/*
 * Decompiled with CFR 0.152.
 */
package phex.utils;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TimerTask;
import phex.common.Environment;
import phex.utils.DirectByteBuffer;
import phex.utils.NLogger;

public class DirectByteBufferProvider {
    private static final DirectByteBufferProvider instance = new DirectByteBufferProvider();
    private Map sizeToBufferListMap = new LinkedHashMap();
    private static final long MAX_TOTAL_BUFFER_SIZE = 0xA00000L;

    private DirectByteBufferProvider() {
        Environment.getInstance().scheduleTimerTask(new CleanupCheckerTask(), 600000L, 600000L);
    }

    public static DirectByteBuffer requestBuffer(int n) {
        return instance.requestDirectByteBuffer(n);
    }

    protected synchronized void releaseDirectByteBuffer(DirectByteBuffer directByteBuffer) {
        ByteBuffer byteBuffer = directByteBuffer.getInternalBuffer();
        int n = (int)Math.ceil((double)byteBuffer.capacity() / 1024.0);
        Integer n2 = new Integer(n);
        ArrayList<DirectByteBuffer> arrayList = (ArrayList<DirectByteBuffer>)this.sizeToBufferListMap.get(n2);
        if (arrayList == null) {
            arrayList = new ArrayList<DirectByteBuffer>();
            this.sizeToBufferListMap.put(n2, arrayList);
        }
        arrayList.add(directByteBuffer);
    }

    private synchronized DirectByteBuffer requestDirectByteBuffer(int n) {
        DirectByteBuffer directByteBuffer;
        int n2 = (int)Math.ceil((double)n / 1024.0);
        Integer n3 = new Integer(n2);
        ArrayList arrayList = (ArrayList)this.sizeToBufferListMap.get(n3);
        if (arrayList == null) {
            arrayList = new ArrayList();
            this.sizeToBufferListMap.put(n3, arrayList);
        }
        if (arrayList.isEmpty()) {
            directByteBuffer = this.allocateDirectByteBuffer(n2 * 1024);
        } else {
            directByteBuffer = (DirectByteBuffer)arrayList.get(arrayList.size() - 1);
            arrayList.remove(directByteBuffer);
        }
        ByteBuffer byteBuffer = directByteBuffer.getInternalBuffer();
        byteBuffer.clear();
        byteBuffer.limit(n);
        return directByteBuffer;
    }

    private DirectByteBuffer allocateDirectByteBuffer(int n) {
        ByteBuffer byteBuffer;
        try {
            byteBuffer = ByteBuffer.allocateDirect(n);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.clearBuffers();
            System.runFinalization();
            System.gc();
            Thread.yield();
            try {
                byteBuffer = ByteBuffer.allocateDirect(n);
            }
            catch (OutOfMemoryError outOfMemoryError2) {
                NLogger.error("GLOBAL", "Out of memory while trying to allocated direct byte buffer.");
                throw outOfMemoryError2;
            }
        }
        DirectByteBuffer directByteBuffer = new DirectByteBuffer(byteBuffer, this);
        return directByteBuffer;
    }

    private synchronized void clearBuffers() {
        Iterator iterator = this.sizeToBufferListMap.values().iterator();
        while (iterator.hasNext()) {
            List list = (List)iterator.next();
            list.clear();
        }
    }

    private synchronized void cleanupChecker() {
        long l = 0L;
        Iterator iterator = this.sizeToBufferListMap.keySet().iterator();
        while (iterator.hasNext()) {
            Integer n = (Integer)iterator.next();
            ArrayList arrayList = (ArrayList)this.sizeToBufferListMap.get(n);
            l += (long)(n * arrayList.size() * 1024);
        }
        if (l > 0xA00000L) {
            this.performCleanup(l - 0xA00000L);
        }
    }

    private synchronized void performCleanup(long l) {
        int n = this.sizeToBufferListMap.size();
        int n2 = 0;
        int[] nArray = new int[n];
        List[] listArray = new List[n];
        int n3 = 0;
        Iterator iterator = this.sizeToBufferListMap.keySet().iterator();
        while (iterator.hasNext()) {
            Integer n4 = (Integer)iterator.next();
            List list = (List)this.sizeToBufferListMap.get(n4);
            nArray[n3] = n4 * 1024;
            listArray[n3] = list;
            int n5 = list.size();
            if (n5 > n2) {
                n2 = n5;
            }
            ++n3;
        }
        long l2 = 0L;
        while (l2 < l && n2 > 0) {
            for (n3 = 0; n3 < n; ++n3) {
                if (listArray[n3].size() != n2) continue;
                listArray[n3].remove(listArray[n3].size() - 1);
                l2 += (long)nArray[n3];
            }
            --n2;
        }
    }

    private class CleanupCheckerTask
    extends TimerTask {
        private static final int TIMER_PERIOD = 600000;

        private CleanupCheckerTask() {
        }

        public void run() {
            DirectByteBufferProvider.this.cleanupChecker();
        }
    }
}

