/*
 * Decompiled with CFR 0.152.
 */
package phex.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import phex.common.FileHandlingException;
import phex.utils.IOUtil;

public final class FileUtils {
    private static final int BUFFER_LENGTH = 262144;

    private FileUtils() {
    }

    public static String getFileExtension(File file) {
        String string = file.getName();
        return FileUtils.getFileExtension(string);
    }

    public static String getFileExtension(String string) {
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return "";
        }
        return string.substring(n + 1);
    }

    public static String replaceFileExtension(String string, String string2) {
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return string + "." + string2;
        }
        return string.substring(0, n + 1) + string2;
    }

    public static String convertToLocalSystemFilename(String string) {
        string = string.replace('/', '_');
        return string.substring(0, Math.min(255, string.length()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void appendFile(File file, File file2) throws IOException {
        long l = file.length();
        long l2 = file2.length();
        FileInputStream fileInputStream = new FileInputStream(file2);
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
            try {
                int n;
                randomAccessFile.setLength(l + l2);
                randomAccessFile.seek(l);
                byte[] byArray = new byte[(int)Math.min(262144L, l2)];
                while (-1 != (n = fileInputStream.read(byArray))) {
                    long l3 = System.currentTimeMillis();
                    randomAccessFile.write(byArray, 0, n);
                    long l4 = System.currentTimeMillis();
                    try {
                        Thread.sleep((l4 - l3) * 2L);
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                        randomAccessFile.close();
                        IOUtil.closeQuietly(randomAccessFile);
                        IOUtil.closeQuietly(fileInputStream);
                        return;
                    }
                }
            }
            finally {
                randomAccessFile.close();
                IOUtil.closeQuietly(randomAccessFile);
            }
        }
        finally {
            IOUtil.closeQuietly(fileInputStream);
        }
        boolean bl = file2.delete();
        if (!bl) {
            file2.deleteOnExit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File file, File file2) throws IOException {
        Object object;
        if (!file.exists()) {
            String string = "File " + file + " does not exist";
            throw new FileNotFoundException(string);
        }
        if (file2.getParentFile() != null && !file2.getParentFile().exists()) {
            file2.getParentFile().mkdirs();
        }
        if (file2.exists() && !file2.canWrite()) {
            String string = "Unable to open file " + file2 + " for writing.";
            throw new IOException(string);
        }
        if (file.getCanonicalPath().equals(file2.getCanonicalPath())) {
            String string = "Unable to write file " + file + " on itself.";
            throw new IOException(string);
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            object = new FileOutputStream(file2);
            try {
                byte[] byArray = new byte[(int)Math.min(262144L, file.length() + 1L)];
                int n = 0;
                while (-1 != (n = fileInputStream.read(byArray))) {
                    ((FileOutputStream)object).write(byArray, 0, n);
                }
            }
            finally {
                IOUtil.closeQuietly((OutputStream)object);
            }
        }
        finally {
            IOUtil.closeQuietly(fileInputStream);
        }
        if (file.length() != file2.length()) {
            object = "Failed to copy full contents from " + file + " to " + file2;
            throw new IOException((String)object);
        }
        file2.setLastModified(file.lastModified());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void splitFile(File file, File file2, long l) throws IOException {
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            try {
                int n;
                randomAccessFile.seek(l);
                byte[] byArray = new byte[(int)Math.min(262144L, file.length() + 1L)];
                while (-1 != (n = randomAccessFile.read(byArray))) {
                    fileOutputStream.write(byArray, 0, n);
                }
                randomAccessFile.setLength(l);
            }
            finally {
                IOUtil.closeQuietly(fileOutputStream);
            }
        }
        finally {
            IOUtil.closeQuietly(randomAccessFile);
        }
    }

    public static void renameLocalFile(File file, File file2) throws FileHandlingException {
        if (file2.exists()) {
            throw new FileHandlingException(1);
        }
        if (file.exists() && !file.renameTo(file2)) {
            throw new FileHandlingException(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void truncateFile(File file, long l) throws IOException {
        if (l < 0L) {
            throw new IllegalArgumentException("File size < 0: " + l);
        }
        if (file.exists() && file.length() > l) {
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
            try {
                randomAccessFile.setLength(l);
            }
            finally {
                IOUtil.closeQuietly(randomAccessFile);
            }
        }
    }

    public static boolean isChildOfDir(File file, File file2) {
        if (!file.getAbsolutePath().startsWith(file2.getAbsolutePath())) {
            return false;
        }
        return FileUtils.isChildOfDirInternal(file, file2);
    }

    private static boolean isChildOfDirInternal(File file, File file2) {
        File file3 = file.getParentFile();
        if (file3 == null) {
            return false;
        }
        if (file3.equals(file2)) {
            return true;
        }
        return FileUtils.isChildOfDirInternal(file3, file2);
    }
}

