/*
 * Decompiled with CFR 0.152.
 */
package phex.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.Writer;
import java.net.InetAddress;
import java.net.Socket;
import java.util.zip.DataFormatException;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import phex.utils.Logger;

public class IOUtil {
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];

    public static int serializeIntLE(int n, byte[] byArray, int n2) {
        byArray[n2++] = (byte)n;
        byArray[n2++] = (byte)(n >> 8);
        byArray[n2++] = (byte)(n >> 16);
        byArray[n2++] = (byte)(n >> 24);
        return n2;
    }

    public static void serializeIntLE(int n, OutputStream outputStream) throws IOException {
        outputStream.write((byte)n);
        outputStream.write((byte)(n >> 8));
        outputStream.write((byte)(n >> 16));
        outputStream.write((byte)(n >> 24));
    }

    public static int deserializeIntLE(byte[] byArray, int n) {
        return byArray[n + 3] << 24 | (byArray[n + 2] & 0xFF) << 16 | (byArray[n + 1] & 0xFF) << 8 | byArray[n] & 0xFF;
    }

    public static int deserializeIntLE(byte[] byArray, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        switch (n2) {
            case 4: {
                n3 = byArray[n + 3] << 24;
            }
            case 3: {
                n4 = (byArray[n + 2] & 0xFF) << 16;
            }
            case 2: {
                n5 = (byArray[n + 1] & 0xFF) << 8;
            }
            case 1: {
                n6 = byArray[n] & 0xFF;
                break;
            }
            default: {
                throw new IllegalArgumentException("Wrong length");
            }
        }
        return n3 | n4 | n5 | n6;
    }

    public static byte[] serializeInt2MinLE(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Negative input value");
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4);
        do {
            byteArrayOutputStream.write(n & 0xFF);
        } while ((n >>= 8) != 0);
        return byteArrayOutputStream.toByteArray();
    }

    public static int deserializeInt(byte[] byArray, int n) {
        return byArray[n] << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF;
    }

    public static int serializeShortLE(short s, byte[] byArray, int n) {
        byArray[n++] = (byte)s;
        byArray[n++] = (byte)(s >> 8);
        return n;
    }

    public static void serializeShortLE(short s, OutputStream outputStream) throws IOException {
        outputStream.write((byte)(s & 0xFF));
        outputStream.write((byte)(s >> 8 & 0xFF));
    }

    public static short deserializeShortLE(byte[] byArray, int n) {
        return (short)((byArray[n + 1] & 0xFF) << 8 | byArray[n] & 0xFF);
    }

    public static short deserializeShortLE(InputStream inputStream) throws IOException {
        int n = inputStream.read() & 0xFF;
        int n2 = (inputStream.read() & 0xFF) << 8;
        return (short)(n2 | n);
    }

    public static int serializeShort(short s, byte[] byArray, int n) {
        byArray[n++] = (byte)(s >> 8);
        byArray[n++] = (byte)s;
        return n;
    }

    public static short deserializeShort(byte[] byArray, int n) {
        return (short)((byArray[n] & 0xFF) << 8 | byArray[n + 1] & 0xFF);
    }

    public static int unsignedByte2int(byte by) {
        return by & 0xFF;
    }

    public static int unsignedShort2Int(short s) {
        return s & 0xFFFF;
    }

    public static long unsignedInt2Long(int n) {
        return (long)n & 0xFFFFFFFFL;
    }

    public static int serializeString(String string, byte[] byArray, int n) {
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            byArray[n] = (byte)cArray[i];
            ++n;
        }
        return n;
    }

    public static int deserializeString(byte[] byArray, int n, StringBuffer stringBuffer) {
        int n2 = n;
        int n3 = byArray.length;
        while (n < n3 && byArray[n] != 0) {
            ++n;
        }
        if (n - n2 > 0) {
            stringBuffer.append(new String(byArray, n2, n - n2));
        }
        return n;
    }

    public static int serializeIP(String string, byte[] byArray, int n) {
        InetAddress inetAddress = null;
        byte[] byArray2 = null;
        try {
            inetAddress = InetAddress.getByName(string);
            byArray2 = inetAddress.getAddress();
        }
        catch (Exception exception) {
            byArray2 = new byte[]{0, 0, 0, 0};
        }
        byArray[n++] = byArray2[0];
        byArray[n++] = byArray2[1];
        byArray[n++] = byArray2[2];
        byArray[n++] = byArray2[3];
        return n;
    }

    public static byte serializeGUESSVersionFormat(int n, int n2) throws IllegalArgumentException {
        if (n < 0 || n >= 16 || n2 < 0 || n2 >= 16) {
            throw new IllegalArgumentException("Version out of range.");
        }
        int n3 = n << 4;
        return (byte)(n3 |= n2);
    }

    public static byte calculateLog2(int n) {
        if (n < 65536) {
            if (n < 256) {
                if (n < 16) {
                    if (n < 4) {
                        if (n < 2) {
                            return 0;
                        }
                        return 1;
                    }
                    if (n < 8) {
                        return 2;
                    }
                    return 3;
                }
                if (n < 64) {
                    if (n < 32) {
                        return 4;
                    }
                    return 5;
                }
                if (n < 128) {
                    return 6;
                }
                return 7;
            }
            if (n < 4096) {
                if (n < 1024) {
                    if (n < 512) {
                        return 8;
                    }
                    return 9;
                }
                if (n < 2048) {
                    return 10;
                }
                return 11;
            }
            if (n < 16384) {
                if (n < 8192) {
                    return 12;
                }
                return 13;
            }
            if (n < 32768) {
                return 14;
            }
            return 15;
        }
        if (n < 0x1000000) {
            if (n < 0x100000) {
                if (n < 262144) {
                    if (n < 131072) {
                        return 16;
                    }
                    return 17;
                }
                if (n < 524288) {
                    return 18;
                }
                return 19;
            }
            if (n < 0x400000) {
                if (n < 0x200000) {
                    return 20;
                }
                return 21;
            }
            if (n < 0x800000) {
                return 22;
            }
            return 23;
        }
        if (n < 0x10000000) {
            if (n < 0x4000000) {
                if (n < 0x2000000) {
                    return 24;
                }
                return 25;
            }
            if (n < 0x8000000) {
                return 26;
            }
            return 27;
        }
        if (n < 0x40000000) {
            if (n < 0x20000000) {
                return 28;
            }
            return 29;
        }
        return 30;
    }

    public static int determineBitCount(int n) {
        if (n < 0) {
            return 32;
        }
        if (n < 65536) {
            if (n < 256) {
                if (n < 16) {
                    if (n < 4) {
                        if (n < 2) {
                            if (n == 0) {
                                return 0;
                            }
                            return 1;
                        }
                        return 2;
                    }
                    if (n < 8) {
                        return 3;
                    }
                    return 4;
                }
                if (n < 64) {
                    if (n < 32) {
                        return 5;
                    }
                    return 6;
                }
                if (n < 128) {
                    return 7;
                }
                return 8;
            }
            if (n < 4096) {
                if (n < 1024) {
                    if (n < 512) {
                        return 9;
                    }
                    return 10;
                }
                if (n < 2048) {
                    return 11;
                }
                return 12;
            }
            if (n < 16384) {
                if (n < 8192) {
                    return 13;
                }
                return 14;
            }
            if (n < 32768) {
                return 15;
            }
            return 16;
        }
        if (n < 0x1000000) {
            if (n < 0x100000) {
                if (n < 262144) {
                    if (n < 131072) {
                        return 17;
                    }
                    return 18;
                }
                if (n < 524288) {
                    return 19;
                }
                return 20;
            }
            if (n < 0x400000) {
                if (n < 0x200000) {
                    return 21;
                }
                return 22;
            }
            if (n < 0x800000) {
                return 23;
            }
            return 24;
        }
        if (n < 0x10000000) {
            if (n < 0x4000000) {
                if (n < 0x2000000) {
                    return 25;
                }
                return 26;
            }
            if (n < 0x8000000) {
                return 27;
            }
            return 28;
        }
        if (n < 0x40000000) {
            if (n < 0x20000000) {
                return 29;
            }
            return 30;
        }
        return 31;
    }

    public static byte[] deflate(byte[] byArray) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream(byteArrayOutputStream);
            deflaterOutputStream.write(byArray, 0, byArray.length);
            deflaterOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            Logger.logError(iOException);
            return null;
        }
    }

    public static byte[] inflate(Inflater inflater, byte[] byArray) throws DataFormatException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        inflater.setInput(byArray);
        byte[] byArray2 = new byte[1024];
        int n = 0;
        do {
            if ((n = inflater.inflate(byArray2)) <= 0) continue;
            byteArrayOutputStream.write(byArray2, 0, n);
        } while (n > 0);
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] inflate(byte[] byArray) throws DataFormatException {
        return IOUtil.inflate(new Inflater(), byArray);
    }

    public static byte[] cobsEncode(byte[] byArray) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
            int n = 1;
            for (int i = 0; i < byArray.length; ++i) {
                if (byArray[i] == 0) {
                    byteArrayOutputStream.write(n);
                    byteArrayOutputStream.write(byteArrayOutputStream2.toByteArray());
                    byteArrayOutputStream2.reset();
                    n = 1;
                    continue;
                }
                byteArrayOutputStream2.write(byArray[i]);
                if (++n != 255) continue;
                byteArrayOutputStream.write(n);
                byteArrayOutputStream.write(byteArrayOutputStream2.toByteArray());
                byteArrayOutputStream2.reset();
                n = 1;
            }
            byteArrayOutputStream.write(n);
            byteArrayOutputStream.write(byteArrayOutputStream2.toByteArray());
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            Logger.logError(iOException);
            return null;
        }
    }

    public static byte[] cobsDecode(byte[] byArray) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            int n = 0;
            int n2 = 0;
            while (n < byArray.length) {
                if (n + ((n2 = IOUtil.unsignedByte2int(byArray[n++])) - 2) >= byArray.length) {
                    throw new IOException("Invalid COBS InputData");
                }
                for (int i = 1; i < n2; ++i) {
                    byteArrayOutputStream.write(byArray[n++]);
                }
                if (n2 >= 255 || n >= byArray.length) continue;
                byteArrayOutputStream.write(0);
            }
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            Logger.logError(iOException);
            return null;
        }
    }

    public static void closeQuietly(OutputStream outputStream) {
        if (outputStream == null) {
            return;
        }
        try {
            outputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeQuietly(Socket socket) {
        if (socket == null) {
            return;
        }
        try {
            socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeQuietly(InputStream inputStream) {
        if (inputStream == null) {
            return;
        }
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeQuietly(Writer writer) {
        if (writer == null) {
            return;
        }
        try {
            writer.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeQuietly(Reader reader) {
        if (reader == null) {
            return;
        }
        try {
            reader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeQuietly(RandomAccessFile randomAccessFile) {
        if (randomAccessFile == null) {
            return;
        }
        try {
            randomAccessFile.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

