/*
 * Decompiled with CFR 0.152.
 */
package phex.utils;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class LengthLimitedInputStream
extends FilterInputStream {
    private long lengthLimit;
    private long lengthRead;
    private boolean closed = false;

    public LengthLimitedInputStream(InputStream inputStream, long l) {
        super(inputStream);
        this.lengthLimit = l;
    }

    public void setLengthLimit(long l) {
        this.lengthLimit = l;
        this.lengthRead = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (!this.closed) {
            try {
                byte[] byArray = new byte[1024];
                while (this.read(byArray) >= 0) {
                }
            }
            finally {
                this.closed = true;
            }
        }
    }

    public int read() throws IOException {
        if (this.closed) {
            throw new IOException("Attempted read from closed stream.");
        }
        if (this.lengthRead >= this.lengthLimit) {
            return -1;
        }
        ++this.lengthRead;
        return super.read();
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.closed) {
            throw new IOException("Attempted read from closed stream.");
        }
        if (this.lengthRead >= this.lengthLimit) {
            return -1;
        }
        if (this.lengthRead + (long)n2 > this.lengthLimit) {
            n2 = (int)(this.lengthLimit - this.lengthRead);
        }
        int n3 = super.read(byArray, n, n2);
        this.lengthRead += (long)n3;
        return n3;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }
}

