/*
 * Decompiled with CFR 0.152.
 */
package phex.utils;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import phex.common.ServiceManager;
import phex.utils.IOUtil;
import phex.utils.Logger;
import phex.utils.NLogger;

public class Localizer {
    private static Map langKeyMap;
    private static Locale usedLocale;
    private static List availableLocales;

    public static void initialize() {
        Locale locale;
        Localizer.setUsedLocale(Locale.US);
        String string = ServiceManager.sCfg.usedLocale;
        if (string == null || string.length() == 0 || string.length() != 2 && string.length() != 5) {
            locale = Locale.US;
        } else {
            String string2 = string.substring(0, 2);
            String string3 = "";
            if (string.length() == 5) {
                string3 = string.substring(3, 5);
            }
            locale = new Locale(string2, string3);
        }
        Localizer.setUsedLocale(locale);
    }

    public static void setUsedLocale(Locale locale) {
        usedLocale = locale;
        Localizer.buildResourceBundle(locale);
    }

    public static Locale getUsedLocale() {
        return usedLocale;
    }

    private static void buildResourceBundle(Locale locale) {
        Object object;
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuffer stringBuffer = new StringBuffer("Lang");
        arrayList.add(stringBuffer.toString());
        String string = locale.getLanguage();
        if (string.length() > 0) {
            stringBuffer.append('_');
            stringBuffer.append(string);
            arrayList.add(stringBuffer.toString());
            object = locale.getCountry();
            if (((String)object).length() > 0) {
                stringBuffer.append('_');
                stringBuffer.append((String)object);
                arrayList.add(stringBuffer.toString());
            }
        }
        langKeyMap = new HashMap();
        object = new HashMap();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            String string2 = "/phex/resources/" + (String)arrayList.get(i) + ".properties";
            object = Localizer.loadProperties(string2);
            if (object != null) {
                langKeyMap.putAll(object);
                Logger.logMessage(Logger.FINEST, (short)255, (String)null, new String[]{"Loaded language map: " + string2 + "."});
            }
            if ((object = Localizer.loadProperties(string2 = "/" + (String)arrayList.get(i) + ".properties")) == null) continue;
            langKeyMap.putAll(object);
            Logger.logMessage(Logger.FINEST, (short)255, (String)null, new String[]{"Loaded language map: " + string2 + "."});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HashMap loadProperties(String string) {
        InputStream inputStream = Localizer.class.getResourceAsStream(string);
        if (inputStream == null) {
            return null;
        }
        inputStream = new BufferedInputStream(inputStream);
        Properties properties = new Properties();
        try {
            properties.load(inputStream);
            HashMap<Object, Object> hashMap = new HashMap<Object, Object>(properties);
            return hashMap;
        }
        catch (IOException iOException) {
        }
        finally {
            IOUtil.closeQuietly(inputStream);
        }
        return null;
    }

    public static List getAvailableLocales() {
        if (availableLocales != null) {
            return availableLocales;
        }
        availableLocales = new ArrayList();
        List list = Localizer.loadLocalList("/language.list");
        availableLocales.addAll(list);
        list = Localizer.loadLocalList("/phex/resources/language.list");
        availableLocales.addAll(list);
        return availableLocales;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List loadLocalList(String string) {
        InputStream inputStream = Localizer.class.getResourceAsStream(string);
        if (inputStream == null) {
            return Collections.EMPTY_LIST;
        }
        try {
            Object object;
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "ISO-8859-1"));
            ArrayList<Locale> arrayList = new ArrayList<Locale>();
            while ((string2 = bufferedReader.readLine()) != null) {
                if ((string2 = string2.trim()).startsWith("#") || string2.length() != 2 && string2.length() != 5) continue;
                object = string2.substring(0, 2);
                String string3 = "";
                if (string2.length() == 5) {
                    string3 = string2.substring(3, 5);
                }
                Locale locale = new Locale((String)object, string3);
                arrayList.add(locale);
            }
            object = arrayList;
            return object;
        }
        catch (IOException iOException) {
            Logger.logError(iOException);
        }
        finally {
            IOUtil.closeQuietly(inputStream);
        }
        return Collections.EMPTY_LIST;
    }

    public static String getString(String string) {
        String string2 = (String)langKeyMap.get(string);
        if (string2 == null) {
            NLogger.error("LOCALIZATION", "Missing language key: " + string);
            string2 = string;
        }
        return string2;
    }

    public static char getChar(String string) {
        String string2 = Localizer.getString(string);
        return string2.charAt(0);
    }

    public static String getFormatedString(String string, Object[] objectArray) {
        String string2 = null;
        String string3 = (String)langKeyMap.get(string);
        if (string3 != null) {
            string2 = MessageFormat.format(string3, objectArray);
        } else {
            Logger.logMessage(Logger.INFO, (short)255, (String)null, new String[]{"Missing language key: " + string});
            string2 = string;
        }
        return string2;
    }
}

