/*
 * Decompiled with CFR 0.152.
 */
package phex.utils;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.logging.Log;
import phex.common.Environment;

public class PhexLogger
implements Log {
    public static final LogLevel DEBUG = new LogLevel(0);
    public static final LogLevel INFO = new LogLevel(1);
    public static final LogLevel WARN = new LogLevel(2);
    public static final LogLevel ERROR = new LogLevel(3);
    private static String[] verboseLevelName = new String[]{"Debug", "Info", "Warn", "Error"};
    private static short logLevelValue = PhexLogger.ERROR.value;
    private static boolean logToConsole = false;
    private static File logFile;
    private static File errorLogFile;
    private static PrintWriter logWriter;
    private static DateFormat dateFormat;
    private static Date date;
    private static long maxLogFileLength;

    public PhexLogger() {
    }

    public PhexLogger(String string) {
    }

    public boolean isDebugEnabled() {
        return PhexLogger.isLevelLogged(DEBUG);
    }

    public boolean isErrorEnabled() {
        return PhexLogger.isLevelLogged(ERROR);
    }

    public boolean isFatalEnabled() {
        return PhexLogger.isLevelLogged(ERROR);
    }

    public boolean isInfoEnabled() {
        return PhexLogger.isLevelLogged(INFO);
    }

    public boolean isTraceEnabled() {
        return PhexLogger.isLevelLogged(DEBUG);
    }

    public boolean isWarnEnabled() {
        return PhexLogger.isLevelLogged(WARN);
    }

    public void trace(Object object) {
        this.debug(object);
    }

    public void trace(Object object, Throwable throwable) {
        this.debug(object, throwable);
    }

    public void debug(Object object) {
        if (PhexLogger.isLevelLogged(DEBUG)) {
            this.writeLogMessage(DEBUG, object, null);
        }
    }

    public void debug(Object object, Throwable throwable) {
        if (PhexLogger.isLevelLogged(DEBUG)) {
            this.writeLogMessage(DEBUG, object, throwable);
        }
    }

    public void info(Object object) {
        if (PhexLogger.isLevelLogged(INFO)) {
            this.writeLogMessage(INFO, object, null);
        }
    }

    public void info(Object object, Throwable throwable) {
        if (PhexLogger.isLevelLogged(INFO)) {
            this.writeLogMessage(INFO, object, throwable);
        }
    }

    public void warn(Object object) {
        if (PhexLogger.isLevelLogged(WARN)) {
            this.writeLogMessage(WARN, object, null);
        }
    }

    public void warn(Object object, Throwable throwable) {
        if (PhexLogger.isLevelLogged(WARN)) {
            this.writeLogMessage(WARN, object, throwable);
        }
    }

    public void error(Object object) {
        if (PhexLogger.isLevelLogged(ERROR)) {
            this.writeLogMessage(ERROR, object, null);
        }
    }

    public void error(Object object, Throwable throwable) {
        if (PhexLogger.isLevelLogged(ERROR)) {
            this.writeLogMessage(ERROR, object, throwable);
        }
    }

    public void fatal(Object object) {
        this.error(object);
    }

    public void fatal(Object object, Throwable throwable) {
        this.error(object, throwable);
    }

    private static boolean isLevelLogged(LogLevel logLevel) {
        return logLevelValue <= logLevel.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeLogMessage(LogLevel logLevel, Object object, Throwable throwable) {
        String string = object != null ? object.toString() : "";
        StringBuffer stringBuffer = new StringBuffer(40 + string.length());
        stringBuffer.append(PhexLogger.getTimeString());
        stringBuffer.append(":");
        stringBuffer.append(PhexLogger.getLogLevelName(logLevel));
        stringBuffer.append(": ");
        stringBuffer.append(object);
        if (logToConsole) {
            if (logLevel.value >= PhexLogger.ERROR.value) {
                System.err.println(stringBuffer.toString());
            } else {
                System.out.println(stringBuffer.toString());
            }
        }
        PhexLogger.initLogFileWriter();
        PrintWriter printWriter = logWriter;
        synchronized (printWriter) {
            Object object2;
            logWriter.println(stringBuffer.toString());
            if (logFile != null && logFile.length() > maxLogFileLength) {
                if (logWriter != null) {
                    logWriter.close();
                }
                logWriter = null;
                object2 = new File(logFile.getAbsolutePath() + ".1");
                ((File)object2).delete();
                logFile.renameTo((File)object2);
            }
            if (logLevel.value >= PhexLogger.ERROR.value) {
                try {
                    object2 = new PrintWriter((Writer)new BufferedWriter(new FileWriter(errorLogFile.getPath(), true)), true);
                    ((PrintWriter)object2).println(stringBuffer.toString());
                    ((PrintWriter)object2).close();
                    if (errorLogFile != null && errorLogFile.length() > maxLogFileLength) {
                        File file = new File(errorLogFile.getAbsolutePath() + ".1");
                        file.delete();
                        errorLogFile.renameTo(file);
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    private static String getTimeString() {
        if (dateFormat == null) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyMMdd HH:mm:ss,SSSS");
            dateFormat = simpleDateFormat;
        }
        if (date == null) {
            date = new Date(System.currentTimeMillis());
        } else {
            date.setTime(System.currentTimeMillis());
        }
        return dateFormat.format(date);
    }

    private static String getLogLevelName(LogLevel logLevel) {
        if (logLevel.value >= 0 && logLevel.value < verboseLevelName.length) {
            return verboseLevelName[logLevel.value];
        }
        return "Unknwon (" + logLevel.value + ')';
    }

    public static void setLogToConsole(boolean bl) {
        logToConsole = bl;
    }

    public static void setMaxLogFileLength(long l) {
        maxLogFileLength = l;
    }

    public static void setVerboseLevel(short s) {
        if (s >= PhexLogger.DEBUG.value && s <= PhexLogger.ERROR.value) {
            logLevelValue = s;
        }
    }

    public static void setLogFile(File file) {
        logFile = file;
        logWriter = null;
    }

    public static void setErrorLogFile(File file) {
        errorLogFile = file;
    }

    private static synchronized void initLogFileWriter() {
        if (logWriter != null) {
            return;
        }
        if (logFile != null) {
            logFile.getParentFile().mkdirs();
            try {
                logWriter = new PrintWriter((Writer)new BufferedWriter(new FileWriter(logFile.getPath(), true)), true);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        } else {
            logToConsole = false;
            logWriter = new PrintWriter(System.out, true);
        }
        if (errorLogFile != null) {
            errorLogFile.getParentFile().mkdirs();
        }
    }

    static {
        String string = System.getProperty("phex.utils.logger.logFile", "phex.log");
        PhexLogger.setLogFile(Environment.getInstance().getPhexConfigFile(string));
        String string2 = System.getProperty("phex.utils.logger.errorLogFile", "phex.error.log");
        PhexLogger.setErrorLogFile(Environment.getInstance().getPhexConfigFile(string2));
        String string3 = System.getProperty("phex.utils.logger.console", "false");
        PhexLogger.setLogToConsole("true".equalsIgnoreCase(string3));
        String string4 = System.getProperty("phex.utils.logger.level", "3");
        try {
            PhexLogger.setVerboseLevel(Short.parseShort(string4));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        String string5 = System.getProperty("phex.utils.logger.maxFileSize", "524288");
        try {
            PhexLogger.setMaxLogFileLength(Long.parseLong(string5));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private static final class LogLevel {
        public final short value;

        public LogLevel(short s) {
            this.value = s;
        }
    }
}

