/*
 * Decompiled with CFR 0.152.
 */
package phex.utils;

import java.util.Iterator;
import java.util.NoSuchElementException;
import phex.utils.CircularQueue;
import phex.utils.CompoundIterator;

public class PriorityQueue {
    private CircularQueue[] queues;
    private int size;

    public PriorityQueue(int[] nArray) {
        this.queues = new CircularQueue[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            this.queues[i] = new CircularQueue((int)Math.ceil((double)nArray[i] / 4.0), nArray[i]);
        }
    }

    public Object addToHead(Object object, int n) {
        if (n < 0 || n >= this.queues.length) {
            throw new IllegalArgumentException("Priority out of range: " + n);
        }
        Object object2 = this.queues[n].addToHead(object);
        if (object2 == null) {
            ++this.size;
        }
        return object2;
    }

    public Object removeMaxPriority() throws NoSuchElementException {
        for (int i = this.queues.length - 1; i >= 0; --i) {
            if (this.queues[i].isEmpty()) continue;
            --this.size;
            return this.queues[i].removeFromHead();
        }
        throw new NoSuchElementException("PriorityQueue is empty");
    }

    public int getSize() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean isFull(int n) {
        return this.queues[n].isFull();
    }

    public void clear() {
        for (int i = 0; i < this.queues.length; ++i) {
            this.queues[i].clear();
        }
        this.size = 0;
    }

    public Iterator iterator() {
        CompoundIterator compoundIterator = new CompoundIterator(this.queues.length);
        for (int i = this.queues.length - 1; i >= 0; --i) {
            if (this.queues[i].getSize() <= 0) continue;
            compoundIterator.addIterator(this.queues[i].iterator());
        }
        return compoundIterator;
    }
}

