/*
 * Decompiled with CFR 0.152.
 */
package phex.utils;

import java.util.HashMap;
import phex.utils.Logger;

public class ReadWriteLock {
    private static final long MAX_WAIT_TIME = 300000L;
    private Thread writeLockOwner;
    private Integer writeLockerHadReadLockCount = null;
    private HashMap readLockOwners = new HashMap(10);

    public synchronized void readLock() {
        Thread thread = Thread.currentThread();
        if (this.writeLockOwner == thread) {
            return;
        }
        Integer n = (Integer)this.readLockOwners.get(thread);
        if (n != null) {
            this.readLockOwners.put(thread, new Integer(n + 1));
            return;
        }
        boolean bl = false;
        while (this.writeLockOwner != null) {
            try {
                long l = System.currentTimeMillis();
                this.wait(300000L);
                long l2 = System.currentTimeMillis();
                if (l2 < l + 300000L) continue;
                Logger.logError((short)255, "Waited too long to aquire read lock.");
                throw new RuntimeException("Waited too long to aquire read lock.");
            }
            catch (InterruptedException interruptedException) {
                bl = true;
            }
        }
        this.readLockOwners.put(thread, new Integer(1));
        if (bl) {
            thread.interrupt();
        }
    }

    public synchronized void readUnlock() throws IllegalAccessException {
        Thread thread = Thread.currentThread();
        if (this.writeLockOwner == thread) {
            return;
        }
        Integer n = (Integer)this.readLockOwners.remove(thread);
        if (n == null) {
            throw new IllegalAccessException("Thread without holding read lock trys to unlock.");
        }
        int n2 = n - 1;
        if (n2 > 0) {
            this.readLockOwners.put(thread, new Integer(n2));
        } else if (this.readLockOwners.size() == 0) {
            this.notifyAll();
        }
    }

    public synchronized void writeLock() {
        Integer n;
        Thread thread = Thread.currentThread();
        if (this.writeLockOwner == thread) {
            return;
        }
        boolean bl = false;
        while (this.writeLockOwner != null) {
            try {
                long l = System.currentTimeMillis();
                this.wait(300000L);
                long l2 = System.currentTimeMillis();
                if (l2 < l + 300000L) continue;
                Logger.logError((short)255, "Waited too long to aquire write lock.");
                throw new RuntimeException("Waited too long to aquire write lock.");
            }
            catch (InterruptedException interruptedException) {
                bl = true;
            }
        }
        this.writeLockOwner = thread;
        this.writeLockerHadReadLockCount = n = (Integer)this.readLockOwners.remove(thread);
        while (this.readLockOwners.size() > 0) {
            try {
                long l = System.currentTimeMillis();
                this.wait(300000L);
                long l3 = System.currentTimeMillis();
                if (l3 < l + 300000L) continue;
                Logger.logError((short)255, "Waited too long to ensure write lock.");
                throw new RuntimeException("Waited too long to ensure write lock.");
            }
            catch (InterruptedException interruptedException) {
                bl = true;
            }
        }
        if (bl) {
            thread.interrupt();
        }
    }

    public synchronized void writeUnlock() throws IllegalAccessException {
        Thread thread = Thread.currentThread();
        if (this.writeLockOwner != thread) {
            throw new IllegalAccessException("Current thread not owner of write lock.");
        }
        this.writeLockOwner = null;
        if (this.writeLockerHadReadLockCount != null) {
            this.readLockOwners.put(thread, this.writeLockerHadReadLockCount);
        }
        this.notifyAll();
    }
}

