/*
 * Decompiled with CFR 0.152.
 */
package phex.utils;

import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.util.StringTokenizer;
import phex.common.Cfg;
import phex.utils.Localizer;

public final class StrUtil {
    public static final String FILE_DELIMITERS = " -._+/*()[]\\";
    public static final long ONE_KB = 1024L;
    public static final long ONE_MB = 0x100000L;
    public static final long ONE_GB = 0x40000000L;
    public static final long ONE_TB = 0x10000000000L;
    public static DecimalFormat byteFormat = new DecimalFormat("0.00");
    public static NumberFormat FILE_LENGTH_FORMAT = NumberFormat.getInstance();

    public static boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    public static String formatSignificantElapsedTime(long l) {
        long l2 = l / 86400L;
        if (l2 > 0L) {
            Object[] objectArray = new Object[]{new Long(l2), new Integer((int)(l / 3600L % 24L))};
            return Localizer.getFormatedString("TimeFormatDH", objectArray);
        }
        int n = (int)(l / 3600L % 24L);
        if (n > 0) {
            Object[] objectArray = new Object[]{new Integer(n), new Integer((int)(l / 60L % 60L))};
            return Localizer.getFormatedString("TimeFormatHM", objectArray);
        }
        int n2 = (int)(l / 60L % 60L);
        if (n2 > 0) {
            Object[] objectArray = new Object[]{new Integer(n2), new Integer((int)(l % 60L))};
            return Localizer.getFormatedString("TimeFormatMS", objectArray);
        }
        int n3 = (int)(l % 60L);
        Object[] objectArray = new Object[]{new Integer(n3)};
        return Localizer.getFormatedString("TimeFormatS", objectArray);
    }

    public static String convertSecondsToTime(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = n / 86400;
        int n3 = n / 3600 % 24;
        int n4 = n / 60 % 60;
        int n5 = n % 60;
        if (n2 > 0) {
            stringBuffer.append(Integer.toString(n2));
            stringBuffer.append(":");
            if (n3 < 10) {
                stringBuffer.append("0");
            }
        }
        if (n2 > 0 || n3 > 0) {
            stringBuffer.append(Integer.toString(n3));
            stringBuffer.append(":");
            if (n4 < 10) {
                stringBuffer.append("0");
            }
        }
        stringBuffer.append(Integer.toString(n4));
        stringBuffer.append(":");
        if (n5 < 10) {
            stringBuffer.append("0");
        }
        stringBuffer.append(Integer.toString(n5));
        return stringBuffer.toString();
    }

    public static String formatSizeBytes(double d) {
        double d2;
        String string;
        StringBuffer stringBuffer = new StringBuffer(16);
        if (d < 1024.0) {
            string = "bytes";
            d2 = 1.0;
        } else if (d < 1048576.0) {
            string = "KB";
            d2 = 1024.0;
        } else if (d < 1.073741824E9) {
            string = "MB";
            d2 = 1048576.0;
        } else if (d < 1.099511627776E12) {
            string = "GB";
            d2 = 1.073741824E9;
        } else {
            string = "TB";
            d2 = 1.099511627776E12;
        }
        double d3 = d / d2;
        byteFormat.format(d3, stringBuffer, new FieldPosition(0)).append(' ').append(string);
        return stringBuffer.toString();
    }

    public static String formatSizeBytes(Number number) {
        return StrUtil.formatSizeBytes(number.doubleValue());
    }

    public static String createNaturalSearchTerm(String string) {
        StringTokenizer stringTokenizer;
        int n;
        int n2 = string.lastIndexOf(".");
        if (n2 >= 0) {
            string = string.substring(0, n2);
        }
        if ((n = (stringTokenizer = new StringTokenizer(string, ",-._()[]")).countTokens()) == 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (string2.length() < Cfg.MIN_SEARCH_TERM_LENGTH) continue;
            stringBuffer.append(string2);
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    public static String join(Object[] objectArray, String string) {
        int n;
        if (objectArray == null) {
            return null;
        }
        if (string == null) {
            string = "";
        }
        int n2 = (n = objectArray.length) == 0 ? 0 : n * ((objectArray[0] == null ? 16 : objectArray[0].toString().length()) + string.length());
        StringBuffer stringBuffer = new StringBuffer(n2);
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuffer.append(string);
            }
            if (objectArray[i] == null) continue;
            stringBuffer.append(objectArray[i]);
        }
        return stringBuffer.toString();
    }

    public static String replace(String string, String string2, String string3, int n) {
        if (string == null || StrUtil.isEmpty(string2) || string3 == null || n == 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n2 = 0;
        int n3 = 0;
        while ((n3 = string.indexOf(string2, n2)) != -1) {
            stringBuffer.append(string.substring(n2, n3)).append(string3);
            n2 = n3 + string2.length();
            if (--n != 0) continue;
        }
        stringBuffer.append(string.substring(n2));
        return stringBuffer.toString();
    }
}

