/*
 * Decompiled with CFR 0.152.
 */
package phex.utils;

import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import phex.common.URN;
import phex.download.RemoteFile;
import phex.host.HostAddress;
import phex.utils.URLCodecUtils;

public class URLUtil {
    public static String buildBitziLookupURL(URN uRN) {
        String string = "http://bitzi.com/lookup/" + uRN.getNamespaceSpecificString() + "?detail&ref=phex";
        return string;
    }

    public static String buildMagnetURL(String string, String string2) {
        String string3 = "magnet:?xt=urn:sha1:" + string + "&dn=" + URLCodecUtils.encodeURL(string2);
        return string3;
    }

    public static String buildFileURL(RemoteFile remoteFile) {
        return "http://" + remoteFile.getHostAddress().getFullHostName() + "/get/" + remoteFile.getFileIndex() + "/" + URLCodecUtils.encodeURL(remoteFile.getFilename());
    }

    public static String buildName2ResourceURL(URN uRN) {
        return "/uri-res/N2R?" + uRN.getAsString();
    }

    public static String buildFullName2ResourceURL(HostAddress hostAddress, URN uRN) {
        return URLUtil.buildHostURL(hostAddress) + "/uri-res/N2R?" + uRN.getAsString();
    }

    public static String buildHostURL(HostAddress hostAddress) {
        return "http://" + hostAddress.getFullHostName();
    }

    public static String getFileNameFromUri(URI uRI) throws URIException {
        String string = uRI.getPath();
        int n = string.lastIndexOf("/");
        int n2 = string.length();
        return n >= 0 ? string.substring(n + 1, n2) : string;
    }

    public static String getPathQueryFromUri(URI uRI) throws URIException {
        String string = uRI.getPath();
        String string2 = uRI.getQuery();
        if (string2 != null && string2.length() > 0) {
            return string + "?" + string2;
        }
        return string;
    }
}

