/*
 * Decompiled with CFR 0.152.
 */
package phex.xml;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import phex.utils.IOUtil;
import phex.utils.Logger;
import phex.xml.XJBPhex;

public class XMLBuilder {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XJBPhex loadXJBPhexFromFile(File file) throws JAXBException {
        XJBPhex xJBPhex;
        if (!file.exists()) {
            return null;
        }
        FileInputStream fileInputStream = null;
        try {
            XJBPhex xJBPhex2;
            fileInputStream = new FileInputStream(file);
            JAXBContext jAXBContext = JAXBContext.newInstance("phex.xml");
            Unmarshaller unmarshaller = jAXBContext.createUnmarshaller();
            xJBPhex = xJBPhex2 = (XJBPhex)unmarshaller.unmarshal(fileInputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            XJBPhex xJBPhex3;
            try {
                Logger.logError(fileNotFoundException);
                xJBPhex3 = null;
            }
            catch (Throwable throwable) {
                IOUtil.closeQuietly(fileInputStream);
                throw throwable;
            }
            IOUtil.closeQuietly(fileInputStream);
            return xJBPhex3;
        }
        IOUtil.closeQuietly(fileInputStream);
        return xJBPhex;
    }

    public static XJBPhex readXJBPhexFromStream(InputStream inputStream) throws JAXBException {
        JAXBContext jAXBContext = JAXBContext.newInstance("phex.xml");
        Unmarshaller unmarshaller = jAXBContext.createUnmarshaller();
        XJBPhex xJBPhex = (XJBPhex)unmarshaller.unmarshal(inputStream);
        return xJBPhex;
    }

    public static byte[] serializeToBytes(XJBPhex xJBPhex) throws JAXBException {
        ByteArrayOutputStream byteArrayOutputStream = null;
        JAXBContext jAXBContext = JAXBContext.newInstance("phex.xml");
        Marshaller marshaller = jAXBContext.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", Boolean.TRUE);
        byteArrayOutputStream = new ByteArrayOutputStream();
        marshaller.marshal((Object)xJBPhex, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void saveToFile(File file, XJBPhex xJBPhex) throws JAXBException {
        BufferedOutputStream bufferedOutputStream = null;
        FileOutputStream fileOutputStream = null;
        FileLock fileLock = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            fileLock = XMLBuilder.lockFile(fileOutputStream.getChannel(), 10L, false);
            JAXBContext jAXBContext = JAXBContext.newInstance("phex.xml");
            Marshaller marshaller = jAXBContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", Boolean.TRUE);
            bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            marshaller.marshal((Object)xJBPhex, bufferedOutputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            try {
                throw new JAXBException(fileNotFoundException);
                catch (IOException iOException) {
                    throw new JAXBException(iOException);
                }
            }
            catch (Throwable throwable) {
                IOUtil.closeQuietly(bufferedOutputStream);
                IOUtil.closeQuietly(fileOutputStream);
                if (fileLock == null) throw throwable;
                try {
                    fileLock.release();
                    throw throwable;
                }
                catch (IOException iOException) {
                    if (iOException instanceof ClosedChannelException) throw throwable;
                    Logger.logError(iOException);
                }
                throw throwable;
            }
        }
        IOUtil.closeQuietly(bufferedOutputStream);
        IOUtil.closeQuietly(fileOutputStream);
        if (fileLock == null) return;
        try {
            fileLock.release();
            return;
        }
        catch (IOException iOException) {
            if (iOException instanceof ClosedChannelException) return;
            Logger.logError(iOException);
            return;
        }
    }

    private static FileLock lockFile(FileChannel fileChannel, long l, boolean bl) throws IOException {
        FileLock fileLock = null;
        int n = 0;
        while (fileLock == null) {
            fileLock = fileChannel.tryLock(0L, l, bl);
            if (fileLock != null) continue;
            if (++n > 10) {
                throw new IOException("Locking file failed.");
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                Thread.interrupted();
            }
        }
        return fileLock;
    }
}

