/*
 * Decompiled with CFR 0.152.
 */
package phex.xml.impl.runtime;

import com.sun.xml.bind.JAXBAssertionError;
import com.sun.xml.bind.unmarshaller.Messages;
import com.sun.xml.bind.unmarshaller.Tracer;
import com.sun.xml.bind.util.AttributesImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.JAXBException;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import phex.xml.impl.runtime.GrammarInfo;
import phex.xml.impl.runtime.SAXUnmarshallerHandler;
import phex.xml.impl.runtime.UnmarshallerImpl;
import phex.xml.impl.runtime.UnmarshallingContext;
import phex.xml.impl.runtime.UnmarshallingEventHandler;

public class SAXUnmarshallerHandlerImpl
implements SAXUnmarshallerHandler,
UnmarshallingContext {
    private boolean isUnmarshalInProgress = true;
    private final GrammarInfo grammarInfo;
    private Object result;
    private UnmarshallingEventHandler[] handlers = new UnmarshallingEventHandler[16];
    private int[] mementos = new int[16];
    private int handlerLen = 0;
    private StringBuffer buffer = new StringBuffer();
    private String[] nsBind = new String[16];
    private int nsLen = 0;
    private int[] idxStack = new int[16];
    private AttributesImpl[] attStack = new AttributesImpl[16];
    private int elementDepth;
    private int stackTop;
    private boolean[] collectText = new boolean[16];
    private Runnable[] patchers = null;
    private int patchersLen = 0;
    private Hashtable idmap = null;
    private Locator locator;
    private final UnmarshallerImpl parent;
    private boolean aborted = false;
    private Tracer tracer;

    public SAXUnmarshallerHandlerImpl(UnmarshallerImpl unmarshallerImpl, GrammarInfo grammarInfo) {
        this.parent = unmarshallerImpl;
        this.grammarInfo = grammarInfo;
        this.startPrefixMapping("", "");
    }

    public GrammarInfo getGrammarInfo() {
        return this.grammarInfo;
    }

    private final boolean shouldCollectText() {
        return this.collectText[this.stackTop];
    }

    public void startDocument() throws SAXException {
        this.result = null;
        this.handlerLen = 0;
        this.patchers = null;
        this.patchersLen = 0;
        this.aborted = false;
        this.isUnmarshalInProgress = true;
        this.stackTop = 0;
        this.elementDepth = 1;
    }

    public void endDocument() throws SAXException {
        this.runPatchers();
        this.isUnmarshalInProgress = false;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (string == null) {
            string = "";
        }
        if (string2 == null || string2.length() == 0) {
            string2 = string3;
        }
        if (string3 == null || string3.length() == 0) {
            string3 = string2;
        }
        if (this.result == null) {
            UnmarshallingEventHandler unmarshallingEventHandler = this.grammarInfo.createUnmarshaller(string, string2, this);
            if (unmarshallingEventHandler == null) {
                throw new SAXParseException(Messages.format("SAXUnmarshallerHandlerImpl.UnexpectedRootElement2", string, string2, this.computeExpectedRootElements()), this.getLocator());
            }
            this.result = unmarshallingEventHandler.owner();
            this.pushContentHandler(unmarshallingEventHandler, 0);
        }
        this.processText(true);
        this.getCurrentHandler().enterElement(string, string2, string3, attributes);
    }

    public final void endElement(String string, String string2, String string3) throws SAXException {
        if (string == null) {
            string = "";
        }
        if (string2 == null || string2.length() == 0) {
            string2 = string3;
        }
        if (string3 == null || string3.length() == 0) {
            string3 = string2;
        }
        this.processText(false);
        this.getCurrentHandler().leaveElement(string, string2, string3);
    }

    public Object getResult() throws UnmarshalException {
        if (this.isUnmarshalInProgress) {
            throw new IllegalStateException();
        }
        if (!this.aborted) {
            return this.result;
        }
        throw new UnmarshalException((String)null);
    }

    public void pushContentHandler(UnmarshallingEventHandler unmarshallingEventHandler, int n) {
        if (this.handlerLen == this.handlers.length) {
            UnmarshallingEventHandler[] unmarshallingEventHandlerArray = new UnmarshallingEventHandler[this.handlerLen * 2];
            int[] nArray = new int[this.handlerLen * 2];
            System.arraycopy(this.handlers, 0, unmarshallingEventHandlerArray, 0, this.handlerLen);
            System.arraycopy(this.mementos, 0, nArray, 0, this.handlerLen);
            this.handlers = unmarshallingEventHandlerArray;
            this.mementos = nArray;
        }
        this.handlers[this.handlerLen] = unmarshallingEventHandler;
        this.mementos[this.handlerLen] = n;
        ++this.handlerLen;
    }

    public void popContentHandler() throws SAXException {
        --this.handlerLen;
        this.handlers[this.handlerLen] = null;
        this.getCurrentHandler().leaveChild(this.mementos[this.handlerLen]);
    }

    public UnmarshallingEventHandler getCurrentHandler() {
        return this.handlers[this.handlerLen - 1];
    }

    protected void consumeText(String string, boolean bl) throws SAXException {
        if (bl && string.trim().length() == 0) {
            return;
        }
        this.getCurrentHandler().text(string);
    }

    private void processText(boolean bl) throws SAXException {
        if (this.shouldCollectText()) {
            this.consumeText(this.buffer.toString(), bl);
        }
        if (this.buffer.length() < 1024) {
            this.buffer.setLength(0);
        } else {
            this.buffer = new StringBuffer();
        }
    }

    public final void characters(char[] cArray, int n, int n2) {
        if (this.shouldCollectText()) {
            this.buffer.append(cArray, n, n2);
        }
    }

    public final void ignorableWhitespace(char[] cArray, int n, int n2) {
        this.characters(cArray, n, n2);
    }

    public void startPrefixMapping(String string, String string2) {
        if (this.nsBind.length == this.nsLen) {
            String[] stringArray = new String[this.nsLen * 2];
            System.arraycopy(this.nsBind, 0, stringArray, 0, this.nsLen);
            this.nsBind = stringArray;
        }
        this.nsBind[this.nsLen++] = string;
        this.nsBind[this.nsLen++] = string2;
    }

    public void endPrefixMapping(String string) {
        this.nsLen -= 2;
    }

    public String resolveNamespacePrefix(String string) {
        if (string.equals("xml")) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        for (int i = this.idxStack[this.stackTop] - 2; i >= 0; i -= 2) {
            if (!string.equals(this.nsBind[i])) continue;
            return this.nsBind[i + 1];
        }
        return null;
    }

    public String[] getNewlyDeclaredPrefixes() {
        return this.getPrefixList(this.idxStack[this.stackTop - 1]);
    }

    public String[] getAllDeclaredPrefixes() {
        return this.getPrefixList(2);
    }

    private String[] getPrefixList(int n) {
        int n2 = (this.idxStack[this.stackTop] - n) / 2;
        String[] stringArray = new String[n2];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = this.nsBind[n + i * 2];
        }
        return stringArray;
    }

    public Iterator getPrefixes(String string) {
        return Collections.unmodifiableList(this.getAllPrefixesInList(string)).iterator();
    }

    private List getAllPrefixesInList(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string.equals("http://www.w3.org/XML/1998/namespace")) {
            arrayList.add("xml");
            return arrayList;
        }
        if (string.equals("http://www.w3.org/2000/xmlns/")) {
            arrayList.add("xmlns");
            return arrayList;
        }
        if (string == null) {
            throw new IllegalArgumentException();
        }
        for (int i = this.nsLen - 2; i >= 0; i -= 2) {
            if (!string.equals(this.nsBind[i + 1]) || !this.getNamespaceURI(this.nsBind[i]).equals(this.nsBind[i + 1])) continue;
            arrayList.add(this.nsBind[i]);
        }
        return arrayList;
    }

    public String getPrefix(String string) {
        if (string.equals("http://www.w3.org/XML/1998/namespace")) {
            return "xml";
        }
        if (string.equals("http://www.w3.org/2000/xmlns/")) {
            return "xmlns";
        }
        if (string == null) {
            throw new IllegalArgumentException();
        }
        for (int i = this.idxStack[this.stackTop] - 2; i >= 0; i -= 2) {
            if (!string.equals(this.nsBind[i + 1]) || !this.getNamespaceURI(this.nsBind[i]).equals(this.nsBind[i + 1])) continue;
            return this.nsBind[i];
        }
        return null;
    }

    public String getNamespaceURI(String string) {
        if (string.equals("xmlns")) {
            return "http://www.w3.org/2000/xmlns/";
        }
        if (string == null) {
            throw new IllegalArgumentException();
        }
        return this.resolveNamespacePrefix(string);
    }

    public void pushAttributes(Attributes attributes, boolean bl) {
        Object object;
        Object object2;
        if (this.attStack.length == this.elementDepth) {
            object2 = new AttributesImpl[this.attStack.length * 2];
            System.arraycopy(this.attStack, 0, object2, 0, this.attStack.length);
            this.attStack = object2;
            int[] nArray = new int[this.idxStack.length * 2];
            System.arraycopy(this.idxStack, 0, nArray, 0, this.idxStack.length);
            this.idxStack = nArray;
            object = new boolean[this.collectText.length * 2];
            System.arraycopy(this.collectText, 0, object, 0, this.collectText.length);
            this.collectText = (boolean[])object;
        }
        ++this.elementDepth;
        ++this.stackTop;
        object2 = this.attStack[this.stackTop];
        if (object2 == null) {
            object2 = new AttributesImpl();
            this.attStack[this.stackTop] = object2;
        } else {
            ((AttributesImpl)object2).clear();
        }
        for (int i = 0; i < attributes.getLength(); ++i) {
            String string;
            object = attributes.getURI(i);
            String string2 = attributes.getLocalName(i);
            String string3 = attributes.getValue(i);
            String string4 = attributes.getQName(i);
            if (object == null) {
                object = "";
            }
            if (string2 == null || string2.length() == 0) {
                string2 = string4;
            }
            if (string4 == null || string4.length() == 0) {
                string4 = string2;
            }
            if (object == "http://www.w3.org/2001/XMLSchema-instance" && string2 == "nil" && ((string = string3.trim()).equals("false") || string.equals("0"))) continue;
            ((AttributesImpl)object2).addAttribute((String)object, string2, string4, attributes.getType(i), string3);
        }
        this.idxStack[this.stackTop] = this.nsLen;
        this.collectText[this.stackTop] = bl;
    }

    public void popAttributes() {
        --this.stackTop;
        --this.elementDepth;
    }

    public Attributes getUnconsumedAttributes() {
        return this.attStack[this.stackTop];
    }

    public int getAttribute(String string, String string2) {
        return this.attStack[this.stackTop].getIndexFast(string, string2);
    }

    public void consumeAttribute(int n) throws SAXException {
        AttributesImpl attributesImpl = this.attStack[this.stackTop];
        String string = attributesImpl.getURI(n);
        String string2 = attributesImpl.getLocalName(n);
        String string3 = attributesImpl.getQName(n);
        String string4 = attributesImpl.getValue(n);
        attributesImpl.removeAttribute(n);
        this.getCurrentHandler().enterAttribute(string, string2, string3);
        this.consumeText(string4, false);
        this.getCurrentHandler().leaveAttribute(string, string2, string3);
    }

    public String eatAttribute(int n) throws SAXException {
        AttributesImpl attributesImpl = this.attStack[this.stackTop];
        String string = attributesImpl.getValue(n);
        attributesImpl.removeAttribute(n);
        return string;
    }

    public void addPatcher(Runnable runnable) {
        if (this.patchers == null) {
            this.patchers = new Runnable[32];
        }
        if (this.patchers.length == this.patchersLen) {
            Runnable[] runnableArray = new Runnable[this.patchersLen * 2];
            System.arraycopy(this.patchers, 0, runnableArray, 0, this.patchersLen);
            this.patchers = runnableArray;
        }
        this.patchers[this.patchersLen++] = runnable;
    }

    private void runPatchers() {
        if (this.patchers != null) {
            for (int i = 0; i < this.patchersLen; ++i) {
                this.patchers[i].run();
            }
        }
    }

    public String addToIdTable(String string) {
        if (this.idmap == null) {
            this.idmap = new Hashtable();
        }
        this.idmap.put(string, this.getCurrentHandler().owner());
        return string;
    }

    public Object getObjectFromId(String string) {
        if (this.idmap == null) {
            return null;
        }
        return this.idmap.get(string);
    }

    public void skippedEntity(String string) {
    }

    public void processingInstruction(String string, String string2) {
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public Locator getLocator() {
        return this.locator;
    }

    public void handleEvent(ValidationEvent validationEvent, boolean bl) throws SAXException {
        ValidationEventHandler validationEventHandler;
        try {
            validationEventHandler = this.parent.getEventHandler();
        }
        catch (JAXBException jAXBException) {
            throw new JAXBAssertionError();
        }
        boolean bl2 = validationEventHandler.handleEvent(validationEvent);
        if (!bl2) {
            this.aborted = true;
        }
        if (!bl || !bl2) {
            throw new SAXException(new UnmarshalException(validationEvent.getMessage(), validationEvent.getLinkedException()));
        }
    }

    public String getBaseUri() {
        return null;
    }

    public boolean isUnparsedEntity(String string) {
        return true;
    }

    public boolean isNotation(String string) {
        return true;
    }

    public void setTracer(Tracer tracer) {
        this.tracer = tracer;
    }

    public Tracer getTracer() {
        if (this.tracer == null) {
            this.tracer = new Tracer.Standard();
        }
        return this.tracer;
    }

    private String computeExpectedRootElements() {
        String string = "";
        String[] stringArray = this.grammarInfo.getProbePoints();
        for (int i = 0; i < stringArray.length; i += 2) {
            if (!this.grammarInfo.recognize(stringArray[i], stringArray[i + 1])) continue;
            if (string.length() != 0) {
                string = string + ',';
            }
            string = string + "<{" + stringArray[i] + "}" + stringArray[i + 1] + ">";
        }
        return string;
    }
}

