/*
 * Decompiled with CFR 0.152.
 */
package phex.xml.impl.runtime;

import com.sun.xml.bind.DatatypeConverterImpl;
import com.sun.xml.bind.validator.Messages;
import javax.xml.bind.DatatypeConverter;
import javax.xml.bind.PropertyException;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.ValidationException;
import javax.xml.bind.Validator;
import javax.xml.bind.helpers.DefaultValidationEventHandler;
import org.xml.sax.SAXException;
import phex.xml.impl.runtime.DefaultJAXBContextImpl;
import phex.xml.impl.runtime.ValidatableObject;
import phex.xml.impl.runtime.ValidationContext;

public class ValidatorImpl
implements Validator {
    private ValidationEventHandler eventHandler = new DefaultValidationEventHandler();
    final DefaultJAXBContextImpl jaxbContext;

    public ValidatorImpl(DefaultJAXBContextImpl defaultJAXBContextImpl) {
        DatatypeConverter.setDatatypeConverter(DatatypeConverterImpl.theInstance);
        this.jaxbContext = defaultJAXBContextImpl;
    }

    public boolean validateRoot(Object object) throws ValidationException {
        if (object == null) {
            throw new IllegalArgumentException(Messages.format("Shared.MustNotBeNull", "rootObj"));
        }
        return this.validate(object, true);
    }

    public boolean validate(Object object) throws ValidationException {
        if (object == null) {
            throw new IllegalArgumentException(Messages.format("Shared.MustNotBeNull", "subrootObj"));
        }
        return this.validate(object, false);
    }

    private boolean validate(Object object, boolean bl) throws ValidationException {
        try {
            ValidatableObject validatableObject = this.jaxbContext.getGrammarInfo().castToValidatableObject(object);
            if (validatableObject == null) {
                throw new ValidationException(Messages.format("Validator.NotValidatable"));
            }
            EventInterceptor eventInterceptor = new EventInterceptor(this.eventHandler);
            ValidationContext validationContext = new ValidationContext(this.jaxbContext, eventInterceptor, bl);
            validationContext.validate(validatableObject);
            validationContext.reconcileIDs();
            return !eventInterceptor.hadError();
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException.getException();
            if (exception != null) {
                throw new ValidationException(exception);
            }
            throw new ValidationException(sAXException);
        }
    }

    public ValidationEventHandler getEventHandler() {
        return this.eventHandler;
    }

    public void setEventHandler(ValidationEventHandler validationEventHandler) {
        this.eventHandler = validationEventHandler == null ? new DefaultValidationEventHandler() : validationEventHandler;
    }

    public void setProperty(String string, Object object) throws PropertyException {
        if (string == null) {
            throw new IllegalArgumentException(Messages.format("Shared.MustNotBeNull", "name"));
        }
        throw new PropertyException(string, object);
    }

    public Object getProperty(String string) throws PropertyException {
        if (string == null) {
            throw new IllegalArgumentException(Messages.format("Shared.MustNotBeNull", "name"));
        }
        throw new PropertyException(string);
    }

    private static class EventInterceptor
    implements ValidationEventHandler {
        private boolean hadError = false;
        private final ValidationEventHandler next;

        EventInterceptor(ValidationEventHandler validationEventHandler) {
            this.next = validationEventHandler;
        }

        public boolean hadError() {
            return this.hadError;
        }

        public boolean handleEvent(ValidationEvent validationEvent) {
            boolean bl;
            this.hadError = true;
            if (this.next != null) {
                try {
                    bl = this.next.handleEvent(validationEvent);
                }
                catch (RuntimeException runtimeException) {
                    bl = false;
                }
            } else {
                bl = false;
            }
            return bl;
        }
    }
}

