/*
 * Decompiled with CFR 0.152.
 */
package phex.xml.thex;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import phex.utils.Logger;
import phex.xml.thex.ThexHashTree;
import phex.xml.thex.ThexHashTreeSAXHandler;

public class ThexHashTreeCodec {
    public static ThexHashTree parseThexHashTreeXML(InputStream inputStream) throws IOException {
        ThexHashTree thexHashTree = new ThexHashTree();
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        try {
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            sAXParser.parse(new InputSource(inputStream), (DefaultHandler)new ThexHashTreeSAXHandler(thexHashTree));
            return thexHashTree;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Logger.logError(parserConfigurationException);
            throw new IOException("Parsing Thex HashTree failed.");
        }
        catch (SAXException sAXException) {
            Logger.logError(sAXException);
            throw new IOException("Parsing Thex HashTree failed.");
        }
    }

    public static byte[] generateThexHashTreeXML(ThexHashTree thexHashTree) throws IOException {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        stringWriter.write("<!DOCTYPE hashtree SYSTEM \"http://open-content.net/spec/thex/thex.dtd\">");
        stringWriter.write("<hashtree>");
        stringWriter.write("<file size=\"");
        stringWriter.write(thexHashTree.getFileSize());
        stringWriter.write("\" segmentsize=\"");
        stringWriter.write(thexHashTree.getFileSegmentSize());
        stringWriter.write("\"/>");
        stringWriter.write("<digest algorithm=\"");
        stringWriter.write(thexHashTree.getDigestAlgorithm());
        stringWriter.write("\" outputsize=\"");
        stringWriter.write(thexHashTree.getDigestOutputSize());
        stringWriter.write("\"/>");
        stringWriter.write("<serializedtree depth=\"");
        stringWriter.write(thexHashTree.getSerializedTreeDepth());
        stringWriter.write("\" type=\"");
        stringWriter.write(thexHashTree.getSerializedTreeType());
        stringWriter.write("\" uri=\"");
        stringWriter.write(thexHashTree.getSerializedTreeUri());
        stringWriter.write("\"/>");
        stringWriter.write("</hashtree>");
        String string = stringWriter.toString();
        return string.getBytes("UTF-8");
    }
}

