<?php
/*=================================================
	Project: phpGedView
	File: addmedia.php
	Author: John Finlay
	Comments:
		This file allows the user to maintain a seperate table
		of media files and associate them with individuals in the gedcom
		and then add these records later.
		Requires MySQL mode.

	phpGedView: Genealogy Viewer
    Copyright (C) 2002 to 2003  John Finlay and Others

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
===================================================*/
# $Id: addmedia.php,v 1.1 2004/01/11 18:17:12 yalnifj Exp $

require("config.php");
require($PGV_BASE_DIRECTORY.$factsfile["english"]);
require($PGV_BASE_DIRECTORY.$factsfile[$LANGUAGE]);

if (empty($ged)) $ged = $GEDCOM;
$GEDCOM = $ged;
require("gdbi_functions.php");

//-- get the medialist
function get_new_media_list() {
	global $medialist, $GEDCOM;
	global $TBLPREFIX;
	
	$medialist = array();
	
	$sql = "SELECT * FROM ".$TBLPREFIX."media WHERE m_file='$GEDCOM' ORDER BY m_indi, m_order";
	$res = dbquery($sql);
	$ct = mysql_num_rows($res);
	while($row=mysql_fetch_array($res)){
		$media = array();
		$media["GEDFILE"] = $row["m_file"];
		$media["INDI"] = $row["m_indi"];
		$media["INDINAME"] = $row["m_indiname"];
		$media["FILE"] = $row["m_name"];
		$media["FORM"] = $row["m_ext"];
		$media["_PRIM"] = $row["m_ind"];
		$media["TITL"] = $row["m_titl"];
		$media["ORDER"] = $row["m_order"];
	}
	return $medialist;
}


print_header("Media Add Tool");
print "\n\t<center><h2>Add Media Tool</h2></center>\n\t";
print "This file will add media OBJE tags to the in gedcom $ged.<br /><br />";

$sql = "SHOW TABLES";
$res = dbquery($sql);
$has_media = false;
while($table = mysql_fetch_array($res)) {
	if ($table[0]==$TBLPREFIX."media") $has_media = true;
}

if (!$has_media) {
	$sql = "CREATE TABLE ".$TBLPREFIX."media (
	m_indi varchar(15) NOT NULL,
	m_indiname varchar(30) NOT NULL,
	m_name varchar(30) NOT NULL,
	m_ext char(3) NOT NULL,
	m_ind char(1) NOT NULL,
	m_titl varchar(255) NULL,
	m_order int(11) NOT NULL,
	m_file varchar(255) NOT NULL,
	PRIMARY KEY (m_indi , m_name, m_file))";
	$res = dbquery($sql);
	if ($res) print "Successfully created <i>media</i> table.";
}

if (empty($action)) $action="showmedia";

if ($action=="newentry") {
	$sql = "INSERT INTO ".$TBLPREFIX."media VALUES('".addslashes($m_indi)."','".addslashes($m_indiname)."','".addslashes($m_name)."','".addslashes($m_ext)."','".addslashes($m_ind)."','".addslashes($m_titl)."','".addslashes($m_order)."','".addslashes($m_file)."')";
	$res = dbquery($sql);
	$action = "showmedia";
}

if ($action=="showmedia") {
	$medialist = get_new_media_list();
	print "<table class=\"list_table\">\n";
	print "<tr><td class=\"list_label\">".$pgv_lang["title"]."</td><td class=\"list_label\">".$pgv_lang["gedcomid"]."</td>\n";
	print "<td class=\"list_label\">".$factarray["FILE"]."</td><td class=\"list_label\">_PRIM</td><td class=\"list_label\">order</td></tr>\n";
	foreach($medialist as $media) {
		print "<tr>";
		print "<td class=\"list_value\">".$media["TITL"]."</td>";
		print "<td class=\"list_value\">".$media["INDINAME"]." (".$media["INDI"].")</td>";
		print "<td class=\"list_value\">".$media["FILE"]."</td>";
		print "<td class=\"list_value\">".$media["_PRIM"]."</td>";
		print "<td class=\"list_value\">".$media["ORDER"]."</td>";
		print "</tr>\n";
	}
	print "</table>\n";
	print "<a href=\"addmedia.php?action=addmedia\">Click here to Add the Media to Gedcom</a><br />\n";
	//-- add a table and form to easily add new values to the table
	print "<form method=\"post\" action=\"addmedia.php\">\n";
	print "<input type=\"hidden\" name=\"action\" value=\"newentry\" />\n";
	print "<table class=\"facts_table\">\n";
	print "<tr><td class=\"facts_label\">".$pgv_lang["gedcomid"]."</td><td class=\"facts_value\"><input type=\"text\" size=\"5\" name=\"m_indi\" /></td></tr>\n";
	print "<tr><td class=\"facts_label\">".$pgv_lang["name"]."</td><td class=\"facts_value\"><input type=\"text\" name=\"m_indiname\" /></td></tr>\n";
	print "<tr><td class=\"facts_label\">".$factarray["FILE"]."</td><td class=\"facts_value\"><input type=\"text\" name=\"m_name\" /></td></tr>\n";
	print "<tr><td class=\"facts_label\">Extension</td><td class=\"facts_value\"><input type=\"text\" name=\"m_ext\" value=\"jpg\" /></td></tr>\n";
	print "<tr><td class=\"facts_label\">_PRIM</td><td class=\"facts_value\"><input type=\"text\" name=\"m_ind\" value=\"Y\" maxlength=\"1\" /></td></tr>\n";
	print "<tr><td class=\"facts_label\">".$pgv_lang["title"]."</td><td class=\"facts_value\"><input type=\"text\" name=\"m_title\" /></td></tr>\n";
	print "<tr><td class=\"facts_label\">Order</td><td class=\"facts_value\"><input type=\"text\" name=\"m_order\" value=\"0\" /></td></tr>\n";
	print "</table>\n";
	print "<input type=\"submit\" value=\"Add Media\" />\n";
	print "</form>\n";
}

if ($action=="addmedia") {
	$medialist = get_new_media_list();
	foreach($medialist as $media) {
		$indirec = find_record_in_file($media["INDI"]);
		$indirec .= "\r\n1 OBJE";
		$indirec .= "\r\b2 FILE ".$media["FILE"];
		$indirec .= "\r\b2 TITL ".$media["TITL"];
		$indirec .= "\r\b2 _PRIM ".$media["_PRIM"];
		$indirec .= "\r\b2 FORM ".$media["FORM"];
		replace_gedrec($media["INDI"], $indirec);
	}
	print "<p>Adds completed.</p>\n";
}

print_footer();
?>