<?php
/*=================================================
	Project: phpGedView
	File: authentication.php
	Author:
		John Finlay		yalnifj@users.sourceforge.net
	Comments:
		Extraction of privacy checking for display of data on living
		individuals.

	Change Log:
		$ Log: $

	phpGedView: Genealogy Viewer
	Copyright (C) 2002 to 2003  John Finlay and Others

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

===================================================*/
# $Id: authentication_index.php,v 1.61 2004/01/15 18:02:20 yalnifj Exp $

if (strstr($_SERVER["PHP_SELF"],"authentication_index.php")) {
	print "Don't you know that hacking is illegal.";
	exit;
}
//-- file that holds the users array
require $PGV_BASE_DIRECTORY."authenticate.php";

//====================================================================
//-- The following functions must be implemented by anyone wishing to
//-- extend the authentication functionality of PhpGedView
//====================================================================

//----------------------------------- authenticateUser
//-- requires a username and password and
//-- returns true if the username and password
//-- pair allow access
function authenticateUser($username, $password) {
	global $users, $GEDCOM;
	$user = getUser($username);
	if ($user!==false) {
		if (crypt($password, $user["password"])==$user["password"]) {
	        /* added by Kurt - start */
	        if (!isset($user["verified"])) $user["verified"] = "";
	        if (!isset($user["verified_by_admin"])) $user["verified_by_admin"] = "";
	        if ((($user["verified"] == "yes") and ($user["verified_by_admin"] == "yes")) or ($user["canadmin"] != "")){
		        /* added by Kurt - end */
		        $users[$username]["loggedin"]="Y";
		        $users[$username]["sessiontime"]=time();
		        if (is_writable("authenticate.php")) storeUsers();
			AddToLog("Login Successful ->" . $username ."<-");
			$_SESSION['pgv_user'] = $username;
			if (isset($pgv_lang[$user["language"]])) $_SESSION['CLANGUAGE'] = $user['language'];
				foreach($user["gedcomid"] as $ged=>$id) {
					if (!empty($id)) $_SESSION['GEDCOM']=$ged;
				}
				return true;
			}
		/* added by Kurt - start */
		}
		/* added by Kurt - end */
	}
	AddToLog("Login Failed ->" . $username ."<-");
	return false;
}

//----------------------------------- userLogout
//-- logs a user out of the system
function userLogout($username = "") {
	global $users;

	if ($username=="") {
		if (isset($_SESSION["pgv_user"])) $username = $_SESSION["pgv_user"];
		else return;
	}
	$users[$username]["loggedin"]="N";
	$users[$username]["sessiontime"]=0;
	storeUsers();
	AddToLog("Logout - " . $username);

	if (isset($_SESSION['pgv_user'])) {
		if ($_SESSION['pgv_user']==$username) {
			$_SESSION['pgv_user'] = "";
			unset($_SESSION['pgv_user']);
			$_SESSION = array();
			@session_destroy();
		}
	}
}

//----------------------------------- getUsers
//-- return an array of user arrays
function getUsers() {
	global $users;
	return $users;
}

//----------------------------------- getUserName
//-- retrieve the username from the state
//-- however you are storing it.  The default
//-- implemenation uses a cookie
function getUserName() {

	//-- this section checks if the session exists and uses it to get the username
	if (isset($_SESSION)) {
		if (isset($_SESSION['pgv_user'])) return $_SESSION['pgv_user'];
	}
	if (isset($HTTP_SESSION_VARS)) {
		if (isset($HTTP_SESSION_VARS['pgv_user'])) return $HTTP_SESSION_VARS['pgv_user'];
	}
	return "";
}

//----------------------------------- userIsAdmin
//-- takes a username and checks if the
//-- user has administrative privileges
//-- to change the configuration files
function userIsAdmin($username) {
	if (empty($username)) return false;
	$user = getUser($username);
	if (!$user) return false;
	return $user["canadmin"];
}

//----------------------------------- userCanEdit
//-- takes a username and checks if the
//-- user has write privileges to change
//-- the gedcom data
function userCanEdit($username) {
	global $ALLOW_EDIT_GEDCOM, $GEDCOM;

	if (!$ALLOW_EDIT_GEDCOM) return false;
	if (userIsAdmin($username)) return true;
	if (empty($username)) return false;
	$user = getUser($username);
	if (!$user) return false;
	return $user["canedit"][$GEDCOM];
}

//----------------------------------- adminUserExists
//-- return true if an admin user has been defined
function adminUserExists() {
	global $users;

	if (count($users)==0) return false;
	return true;
}

//----------------------------------- storeUsers
//-- writes the users to the file
function storeUsers() {
	global $users, $PGV_BASE_DIRECTORY, $pgv_lang;

	$authtext = "<?php\n\n\$users = array();\n\n";
	foreach($users as $key=>$user) {
		$authtext .= "\$user = array();\n";
		foreach($user as $ukey=>$value) {
			if (!is_array($value)) {
				$value = preg_replace('/"/', '\\"', $value);
				$authtext .= "\$user[\"$ukey\"] = '$value';\n";
			}
			else {
				$authtext .= "\$user[\"$ukey\"] = array();\n";
				foreach($value as $subkey=>$subvalue) {
					$subvalue = preg_replace('/"/', '\\"', $subvalue);
					$authtext .= "\$user[\"$ukey\"][\"$subkey\"] = '$subvalue';\n";
				}
			}
		}
		$authtext .= "\$users[\"$key\"] = \$user;\n\n";
	}
	$authtext .= "?>\n";
	if (!is_writeable($PGV_BASE_DIRECTORY."authenticate.php")) {
		print "<span class=\"error\"><b>Unable to write to authenticate.php<br /></b></span>";
		$_SESSION["authenticate.php"]=$authtext;
		print "<br /><br /><a href=\"config_download.php?file=authenticate.php\">".$pgv_lang["download_here"]."</a><br /><br />\n";
		return false;
	}
	else {
		$fp = fopen($PGV_BASE_DIRECTORY."authenticate.php", "w");
		fwrite($fp, $authtext);
		fclose($fp);
		return true;
	}
}

//----------------------------------- addUser
//-- adds a new user.
//-- requires the newuser parameter to be an array
function addUser($newuser) {
	global $users;

	$username = getUserName();
	AddToLog($username." created new user -> ".$newuser["username"]." <-");
	$users[$newuser["username"]]=$newuser;

	$res = storeUsers();
	if (!$res) unset($users[$newuser["username"]]);
	return $res;

}

//----------------------------------- deleteUser
//-- deletes the user with the given username.
function deleteUser($username) {
	global $users;

	$activeuser = getUserName();
	AddToLog($activeuser." Deleted user -> ".$username." <-");
	unset($users[$username]);
	return storeUsers();
}

//----------------------------------- getUser
//-- returns an array for the user with the given username.
function getUser($username) {
	global $users;

	if (isset($users[$username])) return $users[$username];
	return false;

}

//----------------------------------- AddToLog
//-- requires a string to add into the log-file
function AddToLog($LogString) {
	global $INDEX_DIRECTORY, $LOGFILE_CREATE;

	if ($LOGFILE_CREATE=="none") return;

	$REMOTE_ADDR = $_SERVER['REMOTE_ADDR'];

	if ($LOGFILE_CREATE=="daily") $logfile = $INDEX_DIRECTORY."/pgv-" . date("Ymd") . ".log";
	if ($LOGFILE_CREATE=="weekly") $logfile = $INDEX_DIRECTORY."/pgv-" . date("Ym") . "-week" . date("W") . ".log";
	if ($LOGFILE_CREATE=="monthly") $logfile = $INDEX_DIRECTORY."/pgv-" . date("Ym") . ".log";
	if ($LOGFILE_CREATE=="yearly") $logfile = $INDEX_DIRECTORY."/pgv-" . date("Y") . ".log";

	# $logfile = $INDEX_DIRECTORY."/pgv-" . date("Ymd") . ".log";
	if (is_writable($INDEX_DIRECTORY)) {
		$logline = date("d.m.Y H:i:s") . " - " . $REMOTE_ADDR . " - " . $LogString . "\r\n";
		$fp = fopen($logfile, "a");
		flock($fp, 2);
		fputs($fp, $logline);
		flock($fp, 3);
		fclose($fp);
	}
}

//----------------------------------- addMessage
//-- stores a new message in the database
function addMessage($message) {
	global $messages, $CONTACT_METHOD, $pgv_lang, $CHARACTER_SET, $LANGUAGE;

	$message["body"] .= "\r\n=--------------------------------------=\r\nIP ADDRESS: ".$_SERVER['REMOTE_ADDR']."\r\n";
	$message["body"] .= "DNS LOOKUP: ".gethostbyaddr($_SERVER['REMOTE_ADDR'])."\r\n";
	$message["body"] .= "LANGUAGE: $LANGUAGE\r\n";
	if (!isset($messages)) readMessages();
	$messages[] = $message;
	if (!isset($message["created"])) $message["created"] = gmdate ("M d Y H:i:s");
	if ($message["method"]=="messaging2") {
		$email2 = $pgv_lang["message_email2"]."\r\n\r\n".stripslashes($message["body"]);
		$subject = "[PhpGedView Message] ".stripslashes($message["subject"]);
		$fuser = getUser($message["from"]);
		$from ="";
		if (!$fuser) {
			$from = $message["from"];
			$email2 = $pgv_lang["message_email3"]."\r\n\r\n".stripslashes($message["body"]);
			$email1 = $pgv_lang["message_email1"];
			if (!empty($message["from_name"])) $email1 .= $message["from_name"]."\r\n\r\n".stripslashes($message["body"]);
			else $email1 .= $from."\r\n\r\n".stripslashes($message["body"]);
		}
		else {
			$from = "'".hex4email($fuser["fullname"],$CHARACTER_SET). "' <".$fuser["email"].">";
			$email1 = $pgv_lang["message_email1"];
			$email1 .= $fuser["fullname"]."\r\n\r\n".stripslashes($message["body"]);
		}
		$tuser = getUser($message["to"]);
		if (!$tuser) {
			//-- the to user must be a valid user in the system before it will send any mails
			return false;
		}
		else $to = "'".hex4email($tuser["fullname"],$CHARACTER_SET). "' <".$tuser["email"].">";
		if (!$fuser) $header2 = "From: noreply@".$_SERVER["SERVER_NAME"]."\r\nContent-type: text/plain; charset=$CHARACTER_SET; format=flowed\r\nContent-Transfer-Encoding: 8bit\r\n";
		else $header2 = "From: ".$to."\r\nContent-type: text/plain; charset=$CHARACTER_SET; format=flowed\r\nContent-Transfer-Encoding: 8bit\r\n";
		if (!empty($tuser["email"])) mail($to, hex4email($subject,$CHARACTER_SET), $email1, "From: ".$from."\r\nContent-type: text/plain; charset=$CHARACTER_SET; format=flowed\r\nContent-Transfer-Encoding: 8bit\r\n");
		if (!isset($message["no_from"])) mail($from, hex4email($subject,$CHARACTER_SET), $email2, $header2);
	}
	return storeMessages();
}

//----------------------------------- deleteMessage
//-- deletes a message in the database
function deleteMessage($message_id) {
	global $messages;

	if (!isset($messages)) readMessages();
	unset($messages[$message_id]);
	return storeMessages();
}

//----------------------------------- getUserMessages
//-- Return an array of a users messages
function getUserMessages($username) {
	global $messages;

	if (!isset($messages)) readMessages();
	$umessages = array();
	foreach($messages as $k=>$m) {
		if ($m["to"]==$username) $umessages[$k] = $m;
	}
	return $umessages;
}

//----------------------------------- storeMessages
//-- Store the messages in a file
function storeMessages() {
	global $messages, $INDEX_DIRECTORY;

	$mstring = serialize($messages);
	$fp = fopen($INDEX_DIRECTORY."messages.dat", "wb");
	fwrite($fp, $mstring);
	fclose($fp);
	return true;
}

//----------------------------------- readMessages
//-- read the messages in a file
function readMessages() {
	global $messages, $INDEX_DIRECTORY;

	$messages = array();
	if (file_exists($INDEX_DIRECTORY."messages.dat")) {
		$fp = fopen($INDEX_DIRECTORY."messages.dat", "rb");
		$mstring = fread($fp, filesize($INDEX_DIRECTORY."messages.dat"));
		fclose($fp);
		$messages = unserialize($mstring);
	}
}

//----------------------------------- addFavorite
//-- stores a new message in the database
function addFavorite($favorite) {
	global $favorites;

	if (!isset($favorites)) $favorites = readFavorites();
	foreach($favorites as $f) {
		if ($f["gid"]==$favorite["gid"]) return false;
	}
	$favorites[] = $favorite;
	return storeFavorites();
}

//----------------------------------- deleteFavorite
//-- deletes a message in the database
function deleteFavorite($fv_id) {
	global $favorites;

	if (!isset($favorites)) $favorites = readFavorites();
	unset($favorites[$fv_id]);
	return storeFavorites();
}

//----------------------------------- getUserFavorites
//-- Return an array of a users messages
function getUserFavorites($username) {
	global $favorites, $GEDCOMS;

	if (!isset($favorites)) $favorites = readFavorites();
	$ufavorites = array();
	if (isset($favorites)) {
		foreach($favorites as $k=>$m) {
			if ($m["username"]==$username){
				if (isset($GEDCOMS[$m["file"]])) $ufavorites[$k] = $m;
			}
		}
	}
	return $ufavorites;
}

//----------------------------------- storeFavorites
//-- Store the favorites in a file
function storeFavorites() {
	global $favorites, $INDEX_DIRECTORY;
	$mstring = serialize($favorites);
	$fp = fopen($INDEX_DIRECTORY."favorites.dat", "wb");
	fwrite($fp, $mstring);
	fclose($fp);
	return true;
}

//----------------------------------- readFavorites
//-- read the messages in a file
function readFavorites() {
	global $favorites, $INDEX_DIRECTORY;

	$favorites = array();
	if (file_exists($INDEX_DIRECTORY."favorites.dat")) {
		$fp = fopen($INDEX_DIRECTORY."favorites.dat", "rb");
		$mstring = fread($fp, filesize($INDEX_DIRECTORY."favorites.dat"));
		fclose($fp);
		$favorites = unserialize($mstring);
	}
	return $favorites;
}

?>
