<?php
/*=================================================
	Project: phpGedView
	File: authentication.php
	Author:
		John Finlay		yalnifj@users.sourceforge.net
	Comments:
		Extraction of privacy checking for display of data on living
        individuals.

	Change Log:
		$ Log: $

    phpGedView: Genealogy Viewer
    Copyright (C) 2002 to 2003  John Finlay and Others

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

===================================================*/
# $Id: authentication_mysql.php,v 1.57 2004/01/15 18:02:20 yalnifj Exp $
if (strstr($_SERVER["PHP_SELF"],"authentication")) {
	print "Now, why would you want to do that.  You're not hacking are you?";
	exit;
}
//====================================================================
//-- The following functions must be implemented by anyone wishing to
//-- extend the authentication functionality of PhpGedView
//-- Assumes that a database connection has already been established
//====================================================================

//----------------------------------- authenticateUser
//-- requires a username and password and
//-- returns true if the username and password
//-- pair allow access
function authenticateUser($username, $password) {
	global $TBLPREFIX, $GEDCOM;
	checkTableExists();
	$user = getUser($username);
	if ($user!==false) {
		if (crypt($password, $user["password"])==$user["password"]) {
	        /* added by Kurt - start */
	        if (!isset($user["verified"])) $user["verified"] = "";
	        if (!isset($user["verified_by_admin"])) $user["verified_by_admin"] = "";
	        if ((($user["verified"] == "yes") and ($user["verified_by_admin"] == "yes")) or ($user["canadmin"] != "")){
		        /* added by Kurt - end */
		        $sql = "UPDATE ".$TBLPREFIX."users SET u_loggedin='Y', u_sessiontime='".time()."' WHERE u_username='$username'";
		        $res = dbquery($sql);
				AddToLog("Login Successful ->" . $username ."<-");
				$_SESSION['pgv_user'] = $username;
				if (isset($pgv_lang[$user["language"]])) $_SESSION['CLANGUAGE'] = $user['language'];
				foreach($user["gedcomid"] as $ged=>$id) {
					if (!empty($id)) $_SESSION['GEDCOM']=$ged;
				}
				return true;
			}
		/* added by Kurt - start */
		}
		/* added by Kurt - end */
	}
	AddToLog("Login Failed ->" . $username ."<-");
	return false;
}

//----------------------------------- userLogout
//-- logs a user out of the system
function userLogout($username = "") {
	global $TBLPREFIX;

	if ($username=="") {
		if (isset($_SESSION["pgv_user"])) $username = $_SESSION["pgv_user"];
		else return;
	}
	$sql = "UPDATE ".$TBLPREFIX."users SET u_loggedin='N', u_sessiontime='0' WHERE u_username='".$username."'";
	$res = dbquery($sql);
	AddToLog("Logout - " . $username);

	if (isset($_SESSION['pgv_user'])) {
		if ($_SESSION['pgv_user']==$username) {
			$_SESSION['pgv_user'] = "";
			unset($_SESSION['pgv_user']);
			$_SESSION = array();
			@session_destroy();
		}
	}
}

//----------------------------------- getUsers
//-- return an array of user arrays
function getUsers() {
	global $TBLPREFIX;
	$sql = "SELECT * FROM ".$TBLPREFIX."users";
	$res = dbquery($sql);
	$users = array();
	if ($res) {
		while($user_row = mysql_fetch_array($res)) {
			$user = array();
			$user["username"]=$user_row["u_username"];
			$user["fullname"]=$user_row["u_fullname"];
			$user["gedcomid"]=unserialize($user_row["u_gedcomid"]);
			$user["rootid"]=unserialize($user_row["u_rootid"]);
			$user["password"]=$user_row["u_password"];
			if ($user_row["u_canadmin"]=='Y') $user["canadmin"]=true;
			else $user["canadmin"]=false;
			$user["canedit"]=unserialize($user_row["u_canedit"]);
			$user["email"] = $user_row["u_email"];
			$user["verified"] = $user_row["u_verified"];
			$user["verified_by_admin"] = $user_row["u_verified_by_admin"];
			$user["language"] = $user_row["u_language"];
			$user["pwrequested"] = $user_row["u_pwrequested"];
			$user["reg_timestamp"] = $user_row["u_reg_timestamp"];
			$user["reg_hashcode"] = $user_row["u_reg_hashcode"];
			$user["theme"] = $user_row["u_theme"];
			$user["loggedin"] = $user_row["u_loggedin"];
			$user["sessiontime"] = $user_row["u_sessiontime"];
			$users[$user_row["u_username"]] = $user;
		}
	}
	return $users;
}

//----------------------------------- getUserName
//-- retrieve the username from the state
//-- however you are storing it.  The default
//-- implemenation uses a cookie
function getUserName() {

	//-- this section checks if the session exists and uses it to get the username
	if (isset($_SESSION)) {
		if (isset($_SESSION['pgv_user'])) return $_SESSION['pgv_user'];
	}
	if (isset($HTTP_SESSION_VARS)) {
		if (isset($HTTP_SESSION_VARS['pgv_user'])) return $HTTP_SESSION_VARS['pgv_user'];
	}
	return "";
}

//----------------------------------- userIsAdmin
//-- takes a username and checks if the
//-- user has administrative privileges
//-- to change the configuration files
function userIsAdmin($username) {
	if (empty($username)) return false;
	$user = getUser($username);
	if (!$user) return false;
	return $user["canadmin"];
}

//----------------------------------- userCanEdit
//-- takes a username and checks if the
//-- user has write privileges to change
//-- the gedcom data
function userCanEdit($username) {
	global $ALLOW_EDIT_GEDCOM, $GEDCOM;

	if (!$ALLOW_EDIT_GEDCOM) return false;
	if (userIsAdmin($username)) return true;
	if (empty($username)) return false;
	$user = getUser($username);
	if (!$user) return false;
	return $user["canedit"][$GEDCOM];
}

//----------------------------------- adminUserExists
//-- return true if an admin user has been defined
function adminUserExists() {
	global $TBLPREFIX;
	if (checkTableExists()) {
		$sql = "SELECT u_username FROM ".$TBLPREFIX."users WHERE u_canadmin='Y'";
		$res = dbquery($sql);
		$count = mysql_num_rows($res);
		if ($count==0) return false;
		return true;
	}
	return false;
}

//----------------------------------- storeUsers
//-- writes the users to the file
function storeUsers() {
	return true;
}

function checkTableExists() {
	global $TBLPREFIX;
	$sql = "SHOW TABLES";
	$res = dbquery($sql);
	$has_gedcomid = false;
	$has_email = false;
	$has_messages = false;
	$has_favorites = false;
	$has_sessiontime = false;
	while($table = mysql_fetch_array($res)) {
		if ($table[0]==$TBLPREFIX."users") {
			$ssql = "DESCRIBE ".$TBLPREFIX."users";
			$sres = dbquery($ssql);
			while($field = mysql_fetch_array($sres)) {
				if (($field[0]=="u_gedcomid")&&($field[1]=="text")) $has_gedcomid = true;
				if (($field[0]=="u_email")&&($field[1]=="text")) $has_email = true;
				if ($field[0]=="u_sessiontime") $has_sessiontime = true;
			}
			if (!$has_gedcomid) {
				$asql = "DROP TABLE ".$TBLPREFIX."users";
				$ares = dbquery($asql);
				if (!$ares) {
					print "<font color=\"red\">Unable to update <i>Users</i> table.</font><br />\n";
					return false;
				}
			}
			else if (!$has_email) {
				$sql = "ALTER TABLE ".$TBLPREFIX."users ADD COLUMN (u_email TEXT, u_verified VARCHAR(20), u_verified_by_admin VARCHAR(20), u_language VARCHAR(50), u_pwrequested VARCHAR(20), u_reg_timestamp VARCHAR(50), u_reg_hashcode VARCHAR(255), u_theme VARCHAR(50), u_loggedin ENUM('Y','N'), u_sessiontime INT(14))";
				$res = dbquery($sql);
			}
			else if (!$has_sessiontime) {
				$sql = "ALTER TABLE ".$TBLPREFIX."users ADD COLUMN (u_sessiontime INT(14))";
				$res = dbquery($sql);
			}
		}
		if ($table[0]==$TBLPREFIX."messages") $has_messages = true;
		if ($table[0]==$TBLPREFIX."favorites") $has_favorites = true;
	}
	if (!$has_gedcomid) {
		$sql = "CREATE TABLE ".$TBLPREFIX."users (u_username VARCHAR(30) NOT NULL, u_password VARCHAR(255), u_fullname VARCHAR(255), u_gedcomid TEXT, u_rootid TEXT, u_canadmin ENUM('Y','N'), u_canedit TEXT, u_email TEXT, u_verified VARCHAR(20), u_verified_by_admin VARCHAR(20), u_language VARCHAR(50), u_pwrequested VARCHAR(20), u_reg_timestamp VARCHAR(50), u_reg_hashcode VARCHAR(255), u_theme VARCHAR(50), u_loggedin ENUM('Y','N'), u_sessiontime INT(14), PRIMARY KEY(u_username))";
		$res = dbquery($sql);
	}
	if (!$has_messages) {
		$sql = "CREATE TABLE ".$TBLPREFIX."messages (m_id INT NOT NULL auto_increment, m_from VARCHAR(255), m_to VARCHAR(30), m_subject VARCHAR(255), m_body TEXT, m_created VARCHAR(255), PRIMARY KEY(m_id))";
		$res = dbquery($sql);
	}
	if (!$has_favorites) {
		$sql = "CREATE TABLE ".$TBLPREFIX."favorites (fv_id INT NOT NULL auto_increment, fv_username VARCHAR(30), fv_gid VARCHAR(10), fv_type VARCHAR(10), fv_file VARCHAR(100), PRIMARY KEY(fv_id))";
		$res = dbquery($sql);
		if($res) {
			//print "Successfully created <i>Users</i> table.<br />\n";
			return true;
		}
		else {
			print "<font color=\"red\">Unable to create <i>Users</i> table.</font><br />\n";
			return false;
		}
	}
	return true;
}

//----------------------------------- addUser
//-- adds a new user.
//-- requires the newuser parameter to be an array
function addUser($newuser) {
	global $TBLPREFIX;

	if (checkTableExists()) {
		$newuser = db_prep($newuser);
		$sql = "INSERT INTO ".$TBLPREFIX."users VALUES('".$newuser["username"]."','".$newuser["password"]."','".$newuser["fullname"]."','".serialize($newuser["gedcomid"])."','".serialize($newuser["rootid"])."'";
		if ($newuser["canadmin"]) $sql .= ",'Y'";
		else $sql .= ",'N'";
		$sql .= ",'".serialize($newuser["canedit"])."'";
		$sql .= ",'".$newuser["email"]."'";
		$sql .= ",'".$newuser["verified"]."'";
		$sql .= ",'".$newuser["verified_by_admin"]."'";
		$sql .= ",'".$newuser["language"]."'";
		$sql .= ",'".$newuser["pwrequested"]."'";
		$sql .= ",'".$newuser["reg_timestamp"]."'";
		$sql .= ",'".$newuser["reg_hashcode"]."'";
		$sql .= ",'".$newuser["theme"]."'";
		$sql .= ",'".$newuser["loggedin"]."'";
		$sql .= ",'".$newuser["sessiontime"]."'";
		$sql .= ")";
		$res = dbquery($sql);
		$activeuser = getUserName();
		AddToLog($activeuser." added user -> ".$newuser["username"]." <-");
		if ($res) return true;
	}
	return false;
}

//----------------------------------- deleteUser
//-- deletes the user with the given username.
function deleteUser($username) {
	global $TBLPREFIX, $users;
	unset($users[$username]);
	$username = db_prep($username);
	$sql = "DELETE FROM ".$TBLPREFIX."users WHERE u_username='$username'";
	$res = dbquery($sql);
	$activeuser = getUserName();
	AddToLog($activeuser." added user -> ".$username." <-");
	if ($res) return true;
	else return false;
}

//----------------------------------- getUser
//-- returns an array for the user with the given username.
function getUser($username) {
	global $TBLPREFIX, $users;

	if (empty($username)) return false;
	if (isset($users[$username])) return $users[$username];

	$username = db_prep($username);
	$sql = "SELECT * FROM ".$TBLPREFIX."users WHERE BINARY u_username='$username'";
	$res = dbquery($sql);
	if (!$res) return false;
	if (mysql_num_rows($res)==0) return false;
	if ($res) {
		$user_row = mysql_fetch_array($res);
		if ($user_row) {
			$user = array();
			$user["username"]=$user_row["u_username"];
			$user["fullname"]=$user_row["u_fullname"];
			$user["gedcomid"]=unserialize($user_row["u_gedcomid"]);
			$user["rootid"]=unserialize($user_row["u_rootid"]);
			$user["password"]=$user_row["u_password"];
			if ($user_row["u_canadmin"]=='Y') $user["canadmin"]=true;
			else $user["canadmin"]=false;
			$user["canedit"]=unserialize($user_row["u_canedit"]);
			$user["email"] = $user_row["u_email"];
			$user["verified"] = $user_row["u_verified"];
			$user["verified_by_admin"] = $user_row["u_verified_by_admin"];
			$user["language"] = $user_row["u_language"];
			$user["pwrequested"] = $user_row["u_pwrequested"];
			$user["reg_timestamp"] = $user_row["u_reg_timestamp"];
			$user["reg_hashcode"] = $user_row["u_reg_hashcode"];
			$user["theme"] = $user_row["u_theme"];
			$user["loggedin"] = $user_row["u_loggedin"];
			$user["sessiontime"] = $user_row["u_sessiontime"];
			$users[$user_row["u_username"]] = $user;
			return $user;
		}
	}
	return false;
}

//----------------------------------- AddToLog
//-- requires a string to add into the log-file
function AddToLog($LogString) {
	global $INDEX_DIRECTORY, $LOGFILE_CREATE;

	if ($LOGFILE_CREATE=="none") return;

	$REMOTE_ADDR = $_SERVER['REMOTE_ADDR'];
	if (empty($LOGFILE_CREATE)) $LOGFILE_CREATE="daily";
	if ($LOGFILE_CREATE=="daily") $logfile = $INDEX_DIRECTORY."/pgv-" . date("Ymd") . ".log";
	if ($LOGFILE_CREATE=="weekly") $logfile = $INDEX_DIRECTORY."/pgv-" . date("Ym") . "-week" . date("W") . ".log";
	if ($LOGFILE_CREATE=="monthly") $logfile = $INDEX_DIRECTORY."/pgv-" . date("Ym") . ".log";
	if ($LOGFILE_CREATE=="yearly") $logfile = $INDEX_DIRECTORY."/pgv-" . date("Y") . ".log";
	if (is_writable($INDEX_DIRECTORY)) {
		$logline = date("d.m.Y H:i:s") . " - " . $REMOTE_ADDR . " - " . $LogString . "\r\n";
		$fp = fopen($logfile, "a");
		flock($fp, 2);
		fputs($fp, $logline);
		flock($fp, 3);
		fclose($fp);
	}
}

//----------------------------------- addMessage
//-- stores a new message in the database
function addMessage($message) {
	global $TBLPREFIX;
	global $CONTACT_METHOD, $pgv_lang,$CHARACTER_SET, $LANGUAGE;

	$message["body"] .= "\r\n=--------------------------------------=\r\nIP ADDRESS: ".$_SERVER['REMOTE_ADDR']."\r\n";
	$message["body"] .= "DNS LOOKUP: ".gethostbyaddr($_SERVER['REMOTE_ADDR'])."\r\n";
	$message["body"] .= "LANGUAGE: $LANGUAGE\r\n";
	if (!isset($message["created"])) $message["created"] = gmdate ("M d Y H:i:s");
	$sql = "INSERT INTO ".$TBLPREFIX."messages VALUES (NULL, '".addslashes($message["from"])."','".addslashes($message["to"])."','".addslashes($message["subject"])."','".addslashes($message["body"])."','".addslashes($message["created"])."')";
	$res = dbquery($sql);
	if ($message["method"]=="messaging2") {
		$email2 = $pgv_lang["message_email2"]."\r\n\r\n".stripslashes($message["body"]);
		$subject = "[PhpGedView Message] ".stripslashes($message["subject"]);
		$fuser = getUser($message["from"]);
		$from ="";
		if (!$fuser) {
			$from = $message["from"];
			$email2 = $pgv_lang["message_email3"]."\r\n\r\n".stripslashes($message["body"]);
			$email1 = $pgv_lang["message_email1"];
			if (!empty($message["from_name"])) $email1 .= $message["from_name"]."\r\n\r\n".stripslashes($message["body"]);
			else $email1 .= $from."\r\n\r\n".stripslashes($message["body"]);
		}
		else {
			$from = "'".hex4email($fuser["fullname"],$CHARACTER_SET). "' <".$fuser["email"].">";
			$email1 = $pgv_lang["message_email1"];
			$email1 .= $fuser["fullname"]."\r\n\r\n".stripslashes($message["body"]);
		}
		$tuser = getUser($message["to"]);
		if (!$tuser) {
			//-- the to user must be a valid user in the system before it will send any mails
			return false;
		}
		else $to = "'".hex4email($tuser["fullname"],$CHARACTER_SET). "' <".$tuser["email"].">";
		if (!$fuser) $header2 = "From: noreply@".$_SERVER["SERVER_NAME"]."\r\nContent-type: text/plain; charset=$CHARACTER_SET; format=flowed\r\nContent-Transfer-Encoding: 8bit\r\n";
		else $header2 = "From: ".$to."\r\nContent-type: text/plain; charset=$CHARACTER_SET; format=flowed\r\nContent-Transfer-Encoding: 8bit\r\n";
		if (!empty($tuser["email"])) mail($to, hex4email($subject,$CHARACTER_SET), $email1, "From: ".$from."\r\nContent-type: text/plain; charset=$CHARACTER_SET; format=flowed\r\nContent-Transfer-Encoding: 8bit\r\n");
		if (!isset($message["no_from"])) mail($from, hex4email($subject,$CHARACTER_SET), $email2, $header2);
	}
	if ($res) return true;
	else return false;
}

//----------------------------------- deleteMessage
//-- deletes a message in the database
function deleteMessage($message_id) {
	global $TBLPREFIX;

	$sql = "DELETE FROM ".$TBLPREFIX."messages WHERE m_id=".$message_id;
	$res = dbquery($sql);
	if ($res) return true;
	else return false;
}

//----------------------------------- getUserMessages
//-- Return an array of a users messages
function getUserMessages($username) {
	global $TBLPREFIX;

	$messages = array();
	$sql = "SELECT * FROM ".$TBLPREFIX."messages WHERE m_to='$username'";
	$res = dbquery($sql);
	while($row = mysql_fetch_array($res)) {
		$row = db_cleanup($row);
		$message = array();
		$message["id"] = $row["m_id"];
		$message["to"] = $row["m_to"];
		$message["from"] = $row["m_from"];
		$message["subject"] = stripslashes($row["m_subject"]);
		$message["body"] = stripslashes($row["m_body"]);
		$message["created"] = $row["m_created"];
		$messages[] = $message;
	}
	return $messages;
}

//----------------------------------- addFavorite
//-- stores a new message in the database
function addFavorite($favorite) {
	global $TBLPREFIX;

	$sql = "SELECT * FROM ".$TBLPREFIX."favorites WHERE fv_gid='".$favorite["gid"]."' AND fv_file='".$favorite["file"]."'";
	$res = dbquery($sql);
	if (mysql_num_rows($res)>0) return false;
	$sql = "INSERT INTO ".$TBLPREFIX."favorites VALUES (NULL, '".addslashes($favorite["username"])."','".addslashes($favorite["gid"])."','".addslashes($favorite["type"])."','".addslashes($favorite["file"])."')";
	$res = dbquery($sql);
	if ($res) return true;
	else return false;
}

//----------------------------------- deleteFavorite
//-- deletes a message in the database
function deleteFavorite($fv_id) {
	global $TBLPREFIX;

	$sql = "DELETE FROM ".$TBLPREFIX."favorites WHERE fv_id=".$fv_id;
	$res = dbquery($sql);
	if ($res) return true;
	else return false;
}

//----------------------------------- getUserFavorites
//-- Return an array of a users messages
function getUserFavorites($username) {
	global $TBLPREFIX, $GEDCOMS;

	$favorites = array();
	$sql = "SELECT * FROM ".$TBLPREFIX."favorites WHERE fv_username='$username'";
	$res = dbquery($sql);
	while($row = mysql_fetch_array($res)) {
		$row = db_cleanup($row);
		if (isset($GEDCOMS[$row["fv_file"]])) {
			$favorite = array();
			$favorite["id"] = $row["fv_id"];
			$favorite["username"] = $row["fv_username"];
			$favorite["gid"] = $row["fv_gid"];
			$favorite["type"] = $row["fv_type"];
			$favorite["file"] = $row["fv_file"];
			$favorites[] = $favorite;
		}
	}
	return $favorites;
}

?>
