<?php
/*=================================================
	Project: phpGedView
	File: calendar.php
	Author: John Finlay
	Comments:
		Today in your history.  Shows a list of events that
		happened on the given day.  Also shows an option to
		display a calendar view.

	Change Log:
		9/4/03 - File Created

	phpGedView: Genealogy Viewer
    Copyright (C) 2002 to 2003  John Finlay and Others

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

===================================================*/
# $Id: calendar.php,v 1.37.2.3 2004/02/02 15:18:11 yalnifj Exp $

require("config.php");
require($PGV_BASE_DIRECTORY.$factsfile["english"]);
require($PGV_BASE_DIRECTORY.$factsfile[$LANGUAGE]);

if (empty($day)) $day = date("j");
if (empty($month)) $month = date("M");
if (empty($year)) $year = date("Y");

if (empty($action)) $action = "today";
if (empty($filter)) $filter = "all";

print_header($pgv_lang["anniversary_calendar"]);
print_help_link("anniversaries_help", "page_help");
print "<div align=\"center\">\n";
if ($action=="today") {
	$myindilist = array();
	$myfamlist = array();

	if ($day<10) $query = "2 DATE 0?$day $month";
	else $query = "2 DATE $day $month";
	$myindilist = search_indis($query);
	uasort($myindilist, "itemsort");
	$myfamlist = search_fams($query);
	uasort($myfamlist, "famsort");

	print "<font class=\"subheaders\">".$pgv_lang["on_this_day"]."<br />\n";
	print get_changed_date("$day $month $year")."</font><br /><br />\n";
	if ($view!="preview") {
		print "<form name=\"dateform\" method=\"get\" action=\"calendar.php\">";
		print "<input type=\"hidden\" name=\"action\" value=\"$action\" />";
		print $pgv_lang["day"]." <select name=\"day\">";
		for($i=1; $i<32; $i++) {
			print "<option value=\"$i\"";
			if ($i==$day) print " selected=\"selected\"";
			print ">$i</option>\n";
		}
		print "</select> ";
		print $pgv_lang["month"]." <select name=\"month\">";
		foreach($monthtonum as $mon=>$num) {
			print "<option value=\"$mon\"";
			if ($mon==strtolower($month)) print " selected=\"selected\"";
			print ">".$pgv_lang["$mon"]."</option>\n";
		}
		print "</select> ";
		print $pgv_lang["year"]." <input type=\"text\" name=\"year\" value=\"$year\" size=\"4\" />"." ";
		print_help_link("annivers_date_select_help", "qm");
		print "<br />";
		print $pgv_lang["show"].":<select name=\"filter\">\n";
		print "<option value=\"all\"";
		if ($filter=="all") print " selected=\"selected\"";
		print ">".$pgv_lang["all_people"]."</option>\n";
		$username = getUserName();
		if (!$HIDE_LIVE_PEOPLE||(!empty($username))) {
			print "<option value=\"living\"";
			if ($filter=="living") print " selected=\"selected\"";
			print ">".$pgv_lang["living_only"]."</option>\n";
		}
		print "<option value=\"recent\"";
		if ($filter=="recent") print " selected=\"selected\"";
		print ">".$pgv_lang["recent_events"]."</option>\n";
		print "</select> ";
		print_help_link("annivers_show_help", "qm");
		print "<input type=\"submit\" value=\"".$pgv_lang["viewday"]."\" onclick=\"document.dateform.elements['action'].value='today';\" />\n";
		print "<input type=\"submit\" value=\"".$pgv_lang["viewmonth"]."\" onclick=\"document.dateform.elements['action'].value='calendar';\" />\n";
		print_help_link("day_month_help", "qm");
		print "</form>\n";
	}
	if ((count($myfamlist)>0) || (count($myindilist)>0)) {
		print "\n\t\t<table class=\"list_table, $TEXT_DIRECTION\">\n\t\t<tr>";
		if (count($myindilist)>0) {
			print "<td class=\"list_label\">".$pgv_lang["people"]."</td>\n";
		}
		if (count($myfamlist)>0) {
			print "<td class=\"list_label\">".$pgv_lang["families"]."</td>";
		}
		print "</tr>";
		if (count($myindilist)>0) {
			print "\n\t\t<tr><td class=\"list_value\">";
			foreach($myindilist as $gid=>$indi) {
				print " ";
				$disp = true;
				if (($filter=="living")&&($indi["isdead"]==1)) $disp = false;
				else if ($HIDE_LIVE_PEOPLE) $disp = displayDetailsByID($gid);
				if ($disp) {
					$indilines = split("\n", $indi["gedcom"]);
					$factrec = "";
					$lct = count($indilines);
					$text = "";
					for($i=1; $i<=$lct; $i++) {
						if ($i<$lct) $line = $indilines[$i];
						if (empty($line)) $line = " ";
						if ($i==$lct||($line{0}=="1")) {
							if (!empty($factrec)) {
								$ct = preg_match("/$query/i", $factrec, $match);
								if ($ct>0) {
									$text .= get_calendar_fact($factrec, $action, $filter);
								}
							}
							$factrec="";
						}
						$factrec.=$line."\n";
					}
					if (!empty($text)) {
						print "<a href=\"individual.php?pid=$gid&amp;GEDCOM=".$indi["file"]."\"><b>".$indi["name"]."</b>";
						if ($SHOW_ID_NUMBERS) print " &lrm;($gid)&lrm;";
						print "</a><br />\n";
						print "<div class=\"indent";
						if($TEXT_DIRECTION == "rtl"){
							print "_rtl";
						}
						print "\">";
						print $text;
						print "</div><br />";
					}
				}
			}
		}
		print "<br />\n\t\t</td>\n\t\t";
		if (count($myfamlist)>0) {
			//print "<td class=\"list_value\">";
			print "<td class=\"list_value\">";
			foreach($myfamlist as $gid=>$fam) {
				$display = true;
				$parents = find_parents($gid);
				if (!empty($parents["HUSB"])) {
					if (($filter=="living")&&(is_dead_id($parents["HUSB"])==1)) $display = false;
					else if ($HIDE_LIVE_PEOPLE) $display = displayDetailsByID($parents["HUSB"]);
				}
				if ($display) {
					if (!empty($parents["WIFE"])) {
						if (($filter=="living")&&(is_dead_id($parents["WIFE"])==1)) $display = false;
						else if ($HIDE_LIVE_PEOPLE) $display = displayDetailsByID($parents["WIFE"]);
					}
				}
		    	if ($display) {
					$indilines = split("\n", $fam["gedcom"]);
					$factrec = "";
					$lct = count($indilines);
					$text = "";
					for($i=1; $i<=$lct; $i++) {
						if ($i<$lct) $line = $indilines[$i];
						if (empty($line)) $line = " ";
						if ($i==$lct||($line{0}=="1")) {
							if (!empty($factrec)) {
								$ct = preg_match("/$query/i", $factrec, $match);
								if ($ct>0) {
									$text .= get_calendar_fact($factrec, $action, $filter);
								}
							}
							$factrec="";
						}
						$factrec.=$line."\n";
					}
					if (!empty($text)) {
						print "<a href=\"family.php?famid=$gid&amp;GEDCOM=".$fam["file"]."\"><b>".$fam["name"]."</b>";
						print "</a><br />\n";
						//print "<div class=\"indent\">";
						print "<div class=\"indent";
						if($TEXT_DIRECTION == "rtl"){
							print "_rtl";
						}
						print "\">";
						print $text;
						print "</div><br />";
					}
				}
			}
			print "<br />\n\t\t</td>";
		}
		print "</tr>\n\t</table>";
	}
	else print $pgv_lang["no_results"];
}
else if ($action=="calendar") {
	if($CALENDAR_FORMAT=="jewish" || $CALENDAR_FORMAT=="hebrew" ) { //since calendar is based on gregorian it doesn't make sense to not display the gregorian caption
		print "<span class=\"subheaders\">".$pgv_lang[strtolower($month)]." $year</span> &#160; \n";
	}
	if (empty($WEEK_START)) $WEEK_START="0";		//-- if the starting day for a week was not defined in the language file, then make it Sunday
	print "<font class=\"subheaders\">".$pgv_lang["in_this_month"]."<br />\n";
	print get_changed_date(" $month $year ")."</font><br /><br />\n";
	if ($view!="preview") {
		print "<form name=\"dateform\" method=\"get\" action=\"calendar.php\">";
		print "<input type=\"hidden\" name=\"action\" value=\"$action\" />";
		print $pgv_lang["day"]." <select name=\"day\">";
		for($i=1; $i<32; $i++) {
			print "<option value=\"$i\"";
			if ($i==$day) print " selected=\"selected\"";
			print ">$i</option>\n";
		}
		print "</select> ";
		print $pgv_lang["month"]." <select name=\"month\">";
		foreach($monthtonum as $mon=>$num) {
			print "<option value=\"$mon\"";
			if ($mon==strtolower($month)) print " selected=\"selected\"";
			print ">".$pgv_lang["$mon"]."</option>\n";
		}
		print "</select> ";
		print $pgv_lang["year"]." <input type=\"text\" name=\"year\" value=\"$year\" size=\"4\" /> ";
		print_help_link("annivers_date_select_help", "qm");
		print "<br />";
		print $pgv_lang["show"].":<select name=\"filter\">\n";
		print "<option value=\"all\"";
		if ($filter=="all") print " selected=\"selected\"";
		print ">".$pgv_lang["all_people"]."</option>\n";
		$username = getUserName();
		if (!$HIDE_LIVE_PEOPLE||(!empty($username))) {
			print "<option value=\"living\"";
			if ($filter=="living") print " selected=\"selected\"";
			print ">".$pgv_lang["living_only"]."</option>\n";
		}
		print "<option value=\"recent\"";
		if ($filter=="recent") print " selected=\"selected\"";
		print ">".$pgv_lang["recent_events"]."</option>\n";
		print "</select> ";
		print_help_link("annivers_show_help", "qm");
		print "<input type=\"submit\" value=\"".$pgv_lang["viewday"]."\" onclick=\"document.dateform.elements['action'].value='today';\" />\n";
		print "<input type=\"submit\" value=\"".$pgv_lang["viewmonth"]."\" onclick=\"document.dateform.elements['action'].value='calendar';\" />\n";
		print_help_link("day_month_help", "qm");
		print "</form><br />\n";
	}
	print "<table class=\"list_table, $TEXT_DIRECTION\">\n";
	print "\t<tr>\n";
	$days = array();
	$days[0] = "sunday";
	$days[1] = "monday";
	$days[2] = "tuesday";
	$days[3] = "wednesday";
	$days[4] = "thursday";
	$days[5] = "friday";
	$days[6] = "saturday";
	$j = $WEEK_START;
	for($i=0; $i<7; $i++) {
		print "\t\t<td class=\"list_label\">".$pgv_lang[$days[$j]]."</td>\n";
		$j++;
		if ($j>6) $j=0;
	}
	print "\t</tr>\n";
	$monthstart = mktime(1,0,0,$monthtonum[strtolower($month)],1,$year);
	$startday = date("w", $monthstart);
	$mmon = strtolower(date("M", $monthstart));
	$monthstart = $monthstart-(60*60*24*$startday);
	$monthstart += $WEEK_START*(60*60*24);
	$myindilist = array();
	$myfamlist = array();
	$query = "2 DATE [0-9]{1,2} $mmon";
	$myindilist = search_indis($query);
	$myfamlist = search_fams($query);
	for($k=0; $k<6; $k++) {
		print "\t<tr>\n";
		for($j=0; $j<7; $j++) {
			//print "\t\t<td class=\"list_value\">\n";
			print "\t\t<td class=\"list_value\">\n";
			$mday = date("j", $monthstart);
			$mmon = strtolower(date("M", $monthstart));
			if ($mmon==strtolower($month)) {
				$day = $mday;
				print "<span style=\"float: left\">" . "$mday" . "</span>";
				if ($CALENDAR_FORMAT=="hebrew_and_gregorian" || $CALENDAR_FORMAT=="hebrew" ) {
					$monthTemp = $monthtonum[$month];
					$jd = gregoriantojd($monthTemp, $mday, $year);
					$hebrewDate = jdtojewish($jd);
					list ($hebrewMonth, $hebrewDay, $hebrewYear) = split ('/', $hebrewDate);
					print "<span lang=\"he-IL\" dir=\"rtl\" style=\"float: right; color: blue\">" . getHebrewJewishDay($hebrewDay) . " " .getHebrewJewishMonth($hebrewMonth, $hebrewYear) . "</span>";
				} else if($CALENDAR_FORMAT=="jewish_and_gregorian" || $CALENDAR_FORMAT=="jewish" ) {
					$monthTemp = $monthtonum[$month];
					$jd = gregoriantojd($monthTemp, $mday, $year);
					$hebrewDate = jdtojewish($jd);
					list ($hebrewMonth, $hebrewDay, $hebrewYear) = split ('/', $hebrewDate);
					print "<span style=\"float: right; color: blue\">" . $hebrewDay . " " . getJewishMonthName($hebrewMonth, $hebrewYear) . "</span>";
				}
				print"<br />";
				$dayindilist = array();
				if ($mday<10) $query = "2 DATE 0?$mday $mmon";
				else $query = "2 DATE $mday $mmon";
				foreach($myindilist as $gid=>$indi) {
					if (preg_match("/$query/i", $indi["gedcom"])>0) $dayindilist[$gid]=$indi;
				}
				$dayfamlist = array();
				reset($myfamlist);
				foreach($myfamlist as $gid=>$fam) {
					if (preg_match("/$query/i", $fam["gedcom"])>0) $dayfamlist[$gid]=$fam;
				}
				uasort($dayindilist, "itemsort");
				uasort($dayfamlist, "famsort");
				print "<div id=\"day$k-$j\" class=\"details1\" style=\"width: 120px; height: 150px; overflow: auto;\">\n";
				if ((count($dayindilist)>0)||(count($dayfamlist)>0)) {
					foreach($dayindilist as $gid=>$indi) {
						$disp = true;
						if (($filter=="living")&&($indi["isdead"]==1)) $disp = false;
						else if ($HIDE_LIVE_PEOPLE) $disp = displayDetailsByID($gid);
				    	if ($disp) {
							$indilines = split("\n", $indi["gedcom"]);
							$factrec = "";
							$lct = count($indilines);
							$text = "";
							for($i=1; $i<=$lct; $i++) {
								if ($i<$lct) $line = $indilines[$i];
								if (empty($line)) $line = " ";
								if ($i==$lct||($line{0}=="1")) {
									if (!empty($factrec)) {
										$ct = preg_match("/$query/i", $factrec, $match);
										if ($ct>0) {
											$text .= get_calendar_fact($factrec, $action, $filter);
										}
									}
									$factrec="";
								}
								$factrec.=$line."\n";
							}
							if (!empty($text)) {
								print "<a href=\"individual.php?pid=$gid&amp;GEDCOM=".$indi["file"]."\"><b>".$indi["name"]."</b>";
								if ($SHOW_ID_NUMBERS) print " &lrm;($gid)&lrm;";
								print "</a><br />\n";
								//print "<div class=\"indent\">";
								print "<div class=\"indent";
								if($TEXT_DIRECTION == "rtl"){
									print "_rtl";
								}
								print "\">";
								print $text;
								print "</div><br />";
							}
						}
					}
					foreach($dayfamlist as $gid=>$fam) {
						$indilines = split("\n", $fam["gedcom"]);
						$factrec = "";
						$lct = count($indilines);
						$text = "";
						for($i=1; $i<=$lct; $i++) {
							if ($i<$lct) $line = $indilines[$i];
							if (empty($line)) $line = " ";
							if ($i==$lct||($line{0}=="1")) {
								if (!empty($factrec)) {
									$ct = preg_match("/$query/i", $factrec, $match);
									if ($ct>0) {
										$text .= get_calendar_fact($factrec, $action, $filter);
									}
								}
								$factrec="";
							}
							$factrec.=$line."\n";
						}
						if (!empty($text)) {
							$display = true;
							$parents = find_parents($gid);
							if (!empty($parents["HUSB"])) {
								if (($filter=="living")&&(is_dead_id($parents["HUSB"])==1)) $display = false;
								else if ($HIDE_LIVE_PEOPLE) $display = displayDetailsByID($parents["HUSB"]);
							}
							if ($display) {
								if (!empty($parents["WIFE"])) {
									if (($filter=="living")&&(is_dead_id($parents["WIFE"])==1)) $display = false;
									else if ($HIDE_LIVE_PEOPLE) $display = displayDetailsByID($parents["WIFE"]);
								}
							}
				    		if ($display) {
								print "<a href=\"family.php?famid=$gid&amp;GEDCOM=".$fam["file"]."\"><b>".$fam["name"]."</b>";
								print "</a><br />\n";
								//print "<div class=\"indent\">";
								print "<div class=\"indent";
								if($TEXT_DIRECTION == "rtl"){
									print "_rtl";
								}
								print "\">";
								print $text;
								print "</div><br />";
							}
						}
					}
				}
				print "</div>\n";
			}
			else print "<br />";
			print "\t\t</td>\n";
			$monthstart+=(60*60*24);
			$mmon = strtolower(date("M", $monthstart));
			if (($mmon!=strtolower($month)) && ($k>3)) {
				$k=6;
				//$j=7;
			}
		} //-- end day for loop
		print "\t</tr>\n";
	} //-- end week for loop
	print "</table>\n";
}
print "</div>";
print_footer();
?>
