<?php
/*=================================================
	Project: phpGedView
	File: clippings.php
	Author: John Finlay
	Input Variables: $action, $id, $type
	Comments:
		A cart with shopping cart type features for taking clippings from
		the GEDCOM file and creating a GEDCOM file for downloading.

	Change Log:
		7/10/02 - File Created
		9/24/02 - added support for language files

===================================================*/
# $Id: clippings.php,v 1.36.2.3 2004/01/29 20:03:29 yalnifj Exp $
// -- include config file
require("config.php");

if (!isset($ENABLE_CLIPPINGS_CART)) $ENABLE_CLIPPINGS_CART = false;
if (!$ENABLE_CLIPPINGS_CART)
{
  header("Location: index.php");
  exit;
} 

if (!isset($action)) $action="";

// -- print html header information
print_header($pgv_lang["clip_cart"]);
print_help_link("clip_cart_help", "page_help");
print "\r\n\t<h2>".$pgv_lang["clippings_cart"]."</h2>";


function same_group($a, $b) {
	if ($a['type']==$b['type']) return strnatcasecmp($a['id'], $b['id']);
	if ($a['type']=='source') return 1;
	if ($a['type']=='indi') return -1;
	if ($b['type']=='source') return -1;
	if ($b['type']=='indi') return 1;
	return 0;
}

function id_in_cart($id) {
	global $cart;
	$ct = count($cart);
	for($i=0; $i<$ct; $i++) {
		$temp = $cart[$i];
		if ($temp['id']==$id) {
			return true;
		}
	}
	return false;
}

function add_clipping($clipping) {
	global $cart, $pgv_lang;
	if (($clipping['id']==false)||($clipping['id']=="")) return;

	$ct = count($cart);
	if (!id_in_cart($clipping['id'])) {
		$cart[$ct]=$clipping;
		$gedrec = find_gedcom_record($clipping['id']);
		$st = preg_match_all("/\d SOUR @(.*)@/", $gedrec, $match, PREG_SET_ORDER);
		for($i=0; $i<$st; $i++) {
			$clipping = array();
			$clipping['type']="source";
			$clipping['id']=$match[$i][1];
			$ct = count($cart);
			if (!id_in_cart($clipping['id'])) {
				$cart[$ct]=$clipping;
			}
		}
		$nt = preg_match_all("/\d NOTE @(.*)@/", $gedrec, $match, PREG_SET_ORDER);
		for($i=0; $i<$nt; $i++) {
			$clipping = array();
			$clipping['type']="note";
			$clipping['id']=$match[$i][1];
			$ct = count($cart);
			if (!id_in_cart($clipping['id'])) {
				$cart[$ct]=$clipping;
			}
		}
	}
}

// --------------------------------- Recursive function to traverse the tree
function add_family_descendancy($famid) {
	global $cart;

	if (!$famid) return;
	/*
	print "add_family_descendancy(" . $famid . ")<br>";					# --------------
	*/
	$parents = find_parents($famid);
	$clipping = array();
	$clipping['type']="indi";
	$clipping['id']=$parents["HUSB"];
	add_clipping($clipping);
	$clipping = array();
	$clipping['type']="indi";
	$clipping['id']=$parents["WIFE"];
	add_clipping($clipping);
	$famrec = find_family_record($famid);
	if ($famrec) {
		$num = preg_match_all("/1\s*CHIL\s*@(.*)@/", $famrec, $smatch,PREG_SET_ORDER);
		for($i=0; $i<$num; $i++) {
			$cfamids = find_sfamily_ids($smatch[$i][1]);
			if (count($cfamids)>0) {
				foreach($cfamids as $cfamid) {
					$clipping = array();
					$clipping['type']="fam";
					$clipping['id']=$cfamid;
					add_clipping($clipping);		// add the childs family
					add_family_descendancy($cfamid);	// recurse on the childs family
				}
			}
			else {
				$clipping = array();
				$clipping['type']="indi";
				$clipping['id']=$smatch[$i][1];
				add_clipping($clipping);
			}
		}
	}
}

function add_family_members($famid) {
	global $cart;
	$parents = find_parents($famid);
	$clipping = array();
	$clipping['type']="indi";
	$clipping['id']=$parents["HUSB"];
	add_clipping($clipping);
	$clipping = array();
	$clipping['type']="indi";
	$clipping['id']=$parents["WIFE"];
	add_clipping($clipping);
	$famrec = find_family_record($famid);
	if ($famrec) {
		$num = preg_match_all("/1\s*CHIL\s*@(.*)@/", $famrec, $smatch,PREG_SET_ORDER);
		for($i=0; $i<$num; $i++) {
			$clipping = array();
			$clipping['type']="indi";
			$clipping['id']=$smatch[$i][1];
			add_clipping($clipping);
		}
	}
}

//-- recursively adds direct-line ancestors to cart
function add_ancestors($pid) {
	global $cart;
	$famids = find_family_ids($pid);
	if (count($famids)>0) {
		foreach($famids as $famid) {
			$clipping = array();
			$clipping['type']="fam";
			$clipping['id']=$famid;
			add_clipping($clipping);
			$parents = find_parents($famid);
			$clipping = array();
			$clipping['type']="indi";
			$clipping['id']=$parents["HUSB"];
			add_clipping($clipping);
			add_ancestors($parents["HUSB"]);
			$clipping = array();
			$clipping['type']="indi";
			$clipping['id']=$parents["WIFE"];
			add_clipping($clipping);
			add_ancestors($parents["WIFE"]);
		}
	}
}

//-- recursively adds direct-line ancestors and their families to the cart
function add_ancestors_families($pid) {
	global $cart;
	$famids = find_family_ids($pid);
	if (count($famids)>0) {
		foreach($famids as $famid) {
			$clipping = array();
			$clipping['type']="fam";
			$clipping['id']=$famid;
			add_clipping($clipping);
			$parents = find_parents($famid);
			$clipping = array();
			$clipping['type']="indi";
			$clipping['id']=$parents["HUSB"];
			add_clipping($clipping);
			add_ancestors_families($parents["HUSB"]);
			$clipping = array();
			$clipping['type']="indi";
			$clipping['id']=$parents["WIFE"];
			add_clipping($clipping);
			add_ancestors_families($parents["WIFE"]);
			$famrec = find_family_record($famid);
			if ($famrec) {
				$num = preg_match_all("/1\s*CHIL\s*@(.*)@/", $famrec, $smatch,PREG_SET_ORDER);
				for($i=0; $i<$num; $i++) {
					$clipping = array();
					$clipping['type']="indi";
					$clipping['id']=$smatch[$i][1];
					add_clipping($clipping);
				}
			}
		}
	}
}

//---------------------------- End function definition

if ($action=='add') {
	if ($type=='fam') {
		print "\r\n<form action=\"clippings.php\" method=\"get\">\r\n".$pgv_lang["which_links"]."<br />";
		print "\r\n\t<input type=\"hidden\" name=\"id\" value=\"$id\">";
		print "\r\n\t<input type=\"hidden\" name=\"type\" value=\"$type\">";
		print "\r\n\t<input type=\"hidden\" name=\"action\" value=\"add1\">";
		print "\r\n\t<input type=\"radio\" name=\"others\" value=\"none\">".$pgv_lang["just_family"]."<br />";
		print "\r\n\t<input type=\"radio\" name=\"others\" value=\"parents\">".$pgv_lang["parents_and_family"]."<br />";
		print "\r\n\t<input type=\"radio\" name=\"others\" selected value=\"members\">".$pgv_lang["parents_and_child"]."<br />";
		print "\r\n\t<input type=\"radio\" name=\"others\" value=\"descendants\">".$pgv_lang["parents_desc"]."<br />";
		print "\r\n\t<input type=\"submit\" value=\"".$pgv_lang["continue"]."\"><br />\r\n\t</form>";
	}
	else if ($type=='indi') {
		print "\r\n<form action=\"clippings.php\" method=\"get\">\r\n".$pgv_lang["which_p_links"]."<br />";
		print "\r\n\t<input type=\"hidden\" name=\"id\" value=\"$id\">";
		print "\r\n\t<input type=\"hidden\" name=\"type\" value=\"$type\">";
		print "\r\n\t<input type=\"hidden\" name=\"action\" value=\"add1\">";
		print "\r\n\t<input type=\"radio\" name=\"others\" value=\"none\">".$pgv_lang["just_person"]."<br />";
		print "\r\n\t<input type=\"radio\" name=\"others\" value=\"parents\">".$pgv_lang["person_parents_sibs"]."<br />";
		print "\r\n\t<input type=\"radio\" name=\"others\" value=\"ancestors\">".$pgv_lang["person_ancestors"]."<br />";
		print "\r\n\t<input type=\"radio\" name=\"others\" value=\"ancestorsfamilies\">".$pgv_lang["person_ancestor_fams"]."<br />";
		print "\r\n\t<input type=\"radio\" name=\"others\" selected value=\"members\">".$pgv_lang["person_spouse"]."<br />";
		print "\r\n\t<input type=\"radio\" name=\"others\" value=\"descendants\">".$pgv_lang["person_desc"]."<br />";
		print "\r\n\t<input type=\"submit\" value=\"".$pgv_lang["continue"]."\"><br />\r\n\t</form>";
	}
	else {
		$action='add1';
	}
}

if ($action=='add1') {
	$clipping = array();
	$clipping['type']=$type;
	$clipping['id']=$id;
	add_clipping($clipping);
	if ($type=='fam') {
		if ($others=='parents') {
			$parents = find_parents($id);
			$clipping = array();
			$clipping['type']="indi";
			$clipping['id']=$parents["HUSB"];
			add_clipping($clipping);
			$clipping = array();
			$clipping['type']="indi";
			$clipping['id']=$parents["WIFE"];
			add_clipping($clipping);
		}
		else if ($others=="members") {
			add_family_members($id);
		}
		else if ($others=="descendants") {
			add_family_descendancy($id);
		}
	}
	else if ($type=='indi') {
		if ($others=='parents') {
			$famid = find_family_id($id);
			if ($famid) {
				$clipping = array();
				$clipping['type']="fam";
				$clipping['id']=$famid;
				add_clipping($clipping);
				add_family_members($famid);
			}
		}
		else if ($others=='ancestors') {
			add_ancestors($id);
		}
		else if ($others=='ancestorsfamilies') {
			add_ancestors_families($id);
		}
		else if ($others=='members') {
			$famid = find_sfamily_id($id);
			if ($famid) {
				$clipping = array();
				$clipping['type']="fam";
				$clipping['id']=$famid;
				add_clipping($clipping);
				add_family_members($famid);
			}
		}
		else if ($others=='descendants') {
			$famid = find_sfamily_id($id);
			if ($famid) {
				$clipping = array();
				$clipping['type']="fam";
				$clipping['id']=$famid;
				add_clipping($clipping);
				add_family_descendancy($famid);
			}
		}
	}
}
else if($action=='remove') {
	$ct = count($cart);
	for($i=$item+1; $i<$ct; $i++) {
		$cart[$i-1] = $cart[$i];
	}
	unset($cart[$ct-1]);
}
else if($action=='empty') {
	$cart = array();
	$_SESSION["clippings"] = "";
}
else if($action=='download') {
	$path = substr($PHP_SELF, 0, strrpos($PHP_SELF, "/")+1);
	if ($SERVER_URL[strlen($SERVER_URL)-1] == "/")
	{
	  $dSERVER_URL = substr($SERVER_URL, 0, strlen($SERVER_URL) - 1);
	}
	else $dSERVER_URL = $SERVER_URL;
	usort($cart, "same_group");
	$media = array();
	$mediacount=0;
	$ct = count($cart);
	$filetext = "0 HEAD\r\n1 SOUR phpGedView\r\n2 NAME phpGedView\r\n2 VERS $VERSION\r\n2 CORP PhpGedView\r\n1 DEST DISKETTE\r\n1 DATE 28 JUL 2001\r\n1 FILE clipping.ged\r\n1 GEDC\r\n2 VERS 5.5\r\n2 FORM LINEAGE-LINKED\r\n1 CHAR $CHARACTER_SET\r\n";
	for($i=0; $i<$ct; $i++)
	{
		$clipping = $cart[$i];
		$record = find_gedcom_record($clipping['id']);
		if ($clipping['type']=='indi')
		{
			if (displayDetails($record)) {
				$ft = preg_match_all("/1 FAMC @(.*)@/", $record, $match, PREG_SET_ORDER);
				for ($k=0; $k<$ft; $k++) {
					if (!id_in_cart($match[$k][1])) {
						$record = preg_replace("/1 FAMC @".$match[$k][1]."@.*/", "", $record);
					}
				}
				$ft = preg_match_all("/1 FAMS @(.*)@/", $record, $match, PREG_SET_ORDER);
				for ($k=0; $k<$ft; $k++) {
					if (!id_in_cart($match[$k][1])) {
						$record = preg_replace("/1 FAMS @".$match[$k][1]."@.*/", "", $record);
					}
				}
				$ft = preg_match_all("/\d FILE (.*)/", $record, $match, PREG_SET_ORDER);
				for ($k=0; $k<$ft; $k++) {
					$filename = extract_filename(trim($match[$k][1]));
					$media[$mediacount]=$filename;
					$filename = substr($match[$k][1], strrpos($match[$k][1], "\\")+1);
					$mediacount++;
					$record = preg_replace("|(\d FILE )".addslashes($match[$k][1])."|", "$1".$filename, $record);
				}
				$record = preg_replace("/(\r?\n)+/", "$1", $record);
				$filetext .= trim($record)."\r\n";
			}
			else
			{
			  $filetext .= "0 @".$clipping['id']."@ INDI\r\n";
			  
			  /*
			  # removed by Kurt for more security???
			  # Don't know if this part is of use anymore???
			  
			  $lines = preg_split("/\r?\n/", $record);
			  for ($j=0; $j<count($lines); $j++) {
			  	if (strstr($lines[$j], "1 NAME")) {
			  		$k=$j+1;
			  		$filetext .= $lines[$j]."\r\n";
			  		while($lines[$k]{0}>1) {
			  			$filetext .= $lines[$k]."\r\n";
			  			$k++;
			  		}
			  		break;
			  	}
			  }
			  */
			  
		  $indirec = find_person_record($clipping['id']);
		  # if (displayDetails($indirec) or showLivingName($indirec))
		  $id_ok = false;
		  if (showLivingName($indirec))
		  {
		    $id_ok = true;
		  }
		  else
		  {
		    $id_ok = false;
		  }

			  if (!$id_ok)
			  {
			    /* hide living names */
			    $filetext .= "1 NAME " . $pgv_lang["private"] . " /" . $pgv_lang["private"] . "/" . "\r\n";
			    $filetext .= "2 SURN " . $pgv_lang["private"] . "\r\n";
			    $filetext .= "2 GIVN " . $pgv_lang["private"] . "\r\n";
			  }
			  else
			  {
			    $lines = preg_split("/\r?\n/", $record);
			    for ($j=0; $j<count($lines); $j++)
			    {
			      if (strstr($lines[$j], "1 NAME"))
			      {
			        $k=$j+1;
			        $filetext .= $lines[$j]."\r\n";
			        while($lines[$k]{0}>1)
			        {
			          $filetext .= $lines[$k]."\r\n";
			          $k++;
			        }
			        break;
			      }
			    }
			  }
			  
			  $myRecord = array();
			  $myRecord_FAMC_ct = 0;
			  $myRecord_FAMS_ct = 0;
			  
			  $ft = preg_match_all("/1 FAMC @(.*)@/", $record, $match, PREG_SET_ORDER);
			  for ($k=0; $k<$ft; $k++)
			  {
			    if (!id_in_cart($match[$k][1]))
			    {
			      /* if the FAMS is not in the list delete the record of it */
			      $record = preg_replace("/1 FAMC @".$match[$k][1]."@.*/", "", $record);
			    }
			    else
			    {
			      $myRecord_FAMC_ct++;
			      $myRecord['famc'][$myRecord_FAMC_ct] = $match[$k][1];
			    }
			  }
			  
			  $ft = preg_match_all("/1 FAMS @(.*)@/", $record, $match, PREG_SET_ORDER);
			  for ($k=0; $k<$ft; $k++)
			  {
			    if (!id_in_cart($match[$k][1]))
			    {
			      /* if the FAMS is not in the list delete the record of it */
			      $record = preg_replace("/1 FAMS @".$match[$k][1]."@.*/", "", $record);
			    }
			    else
			    {
			      $myRecord_FAMS_ct++;
			      $myRecord['fams'][$myRecord_FAMS_ct] = $match[$k][1];
			    }
			  }
			  
			  if ($myRecord_FAMC_ct > 0)
			  {
			    for ($k = 1; $k <= sizeof($myRecord['famc']); $k++)
			    {
			      if (isset($myRecord['famc'])) $filetext .= "1 FAMC @".$myRecord['famc'][$k]."@\r\n";
			    }
			  }
			  
			  if ($myRecord_FAMS_ct > 0)
			  {
			    for ($k = 1; $k <= sizeof($myRecord['fams']); $k++)
			    {
			      if (isset($myRecord['fams'])) $filetext .= "1 FAMS @".$myRecord['fams'][$k]."@\r\n";
			    }
			  }
			  $filetext .= "1 NOTE ".$pgv_lang["person_private"]."\r\n";
			}
			$filetext .= "1 SOUR @SPGV1@\r\n";
			$filetext .= "2 PAGE ".$dSERVER_URL.$path."individual.php?pid=".$clipping['id']."\r\n";
			$filetext .= "2 DATA\r\n";
			$filetext .= "3 TEXT ".$pgv_lang["indi_downloaded_from"]."\r\n";
			$filetext .= "4 CONT ".$dSERVER_URL.$path."individual.php?pid=".$clipping['id']."\r\n";
		}
		else if ($clipping['type']=='fam')
		     {
		       # START added by Kurt
		       $myRecord = array();
		       $myRecord_child_ct = 0;
		       $myRecord_husb_ct = 0;
		       $myRecord_wife_ct = 0;
		       # END added by Kurt
		       
		       $ft = preg_match_all("/1 CHIL @(.*)@/", $record, $match, PREG_SET_ORDER);
		       for ($k=0; $k<$ft; $k++)
		       {
		       	 if (!id_in_cart($match[$k][1]))
		       	 {
		       	   /* if the child is not in the list delete the record of it */
		       	   $record = preg_replace("/1 CHIL @".$match[$k][1]."@.*/", "", $record);
		       	 }
		       	 # START added by Kurt
		       	 else
		       	 {
		       	   $myRecord_child_ct++;
		       	   $myRecord['child'][$myRecord_child_ct] = $match[$k][1];
		       	 }
		       	 # END added by Kurt
		       }
		       
		       $ft = preg_match_all("/1 HUSB @(.*)@/", $record, $match, PREG_SET_ORDER);
		       for ($k=0; $k<$ft; $k++)
		       {
		       	 if (!id_in_cart($match[$k][1]))
		       	 {
		       	   /* if the husband is not in the list delete the record of him */
		       	   $record = preg_replace("/1 HUSB @".$match[$k][1]."@.*/", "", $record);
		       	 }
		       	 # START added by Kurt
		       	 else
		       	 {
		       	   $myRecord_husb_ct++;
		       	   $myRecord['husb'][$myRecord_husb_ct] = $match[$k][1];
		       	 }
		       	 # END added by Kurt
		       }
		       
		       $ft = preg_match_all("/1 WIFE @(.*)@/", $record, $match, PREG_SET_ORDER);
		       for ($k=0; $k<$ft; $k++)
		       {
		       	 if (!id_in_cart($match[$k][1]))
		       	 {
		       	   /* if the wife is not in the list delete the record of her */
		       	   $record = preg_replace("/1 WIFE @".$match[$k][1]."@.*/", "", $record);
		       	 }
		       	 # START added by Kurt
		       	 else
		       	 {
		       	   $myRecord_wife_ct++;
		       	   $myRecord['wife'][$myRecord_wife_ct] = $match[$k][1];
		       	 }
		       	 # END added by Kurt
		       }
		       
		       $ft = preg_match_all("/\d FILE (.*)/", $record, $match, PREG_SET_ORDER);
		       for ($k=0; $k<$ft; $k++)
		       {
		       	 $filename = substr($match[$k][1], strrpos($match[$k][1], "\\")+1);
		       	 $media[$mediacount]=$filename;
		       	 $mediacount++;
		       	 $record = preg_replace("/(\d FILE )".addslashes($match[$k][1])."/", "$1".$filename, $record);
		       }
		       
		       # START added by Kurt
		       $Myfamrec = find_family_record($clipping['id']);
		       
		       $husb_ok = true;
		       $ct01 = preg_match("/1 HUSB @(.*)@/", $Myfamrec, $match);
		       if ($ct01 > 0)
		       {
		       	 $indirec = find_person_record($match[1]);
		       	 if (displayDetails($indirec) and showLivingName($indirec))
		       	 {
		       	   $husb_ok = true;
		       	 }
		       	 else
		       	 {
		       	   $husb_ok = false;
		       	 }
		       }
		       
		       $wife_ok = true;
		       $ct02 = preg_match("/1 WIFE @(.*)@/", $Myfamrec, $match);
		       if ($ct01 > 0)
		       {
		       	 $indirec = find_person_record($match[1]);
		       	 if (displayDetails($indirec) and showLivingName($indirec))
		       	 {
		       	   $wife_ok = true;
		       	 }
		       	 else
		       	 {
		       	   $wife_ok = false;
		       	 }
		       }
		       # END added by Kurt
		       if ((!$husb_ok) or (!$wife_ok))
		       {
		       	 $filetext .= "0 @".$clipping['id']."@ FAM"."\r\n";
		       	 if ($myRecord_husb_ct > 0)
		       	 {
		       	   for ($k = 1; $k <= sizeof($myRecord['husb']); $k++)
		       	   {
			     $filetext .= "1 HUSB @".$myRecord['husb'][$k]."@\r\n";
			   }
			 }
			 
			 if ($myRecord_wife_ct > 0)
			 {
			   for ($k = 1; $k <= sizeof($myRecord['wife']); $k++)
			   {
			     $filetext .= "1 WIFE @".$myRecord['wife'][$k]."@\r\n";
			   }
			 }
			 
			 if ($myRecord_child_ct > 0)
			 {
			   for ($k = 1; $k <= sizeof($myRecord['child']); $k++)
			   {
			     if (isset($myRecord['child'])) $filetext .= "1 CHIL @".$myRecord['child'][$k]."@\r\n";
			   }
			 }
		       }
		       else
		       {
		       	 $record = preg_replace("/(\r?\n)+/", "$1", $record);
		       	 $filetext .= trim($record)."\r\n";
		       }
		       
		       $filetext .= "1 SOUR @SPGV1@\r\n";
		       $filetext .= "2 PAGE ".$dSERVER_URL.$path."family.php?famid=".$clipping['id']."\r\n";
		       $filetext .= "2 DATA\r\n";
		       $filetext .= "3 TEXT ".$pgv_lang["family_downloaded_from"]."\r\n";
		       $filetext .= "4 CONT ".$dSERVER_URL.$path."family.php?famid=".$clipping['id']."\r\n";
		     }
		     else $filetext .= trim($record)."\r\n";
		     
		     if($clipping['type']=="source")
		     {
		       $st = preg_match_all("/\d REPO @(.*)@/", $record, $match, PREG_SET_ORDER);
		       for($j=0; $j<$st; $j++)
		       {
		       	 $reporec = find_gedcom_record($match[$j][1]);
		       	 $filetext .= $reporec;
		       }
		       $filetext .= "1 NOTE ".$pgv_lang["source_downloaded_from"]."\r\n";
		       $filetext .= "2 CONT ".$dSERVER_URL.$path."source.php?sid=".$clipping['id']."\r\n";
		     }
	}
	$filetext .= "0 @SPGV1@ SOUR\r\n";
	$tuser = getUser($CONTACT_EMAIL);
	if ($tuser) {
		$filetext .= "1 AUTH ".$tuser["fullname"]."\r\n";
	}
	$filetext .= "1 TITL ".$HOME_SITE_TEXT."\r\n";
	$filetext .= "1 ABBR ".$HOME_SITE_TEXT."\r\n";
	$filetext .= "1 PUBL ".$HOME_SITE_URL."\r\n";
	$filetext .= "0 TRLR\r\n";
	$_SESSION["clippings"] = $filetext;
	print "\r\n\t<br /><br />".$pgv_lang["download"]."<br /><br /><ul><li>".$pgv_lang["gedcom_file"]."</li><ul><li><a href=\"clippings_download.php\">clipping.ged</a></li></ul><br />";
	if ($mediacount>0) {
		// -- create zipped media file
		print "<li>".$pgv_lang["media_files"]."</li><ul>";
		for($m=0; $m<$mediacount; $m++) {
			print "<li><a href=\"".$MEDIA_DIRECTORY."$media[$m]\">".substr($media[$m], strrpos($media[$m], "/")+1)."</a></li>";
		}
		print "</ul>";
	}
	print "</ul><br /><br />";
}
$ct = count($cart);
if($ct==0) {

	// -- new lines, added by Jans, to display helptext when cart is empty
	if (!$action=='add') {
		require $PGV_BASE_DIRECTORY.$helptextfile["english"];
		if (file_exists($PGV_BASE_DIRECTORY.$helptextfile[$LANGUAGE])) require $PGV_BASE_DIRECTORY.$helptextfile[$LANGUAGE];
		print $pgv_lang["clip_cart_help"];
	}
	// -- end new lines 
	print "\r\n\t\t<br /><br />".$pgv_lang["cart_is_empty"]."<br /><br />";
}
else {
	print "\r\n\t<table class=\"list_table\">\r\n\t\t<tr>\r\n\t\t\t<td class=\"list_label\">".$pgv_lang["type"]."</td><td class=\"list_label\">".$pgv_lang["id"]."</td><td class=\"list_label\">".$pgv_lang["name_description"]."</th><td class=\"list_label\">".$pgv_lang["remove"]."</td>\r\n\t\t</tr>";
	for($i=0; $i<$ct; $i++) {
		print "\r\n\t\t<tr>\r\n\t\t<td class=\"list_value\">";
		$clipping = $cart[$i];
		if($clipping['type']=='indi') print "<img src=\"$PGV_IMAGE_DIR/$PGV_INDIS_IMG\" border=\"0\">";
		else if($clipping['type']=='fam') print "<img src=\"$PGV_IMAGE_DIR/$PGV_SFAMILY_IMG\" border=\"0\">";
		else if($clipping['type']=='source') print "<img src=\"$PGV_IMAGE_DIR/$PGV_SOURCE_IMG\" border=\"0\">";
		print "</td><td class=\"list_value\">".$clipping['id']."</td><td class=\"list_value\">";
		
		# if($clipping['type']=='indi') print "<a href=\"individual.php?pid=".$clipping['id']."\">".get_sortable_name($clipping['id'])."</a>";
		$id_ok = true;
		if($clipping['type']=='indi')
		{
		  $indirec = find_person_record($clipping['id']);
		  if (displayDetails($indirec) or showLivingName($indirec))
		  {
		    $id_ok = true;
		  }
		  else
		  {
		    $id_ok = false;
		  }
		  if ($id_ok) $dName = get_sortable_name($clipping['id']); else $dName = $pgv_lang["person_private"];
		  print "<a href=\"individual.php?pid=".$clipping['id']."\">".$dName."</a>";
		}
		# else if($clipping['type']=='fam') print "<a href=\"family.php?famid=".$clipping['id']."\">".get_family_descriptor($clipping['id'])."</a>";
		else
		{
		  if($clipping['type']=='fam')
		  {
		    $famrec = find_family_record($clipping['id']);

		    $husb_ok = true;
		    $ct01 = preg_match("/1 HUSB @(.*)@/", $famrec, $match);
		    if ($ct01 > 0)
		    {
		      $indirec = find_person_record($match[1]);
		      if (displayDetails($indirec) or showLivingName($indirec))
		      {
		      	$husb_ok = true;
		      }
		      else
		      {
		      	$husb_ok = false;
		      }
		    }

		    $wife_ok = true;
		    $ct02 = preg_match("/1 WIFE @(.*)@/", $famrec, $match);
		    if ($ct02 > 0)
		    {
		      $indirec = find_person_record($match[1]);
		      if (displayDetails($indirec) or showLivingName($indirec))
		      {
		      	$wife_ok = true;
		      }
		      else
		      {
		      	$wife_ok = false;
		      }
		    }
		    if (($husb_ok) and ($wife_ok)) $dName = get_family_descriptor($clipping['id']); else $dName = $pgv_lang["family_private"];
		    print "<a href=\"family.php?famid=".$clipping['id']."\">".$dName."</a>";
		  }
		  else # if($clipping['type']=='source') print "<a href=\"source.php?sid=".$clipping['id']."\">".get_source_descriptor($clipping['id'])."</a>";
		  {
		    if($clipping['type']=='source')
		    {
		      # $indirec = find_person_record($clipping['id']);
		      # print "-".$clipping['id']."-";
		      # print "-".$indirec."-";
		      # print "-".get_source_descriptor($clipping['id'])."-";
		      # if (isset($sourcelist[$clipping['id']])) print preg_replace("/\\\'/", "'", $sourcelist[$clipping['id']]["gedcom"]);
		      # exit;
		      print "<a href=\"source.php?sid=".$clipping['id']."\">".get_source_descriptor($clipping['id'])."</a>";
		    }
		  }
		}
		print "</td><td class=\"list_value\"><a href=\"clippings.php?action=remove&item=$i\">".$pgv_lang["remove"]."</a>\r\n\t\t</tr>";
	}
	print "\r\n\t</table>";
	if ($action != 'download') {
		print "\r\n\t<br /><a href=\"clippings.php?action=download\">".$pgv_lang["download_now"]."  "."</a>";
		print_help_link("clip_download_help", "qm");
		print "<br />";
	}
	print "\r\n\t<br /><a href=\"clippings.php?action=empty\">".$pgv_lang["empty_cart"]."  "."</a>";
	print_help_link("empty_cart_help", "qm");
}
if (isset($_SESSION["cart"])) $_SESSION["cart"]=$cart;
print_footer();
?>
