<?php
/*=================================================
	Project: phpGedView
	File: config.php
	Author: John Finlay
	Comments:
		Configuration file for PHPGedView

	phpGedView: Genealogy Viewer
    Copyright (C) 2002 to 2003  John Finlay and Others

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
    
===================================================*/
# $Id: config.php,v 1.77.2.1 2004/01/27 20:49:07 yalnifj Exp $

/*
	This is the main configuration file for phpGedView and defines
	which gedcoms will be used with this site.  The gedcom array
	looks like this:
	$gedarray = array();
	$gedarray["gedcom"] = "surname.ged";
	$gedarray["config"] = "config_gedcom.php";
	$gedarray["privacy"] = "privacy.php";
	$gedarray["title"] = "Surname Genealogy";
	$gedarray["path"] = "./surname.ged";
*/

if (preg_match("/\Wconfig.php/", $_SERVER["PHP_SELF"])>0) {
	print "Got your hand caught in the cookie jar.";
	exit;
}

$PGV_BASE_DIRECTORY = "";						//-- path to phpGedView (Only needed when running as phpGedView from another php program such as postNuke, otherwise leave it blank)
$PGV_DATABASE = "index";						//-- which database is being used, file indexes or mysql
$DBHOST = "localhost";							//-- Host where MySQL database is kept
$DBUSER = "";								//-- MySQL database User Name
$DBPASS = "";							//-- MySQL database User Password
$DBNAME = "phpgedview";							//-- The MySQL database name where you want PHPGedView to build its tables
$TBLPREFIX = "pgv_";							//-- prefix to include on table names
$INDEX_DIRECTORY = "./index/";					//-- Readable and Writeable Directory to store index files (include the trailing "/")
$AUTHENTICATION_MODULE = "authentication_index.php";	//-- File that contains authentication functions
$USE_REGISTRATION_MODULE = false;				//-- turn on the user self registration module
$ALLOW_USER_THEMES = false;						//-- Allow user to set their own theme
$DEFAULT_GEDCOM = "";							//-- In a multi-gedcom environment, this is the gedcom to default to
$ALLOW_CHANGE_GEDCOM = true;					//-- A true value will provide a link in the footer to allow users to change the gedcom they are viewing
$LOGFILE_CREATE = "monthly";					//-- set how often new log files are created, "none" turns logs off, "daily", "weekly", "monthly", "yearly"
$PGV_SESSION_SAVE_PATH = "";					//-- Path to save PHP session Files -- DO NOT MODIFY unless you know what you are doing
												//-- leaving it blank will use the default path for your php configuration as found in php.ini
$PGV_SESSION_TIME = "7200";						//-- number of seconds to wait before an inactive session times out
$SERVER_URL = "";								//-- the URL used to access this server



//--START GEDCOM CONFIGURATIONS
$GEDCOMS = array();
//--END GEDCOM CONFIGURATIONS

$CONFIGURED = false;
require_once($PGV_BASE_DIRECTORY."session.php");
?>