<?php
/*=================================================
	Project: phpGedView
	File: config_gedcom.php
	Author: John Finlay
	Comments:
		Configuration file for PHPGedView

	phpGedView: Genealogy Viewer
    Copyright (C) 2002 to 2003  John Finlay and Others

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

===================================================*/
# $Id: config_gedcom.php,v 1.27.2.3 2004/01/27 21:25:22 yalnifj Exp $

if (preg_match("/\Wconfig_gedcom\.php/", $_SERVER["PHP_SELF"])>0) {
	print "Naughty, Naughty, Naughty!";
	exit;
}
if (preg_match("/_conf\.php/", $_SERVER["PHP_SELF"])>0) {
	print "Naughty, Naughty, Naughty!";
	exit;
}

//-- This is a gedcom configuration file for phpGedView
//-- You should not have to edit this file manually.  All editing of this
//-- file can be done through the online configuration script by pointing
//-- your browser to phpGedView/editconfig.php

//-- assign the default language.  User can override this setting if $ENABLE_MULTI_LANGUAGE = true
$LANGUAGE = "english";

$CALENDAR_FORMAT = "gregorian";			//-- Translate dates to the specified Calendar
										//-- options are gregorian, julian, french, jewish, jewish_and_gregorian,
										//-- hebrew, hebrew_and_gregorian
$DISPLAY_JEWISH_THOUSANDS = true;		//-- show Alafim in Jewish dates Similar to php 5.0 CAL_JEWISH_ADD_ALAFIM
$DISPLAY_JEWISH_GERESHAYIM = true;		//-- show single and double quotes in Hebrew dates. Similar to php 5.0 CAL_JEWISH_ADD_GERESHAYIM
$JEWISH_ASHKENAZ_PRONUNCIATION = true;	//-- Jewish pronunciation option

$CHARACTER_SET = "UTF-8";				//-- This is the character set of your gedcom file.  UTF-8 is the default and should work for
										//-- almost all sites.  If you export your gedcom using ibm windows encoding, then you should put
										//-- WINDOWS here.
										//-- NOTE: PHP does NOT support UNICODE so don't try it :-)
										
$CREATE_GENDEX = true;					//-- whether or not to create a gendex file when importing your gedcom.  The gendex file will be placed in
										//-- the index directory

$ENABLE_MULTI_LANGUAGE = true;			//-- set to true to give users the option of selecting a different language from
										//-- a dropdown list in the footer and default to the language they have set in their browser settings
$DEFAULT_PEDIGREE_GENERATIONS = "4";	// -- set the default number of generations to display on the pedigree charts
$MAX_PEDIGREE_GENERATIONS = "10";		// -- set the max number of generations to display on the pedigree charts
$MAX_DESCENDANCY_GENERATIONS = "15";	// -- set the max number of generations to display on the descendancy charts
$USE_RIN = false;						// -- Use the RIN # instead of the regular GEDCOM ID for places where you are asked to enter an ID
$PEDIGREE_ROOT_ID = "I1";				// -- use this line to change the default person who appears on
										// -- the Pedigree tree
$GEDCOM_ID_PREFIX = "I";				// -- This is the prefix to prepend to ID numbers typed in the ID boxes on charts
$PEDIGREE_FULL_DETAILS = true;			// -- Show the birth and death details of an individual on the pedigree tree
$PEDIGREE_LAYOUT = true;					// -- Set to true for Landscape mode, false for portrait mode
$SHOW_EMPTY_BOXES = true;				// -- Show empty boxes on charts if the person is unknown
$ZOOM_BOXES = "click";				// -- When should pedigree boxes zoom.  Values are "disabled", "mouseover", "click"
$LINK_ICONS = "mouseover";				// -- When should pedigree box extra links show up.  Values are "disabled", "mouseover", "click"

$HIDE_LIVE_PEOPLE   = true;				// -- a false value will show details of people who are still alive
$REQUIRE_AUTHENTICATION = false;		// -- set this to try to force all visitors to login before they can view anything on the site
$CHECK_CHILD_DATES  = true;             // -- When checking if a person is alive, check the children's birth dates in addition to the person's
$MAX_ALIVE_AGE      = "120";              // -- Any person born more than MAX_ALIVE_AGE years ago is assumed deceased
$SHOW_GEDCOM_RECORD = true;				// -- a true value will provide a link on detail pages that will
										// --allow people to view the actual lines from the gedcom file
$ALLOW_EDIT_GEDCOM = true;				//-- allow users with canEdit privileges to edit the gedcom

$ALPHA_INDEX_LISTS = true;				// -- for very long individual and family lists, set this to true to split the list into
										// -- pages by the first letter of their last name.

$NAME_FROM_GEDCOM = false;				// -- By default phpGedView uses the name stored in the indexes to get a person's name
										// -- With some gedcom formats the sortable name stored in the indexes does not get
										// -- displayed properly and the best way to get the correct display name is from the gedcom
										// -- However, retrieving the name from the gedcom will slow the program down.

$SHOW_ID_NUMBERS = true;				// -- Show gedcom id numbers on charts next to individual names
$SHOW_PEDIGREE_PLACES = "9";			// -- What level to show the birth and death places next to the birth and death dates on the pedigree and descendency charts.

$MULTI_MEDIA = true;            		// -- if you have no multi-media files, set this to false
$MEDIA_DIRECTORY = "./media/";			// -- Directoroy where media files are stored
$MEDIA_DIRECTORY_LEVELS = "0";			// -- the number of sub-directories to keep when getting names of media files
$SHOW_HIGHLIGHT_IMAGES = true;			// -- show highlighted photos on pedigree tree and individual pages.
$ENABLE_CLIPPINGS_CART = true;			// -- allow tree clippings to be saved in a shopping cart style for download as a
										// -- GEDCOM and imported into other users programs

$HIDE_GEDCOM_ERRORS = false;			//-- a true value will disable error messages for undefined GEDCOM codes.  See the
										//-- non-standard gedcom codes section of the readme file for more information.

$WORD_WRAPPED_NOTES = false;			//-- some programs wrap notes at word boundaries while others wrap notes anywhere
										//-- setting this to true will add a space between words where they are wrapped in the gedcom

$SHOW_CONTEXT_HELP = true;				// show ? links on the page for contextual popup help
$CONTACT_EMAIL   = "you@yourdomain.com";		    // -- this is who the user should contact for more information
$CONTACT_METHOD = "messaging2";						// -- the method to allow users to contact you. options are: mailto, messaging, messaging2
$WEBMASTER_EMAIL = "webmaster@yourdomain.com";		// -- this is who the user should contact in case of errors
$SUPPORT_METHOD = "messaging2";						// -- the method to allow users to contact you. options are: mailto, messaging, messaging2
$HOME_SITE_URL   = "http://www.phpgedview.net";     // -- url for your home page
$HOME_SITE_TEXT  = "About PhpGedView";                     // -- name of your site
$FAVICON = "images/favicon.ico";                          // -- change to point to your favicon, either relative or absolute
$THEME_DIR = "themes/standard/";					// -- directory where display theme files are kept
if (substr ($THEME_DIR, -1) != "/") $THEME_DIR = $THEME_DIR . "/";

$SHOW_STATS = false;					//-- Show execution stats at the bottom of the page

// -- amount of time to execute before quitting in seconds
// -- set this to 0 to remove all time limits
$TIME_LIMIT = "60";

@set_time_limit($TIME_LIMIT);
if (file_exists($PGV_BASE_DIRECTORY.$THEME_DIR."theme.php")) require($PGV_BASE_DIRECTORY.$THEME_DIR."theme.php");
else {
	$THEME_DIR = $PGV_BASE_DIRECTORY."themes/standard/";
	require($THEME_DIR."theme.php");
}

?>