<?php
/*=================================================
	Project: phpGedView
	File: descendancy.php
	Author: John Finlay
	Input Variables: $pid
	Comments:
		Parses gedcom file and displays a descendancy tree.  Specify a $pid to
		root the tree at a certain person with id = $pid in the
		GEDCOM file.

	Change Log:
		6/19/02 - File Created
		12/2/02 - Updated to fix multiple families and partial parents
		12/27/02 - updated so that marriage popups are above other boxes
		2/13/03 - Fixed overlapping boxes on multiple marriages.
===================================================*/
# $Id: descendancy.php,v 1.60 2004/01/16 03:19:56 kosherjava Exp $
// -- include config file
require("config.php");
require($PGV_BASE_DIRECTORY.$factsfile["english"]);
require($PGV_BASE_DIRECTORY.$factsfile[$LANGUAGE]);

if (!isset($show_full)) $show_full=$PEDIGREE_FULL_DETAILS;
if (!isset($generations)) $generations = 10;
if ($generations > $MAX_DESCENDANCY_GENERATIONS) $generations = $MAX_DESCENDANCY_GENERATIONS;

if ($show_full==false) {
	$Dbheight=25;
	$Dbwidth-=40;
}

$pDbwidth = $Dbwidth;
$pDbheight = $Dbheight;
//-- Adjust for mozilla weirdness
//$is_gecko = preg_match("/gecko/i", $_SERVER["HTTP_USER_AGENT"]);
//if ($is_gecko>0) {
	$pDbwidth = $Dbwidth+4;
	$pDbheight = $Dbheight+6;
//}

$bwidth=$Dbwidth;
$bheight=$Dbheight;

// --------------------------------- Recursive function to traverse the tree
// -- returns the last yoffset that was used
function print_descendancy_person($pid, $xoffset, $yoffset, $gencount) {
	global $pDbwidth;		// -- width of DIV layer boxes
	global $pDbheight;			// -- height of DIV layer boxes
	global $Dbxspacing;
	global $Dbyspacing;
	global $Dindent;
	global $Dbasexoffset;
	global $boxcount;
	global $generations, $PGV_IMAGE_DIR, $view;
	global $PGV_HLINE_IMG, $PGV_VLINE_IMG, $PGV_UARROW_IMG, $TEXT_DIRECTION, $show_full, $pgv_lang;

	$boxcount--;
	// -- this next section will create and position the DIV layers for the pedigree tree
	// -- draw the box
	print "\n\t\t<div id=\"box$pid\" style=\"position:absolute; left:".$xoffset."px; top:".$yoffset."px; width:".($pDbwidth+$Dindent)."px; height:".$pDbheight."px; z-index:$boxcount; \">";
	print "\n\t\t\t<table cellspacing=\"0\" cellpadding=\"0\" border=\"0\" dir=\"ltr\"><tr><td>";
	// -- if we are the first person in the list then check if he has parents and show an arrow
	if ($xoffset==$Dbasexoffset) {
		$famids = find_family_ids($pid);

		if (count($famids)>0) {
			$parents=false;
			$j=0;
			while((!$parents)&&($j<count($famids))) {
				$parents = find_parents($famids[$j]);
				$j++;
			}
			if ($parents) {
				if ($parents["HUSB"]!="") print "\n\t\t\t<a href=\"descendancy.php?pid=".$parents["HUSB"]."&amp;generations=$generations&amp;show_full=$show_full\" onmouseover=\"swap_image('uarrow".$parents["HUSB"]."',2);\" onmouseout=\"swap_image('uarrow".$parents["HUSB"]."',2);\"><img id=\"uarrow".$parents["HUSB"]."\" src=\"$PGV_IMAGE_DIR/$PGV_UARROW_IMG\" align=\"left\" hspace=\"0\" vspace=\"0\" border=\"0\" alt=\"".$pgv_lang["start_at_parents"]."\" title=\"".$pgv_lang["start_at_parents"]."\" /></a>";
				else if ($parents["WIFE"]!="") print "\n\t\t\t<a href=\"descendancy.php?pid=".$parents["WIFE"]."&amp;generations=$generations&amp;show_full=$show_full\" onmouseover=\"swap_image('uarrow".$parents["WIFE"]."',2);\" onmouseout=\"swap_image('uarrow".$parents["WIFE"]."',2);\"><img id=\"uarrow".$parents["WIFE"]."\" src=\"$PGV_IMAGE_DIR/$PGV_UARROW_IMG\" align=\"left\" hspace=\"0\" vspace=\"0\" border=\"0\" alt=\"".$pgv_lang["start_at_parents"]."\" title=\"".$pgv_lang["start_at_parents"]."\" /></a>";
			}
			print "\n\t\t\t</td>";
		}
	}
	else {
		// -- we are not the first person so we need an indent line
		print "\n\t\t\t<img src=\"$PGV_IMAGE_DIR/$PGV_HLINE_IMG\" align=\"left\" hspace=\"0\" vspace=\"0\" height=\"3\" width=\"".($Dindent)."\" alt=\"\" />";
		print "\n\t\t\t</td>";
	}
	$mfstyle = "";
	if (!empty($pid)) {
		$indirec = find_person_record($pid);
		$ct = preg_match("/1 SEX F/", $indirec);
		if ($ct>0) $mfstyle="F";
	}
	print "<td valign=\"top\" width=\"$pDbwidth\" dir=\"$TEXT_DIRECTION\">";
	print_pedigree_person($pid, 1, $view!="preview");
	print "\n\t\t\t</td></tr></table>\n\t\t</div><br />";
	$ryoffset = $yoffset;
	if ((empty($generations))||($gencount<$generations)) {
		// -- draw the spouse
		$famid = find_sfamily_ids($pid);
		$num = count($famid);
		$famoffset = $yoffset;
		// loop through each family for this person, and print out the descendants for this marriage
		for($i=0; $i<$num; $i++) {
			$familyid = $famid[$i];
			if ($familyid!="") {
				$ryoffset = print_family_descendancy($pid, $familyid,$xoffset,$famoffset,$i, $gencount+1);
				if ($i<$num-1) $famoffset = $ryoffset;
			}

		}
		if ($num>0) {
			//-- draw the connecting line
			print "\n\t\t<div id=\"line-fams-$pid\" style=\"position:absolute; left:".($xoffset+($Dindent*2))."px; top:".($yoffset+$pDbheight)."px; \"><img src=\"$PGV_IMAGE_DIR/$PGV_VLINE_IMG\" width=\"3\" height=\"".($famoffset-$yoffset+($pDbheight/2))."\" alt=\"\" /></div>";
		}
	}
	return $ryoffset;
}
//---------------------------- End function definition

// --------------------------------- Recursive function to traverse the tree
// -- returns the last yoffset that was used
function print_family_descendancy($pid, $famid, $xoffset, $yoffset, $index, $gencount) {
	global $pDbwidth;		// -- width of DIV layer boxes
	global $pDbheight;			// -- height of DIV layer boxes
	global $Dbxspacing;
	global $Dbyspacing;
	global $Dindent;
	global $Dbasexoffset;
	global $Darrowwidth;
	global $boxcount;
	global $generations, $PGV_IMAGE_DIR, $view ,$PGV_UARROW_IMG, $TEXT_DIRECTION, $show_full, $pgv_lang;

	if ($famid ) {
		$parents = find_parents($famid);
		if ($parents) {
			$sxoffset = $xoffset + ($Dindent*2) + $Dbxspacing;
			$prevyoffset = $yoffset;
			$yoffset = $yoffset + $pDbheight + $Dbyspacing;

			$id = $parents["WIFE"];
			if ($id==$pid) $id = $parents["HUSB"];
			// -- draw the box
			$boxcount--;
			print "\n\t\t<div id=\"box$id\" style=\"position:absolute; left:".$sxoffset."px; top:".$yoffset."px; width:".($pDbwidth+$Dindent+20)."px; height:".$pDbheight."px; z-index:$boxcount; \">";
			print "\n\t\t\t<table cellspacing=\"0\" cellpadding=\"0\" dir=\"ltr\"><tr><td valign=\"middle\" style=\"white-space: nowrap; width: $Dindent; padding-left: 3px; font-size: 14pt; font-weight: bold;\">";
			print "&nbsp;+&nbsp;";
			print "</td>";
			// -- check if spouse has parents and add an arrow
			$sfamid = find_family_id($id);
			if ($sfamid) {
				print "<td>";
				$parents = find_parents($sfamid);
				if ($parents) {
					if ($parents["HUSB"]!="") print "\n\t\t\t<a href=\"descendancy.php?pid=".$parents["HUSB"]."&amp;generations=$generations&amp;show_full=$show_full\" onmouseover=\"swap_image('uarrow".$parents["HUSB"]."',2);\" onmouseout=\"swap_image('uarrow".$parents["HUSB"]."',2);\"><img id=\"uarrow".$parents["HUSB"]."\" src=\"$PGV_IMAGE_DIR/$PGV_UARROW_IMG\" align=\"left\" hspace=\"0\" vspace=\"0\" border=\"0\" alt=\"".$pgv_lang["start_at_parents"]."\" title=\"".$pgv_lang["start_at_parents"]."\" /></a>";
					else if ($parents["WIFE"]!="") print "\n\t\t\t<a href=\"descendancy.php?pid=".$parents["WIFE"]."&amp;generations=$generations&amp;show_full=$show_full\" onmouseover=\"swap_image('uarrow".$parents["WIFE"]."',2);\" onmouseout=\"swap_image('uarrow".$parents["WIFE"]."',2);\"><img id=\"uarrow".$parents["WIFE"]."\" src=\"$PGV_IMAGE_DIR/$PGV_UARROW_IMG\" align=\"left\" hspace=\"0\" vspace=\"0\" border=\"0\" alt=\"".$pgv_lang["start_at_parents"]."\" title=\"".$pgv_lang["start_at_parents"]."\" /></a>";
				}
				print "\n\t\t\t</td>";
			}
			$mfstyle = "";
			if (!empty($id)) {
				$indirec = find_person_record($id);
				$ct = preg_match("/1 SEX F/", $indirec);
				if ($ct>0) $mfstyle="F";
			}
			print "<td valign=\"top\" width=\"$pDbwidth\" dir=\"$TEXT_DIRECTION\">";
			print_pedigree_person($id, 1, $view!="preview");
			print "\n\t\t\t</td></tr></table>\n\t\t</div><br />";
		}

	} // -- end of marriage

	$famrec = find_family_record($famid);
	$ryoffset = print_children_descendancy($famid, $sxoffset + ($Dindent*2), $yoffset, $gencount);

	if ($ryoffset > $yoffset) $yoffset=$ryoffset;
	return $yoffset;
}
//---------------------------- End function definition

// --------------------------------- Recursive function to traverse the tree
// -- returns the last yoffset that was used
function print_children_descendancy($famid, $xoffset, $yoffset, $gencount) {
	global $pDbwidth;		// -- width of DIV layer boxes
	global $pDbheight;			// -- height of DIV layer boxes
	global $Dbxspacing;
	global $Dbyspacing;
	global $Dindent;
	global $Dbasexoffset, $PGV_IMAGE_DIR, $view, $PGV_VLINE_IMG;

	// -- recurse on the children

	$prevyoffset = $yoffset;
	$famrec = find_family_record($famid);
	if ($famrec) {
		$num = preg_match_all("/1\s*CHIL\s*@(.*)@/", $famrec, $smatch,PREG_SET_ORDER);
		$xoffset = $xoffset + ($Dindent*2) + $Dbxspacing;
		for($i=0; $i<$num; $i++) {
			$yoffset = $yoffset + $pDbheight + $Dbyspacing;
			$id = $smatch[$i][1];
			$childoffset = $yoffset;
			$yoffset = print_descendancy_person($id, $xoffset, $childoffset, $gencount);
		}
		// -- if we are in the middle generations then we need to draw the connecting lines
		if ($num > 0) {
				print "\n\t\t<div id=\"line$famid\" style=\"position:absolute; left:".($xoffset)."px; top:".($prevyoffset+$pDbheight)."px; \"><img src=\"$PGV_IMAGE_DIR/$PGV_VLINE_IMG\" width=\"3\" height=\"".($childoffset-$prevyoffset-($pDbheight/2))."\" alt=\"\" /></div>";
		}
	} // -- end of children

	return $yoffset;
}
//---------------------------- End function definition

if (!isset($view)) $view="";
if ($view=="preview") {
	$Dbaseyoffset=55;
	$Dbasexoffset=10;
}

//-- if the $rootid is not already there then find the first person in the file and make him the root
if ((!isset($pid)) || ($pid=="")) {
	$user = getUser(getUserName());
	if ((!empty($user["rootid"][$GEDCOM]))&&(find_person_record($user["rootid"][$GEDCOM]))) $pid=$user["rootid"][$GEDCOM];
	else if ((!empty($user["gedcomid"][$GEDCOM]))&&(find_person_record($user["gedcomid"][$GEDCOM]))) $pid=$user["gedcomid"][$GEDCOM];
	//-- allow users to overide default id in the config file.
	else if ((isset($PEDIGREE_ROOT_ID))&&(find_person_record($PEDIGREE_ROOT_ID)!="")) $pid=$PEDIGREE_ROOT_ID;
	else {
		$pid = find_first_person();
	}
}
else {
	if (preg_match("/[A-Za-z]+/", $pid)==0) $pid = $GEDCOM_ID_PREFIX.$pid;
}

if ($USE_RIN) {
	$indirec = find_person_record($pid);
	if ($indirec==false) $pid = find_rin_id($pid);
}
if ((DisplayDetailsByID($pid))||(showLivingNameByID($pid))) $name = get_person_name($pid);
else $name = $pgv_lang["private"];
// -- print html header information
print_header($name." ".$pgv_lang["descend_chart"]);
print "\n\t<h2>".$name." - ".$pgv_lang["descend_chart"]."</h2>";
?>
<script language="JavaScript" type="text/javascript">
var pasteto;
function open_find(textbox) {
	pasteto = textbox;
	findwin = window.open('findid.php', '', 'left=50,top=50,width=410,height=320,resizable=1,scrollbars=1');
}
function paste_id(value) {
	pasteto.value=value;
}
</script>
<?php
$gencount=0;
if ($view!="preview") {
	print "<form method=\"get\" name=\"people\" action=\"descendancy.php\">\n";
	print_help_link("descendancy_help", "page_help");
	print "\n\t\t".$pgv_lang["root_person"]." <input type=\"text\" name=\"pid\" size=\"3\" value=\"$pid\" />";
	print "<font size=\"1\"><a href=\"javascript:open_find(document.people.pid);\">".$pgv_lang["find_id"]."</a></font>";
	print_help_link("desc_rootid_help", "qm");
	print " - ".$pgv_lang["generations"]." <input type=\"text\" size=\"2\" name=\"generations\" value=\"$generations\" />";
	print_help_link("desc_generations_help", "qm");
	print " <input type=\"submit\" value=\"".$pgv_lang["view"]."\" />";
	print "<input type=\"hidden\" name=\"show_full\" value=\"$show_full\" />";
	print "<input type=\"submit\" value=\"";
	if ($show_full) print $pgv_lang["hide_details"]."\" onclick=\"document.people.show_full.value='0';\" />\n";
	else print $pgv_lang["show_details"]."\" onclick=\"document.people.show_full.value='1';\" />\n";
	print_help_link("show_full_help", "qm");
	print "</form>\n";
}

$boxcount=99;
// -- perform a depth first traversal of the decendancy tree
$yoffset = print_descendancy_person($pid, $Dbasexoffset, $Dbaseyoffset, $gencount);
$yoffset = $yoffset + $pDbheight*2;
print "\n\t\t<div id=\"footerbox\" style=\"position:absolute; left:0px; top:".$yoffset."px; width:100%;  \">";
$without_close=true;
print_footer();
print "\n\t</div>\n</body>\n</html>";

?>
