<?php
/*=================================================
	Project:	phpGedView
	File:		edit_privacy.php
	Author:		John Finlay, Kurt Norgaz
	Comments:	Edit the content of the privacy file defined in $PRIVACY_MODULE

	phpGedView:	Genealogy Viewer

    Copyright (C) 2002 to 2003  John Finlay and Others

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

===================================================*/
# $Id: edit_privacy.php,v 1.16.2.5 2004/02/03 22:13:21 yalnifj Exp $

require "config.php";
require $PGV_BASE_DIRECTORY.$confighelpfile["english"];
if (file_exists($PGV_BASE_DIRECTORY.$confighelpfile[$LANGUAGE])) require $PGV_BASE_DIRECTORY.$confighelpfile[$LANGUAGE];

require($PGV_BASE_DIRECTORY.$factsfile["english"]);
require($PGV_BASE_DIRECTORY.$factsfile[$LANGUAGE]);

$message="";
if (!isset($action)) $action = "";
if (!isset($url)) $url = "index.php";

if (!userIsAdmin(getUserName())) {
	header("Location: login.php?url=edit_privacy.php?action=edit");
	exit;
}

if (!empty($ged)) $GEDCOM = $ged;
$PRIVACY_MODULE = get_privacy_file();

//-------------------------------------------------- constants
$konstante[2] = chr(36) . "PRIV_PUBLIC";	//-- accessible by public 2
$konstante_lang[2] = $pgv_lang["PRIV_PUBLIC"];	//-- accessible by public 2
$konstante[1] = chr(36) . "PRIV_USER";		//-- accessible only by authenticated users 1
$konstante_lang[1] = $pgv_lang["PRIV_USER"];	//-- accessible only by authenticated users 1
$konstante[0] = chr(36) . "PRIV_NONE";		//-- accessible only by admin users 0
$konstante_lang[0] = $pgv_lang["PRIV_NONE"];	//-- accessible only by admin users 0
$konstante[3] = chr(36) . "PRIV_HIDE";		//-- hide even for admins
$konstante_lang[3] = $pgv_lang["PRIV_HIDE"];	//-- hide even for admins

//---------------------------------------------------------- global variables
$variable =  array();
$variable[10][1] = chr(36) . "SHOW_DEAD_PEOPLE";
$variable[10][2] = "";
$variable[10][3] = "";
$variable[10][4] = "";
$variable[10][5] = "";

$variable[1][1] = chr(36) . "SHOW_LIVING_NAMES";	//-- Name of variable
$variable[1][2] = "";					//-- line number in privacy-file - 1
$variable[1][3] = "";					//-- content of the variable (number or 1==true, 0==false)
$variable[1][4] = "";					//-- content of everything after ; in the line

$variable[9][1] = chr(36) . "SHOW_RESEARCH_LOG";
$variable[9][2] = "";
$variable[9][3] = "";
$variable[9][4] = "";
$variable[9][5] = "";

$variable[2][1] = chr(36) . "USE_RELATIONSHIP_PRIVACY";
$variable[2][2] = "";
$variable[2][3] = "";
$variable[2][4] = "";

$variable[3][1] = chr(36) . "MAX_RELATION_PATH_LENGTH";
$variable[3][2] = "";
$variable[3][3] = "";
$variable[3][4] = "";

$variable[4][1] = chr(36) . "CHECK_MARRIAGE_RELATIONS";
$variable[4][2] = "";
$variable[4][3] = "";
$variable[4][4] = "";

$variable[5][1] = chr(36) . "person_privacy";
$variable[5][2] = "";
$variable[5][3] = "";
$variable[5][4] = "";
$variable[5][5] = "";

$variable[6][1] = chr(36) . "user_privacy";
$variable[6][2] = "";
$variable[6][3] = "";
$variable[6][4] = "";
$variable[6][5] = "";

$variable[7][1] = chr(36) . "global_facts";
$variable[7][2] = "";
$variable[7][3] = "";
$variable[7][4] = "";
$variable[7][5] = "";

$variable[8][1] = chr(36) . "person_facts";
$variable[8][2] = "";
$variable[8][3] = "";
$variable[8][4] = "";
$variable[8][5] = "";

$person_privacy_array = array(); $person_privacy_array_counter = 0;
$user_privacy_array = array();	 $user_privacy_array_counter = 0;
$global_facts_array = array();	 $global_facts_array_counter = 0;
$person_facts_array = array();	 $person_facts_array_counter = 0;

$privacy_array = array();
$my_facts_array = array();

/* ------------------------------------------------------------------------------------------------------------- */
function read_factsfile()
{
  global $PGV_BASE_DIRECTORY;
  global $my_facts_array;
  global $factarray;

  $d_my_facts_array = array();
  $my_facts_array_counter = 0;

  $Filename = $PGV_BASE_DIRECTORY . "languages/facts.en.php";

  if ($d_my_facts_array = file($Filename))
  {
    for ($x = 0; $x < count($d_my_facts_array); $x++)
    {
      $d_my_facts_array[$x] = trim(strtoupper($d_my_facts_array[$x]));
      if (substr($d_my_facts_array[$x], 0, 12) == chr(36) . "FACTARRAY[" . chr(34))
      {
        $my_facts_array[$my_facts_array_counter] = trim(strtoupper($d_my_facts_array[$x]));
        $my_facts_array[$my_facts_array_counter] = substr($my_facts_array[$my_facts_array_counter], 12);
        $my_facts_array[$my_facts_array_counter] = substr($my_facts_array[$my_facts_array_counter], 0, strpos($my_facts_array[$my_facts_array_counter], chr(34)."]"));
        $my_facts_array_counter++;
      }
    }
  }
  unset($d_my_facts_array);
}

/* ------------------------------------------------------------------------------------------------------------- */
function read_privacyfile()
{
  global $konstante, $variable, $PGV_BASE_DIRECTORY, $PRIVACY_MODULE;
  global $privacy_array;
  global $person_privacy_array, $person_privacy_array_counter;
  global $user_privacy_array, $user_privacy_array_counter;
  global $global_facts_array, $global_facts_array_counter;
  global $person_facts_array, $person_facts_array_counter;

  $Filename = $PGV_BASE_DIRECTORY . $PRIVACY_MODULE;

  if ($privacy_array = file($Filename))
  {
    for ($x = 0; $x < count($privacy_array); $x++)
    {
      $dDummy00 = trim($privacy_array[$x]);

      for ($y = 1; $y <= 10; $y++)
      {
        $dDummy01 = substr($dDummy00, 0, strlen($variable[$y][1]));
        if (strtoupper($dDummy01) == strtoupper($variable[$y][1]))
        {
          $variable[$y][2] = $x;

          $dDummy01 = trim(substr($dDummy00, strpos($dDummy00, "=") + 1));
          $variable[$y][4] = substr($dDummy01, strpos($dDummy01, ";") + 1);
          $dDummy02 = trim(substr($dDummy01, 0, strpos($dDummy01, ";")));

          switch ($y)
          {
            case 10: switch (strtoupper($dDummy02))
            	     {
            	       case $konstante[0] : $variable[$y][3] = 0; break;
            	       case $konstante[1] : $variable[$y][3] = 1; break;
            	       case $konstante[2] : $variable[$y][3] = 2; break;
            	       default :	    $variable[$y][3] = 0; break;
            	     }
            	     break;
            case 1 : switch (strtoupper($dDummy02))
            	     {
            	       case $konstante[0] : $variable[$y][3] = 0; break;
            	       case $konstante[1] : $variable[$y][3] = 1; break;
            	       case $konstante[2] : $variable[$y][3] = 2; break;
            	       default :	    $variable[$y][3] = 0; break;
            	     }
            	     break;
            case 9 : switch (strtoupper($dDummy02))
            	     {
            	       case $konstante[0] : $variable[$y][3] = 0; break;
            	       case $konstante[1] : $variable[$y][3] = 1; break;
            	       case $konstante[2] : $variable[$y][3] = 2; break;
            	       default :	    $variable[$y][3] = 0; break;
            	     }
            	     break;
            case 2 : switch (strtoupper($dDummy02))
            	     {
            	       case "TRUE" :  $variable[$y][3] = 1; break;
            	       case "FALSE" : $variable[$y][3] = 0; break;
            	       default :      $variable[$y][3] = 1; break;
            	     }
            	     break;
            case 3 : $variable[$y][3] = $dDummy02;
            	     break;
            case 4 : switch (strtoupper($dDummy02))
		     {
		       case "TRUE" :  $variable[$y][3] = 1; break;
		       case "FALSE" : $variable[$y][3] = 0; break;
		       default :      $variable[$y][3] = 1; break;
		     }
		     break;
            case 5 : if (strtoupper($dDummy02) != "ARRAY()")
		     {
		       $dDummy00 = substr($dDummy00, strlen($variable[$y][1]));
		       $dDummy00 = trim(substr($dDummy00, 0, strpos($dDummy00, "=") - 1));
		       $dDummy00 = substr($dDummy00, strpos($dDummy00, "[" . chr(34)) + 2);
		       $dDummy00 = substr($dDummy00, 0, strpos($dDummy00, chr(34) . "]"));

		       $person_privacy_array[$person_privacy_array_counter][1] = $dDummy00; //-- ArrayDefiniton
		       $person_privacy_array[$person_privacy_array_counter][2] = $x; //-- line number in privacy-file
		       switch (strtoupper($dDummy02))
		       {
		       	 case $konstante[0] : $person_privacy_array[$person_privacy_array_counter][3] = 0; break; //-- content of the variable (number or 1==true, 0==false)
		       	 case $konstante[1] : $person_privacy_array[$person_privacy_array_counter][3] = 1; break;
		       	 case $konstante[2] : $person_privacy_array[$person_privacy_array_counter][3] = 2; break;
		       	 default :	      $person_privacy_array[$person_privacy_array_counter][3] = 0; break;
		       }
		       $person_privacy_array[$person_privacy_array_counter][4] = rtrim(substr($dDummy01, strpos($dDummy01, ";") + 1)); //-- content of everything after ; in the line
		       $person_privacy_array_counter++;
            	     }
            	     else
            	     {
            	       $variable[$y][5] = $x;
            	     }
            	     break;
            case 6 : if (strtoupper($dDummy02) != "ARRAY()")
		     {
		       $dDummy00 = substr($dDummy00, strlen($variable[$y][1]));
		       $dDummy00 = trim(substr($dDummy00, 0, strpos($dDummy00, "=") - 1));

		       $dDummy00_00 = $dDummy00;
		       $dDummy00 = substr($dDummy00, strpos($dDummy00, "[" . chr(34)) + 2);
		       $dUsername = substr($dDummy00, 0, strpos($dDummy00, chr(34) . "]"));
		       $dHide_ID = substr($dDummy00_00, strpos($dDummy00_00, chr(34) . "]") + 2);
		       $dHide_ID = substr($dHide_ID, strpos($dHide_ID, "[" . chr(34)) + 2);
		       $dHide_ID = substr($dHide_ID, 0, strpos($dHide_ID, chr(34) . "]"));

		       $user_privacy_array[$user_privacy_array_counter][1][0] = $dUsername; //-- ArrayDefiniton 1
		       $user_privacy_array[$user_privacy_array_counter][1][1] = $dHide_ID; //-- ArrayDefiniton 2
		       $user_privacy_array[$user_privacy_array_counter][2] = $x; //-- line number in privacy-file
		       switch (strtoupper($dDummy02))
		       {
		       	 case $konstante[0] : $user_privacy_array[$user_privacy_array_counter][3] = 0; break; //-- content of the variable (number or 1==true, 0==false)
		       	 case $konstante[1] : $user_privacy_array[$user_privacy_array_counter][3] = 1; break;
		       	 case $konstante[2] : $user_privacy_array[$user_privacy_array_counter][3] = 2; break;
		       	 default :	      $user_privacy_array[$user_privacy_array_counter][3] = 0; break;
		       }
		       $user_privacy_array[$user_privacy_array_counter][4] = rtrim(substr($dDummy01, strpos($dDummy01, ";") + 1)); //-- content of everything after ; in the line
		       $user_privacy_array_counter++;
            	     }
            	     else
            	     {
            	       $variable[$y][5] = $x;
            	     }
            	     break;
            case 7 : if (strtoupper($dDummy02) != "ARRAY()")
		     {
		       $dDummy00 = substr($dDummy00, strlen($variable[$y][1]));
		       $dDummy00 = trim(substr($dDummy00, 0, strpos($dDummy00, "=") - 1));

		       $dDummy00_00 = $dDummy00;
		       $dDummy00 = substr($dDummy00, strpos($dDummy00, "[" . chr(34)) + 2);
		       $dUsername = substr($dDummy00, 0, strpos($dDummy00, chr(34) . "]"));
		       $dHide_ID = substr($dDummy00_00, strpos($dDummy00_00, chr(34) . "]") + 2);
		       $dHide_ID = substr($dHide_ID, strpos($dHide_ID, "[" . chr(34)) + 2);
		       $dHide_ID = substr($dHide_ID, 0, strpos($dHide_ID, chr(34) . "]"));

		       $global_facts_array[$global_facts_array_counter][1][0] = $dUsername; //-- ArrayDefiniton 1
		       $global_facts_array[$global_facts_array_counter][1][1] = $dHide_ID; //-- ArrayDefiniton 2

		       $global_facts_array[$global_facts_array_counter][2] = $x; //-- line number in privacy-file
		       switch (strtoupper($dDummy02))
		       {
		       	 case $konstante[0] : $global_facts_array[$global_facts_array_counter][3] = 0; break; //-- content of the variable (number or 1==true, 0==false)
		       	 case $konstante[1] : $global_facts_array[$global_facts_array_counter][3] = 1; break;
		       	 case $konstante[2] : $global_facts_array[$global_facts_array_counter][3] = 2; break;
		       	 case $konstante[3] : $global_facts_array[$global_facts_array_counter][3] = 3; break;
		       	 default :	      $global_facts_array[$global_facts_array_counter][3] = 0; break;
		       }
		       $global_facts_array[$global_facts_array_counter][4] = rtrim(substr($dDummy01, strpos($dDummy01, ";") + 1)); //-- content of everything after ; in the line
		       $global_facts_array_counter++;
            	     }
            	     else
            	     {
            	       $variable[$y][5] = $x;
            	     }
            	     break;
            case 8 : if (strtoupper($dDummy02) != "ARRAY()")
		     {
		       $dDummy00 = substr($dDummy00, strlen($variable[$y][1]));
		       $dDummy00 = trim(substr($dDummy00, 0, strpos($dDummy00, "=") - 1));

		       $dDummy00_00 = $dDummy00;
		       $dDummy00 = substr($dDummy00, strpos($dDummy00, "[" . chr(34)) + 2);
		       $dUsername = substr($dDummy00, 0, strpos($dDummy00, chr(34) . "]"));
		       $dHide_ID = substr($dDummy00_00, strpos($dDummy00_00, chr(34) . "]") + 2);
		       $dHide_ID = substr($dHide_ID, strpos($dHide_ID, "[" . chr(34)) + 2);
		       $dHide_ID = substr($dHide_ID, 0, strpos($dHide_ID, chr(34) . "]"));

		       $dDummy00_00 = substr($dDummy00_00, strpos($dDummy00_00, chr(34) . "]") + 2);
		       $dWhat = substr($dDummy00_00, strpos($dDummy00_00, chr(34) . "]") + 2);
		       $dWhat = substr($dWhat, strpos($dWhat, "[" . chr(34)) + 2);
		       $dWhat = substr($dWhat, 0, strpos($dWhat, chr(34) . "]"));

		       $person_facts_array[$person_facts_array_counter][1][0] = $dUsername; //-- ArrayDefiniton 1
		       $person_facts_array[$person_facts_array_counter][1][1] = $dHide_ID; //-- ArrayDefiniton 2
		       $person_facts_array[$person_facts_array_counter][1][2] = $dWhat; //-- ArrayDefiniton 3

		       $person_facts_array[$person_facts_array_counter][2] = $x; //-- line number in privacy-file
		       switch (strtoupper($dDummy02))
		       {
		       	 case $konstante[0] : $person_facts_array[$person_facts_array_counter][3] = 0; break; //-- content of the variable (number or 1==true, 0==false)
		       	 case $konstante[1] : $person_facts_array[$person_facts_array_counter][3] = 1; break;
		       	 case $konstante[2] : $person_facts_array[$person_facts_array_counter][3] = 2; break;
		       	 default :	      $person_facts_array[$person_facts_array_counter][3] = 0; break;
		       }
		       $person_facts_array[$person_facts_array_counter][4] = rtrim(substr($dDummy01, strpos($dDummy01, ";") + 1)); //-- content of everything after ; in the line
		       $person_facts_array_counter++;
            	     }
            	     else
            	     {
            	       $variable[$y][5] = $x;
            	     }
            	     break;
          }
          break; // break of "for $y" - loop
        }
      }
    }
  }
  else
  {
    print "<font class=\"error\">";
    print $pgv_lang["file_read_error"];
    print "</font><br /><br />";
    exit;
  }
}

/* ------------------------------------------------------------------------------------------------------------- */
function write_access_option($checkVar)
{
  global $konstante;
  global $konstante_lang;

  for ($y = 2; $y >= 0; $y--)
  {
    print "<option";
    if ($checkVar == $y) print " selected=\"selected\"";
    print " value=\"";
    print $y;
    print "\">";
    print $konstante_lang[$y];
    print "</option>";
  }
}

/* ------------------------------------------------------------------------------------------------------------- */
function write_access_option_02($checkVar)
{
  global $konstante;
  global $pgv_lang;
  $konstante_lang_02[1] = $pgv_lang["show"];
  $konstante_lang_02[0] = $pgv_lang["hide"];

  for ($y = 1; $y >= 0; $y--)
  {
    print "<option";
    if ($checkVar == $y) print " selected=\"selected\"";
    print " value=\"";
    print $y;
    print "\">";
    print $konstante_lang_02[$y];
    print "</option>";
  }
}

/* ------------------------------------------------------------------------------------------------------------- */
function write_access_option03($checkVar)
{
  global $konstante;
  global $konstante_lang;

  for ($y = 3; $y >= 0; $y--)
  {
    print "<option";
    if ($checkVar == $y) print " selected=\"selected\"";
    print " value=\"";
    print $y;
    print "\">";
    print $konstante_lang[$y];
    print "</option>";
  }
}

/* ------------------------------------------------------------------------------------------------------------- */
function write_yes_no($checkVar)
{
  global $pgv_lang;

  print "<option";
  if ($checkVar == 0) print " selected=\"selected\"";
  print " value=\"";
  print "0";
  print "\">";
  print $pgv_lang["no"];
  print "</option>";

  print "<option";
  if ($checkVar == 1) print " selected=\"selected\"";
  print " value=\"";
  print "1";
  print "\">";
  print $pgv_lang["yes"];
  print "</option>";
}

/* ------------------------------------------------------------------------------------------------------------- */
function search_ID_details($checkVar, $outputVar)
{
  global $GEDCOMS, $GEDCOM;
  global $pgv_lang;

  # print $GEDCOMS[$GEDCOM]["path"]; exit;

  if (file_exists($GEDCOMS[$GEDCOM]["path"]))
  {
    $fpged = fopen($GEDCOMS[$GEDCOM]["path"], "r");
    $BLOCK_SIZE = 1024*4;	//-- 4k bytes per read
    $fcontents = "";
    while(!feof($fpged))
    {
      $fcontents .= fread($fpged, $BLOCK_SIZE);
      $pos1 = strpos($fcontents, "0 @" . $checkVar . "@", 0);
      if ($pos1===false)
      {
        $fcontents = "";
      }
      else
      {
        $pos2 = strpos($fcontents, "0 @", $pos1+1);
        while((!$pos2)&&(!feof($fpged)))
        {
          $fcontents .= fread($fpged, $BLOCK_SIZE);
          $pos2 = strpos($fcontents, "0 @", $pos1+1);
        }
        if ($pos2)
        {
          $indirec = substr($fcontents, $pos1, $pos2-$pos1);
        }
        else $indirec = substr($fcontents, $pos1);
        break;
      }
    }
    fclose($fpged);

    if (!empty($indirec))
    {
      preg_match("/1 NAME (.*)/", $indirec, $match);
      $name = preg_replace("'\/'", " ", $match[1]);
      $name = rtrim($name);
      $nt = preg_match("/2 NSFX (.*)/", $indirec, $smatch);
      if ($nt>0) $name .= " ".$smatch[1];
      print "\n<font class=\"list_item\">$name";
      print "--<i>".$pgv_lang["birth"]." ";
      $bpos1 = strpos($indirec, "1 BIRT");
      if ($bpos1)
      {
        $birthrec = substr($indirec, $bpos1+1);
        $bt = preg_match("/1 [A-Z]{4}/", $birthrec, $match);
        if ($bt>0)
        {
          $bpos2 = strpos($birthrec, $match[0]);
          if ($bpos2) $birthrec = substr($birthrec, 0, $bpos2);
        }
        $dct = preg_match("/2 DATE (.*)/", $birthrec, $match);
        if ($dct>0) print $match[1];
        $pct = preg_match("/2 PLAC (.*)/", $birthrec, $match);
        if ($pct>0) print " - ".$match[1];

      }
      print "</i>";
      print "</font>\n";
    }
    else
    {
      print "<font class=\"error\">";
      if ($outputVar == 1) print $pgv_lang["unable_to_find_privacy_indi"] . "<br />[" . $checkVar . "]";
      if ($outputVar == 2) print $pgv_lang["unable_to_find_privacy_indi"];
    print "</font><br /><br />";
    }
  }
  //else print "<font class=\"error\">".$pgv_lang["error_header"]."</font>";
  else print "<font class=\"error\">".str_replace("#GEDCOM#", $GEDCOM, $pgv_lang["error_header"])."</font><br /><br />";
}

/* ------------------------------------------------------------------------------------------------------------- */
function showeditmask()
{
  global $PRIVACY_MODULE;
  global $variable, $pgv_lang;
  global $person_privacy_array, $person_privacy_array_counter;
  global $user_privacy_array, $user_privacy_array_counter;
  global $global_facts_array, $global_facts_array_counter;
  global $person_facts_array, $person_facts_array_counter;
  global $my_facts_array, $factarray;

  print "<div class=\"center\"><center>";

  print "<font class=\"subheaders\">" . str_replace("#PRIVACY_MODULE#", $PRIVACY_MODULE, $pgv_lang["edit_privacy_title"]) . "</font><br />";
  # str_replace("#PRIVACY_MODULE#", $PRIVACY_MODULE, $pgv_lang["edit_privacy"])

  ?>

<script language="JavaScript">
	var helpWin;
	function helpPopup(which) {
		if ((!helpWin)||(helpWin.closed)) helpWin = window.open('editconfig_help.php?help='+which,'','left=50,top=50,width=400,height=320,resizable=1,scrollbars=1');
		else helpWin.location = 'editconfig_help.php?help='+which;
		return false;
	}
</script>

  <?php print $pgv_lang["help_info"]; ?>
  <form name="editprivacyform" method="post">
    <input type="hidden" name="action" value="save">
    <table class="facts_table">

      <tr>
        <td class="facts_label" colspan="2"><b><?php print $pgv_lang["general_settings"]; ?></b></td>
      </tr>

      <tr>
        <td class="facts_label"><?php print $pgv_lang["SHOW_DEAD_PEOPLE"]; ?> <a href="#" onclick="return helpPopup('SHOW_DEAD_PEOPLE_help');"><b><font color=red>?</font></b></a></td>
        <td class="facts_value" style="text-align:left; ">
          <select size="1" name="v_SHOW_DEAD_PEOPLE"><?php write_access_option($variable[10][3]); ?></select>
        </td>
      </tr>

      <tr>
        <td class="facts_label"><?php print $pgv_lang["SHOW_LIVING_NAMES"]; ?> <a href="#" onclick="return helpPopup('SHOW_LIVING_NAMES_help');"><b><font color=red>?</font></b></a></td>
        <td class="facts_value" style="text-align:left; ">
          <select size="1" name="v_SHOW_LIVING_NAMES"><?php write_access_option($variable[1][3]); ?></select>
        </td>
      </tr>

      <tr>
        <td class="facts_label"><?php print $pgv_lang["SHOW_RESEARCH_LOG"]; ?> <a href="#" onclick="return helpPopup('SHOW_RESEARCH_LOG_help');"><b><font color=red>?</font></b></a></td>
        <td class="facts_value" style="text-align:left; ">
          <select size="1" name="v_SHOW_RESEARCH_LOG"><?php write_access_option($variable[9][3]); ?></select>
        </td>
      </tr>

      <tr>
        <td class="facts_label"><?php print $pgv_lang["USE_RELATIONSHIP_PRIVACY"]; ?> <a href="#" onclick="return helpPopup('USE_RELATIONSHIP_PRIVACY_help');"><b><font color=red>?</font></b></a></td>
        <td class="facts_value" style="text-align:left; ">
          <select size="1" name="v_USE_RELATIONSHIP_PRIVACY"><?php write_yes_no($variable[2][3]); ?></select>
        </td>
      </tr>

      <tr>
        <td class="facts_label"><?php print $pgv_lang["MAX_RELATION_PATH_LENGTH"]; ?> <a href="#" onclick="return helpPopup('MAX_RELATION_PATH_LENGTH_help');"><b><font color=red>?</font></b></a></td>
        <td class="facts_value" style="text-align:left; ">
          <select size="1" name="v_MAX_RELATION_PATH_LENGTH"><?php
          for ($y = 1; $y <= 10; $y++)
          {
            print "<option";
            if ($variable[3][3] == $y) print " selected=\"selected\"";
            print ">";
            print $y;
            print "</option>";
          }
          ?></select>
        </td>
      </tr>

      <tr>
        <td class="facts_label"><?php print $pgv_lang["CHECK_MARRIAGE_RELATIONS"]; ?> <a href="#" onclick="return helpPopup('CHECK_MARRIAGE_RELATIONS_help');"><b><font color=red>?</font></b></a></td>
        <td class="facts_value" style="text-align:left; ">
          <select size="1" name="v_CHECK_MARRIAGE_RELATIONS"><?php write_yes_no($variable[4][3]); ?></select>
        </td>
      </tr>

      <tr>
        <td class="facts_label" colspan="2"><input type="submit" name="B001" value="<?php print $pgv_lang["save_changed_settings"]; ?>"></td>
      </tr>
    </table>

  <br /> <?php //--------------person_privacy------------------------------------------------------------------------ ?>

    <table class="facts_table">

      <tr>
        <td class="facts_label03"><?php print $pgv_lang["person_privacy_settings"]; ?> <a href="#" onclick="return helpPopup('person_privacy_help');"><b><font color=red>?</font></b></a></td>
      </tr>

      <tr>
        <td class="facts_label03">
          <center>
          <table>
            <tr>
              <td class="facts_label02" colspan="2"><?php print $pgv_lang["add_new_pp_setting"]; ?></td>
            </tr>

            <tr>
              <td class="facts_label02"><?php print $pgv_lang["id"]; ?></td>
              <td class="facts_label02"><?php print $pgv_lang["accessible_by"]; ?></td>
            </tr>

            <tr>
              <td class="facts_value02">
                <input type="hidden" name="v_new_person_privacy_access_line" value="<?php print $variable[5][5]; ?>">
                <input type="text" name="v_new_person_privacy_access_ID" size="4">
                <?php
                print " <font size=\"1\"><a href=\"javascript:open_find(document.editprivacyform.v_new_person_privacy_access_ID);\">";
                print $pgv_lang["find_id"];
                print "</a></font>";
                ?>
              </td>
              <td class="facts_value02">
                <select size="1" name="v_new_person_privacy_acess_option"><?php write_access_option(""); ?></select>
              </td>
            </tr>

            <tr>
              <td class="facts_label02" colspan="2"><input type="submit" name="B002" value="<?php print $pgv_lang["add_new_pp_setting"]; ?>"></td>
            </tr>

          </table>
          </center>

        </td>
      </tr>

      <tr>
        <td class="facts_label03">
          <?php
          if ($person_privacy_array_counter > 0)
          {
          ?>
          <center>
          <table>
            <tr>
              <td class="facts_label02" colspan="4"><?php print $pgv_lang["edit_exist_person_privacy_settings"]; ?></td>
            </tr>

            <tr>
              <td class="facts_label02"><?php print $pgv_lang["delete"]; ?></td>
              <td class="facts_label02"><?php print $pgv_lang["id"]; ?></td>
              <td class="facts_label02"><?php print $pgv_lang["full_name"]; ?></td>
              <td class="facts_label02"><?php print $pgv_lang["accessible_by"]; ?></td>
            </tr>

            <?php

            for ($x = 0; $x < $person_privacy_array_counter; $x++)
            {
            ?>

            <tr>
              <td class="facts_value02">
              <input type="hidden" name="v_person_privacy_id_<?php print $x; ?>" value="<?php print $person_privacy_array[$x][1]; ?>">
              <input type="checkbox" name="v_person_privacy_del_<?php print $x; ?>" value="1"></td>
              <td class="facts_value02"><?php print $person_privacy_array[$x][1]; ?></td>
              <td class="facts_value02"><?php search_ID_details($person_privacy_array[$x][1], 1); ?></td>
              <td class="facts_value02">
                <select size="1" name="v_person_privacy_<?php print $x; ?>"><?php write_access_option($person_privacy_array[$x][3]); ?></select>
              </td>
            </tr>

            <?php
            }
            ?>

            <tr>
              <td class="facts_label02" colspan="4"><input type="submit" name="B003" value="<?php print $pgv_lang["save_changed_settings"]; ?>"></td>
            </tr>
          </table>
          </center>
          <?php
          }
          else print "&nbsp";
          ?>
        </td>

      </tr>

    </table>

  <br /> <?php //--------------user_privacy-------------------------------------------------------------------------- ?>

    <table class="facts_table">

      <tr>
        <td class="facts_label03"><?php print $pgv_lang["user_privacy_settings"]; ?> <a href="#" onclick="return helpPopup('user_privacy_help');"><b><font color=red>?</font></b></a></td>
      </tr>

      <tr>
        <td class="facts_label03">
          <center>
          <table>
            <tr>
              <td class="facts_label02" colspan="3"><?php print $pgv_lang["add_new_up_setting"]; ?></td>
            </tr>

            <tr>
              <td class="facts_label02"><?php print $pgv_lang["user_name"]; ?></td>
              <td class="facts_label02"><?php print $pgv_lang["id"]; ?></td>
              <td class="facts_label02"><?php print $pgv_lang["show_question"]; ?></td>
            </tr>

            <tr>
              <td class="facts_value02">
                <select size="1" name="v_new_user_privacy_username">
                <?php
                $users = getUsers();
                foreach($users as $username => $user)
                {
                  print "<option";
                  print " value=\"";
                  print $username;
                  print "\">";
                  print $user["fullname"];
                  print "</option>";
                }
                ?>
                </select>
              </td>
              <td class="facts_value02">
                <input type="hidden" name="v_new_user_privacy_access_line" value="<?php print $variable[6][5]; ?>">
                <input type="text" name="v_new_user_privacy_access_ID" size="4">
                <?php
                print " <font size=\"1\"><a href=\"javascript:open_find(document.editprivacyform.v_new_user_privacy_access_ID);\">";
                print $pgv_lang["find_id"];
                print "</a></font>";
                ?>
              </td>
              <td class="facts_value02">
                <select size="1" name="v_new_user_privacy_acess_option"><?php write_access_option_02(""); ?></select>
              </td>
            </tr>

            <tr>
              <td class="facts_label02" colspan="3"><input type="submit" name="B004" value="<?php print $pgv_lang["add_new_up_setting"]; ?>"></td>
            </tr>

          </table>
          </center>

        </td>
      </tr>

      <tr>
        <td class="facts_label03">
          <?php
          if ($user_privacy_array_counter > 0)
          {
          ?>
          <center>
          <table>
            <tr>
              <td class="facts_label02" colspan="4"><?php print $pgv_lang["edit_exist_user_privacy_settings"]; ?></td>
            </tr>

            <tr>
              <td class="facts_label02"><?php print $pgv_lang["delete"]; ?></td>
              <td class="facts_label02"><?php print $pgv_lang["user_name"]; ?></td>
              <td class="facts_label02"><?php print $pgv_lang["id"]; ?></td>
              <td class="facts_label02"><?php print $pgv_lang["show_question"]; ?></td>
            </tr>

            <?php

            for ($x = 0; $x < $user_privacy_array_counter; $x++)
            {
            ?>

            <tr>

              <td class="facts_value02">
              <input type="hidden" name="v_user_privacy_username_<?php print $x; ?>" value="<?php print $user_privacy_array[$x][1][0]; ?>">
              <input type="hidden" name="v_user_privacy_id_<?php print $x; ?>" value="<?php print $user_privacy_array[$x][1][1]; ?>">
              <input type="checkbox" name="v_user_privacy_del_<?php print $x; ?>" value="1"></td>
              <td class="facts_value02"><?php print $user_privacy_array[$x][1][0]; ?></td>
              <td class="facts_value02"><?php search_ID_details($user_privacy_array[$x][1][1], 2); ?><br /><?php print $user_privacy_array[$x][1][1]; ?></td>
              <td class="facts_value02">
                <select size="1" name="v_user_privacy_<?php print $x; ?>"><?php write_access_option_02($user_privacy_array[$x][3]); ?></select>
              </td>
            </tr>

            <?php
            }
            ?>

            <tr>
              <td class="facts_label02" colspan="4"><input type="submit" name="B005" value="<?php print $pgv_lang["save_changed_settings"]; ?>"></td>
            </tr>
          </table>
          </center>
          <?php
          }
          else print "&nbsp";
          ?>
        </td>

      </tr>

    </table>

  <br /> <?php //-------------global_facts------------------------------------------------------------------------ ?>

    <table class="facts_table">

      <tr>
        <td class="facts_label03"><?php print $pgv_lang["global_facts_settings"]; ?> <a href="#" onclick="return helpPopup('global_facts_help');"><b><font color=red>?</font></b></a></td>
      </tr>

      <tr>
        <td class="facts_label03">
          <center>
          <table>
            <tr>
              <td class="facts_label02" colspan="3"><?php print $pgv_lang["add_new_gf_setting"]; ?></td>
            </tr>

            <tr>
              <td class="facts_label02"><?php print $pgv_lang["name_of_fact"]; ?></td>
              <td class="facts_label02"><?php print $pgv_lang["choice"]; ?></td>
              <td class="facts_label02"><?php print $pgv_lang["accessible_by"]; ?></td>
            </tr>

            <tr>
              <td class="facts_value02">
                <input type="hidden" name="v_new_global_facts_access_line" value="<?php print $variable[7][5]; ?>">
                <select size="1" name="v_new_global_facts_abbr">
                <?php
                for ($x = 0; $x < count($my_facts_array); $x++)
                {
                  print "<option";
                  print " value=\"";
                  print $my_facts_array[$x];
                  print "\">";
                  print $my_facts_array[$x] . " - " . str_replace("<br />", " ", $factarray[$my_facts_array[$x]]);
                  print "</option>";
                }
                ?>
                </select>
              </td>
              <td class="facts_value02">
                <select size="1" name="v_new_global_facts_choice">
                  <option value="details"><?php print $pgv_lang["fact_details"]; ?></option>";
                  <option value="show"><?php print $pgv_lang["fact_show"]; ?></option>";
                </select>
              </td>
              <td class="facts_value02">
                <select size="1" name="v_new_global_facts_acess_option"><?php write_access_option03(""); ?></select>
              </td>
            </tr>

            <tr>
              <td class="facts_label02" colspan="3"><input type="submit" name="B006" value="<?php print $pgv_lang["add_new_gf_setting"]; ?>"></td>
            </tr>

          </table>
          </center>

        </td>
      </tr>

      <tr>
        <td class="facts_label03">
          <?php
          if ($global_facts_array_counter > 0)
          {
          ?>
          <center>
          <table>
            <tr>
              <td class="facts_label02" colspan="4"><?php print $pgv_lang["edit_exist_global_facts_settings"]; ?></td>
            </tr>

            <tr>
              <td class="facts_label02"><?php print $pgv_lang["delete"]; ?></td>
              <td class="facts_label02"><?php print $pgv_lang["name_of_fact"]; ?></td>
              <td class="facts_label02"><?php print $pgv_lang["choice"]; ?></td>
              <td class="facts_label02"><?php print $pgv_lang["accessible_by"]; ?></td>
            </tr>

            <?php

            for ($x = 0; $x < $global_facts_array_counter; $x++)
            {
            ?>

            <tr>

              <td class="facts_value02">
              <input type="hidden" name="v_global_facts_abbr_<?php print $x; ?>" value="<?php print $global_facts_array[$x][1][0]; ?>">
              <input type="hidden" name="v_global_facts_choice_<?php print $x; ?>" value="<?php print $global_facts_array[$x][1][1]; ?>">
              <input type="checkbox" name="v_global_facts_del_<?php print $x; ?>" value="1"></td>

              <td class="facts_value02" style="text-align: center; ">
              <?php
  		print $global_facts_array[$x][1][0]; //-- ArrayDefiniton 1
                for ($y = 0; $y < count($my_facts_array); $y++)
                {
                  if ($my_facts_array[$y] == $global_facts_array[$x][1][0])
                  {
                    print "<br />(" . $factarray[$my_facts_array[$y]] . ")";
                    break;
                  }
                }
                ?>
              </td>
              <td class="facts_value02" style="text-align: center; "><?php
              if ($global_facts_array[$x][1][1] == "show") print $pgv_lang["fact_show"];
              if ($global_facts_array[$x][1][1] == "details") print $pgv_lang["fact_details"];
              ?></td>
              <td class="facts_value02">
                <select size="1" name="v_global_facts_<?php print $x; ?>"><?php write_access_option03($global_facts_array[$x][3]); ?></select>
              </td>
            </tr>

            <?php
            }
            ?>

            <tr>
              <td class="facts_label02" colspan="4"><input type="submit" name="B007" value="<?php print $pgv_lang["save_changed_settings"]; ?>"></td>
            </tr>
          </table>
          </center>
          <?php
          }
          else print "&nbsp";
          ?>
        </td>

      </tr>

    </table>

  <br /> <?php //-------------person_facts------------------------------------------------------------------------ ?>

    <table class="facts_table">

      <tr>
        <td class="facts_label03"><?php print $pgv_lang["person_facts_settings"]; ?> <a href="#" onclick="return helpPopup('person_facts_help');"><b><font color=red>?</font></b></a></td>
      </tr>

      <tr>
        <td class="facts_label03">
          <center>
          <table>
            <?php //--Start--add person_facts for individuals----------------------------------------------- ?>
            <tr>
              <td class="facts_label02" colspan="4"><?php print $pgv_lang["add_new_pf_setting_indi"]; ?></td>
            </tr>

            <tr>
              <td class="facts_label02"><?php print $pgv_lang["privacy_indi_id"]; ?></td>
              <td class="facts_label02"><?php print $pgv_lang["name_of_fact"]; ?></td>
              <td class="facts_label02"><?php print $pgv_lang["choice"]; ?></td>
              <td class="facts_label02"><?php print $pgv_lang["accessible_by"]; ?></td>
            </tr>

            <tr>
              <td class="facts_value02">
                <input type="hidden" name="v_new_person_facts_access_line" value="<?php print $variable[8][5]; ?>">
                <input type="text" name="v_new_person_facts_access_ID" size="4">
                <?php
                print " <font size=\"1\"><a href=\"javascript:open_find(document.editprivacyform.v_new_person_facts_access_ID);\">";
                print $pgv_lang["find_id"];
                print "</a></font>";
                ?>
              </td>
              <td class="facts_value02">
                <select size="1" name="v_new_person_facts_abbr">
                <?php
                for ($x = 0; $x < count($my_facts_array); $x++)
                {
                  print "<option";
                  print " value=\"";
                  print $my_facts_array[$x];
                  print "\">";
                  print $my_facts_array[$x] . " - " . str_replace("<br />", " ", $factarray[$my_facts_array[$x]]);
                  print "</option>";
                }
                ?>
                </select>
              </td>
              <td class="facts_value02">
                <select size="1" name="v_new_person_facts_choice">
                  <option value="details"><?php print $pgv_lang["fact_details"]; ?></option>";
                  <option value="show"><?php print $pgv_lang["fact_show"]; ?></option>";
                </select>
              </td>
              <td class="facts_value02">
                <select size="1" name="v_new_person_facts_acess_option"><?php write_access_option(""); ?></select>
              </td>
            </tr>
            <?php //--End----add person_facts for individuals----------------------------------------------- ?>

            <?php //--Start--add person_facts for sources--------------------------------------------------- ?>
            <tr>
              <td class="facts_label02" colspan="4"><?php print $pgv_lang["add_new_pf_setting_source"]; ?></td>
            </tr>

            <tr>
              <td class="facts_label02"><?php print $pgv_lang["privacy_source_id"]; ?></td>
              <td class="facts_label02"><?php print $pgv_lang["name_of_fact"]; ?></td>
              <td class="facts_label02"><?php print $pgv_lang["choice"]; ?></td>
              <td class="facts_label02"><?php print $pgv_lang["accessible_by"]; ?></td>
            </tr>

            <tr>
              <td class="facts_value02">
                <input type="hidden" name="v_new_person_facts_access_line" value="<?php print $variable[8][5]; ?>">
                <input type="text" name="v_new_person_facts_access_ID_source" size="4">
                <?php
                print " <font size=\"1\"><a href=\"javascript:open_find_source(document.editprivacyform.v_new_person_facts_access_ID_source);\">";
                print $pgv_lang["find_sourceid"];
                print "</a></font>";
                ?>
              </td>
              <td class="facts_value02">
                <select size="1" name="v_new_person_facts_abbr_source">
                <?php
                for ($x = 0; $x < count($my_facts_array); $x++)
                {
                  print "<option";
                  print " value=\"";
                  print $my_facts_array[$x];
                  print "\">";
                  print $my_facts_array[$x] . " - " . str_replace("<br />", " ", $factarray[$my_facts_array[$x]]);
                  print "</option>";
                }
                ?>
                </select>
              </td>
              <td class="facts_value02">
                <select size="1" name="v_new_person_facts_choice_source">
                  <option value="details"><?php print $pgv_lang["fact_details"]; ?></option>";
                  <option value="show"><?php print $pgv_lang["fact_show"]; ?></option>";
                </select>
              </td>
              <td class="facts_value02">
                <select size="1" name="v_new_person_facts_acess_option_source"><?php write_access_option(""); ?></select>
              </td>
            </tr>
            <?php //--End----add person_facts for sources--------------------------------------------------- ?>

            <tr>
              <td class="facts_label02" colspan="4"><input type="submit" name="B008" value="<?php print $pgv_lang["add_new_pf_setting"]; ?>"></td>
            </tr>

          </table>
          </center>

        </td>
      </tr>

      <tr>
        <td class="facts_label03">
          <?php
          if ($person_facts_array_counter > 0)
          {
          ?>
          <center>
          <table>
            <tr>
              <td class="facts_label02" colspan="6"><?php print $pgv_lang["edit_exist_person_facts_settings"]; ?></td>
            </tr>

            <tr>
              <td class="facts_label02"><?php print $pgv_lang["delete"]; ?></td>
              <td class="facts_label02"><?php print $pgv_lang["privacy_indi_source"]; ?></td>
              <td class="facts_label02"><?php print $pgv_lang["id"]; ?></td>
              <td class="facts_label02"><?php print $pgv_lang["name_of_fact"]; ?></td>
              <td class="facts_label02"><?php print $pgv_lang["choice"]; ?></td>
              <td class="facts_label02"><?php print $pgv_lang["accessible_by"]; ?></td>
            </tr>

            <?php

            for ($x = 0; $x < $person_facts_array_counter; $x++)
            {
            ?>

            <tr>

              <td class="facts_value02" style="text-align: center; ">
              <input type="hidden" name="v_person_facts_access_ID_<?php print $x; ?>" value="<?php print $person_facts_array[$x][1][0]; ?>">
              <input type="hidden" name="v_person_facts_abbr_<?php print $x; ?>" value="<?php print $person_facts_array[$x][1][1]; ?>">
              <input type="hidden" name="v_person_facts_choice_<?php print $x; ?>" value="<?php print $person_facts_array[$x][1][2]; ?>">
              <input type="checkbox" name="v_person_facts_del_<?php print $x; ?>" value="1"></td>

              <td class="facts_value02" style="text-align: center; "><?php
              if (strtoupper($person_facts_array[$x][1][0][0]) == "S") print $pgv_lang["privacy_source"]; else print $pgv_lang["privacy_indi"];
              ?></td>

              <td class="facts_value02" style="text-align: center; "><?php
                if (strtoupper($person_facts_array[$x][1][0][0]) == "S")
                {
                  print "<font class=\"list_item\">";
                  print get_source_descriptor($person_facts_array[$x][1][0]);
                  print "</font><br />" . $person_facts_array[$x][1][0];
                }
                else
                {
                  search_ID_details($person_facts_array[$x][1][0], 2);
                  print "<br />" . $person_facts_array[$x][1][0];
                }
              ?></td>
              <td class="facts_value02" style="text-align: center; ">
              <?php
                print $person_facts_array[$x][1][1];
                for ($y = 0; $y < count($my_facts_array); $y++)
                {
                  if ($my_facts_array[$y] == $person_facts_array[$x][1][1])
                  {
                    print "<br />(" . $factarray[$my_facts_array[$y]] . ")";
                    break;
                  }
                }
              ?></td>
              <td class="facts_value02" style="text-align: center; "><?php
              if ($person_facts_array[$x][1][2] == "show") print $pgv_lang["fact_show"];
              if ($person_facts_array[$x][1][2] == "details") print $pgv_lang["fact_details"];
              ?></td>
              <td class="facts_value02">
                <select size="1" name="v_person_facts_<?php print $x; ?>"><?php write_access_option($person_facts_array[$x][3]); ?></select>
              </td>
            </tr>

            <?php
            }
            ?>

            <tr>
              <td class="facts_label02" colspan="6"><input type="submit" name="B009" value="<?php print $pgv_lang["save_changed_settings"]; ?>"></td>
            </tr>
          </table>
          </center>
          <?php
          }
          else print "&nbsp";
          ?>
        </td>

      </tr>

    </table>
  <?php
  print "</center></div>";
}

/* ------------------------------------------------------------------------------------------------------------- */
function write_privacyfile()
{
  global $GEDCOMS, $GEDCOM, $INDEX_DIRECTORY;
  global $pgv_lang;
  global $konstante, $variable, $PGV_BASE_DIRECTORY, $PRIVACY_MODULE;
  global $privacy_array;
  global $person_privacy_array, $person_privacy_array_counter;
  global $user_privacy_array, $user_privacy_array_counter;
  global $global_facts_array, $global_facts_array_counter;
  global $person_facts_array, $person_facts_array_counter;
  global $v_SHOW_DEAD_PEOPLE;
  global $v_SHOW_LIVING_NAMES;
  global $v_SHOW_RESEARCH_LOG;
  global $v_USE_RELATIONSHIP_PRIVACY;
  global $v_MAX_RELATION_PATH_LENGTH;
  global $v_CHECK_MARRIAGE_RELATIONS;
  global $B001, $B002, $B003, $B004, $B006, $B008;
  global $v_new_person_privacy_access_ID, $v_new_person_privacy_acess_option, $v_new_person_privacy_access_line;
  global $v_new_user_privacy_username, $v_new_user_privacy_access_ID;
  global $v_new_user_privacy_acess_option, $v_new_user_privacy_access_line;
  global $v_new_global_facts_access_line, $v_new_global_facts_abbr, $v_new_global_facts_choice;
  global $v_new_global_facts_acess_option;
  global $v_new_person_facts_access_line, $v_new_person_facts_access_ID;
  global $v_new_person_facts_access_ID_source, $v_new_person_facts_abbr_source;
  global $v_new_person_facts_choice_source, $v_new_person_facts_acess_option_source;
  global $v_new_person_facts_abbr, $v_new_person_facts_choice, $v_new_person_facts_acess_option;

  # foreach($_POST as $key=>$value) { print "#" . $key . "# -> #" . $value . "#<br />"; }
  # exit;

  // -- if no privacy file exists create one by copying the original privacy.php
  $Filename = $PGV_BASE_DIRECTORY . $PRIVACY_MODULE;
  if (strstr($Filename, "privacy.php")) {
	@copy($Filename, $INDEX_DIRECTORY.$GEDCOM."_priv.php");
	$Filename = $INDEX_DIRECTORY.$GEDCOM."_priv.php";
	$GEDCOMS[$GEDCOM]["privacy"] = $Filename;
	store_gedcoms();
  }
  else {
  	@copy($Filename, $Filename . ".old");
  }

  if ($fp = @fopen($Filename, "w"))
  {

  for ($x = 0; $x < count($privacy_array); $x++)
  {
    $variable_01_found = false;
    $variable_02_found = false;
    $variable_03_found = false;
    $variable_04_found = false;
    $variable_05_found = false;
    $variable_06_found = false;
    $variable_07_found = false;
    $variable_08_found = false;
    $variable_09_found = false;
    $variable_10_found = false;

    if ($x == $variable[10][2])
    {
      $dDummy  = $variable[10][1];
      $dDummy .= " = ";
      $dDummy .= $konstante[$v_SHOW_DEAD_PEOPLE];
      $dDummy .= ";";
      $dDummy .= $variable[10][4];
      $dDummy .= "\r\n";
      # print $dDummy . "<br />";
      fwrite($fp, $dDummy);
      $variable_10_found = true;
    }

    if ($x == $variable[1][2])
    {
      $dDummy  = $variable[1][1];
      $dDummy .= " = ";
      $dDummy .= $konstante[$v_SHOW_LIVING_NAMES];
      $dDummy .= ";";
      $dDummy .= $variable[1][4];
      $dDummy .= "\r\n";
      # print $dDummy . "<br />";
      fwrite($fp, $dDummy);
      $variable_01_found = true;
    }

    if ($x == $variable[9][2])
    {
      $dDummy  = $variable[9][1];
      $dDummy .= " = ";
      $dDummy .= $konstante[$v_SHOW_RESEARCH_LOG];
      $dDummy .= ";";
      $dDummy .= $variable[9][4];
      $dDummy .= "\r\n";
      # print $dDummy . "<br />";
      fwrite($fp, $dDummy);
      $variable_09_found = true;
    }

    if ($x == $variable[2][2])
    {
      $dDummy  = $variable[2][1];
      $dDummy .= " = ";
      if ($v_USE_RELATIONSHIP_PRIVACY == 1){$dDummy .= "true";}else{$dDummy .= "false";}
      $dDummy .= ";";
      $dDummy .= $variable[2][4];
      $dDummy .= "\r\n";
      # print $dDummy . "<br />";
      fwrite($fp, $dDummy);
      $variable_02_found = true;
    }

    if ($x == $variable[3][2])
    {
      $dDummy  = $variable[3][1];
      $dDummy .= " = ";
      $dDummy .= $v_MAX_RELATION_PATH_LENGTH;
      $dDummy .= ";";
      $dDummy .= $variable[3][4];
      $dDummy .= "\r\n";
      # print $dDummy . "<br />";
      fwrite($fp, $dDummy);
      $variable_03_found = true;
    }

    if ($x == $variable[4][2])
    {
      $dDummy  = $variable[4][1];
      $dDummy .= " = ";
      if ($v_CHECK_MARRIAGE_RELATIONS == 1){$dDummy .= "true";}else{$dDummy .= "false";}
      $dDummy .= ";";
      $dDummy .= $variable[4][4];
      $dDummy .= "\r\n";
      # print $dDummy . "<br />";
      fwrite($fp, $dDummy);
      $variable_04_found = true;
    }

    for ($z = 0; $z < count($person_privacy_array); $z++)
    {
      if ($x == $person_privacy_array[$z][2])
      {
        $variable_05_found = true;

        if (!isset($GLOBALS["v_person_privacy_del_" . $z])) $GLOBALS["v_person_privacy_del_" . $z] = 0;
        if ($GLOBALS["v_person_privacy_del_" . $z] == 0)
        {
          $dDummy  = $variable[5][1];
          $dDummy  .= "[\"";
          # $dDummy .= "$v_person_privacy_id_" . $z;
          $dDummy .= $GLOBALS["v_person_privacy_id_" . $z];
          $dDummy  .= "\"]";
          $dDummy .= " = ";
          $dDummy .= $konstante[$GLOBALS["v_person_privacy_" . $z]];
          $dDummy .= ";";
          $dDummy .= $person_privacy_array[$z][4];
          $dDummy .= "\r\n";

          $person_privacy_array[$z][2] = "";
          # print "-".$dDummy . "-<br />";
          fwrite($fp, $dDummy);
        }
        break;
      }
    }

    for ($z = 0; $z < count($user_privacy_array); $z++)
    {
      if ($x == $user_privacy_array[$z][2])
      {
        $variable_06_found = true;

        if (!isset($GLOBALS["v_user_privacy_del_" . $z])) $GLOBALS["v_user_privacy_del_" . $z] = 0;
        if ($GLOBALS["v_user_privacy_del_" . $z] == 0)
        {
          $dDummy  = $variable[6][1];
          $dDummy  .= "[\"";
          $dDummy .= $GLOBALS["v_user_privacy_username_" . $z];
          $dDummy  .= "\"]";
          $dDummy  .= "[\"";
          $dDummy .= $GLOBALS["v_user_privacy_id_" . $z];
          $dDummy  .= "\"]";
          $dDummy .= " = ";
          $dDummy .= $konstante[$GLOBALS["v_user_privacy_" . $z]];
          $dDummy .= ";";
          $dDummy .= $user_privacy_array[$z][4];
          $dDummy .= "\r\n";

          $user_privacy_array[$z][2] = "";
          # print "-".$dDummy . "-<br />";
          fwrite($fp, $dDummy);
        }
        break;
      }
    }

    for ($z = 0; $z < count($global_facts_array); $z++)
    {
      if ($x == $global_facts_array[$z][2])
      {
        $variable_07_found = true;

        if (!isset($GLOBALS["v_global_facts_del_" . $z])) $GLOBALS["v_global_facts_del_" . $z] = 0;
        if ($GLOBALS["v_global_facts_del_" . $z] == 0)
        {
          $dDummy  = $variable[7][1];
          $dDummy  .= "[\"";
          $dDummy .= $GLOBALS["v_global_facts_abbr_" . $z];
          $dDummy  .= "\"]";
          $dDummy  .= "[\"";
          $dDummy .= $GLOBALS["v_global_facts_choice_" . $z];
          $dDummy  .= "\"]";
          $dDummy .= " = ";
          $dDummy .= $konstante[$GLOBALS["v_global_facts_" . $z]];
          $dDummy .= ";";
          $dDummy .= $global_facts_array[$z][4];
          $dDummy .= "\r\n";

          $global_facts_array[$z][2] = "";
          # print "-".$dDummy . "-<br />";
          fwrite($fp, $dDummy);
        }
        break;
      }
    }

    for ($z = 0; $z < count($person_facts_array); $z++)
    {
      if ($x == $person_facts_array[$z][2])
      {
        $variable_08_found = true;

        if (!isset($GLOBALS["v_person_facts_del_" . $z])) $GLOBALS["v_person_facts_del_" . $z] = 0;
        if ($GLOBALS["v_person_facts_del_" . $z] == 0)
        {
          $dDummy  = $variable[8][1];
          $dDummy  .= "[\"";
          $dDummy .= $GLOBALS["v_person_facts_access_ID_" . $z];
          $dDummy  .= "\"]";
          $dDummy  .= "[\"";
          $dDummy .= $GLOBALS["v_person_facts_abbr_" . $z];
          $dDummy  .= "\"]";
          $dDummy  .= "[\"";
          $dDummy .= $GLOBALS["v_person_facts_choice_" . $z];
          $dDummy  .= "\"]";
          $dDummy .= " = ";
          $dDummy .= $konstante[$GLOBALS["v_person_facts_" . $z]];
          $dDummy .= ";";
          $dDummy .= $person_facts_array[$z][4];
          $dDummy .= "\r\n";

          $person_facts_array[$z][2] = "";
          # print "-".$dDummy . "-<br />";
          fwrite($fp, $dDummy);
        }
        break;
      }
    }

    if ((!$variable_01_found) and
        (!$variable_02_found) and
        (!$variable_03_found) and
        (!$variable_04_found) and
        (!$variable_05_found) and
        (!$variable_06_found) and
        (!$variable_07_found) and
        (!$variable_08_found) and
        (!$variable_09_found) and
        (!$variable_10_found))
    {
      # print $privacy_array[$x] . "<br />";
      fwrite($fp, $privacy_array[$x]);

      if ($x == $v_new_person_privacy_access_line)
      {
      	if (!isset($B002)) $B002 = "";
      	if ($B002 == $pgv_lang["add_new_pp_setting"])
      	{
      	  if ($v_new_person_privacy_access_ID != "")
      	  {
      	    $dDummy  = $variable[5][1];
      	    $dDummy  .= "[\"";
      	    $dDummy .= $v_new_person_privacy_access_ID;
      	    $dDummy  .= "\"]";
      	    $dDummy .= " = ";
      	    $dDummy .= $konstante[$v_new_person_privacy_acess_option];
      	    $dDummy .= ";";
      	    $dDummy .= "\r\n";

      	    # print "-".$dDummy . "-<br />";
      	    fwrite($fp, $dDummy);
      	  }
      	}
      	$B002 = "";
      	$v_new_person_privacy_access_line = (-1);
      }

      if ($x == $v_new_user_privacy_access_line)
      {
      	if (!isset($B004)) $B004 = "";
      	if ($B004 == $pgv_lang["add_new_up_setting"])
      	{
      	  if ($v_new_user_privacy_username != "")
      	  {
      	    $dDummy  = $variable[6][1];
      	    $dDummy  .= "[\"";
      	    $dDummy .= $v_new_user_privacy_username;
      	    $dDummy  .= "\"]";
      	    $dDummy  .= "[\"";
      	    $dDummy .= $v_new_user_privacy_access_ID;
      	    $dDummy  .= "\"]";
      	    $dDummy .= " = ";
      	    $dDummy .= $konstante[$v_new_user_privacy_acess_option];
      	    $dDummy .= ";";
      	    $dDummy .= "\r\n";

      	    # print "-".$dDummy . "-<br />";
      	    fwrite($fp, $dDummy);
      	  }
      	}
      	$B004 = "";
      	$v_new_user_privacy_access_line = (-1);
      }

      if ($x == $v_new_global_facts_access_line)
      {
      	# print "-Gefunden- $B008 -<br />"; Exit;
      	if (!isset($B006)) $B006 = "";
      	if ($B006 == $pgv_lang["add_new_gf_setting"])
      	{
          $dDummy  = $variable[7][1];
          $dDummy  .= "[\"";
          $dDummy .= $v_new_global_facts_abbr;
          $dDummy  .= "\"]";
          $dDummy  .= "[\"";
          $dDummy .= $v_new_global_facts_choice;
          $dDummy  .= "\"]";
          $dDummy .= " = ";
          $dDummy .= $konstante[$v_new_global_facts_acess_option];
          $dDummy .= ";";
          $dDummy .= "\r\n";

          # print "-".$dDummy . "-<br />";
          fwrite($fp, $dDummy);
        }
      	$B006 = "";
      	$v_new_global_facts_access_line = (-1);
      }

      if ($x == $v_new_person_facts_access_line)
      {
      	if (!isset($B008)) $B008 = "";
      	if ($B008 == $pgv_lang["add_new_pf_setting"])
      	{
          if ($v_new_person_facts_access_ID != "")
          {
          $dDummy  = $variable[8][1];
          $dDummy  .= "[\"";
          $dDummy .= $v_new_person_facts_access_ID;
          $dDummy  .= "\"]";
          $dDummy  .= "[\"";
          $dDummy .= $v_new_person_facts_abbr;
          $dDummy  .= "\"]";
          $dDummy  .= "[\"";
          $dDummy .= $v_new_person_facts_choice;
          $dDummy  .= "\"]";
          $dDummy .= " = ";
          $dDummy .= $konstante[$v_new_person_facts_acess_option];
          $dDummy .= ";";
          $dDummy .= "\r\n";
          # print "-".$dDummy . "-<br />";
          fwrite($fp, $dDummy);
        }
          if ($v_new_person_facts_access_ID_source != "")
          {
            $dDummy  = $variable[8][1];
            $dDummy  .= "[\"";
            $dDummy .= $v_new_person_facts_access_ID_source;
            $dDummy  .= "\"]";
            $dDummy  .= "[\"";
            $dDummy .= $v_new_person_facts_abbr_source;
            $dDummy  .= "\"]";
            $dDummy  .= "[\"";
            $dDummy .= $v_new_person_facts_choice_source;
            $dDummy  .= "\"]";
            $dDummy .= " = ";
            $dDummy .= $konstante[$v_new_person_facts_acess_option_source];
            $dDummy .= ";";
            $dDummy .= "\r\n";
            # print "-".$dDummy . "-<br />";
            fwrite($fp, $dDummy);
          }
        }
      	$B008 = "";
      	$v_new_person_facts_access_line = (-1);
      }
    }
  }
  fclose($fp);
  }
  else
  {
    print "<center class=\"error\">";
    print str_replace("#PRIVACY_MODULE#", $PRIVACY_MODULE, $pgv_lang["privacy_write_error"]);
    print "</center><br /><br />";
  }
}

function write_javascript()
{
?>
  <script language="JavaScript">
  var pasteto;
  function open_find(textbox)
  {
    pasteto = textbox;
    findwin = window.open('findid.php', '', 'left=50,top=50,width=410,height=320,resizable=1,scrollbars=1');
  }
  function open_find_source(textbox)
  {
    pasteto = textbox;
    findwin = window.open('find_sourceid.php', '', 'left=50,top=50,width=410,height=320,resizable=1,scrollbars=1');
  }
  function paste_id(value)
  {
    pasteto.value=value;
  }
  </script>
<?php
}

//------------------------------------------------------------------------
//-- Body of script
//------------------------------------------------------------------------

  read_privacyfile();

  switch ($action)
  {
    case "edit" :
		  print_header("PhpGedView - " . $pgv_lang["privacy_header"] . " \"" . $PRIVACY_MODULE . "\"");
		  write_javascript();
		  read_factsfile();
		  showeditmask();
		  break;
    case "save" : $QUERY_STRING = "";
		  print_header("PhpGedView - " . $pgv_lang["privacy_header"] . " \"" . $PRIVACY_MODULE . "\"");
		  write_privacyfile();
		  $action = "edit";
		  unset($person_privacy_array);	$person_privacy_array = array(); $person_privacy_array_counter = 0;
		  unset($user_privacy_array);	$user_privacy_array = array();   $user_privacy_array_counter = 0;
		  unset($global_facts_array);	$global_facts_array = array();   $global_facts_array_counter = 0;
		  unset($person_facts_array);	$person_facts_array = array();   $person_facts_array_counter = 0;
		  unset($privacy_array);	$privacy_array = array();
		  unset($my_facts_array);	$my_facts_array = array();
		  read_privacyfile();
		  write_javascript();
		  read_factsfile();
		  showeditmask();
		  break;
    default :	  header("Location: $url"); break;
  }

  print_footer();
?>