<?php
/*=================================================
	Project: phpGedView
	File: editconfig.php
	Author: John Finlay
	Comments:
		UI for online updating of the config file.

	phpGedView: Genealogy Viewer
    Copyright (C) 2002 to 2003  John Finlay and Others

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

===================================================*/
# $Id: editconfig.php,v 1.41.2.1 2004/01/28 20:17:35 botak Exp $

require "config.php";
require $PGV_BASE_DIRECTORY.$confighelpfile["english"];
if (file_exists($PGV_BASE_DIRECTORY.$confighelpfile[$LANGUAGE])) require $PGV_BASE_DIRECTORY.$confighelpfile[$LANGUAGE];

if (empty($action)) $action="";

if ($CONFIGURED) {
if (($PGV_DATABASE=='index')||(check_db())) {
	//-- check if no users have been defined and create the main admin user
	if (!adminUserExists()) {
		print_header("PhpGedView Configuration");
		print "<font class=\"subheaders\">".$pgv_lang["configure"]."</font><br />";
		print $pgv_lang["welcome"]."<br />";
		if ($action=="createadminuser") {
			if ($pass1==$pass2) {
				$user = array();
				$user["username"]=$username;
				$user["fullname"]=$fullname;
				$user["password"]=crypt($pass1);
				$user["canedit"] = array();
				$user["rootid"] = array();
				$user["gedcomid"] = array();
				$user["canadmin"]=true;
				$user["email"]=$emailadress;
				$user["verified"] = "yes";
				$user["verified_by_admin"] = "yes";
				$user["pwrequested"] = "";
				$user["theme"] = "";
				$user["theme"] = "Y";
				$user["language"] = $LANGUAGE;
				$user["reg_timestamp"] = date("U");
				$user["reg_hashcode"] = "";
				$user["loggedin"] = "Y";
				$user["sessiontime"] = 0;
				$au = addUser($user);
				if ($au) {
					print $pgv_lang["user_created"]."<br />";
					print "<a href=\"editgedcoms.php\">".$pgv_lang["click_here_to_continue"]."</a><br />";
					$_SESSION["pgv_user"]=$username;
					print_footer();
					exit;
				}
				else {
					print "<font class=error>".$pgv_lang["user_create_error"]."<br /></font>";
					print_footer();
					exit;
				}
			}
			else {
				print "<font class=error>".$pgv_lang["password_mismatch"]."<br /></font>";
				print_footer();
				exit;
			}
		}
		else {
			?>
			<script language="JavaScript">
				function checkform(frm) {
					if (frm.username.value=="") {
						alert("<?php print $pgv_lang["enter_username"]; ?>");
						frm.username.focus();
						return false;
					}
					if (frm.fullname.value=="") {
						alert("<?php print $pgv_lang["enter_fullname"]; ?>");
						frm.fullname.focus();
						return false;
					}
					if (frm.pass1.value=="") {
						alert("<?php print $pgv_lang["enter_password"]; ?>");
						frm.pass1.focus();
						return false;
					}
					if (frm.pass2.value=="") {
						alert("<?php print $pgv_lang["confirm_password"]; ?>");
						frm.pass2.focus();
						return false;
					}
					return true;
				}
			</script>
			<form method="post" onsubmit="return checkform(this);">
			<input type="hidden" name="action" value="createadminuser">
			<b><?php print $pgv_lang["default_user"]?></b><br />
			<?php print $pgv_lang["about_user"]?><br /><br />
			<table>
				<tr><td align="right"><?php print $pgv_lang["username"]?></td><td><input type="text" name="username"></td></tr>
				<tr><td align="right"><?php print $pgv_lang["fullname"]?></td><td><input type="text" name="fullname"></td></tr>
				<tr><td align="right"><?php print $pgv_lang["password"]?></td><td><input type="password" name="pass1"></td></tr>
				<tr><td align="right"><?php print $pgv_lang["confirm"]?></td><td><input type="password" name="pass2"></td></tr>
				<tr><td align="right"><?php print $pgv_lang["emailadress"]?></td><td><input type="text" name="emailadress" size="45"></td></tr>
			</table>
			<input type="submit" value="<?php print $pgv_lang["create_user"]; ?>" />
			</form>
			<?php
			print_footer();
			exit;
		}
	}
	if (!userIsAdmin(getUserName())) {
		header("Location: login.php?url=editconfig.php");
		exit;
	}
}
}

print_header("PhpGedView Configuration");
print "<font class=\"subheaders\">".$pgv_lang["configure"]."</font><br />";
print $pgv_lang["welcome"]."<br />";
if ($action=="update") {
	if (!isset($_POST)) $_POST = $HTTP_POST_VARS;
	$boolarray = array();
	$boolarray["yes"]="true";
	$boolarray["no"]="false";
	$boolarray[false]="false";
	$boolarray[true]="true";
	print $pgv_lang["performing_update"]."<br />";
	$configtext = implode('', file("config.php"));
	print $pgv_lang["config_file_read"]."<br />\n";
	if (preg_match("'://'", $NEW_SERVER_URL)==0) $NEW_SERVER_URL = "http://".$NEW_SERVER_URL;
	if (preg_match("'/$'", $NEW_SERVER_URL)==0) $NEW_SERVER_URL .= "/";
	$configtext = preg_replace('/\$PGV_DATABASE\s*=\s*".*";/', "\$PGV_DATABASE = \"".$_POST["NEW_PGV_DATABASE"]."\";", $configtext);
	$configtext = preg_replace('/\$DBHOST\s*=\s*".*";/', "\$DBHOST = \"".$_POST["NEW_DBHOST"]."\";", $configtext);
	$configtext = preg_replace('/\$DBUSER\s*=\s*".*";/', "\$DBUSER = \"".$_POST["NEW_DBUSER"]."\";", $configtext);
	$configtext = preg_replace('/\$DBPASS\s*=\s*".*";/', "\$DBPASS = \"".$_POST["NEW_DBPASS"]."\";", $configtext);
	$configtext = preg_replace('/\$DBNAME\s*=\s*".*";/', "\$DBNAME = \"".$_POST["NEW_DBNAME"]."\";", $configtext);
	$configtext = preg_replace('/\$TBLPREFIX\s*=\s*".*";/', "\$TBLPREFIX = \"".$_POST["NEW_TBLPREFIX"]."\";", $configtext);
	$configtext = preg_replace('/\$ALLOW_CHANGE_GEDCOM\s*=\s*.*;/', "\$ALLOW_CHANGE_GEDCOM = ".$boolarray[$_POST["NEW_ALLOW_CHANGE_GEDCOM"]].";", $configtext);
	$configtext = preg_replace('/\$USE_REGISTRATION_MODULE\s*=\s*.*;/', "\$USE_REGISTRATION_MODULE = ".$boolarray[$_POST["NEW_USE_REGISTRATION_MODULE"]].";", $configtext);
	$configtext = preg_replace('/\$ALLOW_USER_THEMES\s*=\s*.*;/', "\$ALLOW_USER_THEMES = ".$boolarray[$_POST["NEW_ALLOW_USER_THEMES"]].";", $configtext);
	$configtext = preg_replace('/\$INDEX_DIRECTORY\s*=\s*".*";/', "\$INDEX_DIRECTORY = \"".$_POST["NEW_INDEX_DIRECTORY"]."\";", $configtext);
	$configtext = preg_replace('/\$AUTHENTICATION_MODULE\s*=\s*".*";/', "\$AUTHENTICATION_MODULE = \"".$_POST["NEW_AUTHENTICATION_MODULE"]."\";", $configtext);
	$configtext = preg_replace('/\$LOGFILE_CREATE\s*=\s*".*";/', "\$LOGFILE_CREATE = \"".$_POST["NEW_LOGFILE_CREATE"]."\";", $configtext);
	$configtext = preg_replace('/\$PGV_SESSION_SAVE_PATH\s*=\s*".*";/', "\$PGV_SESSION_SAVE_PATH = \"".$_POST["NEW_PGV_SESSION_SAVE_PATH"]."\";", $configtext);
	$configtext = preg_replace('/\$PGV_SESSION_TIME\s*=\s*".*";/', "\$PGV_SESSION_TIME = \"".$_POST["NEW_PGV_SESSION_TIME"]."\";", $configtext);
	$configtext = preg_replace('/\$SERVER_URL\s*=\s*".*";/', "\$SERVER_URL = \"".$_POST["NEW_SERVER_URL"]."\";", $configtext);
	$configtext = preg_replace('/\$CONFIGURED\s*=\s*.*;/', "\$CONFIGURED = true;", $configtext);

	if (!isset($download)) {
		$fp = fopen("config.php", "wb");
		if (!$fp) {
			print "<font class=error>".$pgv_lang["config_write_error"]."<br /></font>\n";
		}
		else {
			fwrite($fp, $configtext);
			fclose($fp);
			if (!$CONFIGURED) print "<script language=\"JavaScript\">\nwindow.location = 'editconfig.php';\n</script>\n";
			$CONFIGURED = true;
		}
		foreach($_POST as $key=>$value) {
			$key=preg_replace("/NEW_/", "", $key);
			if ($value=='yes') $$key=true;
			else if ($value=='no') $$key=false;
			else $$key=stripslashes($value);
		}
	}
	else {
		$_SESSION["config.php"]=$configtext;
		print "<br /><br /><a href=\"config_download.php?file=config.php\">".$pgv_lang["download_here"]."</a><br /><br />\n";
	}
	AddToLog("Site configuration config.php updated by >".getUserName()."<");
}

?>
<script language="JavaScript">
	var helpWin;
	function helpPopup(which) {
		if ((!helpWin)||(helpWin.closed)) helpWin = window.open('editconfig_help.php?help='+which,'','left=50,top=50,width=400,height=320,resizable=1,scrollbars=1');
		else helpWin.location = 'editconfig_help.php?help='+which;
		return false;
	}
	function getHelp(which) {
		if ((helpWin)&&(!helpWin.closed)) helpWin.location='editconfig_help.php?help='+which;
	}
	function closeHelp() {
		if (helpWin) helpWin.close();
	}
	function show_mysql(dbselect, sid) {
		var sbox = document.getElementById(sid);
		var sbox_style = sbox.style;
		var auth_loc = document.getElementById('NEW_AUTHENTICATION_MODULE');

		if (dbselect.options[dbselect.selectedIndex].value=='mysql') {
			sbox_style.display='block';
			auth_loc.value = 'authentication_mysql.php';
		}
		else {
			sbox_style.display='none';
			auth_loc.value = 'authentication_index.php';
		}
	}
</script>
<form method="post" name="configform">
<?php
	if (($PGV_DATABASE=='mysql')&& (!$DBSEL || !$DBCONN)) {
		$CONFIGURED=false;
		print "<font class=\"error\">".$pgv_lang["db_setup_bad"]."</font><br />";
	}

	print $pgv_lang["review_readme"];
	if ($CONFIGURED) print "<br /><br /><a href=\"editgedcoms.php\">".$pgv_lang["admin_gedcoms"]."</a><br />\n";
?>
<input type="hidden" name="action" value="update">
<table class="facts_table">
	<tr>
		<td class="facts_label"><?php print $pgv_lang["PGV_DATABASE"]?> <a href="#" onclick="return helpPopup('PGV_DATABASE_help');"><b>?</b></a></td>
		<td class="facts_value"><select name="NEW_PGV_DATABASE" tabindex="1" onfocus="getHelp('PGV_DATABASE_help');" onchange="show_mysql(this, 'mysql-options');">
				<option value="index" <?php if ($PGV_DATABASE=='index') print "selected=\"selected\""; ?>><?php print $pgv_lang["index"];?></option>
				<option value="mysql" <?php if ($PGV_DATABASE=='mysql') print "selected=\"selected\""; ?>><?php print $pgv_lang["mysql"];?></option>
			</select>
		</td>
	</tr>
</table>
	<div id="mysql-options" style="display: <?php if ($PGV_DATABASE=='mysql') print 'block'; else print 'none'; ?>;">
	<table class="facts_table">
	<tr>
		<td class="facts_label"><?php print $pgv_lang["DBHOST"]?> <a href="#" onclick="return helpPopup('DBHOST_help');"><b>?</b></a></td>
		<td class="facts_value"><input type="text" name="NEW_DBHOST" value="<?php print $DBHOST?>" size="40" tabindex="2" onfocus="getHelp('DBHOST_help');" /></td>
	</tr>
	<tr>
		<td class="facts_label"><?php print $pgv_lang["DBUSER"]?> <a href="#" onclick="return helpPopup('DBUSER_help');"><b>?</b></a></td>
		<td class="facts_value"><input type="text" name="NEW_DBUSER" value="<?php print $DBUSER?>" size="40" tabindex="3" onfocus="getHelp('DBUSER_help');" /></td>
	</tr>
	<tr>
		<td class="facts_label"><?php print $pgv_lang["DBPASS"]?> <a href="#" onclick="return helpPopup('DBPASS_help');"><b>?</b></a></td>
		<td class="facts_value"><input type="password" name="NEW_DBPASS" value="<?php print $DBPASS?>" size="40" tabindex="4" onfocus="getHelp('DBPASS_help');" /></td>
	</tr>
	<tr>
		<td class="facts_label"><?php print $pgv_lang["DBNAME"]?> <a href="#" onclick="return helpPopup('DBNAME_help');"><b>?</b></a></td>
		<td class="facts_value"><input type="text" name="NEW_DBNAME" value="<?php print $DBNAME?>" size="40" tabindex="5" onfocus="getHelp('DBNAME_help');" /></td>
	</tr>
	<tr>
		<td class="facts_label"><?php print $pgv_lang["TBLPREFIX"]?> <a href="#" onclick="return helpPopup('TBLPREFIX_help');"><b>?</b></a></td>
		<td class="facts_value"><input type="text" name="NEW_TBLPREFIX" value="<?php print $TBLPREFIX?>" size="40" tabindex="6" onfocus="getHelp('TBLPREFIX_help');" /></td>
	</tr>
	</table>
	</div>
	<table class="facts_table">
	<tr>
		<td class="facts_label"><?php print $pgv_lang["ALLOW_CHANGE_GEDCOM"]?> <a href="#" onclick="return helpPopup('ALLOW_CHANGE_GEDCOM_help');"><b>?</b></a></td>
		<td class="facts_value"><select name="NEW_ALLOW_CHANGE_GEDCOM" tabindex="8" onfocus="getHelp('ALLOW_CHANGE_GEDCOM_help');">
				<option value="yes" <?php if ($ALLOW_CHANGE_GEDCOM) print "selected"; ?>><?php print $pgv_lang["yes"];?></option>
				<option value="no" <?php if (!$ALLOW_CHANGE_GEDCOM) print "selected"; ?>><?php print $pgv_lang["no"];?></option>
			</select>
		</td>
	</tr>
	<tr>
		<td class="facts_label"><?php print $pgv_lang["INDEX_DIRECTORY"]?> <a href="#" onclick="return helpPopup('INDEX_DIRECTORY_help');"><b>?</b></a></td>
		<td class="facts_value"><input type="text" name="NEW_INDEX_DIRECTORY" value="<?php print $INDEX_DIRECTORY?>" tabindex="9" onfocus="getHelp('INDEX_DIRECTORY_help');" /></td>
	</tr>
	<tr>
		<td class="facts_label"><?php print $pgv_lang["AUTHENTICATION_MODULE"]?> <a href="#" onclick="return helpPopup('AUTHENTICATION_MODULE_help');"><b>?</b></a></td>
		<td class="facts_value"><input type="text" name="NEW_AUTHENTICATION_MODULE" value="<?php print $AUTHENTICATION_MODULE?>" tabindex="10" onfocus="getHelp('AUTHENTICATION_MODULE_help');" /></td>
	</tr>
	<tr>
		<td class="facts_label"><?php print $pgv_lang["USE_REGISTRATION_MODULE"]?> <a href="#" onclick="return helpPopup('USE_REGISTRATION_MODULE_help');"><b>?</b></a></td>
		<td class="facts_value"><select name="NEW_USE_REGISTRATION_MODULE" tabindex="11" onfocus="getHelp('USE_REGISTRATION_MODULE_help');">
				<option value="yes" <?php if ($USE_REGISTRATION_MODULE) print "selected=\"selected\""; ?>><?php print $pgv_lang["yes"];?></option>
				<option value="no" <?php if (!$USE_REGISTRATION_MODULE) print "selected=\"selected\""; ?>><?php print $pgv_lang["no"];?></option>
			</select>
		</td>
	</tr>
	<tr>
		<td class="facts_label"><?php print $pgv_lang["ALLOW_USER_THEMES"]?> <a href="#" onclick="return helpPopup('ALLOW_USER_THEMES_help');"><b>?</b></a></td>
		<td class="facts_value"><select name="NEW_ALLOW_USER_THEMES" tabindex="12" onfocus="getHelp('ALLOW_USER_THEMES_help');">
				<option value="yes" <?php if ($ALLOW_USER_THEMES) print "selected=\"selected\""; ?>><?php print $pgv_lang["yes"];?></option>
				<option value="no" <?php if (!$ALLOW_USER_THEMES) print "selected=\"selected\""; ?>><?php print $pgv_lang["no"];?></option>
			</select>
		</td>
	</tr>
	<tr>
		<td class="facts_label"><?php print $pgv_lang["LOGFILE_CREATE"]?> <a href="#" onclick="return helpPopup('LOGFILE_CREATE_help');"><b>?</b></a></td>
		<td class="facts_value"><select name="NEW_LOGFILE_CREATE" tabindex="13" onfocus="getHelp('LOGFILE_CREATE_help');">
				<option value="none" <?php if ($LOGFILE_CREATE=="none") print "selected=\"selected\""; ?>><?php print $pgv_lang["no_logs"];?></option>
				<option value="daily" <?php if ($LOGFILE_CREATE=="daily") print "selected=\"selected\""; ?>><?php print $pgv_lang["daily"];?></option>
				<option value="weekly" <?php if ($LOGFILE_CREATE=="weekly") print "selected=\"selected\""; ?>><?php print $pgv_lang["weekly"];?></option>
				<option value="monthly" <?php if ($LOGFILE_CREATE=="monthly") print "selected=\"selected\""; ?>><?php print $pgv_lang["monthly"];?></option>
				<option value="yearly" <?php if ($LOGFILE_CREATE=="yearly") print "selected=\"selected\""; ?>><?php print $pgv_lang["yearly"];?></option>
			</select>
		</td>
	</tr>
	<tr>
		<td class="facts_label"><?php print $pgv_lang["SERVER_URL"]?> <a href="#" onclick="return helpPopup('SERVER_URL_help');"><b>?</b></a></td>
		<td class="facts_value"><input type="text" name="NEW_SERVER_URL" value="<?php print stripslashes($SERVER_URL)?>" tabindex="14" onfocus="getHelp('SERVER_URL_help');" size="100" /></td>
	</tr>
	<tr>
		<td class="facts_label"><?php print $pgv_lang["PGV_SESSION_SAVE_PATH"]?> <a href="#" onclick="return helpPopup('PGV_SESSION_SAVE_PATH_help');"><b>?</b></a></td>
		<td class="facts_value"><input type="text" name="NEW_PGV_SESSION_SAVE_PATH" value="<?php print $PGV_SESSION_SAVE_PATH?>" tabindex="15" onfocus="getHelp('PGV_SESSION_SAVE_PATH_help');" /></td>
	</tr>
	<tr>
		<td class="facts_label"><?php print $pgv_lang["PGV_SESSION_TIME"]?> <a href="#" onclick="return helpPopup('PGV_SESSION_TIME_help');"><b>?</b></a></td>
		<td class="facts_value"><input type="text" name="NEW_PGV_SESSION_TIME" value="<?php print $PGV_SESSION_TIME?>" tabindex="16" onfocus="getHelp('PGV_SESSION_TIME_help');" /></td>
	</tr>
</table>
<input type="submit" tabindex="17" value="<?php print $pgv_lang["save_config"]?>" onclick="closeHelp();" />
<input type="reset" tabindex="18" value="<?php print $pgv_lang["reset"]?>" /><br />
<?php
	if (!is_writable("config.php")) {
			print $pgv_lang["not_writable"]."<br /><input type=\"submit\" value=\"".$pgv_lang["download_file"]."\" name=\"download\" /><br />\n";
	}
?>
</form>
<?php if (!$CONFIGURED) { ?>
<script language="JavaScript">
	helpPopup('welcome_help');
</script>
<?php
}

print_footer();

?>
