<?php
/*=================================================
	Project: phpGedView
	File: editconfig.php
	Author: John Finlay
	Comments:
		UI for online updating of the config file.

	phpGedView: Genealogy Viewer
    Copyright (C) 2002 to 2003  John Finlay and Others

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

===================================================*/
# $Id: editconfig_gedcom.php,v 1.57.2.4 2004/01/27 21:25:23 yalnifj Exp $

require "config.php";

if (empty($action)) $action="";
if (!userIsAdmin(getUserName())) {
	if (!isset($ged)) $ged="";
	header("Location: login.php?url=editconfig_gedcom.php?ged=$ged");
	exit;
}

require $PGV_BASE_DIRECTORY.$confighelpfile["english"];
if (file_exists($PGV_BASE_DIRECTORY.$confighelpfile[$LANGUAGE])) require $PGV_BASE_DIRECTORY.$confighelpfile[$LANGUAGE];

print_header("GEDCOM Configuration");
print "<font class=\"subheaders\">".$pgv_lang["configure"]."</font><br />";
print $pgv_lang["welcome"]."<br />";

if (!isset($_POST)) $_POST = $HTTP_POST_VARS;
if (empty($oldged)) $oldged = "";
if (!empty($ged)) {
	$GEDCOMPATH = $GEDCOMS[$ged]["path"];
	$gedcom_title = $GEDCOMS[$ged]["title"];
	$gedcom_config = $GEDCOMS[$ged]["config"];
	$gedcom_privacy = $GEDCOMS[$ged]["privacy"];
	$FILE = $ged;
	$oldged = $ged;
}
else {
	if (empty($_POST["GEDCOMPATH"])) {
		$GEDCOMPATH = "";
		$gedcom_title = "";
	}
	$gedcom_config = "config_gedcom.php";
	$gedcom_privacy = "privacy.php";
}

require($gedcom_config);

if ($action=="update") {
	if (!isset($_POST)) $_POST = $HTTP_POST_VARS;
	//-- only get the filename from the path
	$slpos = strrpos($GEDCOMPATH, "/");
	if (!$slpos) $slpos = strrpos($GEDCOMPATH,"\\");
	if ($slpos) $FILE = substr($GEDCOMPATH, $slpos+1);
	else $FILE=$GEDCOMPATH;
	$newgedcom=false;
	$gedcom_config="config_gedcom.php";
	if (copy($gedcom_config, $INDEX_DIRECTORY.$FILE."_conf.php")) {
		$gedcom_config = $INDEX_DIRECTORY.$FILE."_conf.php";
	}
	if (!file_exists($INDEX_DIRECTORY.$FILE."_priv.php")) {
		if (copy($gedcom_privacy, $INDEX_DIRECTORY.$FILE."_priv.php")) {
			$gedcom_privacy = $INDEX_DIRECTORY.$FILE."_priv.php";
		}
	}
	if (!empty($oldged)) {
		unset($GEDCOMS[$oldged]);
		if ($oldged!=$FILE) {
			$newgedcom = true;
			delete_gedcom($oldged);
		}
	}
	$gedarray = array();
	$gedarray["gedcom"] = $FILE;
	$gedarray["config"] = $gedcom_config;
	$gedarray["privacy"] = $gedcom_privacy;
	$gedarray["title"] = $gedcom_title;
	$gedarray["path"] = $GEDCOMPATH;
	$GEDCOMS[$FILE] = $gedarray;
	store_gedcoms();
	$boolarray = array();
	$boolarray["yes"]="true";
	$boolarray["no"]="false";
	$boolarray[false]="false";
	$boolarray[true]="true";
	print $pgv_lang["performing_update"]."<br />";
	$configtext = implode('', file($gedcom_config));
	print $pgv_lang["config_file_read"].": $gedcom_config<br />\n";

	$ct = preg_match("'/$'", $_POST["NEW_MEDIA_DIRECTORY"]);
	if ($ct==0) $_POST["NEW_MEDIA_DIRECTORY"] .= "/";
	if (preg_match("'://'", $_POST["NEW_HOME_SITE_URL"])==0) $_POST["NEW_HOME_SITE_URL"] = "http://".$_POST["NEW_HOME_SITE_URL"];
	if (preg_match("'/$'", $_POST["NEW_HOME_SITE_URL"])==0) $_POST["NEW_HOME_SITE_URL"] .= "/";
	$configtext = preg_replace('/\$LANGUAGE\s*=\s*".*";/', "\$LANGUAGE = \"".$_POST["NEWLANGUAGE"]."\";", $configtext);
	$configtext = preg_replace('/\$CALENDAR_FORMAT\s*=\s*".*";/', "\$CALENDAR_FORMAT = \"".$_POST["NEW_CALENDAR_FORMAT"]."\";", $configtext);
	$configtext = preg_replace('/\$DISPLAY_JEWISH_THOUSANDS\s*=\s*.*;/', "\$DISPLAY_JEWISH_THOUSANDS = ".$boolarray[$_POST["NEW_DISPLAY_JEWISH_THOUSANDS"]].";", $configtext);
	$configtext = preg_replace('/\$DISPLAY_JEWISH_GERESHAYIM\s*=\s*.*;/', "\$DISPLAY_JEWISH_GERESHAYIM = ".$boolarray[$_POST["NEW_DISPLAY_JEWISH_GERESHAYIM"]].";", $configtext);
	$configtext = preg_replace('/\$JEWISH_ASHKENAZ_PRONUNCIATION\s*=\s*.*;/', "\$JEWISH_ASHKENAZ_PRONUNCIATION = ".$boolarray[$_POST["NEW_JEWISH_ASHKENAZ_PRONUNCIATION"]].";", $configtext);
	$configtext = preg_replace('/\$CHARACTER_SET\s*=\s*".*";/', "\$CHARACTER_SET = \"".$_POST["NEW_CHARACTER_SET"]."\";", $configtext);
	$configtext = preg_replace('/\$CREATE_GENDEX\s*=\s*.*;/', "\$CREATE_GENDEX = ".$boolarray[$_POST["NEW_CREATE_GENDEX"]].";", $configtext);
	$configtext = preg_replace('/\$ENABLE_MULTI_LANGUAGE\s*=\s*.*;/', "\$ENABLE_MULTI_LANGUAGE = ".$boolarray[$_POST["NEW_ENABLE_MULTI_LANGUAGE"]].";", $configtext);
	$configtext = preg_replace('/\$DEFAULT_PEDIGREE_GENERATIONS\s*=\s*".*";/', "\$DEFAULT_PEDIGREE_GENERATIONS = \"".$_POST["NEW_DEFAULT_PEDIGREE_GENERATIONS"]."\";", $configtext);
	$configtext = preg_replace('/\$MAX_PEDIGREE_GENERATIONS\s*=\s*".*";/', "\$MAX_PEDIGREE_GENERATIONS = \"".$_POST["NEW_MAX_PEDIGREE_GENERATIONS"]."\";", $configtext);
	$configtext = preg_replace('/\$MAX_DESCENDANCY_GENERATIONS\s*=\s*".*";/', "\$MAX_DESCENDANCY_GENERATIONS = \"".$_POST["NEW_MAX_DESCENDANCY_GENERATIONS"]."\";", $configtext);
	$configtext = preg_replace('/\$USE_RIN\s*=\s*.*;/', "\$USE_RIN = ".$boolarray[$_POST["NEW_USE_RIN"]].";", $configtext);
	$configtext = preg_replace('/\$PEDIGREE_ROOT_ID\s*=\s*".*";/', "\$PEDIGREE_ROOT_ID = \"".$_POST["NEW_PEDIGREE_ROOT_ID"]."\";", $configtext);
	$configtext = preg_replace('/\$GEDCOM_ID_PREFIX\s*=\s*".*";/', "\$GEDCOM_ID_PREFIX = \"".$_POST["NEW_GEDCOM_ID_PREFIX"]."\";", $configtext);
	$configtext = preg_replace('/\$PEDIGREE_FULL_DETAILS\s*=\s*.*;/', "\$PEDIGREE_FULL_DETAILS = ".$boolarray[$_POST["NEW_PEDIGREE_FULL_DETAILS"]].";", $configtext);
	$configtext = preg_replace('/\$PEDIGREE_LAYOUT\s*=\s*.*;/', "\$PEDIGREE_LAYOUT = ".$boolarray[$_POST["NEW_PEDIGREE_LAYOUT"]].";", $configtext);
	$configtext = preg_replace('/\$SHOW_EMPTY_BOXES\s*=\s*.*;/', "\$SHOW_EMPTY_BOXES = ".$boolarray[$_POST["NEW_SHOW_EMPTY_BOXES"]].";", $configtext);
	$configtext = preg_replace('/\$ZOOM_BOXES\s*=\s*\".*\";/', "\$ZOOM_BOXES = \"".$_POST["NEW_ZOOM_BOXES"]."\";", $configtext);
	$configtext = preg_replace('/\$LINK_ICONS\s*=\s*\".*\";/', "\$LINK_ICONS = \"".$_POST["NEW_LINK_ICONS"]."\";", $configtext);
	$configtext = preg_replace('/\$HIDE_LIVE_PEOPLE\s*=\s*.*;/', "\$HIDE_LIVE_PEOPLE = ".$boolarray[$_POST["NEW_HIDE_LIVE_PEOPLE"]].";", $configtext);
	$configtext = preg_replace('/\$REQUIRE_AUTHENTICATION\s*=\s*.*;/', "\$REQUIRE_AUTHENTICATION = ".$boolarray[$_POST["NEW_REQUIRE_AUTHENTICATION"]].";", $configtext);
	$configtext = preg_replace('/\$CHECK_CHILD_DATES\s*=\s*.*;/', "\$CHECK_CHILD_DATES = ".$boolarray[$_POST["NEW_CHECK_CHILD_DATES"]].";", $configtext);
	$configtext = preg_replace('/\$MAX_ALIVE_AGE\s*=\s*".*";/', "\$MAX_ALIVE_AGE = \"".$_POST["NEW_MAX_ALIVE_AGE"]."\";", $configtext);
	$configtext = preg_replace('/\$SHOW_GEDCOM_RECORD\s*=\s*.*;/', "\$SHOW_GEDCOM_RECORD = ".$boolarray[$_POST["NEW_SHOW_GEDCOM_RECORD"]].";", $configtext);
	$configtext = preg_replace('/\$ALLOW_EDIT_GEDCOM\s*=\s*.*;/', "\$ALLOW_EDIT_GEDCOM = ".$boolarray[$_POST["NEW_ALLOW_EDIT_GEDCOM"]].";", $configtext);
	$configtext = preg_replace('/\$ALPHA_INDEX_LISTS\s*=\s*.*;/', "\$ALPHA_INDEX_LISTS = ".$boolarray[$_POST["NEW_ALPHA_INDEX_LISTS"]].";", $configtext);
	$configtext = preg_replace('/\$NAME_FROM_GEDCOM\s*=\s*.*;/', "\$NAME_FROM_GEDCOM = ".$boolarray[$_POST["NEW_NAME_FROM_GEDCOM"]].";", $configtext);
	$configtext = preg_replace('/\$SHOW_ID_NUMBERS\s*=\s*.*;/', "\$SHOW_ID_NUMBERS = ".$boolarray[$_POST["NEW_SHOW_ID_NUMBERS"]].";", $configtext);
	$configtext = preg_replace('/\$SHOW_PEDIGREE_PLACES\s*=\s*".*";/', "\$SHOW_PEDIGREE_PLACES = \"".$_POST["NEW_SHOW_PEDIGREE_PLACES"]."\";", $configtext);
	$configtext = preg_replace('/\$MULTI_MEDIA\s*=\s*.*;/', "\$MULTI_MEDIA = ".$boolarray[$_POST["NEW_MULTI_MEDIA"]].";", $configtext);
	$configtext = preg_replace('/\$MEDIA_DIRECTORY\s*=\s*".*";/', "\$MEDIA_DIRECTORY = \"".$_POST["NEW_MEDIA_DIRECTORY"]."\";", $configtext);
	$configtext = preg_replace('/\$MEDIA_DIRECTORY_LEVELS\s*=\s*".*";/', "\$MEDIA_DIRECTORY_LEVELS = \"".$_POST["NEW_MEDIA_DIRECTORY_LEVELS"]."\";", $configtext);
	$configtext = preg_replace('/\$SHOW_HIGHLIGHT_IMAGES\s*=\s*.*;/', "\$SHOW_HIGHLIGHT_IMAGES = ".$boolarray[$_POST["NEW_SHOW_HIGHLIGHT_IMAGES"]].";", $configtext);
	$configtext = preg_replace('/\$ENABLE_CLIPPINGS_CART\s*=\s*.*;/', "\$ENABLE_CLIPPINGS_CART = ".$boolarray[$_POST["NEW_ENABLE_CLIPPINGS_CART"]].";", $configtext);
	$configtext = preg_replace('/\$HIDE_GEDCOM_ERRORS\s*=\s*.*;/', "\$HIDE_GEDCOM_ERRORS = ".$boolarray[$_POST["NEW_HIDE_GEDCOM_ERRORS"]].";", $configtext);
	$configtext = preg_replace('/\$WORD_WRAPPED_NOTES\s*=\s*.*;/', "\$WORD_WRAPPED_NOTES = ".$boolarray[$_POST["NEW_WORD_WRAPPED_NOTES"]].";", $configtext);
	$configtext = preg_replace('/\$SHOW_CONTEXT_HELP\s*=\s*.*;/', "\$SHOW_CONTEXT_HELP = ".$boolarray[$_POST["NEW_SHOW_CONTEXT_HELP"]].";", $configtext);
	$configtext = preg_replace('/\$HOME_SITE_URL\s*=\s*".*";/', "\$HOME_SITE_URL = \"".$_POST["NEW_HOME_SITE_URL"]."\";", $configtext);
	$configtext = preg_replace('/\$HOME_SITE_TEXT\s*=\s*".*";/', "\$HOME_SITE_TEXT = \"".$_POST["NEW_HOME_SITE_TEXT"]."\";", $configtext);
	$configtext = preg_replace('/\$CONTACT_EMAIL\s*=\s*".*";/', "\$CONTACT_EMAIL = \"".$_POST["NEW_CONTACT_EMAIL"]."\";", $configtext);
	$configtext = preg_replace('/\$CONTACT_METHOD\s*=\s*".*";/', "\$CONTACT_METHOD = \"".$_POST["NEW_CONTACT_METHOD"]."\";", $configtext);
	$configtext = preg_replace('/\$WEBMASTER_EMAIL\s*=\s*".*";/', "\$WEBMASTER_EMAIL = \"".$_POST["NEW_WEBMASTER_EMAIL"]."\";", $configtext);
	$configtext = preg_replace('/\$SUPPORT_METHOD\s*=\s*".*";/', "\$SUPPORT_METHOD = \"".$_POST["NEW_SUPPORT_METHOD"]."\";", $configtext);
	$configtext = preg_replace('/\$FAVICON\s*=\s*".*";/', "\$FAVICON = \"".$_POST["NEW_FAVICON"]."\";", $configtext);
	$configtext = preg_replace('/\$SHOW_STATS\s*=\s*.*;/', "\$SHOW_STATS = ".$boolarray[$_POST["NEW_SHOW_STATS"]].";", $configtext);
	if (file_exists($NTHEME_DIR)) $configtext = preg_replace('/\$THEME_DIR\s*=\s*".*";/', "\$THEME_DIR = \"".$_POST["NTHEME_DIR"]."\";", $configtext);
	else {
		print "<font class=\"error\">$NTHEME_DIR ".$pgv_lang["does_not_exist"]."</font>\n";
		$NTHEME_DIR=$THEME_DIR;
	}
	$configtext = preg_replace('/\$TIME_LIMIT\s*=\s*".*";/', "\$TIME_LIMIT = \"".$_POST["NEW_TIME_LIMIT"]."\";", $configtext);
	if (!is_writable($gedcom_config)) {
		print "<font color=\"red\"><b>Unable to write to $gedcom_config<br /></b></font>";
		print "<br /><br /><a href=\"config_download.php?file=$gedcom_config\">".$pgv_lang["download_gedconf"]."</a> ".$pgv_lang["upload_to_index"]."$INDEX_DIRECTORY<br /><br />\n";
	}
	$fp = fopen($gedcom_config, "wb");
	if (!$fp) {
		print "<font class=\"error\">".$pgv_lang["config_write_error"]."<br /></font>\n";
	}
	else {
		fwrite($fp, $configtext);
		fclose($fp);
		//print "<script language=\"JavaScript\">window.location='editgedcoms.php";
		//if ($newgedcom) print "?ged=$FILE";
		//print "';</script>";
	}
	$_SESSION[$gedcom_config]=$configtext;
	foreach($_POST as $key=>$value) {
		$key=preg_replace("/NEW_/", "", $key);
		if ($value=='yes') $$key=true;
		else if ($value=='no') $$key=false;
		else $$key=stripslashes($value);
	}
	print "<form><input type=\"button\" value=\"".$pgv_lang["import_gedcom"]."\" onclick=\"window.location = 'importgedcom.php?ged=$FILE';\" /></form><br />\n";
	AddToLog("Gedcom configuration ".$gedcom_config." updated by >".getUserName()."<");
}
if (!isset($NTHEME_DIR)) $NTHEME_DIR=$THEME_DIR;
if (!isset($themeselect)) $themeselect="";
?>
<script language="JavaScript">
	var helpWin;
	function helpPopup(which) {
		if ((!helpWin)||(helpWin.closed)) helpWin = window.open('editconfig_help.php?help='+which,'','left=50,top=50,width=400,height=320,resizable=1,scrollbars=1');
		else helpWin.location = 'editconfig_help.php?help='+which;
		return false;
	}
	function getHelp(which) {
		if ((helpWin)&&(!helpWin.closed)) helpWin.location='editconfig_help.php?help='+which;
	}
	function closeHelp() {
		if (helpWin) helpWin.close();
	}
	function show_jewish(dbselect, sid) {
		var sbox = document.getElementById(sid);
		var sbox_style = sbox.style;

		if ((dbselect.options[dbselect.selectedIndex].value=='jewish')
			||(dbselect.options[dbselect.selectedIndex].value=='hebrew')
			||(dbselect.options[dbselect.selectedIndex].value=='jewish_and_gregorian')
			||(dbselect.options[dbselect.selectedIndex].value=='hebrew_and_gregorian')) {
			sbox_style.display='block';
		}
		else {
			sbox_style.display='none';
		}
	}
</script>
<form method="post" name="configform" action="editconfig_gedcom.php">
<?php print $pgv_lang["review_readme"]?>
<input type="hidden" name="action" value="update" />
<input type="hidden" name="oldged" value="<?php print $oldged; ?>" />
<table class="facts_table">
	<tr>
		<td class="facts_label"><?php print $pgv_lang["GEDCOM"]?> <a href="#" onclick="return helpPopup('gedcom_path_help');"><b>?</b></a></td>
		<td class="facts_value"><input type="text" name="GEDCOMPATH" value="<?php print preg_replace('/\\\\/', '\\', $GEDCOMPATH);?>" size="40" tabindex="1" onfocus="getHelp('gedcom_path_help');" />
		<?php
			if ((!strstr($GEDCOMPATH, "://"))&&(!file_exists($GEDCOMPATH))) {
				//print "<font class=\"error\">".$pgv_lang["error_header"]."</font>\n";
				print "<br /><font class=\"error\">".str_replace("#GEDCOM#", $GEDCOM, $pgv_lang["error_header"])."</font>\n";
			}
		?>
		</td>
	</tr>
	<tr>
		<td class="facts_label"><?php print $pgv_lang["gedcom_title"]?> <a href="#" onclick="return helpPopup('gedcom_title_help');"><b>?</b></a></td>
		<td class="facts_value"><input type="text" name="gedcom_title" value="<?php print $gedcom_title?>" size="40" tabindex="2" onfocus="getHelp('gedcom_title_help');" /></td>
	</tr>
	<tr>
		<td class="facts_label"><?php print $pgv_lang["CHARACTER_SET"]?> <a href="#" onclick="return helpPopup('CHARACTER_SET_help');"><b>?</b></a></td>
		<td class="facts_value"><input type="text" name="NEW_CHARACTER_SET" value="<?php print $CHARACTER_SET?>" onfocus="getHelp('CHARACTER_SET_help');" tabindex="3" /></td>
	</tr>
	<tr>
		<td class="facts_label"><?php print $pgv_lang["LANGUAGE"]?> <a href="#" onclick="return helpPopup('LANGUAGE_help');"><b>?</b></a></td>
		<td class="facts_value"><input type="hidden" name="changelanguage" value="yes" />
		<select name="NEWLANGUAGE" onfocus="getHelp('LANGUAGE_help');" tabindex="4">
		<?php
			if (!isset($NEWLANGUAGE)) $NEWLANGUAGE=$LANGUAGE;
			foreach ($pgv_language as $key=>$value) {
				print "\n\t\t\t<option value=\"$key\"";
				if ($NEWLANGUAGE==$key) print " selected=\"selected\"";
				print ">".$pgv_lang[$key]."</option>";
			}
		?>
			</select>
		</td>
	</tr>
	<tr>
		<td class="facts_label"><?php print $pgv_lang["CREATE_GENDEX"]?> <a href="#" onclick="return helpPopup('CREATE_GENDEX_help');"><b>?</b></a></td>
		<td class="facts_value"><select name="NEW_CREATE_GENDEX" onfocus="getHelp('CREATE_GENDEX_help');" tabindex="5" >
				<option value="yes" <?php if ($CREATE_GENDEX) print "selected=\"selected\""; ?>><?php print $pgv_lang["yes"];?></option>
				<option value="no" <?php if (!$CREATE_GENDEX) print "selected=\"selected\""; ?>><?php print $pgv_lang["no"];?></option>
			</select>
		</td>
	</tr>
	<tr>
		<td class="facts_label"><?php print $pgv_lang["ENABLE_MULTI_LANGUAGE"]?> <a href="#" onclick="return helpPopup('ENABLE_MULTI_LANGUAGE_help');"><b>?</b></a></td>
		<td class="facts_value"><select name="NEW_ENABLE_MULTI_LANGUAGE" onfocus="getHelp('ENABLE_MULTI_LANGUAGE_help');" tabindex="6" >
				<option value="yes" <?php if ($ENABLE_MULTI_LANGUAGE) print "selected=\"selected\""; ?>><?php print $pgv_lang["yes"];?></option>
				<option value="no" <?php if (!$ENABLE_MULTI_LANGUAGE) print "selected=\"selected\""; ?>><?php print $pgv_lang["no"];?></option>
			</select>
		</td>
	</tr>
	<tr>
		<td class="facts_label"><?php print $pgv_lang["CALENDAR_FORMAT"]?> <a href="#" onclick="return helpPopup('CALENDAR_FORMAT_help');"><b>?</b></a></td>
		<td class="facts_value"><select name="NEW_CALENDAR_FORMAT" tabindex="7"  onfocus="getHelp('CALENDAR_FORMAT_help');" onchange="show_jewish(this, 'hebrew-cal');">
				<option value="gregorian" <?php if ($CALENDAR_FORMAT=='gregorian') print "selected=\"selected\""; ?>><?php print $pgv_lang["gregorian"];?></option>
				<option value="julian" <?php if ($CALENDAR_FORMAT=='julian') print "selected=\"selected\""; ?>><?php print $pgv_lang["julian"];?></option>
				<option value="french" <?php if ($CALENDAR_FORMAT=='french') print "selected=\"selected\""; ?>><?php print $pgv_lang["config_french"];?></option>
				<option value="jewish" <?php if ($CALENDAR_FORMAT=='jewish') print "selected=\"selected\""; ?>><?php print $pgv_lang["jewish"];?></option>
				<option value="jewish_and_gregorian" <?php if ($CALENDAR_FORMAT=='jewish_and_gregorian') print "selected=\"selected\""; ?>><?php print $pgv_lang["jewish_and_gregorian"];?></option>
				<option value="hebrew" <?php if ($CALENDAR_FORMAT=='hebrew') print "selected=\"selected\""; ?>><?php print $pgv_lang["config_hebrew"];?></option>
				<option value="hebrew_and_gregorian" <?php if ($CALENDAR_FORMAT=='hebrew_and_gregorian') print "selected=\"selected\""; ?>><?php print $pgv_lang["hebrew_and_gregorian"];?></option>
			</select>
		</td>
	</tr>
	</table>
	<div id="hebrew-cal" style="display: <?php if (($CALENDAR_FORMAT=='jewish')||($CALENDAR_FORMAT=='jewish_and_gregorian')||($CALENDAR_FORMAT=='hebrew')||($CALENDAR_FORMAT=='hebrew_and_gregorian')) print 'block'; else print 'none';?>;">
	<table class="facts_table">
	<tr>
		<td class="facts_label"><?php print $pgv_lang["DISPLAY_JEWISH_THOUSANDS"]?> <a href="#" onclick="return helpPopup('DISPLAY_JEWISH_THOUSANDS_help');"><b>?</b></a></td>
		<td class="facts_value"><select name="NEW_DISPLAY_JEWISH_THOUSANDS" onfocus="getHelp('DISPLAY_JEWISH_THOUSANDS_help');">
				<option value="yes" <?php if ($DISPLAY_JEWISH_THOUSANDS) print "selected=\"selected\""; ?>><?php print $pgv_lang["yes"];?></option>
				<option value="no" <?php if (!$DISPLAY_JEWISH_THOUSANDS) print "selected=\"selected\""; ?>><?php print $pgv_lang["no"];?></option>
			</select>
		</td>
	</tr>
	<tr>
		<td class="facts_label"><?php print $pgv_lang["DISPLAY_JEWISH_GERESHAYIM"]?> <a href="#" onclick="return helpPopup('DISPLAY_JEWISH_GERESHAYIM_help');"><b>?</b></a></td>
		<td class="facts_value"><select name="NEW_DISPLAY_JEWISH_GERESHAYIM" onfocus="getHelp('DISPLAY_JEWISH_GERESHAYIM_help');">
				<option value="yes" <?php if ($DISPLAY_JEWISH_GERESHAYIM) print "selected=\"selected\""; ?>><?php print $pgv_lang["yes"];?></option>
				<option value="no" <?php if (!$DISPLAY_JEWISH_GERESHAYIM) print "selected=\"selected\""; ?>><?php print $pgv_lang["no"];?></option>
			</select>
		</td>
	</tr>
	<tr>
		<td class="facts_label"><?php print $pgv_lang["JEWISH_ASHKENAZ_PRONUNCIATION"]?> <a href="#" onclick="return helpPopup('JEWISH_ASHKENAZ_PRONUNCIATION_help');"><b>?</b></a></td>
		<td class="facts_value"><select name="NEW_JEWISH_ASHKENAZ_PRONUNCIATION" onfocus="getHelp('JEWISH_ASHKENAZ_PRONUNCIATION_help');">
				<option value="yes" <?php if ($JEWISH_ASHKENAZ_PRONUNCIATION) print "selected=\"selected\""; ?>><?php print $pgv_lang["yes"];?></option>
				<option value="no" <?php if (!$JEWISH_ASHKENAZ_PRONUNCIATION) print "selected=\"selected\""; ?>><?php print $pgv_lang["no"];?></option>
			</select>
		</td>
	</tr>
	</table>
	</div>
	<table class="facts_table">
	<tr>
		<td class="facts_label"><?php print $pgv_lang["DEFAULT_PEDIGREE_GENERATIONS"]?> <a href="#" onclick="return helpPopup('DEFAULT_PEDIGREE_GENERATIONS_help');"><b>?</b></a></td>
		<td class="facts_value"><input type="text" name="NEW_DEFAULT_PEDIGREE_GENERATIONS" value="<?php print $DEFAULT_PEDIGREE_GENERATIONS?>" size="5" tabindex="8" onfocus="getHelp('DEFAULT_PEDIGREE_GENERATIONS_help');" /></td>
	</tr>
	<tr>
		<td class="facts_label"><?php print $pgv_lang["MAX_PEDIGREE_GENERATIONS"]?> <a href="#" onclick="return helpPopup('MAX_PEDIGREE_GENERATIONS_help');"><b>?</b></a></td>
		<td class="facts_value"><input type="text" name="NEW_MAX_PEDIGREE_GENERATIONS" value="<?php print $MAX_PEDIGREE_GENERATIONS?>" size="5" tabindex="9" onfocus="getHelp('MAX_PEDIGREE_GENERATIONS_help');" /></td>
	</tr>
	<tr>
		<td class="facts_label"><?php print $pgv_lang["MAX_DESCENDANCY_GENERATIONS"]?> <a href="#" onclick="return helpPopup('MAX_DESCENDANCY_GENERATIONS_help');"><b>?</b></a></td>
		<td class="facts_value"><input type="text" name="NEW_MAX_DESCENDANCY_GENERATIONS" value="<?php print $MAX_DESCENDANCY_GENERATIONS?>" size="5" tabindex="10" onfocus="getHelp('DMAX_DESCENDANCY_GENERATIONS_help');" /></td>
	</tr>
	<tr>
		<td class="facts_label"><?php print $pgv_lang["USE_RIN"]?> <a href="#" onclick="return helpPopup('USE_RIN_help');"><b>?</b></a></td>
		<td class="facts_value"><select name="NEW_USE_RIN" tabindex="11" onfocus="getHelp('USE_RIN_help');">
				<option value="yes" <?php if ($USE_RIN) print "selected=\"selected\""; ?>><?php print $pgv_lang["yes"];?></option>
				<option value="no" <?php if (!$USE_RIN) print "selected=\"selected\""; ?>><?php print $pgv_lang["no"];?></option>
			</select>
		</td>
	</tr>
	<tr>
		<td class="facts_label"><?php print $pgv_lang["PEDIGREE_ROOT_ID"]?> <a href="#" onclick="return helpPopup('PEDIGREE_ROOT_ID_help');"><b>?</b></a></td>
		<td class="facts_value"><input type="text" name="NEW_PEDIGREE_ROOT_ID" value="<?php print $PEDIGREE_ROOT_ID?>" size="5" tabindex="12" onfocus="getHelp('PEDIGREE_ROOT_ID_help');" />
		<?php
		if ((!empty($GEDCOMPATH))&&(file_exists($GEDCOMPATH))) {
			$fpged = fopen($GEDCOMPATH, "r");
			$BLOCK_SIZE = 1024*4;	//-- 4k bytes per read
			$fcontents = "";
			while(!feof($fpged)) {
				$fcontents .= fread($fpged, $BLOCK_SIZE);
				$pos1 = strpos($fcontents, "0 @$PEDIGREE_ROOT_ID@", 0);
				if ($pos1===false) $fcontents = "";
				else {
					$pos2 = strpos($fcontents, "0 @", $pos1+1);
					while((!$pos2)&&(!feof($fpged))) {
						$fcontents .= fread($fpged, $BLOCK_SIZE);
						$pos2 = strpos($fcontents, "0 @", $pos1+1);
					}
					if ($pos2) $indirec = substr($fcontents, $pos1, $pos2-$pos1);
					else $indirec = substr($fcontents, $pos1);
					break;
				}
			}
			fclose($fpged);
			if (!empty($indirec)) {
				preg_match("/1 NAME (.*)/", $indirec, $match);
				$name = preg_replace("'\/'", " ", $match[1]);
				$name = rtrim($name);
				$nt = preg_match("/2 NSFX (.*)/", $indirec, $smatch);
				if ($nt>0) $name .= " ".$smatch[1];
				print "\n<font class=\"list_item\">$name";
				print "--<i>".$pgv_lang["birth"]." ";
				$bpos1 = strpos($indirec, "1 BIRT");
				if ($bpos1) {
					$birthrec = substr($indirec, $bpos1+1);
					$bt = preg_match("/1 [A-Z]{4}/", $birthrec, $match);
					if ($bt>0) {
						$bpos2 = strpos($birthrec, $match[0]);
						if ($bpos2) $birthrec = substr($birthrec, 0, $bpos2);
					}
					$dct = preg_match("/2 DATE (.*)/", $birthrec, $match);
					if ($dct>0) print $match[1];
					$pct = preg_match("/2 PLAC (.*)/", $birthrec, $match);
					if ($pct>0) print " - ".$match[1];
				}
				print "</i>";
			    print "</font>\n";
		    }
		    else {
			    print "<font class=\"error\">".$pgv_lang["unable_to_find_indi"]."</font>";
		    }
	    }
		?>
		</td>
	</tr>
	<tr>
		<td class="facts_label"><?php print $pgv_lang["GEDCOM_ID_PREFIX"]?> <a href="#" onclick="return helpPopup('GEDCOM_ID_PREFIX_help');"><b>?</b></a></td>
		<td class="facts_value"><input type="text" name="NEW_GEDCOM_ID_PREFIX" value="<?php print $GEDCOM_ID_PREFIX?>" size="5" tabindex="13" onfocus="getHelp('GEDCOM_ID_PREFIX_help');" />
		</td>
	</tr>
	<tr>
		<td class="facts_label"><?php print $pgv_lang["PEDIGREE_FULL_DETAILS"]?> <a href="#" onclick="return helpPopup('PEDIGREE_FULL_DETAILS_help');"><b>?</b></a></td>
		<td class="facts_value"><select name="NEW_PEDIGREE_FULL_DETAILS" tabindex="14" onfocus="getHelp('PEDIGREE_FULL_DETAILS_help');">
				<option value="yes" <?php if ($PEDIGREE_FULL_DETAILS) print "selected=\"selected\""; ?>><?php print $pgv_lang["yes"];?></option>
				<option value="no" <?php if (!$PEDIGREE_FULL_DETAILS) print "selected=\"selected\""; ?>><?php print $pgv_lang["no"];?></option>
			</select>
		</td>
	</tr>
	<tr>
		<td class="facts_label"><?php print $pgv_lang["PEDIGREE_LAYOUT"]?> <a href="#" onclick="return helpPopup('PEDIGREE_LAYOUT_help');"><b>?</b></a></td>
		<td class="facts_value"><select name="NEW_PEDIGREE_LAYOUT" tabindex="15" onfocus="getHelp('PEDIGREE_LAYOUT_help');">
				<option value="yes" <?php if ($PEDIGREE_LAYOUT) print "selected=\"selected\""; ?>><?php print $pgv_lang["landscape"];?></option>
				<option value="no" <?php if (!$PEDIGREE_LAYOUT) print "selected=\"selected\""; ?>><?php print $pgv_lang["portrait"];?></option>
			</select>
		</td>
	</tr>
	<tr>
		<td class="facts_label"><?php print $pgv_lang["ZOOM_BOXES"]?> <a href="#" onclick="return helpPopup('ZOOM_BOXES_help');"><b>?</b></a></td>
		<td class="facts_value"><select name="NEW_ZOOM_BOXES" tabindex="16" onfocus="getHelp('ZOOM_BOXES_help');">
				<option value="disabled" <?php if ($ZOOM_BOXES=='disabled') print "selected=\"selected\""; ?>><?php print $pgv_lang["disabled"];?></option>
				<option value="mouseover" <?php if ($ZOOM_BOXES=='mouseover') print "selected=\"selected\""; ?>><?php print $pgv_lang["mouseover"];?></option>
				<option value="mousedown" <?php if ($ZOOM_BOXES=='mousedown') print "selected=\"selected\""; ?>><?php print $pgv_lang["mousedown"];?></option>
				<option value="click" <?php if ($ZOOM_BOXES=='click') print "selected=\"selected\""; ?>><?php print $pgv_lang["click"];?></option>
			</select>
		</td>
	</tr>
	<tr>
		<td class="facts_label"><?php print $pgv_lang["LINK_ICONS"]?> <a href="#" onclick="return helpPopup('LINK_ICONS_help');"><b>?</b></a></td>
		<td class="facts_value"><select name="NEW_LINK_ICONS" tabindex="17" onfocus="getHelp('LINK_ICONS_help');">
				<option value="disabled" <?php if ($LINK_ICONS=='disabled') print "selected=\"selected\""; ?>><?php print $pgv_lang["disabled"];?></option>
				<option value="mouseover" <?php if ($LINK_ICONS=='mouseover') print "selected=\"selected\""; ?>><?php print $pgv_lang["mouseover"];?></option>
				<option value="click" <?php if ($LINK_ICONS=='click') print "selected=\"selected\""; ?>><?php print $pgv_lang["click"];?></option>
			</select>
		</td>
	</tr>
	<tr>
		<td class="facts_label"><?php print $pgv_lang["SHOW_EMPTY_BOXES"]?> <a href="#" onclick="return helpPopup('SHOW_EMPTY_BOXES_help');"><b>?</b></a></td>
		<td class="facts_value"><select name="NEW_SHOW_EMPTY_BOXES" tabindex="18" onfocus="getHelp('SHOW_EMPTY_BOXES_help');">
				<option value="yes" <?php if ($SHOW_EMPTY_BOXES) print "selected=\"selected\""; ?>><?php print $pgv_lang["yes"];?></option>
				<option value="no" <?php if (!$SHOW_EMPTY_BOXES) print "selected=\"selected\""; ?>><?php print $pgv_lang["no"];?></option>
			</select>
		</td>
	</tr>
	<tr>
		<td class="facts_label"><?php print $pgv_lang["HIDE_LIVE_PEOPLE"]?> <a href="#" onclick="return helpPopup('HIDE_LIVE_PEOPLE_help');"><b>?</b></a></td>
		<td class="facts_value"><select name="NEW_HIDE_LIVE_PEOPLE" tabindex="20" onfocus="getHelp('HIDE_LIVE_PEOPLE_help');">
				<option value="yes" <?php if ($HIDE_LIVE_PEOPLE) print "selected=\"selected\""; ?>><?php print $pgv_lang["yes"];?></option>
				<option value="no" <?php if (!$HIDE_LIVE_PEOPLE) print "selected=\"selected\""; ?>><?php print $pgv_lang["no"];?></option>
			</select>
		</td>
	</tr>
	<tr>
		<td class="facts_label"><?php print $pgv_lang["REQUIRE_AUTHENTICATION"]?> <a href="#" onclick="return helpPopup('REQUIRE_AUTHENTICATION_help');"><b>?</b></a></td>
		<td class="facts_value"><select name="NEW_REQUIRE_AUTHENTICATION" tabindex="21" onfocus="getHelp('REQUIRE_AUTHENTICATION_help');">
				<option value="yes" <?php if ($REQUIRE_AUTHENTICATION) print "selected=\"selected\""; ?>><?php print $pgv_lang["yes"];?></option>
				<option value="no" <?php if (!$REQUIRE_AUTHENTICATION) print "selected=\"selected\""; ?>><?php print $pgv_lang["no"];?></option>
			</select>
		</td>
	</tr>
	<tr>
		<td class="facts_label"><?php print $pgv_lang["CHECK_CHILD_DATES"]?> <a href="#" onclick="return helpPopup('CHECK_CHILD_DATES_help');"><b>?</b></a></td>
		<td class="facts_value"><select name="NEW_CHECK_CHILD_DATES" tabindex="22" onfocus="getHelp('CHECK_CHILD_DATES_help');">
				<option value="yes" <?php if ($CHECK_CHILD_DATES) print "selected=\"selected\""; ?>><?php print $pgv_lang["yes"];?></option>
				<option value="no" <?php if (!$CHECK_CHILD_DATES) print "selected=\"selected\""; ?>><?php print $pgv_lang["no"];?></option>
			</select>
		</td>
	</tr>
	<tr>
		<td class="facts_label"><?php print $pgv_lang["MAX_ALIVE_AGE"]?> <a href="#" onclick="return helpPopup('MAX_ALIVE_AGE_help');"><b>?</b></a></td>
		<td class="facts_value"><input type="text" name="NEW_MAX_ALIVE_AGE" value="<?php print $MAX_ALIVE_AGE?>" size="5" tabindex="23" onfocus="getHelp('MAX_ALIVE_AGE_help');" /></td>
	</tr>
	<tr>
		<td class="facts_label"><?php print $pgv_lang["SHOW_GEDCOM_RECORD"]?> <a href="#" onclick="return helpPopup('SHOW_GEDCOM_RECORD_help');"><b>?</b></a></td>
		<td class="facts_value"><select name="NEW_SHOW_GEDCOM_RECORD" tabindex="24" onfocus="getHelp('SHOW_GEDCOM_RECORD_help');">
				<option value="yes" <?php if ($SHOW_GEDCOM_RECORD) print "selected=\"selected\""; ?>><?php print $pgv_lang["yes"];?></option>
				<option value="no" <?php if (!$SHOW_GEDCOM_RECORD) print "selected=\"selected\""; ?>><?php print $pgv_lang["no"];?></option>
			</select>
		</td>
	</tr>
	<tr>
		<td class="facts_label"><?php print $pgv_lang["ALLOW_EDIT_GEDCOM"]?> <a href="#" onclick="return helpPopup('ALLOW_EDIT_GEDCOM_help');"><b>?</b></a></td>
		<td class="facts_value"><select name="NEW_ALLOW_EDIT_GEDCOM" tabindex="25" onfocus="getHelp('ALLOW_EDIT_GEDCOM_help');">
				<option value="yes" <?php if ($ALLOW_EDIT_GEDCOM) print "selected=\"selected\""; ?>><?php print $pgv_lang["yes"];?></option>
				<option value="no" <?php if (!$ALLOW_EDIT_GEDCOM) print "selected=\"selected\""; ?>><?php print $pgv_lang["no"];?></option>
			</select>
		</td>
	</tr>
	<tr>
		<td class="facts_label"><?php print $pgv_lang["INDEX_DIRECTORY"]?> <a href="#" onclick="return helpPopup('INDEX_DIRECTORY_help');"><b>?</b></a></td>
		<td class="facts_value"><input type="text" name="NEW_INDEX_DIRECTORY" value="<?php print $INDEX_DIRECTORY?>" tabindex="26" onfocus="getHelp('INDEX_DIRECTORY_help');" /></td>
	</tr>
	<tr>
		<td class="facts_label"><?php print $pgv_lang["ALPHA_INDEX_LISTS"]?> <a href="#" onclick="return helpPopup('ALPHA_INDEX_LISTS_help');"><b>?</b></a></td>
		<td class="facts_value"><select name="NEW_ALPHA_INDEX_LISTS" tabindex="27" onfocus="getHelp('ALPHA_INDEX_LISTS_help');">
				<option value="yes" <?php if ($ALPHA_INDEX_LISTS) print "selected=\"selected\""; ?>><?php print $pgv_lang["yes"];?></option>
				<option value="no" <?php if (!$ALPHA_INDEX_LISTS) print "selected=\"selected\""; ?>><?php print $pgv_lang["no"];?></option>
			</select>
		</td>
	</tr>
	<tr>
		<td class="facts_label"><?php print $pgv_lang["NAME_FROM_GEDCOM"]?> <a href="#" onclick="return helpPopup('NAME_FROM_GEDCOM_help');"><b>?</b></a></td>
		<td class="facts_value"><select name="NEW_NAME_FROM_GEDCOM" tabindex="28" onfocus="getHelp('NAME_FROM_GEDCOM_help');">
				<option value="yes" <?php if ($NAME_FROM_GEDCOM) print "selected=\"selected\""; ?>><?php print $pgv_lang["yes"];?></option>
				<option value="no" <?php if (!$NAME_FROM_GEDCOM) print "selected=\"selected\""; ?>><?php print $pgv_lang["no"];?></option>
			</select>
		</td>
	</tr>
	<tr>
		<td class="facts_label"><?php print $pgv_lang["SHOW_ID_NUMBERS"]?> <a href="#" onclick="return helpPopup('SHOW_ID_NUMBERS_help');"><b>?</b></a></td>
		<td class="facts_value"><select name="NEW_SHOW_ID_NUMBERS" tabindex="29" onfocus="getHelp('SHOW_ID_NUMBERS_help');">
				<option value="yes" <?php if ($SHOW_ID_NUMBERS) print "selected=\"selected\""; ?>><?php print $pgv_lang["yes"];?></option>
				<option value="no" <?php if (!$SHOW_ID_NUMBERS) print "selected=\"selected\""; ?>><?php print $pgv_lang["no"];?></option>
			</select>
		</td>
	</tr>
	<tr>
		<td class="facts_label"><?php print $pgv_lang["SHOW_PEDIGREE_PLACES"]?> <a href="#" onclick="return helpPopup('SHOW_PEDIGREE_PLACES_help');"><b>?</b></a></td>
		<td class="facts_value"><input type="text" size="5" name="NEW_SHOW_PEDIGREE_PLACES" value="<?php print $SHOW_PEDIGREE_PLACES; ?>" tabindex="30" onfocus="getHelp('SHOW_PEDIGREE_PLACES_help');" /></td>
	</tr>
	<tr>
		<td class="facts_label"><?php print $pgv_lang["MULTI_MEDIA"]?> <a href="#" onclick="return helpPopup('MULTI_MEDIA_help');"><b>?</b></a></td>
		<td class="facts_value"><select name="NEW_MULTI_MEDIA" tabindex="31" onfocus="getHelp('MULTI_MEDIA_help');">
				<option value="yes" <?php if ($MULTI_MEDIA) print "selected=\"selected\""; ?>><?php print $pgv_lang["yes"];?></option>
				<option value="no" <?php if (!$MULTI_MEDIA) print "selected=\"selected\""; ?>><?php print $pgv_lang["no"];?></option>
			</select>
		</td>
	</tr>
	<tr>
		<td class="facts_label"><?php print $pgv_lang["MEDIA_DIRECTORY"]?> <a href="#" onclick="return helpPopup('MEDIA_DIRECTORY_help');"><b>?</b></a></td>
		<td class="facts_value"><input type="text" name="NEW_MEDIA_DIRECTORY" value="<?php print $MEDIA_DIRECTORY?>" tabindex="32" onfocus="getHelp('MEDIA_DIRECTORY_help');" /></td>
	</tr>
	<tr>
		<td class="facts_label"><?php print $pgv_lang["MEDIA_DIRECTORY_LEVELS"]?> <a href="#" onclick="return helpPopup('MEDIA_DIRECTORY_LEVELS_help');"><b>?</b></a></td>
		<td class="facts_value"><input type="text" name="NEW_MEDIA_DIRECTORY_LEVELS" value="<?php print $MEDIA_DIRECTORY_LEVELS?>" size="5" tabindex="33" onfocus="getHelp('MEDIA_DIRECTORY_LEVELS_help');" /></td>
	</tr>
	<tr>
		<td class="facts_label"><?php print $pgv_lang["SHOW_HIGHLIGHT_IMAGES"]?> <a href="#" onclick="return helpPopup('SHOW_HIGHLIGHT_IMAGES_help');"><b>?</b></a></td>
		<td class="facts_value"><select name="NEW_SHOW_HIGHLIGHT_IMAGES" tabindex="34" onfocus="getHelp('SHOW_HIGHLIGHT_IMAGES_help');">
				<option value="yes" <?php if ($SHOW_HIGHLIGHT_IMAGES) print "selected=\"selected\""; ?>><?php print $pgv_lang["yes"];?></option>
				<option value="no" <?php if (!$SHOW_HIGHLIGHT_IMAGES) print "selected=\"selected\""; ?>><?php print $pgv_lang["no"];?></option>
			</select>
		</td>
	</tr>
	<tr>
		<td class="facts_label"><?php print $pgv_lang["ENABLE_CLIPPINGS_CART"]?> <a href="#" onclick="return helpPopup('ENABLE_CLIPPINGS_CART_help');"><b>?</b></a></td>
		<td class="facts_value"><select name="NEW_ENABLE_CLIPPINGS_CART" tabindex="35" onfocus="getHelp('ENABLE_CLIPPINGS_CART_help');">
				<option value="yes" <?php if ($ENABLE_CLIPPINGS_CART) print "selected=\"selected\""; ?>><?php print $pgv_lang["yes"];?></option>
				<option value="no" <?php if (!$ENABLE_CLIPPINGS_CART) print "selected=\"selected\""; ?>><?php print $pgv_lang["no"];?></option>
			</select>
		</td>
	</tr>
	<tr>
		<td class="facts_label"><?php print $pgv_lang["HIDE_GEDCOM_ERRORS"]?> <a href="#" onclick="return helpPopup('HIDE_GEDCOM_ERRORS_help');"><b>?</b></a></td>
		<td class="facts_value"><select name="NEW_HIDE_GEDCOM_ERRORS" tabindex="36" onfocus="getHelp('HIDE_GEDCOM_ERRORS_help');">
				<option value="yes" <?php if ($HIDE_GEDCOM_ERRORS) print "selected=\"selected\""; ?>><?php print $pgv_lang["yes"];?></option>
				<option value="no" <?php if (!$HIDE_GEDCOM_ERRORS) print "selected=\"selected\""; ?>><?php print $pgv_lang["no"];?></option>
			</select>
		</td>
	</tr>
	<tr>
		<td class="facts_label"><?php print $pgv_lang["WORD_WRAPPED_NOTES"]?> <a href="#" onclick="return helpPopup('WORD_WRAPPED_NOTES_help');"><b>?</b></a></td>
		<td class="facts_value"><select name="NEW_WORD_WRAPPED_NOTES" tabindex="37" onfocus="getHelp('WORD_WRAPPED_NOTES_help');">
				<option value="yes" <?php if ($WORD_WRAPPED_NOTES) print "selected=\"selected\""; ?>><?php print $pgv_lang["yes"];?></option>
				<option value="no" <?php if (!$WORD_WRAPPED_NOTES) print "selected=\"selected\""; ?>><?php print $pgv_lang["no"];?></option>
			</select>
		</td>
	</tr>
	<tr>
		<td class="facts_label"><?php print $pgv_lang["SHOW_CONTEXT_HELP"]?> <a href="#" onclick="return helpPopup('SHOW_CONTEXT_HELP_help');"><b>?</b></a></td>
		<td class="facts_value"><select name="NEW_SHOW_CONTEXT_HELP" tabindex="37" onfocus="getHelp('SHOW_CONTEXT_HELP_help');">
				<option value="yes" <?php if ($SHOW_CONTEXT_HELP) print "selected=\"selected\""; ?>><?php print $pgv_lang["yes"];?></option>
				<option value="no" <?php if (!$SHOW_CONTEXT_HELP) print "selected=\"selected\""; ?>><?php print $pgv_lang["no"];?></option>
			</select>
		</td>
	</tr>
	<tr>
		<td class="facts_label"><?php print $pgv_lang["HOME_SITE_URL"]?> <a href="#" onclick="return helpPopup('HOME_SITE_URL_help');"><b>?</b></a></td>
		<td class="facts_value"><input type="text" name="NEW_HOME_SITE_URL" value="<?php print $HOME_SITE_URL?>" size="50" tabindex="38" onfocus="getHelp('HOME_SITE_URL_help');" /></td>
	</tr>
	<tr>
		<td class="facts_label"><?php print $pgv_lang["HOME_SITE_TEXT"]?> <a href="#" onclick="return helpPopup('HOME_SITE_TEXT_help');"><b>?</b></a></td>
		<td class="facts_value"><input type="text" name="NEW_HOME_SITE_TEXT" value="<?php print htmlspecialchars($HOME_SITE_TEXT);?>" size="50" tabindex="39" onfocus="getHelp('HOME_SITE_TEXT_help');" /></td>
	</tr>
	<tr>
		<td class="facts_label"><?php print $pgv_lang["CONTACT_EMAIL"]?> <a href="#" onclick="return helpPopup('CONTACT_EMAIL_help');"><b>?</b></a></td>
		<td class="facts_value"><select name="NEW_CONTACT_EMAIL" tabindex="40" onfocus="getHelp('CONTACT_EMAIL_help');">
		<?php
			$users = getUsers();
			foreach($users as $user) {
				print "<option value=\"".$user["username"]."\"";
				if ($CONTACT_EMAIL==$user["username"]) print " selected=\"selected\"";
				print ">".$user["fullname"]." (".$user["username"].")</option>\n";
			}
		?>
		</select>
		</td>
	</tr>
	<tr>
		<td class="facts_label"><?php print $pgv_lang["CONTACT_METHOD"]?> <a href="#" onclick="return helpPopup('CONTACT_METHOD_help');"><b>?</b></a></td>
		<td class="facts_value"><select name="NEW_CONTACT_METHOD" tabindex="41" onfocus="getHelp('CONTACT_METHOD_help');">
				<option value="messaging" <?php if ($CONTACT_METHOD=='messaging') print "selected=\"selected\""; ?>><?php print $pgv_lang["messaging"];?></option>
				<option value="messaging2" <?php if ($CONTACT_METHOD=='messaging2') print "selected=\"selected\""; ?>><?php print $pgv_lang["messaging2"];?></option>
				<option value="mailto" <?php if ($CONTACT_METHOD=='mailto') print "selected=\"selected\""; ?>><?php print $pgv_lang["mailto"];?></option>
				<option value="none" <?php if ($CONTACT_METHOD=='none') print "selected=\"selected\""; ?>><?php print $pgv_lang["no_messaging"];?></option>
			</select>
		</td>
	</tr>
	<tr>
		<td class="facts_label"><?php print $pgv_lang["WEBMASTER_EMAIL"]?> <a href="#" onclick="return helpPopup('WEBMASTER_EMAIL_help');"><b>?</b></a></td>
		<td class="facts_value"><select name="NEW_WEBMASTER_EMAIL" tabindex="42" onfocus="getHelp('WEBMASTER_EMAIL_help');">
		<?php
			$users = getUsers();
			foreach($users as $user) {
				print "<option value=\"".$user["username"]."\"";
				if ($WEBMASTER_EMAIL==$user["username"]) print " selected=\"selected\"";
				print ">".$user["fullname"]." (".$user["username"].")</option>\n";
			}
		?>
		</select>
		</td>
	</tr>
	<tr>
		<td class="facts_label"><?php print $pgv_lang["SUPPORT_METHOD"]?> <a href="#" onclick="return helpPopup('SUPPORT_METHOD_help');"><b>?</b></a></td>
		<td class="facts_value"><select name="NEW_SUPPORT_METHOD" tabindex="43" onfocus="getHelp('SUPPORT_METHOD_help');">
				<option value="mailto" <?php if ($SUPPORT_METHOD=='mailto') print "selected=\"selected\""; ?>><?php print $pgv_lang["mailto"];?></option>
				<option value="messaging" <?php if ($SUPPORT_METHOD=='messaging') print "selected=\"selected\""; ?>><?php print $pgv_lang["messaging"];?></option>
				<option value="messaging2" <?php if ($SUPPORT_METHOD=='messaging2') print "selected=\"selected\""; ?>><?php print $pgv_lang["messaging2"];?></option>
				<option value="mailto" <?php if ($SUPPORT_METHOD=='mailto') print "selected=\"selected\""; ?>><?php print $pgv_lang["mailto"];?></option>
				<option value="none" <?php if ($SUPPORT_METHOD=='none') print "selected=\"selected\""; ?>><?php print $pgv_lang["no_messaging"];?></option>
			</select>
		</td>
	</tr>
	<tr>
		<td class="facts_label"><?php print $pgv_lang["FAVICON"]?> <a href="#" onclick="return helpPopup('FAVICON_help');"><b>?</b></a></td>
		<td class="facts_value"><input type="text" name="NEW_FAVICON" value="<?php print $FAVICON?>" size="40" tabindex="44" onfocus="getHelp('FAVICON_help');" /></td>
	</tr>
	<tr>
		<td class="facts_label"><?php print $pgv_lang["SHOW_STATS"]?> <a href="#" onclick="return helpPopup('SHOW_STATS_help');"><b>?</b></a></td>
		<td class="facts_value"><select name="NEW_SHOW_STATS" tabindex="45" onfocus="getHelp('SHOW_STATS_help');">
				<option value="yes" <?php if ($SHOW_STATS) print "selected=\"selected\""; ?>><?php print $pgv_lang["yes"];?></option>
				<option value="no" <?php if (!$SHOW_STATS) print "selected=\"selected\""; ?>><?php print $pgv_lang["no"];?></option>
			</select>
		</td>
	</tr>
	<tr>
		<td class="facts_label"><?php print $pgv_lang["THEME_DIR"]?> <a href="#" onclick="return helpPopup('THEME_DIR_help');"><b>?</b></a></td>
		<td class="facts_value">
			<select name="themeselect" tabindex="46"  onchange="document.configform.NTHEME_DIR.value=document.configform.themeselect.options[document.configform.themeselect.selectedIndex].value;">
				<?php
					$themes = get_theme_names();
					foreach($themes as $themedir) {
						print "<option value=\"".$themedir["dir"]."\"";
						if ($themedir["dir"] == $NTHEME_DIR) print " selected=\"selected\"";
						print ">".$themedir["name"]."</option>\n";
					}
				?>
				<option value="themes/" <?php if($themeselect=="themes//") print "selected=\"selected\""; ?>><?php print $pgv_lang["other_theme"]; ?></option>
			</select>
			<input type="text" name="NTHEME_DIR" value="<?php print $NTHEME_DIR?>" size="40" tabindex="47" onfocus="getHelp('THEME_DIR_help');" />
		</td>
	</tr>
	<tr>
		<td class="facts_label"><?php print $pgv_lang["TIME_LIMIT"]?> <a href="#" onclick="return helpPopup('TIME_LIMIT_help');"><b>?</b></a></td>
		<td class="facts_value"><input type="text" name="NEW_TIME_LIMIT" value="<?php print $TIME_LIMIT?>" size="5" tabindex="48" onfocus="getHelp('TIME_LIMIT_help');" /></td>
	</tr>
</table>
<font class="error"><?php print $pgv_lang["save_and_import"]; ?></font><br />
<input type="submit" tabindex="49" value="<?php print $pgv_lang["save_config"]?>" onclick="closeHelp();" />
<input type="reset" tabindex="50" value="<?php print $pgv_lang["reset"]?>" /><br />
</form>
<?php if (count($GEDCOMS)==0) { ?>
<script language="JavaScript">
	helpPopup('welcome_help');
</script>
<?php
}

print_footer();

?>
