<?php
/*=================================================
	Project: phpGedView
	File: editgedcoms.php
	Author: John Finlay
	Comments:
		UI for online updating of the config file.

	phpGedView: Genealogy Viewer
    Copyright (C) 2002 to 2003  John Finlay and Others

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
    
===================================================*/
# $Id: editgedcoms.php,v 1.16.2.5 2004/02/02 15:18:11 yalnifj Exp $

require "config.php";
require $PGV_BASE_DIRECTORY.$confighelpfile["english"];
if (file_exists($PGV_BASE_DIRECTORY.$confighelpfile[$LANGUAGE])) require $PGV_BASE_DIRECTORY.$confighelpfile[$LANGUAGE];

if (!isset($action)) $action="";
if (!isset($ged)) $ged = "";

//-- make sure that they have admin status before they can use this page
//-- otherwise have them login again
if (!userIsAdmin(getUserName())) {
	header("Location: login.php?url=editgedcoms.php");
	exit;
}

print_header("GEDCOM Administration");
print "<center>\n";

if ($action=="delete") {
	unset($GEDCOMS[$ged]);
	store_gedcoms();
	delete_gedcom($ged);
	print "<br />".str_replace("#GED#", $ged, $pgv_lang["gedcom_deleted"])."<br />\n";
}

if ($action=="setdefault") {
	$DEFAULT_GEDCOM = $default_ged;
	$configtext = implode('', file("config.php"));
	print $pgv_lang["config_file_read"]."<br />\n";
	$configtext = preg_replace('/\$DEFAULT_GEDCOM\s*=\s*".*";/', "\$DEFAULT_GEDCOM = \"".$_POST["default_ged"]."\";", $configtext);
	$fp = fopen("config.php", "wb");
	if (!$fp) {
		print "<font class=error>".$pgv_lang["config_write_error"]."<br /></font>\n";
	}
	else {
		fwrite($fp, $configtext);
		fclose($fp);
	}
}

print "<br /><br />";
?>
<font class="subheaders"><?php print $pgv_lang["current_gedcoms"]; ?></font><br />
<?php if (!empty($ged)) print "<br />".$pgv_lang["now_import"]."<br /><br />";?>
<form name="defaultform" method="post">
<input type="hidden" name="action" value="setdefault">
<table class="list_table">
<tr>
	<td class="list_label"><?php print $pgv_lang["delete"]; ?></td>
	<td class="list_label"><?php print $pgv_lang["edit"]; ?></td>
	<td class="list_label"><?php print $pgv_lang["edit_privacy"]; ?></td>
	<td class="list_label"><?php print $pgv_lang["DEFAULT_GEDCOM"]?></td>
	<td class="list_label"><?php print $pgv_lang["ged_gedcom"]; ?></td>
	<td class="list_label"><?php print $pgv_lang["ged_title"]; ?></td>
	<td class="list_label"><?php print $pgv_lang["ged_config"]; ?></td>
	<td class="list_label"><?php print $pgv_lang["ged_import"]; ?></td>
	<td class="list_label"><?php print $pgv_lang["ged_download"]; ?></td>
</tr>
<?php
foreach($GEDCOMS as $gedc=>$gedarray) {
	if (empty($DEFAULT_GEDCOM)) {
		$DEFAULT_GEDCOM = $gedc;
	}
	print "\t<tr><td class=\"list_value\"><a href=\"editgedcoms.php?action=delete&ged=".urlencode($gedc)."\" onclick=\"return confirm('".$pgv_lang["confirm_gedcom_delete"]." $gedc?');\">".$pgv_lang["delete"]."</a></td>\n";
	print "\t<td class=\"list_value\"><a href=\"editconfig_gedcom.php?ged=".urlencode($gedc)."\">".$pgv_lang["edit"]."</a></td>\n";
	print "\t<td class=\"list_value\"><a href=\"edit_privacy.php?action=edit&amp;ged=".urlencode($gedc)."\">".$pgv_lang["edit_privacy"]."</a></td>\n";
	print "\t<td class=\"list_value\"><input type=\"radio\" name=\"default_ged\" value=\"".urlencode($gedc)."\"";
	if ($DEFAULT_GEDCOM==$gedc) print " checked";
	print " onclick=\"document.defaultform.submit();\"></td>\n";
	print "\t<td class=\"list_value\">";
	if (file_exists($gedarray["path"])) {
		print "$gedc (";
		printf("%.2fKb", (filesize($gedarray["path"])/1024));
		print ")";
	}
	else print "<span class=\"error\">".$pgv_lang["file_not_found"]."</span>";
	print "</td>\n";
	print "\t<td class=\"list_value\">".$gedarray["title"]."</td>\n";
	print "\t<td class=\"list_value\">".$gedarray["config"]."</td>\n";
	print "\t<td class=\"list_value\"><a href=\"importgedcom.php?ged=$gedc\">".$pgv_lang["ged_import"]."</a>";
	if (!check_for_import($gedc)) {
		print "<br /><span class=\"error\">".$pgv_lang["gedcom_not_imported"]."</span>";
	}
	print "</td>\n";
	print "\t<td class=\"list_value\"><a href=\"downloadgedcom.php?ged=$gedc\">".$pgv_lang["ged_download"]."</a></td>\n";
	print "</tr>";
}
print "</table>\n</form>";

print "<br /><br /><a href=\"editconfig_gedcom.php\">".$pgv_lang["add_gedcom"]."</a><br /><br />";
print "<a href=\"uploadgedcom.php\">".$pgv_lang["upload_gedcom"]."</a><br /><br />";
print "<a href=\"addnewgedcom.php\">".$pgv_lang["add_new_gedcom"]."</a><br /><br />";
print "<br /><br />\n";

print_footer();
?>