<?php
/*=================================================
   Project:	phpGedView
   File:	editlang.php
   Author:	John Finlay, Kurt Norgaz
   Comments:	Display a diff between two language files to help in translating.
   phpGedView:	Genealogy Viewer
		Copyright (C) 2002 to 2003  John Finlay and Others

   Change Log:	2003/07/20 - File Created

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
===================================================*/
# $Id: editlang.php,v 1.32.2.4 2004/02/03 22:13:22 yalnifj Exp $

require "config.php";
require $PGV_BASE_DIRECTORY . $confighelpfile["english"];
if (file_exists($PGV_BASE_DIRECTORY . $confighelpfile[$LANGUAGE])) require $PGV_BASE_DIRECTORY . $confighelpfile[$LANGUAGE];

require $PGV_BASE_DIRECTORY . "editlang_functions.php";
if (file_exists($PGV_BASE_DIRECTORY . "rs_functions.php")) require $PGV_BASE_DIRECTORY . "rs_functions.php";

if (!isset($action)) $action="";
if (!isset($language2)) $language2 = $LANGUAGE;
if (!isset($file_type)) $file_type = "lang";
if (!isset($language1)) $language1="english";
$lang_shortcut = $language_settings[$language2]["lang_short_cut"];

//-- make sure that they have admin status before they can use this page
//-- otherwise have them login again
$uname = getUserName();
if (empty($uname)) {
	header("Location: login.php?url=editlang.php");
	exit;
}

switch ($action)
{
  case "edit"	: print_header($pgv_lang["edit_lang_utility"]); break;
  case "export"	: print_header($pgv_lang["export_lang_utility"]); break;
  case "compare": print_header($pgv_lang["compare_lang_utility"]); break;
  default	: print_header($pgv_lang["edit_langdiff"]); break;
}

print "<script language=\"JavaScript\">\n";
print "var helpWin;\n";
print "function helpPopup(which) {\n";
print "if ((!helpWin)||(helpWin.closed)){helpWin = window.open('editlang_edit.php?' + which, '' , 'left=50, top=30, width=700, height=600, resizable=1, scrollbars=1'); helpWin.focus();}\n";
print "else helpWin.location = 'editlang_edit.php?' + which;\n";
print "return false;\n";
print "}\n";
print "function showchanges() {";
print "\twindow.location = '$PHP_SELF?$QUERY_STRING';";
print "}";
print "function helpPopup02(which) {\n";
print "if ((!helpWin)||(helpWin.closed)){helpWin = window.open('editlang_edit_settings.php?' + which, '' , 'left=50, top=30, width=700, height=600, resizable=1, scrollbars=1'); helpWin.focus();}\n";
print "else helpWin.location = 'editlang_edit_settings.php?' + which;\n";
print "return false;\n";
print "}\n";
print "</script>\n";

# print "<center>";
print "<div class=\"center\"><center>";
    print "<table class=\"facts_table\" style=\"width:70%; \">";
      print "<tr>";
        print "<td class=\"facts_label03\">";
          print "<a href=\"http://sourceforge.net/forum/forum.php?forum_id=294245\" target=\"translationsforum\">";
          print $pgv_lang["translation_forum"]; "Link to the PhpGedView translations forum on SourceForge";
          print "</a>";
        print "</td>";
      print "</tr>";
      print "<tr>";
        print "<td class=\"facts_value\" style=\"text-align:left; \">" . $pgv_lang["translation_forum_help"] . "</td>";
      print "</tr>";
    print "</table>";
    print "<img src=\"$PGV_IMAGE_DIR/$PGV_HLINE_IMG\" width=\"100%\" height=\"6\" alt=\"\" /><br />\n";

  if (($action == "") or ($action == "edit"))
  {
    //-- Choose the language and the file type you want do edit the content of
    print "<table class=\"facts_table\" style=\"width:70%; \">";
      print "<tr>";
        print "<td class=\"facts_label03\">" . $pgv_lang["edit_lang_utility"] . "</td>";
      print "</tr>";
      print "<tr>";
        print "<td class=\"facts_value\" style=\"text-align:left; \">" . $pgv_lang["edit_lang_utility_help"] . "</td>";
      print "</tr>";
    print "</table>";

    print "<form name=\"choose_form\" method=\"get\">";
      print "<input type=\"hidden\" name=\"action\" value=\"edit\" />";
      print "<table class=\"facts_table\" style=\"width:70%; \">";
        print "<tr>";
          print "<td class=\"facts_value\" style=\"text-align:left; \">" . $pgv_lang["language_to_edit"] . ":<br />";
            print "<select name=\"language2\">";
              foreach ($pgv_language as $key => $value)
              {
              	print "\n\t\t\t<option value=\"$key\"";
              	if ($key == $language2) print " selected=\"selected\"";
              	print ">".$pgv_lang[$key]."</option>";
              }
            print "</select>";
          print "</td>";

          print "<td class=\"facts_value\" style=\"text-align:left; \">" . $pgv_lang["file_to_edit"] . ":<br />";
            print "<select name=\"file_type\">";
            print "\n\t\t\t<option value=\"lang\"";
            if ($file_type == "lang") print " selected=\"selected\"";
            print ">"."lang.xx.php"."</option>";

            print "\n\t\t\t<option value=\"facts\"";
            if ($file_type == "facts") print " selected=\"selected\"";
            print ">" . "facts.xx.php" . "</option>";

            print "\n\t\t\t<option value=\"configure_help\"";
            if ($file_type == "configure_help") print " selected=\"selected\"";
            print ">" . "configure_help.xx.php" . "</option>";
            
            print "\n\t\t\t<option value=\"help_text\"";
            if ($file_type == "help_text") print " selected=\"selected\"";
            print ">" . "help_text.xx.php" . "</option>";

            if (file_exists($PGV_BASE_DIRECTORY . "rs_functions.php"))
            {
              print "\n\t\t\t<option value=\"rs_lang\"";
              if ($file_type == "rs_lang") print " selected=\"selected\"";
              print ">" . "rs_lang.xx.php" . "</option>";
            }

            print "</select>";
          print "</td>";

          print "<td class=\"facts_value\" style=\"text-align: center; \">";
            print "<input type=\"submit\" value=\"" . $pgv_lang["edit"] . "\" />";
          print "</td>";
        print "</tr>";
      print "</table>";
    print "</form>";
    if ($action == "edit") print  "<a href=\"editlang.php\">" . $pgv_lang["lang_back"] . "</a><br /><br />";
    print "<img src=\"$PGV_IMAGE_DIR/$PGV_HLINE_IMG\" width=\"100%\" height=\"6\" alt=\"\" /><br />\n";
  }

  if (($action != "edit") and ($action != "compare") and ($action != "config_lang"))
  {
    //-- Choose the language you want to export the help messages into a seperate HTML-File
    print "<br />";
    print "<table class=\"facts_table\" style=\"width:70%; \">";
      print "<tr>";
        print "<td class=\"facts_label03\">" . $pgv_lang["export_lang_utility"] . "</td>";
      print "</tr>";
      print "<tr>";
        print "<td class=\"facts_value\" style=\"text-align:left; \">" . $pgv_lang["export_lang_utility_help"] . "</td>";
      print "</tr>";
    print "</table>";

    print "<form name=\"export_form\" method=\"get\">";
      print "<input type=\"hidden\" name=\"action\" value=\"export\" />";
      print "<table class=\"facts_table\" style=\"width:70%; \">";
        print "<tr>";
          print "<td class=\"facts_value\" style=\"text-align:left; \">" . $pgv_lang["language_to_export"] . ":<br />";
            print "<select name=\"language2\">";
              foreach ($pgv_language as $key => $value)
              {
              	print "\n\t\t\t<option value=\"$key\"";
              	if ($key == $language2) print " selected=\"selected\"";
              	print ">".$pgv_lang[$key]."</option>";
              }
            print "</select>";
          print "</td>";

          print "<td class=\"facts_value\" style=\"text-align: center; \">";
            print "<input type=\"submit\" value=\"" . $pgv_lang["export"] . "\" />";
          print "</td>";
        print "</tr>";
      print "</table>";
    print "</form>";
    if ($action != "export") print "<img src=\"$PGV_IMAGE_DIR/$PGV_HLINE_IMG\" width=\"100%\" height=\"6\" alt=\"\" /><br />\n";
  }

  if (($action != "edit") and ($action != "export") and ($action != "config_lang"))
  {
    //-- Choose the languages you want to compare the content of
    print "<br />";
    print "<table class=\"facts_table\" style=\"width:70%; \">";
      print "<tr>";
        print "<td class=\"facts_label03\">" . $pgv_lang["compare_lang_utility"] . "</td>";
      print "</tr>";
      print "<tr>";
        print "<td class=\"facts_value\" style=\"text-align:left; \">";
          if (strpos($pgv_lang["compare_lang_utility_help"], "#languages/LANG_CHANGELOG.txt#"))
          {
            $ct01 = strpos($pgv_lang["compare_lang_utility_help"], "#languages/LANG_CHANGELOG.txt#");
            $d01 = substr($pgv_lang["compare_lang_utility_help"], 0, $ct01);
            $d02 = substr($pgv_lang["compare_lang_utility_help"], $ct01 + 30);
            print $d01;
            print "<a href=\"languages/LANG_CHANGELOG.txt\" target=\"changelog\">" . "languages/LANG_CHANGELOG.txt" . "</a>";
            print $d02;
          }
          else print $pgv_lang["compare_lang_utility_help"];
        print "</td>";
      print "</tr>";
    print "</table>";

   print "<form name=\"langdiff_form\" method=\"get\">";
      print "<input type=\"hidden\" name=\"action\" value=\"compare\">";
      print "<table class=\"facts_table\" style=\"width:70%; \">";
        print "<tr>";
          print "<td class=\"facts_value\" style=\"text-align:left; \">" . $pgv_lang["new_language"] . ":<br />";
            print "<select name=\"language1\">";
              foreach ($pgv_language as $key => $value)
              {
              	print "\n\t\t\t<option value=\"$key\"";
              	if ($key == $language1) print " selected=\"selected\"";
              	print ">".$pgv_lang[$key]."</option>";
              }
            print "</select>";
          print "</td>";
          print "<td class=\"facts_value\" style=\"text-align:left; \">" . $pgv_lang["old_language"] . ":<br />";
            print "<select name=\"language2\">";
              foreach ($pgv_language as $key => $value)
              {
              	print "\n\t\t\t<option value=\"$key\"";
              	if ($key == $language2) print " selected=\"selected\"";
              	print ">".$pgv_lang[$key]."</option>";
              }
           print "</select>";
          print "</td>";

          print "<td class=\"facts_value\" style=\"text-align: center; \">";
            print "<input type=\"submit\" value=\"" . $pgv_lang["compare"] . "\" />";
          print "</td>";
        print "</tr>";
      print "</table>";
    print "</form>";
    if ($action == "compare") print  "<a href=\"editlang.php\">" . $pgv_lang["lang_back"] . "</a><br /><br />";
    print "<img src=\"$PGV_IMAGE_DIR/$PGV_HLINE_IMG\" width=\"100%\" height=\"6\" alt=\"\" /><br />\n";
  }

  if (($action != "edit") and ($action != "export") and ($action != "compare") and ($action != "config_lang"))
  {
    //-- Choose the language you want to edit the settings of
    print "<br />";
    print "<table class=\"facts_table\" style=\"width:70%; \">";
      print "<tr>";
        print "<td class=\"facts_label03\">" . $pgv_lang["config_lang_utility"] . "</td>";
      print "</tr>";
      print "<tr>";
        print "<td class=\"facts_value\" style=\"text-align:left; \">" . $pgv_lang["config_lang_utility_help"] . "</td>";
      print "</tr>";
    print "</table>";

    print "<form name=\"lang_config_form\" method=\"get\">";
      print "<input type=\"hidden\" name=\"action\" value=\"config_lang\">";
      print "<table class=\"facts_table\" style=\"width:70%; \">";
        print "<tr>";
          print "<td class=\"facts_label03\">" . $pgv_lang["lang_language"] . "</td>";
          print "<td class=\"facts_label03\">" . $pgv_lang["active"] . "</td>";
          print "<td class=\"facts_label03\">" . $pgv_lang["edit_settings"] . "</td>";
          print "<td class=\"facts_label03\">" . "&nbsp;" . "</td>";
          print "<td class=\"facts_label03\">" . $pgv_lang["lang_language"] . "</td>";
          print "<td class=\"facts_label03\">" . $pgv_lang["active"] . "</td>";
          print "<td class=\"facts_label03\">" . $pgv_lang["edit_settings"] . "</td>";
        print "</tr>\n";

        $cnt = 0;
        foreach ($pgv_language as $key => $value)
        {
          if (($cnt % 2) == 0){print "<tr>";}	/* Even number */
            print "<td class=\"facts_value\" style=\"text-align: center;\">";
              $d_LangName = "lang_name_" . $key;
              print $pgv_lang[$d_LangName];
            print "</td>";
            print "<td class=\"facts_value\" style=\"text-align: center;\">";
              if ($pgv_lang_use["$key"]) print $pgv_lang["yes"]; else print $pgv_lang["no"];
            print "</td>";
            print "<td class=\"facts_value\" style=\"text-align: center;\">";
              if ($key != "english")
              {
              	print "<a href=\"#\" onclick=\"return helpPopup02('" . "ln=" . $key . "');\">";
              	print $pgv_lang["lang_edit"];
              	print "</a>";
              }
              else print "&nbsp;";
            print "</td>";

          /* Odd number closes <tr> - even number adds empty <td>*/
          if (($cnt % 2) == 1) print "</tr>"; else print "<td class=\"facts_label03\">&nbsp;</td>";
          $cnt++;
        }
        /* Odd number */
        if (($cnt % 2) == 1){print "<td class=\"facts_value\">&nbsp;</td><td class=\"facts_value\">&nbsp;</td><td class=\"facts_value\">&nbsp;</td></tr>";}
      print "</table>";
    print "</form>";
    print "<img src=\"$PGV_IMAGE_DIR/$PGV_HLINE_IMG\" width=\"100%\" height=\"6\" alt=\"\" /><br /><br />\n";
  }

  if ($action == "") print  "<a href=\"admin.php\">" . $pgv_lang["lang_back_admin"] . "</a><br /><br />";

  if ($action == "edit")
  {
    print "<br /><font class=\"subheaders\">" . $pgv_lang["listing"] . ": \"";
    switch ($file_type)
    {
      case "lang"		: print $pgv_language["english"] . "\" ";
          			  print $pgv_lang["and"] . " \"";
          			  print $pgv_language[$language2];
          			  // read the english lang.en.php file into array
          			  $english_language_array = array();
          			  $english_language_array = read_complete_file_into_array($pgv_language["english"], "pgv_lang[");
          			  // read the chosen lang.xx.php file into array
          			  $new_language_array = array();
          			  $new_language_array = read_complete_file_into_array($pgv_language[$language2], "pgv_lang[");
          			  break;
      case "facts"		: print $factsfile["english"]."\" ";
          			  print $pgv_lang["and"] . " \"";
          			  print $factsfile[$language2];
          			  // read the english lang.en.php file into array
          			  $english_language_array = array();
          			  $english_language_array = read_complete_file_into_array($factsfile["english"], "factarray[");
          			  // read the chosen lang.xx.php file into array
          			  $new_language_array = array();
          			  $new_language_array = read_complete_file_into_array($factsfile[$language2], "factarray[");
          			  break;
      case "configure_help"	: print $confighelpfile["english"]."\" ";
          			  print $pgv_lang["and"] . " \"";
          			  print $confighelpfile[$language2];
          			  // read the english lang.en.php file into array
          			  $english_language_array = array();
          			  $english_language_array = read_complete_file_into_array($confighelpfile["english"], "pgv_lang[");
          			  // read the chosen lang.xx.php file into array
          			  $new_language_array = array();
          			  $new_language_array = read_complete_file_into_array($confighelpfile[$language2], "pgv_lang[");
          			  break;
      case "help_text"	: print $helptextfile["english"]."\" ";
          			  print $pgv_lang["and"] . " \"";
          			  print $helptextfile[$language2];
          			  // read the english lang.en.php file into array
          			  $english_language_array = array();
          			  $english_language_array = read_complete_file_into_array($helptextfile["english"], "pgv_lang[");
          			  // read the chosen lang.xx.php file into array
          			  $new_language_array = array();
          			  $new_language_array = read_complete_file_into_array($helptextfile[$language2], "pgv_lang[");
          			  break;
      case "rs_lang"		: print $rs_language["english"] . "\" ";
          			  print $pgv_lang["and"] . " \"";
          			  print $rs_language[$language2];
          			  // read the english lang.en.php file into array
          			  $english_language_array = array();
          			  $english_language_array = read_complete_file_into_array($rs_language["english"], "pgv_lang[");
          			  // read the chosen lang.xx.php file into array
          			  $new_language_array = array();
          			  $new_language_array = read_complete_file_into_array($rs_language[$language2], "pgv_lang[");
          			  break;
    }

    print "\"</font><br /><br />\n";
    print "<font class=\"subheaders\">" . $pgv_lang["contents"] . ":</font>";
    print "<table class=\"facts_table\">\n";
      $lastfound = (-1);
      for ($z = 0; $z < sizeof($english_language_array); $z++)
      {
        if (isset($english_language_array[$z][1]))
        {
	  print "<tr>";
	    print "<td class=\"facts_label\" rowspan=\"2\">";
	      print $english_language_array[$z][0];
	    print "</td>\n";
	    print "<td class=\"facts_value\" style=\"text-align:left; \">";
	      if (stripslashes(mask_all($english_language_array[$z][1])) == "")
	      {
	        print "<strong style=\"color: #FF0000\">" . str_replace("#LANGUAGE_FILE#", $pgv_language[$language1], $pgv_lang["message_empty_warning"]) . "</strong>";
	      }
	      else print "<i>" . stripslashes(mask_all($english_language_array[$z][1])) . "</i>";
	    print "</td>";
	  print "</tr>\n";

	  print "<tr>\n";
	    print "<td class=\"facts_value\" style=\"text-align:left; \">";

	      $found = false;
	      for ($y = 0; $y < sizeof($new_language_array); $y++)
	      {
	        if (isset($new_language_array[$y][1]))
	        {
	          if ($new_language_array[$y][0] == $english_language_array[$z][0])
	          {
	            $dDummy =  $new_language_array[$y][1];
	            print "<a href=\"#\" onclick=\"return helpPopup('" . "ls01=" . $z . "&ls02=" . $y . "&language2=" . $language2 . "&file_type=" . $file_type . "');\">";
	            print stripslashes(mask_all($dDummy));
	            if (stripslashes(mask_all($dDummy)) == "")
	            {
	              print "<strong style=\"color: #FF0000\">" . str_replace("#LANGUAGE_FILE#", $pgv_language[$language2], $pgv_lang["message_empty_warning"]) . "</strong>";
	            }
	            print "</a>";
	            $found = true;
	            $lastfound = $y;
	            break;
	          }
	        }
	      }
	      if (!$found)
	      {
	        print "<a style=\"color: #FF0000\" href=\"#\" onclick=\"return helpPopup('" . "ls01=" . $z . "&ls02=" . (0 - intval($lastfound) - 1) . "&language2=" . $language2 . "&file_type=" . $file_type . "');\">";
	        print "<i>";
	        if (stripslashes(mask_all($english_language_array[$z][1])) == "")
	        {
	          print "&nbsp;";
	        }
	        else print stripslashes(mask_all($english_language_array[$z][1]));
	        print "</i>";
	        print "</a>";
	      }

	    print "</td>";
	  print "</tr>\n";
	}
      }
    print "</table>\n";
    print  "<br /><br />" . "<a href=\"editlang.php\">" . $pgv_lang["lang_back"] . "</a><br /><br />";
  }

  if ($action == "export")
  {
    $FileName = $confighelpfile[$language2] . ".html";
    $fp = @fopen($FileName, "w");

    fwrite($fp, "<html><head><meta http-equiv=\"content-type\" content=\"text/html; charset=UTF-8\">\r\n");
    $language_array = array();
    $language_array = read_export_file_into_array($confighelpfile[$language2], "pgv_lang[");
    $new_language_array = array();
    $new_language_array_counter = 0;;

    for ($z = 0; $z < sizeof($language_array); $z++)
    {
      if (strpos($language_array[$z][0], "_help") > 0)
      {
        $language_array[$z][0] = substr($language_array[$z][0], strpos($language_array[$z][0], "\"") + 1);
        $language_array[$z][0] = substr($language_array[$z][0], 0, strpos($language_array[$z][0], "\""));
        $new_language_array[$new_language_array_counter] = $language_array[$z];
        $new_language_array_counter++;
      }
    }

    fwrite($fp, "<ol>");

    for ($z = 0; $z < sizeof($new_language_array); $z++)
    {
      for ($x = 0; $x < sizeof($language_array); $x++)
      {
        $dDummy = $new_language_array[$z][0];
        $dDummy = substr($dDummy, 0, strpos($dDummy, "_help"));

        if (strpos($language_array[$x][0], "\"" . $dDummy . "\"") > 0)
        {
          if ($new_language_array[$z][0] != "config_help")
          {
            if ($new_language_array[$z][0] != "welcome_help")
            {
              $new_language_array[$z][0] = $language_array[$x][1];
            }
          }
          break;
        }
      }
    }
    for ($z = 0; $z < sizeof($new_language_array); $z++)
    {
      if ($new_language_array[$z][0] != "config_help")
      {
        if ($new_language_array[$z][0] != "welcome_help")
        {
          fwrite($fp, "<li><strong>".$new_language_array[$z][0] . "</strong><br />");
          fwrite($fp, stripslashes($new_language_array[$z][1]) . "<br /><br /></li>\r\n");
        }
      }
    }

    fwrite($fp, "</ol>");
    fwrite($fp, "</body></html>\r\n");
    fclose($fp);
    print "<strong>" . $pgv_lang["export_ok"] . "</strong><br />";
    print $pgv_lang["export_filename"] . " " . $FileName;
    print  "<br /><br />" . "<a href=\"editlang.php\">" . $pgv_lang["lang_back"] . "</a><br /><br />";
  }

  if ($action == "compare")
  {
    $d_pgv_lang["comparing"] = $pgv_lang["comparing"];
    $d_pgv_lang["no_additions"] = $pgv_lang["no_additions"];
    $d_pgv_lang["additions"] = $pgv_lang["additions"];
    $d_pgv_lang["subtractions"] = $pgv_lang["subtractions"];
    $d_pgv_lang["no_subtractions"] = $pgv_lang["no_subtractions"];

    print "<br /><font class=\"subheaders\">".$d_pgv_lang["comparing"]."<br />\"".$pgv_language[$language1]."\" <---> \"".$pgv_language[$language2]."\"</font><br /><br />\n";
    $pgv_lang=array();
    require $PGV_BASE_DIRECTORY.$pgv_language[$language1];
    $lang1 = $pgv_lang;
    print "<font class=\"subheaders\">".$d_pgv_lang["additions"].":</font><table class=\"facts_table\">\n";
    $pgv_lang=array();
    if (file_exists($PGV_BASE_DIRECTORY.$pgv_language[$language2])) require $PGV_BASE_DIRECTORY.$pgv_language[$language2];
    $count=0;
    foreach($lang1 as $key=>$value)
    {
      if (!array_key_exists($key, $pgv_lang))
      {
      	print "<tr><td class=\"facts_label\">\$pgv_lang[\"$key\"]</td>\n";
      	print "<td class=\"facts_value\" style=\"text-align:left; \">\"$value\";</td></tr>\n";
      	$count++;
      }
    }
    if ($count==0)
    {
      print "<tr><td colspan=\"2 class=\"facts_value\" style=\"text-align:left; \">".$d_pgv_lang["no_additions"]."</td></tr>\n";
    }
    print "</table><br /><br />\n";
    print "<font class=\"subheaders\">".$d_pgv_lang["subtractions"].":</font>:<table class=\"facts_table\">\n";
    $count=0;
    foreach($pgv_lang as $key=>$value)
    {
      if (!array_key_exists($key, $lang1))
      {
      	print "<tr><td class=\"facts_label\">\$pgv_lang[\"$key\"]</td>\n";
      	print "<td class=\"facts_value\" style=\"text-align:left; \">\"$value\";</td></tr>\n";
      	$count++;
      }
    }
    if ($count==0)
    {
      print "<tr><td colspan=\"2\" class=\"facts_value\" style=\"text-align:left; \">".$d_pgv_lang["no_subtractions"]."</td></tr>\n";
    }
    print "</table><br /><br />\n";

    print "<img src=\"$PGV_IMAGE_DIR/$PGV_HLINE_IMG\" width=\"100%\" height=\"6\" alt=\"\" /><br />\n";
    print "<font class=\"subheaders\">".$d_pgv_lang["comparing"]."<br />\"".$factsfile[$language1]."\" <---> \"".$factsfile[$language2]."\"<br /><br /></font>\n";
    $factsarray=array();
    require $PGV_BASE_DIRECTORY.$factsfile[$language1];
    $lang1 = $factarray;
    $factsarray=array();
    if (file_exists($PGV_BASE_DIRECTORY.$factsfile[$language2])) require $PGV_BASE_DIRECTORY.$factsfile[$language2];
    print "<font class=\"subheaders\">".$d_pgv_lang["additions"].":</font><table class=\"facts_table\">\n";
    $count=0;
    foreach($lang1 as $key=>$value)
    {
      if (!array_key_exists($key, $factarray))
      {
      	print "<tr><td class=\"facts_label\">\$factarray[\"$key\"]</td>\n";
      	print "<td class=\"facts_value\" style=\"text-align:left; \">\"$value\";</td></tr>\n";
      	$count++;
      }
    }
    if ($count==0)
    {
      print "<tr><td colspan=\"2\" class=\"facts_value\" style=\"text-align:left; \">".$d_pgv_lang["no_additions"]."</td></tr>\n";
    }
    print "</table><br /><br />\n";
    print "<font class=\"subheaders\">".$d_pgv_lang["subtractions"].":</font><table class=\"facts_table\">\n";
    $count=0;
    foreach($factarray as $key=>$value)
    {
      if (!array_key_exists($key, $lang1))
      {
      	print "<tr><td class=\"facts_label\">\$pgv_lang[\"$key\"]</td>\n";
      	print "<td class=\"facts_value\" style=\"text-align:left; \">\"$value\";</td></tr>\n";
      	$count++;
      }
    }
    if ($count==0)
    {
      print "<tr><td colspan=\"2\" class=\"facts_value\" style=\"text-align:left; \">".$d_pgv_lang["no_subtractions"]."</td></tr>\n";
    }
    print "</table><br /><br />\n";

    if (file_exists($confighelpfile[$language2]))
    {
      print "<img src=\"$PGV_IMAGE_DIR/$PGV_HLINE_IMG\" width=\"100%\" height=\"6\" alt=\"\" /><br />\n";
      print "<font class=\"subheaders\">".$d_pgv_lang["comparing"]."<br />\"".$confighelpfile[$language1]."\" <---> \"".$confighelpfile[$language2]."\"</font><br /><br />\n";
      $pgv_lang=array();
      require $PGV_BASE_DIRECTORY.$confighelpfile[$language1];
      $lang1 = $pgv_lang;
      $pgv_lang=array();
      if (file_exists($PGV_BASE_DIRECTORY.$confighelpfile[$language2])) require $PGV_BASE_DIRECTORY.$confighelpfile[$language2];
      print "<font class=\"subheaders\">".$d_pgv_lang["additions"].":</font><table class=\"facts_table\">\n";
      $count=0;
      foreach($lang1 as $key=>$value)
      {
      	if (!array_key_exists($key, $pgv_lang))
      	{
      	  print "<tr><td class=\"facts_label\">\$pgv_lang[\"$key\"]</td>\n";
      	  print "<td class=\"facts_value\" style=\"text-align:left; \">\"$value\";</td></tr>\n";
      	  $count++;
      	}
      }
      if ($count==0)
      {
        print "<tr><td colspan=\"2\" class=\"facts_value\" style=\"text-align:left; \">".$d_pgv_lang["no_additions"]."</td></tr>\n";
      }

      print "</table><br /><br />\n";
      print "<font class=\"subheaders\">".$d_pgv_lang["subtractions"].":</font>:<table class=\"facts_table\">\n";
      $count=0;
      foreach($pgv_lang as $key=>$value)
      {
      	if (!array_key_exists($key, $lang1))
      	{
      	  print "<tr><td class=\"facts_label\">\$pgv_lang[\"$key\"]</td>\n";
      	  print "<td class=\"facts_value\" style=\"text-align:left; \">\"$value\";</td></tr>\n";
      	  $count++;
      	}
      }
      if ($count==0)
      {
      	print "<tr><td colspan=\"2\" class=\"facts_value\" style=\"text-align:left; \">".$d_pgv_lang["no_subtractions"]."</td></tr>\n";
      }
      print "</table><br /><br />\n";
    }
    require $PGV_BASE_DIRECTORY.$pgv_language[$language1];
    require $PGV_BASE_DIRECTORY.$pgv_language[$language2];

    if (file_exists($PGV_BASE_DIRECTORY . "rs_functions.php"))
    {
      if (file_exists($rs_language[$language1]))
      {
        print "<img src=\"$PGV_IMAGE_DIR/$PGV_HLINE_IMG\" width=\"100%\" height=\"6\" alt=\"\" /><br />\n";
        print "<font class=\"subheaders\">".$d_pgv_lang["comparing"]."<br />\"".$rs_language[$language1]."\" <---> \"".$rs_language[$language2]."\"</font><br /><br />\n";
        $pgv_lang=array();
        require $PGV_BASE_DIRECTORY.$rs_language[$language1];
        $lang1 = $pgv_lang;
        $pgv_lang=array();
        if (file_exists($rs_language[$language2])) require $PGV_BASE_DIRECTORY.$rs_language[$language2];
        print "<font class=\"subheaders\">".$d_pgv_lang["additions"].":</font><table class=\"facts_table\">\n";
        $count=0;
        foreach($lang1 as $key=>$value)
        {
          if (!array_key_exists($key, $pgv_lang))
          {
            print "<tr><td class=\"facts_label\">\$pgv_lang[\"$key\"]</td>\n";
            print "<td class=\"facts_value\" style=\"text-align:left; \">\"$value\";</td></tr>\n";
            $count++;
          }
        }
        if ($count==0)
        {
          print "<tr><td colspan=\"2\" class=\"facts_value\" style=\"text-align:left; \">".$d_pgv_lang["no_additions"]."</td></tr>\n";
        }

        print "</table><br /><br />\n";
        print "<font class=\"subheaders\">".$d_pgv_lang["subtractions"].":</font>:<table class=\"facts_table\">\n";
        $count=0;
        foreach($pgv_lang as $key=>$value)
        {
          if (!array_key_exists($key, $lang1))
          {
            print "<tr><td class=\"facts_label\">\$pgv_lang[\"$key\"]</td>\n";
            print "<td class=\"facts_value\" style=\"text-align:left; \">\"$value\";</td></tr>\n";
            $count++;
          }
        }
        if ($count==0)
        {
          print "<tr><td colspan=\"2\" class=\"facts_value\" style=\"text-align:left; \">".$d_pgv_lang["no_subtractions"]."</td></tr>\n";
        }
        print "</table><br /><br />\n";
      }
      require $PGV_BASE_DIRECTORY . $pgv_language[$language1];
      require $PGV_BASE_DIRECTORY . $pgv_language[$language2];
    }
    require $PGV_BASE_DIRECTORY . $confighelpfile["english"];
    if (file_exists($PGV_BASE_DIRECTORY . $confighelpfile[$LANGUAGE])) require $PGV_BASE_DIRECTORY . $confighelpfile[$LANGUAGE];
    print  "<br /><br />" . "<a href=\"editlang.php\">" . $pgv_lang["lang_back"] . "</a><br /><br />";
  }

print "</center></div>";

print_footer();

?>
