<?php
/*=================================================
	Project: phpGedView
	File: family.php
	Author: John Finlay
	Input Variables: $famid
	Comments:
		Parses gedcom file and displays information about a family.  You
		must supply a $famid value with the identifier for the family.

	Change Log:
		6/3/02 - File Created
		6/19/02 - Inserted check for live parents to hide marriage details
		9/24/02 - Added support for language files
		12/27/02 - Added parents of husband and wife so that the tree can be
			traversed from family view
		3/4/03 - Fixed bug where last fact was dropped
		
	phpGedView: Genealogy Viewer
    Copyright (C) 2002 to 2003  John Finlay and Others

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

===================================================*/
# $Id: family.php,v 1.59 2004/01/14 21:49:17 yalnifj Exp $

require("config.php");
require($PGV_BASE_DIRECTORY.$factsfile["english"]);
require($PGV_BASE_DIRECTORY.$factsfile[$LANGUAGE]);

function factsort($a, $b) {
   global $factarray;

   return strnatcasecmp($factarray[$a], $factarray[$b]);
}

// -- array of GEDCOM elements that will be found but should not be displayed
$nonfacts = array();
$nonfacts[0] = "FAMS";
$nonfacts[1] = "FAMC";
$nonfacts[2] = "MAY";
$nonfacts[3] = "BLOB";
$nonfacts[4] = "HUSB";
$nonfacts[5] = "WIFE";
$nonfacts[6] = "CHIL";
$nonfacts[7] = "_MEND";
$nonfacts[8] = "";

$addfacts = array("MARR","MARL","DIV","ANUL","CENS","DIVF","ENGA","MARB","MARC","MARS","SLGS");
usort($addfacts, "factsort");


$display=true;
$showLiving=true;

$bwidth=$Dbwidth;
$pbwidth = $bwidth+12;
$pbheight = $bheight+14;
	
//-- check if we can display both parents
$parents = find_parents($famid);
if ($HIDE_LIVE_PEOPLE){
	$indirec = find_person_record($parents["HUSB"]);
	$display = displayDetails($indirec);
	if ($display) {
		$indirec = find_person_record($parents["WIFE"]);
		$display = displayDetails($indirec);
		if (!$display) $showLiving=showLivingName($indirec);
	}
	else {
		$showLiving=showLivingName($indirec);
	}
}


$famrec = find_family_record($famid);

if (!$showLiving) {
	print_header($pgv_lang["living"]." ".$pgv_lang["family_info"]);
	print_privacy_error($CONTACT_EMAIL);
	print_footer();
	exit;
}
print_header(get_person_name($parents["HUSB"])." ".$pgv_lang["family_info"]);

?>

<script language="JavaScript" type="text/javascript">
<!--
	function show_gedcom_record() {
		var recwin = window.open("gedrecord.php?pid=<?php print $famid ?>", "", "top=50,left=50,width=300,height=400,scrollbars=1,scrollable=1,resizable=1");
	}
	function showchanges() {
		window.location = '<?php print $PHP_SELF."?".preg_replace("/&amp;/", "&", $QUERY_STRING)."&show_changes=yes"; ?>';
	}
//-->
</script>
<?php
if ($view!="preview" && $display ) {
    if (userCanEdit(getUserName())&&($view!="preview")) {
      if (isset($pgv_changes[$famid."_".$GEDCOM])) print "<a href=\"family.php?id=$famid&amp;show_changes=yes\">".$pgv_lang["show_changes"]."</a><br />";
    //  print "<a href=\"#\" onclick=\"return deleteperson('$famid');\">".$pgv_lang["delete_person"]."</a><br />\n";
   }
    $height = 134 + 133 * ( $SHOW_GEDCOM_RECORD + $ENABLE_CLIPPINGS_CART );
	print "\n\t<table border=\"0\" align=\"right\">";
    print "\n\t\t<tr><td align=\"center\" valign=\"top\"><a href=\"timeline.php?pids[0]=".$parents['HUSB']."&amp;pids[1]=".$parents['WIFE']."\"><img src=\"$PGV_IMAGE_DIR/$PGV_TIMELINE_IMG\" border=\"0\" alt=\"\" class=\"icon\" /><br /><font size=\"1\">".$pgv_lang['parents_timeline']."</font></a></td></tr>";
	if ( $SHOW_GEDCOM_RECORD) {
		print "\n\t\t<tr><td align=\"center\" valign=\"top\"><span class=\"link\"><a href=\"javascript:show_gedcom_record();\"><img src=\"$PGV_IMAGE_DIR/$PGV_GEDCOM_IMG\" border=\"0\" alt=\"\" class=\"icon\" /><br />".$pgv_lang["view_gedcom"]."</a></span></td></tr>";
	}
	if ( $ENABLE_CLIPPINGS_CART) {
		print "\n\t\t<tr><td align=\"center\" valign=\"top\"><span class=\"link\"><a href=\"clippings.php?action=add&amp;id=$famid&amp;type=fam\"><img src=\"$PGV_IMAGE_DIR/$PGV_CLIPPINGS_IMG\" border=\"0\" alt=\"\" class=\"icon\" /><br />".$pgv_lang["add_to_cart"]."</a></span></td></tr>";
	}
	print "</table>";
}

//-- print the parents
//-- print the father
print "<table cellspacing=\"0\" cellpadding=\"0\" border=\"0\"><tr><td rowspan=\"2\">";
print "<font class=\"subheaders\">".$pgv_lang["husband"]." </font>";
print "\n\t<table style=\"width: ".($pbwidth)."px; height: ".$pbheight."px;\"><tr>";
print "\n\t<td valign=\"top\">";
print_pedigree_person($parents['HUSB'],1);
print "</td></tr></table>";
//-- print the lines for the parents
print "</td>\n";
//-- print the parents
$hfamids = find_family_ids($parents['HUSB']);
$hparents=false;
$upfamid = "";
if (count($hfamids)>0) {
	print "<td rowspan=\"2\"><img src=\"$PGV_IMAGE_DIR/$PGV_HLINE_IMG\" alt=\"\" /></td><td rowspan=\"2\"><img src=\"$PGV_IMAGE_DIR/$PGV_VLINE_IMG\" width=\"3\" height=\"".($pbheight)."\" alt=\"\" /></td>";
	print "<td><img src=\"$PGV_IMAGE_DIR/$PGV_HLINE_IMG\" alt=\"\" /></td><td>";
	$hparents=false;
	$j=0;
	while((!$hparents)&&($j<count($hfamids))) {
		$hparents = find_parents($hfamids[$j]);
		$upfamid = $hfamids[$j];
		$j++;
	}
	if ($hparents) {
		print "\n\t<table style=\"width: ".($pbwidth)."px; height: ".$pbheight."px;\"><tr>";
		print "\n\t<td valign=\"top\">";
		print_pedigree_person($hparents['HUSB'],1);
		print "</td></tr></table>";
	}
	print "</td>";
}
if (!empty($upfamid)) {
	print "<td valign=\"middle\" rowspan=\"2\">";
	if ($view!="preview") print "<a href=\"family.php?famid=".$upfamid."&amp;show_full=$show_full\" onmouseover=\"swap_image('arrow_husb',1);\" onmouseout=\"swap_image('arrow_husb',1);\">";
	print "<img id=\"arrow_husb\" src=\"$PGV_IMAGE_DIR/$PGV_RARROW_IMG\" border=\"0\" alt=\"\"/>";
	if ($view!="preview") print "</a>";
	print "</td>\n";
}
if ($hparents) {
		print "</tr><tr><td><img src=\"$PGV_IMAGE_DIR/$PGV_HLINE_IMG\" alt=\"\" /></td><td>";
		print "\n\t<table style=\"width: ".($pbwidth)."px; height: ".$pbheight."px;\"><tr>";
		print "\n\t<td valign=\"top\">";
		print_pedigree_person($hparents['WIFE'],1);
		print "</td></tr></table>";
		print "</td>\n";
}
print "</tr></table>\n\n";
print "<br />\n";
//-- print the mother
print "<table cellspacing=\"0\" cellpadding=\"0\" border=\"0\"><tr><td rowspan=\"2\">";
print "<font class=\"subheaders\">".$pgv_lang["wife"]." </font>";
print "\n\t<table style=\"width: ".($pbwidth)."px; height: ".$pbheight."px;\"><tr>";
print "\n\t<td valign=\"top\">";
print_pedigree_person($parents['WIFE'],1);
print "</td></tr></table>";
//-- print the lines for the parents
print "</td>\n";
//-- print the parents
$hfamids = find_family_ids($parents['WIFE']);
$hparents=false;
$upfamid = "";
if (count($hfamids)>0) {
	print "<td rowspan=\"2\"><img src=\"$PGV_IMAGE_DIR/$PGV_HLINE_IMG\" alt=\"\" /></td><td rowspan=\"2\"><img src=\"$PGV_IMAGE_DIR/$PGV_VLINE_IMG\" width=\"3\" height=\"".($pbheight)."\" alt=\"\" /></td>";
	print "<td><img src=\"$PGV_IMAGE_DIR/$PGV_HLINE_IMG\" alt=\"\" /></td><td>";
	$j=0;
	while((!$hparents)&&($j<count($hfamids))) {
		$hparents = find_parents($hfamids[$j]);
		$upfamid = $hfamids[$j];
		$j++;
	}
	if ($hparents) {
		print "\n\t<table style=\"width: ".($pbwidth)."px; height: ".$pbheight."px;\"><tr>";
		print "\n\t<td valign=\"top\">";
		print_pedigree_person($hparents['HUSB'],1);
		print "</td></tr></table>";
	}
	print "</td>\n";
}
if (!empty($upfamid)) {
	print "<td valign=\"middle\" rowspan=\"2\">";
	if ($view!="preview") print "<a href=\"family.php?famid=".$upfamid."&amp;show_full=$show_full\" onmouseover=\"swap_image('arrow_wife',1);\" onmouseout=\"swap_image('arrow_wife',1);\">";
	print "<img id=\"arrow_wife\" src=\"$PGV_IMAGE_DIR/$PGV_RARROW_IMG\" border=\"0\" alt=\"\"/>";
	if ($view!="preview") print "</a>";
	print "</td>\n";
}
if ($hparents) {
	print "</tr><tr><td><img src=\"$PGV_IMAGE_DIR/$PGV_HLINE_IMG\" alt=\"\" /></td><td>";
	print "\n\t<table style=\"width: ".($pbwidth)."px; height: ".$pbheight."px;\"><tr>";
	print "\n\t<td valign=\"top\">";
	print_pedigree_person($hparents['WIFE'],1);
	print "</td></tr></table>\n";
	print "</td>\n";
}
print "</tr></table>\n\n";

//-- print the children
print "\n\t<br />\n";
print "<table width=\"100%\"><tr><td valign=\"top\">\n";
print "<table cellspacing=\"0\"><tr><td><b><font class=\"subheaders\">".$pgv_lang["children"]."</font></b></td></tr>";
$ct = preg_match_all("/1 CHIL @(.*)@/", $famrec, $match,PREG_SET_ORDER);
if ($ct>0) {
	for($i=0; $i<$ct; $i++) {
		print "\n\t\t\t<tr><td valign=\"top\" style=\"width: ".($pbwidth)."px; height: ".$pbheight."px;\">\n";
		print "<table><tr><td>";
		print_pedigree_person($match[$i][1],1);
		print "\n\t\t\t</td></tr></table></td></tr>";
	}
}
else print "\n\t\t\t<tr><td valign=\"top\"><img src=\"$PGV_IMAGE_DIR/spacer.gif\" width=\"10\" align=\"left\" alt=\"\" /><font class=\"label\">".$pgv_lang["no_children"]."</font>\n\t</td></tr>";
print "</table><br />";
if (($view!="preview") && (userCanEdit(getUserName()))) {
	print "<a href=\"#\" onclick=\"return addnewchild('$famid');\">".$pgv_lang["add_child_to_family"]."</a>";
}
print "</td><td valign=\"top\" width=\"100%\">";
//-- if both parents are displayable then print the marriage facts
if ($display) {
//-- find all the fact information
	$indifacts = array();						// -- array to store the fact records in for sorting and displaying
	$otheritems = array();
	$indilines = split("\n", $famrec);	// -- find the number of lines in the individuals record
	$lct = count($indilines);
	$factrec = "";	// -- complete fact record
	$line = "";	// -- temporary line buffer
	$f=0;
	$linenum=0;
	for($i=1; $i<=$lct; $i++) {
		if ($i<$lct) $line = $indilines[$i];
		else $line=" ";
		if (empty($line)) $line=" ";
		if (($i==$lct)||($line{0}==1)) {
			$ft = preg_match("/1\s(_?.{3,4})\s(.*)/", $factrec, $match);
			if ($ft>0) $fact = $match[1];
			else $fact="";
			$fact = trim($fact);
			// -- handle special source fact case
			if ($fact=="SOUR") {
				$otheritems[] = array($linenum, $factrec);
			}
			// -- handle special media object case
			else if ($fact=="OBJE") {
				$otheritems[] = array($linenum, $factrec);
			}
			// -- handle special note fact case
			else if ($fact=="NOTE") {
				$otheritems[] = array($linenum, $factrec);
			}
			else {
				if (!in_array($fact, $nonfacts)) {
					$indifacts[$f]=array($linenum, $factrec);
					$f++;
				}
			}
			$factrec = $line;
			$linenum = $i;
		}
		else $factrec .= "\n".$line;
	}
if (userCanEdit(getUserName())) {
   if ((isset($show_changes))&&(isset($pgv_changes[$famid."_".$GEDCOM]))) {
      $newrec = find_record_in_file($famid);
      $indilines = split("\n", $newrec);   // -- find the number of lines in the individuals record
      $lct = count($indilines);
      $factrec = "";   // -- complete fact record
      $line = "";   // -- temporary line buffer
      $f=0;
      $newfacts = array();
      $newother = array();
      $linenum = 0;
      for($i=1; $i<=$lct; $i++) {
         if ($i<$lct) $line = $indilines[$i];
         else $line=" ";
         if (empty($line)) $line=" ";
         if (($i==$lct)||($line{0}==1)) {
            $ft = preg_match("/1\s(_?.{3,4})\s(.*)/", $factrec, $match);
            if ($ft>0) $fact = $match[1];
            else $fact="";
            $fact = trim($fact);
            // -- handle special source fact case
            if ($fact=="SOUR") {
               $newother[]=array($linenum, $factrec);
            }
            // -- handle special media object case
            else if ($fact=="OBJE") {
               $newother[]=array($linenum, $factrec);
            }
            // -- handle special note fact case
            else if ($fact=="NOTE") {
               $newother[]=array($linenum, $factrec);
            }
            else {
               $newfacts[$f]=array($linenum, $factrec);
               $f++;
            }
            $factrec = $line;
            $linenum = $i;
         }
         else $factrec .= "\n".$line;
      }
   }
}
//-- loop through new facts and add them to the list if they are any changes
if (isset($newfacts)) {
        //-- compare new and old facts of the Personal Fact and Details tab 1
   for($i=0; $i<count($indifacts); $i++) {
      $found=false;
      foreach($newfacts as $newfact) {
         if (trim($newfact[1])==trim($indifacts[$i][1])) {
            $found=true;
            break;
         }
      }
      if (!$found) {
         $indifacts[$i][1].="\nPGV_OLD\n";
      }
   }
   foreach($newfacts as $newfact) {
      $found=false;
      foreach($indifacts as $fact) {
         if (trim($fact[1])==trim($newfact[1])) {
            $found=true;
            break;
         }
      }
      if (!$found) {
         $newfact[1].="\nPGV_NEW\n";
         $indifacts[]=$newfact;
      }
   }
   //-- compare new and old facts of the Notes Sources and Media tab 2
   for($i=0; $i<count($otheritems); $i++) {
      $found=false;
      foreach($newother as $newfact) {
         if (trim($newfact[1])==trim($otheritems[$i][1])) {
            $found=true;
            break;
         }
      }
      if (!$found) {
         $otheritems[$i][1].="\nPGV_OLD\n";
      }
   }
   foreach($newother as $newfact) {
      $found=false;
      foreach($otheritems as $fact) {
         if (trim($fact[1])==trim($newfact[1])) {
            $found=true;
            break;
         }
      }
      if (!$found) {
         $newfact[1].="\nPGV_NEW\n";
         $otheritems[]=$newfact;
      }
   }
}
	if ((count($indifacts)>0)||(count($otheritems)>0)) {
		usort($indifacts, "compare_facts");
		print "\n\t<font class=\"subheaders\">".$pgv_lang["family_group_info"]."</font><br />\n\t<table class=\"facts_table\">";
		foreach ($indifacts as $key => $value) {
			print_fact($value[1], $famid, $value[0]);
		}
		foreach($otheritems as $key=>$value) {
		$ft = preg_match("/1\s(_?.{3,4})\s(.*)/", $value[1], $match);
			if ($ft>0) $fact = $match[1];
			else $fact="";
			$fact = trim($fact);
			// -- handle special source fact case
			if ($fact=="SOUR") {
				print_main_sources($value[1], 1, $famid, $value[0]);
			}
			// -- handle special media object case
			else if ($fact=="OBJE") {
				print_main_media($value[1], 1, $famid, $value[0]);
			}
			// -- handle special note fact case
			else if ($fact=="NOTE") {
				print_main_notes($value[1], 1, $famid, $value[0]);
			}
		}
		print "\n\t</table>";
	}
	//-- new fact link
	if (($view!="preview") &&(userCanEdit(getUserName()))) {
	   print "\n\t<table class=\"facts_table\">";
	   print "<tr><td class=\"facts_label\">".$pgv_lang["add_fact"]."</td>";
	   print "<td class=\"facts_value\">";
	   print "<form method=\"get\" name=\"newfactform\">\n";
	   print "<select id=\"newfact\" name=\"newfact\">\n";
	   foreach($addfacts as $fact) {
	      print "<option value=\"$fact\">".$factarray[$fact]."</option>\n";
	   }
	   print "<option value=\"EVEN\">".$pgv_lang["custom_event"]."</option>\n";
	   print "</select>";
	   print "<input type=\"button\" value=\"".$pgv_lang["add"]."\" onclick=\"add_record('$famid', 'newfact');\">\n";
	   print "</form>\n";
	   print "</td></tr>\n";
	   print "<tr><td class=\"facts_label\">".$pgv_lang["add_fact"]."</td>";
	   print "<td class=\"facts_value\">";
	   print "<form method=\"get\" name=\"newnsoform\">\n";
	   print "<select id=\"newnso\" name=\"newnso\">\n";
	   print "<option value=\"NOTE\">".$factarray["NOTE"]."</option>\n";
	   print "<option value=\"OBJE\">".$factarray["OBJE"]."</option>\n";
	   print "<option value=\"SOUR\">".$factarray["SOUR"]."</option>\n";
	   print "</select>";
	   print "<input type=\"button\" value=\"".$pgv_lang["add"]."\" onclick=\"add_record('$famid', 'newnso');\">\n";
	   print "</form>\n";
	   print "</td></tr>\n";
	   print "\n\t</table>\n";
	}
}
print "</td></tr></table>\n";

print "<br />";
print_footer();

?>
