<?php
/*=================================================
	Project: phpGedView
	File: famlist.php
	Author: John Finlay
	Comments:
		Parses gedcom file and displays a list of the families in the file.

	Change Log:
		8/21/03 - File Created

	phpGedView: Genealogy Viewer
    Copyright (C) 2002 to 2003  John Finlay and Others

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

2004-01-16 Added lines for popup Help (Jans)
===================================================*/
# $Id: famlist.php,v 1.42.2.3 2004/02/03 22:13:22 yalnifj Exp $

require("config.php");
print_header("Family List");
print_help_link("families_help", "page_help");
print "<div class=\"center\">";
print "\n\t<h2>".$pgv_lang["family_list"]."</h2>";
if (empty($surname_sublist)) $surname_sublist = "yes";
if (empty($show_all)) $show_all = "no";

$tfamlist = array();

$famalpha = get_fam_alpha();
foreach($famalpha as $letter=>$list) {
		if (empty($alpha)) $alpha = $letter;
		print "<a href=\"famlist.php?alpha=".$letter."&amp;surname_sublist=$surname_sublist\">$letter</a> | \n";
}
if (isset($alpha)){
	print "<a href=\"famlist.php?show_all=yes&amp;surname_sublist=$surname_sublist\">".$pgv_lang["all"]."</a>\n";
	$tfamlist = get_alpha_fams($alpha);
	uasort($tfamlist, "itemsort");
	print_help_link("alpha_help", "qm");
}

print "<br /><br /><table class=\"list_table, $TEXT_DIRECTION\"><tr>";
if (($surname_sublist=="yes")&&($show_all=="yes")) {
	$tfamlist = get_fam_list();
	uasort($tfamlist, "itemsort");
	if (!isset($alpha)) $alpha="";
	print "<td class=\"list_label\" colspan=\"2\">".$pgv_lang["surnames"]."</td></tr><tr>\n";
	print "<td class=\"list_value\">\n";
	// Start printing names
	$surnames = array();
	foreach($tfamlist as $gid=>$fam) {
		// Added space to regexp after z to also remove prefixes
		$name = preg_replace(array("/ [jJsS]r\.?,/", "/ I+,/", "/^[a-z. ]*/"), array("","",""), $fam["name"]);
		$name = trim($name);
		$names = preg_split("/[,+]/", $name);
		// Match names with chosen first letter
			$surname = $names[0];
		$surname = strtoupper(trim($surname));
		if (!isset($surnames[$surname])) {
			// Put first letter in array to make link work
			$letter = substr($names[0], 0, 1);
			if ($CHARACTER_SET=="UTF-8") {
				$ord = ord($letter);
				if ($ord==195 || $ord ==196 || $ord==215){
					$letter = substr($names[0], 0, 2);
				}
			}
			$surnames[$surname] = array();
			$surnames[$surname]["alpha"] = $letter;
					// Convert names again to include prefixes for displaying
					$name = preg_replace(array("/ [jJsS]r\.?,/", "/ I+,/"), array("",""), $fam["name"]);
					$names = preg_split("/[,+]/", $name);
			$surnames[$surname]["name"] = $names[0];
			$surnames[$surname]["match"] = 1;
		}
		else {
			$surnames[$surname]["match"]++;
		}
	}
	$i = 0;
	ksort($surnames);
	$count = count($surnames);
	foreach($surnames as $surname=>$namecount) {
		if (ord(substr($namecount["name"], 0, 2)) == 215){
			print "<div class =\"rtl\"><a href=\"famlist.php?alpha=".$namecount["alpha"]."&amp;surname_sublist=$surname_sublist&amp;surname=".stripslashes($namecount["name"])."\">".stripslashes($namecount["name"])." - &rlm;[".($namecount["match"])."]&rlm;";
		}
		else print "<div class =\"ltr\"><a href=\"famlist.php?alpha=".$namecount["alpha"]."&amp;surname_sublist=$surname_sublist&amp;surname=".stripslashes($namecount["name"])."\">".stripslashes($namecount["name"])." - &lrm;[".($namecount["match"])."]&lrm;";
		print "</a></div>\n";
		$i++;
		if ($i==floor($count/2)) print "</td><td class=\"list_value\">\n";
	}
	print "</td>\n";
}
else if (($surname_sublist=="yes")&&(empty($surname))&&($show_all=="no")) {
	if (!isset($alpha)) $alpha="";
	print "<td class=\"list_label\" colspan=\"2\">".$pgv_lang["surnames"]."</td></tr><tr>\n";
	print "<td class=\"list_value\">\n";
	$surnames = array();
	foreach($tfamlist as $gid=>$fam) {
		// Added space to regexp after z to also remove prefixes
		$name = preg_replace(array("/ [jJsS]r\.?,/", "/ I+,/", "/^[a-z. ]*/"), array("","",""), $fam["name"]);
		$name = trim($name);
		$names = preg_split("/[,+]/", $name);
		// Match names with chosen first letter
		if (substr($names[0],0,2) == $alpha || substr($names[0],0,1) == $alpha) {
			$surname = $names[0];
			$surname = strtoupper(trim($surname));
			if (!isset($surnames[$surname])) {
				$name = preg_replace(array("/ [jJsS]r\.?,/", "/ I+,/"), array(",",""), $fam["name"]);
				$names = preg_split("/[,+]/", $name);
				$surnames[$surname] = array();
				$surnames[$surname]["name"] = $names[0];
				$surnames[$surname]["match"] = 1;
			}
			else {
				$surnames[$surname]["match"]++;
			}
		}
	}
	$i = 0;
	ksort($surnames);
	$count = count($surnames);
	foreach($surnames as $surname=>$namecount) {
		if (ord(substr($namecount["name"], 0, 2)) == 215){
			print "<div class =\"rtl\"><a href=\"famlist.php?alpha=".$alpha."&amp;surname_sublist=$surname_sublist&amp;surname=".stripslashes($namecount["name"])."\">".stripslashes($namecount["name"])." - &rlm;[".($namecount["match"])."]&rlm;";
		}
		else print "<div class =\"ltr\"><a href=\"famlist.php?alpha=".$alpha."&amp;surname_sublist=$surname_sublist&amp;surname=".stripslashes($namecount["name"])."\">".stripslashes($namecount["name"])." - &lrm;[".($namecount["match"])."]&lrm;";
		print "</a></div>\n";
		$i++;
		if ($i==floor($count/2)) print "</td><td class=\"list_value\">\n";
	}
	print "</td>\n";
}
else {
	//-- if the surname is set then only get the names in that surname list
	if ((!empty($surname))&&($surname_sublist=="yes")) {
		$newfamlist = array();
		foreach($tfamlist as $gid=>$fam) {
			$name = preg_replace(array("/ [jJsS]r\.?,/", "/ I+,/"), array("",""), $fam["name"]);
			$name = trim($name);
			$names = preg_split("/[,+]/", $name);
			$sname = $names[0];
			if (trim(strtoupper($sname))==trim(strtoupper($surname))) $newfamlist[$gid] = $fam;
		}
		$tfamlist = $newfamlist;
	}
	if (($surname_sublist=="no")&&($show_all=="yes")) {
		$tfamlist = get_fam_list();
		uasort($tfamlist, "itemsort");
	}
	$ct = count($tfamlist);
	$i=0;
	print "<td class=\"list_value\"><ul>\n";
	foreach($tfamlist as $gid=>$fam) {
		$showLiving = true;
		$display = true;
		if ($HIDE_LIVE_PEOPLE){
			$parents = find_parents($gid);
			if (!empty($parents["HUSB"])) $display = displayDetailsByID($parents["HUSB"]);
			if ($display) {
				if (!empty($parents["WIFE"])) $display = displayDetailsByID($parents["WIFE"]);
				if (!$display) $showLiving=showLivingNameByID($parents["WIFE"]);
			}
			else {
				$showLiving=showLivingNameByID($parents["HUSB"]);
			}
		}
	    if ($showLiving) {
		    $name = preg_replace(array("/ [jJsS]r\.?,/", "/ I+,/", "/^[a-z. ]*/"), array("","",""), $fam["name"]);
			$name = trim($name);
			$names = preg_split("/,/", $name);
    		if ($show_all=="no") {
				if (substr($names[0],0,2) == $alpha || substr($names[0],0,1) == $alpha) {
					$surname = $names[0];
					if (!empty($names[1])) $firstname = $names[1];
					else $firstname = "";
					$name = preg_replace(array("/ [jJsS]r\.?,/", "/ I+,/","/^[a-z. ]*/"), array("","",""), $fam["name"]);
			$name = trim($name);
			$names = preg_split("/[,+]/", $name);
			$surname = $names[0];
			if (empty($surname)) $surname = $gid;
			$surnames[$surname.$gid]["name"] = $names[0];
			$surnames[$surname.$gid]["famname"] = $fam["name"];
			$surnames[$surname.$gid]["gid"] = $gid;
			$surnames[$surname.$gid]["file"] = $fam["file"];
		}
	}
			else {
				$surname = $names[0];
				if (!empty($names[1])) $firstname = $names[1];
				else $firstname = "";
				$name = preg_replace(array("/ [jJsS]r\.?,/", "/ I+,/"), array("",""), $fam["name"]);
				$names = preg_split("/,/", $name);
				if (empty($surname)) $surname = $gid;
				$surnames[$surname.$firstname.$gid]["name"] = $names[0];
				$surnames[$surname.$firstname.$gid]["famname"] = $fam["name"];
				$surnames[$surname.$firstname.$gid]["gid"] = $gid;
				$surnames[$surname.$firstname.$gid]["file"] = $fam["file"];
			}
		}
	}
	if (!empty($surnames)) {
	ksort($surnames);
	$count = count($surnames);
	foreach($surnames as $k => $surname) {
		print "<li>";
		print_list_family($surname["gid"], array($surname["famname"], $surname["file"]));
		print "</li>\n";
		$i++;
		if ($i==floor($count/2)) print "</ul></td><td class=\"list_value\"><ul>\n";
	}
	print "</ul></td>\n";
	}
}
print "</tr></table>";
print_help_link("name_list_help", "qm");
if ($show_all=="yes"){
	if ($surname_sublist=="yes") print "<br /><a href=\"famlist.php?show_all=yes&amp;surname_sublist=no\">".$pgv_lang["skip_surnames"]."</a>";
 	else print "<br /><a href=\"famlist.php?show_all=yes&amp;surname_sublist=yes\">".$pgv_lang["show_surnames"]."</a>";
}
else if ((!isset($alpha)) || ($alpha=="")) {
	if ($surname_sublist=="yes") print "<br /><a href=\"famlist.php?show_all=yes&amp;surname_sublist=no\">".$pgv_lang["skip_surnames"]."</a>";
	else print "<br /><a href=\"famlist.php?show_all=yes&amp;surname_sublist=yes\">".$pgv_lang["show_surnames"]."</a>";
}
else {
	if ($surname_sublist=="yes") print "<br /><a href=\"famlist.php?alpha=$alpha&amp;surname_sublist=no\">".$pgv_lang["skip_surnames"]."</a>";
	else print "<br /><a href=\"famlist.php?alpha=$alpha&amp;surname_sublist=yes\">".$pgv_lang["show_surnames"]."</a>";
}
	print_help_link("skip_sublist_help", "qm");
print "<br />\n";
print "</div>\n";
print_footer();

?>
