<?php
/***********************************************************
	File: find_sourceid.php
	Project: phpGedView
	Author: John Finlay
	Posts to: none
	Comments:
		Popup window that will allow a user to search for a source id

	Change Log:
		25/01/04 - File Created using findid.php (Kurt)

	phpGedView: Genealogy Viewer
    Copyright (C) 2002 to 2003  John Finlay and Others

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

***********************************************************/
# $Id: find_sourceid.php,v 1.2.2.1 2004/01/27 18:32:39 yalnifj Exp $
require("config.php");
if (!isset($action)) $action="";
if (!isset($name_filter)) $name_filter="";

print_simple_header($pgv_lang["find_sourceid"]);
?>
<script language="JavaScript">
	function paste_id(id) {
		window.opener.paste_id(id);
		window.close();
	}
</script>
<center>
<font class="subheaders"><?php print $pgv_lang["find_sourceid"]; ?></font>
<form name="filter" method="post">
<input type="hidden" name="action" value="filter">
<?php print $pgv_lang["name_contains"]; ?> <input type="text" name="name_filter" value="<?php print $name_filter;?>">
<input type="submit" value="<?php print $pgv_lang["filter"];?>"><br />
</form>
<?php
if ($action=="filter") {
	# $indilist = get_indi_list();
	$indilist = get_source_list();
	$sindilist = array();
	if (!isset($name_filter)) $name_filter="";
	$names = preg_split("/[\s,]+/", $name_filter);
	$namerev = implode(" ", array_reverse($names));
	$num_names = count($names);
	// -- only get the names who match soundex
	foreach ($indilist as $key => $value) {
		if ($num_names>0) {
			$matches = 0;
			foreach($names as $name) $matches += preg_match("/$name/i", $value["name"]);
			if ($matches > floor($num_names/2)) $sindilist[$key]=$value;
		}
		else $sindilist[$key]=$value;
	}
	if (count($sindilist)==0) {
		print "<b>".$pgv_lang["no_results"]."</b><br />";
		// -- only get the names who match soundex
		foreach ($indilist as $key => $value) {
			if ((soundex($value["name"])==soundex($name_filter))||(soundex($value["name"])==soundex($namerev))) $sindilist[$key]=$value;
		}
		if (count($sindilist)!=0) print $pgv_lang["soundex_results"]."<br />";
	}
	print "\n\t<table class=\"list_table\">\n\t\t<tr>\n\t\t<td class=\"list_value\">";
	uasort($sindilist, "itemsort");
	reset($sindilist);
	foreach($sindilist as $key=>$value) {
		# $indirec = find_person_record($key);
		$indirec = find_source_record($key);
		$disp = displayDetails($indirec);
		if ($disp || showLivingName($indirec))
		{
		    print "\n\t\t\t<a href=\"#\" onclick=\"paste_id('$key');\"><font class=\"list_item\">". $key . "-".$value["name"];
			if (!$disp) {
				print "--<i>".$pgv_lang["private"]."</i>";
			}
			else {
				print "--<i>".$pgv_lang["birth"]." ";
				$bpos1 = strpos($indirec, "1 BIRT");
				if ($bpos1) {
					$birthrec = substr($indirec, $bpos1+1);
					$bt = preg_match("/1 [A-Z]{4}/", $birthrec, $match);
					if ($bt>0) {
						$bpos2 = strpos($birthrec, $match[0]);
						if ($bpos2) $birthrec = substr($birthrec, 0, $bpos2);
					}
					$dct = preg_match("/2 DATE (.*)/", $birthrec, $match);
					if ($dct>0) print get_changed_date($match[1]);
					$pct = preg_match("/2 PLAC (.*)/", $birthrec, $match);
					if ($pct>0) print " - ".$match[1];
				}
				print "</i>";
			}
		    print "</font></a><br />\n";
	    }
	}
	print "</td></tr></table>";
}
print "</center>";
?>
<script language="JavaScript">
document.filter.name_filter.focus();
</script>
<?php
print_simple_footer();
?>
