<?php
/*=================================================
	Project: phpGedView
	File: functions.php
	Author:
		John Finlay
		Joe Witthuhn		jaw959@users.sourceforge.net
		Kurt Norgaz		kurtnorgaz@users.sourceforge.net
	Comments:
		Various functions used by all scripts and included by the config.php
		file.

	Change Log:
		8/09/03 - File Created from mysql version functions.php

    phpGedView: Genealogy Viewer
    Copyright (C) 2002 to 2003  John Finlay and Others

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

===================================================*/
# $Id: functions_mysql.php,v 1.62.2.6 2004/02/04 20:16:17 botak Exp $
if (strstr($_SERVER["PHP_SELF"],"functions")) {
	print "Now, why would you want to do that.  You're not hacking are you?";
	exit;
}

//============================== dbquery
//-- perform the given SQL query on the database
//-- print out any errors
function dbquery($sql) {
	global $DBSEL, $DBCONN, $TOTAL_QUERIES;
	//-- make sure a database connection has been established
	if (!$DBSEL || !$DBCONN) {
		return false;
	}

	$res = mysql_query($sql);
	if (!$res) {
		print "<font color=\"red\"><b>ERROR:".mysql_error()." <br />SQL:</b>$sql</font><br /><br />\n";
	}
	$TOTAL_QUERIES++;
	return $res;
}

//============================== db_prep
//-- add slashes and convert special
//-- so that it can be added to db
function db_prep($item) {
	if (is_array($item)) {
		foreach($item as $key=>$value) {
			$item[$key]=db_prep($value);
		}
		return $item;
	}
	else {
		return addslashes($item);
		//-- use the following commented line to convert between character sets
		//return addslashes(iconv("iso-8859-1", "UTF-8", $item));
	}
}

//============================== db_cleanup
//-- clean the slashes and convert special
//-- html characters to their entities for
//-- display and entry into form elements
function db_cleanup($item) {
//	return $item;
	if (is_array($item)) {
		foreach($item as $key=>$value) {
			if ($key!="gedcom") $item[$key]=stripslashes($value);
			else $key=$value;
		}
		return $item;
	}
	else {
		return stripslashes($item);
	}
}

function check_db() {
	global $DBHOST, $DBUSER, $DBPASS, $DBNAME, $DBCONN, $DBSEL, $TOTAL_QUERIES, $PHP_SELF;

	//-- initialize query counter
	$TOTAL_QUERIES = 0;

	//-- connect to the database
	$DBCONN = @mysql_connect($DBHOST, $DBUSER, $DBPASS);
	$DBSEL = @mysql_select_db($DBNAME);
	//print "Here dbconn:$DBCONN dbsel:$DBSEL";
	if (!$DBSEL || !$DBCONN) {
		return false;
	}
	if (preg_match("/editconfig\.php/", $PHP_SELF)==0) {
		$DBUSER = "";
		$DBPASS = "";
	}
	return true;
}

function check_for_import($ged) {
	global $TBLPREFIX, $BUILDING_INDEX;
	
	if (isset($BUILDING_INDEX)) return true;
	$sql = "SELECT i_id FROM ".$TBLPREFIX."individuals WHERE i_file='".$ged."' LIMIT 0,1";
	$res = @mysql_query($sql);
	if (($res)&&(mysql_num_rows($res)>0)) return true;
	return false;
}

function print_execution_stats() {
	global $start_time, $pgv_lang, $TOTAL_QUERIES;

	$end_time = getmicrotime();
	$exectime = $end_time - $start_time;
	print "<br /><br />".$pgv_lang["exec_time"];
	printf(" %.3f sec.", $exectime);
	print "  ".$pgv_lang["total_queries"]." $TOTAL_QUERIES.<br />";
}

// -- check if a person is dead by id
function is_dead_id($pid) {
	global $HIDE_LIVE_PEOPLE;
	global $BUILDING_INDEX;
	global $TBLPREFIX, $GEDCOM, $indilist;

	if ($HIDE_LIVE_PEOPLE){
		//-- if using indexes then first check the indi_isdead array
		if ((!$BUILDING_INDEX)&&(!empty($pid))) {
			if (isset($indilist[$pid]["isdead"])) return $indilist[$pid]["isdead"];
			$sql = "SELECT i_gedcom, i_name, i_isdead, i_file FROM ".$TBLPREFIX."individuals WHERE i_id='$pid' AND i_file='$GEDCOM'";
			$res = dbquery($sql);
			$row = mysql_fetch_row($res);
			$indilist[$pid]["gedcom"] = $row[0];
			$indilist[$pid]["name"] = stripslashes($row[1]);
			$indilist[$pid]["isdead"] = $row[2];
			$indilist[$pid]["file"] = $row[3];
			return $row[2];
		}
		return is_dead(find_person_record($pid));
	}
	return true;
}

// -- find and return a given family's information
function find_family_record($famid) {
	global $TBLPREFIX;
	global $GEDCOM, $famlist;

	if (isset($famlist[$famid]["gedcom"])) return $famlist[$famid]["gedcom"];

	$sql = "SELECT f_gedcom, f_name, f_file FROM ".$TBLPREFIX."families WHERE f_id='$famid' AND f_file='$GEDCOM'";
	$res = dbquery($sql);
	$row = mysql_fetch_row($res);
	$famlist[$famid]["gedcom"] = $row[0];
	$famlist[$famid]["name"] = stripslashes($row[1]);
	$famlist[$famid]["file"] = $row[2];
	return $row[0];
}

// -- find and return a given individuals information
function find_person_record($pid) {
	global $pgv_lang;
	global $TBLPREFIX;
	global $GEDCOM;
	global $BUILDING_INDEX, $indilist;

	if (isset($indilist[$pid]["gedcom"])) return $indilist[$pid]["gedcom"];

	$sql = "SELECT i_gedcom, i_name, i_isdead, i_file FROM ".$TBLPREFIX."individuals WHERE i_id='$pid' AND i_file='$GEDCOM'";
	$res = dbquery($sql);
	if (mysql_num_rows($res)==0) {
		//print $pgv_lang["unable_to_find_indi"]." $pid";
		return false;
	}
	$row = mysql_fetch_row($res);
	$indilist[$pid]["gedcom"] = $row[0];
	$indilist[$pid]["name"] = stripslashes($row[1]);
	$indilist[$pid]["isdead"] = $row[2];
	$indilist[$pid]["file"] = $row[3];
	return $row[0];
}

// -- find and return a given ids record
function find_gedcom_record($pid) {
	global $pgv_lang;
	global $TBLPREFIX;
	global $GEDCOM, $indilist, $famlist, $sourcelist, $otherlist;

	if (isset($indilist[$pid]["gedcom"])) return $indilist[$pid]["gedcom"];
	if (isset($famlist[$pid]["gedcom"])) return $famlist[$pid]["gedcom"];
	if (isset($sourcelist[$pid]["gedcom"])) return $sourcelist[$pid]["gedcom"];
	if (isset($otherlist[$pid]["gedcom"])) return $otherlist[$pid]["gedcom"];

	$sql = "SELECT o_gedcom FROM ".$TBLPREFIX."other WHERE o_id='$pid' AND o_file='$GEDCOM'";
	$res = dbquery($sql);
	if (mysql_num_rows($res)!=0) {
		$row = mysql_fetch_row($res);
		$otherlist[$pid]["gedcom"] = $row[0];
		return $row[0];
	}
	$sql = "SELECT s_gedcom, s_name, s_file FROM ".$TBLPREFIX."sources WHERE s_id='$pid' AND s_file='$GEDCOM'";
	$res = dbquery($sql);
	if (mysql_num_rows($res)!=0) {
		$row = mysql_fetch_row($res);
		$sourcelist[$pid]["name"] = stripslashes($row[1]);
		$sourcelist[$pid]["gedcom"] = $row[0];
		$sourcelist[$pid]["file"] = $row[2];
		return $row[0];
	}
	$sql = "SELECT i_gedcom, i_name, i_isdead, i_file FROM ".$TBLPREFIX."individuals WHERE i_id='$pid' AND i_file='$GEDCOM'";
	$res = dbquery($sql);
	if (mysql_num_rows($res)!=0) {
		$row = mysql_fetch_row($res);
		$indilist[$pid]["gedcom"] = $row[0];
		$indilist[$pid]["name"] = stripslashes($row[1]);
		$indilist[$pid]["isdead"] = $row[2];
		$indilist[$pid]["file"] = $row[3];
		return$row[0];
	}
	$sql = "SELECT f_gedcom, f_name, f_file FROM ".$TBLPREFIX."families WHERE f_id='$pid' AND f_file='$GEDCOM'";
	$res = dbquery($sql);
	if (mysql_num_rows($res)!=0) {
		$row = mysql_fetch_row($res);
		$famlist[$pid]["gedcom"] = $row[0];
		$famlist[$pid]["name"] = stripslashes($row[1]);
		$famlist[$pid]["file"] = $row[2];
		return $row[0];
	}
	print $pgv_lang["unable_to_find_record"]." $pid";
	return false;
}

// -- find and return given source information
function find_source_record($sid) {
	global $fcontents;
	global $pgv_lang;
	global $TBLPREFIX;
	global $GEDCOM, $sourcelist;

	if ($sid=="") return false;
	if (isset($sourcelist[$sid]["gedcom"])) return $sourcelist[$sid]["gedcom"];

	$sql = "SELECT s_gedcom, s_name, s_file FROM ".$TBLPREFIX."sources WHERE s_id='$sid' AND s_file='$GEDCOM'";
	$res = dbquery($sql);
	if (mysql_num_rows($res)!=0) {
		$row = mysql_fetch_row($res);
		$sourcelist[$sid]["name"] = stripslashes($row[1]);
		$sourcelist[$sid]["gedcom"] = $row[0];
		$sourcelist[$sid]["file"] = $row[2];
		return $row[0];
	}
	else {
		print $pgv_lang["unable_to_find_source"]." $sid";
		return false;
	}
}

//-- find and return the id of the first person in the gedcom
function find_first_person() {
	global $GEDCOM, $TBLPREFIX;
	$sql = "SELECT i_id FROM ".$TBLPREFIX."individuals WHERE i_file='$GEDCOM' LIMIT 0,1";
	$res = dbquery($sql);
	$row = mysql_fetch_row($res);
	return $row[0];
}

if (!isset($BUILDING_INDEX)) {
	function get_sortable_name($pid) {
		global $TBLPREFIX;
		global $GEDCOM, $indilist;

		if (empty($pid)) return false;

		if (isset($indilist[$pid]["name"])) return $indilist[$pid]["name"];

		$sql = "SELECT i_gedcom, i_name, i_isdead, i_file FROM ".$TBLPREFIX."individuals WHERE i_id='$pid' AND i_file='$GEDCOM'";
		$res = dbquery($sql);
		if (mysql_num_rows($res)==0) {
			return false;
		}
		$row = mysql_fetch_row($res);
		$indilist[$pid]["gedcom"] = $row[0];
		$indilist[$pid]["name"] = stripslashes($row[1]);
		$indilist[$pid]["isdead"] = $row[2];
		$indilist[$pid]["file"] = $row[3];
		return stripslashes($row[1]);
	}

	function get_family_descriptor($fid) {
		global $pgv_lang;
		$parents = find_parents($fid);
		return get_sortable_name($parents["HUSB"])." + ".get_sortable_name($parents["WIFE"]);
	}

	function get_source_descriptor($sid) {
		global $TBLPREFIX;
		global $GEDCOM, $sourcelist;
		if ($sid=="") return false;
		if (isset($sourcelist[$sid]["name"])) return $sourcelist[$sid]["name"];
		$sql = "SELECT s_name, s_gedcom, s_file FROM ".$TBLPREFIX."sources WHERE s_id='$sid' AND s_file='$GEDCOM'";
		$res = dbquery($sql);
		$row = mysql_fetch_row($res);
		$sourcelist[$sid]["name"] = stripslashes($row[0]);
		$sourcelist[$sid]["gedcom"] = $row[1];
		$sourcelist[$sid]["file"] = $row[2];
		return stripslashes($row[0]);
	}
}
else {
	function get_sortable_name($pid) {
		global $fcontents;
		global $pgv_lang;

		if ($pid=="") return false;
		$pos1 = strpos($fcontents, "0 @$pid@ INDI");
		if (!$pos1) {
			print "Unable to find individual with id $pid";
			return false;
		}
		$pos2 = strpos($fcontents, "0 @", $pos1+1);
		$indirec = substr($fcontents, $pos1, $pos2-$pos1);
		$ct = preg_match("/2 SURN (.*)/", $indirec, $match);
		if ($ct>0) {
			$gt = preg_match("/2 GIVN (.*)/", $indirec, $gmatch);
			$st = preg_match("/2 NSFX (.*)/", $indirec, $smatch);
			$name = rtrim($match[1]);
			if ($st>0) $name.=" ".rtrim($smatch[1]);
			if ($gt>0) $name.=", ".rtrim($gmatch[1]);
		}
		else {
			$nt = preg_match("/1 NAME (.*)/", $indirec, $match);
			if ($nt>0) {
				$names = preg_split("/\//", $match[1]);
				if (count($names)>1) {
					$name = trim($names[1]).",";
					$name .= " ".trim($names[0]);
					if (count($names)>2) $name .= " ".trim($names[2]);
				}
				else $name=$match[1];

			}
			else $name = "Individual $gid";
		}
		$name = preg_replace("'\/'", "", $name);
		$name = preg_replace('/"/', '\"', $name);
		return $name;
	}

	function get_family_descriptor($fid) {
		global $pgv_lang;
		$parents = find_parents($fid);
		return get_sortable_name($parents["HUSB"])." + ".get_sortable_name($parents["WIFE"]);
	}

	function get_source_descriptor($sid) {
		global $pgv_lang;
		$source = find_source_record($sid);
		if ($source) {
			$ct = preg_match("/1 ABBR (.*)/", $source, $match);
			if ($ct > 0) return $match[1];
			else {
				$ct = preg_match("/1 TITL (.*)/", $source, $match);
				if ($ct > 0) {
					$title = $match[1];
					$ct = preg_match_all("/2 CON[C|T] (.*)/", $factrec, $match, PREG_SET_ORDER);
					for($i=0; $i<$ct; $i++) {
						$title .= $match[$i][1];
					}
					return $title;
				}
			}
		}
		return $sid;
	}
}

//=================== IMPORT FUNCTIONS
//-- function to import a record into the database
function import_record($indirec) {
	global $gid, $type,$indilist,$famlist,$sourcelist,$otherlist;
	global $TBLPREFIX, $GEDCOM_FILE, $FILE, $pgv_lang, $USE_RIN, $CREATE_GENDEX, $gdfp, $placecache;

	if (!isset($placecache)) $placecache = array();
	//-- import all place locations
	$pt = preg_match_all("/\d PLAC (.*)/", $indirec, $match, PREG_SET_ORDER);
	for($i=0; $i<$pt; $i++) {
		$place = trim($match[$i][1]);
		$places = preg_split("/,/", $place);
		$secalp = array_reverse($places);
		$parent_id = 0;
		$level = 0;
		foreach($secalp as $place) {
			$place = trim($place);
			$place=preg_replace("/[\.\"\><]/", "", $place);
			if (empty($parent_id)) $parent_id=0;
			$key = strtolower($place."_".$level."_".$parent_id);
			if (isset($placecache[$key])) {
				$parent_id = $placecache[$key];
			}
			else {
				$sql = "INSERT INTO ".$TBLPREFIX."places VALUES(NULL, '".addslashes($place)."', $level, '$parent_id', '".addslashes($FILE)."')";
				$res = dbquery($sql);
				if ($res) $parent_id = mysql_insert_id();
				$placecache[$key] = $parent_id;
			}
			$level++;
		}
	}
	$indirec = addslashes($indirec);
	//-- import different types of records
	$ct = preg_match("/0 @(.*)@ (.*)/", $indirec, $match);
	if ($ct > 0) {
		$gid = $match[1];
		$type = trim($match[2]);
	}
	else {
		$ct = preg_match("/0 (.*)/", $indirec, $match);
		$gid = trim($match[1]);
		$type = trim($match[1]);
	}
	if ($type == "INDI") {
		$nametag="";
		$surname="";
		$nt = preg_match("/1 NAME (.*)/", $indirec, $ntmatch);
		if ($nt>0) {
			$nametag = trim($ntmatch[1]);
		}
		$ct = preg_match("/2 SURN (.*)/", $indirec, $match);
		if ($ct>0) {
			$gt = preg_match("/2 GIVN (.*)/", $indirec, $gmatch);
			$st = preg_match("/2 NSFX (.*)/", $indirec, $smatch);
			$name = rtrim($match[1]);
			$surname = trim($name);
			if (empty($name)) $name = "(".$pgv_lang["unknown"].")";
			if ($st>0) $name.=" ".rtrim($smatch[1]);
			if ($gt>0) $name.=", ".rtrim($gmatch[1]);
		}
		else {
			if ($nt>0) {
				$names = preg_split("/\//", $ntmatch[1]);
				if (count($names)>1) $name = trim($names[1]);
			}
			if (empty($name)) $name = "(".$pgv_lang["unknown"].")";
			$surname = $name;
			$st = preg_match("/2 NSFX (.*)/", $indirec, $smatch);
			if ($st>0) $name.=" ".rtrim($smatch[1]);
			if ($nt>0) {
				$name .= ", ".trim($names[0]);
				if (count($names)>2) $name .= " ".trim($names[2]);
			}
		}
		$name = preg_replace("'\/'", "", $name);
		$ct = preg_match_all("/1 FAMS @(.*)@/", $indirec, $match, PREG_SET_ORDER);
		$sfams = "";
		for($j=0; $j<$ct; $j++) {
			$sfams .= $match[$j][1].";";
		}
		$ct = preg_match_all("/1 FAMC @(.*)@/", $indirec, $match, PREG_SET_ORDER);
		$cfams = "";
		for($j=0; $j<$ct; $j++) {
			$cfams .= $match[$j][1].";";
		}
		$isdead = 0;
		$indi = array();
		$indi["name"] = addslashes($name);
		$indi["isdead"] = $isdead;
		$indi["gedcom"] = $indirec;
		$indi["file"] = $FILE;
		if ($USE_RIN) {
			$ct = preg_match("/1 RIN (.*)/", $indirec, $match);
			if ($ct>0) $rin = trim($match[1]);
			else $rin = $gid;
			$indi["rin"] = $rin;
		}
		else $indi["rin"] = $gid;
		$indilist["$gid"] = $indi;
		// -- the next section is to generate a gedex file
		if ($CREATE_GENDEX) {
			$birthdate = "";
			$birthplace = "";
			$deathdate = "";
			$deathplace = "";
			$bpos1 = strpos($indirec, "1 BIRT");
			if ($bpos1) {
				$birthrec = get_sub_record(1, "1 BIRT", $indirec);
				if ($birthrec!==false) {
					$dct = preg_match("/2 DATE (.*)/", $birthrec, $match);
					if ($dct>0) $birthdate = trim($match[1]);
					$pct = preg_match("/2 PLAC (.*)/", $birthrec, $match);
					if ($pct>0) $birthplace = trim($match[1]);
				}
			}
			//-- no birth check for christening or baptism
			else {
				$bpos1 = strpos($indirec, "1 CHR");
				if ($bpos1) {
					$birthrec = get_sub_record(1, "1 CHR", $indirec);
					if ($birthrec!==false) {
						$dct = preg_match("/2 DATE (.*)/", $birthrec, $match);
						if ($dct>0) $birthdate = trim($match[1]);
						$pct = preg_match("/2 PLAC (.*)/", $birthrec, $match);
						if ($pct>0) $birthplace = trim($match[1]);
					}
				}
			}
			$bpos1 = strpos($indirec, "1 DEAT");
			if ($bpos1) {
				$birthrec = get_sub_record(1, "1 DEAT", $indirec);
				if ($birthrec!==false) {
					$dct = preg_match("/2 DATE (.*)/", $birthrec, $match);
					if ($dct>0) $deathdate = trim($match[1]);
					$pct = preg_match("/2 PLAC (.*)/", $birthrec, $match);
					if ($pct>0) $deathplace = trim($match[1]);
				}
			}
			//-- no birth check for christening or baptism
			else {
				$bpos1 = strpos($indirec, "1 BURI");
				if ($bpos1) {
					$birthrec = get_sub_record(1, "1 BURI", $indirec);
					if ($birthrec!==false) {
						$dct = preg_match("/2 DATE (.*)/", $birthrec, $match);
						if ($dct>0) $deathdate = trim($match[1]);
						$pct = preg_match("/2 PLAC (.*)/", $birthrec, $match);
						if ($pct>0) $deathplace = trim($match[1]);
					}
				}
			}
			fwrite($gdfp, utf8_decode("individual.php?pid=$gid|$surname|$nametag|$birthdate|$birthplace|$deathdate|$deathplace|\r\n"));
		}
	}
	else if ($type == "FAM") {
		$parents = array();
		$ct = preg_match("/1 HUSB @(.*)@/", $indirec, $match);
		if ($ct>0) $parents["HUSB"]=$match[1];
		else $parents["HUSB"]=false;
		$ct = preg_match("/1 WIFE @(.*)@/", $indirec, $match);
		if ($ct>0) $parents["WIFE"]=$match[1];
		else $parents["WIFE"]=false;
		$ct = preg_match_all("/\d CHIL @(.*)@/", $indirec, $match, PREG_SET_ORDER);
		$chil = "";
		for($j=0; $j<$ct; $j++) {
			$chil .= $match[$j][1].";";
		}
		$fam = array();
		$fam["HUSB"] = $parents["HUSB"];
		$fam["WIFE"] = $parents["WIFE"];
		$fam["CHIL"] = $chil;
		$fam["gedcom"] = $indirec;
		$fam["file"] = $FILE;
		$famlist[$gid] = $fam;
	}
	else if ($type=="SOUR") {
		$et = preg_match("/1 ABBR (.*)/", $indirec, $smatch);
		if ($et>0) $name = $smatch[1];
		$tt = preg_match("/1 TITL (.*)/", $indirec, $smatch);
		if ($tt>0) $name = $smatch[1];
		if (empty($name)) $name = $gid;
		$sql = "INSERT INTO ".$TBLPREFIX."sources VALUES ('$gid','".addslashes($FILE)."','".addslashes($name)."','".$indirec."')";
		$res = dbquery($sql);
		if (!$res) exit;
		$source = array();
		$source["name"] = addslashes($name);
		$source["gedcom"] = $indirec;
		$source["file"] = $FILE;
		$sourcelist[$gid] = $source;
	}
	else if (preg_match("/_/", $type)==0) {
		$sql = "INSERT INTO ".$TBLPREFIX."other VALUES ('$gid','".addslashes($FILE)."','".addslashes($type)."','".$indirec."')";
		$res = dbquery($sql);
		if (!$res) exit;
		$source = array();
		$source["type"] = addslashes($type);
		$source["gedcom"] = $indirec;
		$source["file"] = $FILE;
		$otherlist[$gid] = $source;
	}
}

function update_isdead($gid, $indi) {
	global $TBLPREFIX, $USE_RIN;
	$isdead = 0;
	$isdead = is_dead($indi["gedcom"]);
	if (empty($isdead)) $isdead = 0;
	$sql = "INSERT INTO ".$TBLPREFIX."individuals VALUES ('$gid','".addslashes($indi["file"])."','".$indi["rin"]."','".$indi["name"]."',$isdead,'".$indi["gedcom"]."')";
	$res = dbquery($sql);
}

function update_family_name($gid, $fam) {
	global $indilist, $pgv_lang, $TBLPREFIX;

	$name = "";
	if (!empty($fam["HUSB"])) $name = $indilist[$fam["HUSB"]]["name"];
	else $name = "(".$pgv_lang["unknown"].")";
	$name .= " + ";
	if (!empty($fam["WIFE"])) $name .= $indilist[$fam["WIFE"]]["name"];
	else $name .= "(".$pgv_lang["unknown"].")";

	$sql = "INSERT INTO ".$TBLPREFIX."families VALUES ('$gid','".addslashes($fam["file"])."','".addslashes($name)."','".$fam["HUSB"]."','".$fam["WIFE"]."','".$fam["CHIL"]."','".$fam["gedcom"]."')";
	$res = dbquery($sql);
	if (!$res) exit;

}

//-- function that checks if the database exists and creates tables
function setup_database() {
	global $TBLPREFIX;

	//---------- Check if tables exist
	$sql = "SHOW TABLES";
	$res = dbquery($sql);
	$tables_exist=false;
	$has_rin = false;
	$has_places = false;
	while($row=mysql_fetch_row($res)) {
		if ($row[0]=="".$TBLPREFIX."individuals") {
			$tables_exist=true;
			$ssql = "DESCRIBE ".$TBLPREFIX."individuals";
			$sres = dbquery($ssql);
			while($frow = mysql_fetch_row($sres)) {
				if ($frow[0]=="i_rin") $has_rin = true;
			}
		}
		if ($row[0]==$TBLPREFIX."places") {
			$has_places = true;
		}
	}

	if (($tables_exist)&&(!$has_rin)) {
		$sql = "DROP table if exists ".$TBLPREFIX."individuals, ".$TBLPREFIX."families, ".$TBLPREFIX."sources, ".$TBLPREFIX."other";
		$res = dbquery($sql);
		$tables_exist = false;
	}

	if (!$tables_exist) {
		$sql = "CREATE TABLE ".$TBLPREFIX."individuals (i_id VARCHAR(30), i_file VARCHAR(255), i_rin VARCHAR(30), i_name VARCHAR(255), i_isdead INT(1) DEFAULT 1, i_gedcom TEXT, KEY index_id (i_id), KEY index_name (i_name), KEY index_rin (i_rin))";
		$res = dbquery($sql);
		if($res) print "Successfully created <i>Individuals</i> table.<br />\n";
		else {
			print "Unable to create <i>Individuals</i> table.<br />\n";
			exit;
		}

		$sql = "CREATE TABLE ".$TBLPREFIX."families (f_id VARCHAR(30), f_file VARCHAR(255), f_name VARCHAR(255), f_husb VARCHAR(30), f_wife VARCHAR(30), f_chil VARCHAR(255), f_gedcom TEXT, KEY index_id (f_id), KEY index_name (f_name))";
		$res = dbquery($sql);
		if($res) print "Successfully created <i>Families</i> table.<br />\n";
		else {
			print "Unable to create <i>Families</i> table.<br />\n";
			exit;
		}
		$sql = "CREATE TABLE ".$TBLPREFIX."sources (s_id VARCHAR(30), s_file VARCHAR(255), s_name VARCHAR(255), s_gedcom TEXT, KEY index_id (s_id), KEY index_name (s_name))";
		$res = dbquery($sql);
		if($res) print "Successfully created <i>Sources</i> table.<br />\n";
		else {
			print "Unable to create <i>Sources</i> table.<br />\n";
			exit;
		}

		$sql = "CREATE TABLE ".$TBLPREFIX."other (o_id VARCHAR(30), o_file VARCHAR(255), o_type VARCHAR(20), o_gedcom TEXT, KEY index_id (o_id), KEY index_type(o_type))";
		$res = dbquery($sql);
		if($res) print "Successfully created <i>Other</i> table.<br />\n";
		else {
			print "Unable to create <i>Other</i> table.<br />\n";
			exit;
		}

		$sql = "CREATE TABLE ".$TBLPREFIX."places (p_id INT NOT NULL auto_increment, p_place VARCHAR(150), p_level INT, p_parent_id INT, p_file VARCHAR(255), KEY index_place(p_place), KEY index_level(p_level), KEY index_parent(p_parent_id),PRIMARY KEY(p_id))";
		$res = dbquery($sql);
		if($res) print "Successfully created <i>Places</i> table.<br />\n";
		else {
			print "Unable to create <i>Places</i> table.<br />\n";
			exit;
		}
	}
	else if (!$has_places) {
		$sql = "CREATE TABLE ".$TBLPREFIX."places (p_id INT NOT NULL auto_increment, p_place VARCHAR(150), p_level INT, p_parent_id INT, p_file VARCHAR(255), KEY index_place(p_place), KEY index_level(p_level), KEY index_parent(p_parent_id),PRIMARY KEY(p_id))";
		$res = dbquery($sql);
		if($res) print "Successfully created <i>Places</i> table.<br />\n";
		else {
			print "Unable to create <i>Places</i> table.<br />\n";
			exit;
		}
	}
}

//-- check if a gedcom already exists
function check_dataset($FILE) {
	global $TBLPREFIX;

	$dataset_exists=false;
	$sql = "SELECT * FROM ".$TBLPREFIX."individuals WHERE i_file='$FILE'";
	$res = dbquery($sql);
	if (mysql_num_rows($res)>0) $dataset_exists=true;
	return $dataset_exists;
}

//-- erase the data for a gedcom file
function empty_database($FILE) {
	global $TBLPREFIX;

	$sql = "DELETE FROM ".$TBLPREFIX."individuals WHERE i_file='$FILE'";
	$res = dbquery($sql);
	$sql = "DELETE FROM ".$TBLPREFIX."families WHERE f_file='$FILE'";
	$res = dbquery($sql);
	$sql = "DELETE FROM ".$TBLPREFIX."sources WHERE s_file='$FILE'";
	$res = dbquery($sql);
	$sql = "DELETE FROM ".$TBLPREFIX."other WHERE o_file='$FILE'";
	$res = dbquery($sql);
	$sql = "DELETE FROM ".$TBLPREFIX."places WHERE p_file='$FILE'";
	$res = dbquery($sql);
}

//-- cleanup the database
function cleanup_database() {
	//-- for mysql we don't need to do anything here
}

//-- get the sourcelist from the datastore
function get_source_list() {
	global $sourcelist, $GEDCOM;
	global $TBLPREFIX;

	$sourcelist = array();

	$sql = "SELECT * FROM ".$TBLPREFIX."sources WHERE s_file='$GEDCOM' ORDER BY s_name";
	$res = dbquery($sql);
	$ct = mysql_num_rows($res);
	while($row=mysql_fetch_array($res)){
		$source = array();
		$source["gedcom"] = $row["s_gedcom"];
		$row = db_cleanup($row);
		$source["name"] = $row["s_name"];
		$source["file"] = $row["s_file"];
		$sourcelist[$row["s_id"]] = $source;
	}

	return $sourcelist;
}

//-- get the indilist from the datastore
function get_indi_list() {
	global $indilist, $GEDCOM;
	global $TBLPREFIX;

	$indilist = array();

	$sql = "SELECT * FROM ".$TBLPREFIX."individuals WHERE i_file='$GEDCOM'";
	$res = dbquery($sql);
	$ct = mysql_num_rows($res);
	while($row=mysql_fetch_array($res)){
		$indi = array();
		$indi["gedcom"] = $row["i_gedcom"];
		$row = db_cleanup($row);
		$indi["name"] = $row["i_name"];
		$indi["isdead"] = $row["i_isdead"];
		$indi["file"] = $row["i_file"];
		$indilist[$row["i_id"]] = $indi;
	}

	return $indilist;
}

//-- get the famlist from the datastore
function get_fam_list() {
	global $famlist, $GEDCOM;
	global $TBLPREFIX;

	$famlist = array();

	$sql = "SELECT * FROM ".$TBLPREFIX."families WHERE f_file='$GEDCOM'";
	$res = dbquery($sql);
	$ct = mysql_num_rows($res);
	while($row=mysql_fetch_array($res)){
		$fam = array();
		$fam["gedcom"] = $row["f_gedcom"];
		$row = db_cleanup($row);
		$fam["name"] = $row["f_name"];
		$fam["HUSB"] = $row["f_husb"];
		$fam["WIFE"] = $row["f_wife"];
		$fam["CHIL"] = $row["f_chil"];
		$fam["file"] = $row["f_file"];
		$famlist[$row["f_id"]] = $fam;
	}
	return $famlist;
}

//-- get the otherlist from the datastore
function get_other_list() {
	global $otherlist, $GEDCOM;
	global $TBLPREFIX;

	$otherlist = array();

	$sql = "SELECT * FROM ".$TBLPREFIX."other WHERE o_file='$GEDCOM'";
	$res = dbquery($sql);
	$ct = mysql_num_rows($res);
	while($row=mysql_fetch_array($res)){
		$source = array();
		$source["gedcom"] = $row["o_gedcom"];
		$row = db_cleanup($row);
		$source["type"] = $row["o_type"];
		$source["file"] = $row["o_file"];
		$otherlist[$row["o_id"]]= $source;
	}

	return $otherlist;
}

//-- search through the gedcom records for individuals
function search_indis($query, $allgeds=false) {
	global $TBLPREFIX, $GEDCOM, $indilist;

	$myindilist = array();
	$sql = "SELECT i_id, i_name, i_file, i_gedcom, i_isdead FROM ".$TBLPREFIX."individuals WHERE i_gedcom REGEXP '$query'";
	if (!$allgeds) $sql .= " AND i_file='$GEDCOM'";
	$res = dbquery($sql);
	while($row=mysql_fetch_row($res)) {
		$row = db_cleanup($row);
		$myindilist[$row[0]]["name"] = stripslashes($row[1]);
		$myindilist[$row[0]]["file"] = $row[2];
		$myindilist[$row[0]]["gedcom"] = $row[3];
		$myindilist[$row[0]]["isdead"] = $row[4];
		$indilist[$row[0]] = $myindilist[$row[0]];
	}
	return $myindilist;
}

//-- search through the gedcom records for families
function search_fams($query, $allgeds=false) {
	global $TBLPREFIX, $GEDCOM, $famlist;

	$myfamlist = array();
	$sql = "SELECT f_id, f_name, f_file, f_gedcom FROM ".$TBLPREFIX."families WHERE f_gedcom REGEXP '$query'";
	if (!$allgeds) $sql .= " AND f_file='$GEDCOM'";
	$res = dbquery($sql);
	while($row=mysql_fetch_row($res)) {
		$row = db_cleanup($row);
		$myfamlist[$row[0]]["name"] = stripslashes($row[1]);
		$myfamlist[$row[0]]["file"] = $row[2];
		$myfamlist[$row[0]]["gedcom"] = $row[3];
		$famlist[$row[0]] = $myfamlist[$row[0]];
	}

	return $myfamlist;
}

//-- search through the gedcom records for sources
function search_sources($query, $allgeds=false) {
	global $TBLPREFIX, $GEDCOM;

	$mysourcelist = array();
	$sql = "SELECT s_id, s_name, s_file FROM ".$TBLPREFIX."sources WHERE s_gedcom REGEXP '$query'";
	if (!$allgeds) $sql .= " AND s_file='$GEDCOM'";
	$res = dbquery($sql);
	while($row=mysql_fetch_row($res)) {
		$row = db_cleanup($row);
		$mysourcelist[$row[0]]["name"] = stripslashes($row[1]);
		$mysourcelist[$row[0]]["file"] = $row[2];
	}

	return $mysourcelist;
}

//-- find all of the places
function get_place_list() {
	global $numfound, $j, $level, $parent, $found;
	global $GEDCOM, $TBLPREFIX, $placelist, $positions;

	// --- find all of the place in the file
	if ($level==0) $sql = "SELECT p_place FROM ".$TBLPREFIX."places WHERE p_level=0 AND p_file='$GEDCOM' ORDER BY p_place";
	else {
		$psql = "SELECT p_id FROM ".$TBLPREFIX."places WHERE p_level=".($level-1)." AND p_place LIKE '".$parent[$level-1]."' AND p_file='$GEDCOM' ORDER BY p_place";
		$res = dbquery($psql);
		$row = mysql_fetch_row($res);
		$parent_id = $row[0];
		$sql = "SELECT p_place FROM ".$TBLPREFIX."places WHERE p_level=$level AND p_parent_id=$parent_id AND p_file='$GEDCOM' ORDER BY p_place";
	}
	$res = dbquery($sql);
	while ($row = mysql_fetch_row($res)) {
		$placelist[] = stripslashes($row[0]);
		$numfound++;
	}
}

//-- get all of the place connections
function get_place_positions($parent, $level) {
	global $positions, $TBLPREFIX, $GEDCOM;

	$parent = array_reverse($parent);
	$sql = "SELECT i_id FROM ".$TBLPREFIX."individuals WHERE i_gedcom LIKE '%";
	foreach($parent as $place) $sql.="$place%";
	$sql .= "' AND i_file='$GEDCOM'";
	$res = dbquery($sql);
	while($row = mysql_fetch_row($res)) {
		$positions[] = $row[0];
	}
	$sql = "SELECT f_id FROM ".$TBLPREFIX."families WHERE f_gedcom LIKE '%";
	foreach($parent as $place) $sql.="$place%";
	$sql .= "' AND f_file='$GEDCOM'";
	$res = dbquery($sql);
	while($row = mysql_fetch_row($res)) {
		$positions[] = $row[0];
	}
	$sql = "SELECT s_id FROM ".$TBLPREFIX."sources WHERE s_gedcom LIKE '%";
	foreach($parent as $place) $sql.="$place%";
	$sql .= "' AND s_file='$GEDCOM'";
	$res = dbquery($sql);
	while($row = mysql_fetch_row($res)) {
		$positions[] = $row[0];
	}
	return $positions;
}

function search_places($sql, $splace) {
	global $placelist;

	$res = dbquery($sql);
	$k=0;
	//print $splace;
	while($row=mysql_fetch_row($res)) {
		$row = db_cleanup($row);
		print " ";
		if ($k%4000 == 0) print "\n";
		// -- put all the places into an array
		if (empty($splace)) $ct = preg_match_all("/\d PLAC (.*)/", $row[1], $match, PREG_SET_ORDER);
		else $ct = preg_match_all("/\d PLAC (.*$splace.*)/i", $row[1], $match, PREG_SET_ORDER);
		for($i=0; $i<$ct; $i++) {
			$place = $match[$i][1];
			$place=trim($place);

			$place=preg_replace("/[\.\"\><]/", "", $place);
			$levels = preg_split ("/,/", $place);		// -- split the place into comma seperated values
			$levels = array_reverse($levels);				// -- reverse the array so that we get the top level first
			$placetext="";
			$j=0;
			foreach($levels as $level) {
				if ($j>0) $placetext .= ", ";
				$placetext .= trim($level);
				$j++;
			}
			$placelist[] = $placetext;
			$k++;
		}//--end for
	}//-- end while
}

//-- find all of the places
function find_place_list($place) {
	global $GEDCOM, $TBLPREFIX, $placelist, $indilist, $famlist, $sourcelist, $otherlist;

	// --- find all of the place in the file
	$sql = "SELECT i_id, i_gedcom FROM ".$TBLPREFIX."individuals WHERE i_gedcom LIKE '% PLAC %' AND i_file='$GEDCOM'";
	search_places($sql, $place);
	$sql = "SELECT f_id, f_gedcom FROM ".$TBLPREFIX."families WHERE f_gedcom LIKE '% PLAC %' AND f_file='$GEDCOM'";
	search_places($sql, $place);
	$sql = "SELECT s_id, s_gedcom FROM ".$TBLPREFIX."sources WHERE s_gedcom LIKE '% PLAC %' AND s_file='$GEDCOM'";
	search_places($sql, $place);
	$sql = "SELECT o_id, o_gedcom FROM ".$TBLPREFIX."other WHERE o_gedcom LIKE '% PLAC %' AND o_file='$GEDCOM'";
	search_places($sql, $place);
	natcasesort($placelist);
	$placelist = array_unique($placelist);
}

function findLinkedRecords($query) {
	global $TBLPREFIX, $GEDCOM;
	$link = array();

	$sql1 = "SELECT i_gedcom, i_id FROM ".$TBLPREFIX."individuals WHERE i_gedcom LIKE '%$query%' AND i_file='$GEDCOM'";
	$sql2 = "SELECT f_gedcom, f_id FROM ".$TBLPREFIX."families WHERE f_gedcom LIKE '%$query%' AND f_file='$GEDCOM'";
	$sql3 = "SELECT s_gedcom, s_id FROM ".$TBLPREFIX."sources WHERE s_gedcom LIKE '%$query%' AND s_file='$GEDCOM'";

	$sql = array($sql1, $sql2, $sql3);
	foreach($sql as $squery) {
		$res = dbquery($squery);
		while($row=mysql_fetch_row($res)) {
			preg_match("/0 @(.*)@ (.*)/", $row[0], $match);
			$gid = $match[1];
			$type = trim($match[2]);
			if ($type=="INDI") {
				if (displayDetailsById($gid)||showLivingNameById($gid)) {
					$link[$gid]=$type;
				}
			}
			else if ($type=="FAM") {
				$parents = find_parents_in_record($row[0]);
				$disp = false;
				if (displayDetailsById($parents["HUSB"])||showLivingNameById($parents["HUSB"])) {
					$disp = true;
				}
				if ($disp) {
					if (displayDetailsById($parents["WIFE"])||showLivingNameById($parents["WIFE"])) {
						$link[$gid]=$type;
					}
				}
			}
			else $link[$gid]=$type;
		}
	}
	return $link;
}

function find_media($sql, $type) {
	global $ct, $medialist, $MEDIA_DIRECTORY, $foundlist, $PGV_IMAGE_DIR, $PGV_GEDCOM_IMG;
	$res = dbquery($sql);
	while($row=mysql_fetch_row($res)) {
		print " ";
		find_media_in_record($row[0]);
	}
}

//-- find all of the media
function get_media_list() {
	global $GEDCOM, $TBLPREFIX, $medialist, $ct;

	$ct=0;
	$sql = "SELECT i_gedcom, i_id FROM ".$TBLPREFIX."individuals WHERE i_gedcom LIKE '% OBJE%' AND i_file='$GEDCOM'";
	find_media($sql, 'INDI');
	$sql = "SELECT f_gedcom, f_id FROM ".$TBLPREFIX."families WHERE f_gedcom LIKE '% OBJE%' AND f_file='$GEDCOM'";
	find_media($sql, 'FAM');
	$sql = "SELECT s_gedcom, s_id FROM ".$TBLPREFIX."sources WHERE s_gedcom LIKE '% OBJE%' AND s_file='$GEDCOM'";
	find_media($sql, 'SOUR');
	$sql = "SELECT o_gedcom, o_id FROM ".$TBLPREFIX."other WHERE o_gedcom LIKE '% OBJE%' AND o_file='$GEDCOM'";
	find_media($sql, 'OTHER');

}

//-- get the first character in the list
function get_indi_alpha() {
	global $CHARACTER_SET, $TBLPREFIX, $GEDCOM;

	$indialpha = array();
	$sql = "SELECT DISTINCT SUBSTRING(i_name, 1) as alpha FROM ".$TBLPREFIX."individuals WHERE i_file='$GEDCOM' ORDER BY alpha";
	$res = dbquery($sql);
	while($row = mysql_fetch_array($res)) {
		$name = preg_replace(array("/ [jJsS]r\.?,/", "/ I+,/", "/^[a-z. ]*/"), array("","",""), $row[0]);
		$name = trim($name);
		$names = preg_split("/,/", $name);
		$letter = substr($names[0], 0, 1);
		if ($CHARACTER_SET=="UTF-8") {
			$ord = ord($letter);
			//196 ordinal required for Turkish
			//215 ordinal required for Hebrew
			if ($ord==195 || $ord ==196 || $ord ==215){
				$letter = substr($row[0], 0, 2);
			}
			else $letter = strtoupper($letter);
		}
		$letter = strtoupper($letter);
		if (!isset($indialpha[$letter])) {
			$indialpha[$letter]=$letter;
		}
	}
	ksort($indialpha);
	return $indialpha;
}

//-- get the first character in the list
function get_fam_alpha() {
	global $CHARACTER_SET, $TBLPREFIX, $GEDCOM;

	$indialpha = array();
	$sql = "SELECT DISTINCT SUBSTRING(f_name, 1, 2) as alpha FROM ".$TBLPREFIX."families WHERE f_file='$GEDCOM' ORDER BY alpha";
	$res = dbquery($sql);
	$oldletter = "";
	while($row = mysql_fetch_array($res)) {
		$letter = substr($row[0], 0, 1);
		if ($CHARACTER_SET=="UTF-8") {
			$ord = ord($letter);
			//196 ordinal required for Turkish
			//215 ordinal required for Hebrew
			if ($ord==195 || $ord ==196 || $ord ==215){
				$letter = substr($row[0], 0, 2);
			}
			else $letter = strtoupper($letter);
		}
		else $letter = strtoupper($letter);
		if (!isset($indialpha[$letter])) {
			$indialpha[$letter]=$letter;
		}
	}
	ksort($indialpha);
	return $indialpha;
}

//-- find all of the individuals who start with the given letter
function get_alpha_indis($letter) {
	global $TBLPREFIX, $GEDCOM;

	$tindilist = array();
	$sql = "SELECT * FROM ".$TBLPREFIX."individuals WHERE i_name LIKE '%".addslashes($letter)."%' AND i_file='$GEDCOM' ORDER BY i_name";
	$res = dbquery($sql);
	while($row = mysql_fetch_array($res)) {
		$row = db_cleanup($row);
		$indi = array();
		$indi["name"] = $row["i_name"];
		$indi["isdead"] = $row["i_isdead"];
		$indi["gedcom"] = $row["i_gedcom"];
		$indi["file"] = $row["i_file"];
		$tindilist[$row["i_id"]] = $indi;
	}
	return $tindilist;
}

//-- find all of the individuals who start with the given letter
function get_alpha_fams($letter) {
	global $TBLPREFIX, $GEDCOM;

	$tfamlist = array();
	$sql = "SELECT * FROM ".$TBLPREFIX."families WHERE f_name LIKE '%".addslashes($letter)."%' AND f_file='$GEDCOM' ORDER BY f_name";
	$res = dbquery($sql);
	while($row = mysql_fetch_array($res)) {
		$row = db_cleanup($row);
		$fam = array();
		$fam["name"] = $row["f_name"];
		$fam["HUSB"] = $row["f_husb"];
		$fam["WIFE"] = $row["f_wife"];
		$fam["CHIL"] = $row["f_chil"];
		$fam["gedcom"] = $row["f_gedcom"];
		$fam["file"] = $row["f_file"];
		$tfamlist[$row["f_id"]] = $fam;
	}
	return $tfamlist;
}

//-- function to find the gedcom id for the given rin
function find_rin_id($rin) {
	global $TBLPREFIX, $GEDCOM;

	$sql = "SELECT i_id FROM ".$TBLPREFIX."individuals WHERE i_rin='$rin' AND i_file='$GEDCOM'";
	$res = dbquery($sql);
	while($row = mysql_fetch_array($res)) {
		return $row["i_id"];
	}
	return $rin;
}

function delete_gedcom($ged) {
	global $INDEX_DIRECTORY, $TBLPREFIX;

	@unlink($INDEX_DIRECTORY.$ged."_conf.php");
	$sql = "DELETE FROM ".$TBLPREFIX."individuals WHERE i_file='$ged'";
	$res = dbquery($sql);
	$sql = "DELETE FROM ".$TBLPREFIX."families WHERE f_file='$ged'";
	$res = dbquery($sql);
	$sql = "DELETE FROM ".$TBLPREFIX."sources WHERE s_file='$ged'";
	$res = dbquery($sql);
	$sql = "DELETE FROM ".$TBLPREFIX."other WHERE o_file='$ged'";
	$res = dbquery($sql);
	$sql = "DELETE FROM ".$TBLPREFIX."places WHERE p_file='$ged'";
	$res = dbquery($sql);
	$sql = "DELETE FROM ".$TBLPREFIX."favorites WHERE fv_file='$ged'";
	$res = dbquery($sql);

	if (isset($pgv_changes)) {
		//-- erase any of the changes
		foreach($pgv_changes as $cid=>$changes) {
			if ($changes[0]["gedcom"]==$ged) unset($pgv_changes[$cid]);
		}
		write_changes();
	}
}
?>
