<?php
/*=================================================
	Project: phpGedView
	File: functions_print.php
	Author:
		John Finlay
		Joe Witthuhn		jaw959@users.sourceforge.net
		Kurt Norgaz			kurtnorgaz
	Comments:
		Various printing functions used by all scripts and included by the functions.php
		file.

	Change Log:
		9/26/03 - File Created from functions.php

    phpGedView: Genealogy Viewer
    Copyright (C) 2002 to 2003  John Finlay and Others

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

===================================================*/
# $Id: functions_print.php,v 1.143.2.8 2004/02/04 20:17:32 yalnifj Exp $
if (strstr($_SERVER["PHP_SELF"],"functions")) {
	print "Now, why would you want to do that.  You're not hacking are you?";
	exit;
}

//-- find and print submitter information
function print_submitter_info($sid) {
	$srec = find_gedcom_record($sid);
	preg_match("/1 NAME (.*)/", $srec, $match);
	print "$match[1]<br />";
	print_address_structure($srec, 1);
	print_media_links($srec, 1);
}

// -- find and print given Repository information
function print_repository_record($sid) {
	global $pgv_lang;

	$source = find_gedcom_record($sid);
	$ct = preg_match("/1 NAME (.*)/", $source, $match);
	if ($ct > 0) print "<br /><font class=\"label\">".$pgv_lang["repo_name"]."</font> <font class=\"field\">$match[1]</font>";
	print_address_structure($source, 1);
	print_fact_notes($source, 1);
}

//-- print information about a person for a list view
// $key is the gedcom ID of the person to print
// $value is an array of the form array($name, $GEDCOM)
function print_list_person($key, $value) {
	global $pgv_lang, $PHP_SELF;
	global $GEDCOM, $SHOW_ID_NUMBERS, $TEXT_DIRECTION;

	$GEDCOM = $value[1];
	$indirec=find_person_record($key);
    $disp = displayDetailsByID($key);
    if ($disp || showLivingNameByID($key)) {
	    print "<a href=\"individual.php?pid=$key&amp;GEDCOM=$value[1]\" class=\"list_item\"><b>".stripslashes($value[0])."</b>";
	    if ($SHOW_ID_NUMBERS){
	    	print " &lrm;($key)&lrm;";
	    }
		if (!$disp) {
			print "--<i>".$pgv_lang["private"]."</i>";
		}
		else {
			print "--<i>".$pgv_lang["birth"]." ";
			$bpos1 = strpos($indirec, "1 BIRT");
			if ($bpos1) {
				$birthrec = substr($indirec, $bpos1+1);
				$bt = preg_match("/1 [A-Z]{4}/", $birthrec, $match);
				if ($bt>0) {
					$bpos2 = strpos($birthrec, $match[0]);
					if ($bpos2) $birthrec = substr($birthrec, 0, $bpos2);
				}
				$dct = preg_match("/2 DATE (.*)/", $birthrec, $match);
				if ($dct>0) print trim(get_changed_date($match[1]));
				$pct = preg_match("/2 PLAC (.*)/", $birthrec, $match);
				if ($pct>0) print " - ".trim($match[1]);
			}
			print "</i>";
		}
		print "</a><br />";
    }
}

//-- print information about a family for a list view
function print_list_family($key, $value) {
	global $pgv_lang;
	global $GEDCOM, $HIDE_LIVE_PEOPLE;

	$GEDCOM = $value[1];
	$famrec=find_family_record($key);
	//-- check if we can display both parents
	$parents = find_parents_in_record($famrec);
	$showLiving = true;
	$display = true;
	if ($HIDE_LIVE_PEOPLE){
		if (!empty($parents["HUSB"])) $display = displayDetailsByID($parents["HUSB"]);
		if ($display) {
			if (!empty($parents["WIFE"])) $display = displayDetailsByID($parents["WIFE"]);
			if (!$display) $showLiving=showLivingNameByID($parents["WIFE"]);
		}
		else {
			$showLiving=showLivingNameByID($parents["HUSB"]);
		}
	}
    if ($showLiving) {
	    print "<a href=\"family.php?famid=$key&amp;GEDCOM=$value[1]\" class=\"list_item\"><b>".stripslashes($value[0])."</b>";
		if (!$display) {
			print "--<i>".$pgv_lang["private"]."</i>";
		}
		else {
			print "--<i>".$pgv_lang["marriage"]." ";
			$bpos1 = strpos($famrec, "1 MARR");
			if ($bpos1) {
				$birthrec = substr($famrec, $bpos1+1);
				$bt = preg_match("/1 [A-Z]{4}/", $birthrec, $match);
				if ($bt>0) {
					$bpos2 = strpos($birthrec, $match[0]);
					if ($bpos2) $birthrec = substr($birthrec, 0, $bpos2);
				}
				$dct = preg_match("/2 DATE (.*)/", $birthrec, $match);
				if ($dct>0) print trim(get_changed_date($match[1]));
				$pct = preg_match("/2 PLAC (.*)/", $birthrec, $match);
				if ($pct>0) print " - ".trim($match[1]);
			}
			print "</i>";
		}
		print "</a><br />";
    }
}

// -- find and print a given individuals information for a pedigree chart
function print_pedigree_person($pid, $style=1, $show_famlink=true) {
	global $HIDE_LIVE_PEOPLE, $SHOW_LIVING_NAMES, $PRIV_PUBLIC, $factarray, $TEMPLE_CODES, $ZOOM_BOXES, $LINK_ICONS, $PHP_SELF;
	global $pgv_lang, $MULTI_MEDIA, $SHOW_HIGHLIGHT_IMAGES, $bwidth, $bheight, $show_full, $PEDIGREE_FULL_DETAILS, $SHOW_ID_NUMBERS, $SHOW_PEDIGREE_PLACES, $PGV_IMAGE_DIR;
	global $PGV_PEDIGREE_IMG, $PGV_SEARCH_IMG, $CONTACT_EMAIL, $CONTACT_METHOD, $TEXT_DIRECTION, $DEFAULT_PEDIGREE_GENERATIONS, $OLD_PGENS, $talloffset, $PEDIGREE_LAYOUT;

	if (!isset($OLD_PGENS)) $OLD_PGENS = $DEFAULT_PEDIGREE_GENERATIONS;
	if (!isset($talloffset)) $talloffset = $PEDIGREE_LAYOUT;
	if (!isset($show_full)) $show_full=$PEDIGREE_FULL_DETAILS;
	if ($pid==false) {
			print "\n\t\t\t<div id=\"out-".rand()."\" class=\"person_box\" style=\"width: ".$bwidth."px; height: ".$bheight."px; padding: 2px; overflow: hidden;\">";
		print "<br />";
		print "\n\t\t\t</div>";
		return false;
	}
	$indirec=find_person_record($pid);
	if (!$indirec) $indirec = find_record_in_file($pid);
	$ft = preg_match_all("/^1 ([A-Z]{3,4})(.*)/m", $indirec, $fmatch, PREG_SET_ORDER);
	$isF = "";
	if (preg_match("/1 SEX F/", $indirec)>0) $isF="F";
	$disp = displayDetails($indirec);
	if ($disp || showLivingName($indirec)) {
		if ($show_famlink&&$show_full) {
			if ($LINK_ICONS!="disabled") {
				//-- draw a box for the family popup
				print "\n\t\t<div id=\"I".$pid."links\" style=\"position:absolute; left: 0px; top:0px; width: ".($bwidth*.75)."px; visibility:hidden; text-align: left; z-index:'100';\">";
				print "\n\t\t\t<table class=\"person_box$isF\"><tr><td class=\"details1\">";
				print "<a href=\"index.php?rootid=$pid&amp;PEDIGREE_GENERATIONS=$OLD_PGENS&amp;talloffset=$talloffset\" onmouseover=\"clear_family_box_timeout('".$pid."');\" onmouseout=\"family_box_timeout('".$pid."');\"><b>".$pgv_lang["index_header"]."</b></a>\n";
				print "<br /><a href=\"descendancy.php?pid=$pid\" onmouseover=\"clear_family_box_timeout('".$pid."');\" onmouseout=\"family_box_timeout('".$pid."');\"><b>".$pgv_lang["descend_chart"]."</b></a><br />\n";
				$ct = preg_match_all("/1\s*FAMS\s*@(.*)@/", $indirec, $match, PREG_SET_ORDER);
				for ($i=0; $i<$ct; $i++) {
					$famid = $match[$i][1];
					$famrec = find_family_record($famid);
					if ($famrec) {
						$parents = find_parents_in_record($famrec);
						$spouse = $parents["WIFE"];
						if ((empty($spouse))||($spouse==$pid)) $spouse=$parents["HUSB"];
						if (!empty($spouse)) {
							print "<a href=\"family.php?famid=$famid\" onmouseover=\"clear_family_box_timeout('".$pid."');\" onmouseout=\"family_box_timeout('".$pid."');\"><b>".$pgv_lang["fam_spouse"]."</b></a> <br /><a href=\"individual.php?pid=$spouse\" onmouseover=\"clear_family_box_timeout('".$pid."');\" onmouseout=\"family_box_timeout('".$pid."');\">";
							if (($SHOW_LIVING_NAMES>=$PRIV_PUBLIC) || (displayDetailsByID($spouse))||(showLivingNameByID($spouse))) print get_person_name($spouse);
							else print $pgv_lang["living"];
							print "</a><br />\n";
						}
						$num = preg_match_all("/1\s*CHIL\s*@(.*)@/", $famrec, $smatch,PREG_SET_ORDER);
						for($j=0; $j<$num; $j++) {
							$cpid = $smatch[$j][1];
							print "\n\t\t\t\t&nbsp;&nbsp;<a href=\"individual.php?pid=$cpid\" onmouseover=\"clear_family_box_timeout('".$pid."');\" onmouseout=\"family_box_timeout('".$pid."');\">";
							if (($SHOW_LIVING_NAMES>=$PRIV_PUBLIC) || (displayDetailsByID($cpid))||(showLivingNameByID($cpid))) print get_person_name($cpid);
							else print $pgv_lang["living"];
							print "<br /></a>";
						}
					}
				}
				print "</td></tr></table>\n\t\t</div>";
			}
			print "\n\t\t\t<div id=\"out-$pid\"";
			if ($style==1) print " class=\"person_box$isF\" style=\"width: ".$bwidth."px; height: ".$bheight."px; padding: 2px; overflow: hidden; z-index:'-1';\"><table width=\"100%\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\"><tr><td valign=\"top\">";
			else print "style=\"padding: 2px;\"><table width=\"100%\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\"><tr><td valign=\"top\">";
			//-- links and zoom icons
			if ($TEXT_DIRECTION == "rtl") {
				print "<div style=\"float:left; width: 25px; height: 50px;\">";
			} else {
			print "<div style=\"float:right; width: 25px; height: 50px;\">";
			}
			if ($LINK_ICONS!="disabled") {
				$click_link="#";
				if (preg_match("/index.php/", $PHP_SELF)>0) $click_link="index.php?rootid=$pid&amp;PEDIGREE_GENERATIONS=$OLD_PGENS&amp;talloffset=$talloffset";
				if (preg_match("/descendancy.php/", $PHP_SELF)>0) $click_link="descendancy.php?pid=$pid";
				if ((preg_match("/family.php/", $PHP_SELF)>0)&&!empty($famid)) $click_link="family.php?famid=$famid";
				if (preg_match("/individual.php/", $PHP_SELF)>0) $click_link="individual.php?pid=$pid";
				print "<a href=\"$click_link\" ";
				if ($LINK_ICONS=="mouseover") print "onmouseover=\"show_family_box('".$pid."', '";
				if ($LINK_ICONS=="click") print "onclick=\"toggle_family_box('".$pid."', '";
				if ($style==1) print "box$pid";
				else print "relatives";
				print "');";
				print " return false;\" ";
				//if ($LINK_ICONS=="mouseover")
				print "onmouseout=\"family_box_timeout('".$pid."');";
				print " return false;\"";
				print "><img src=\"$PGV_IMAGE_DIR/small/$PGV_PEDIGREE_IMG\" width=\"25\" border=\"0\" vspace=\"0\" hspace=\"0\" alt=\"".$pgv_lang["person_links"]."\" title=\"".$pgv_lang["person_links"]."\" /></a>";
			}
			if ($ZOOM_BOXES!="disabled") {
				print "<a href=\"#\"";
				if ($ZOOM_BOXES=="mouseover") print " onmouseover=\"expandbox('$pid', $style);\" onmouseout=\"restorebox('$pid', $style);\" onclick=\"return false;\"";
				if ($ZOOM_BOXES=="mousedown") print "onmousedown=\"expandbox('$pid', $style);\" onmouseup=\"restorebox('$pid', $style);\"";
				if ($ZOOM_BOXES=="click") print "onclick=\"expandbox('$pid', $style); return false;\"";
				print "><img src=\"$PGV_IMAGE_DIR/small/$PGV_SEARCH_IMG\" width=\"25\" height=\"25\" border=\"0\" alt=\"".$pgv_lang["zoom_box"]."\" title=\"".$pgv_lang["zoom_box"]."\"/></a>";
			}
			print "</div>\n";
		}
		else {
			if ($style==1) {
				print "\n\t\t\t<div id=\"out-$pid\" class=\"person_box$isF\" style=\"width: ".$bwidth."px; height: ".$bheight."px; padding: 2px; overflow: hidden;\"";
			}
			else {
				print "\n\t\t\t<div id=\"out-$pid\" class=\"person_box$isF\" style=\"padding: 2px; overflow: hidden;\"";
			}
			if ($ZOOM_BOXES!="disabled") {
				if ($ZOOM_BOXES=="mouseover") print " onmouseover=\"expandbox('$pid', $style); return false;\" onmouseout=\"restorebox('$pid', $style); return false;\"";
				if ($ZOOM_BOXES=="mousedown") print "onmousedown=\"expandbox('$pid', $style);\" onmouseup=\"restorebox('$pid', $style);\"";
				if ($ZOOM_BOXES=="click") print "onclick=\"expandbox('$pid', $style);\"";
				//print "><img src=\"$PGV_IMAGE_DIR/small/$PGV_SEARCH_IMG\" width=\"25\" height=\"25\" border=\"0\" alt=\"".$pgv_lang["zoom_box"]."\" title=\"".$pgv_lang["zoom_box"]."\"/></a>";
			}
			print "><table width=\"100%\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\"><tr><td valign=\"top\">";
		}
	}
	else {
		if ($style==1) print "\n\t\t\t<div id=\"out-$pid\" class=\"person_box$isF\" style=\"width: ".$bwidth."px; height: ".$bheight."px; padding: 2px; overflow: hidden;\"><table width=\"100%\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\"><tr><td valign=\"top\">";
		else print "\n\t\t\t<div id=\"out-$pid\" class=\"person_box$isF\" style=\"padding: 2px; overflow: hidden;\"><table width=\"100%\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\"><tr><td valign=\"top\">";
	}

	//-- find the name
	//preg_match("/1 NAME (.*)/", $indirec, $match);
	$name = get_person_name($pid);
	if ($MULTI_MEDIA && $SHOW_HIGHLIGHT_IMAGES && showFact("OBJE", $pid)) {
		$object = find_highlighted_object($pid, $indirec);
		if (!empty($object["thumb"])) {
			$size = @getimagesize($object["thumb"]);
			$class = "pedigree_image_portrait";
			if ($size[0]>$size[1]) $class = "pedigree_image_landscape";
			print "<img id=\"box-$pid-thumb\" src=\"".$object["thumb"]."\" vspace=\"0\" hspace=\"0\" class=\"$class\" alt =\"\"";
			if (!$show_full) print " style=\"display: none;\"";
			print " />\n";
		}
	}
	//-- check if the persion is visible
	if (!$disp) {
		if (showLivingName($indirec)) {
			print "<a href=\"individual.php?pid=$pid\"><font id=\"namedef-$pid\" class=\"name$style\">";
			print $name;
			print "</font>";
			if ($SHOW_ID_NUMBERS) {
				print "<font class=\"details$style\">";
				print " &lrm;($pid)&lrm;";
				print "</font>";
			}
			print "</a>";
		}
		else {
			$user = getUser($CONTACT_EMAIL);
			print "<a href=\"#\" onclick=\"if (confirm('".preg_replace("'<br />'", " ", $pgv_lang["privacy_error"])."\\n\\n".str_replace("#user[fullname]#", $user["fullname"], $pgv_lang["clicking_ok"])."')) ";
			if ($CONTACT_METHOD!="none") {
				if ($CONTACT_METHOD=="mailto") print "window.location = 'mailto:".$user["email"]."'; ";
				else print "message('$CONTACT_EMAIL', '$CONTACT_METHOD'); ";
			}
			print "return false;\"><font id=\"namedef-$pid\" class=\"name$style\">".$pgv_lang["living"]."</font></a>\n";
		}
		if ($show_full) {
			print "<br /><font id=\"fontdef-$pid\" class=\"details$style\">";
			print $pgv_lang["private"];
			print "</font>";
		}
		print "\n\t\t\t</td></tr></table></div>";
		return;
	}
 	print "<a href=\"individual.php?pid=$pid\"";
 	if (! $show_full) {
 		//not needed or wanted for mouseover //if ($ZOOM_BOXES=="mouseover") print " onmouseover=\"event.cancelBubble = true;\"";
 		if ($ZOOM_BOXES=="mousedown") print "onmousedown=\"event.cancelBubble = true;\"";
 		if ($ZOOM_BOXES=="click") print "onclick=\"event.cancelBubble = true;\"";

 	}
 	print "><span id=\"namedef-$pid\" class=\"name$style\">";
	print $name;
	print "</span>";
	if ($SHOW_ID_NUMBERS) {
		print "<span class=\"details$style\"> ";
		print " &lrm;($pid)&lrm;";
		print "</span>";
	}
	print "</a>";
	if (!$show_full) print "\n<div id=\"inout-$pid\" style=\"display: none;\">\n";
	print "<div id=\"fontdef-$pid\" class=\"details$style\">";
	$birttag = "BIRT";
	$bpos1 = strpos($indirec, "1 BIRT");
	if ($bpos1) {
		if (showFact($birttag, $pid)) print_simple_fact($indirec, $birttag, $pid);
	}
	//-- no birth check for christening or baptism
	else {
		$bpos1 = strpos($indirec, "1 CHR");
		if ($bpos1) {
			$birttag = "CHR";
			if (showFact($birttag, $pid)) print_simple_fact($indirec, $birttag, $pid);
		}
		else {
			$bpos1 = strpos($indirec, "1 BAPM");
			if ($bpos1) {
				$birttag = "BAPM";
				if (showFact($birttag, $pid)) print_simple_fact($indirec, $birttag, $pid);
			}
		}
	}
	if ($ft>3) {
		$skipfacts = array($birttag,"DEAT","SEX","FAMS","FAMC","NAME","TITL","NOTE","SOUR","SSN","OBJE","HUSB","WIFE","CHIL","ALIA","ADDR","PHON","SUBM","_EMAIL");
		if ($show_full) print "\n<div id=\"inout-$pid\" style=\"display: none;\">\n";
		$f2 = 0;
		$pos2 = 0;
		for($f=0; $f<$ft; $f++) {
			$fact = trim($fmatch[$f][1]);
			$details = trim($fmatch[$f][2]);
			if ((!in_array($fact, $skipfacts))&&(isset($factarray[$fact]))&&(showFact($fact, $pid))) {
				$pos1 = strpos($indirec, $fmatch[$f][0], $pos2);
				$pos2 = strpos($indirec, "\n1", $pos1+1);
				if (!$pos2) $pos2 = strlen($indirec);
				$factrec = substr($indirec, $pos1, $pos2-$pos1);
				if ($f2>0) print "\n<br />";
				$f2++;
				if ($fact!="EVEN") print "<font class=\"details_label\">".$factarray[$fact]."</font> ";
				else {
					$tct = preg_match("/2 TYPE (.*)/", $factrec, $match);
					if ($tct>0) {
						$facttype = trim($match[1]);
						print "<font class=\"details_label\">";
						if (isset($factarray[$facttype])) print $factarray[$facttype];
						else print $facttype;
						print "</font> ";
					}
				}
				print $details;
				$dct = preg_match("/2 DATE (.*)/", $factrec, $match);
				if ($dct>0) print " <font class=\"date\">".get_changed_date($match[1])."</font>";
				if ($SHOW_PEDIGREE_PLACES>0) {
					$pct = preg_match("/2 PLAC (.*)/", $factrec, $match);
					if ($pct>0) {
						print " -- ";
						$plevels = preg_split("/,/", $match[1]);
						for($plevel=0; $plevel<$SHOW_PEDIGREE_PLACES; $plevel++) {
							if (!empty($plevels[$plevel])) {
								if ($plevel>0) print ", ";
								print trim($plevels[$plevel]);
							}
						}
					}
					$pct = preg_match("/2 TEMP (.*)/", $factrec, $match);
					if ($pct>0) {
						print " -- ".$pgv_lang["temple"]." ";
						if (isset($TEMPLE_CODES[trim($match[1])])) print $TEMPLE_CODES[trim($match[1])];
						else print trim($match[1]);
					}
					$pct = preg_match("/2 STAT (.*)/", $factrec, $match);
					if ($pct>0) {
						print " ".$pgv_lang["status"]." ";
						print trim($match[1]);
					}
				}
			}
		}
		//-- find family as spouse
		$sct = preg_match_all("/1\s+FAMS\s+@(.*)@/", $indirec, $sfmatch, PREG_SET_ORDER);
		for($s=0; $s<$sct; $s++) {
			$famid = $sfmatch[$s][1];
			$famrec = find_family_record($famid);
			$parents=find_parents_in_record($famrec);
			if ($parents['HUSB']==$pid) $spouse=$parents['WIFE'];
			else $spouse=$parents['HUSB'];
			$fft = preg_match_all("/1 ([A-Z]{4})(.*)/", $famrec, $fmatch, PREG_SET_ORDER);
			$pos2=0;
			for($f=0; $f<$fft; $f++) {
				$fact = trim($fmatch[$f][1]);
				if ((!in_array($fact, $skipfacts))&&(isset($factarray[$fact]))&&(showFact($fact, $pid))) {
					$pos1 = strpos($famrec, $fmatch[$f][0], $pos2);
					if ($pos1) {
						$pos2 = strpos($famrec, "\n1", $pos1+1);
						if (!$pos2) $pos2 = strlen($famrec);
						$factrec = substr($famrec, $pos1, $pos2-$pos1);
						if ($f2>0) print "<br />";
						$f2++;
						if ($fact!="EVEN") print "<font class=\"details_label\">".$factarray[$fact]."</font> ";
						else {
							$tct = preg_match("/2 TYPE (.*)/", $factrec, $match);
							if ($tct>0) print "<font class=\"details_label\">".$match[1]."</font> ";
						}
						$dct = preg_match("/2 DATE (.*)/", $factrec, $match);
						if ($dct>0) print " <font class=\"date\">".get_changed_date($match[1])."</font>";
						if (($fact=="MARR")||($fact=="SLGS")) print "<a href=\"individual.php?pid=$spouse\">".get_person_name($spouse)."</a>";
						if ($SHOW_PEDIGREE_PLACES>0) {
							$pct = preg_match("/2 PLAC (.*)/", $factrec, $match);
							if ($pct>0) {
								print " -- ";
								$plevels = preg_split("/,/", $match[1]);
								for($plevel=0; $plevel<$SHOW_PEDIGREE_PLACES; $plevel++) {
									if (!empty($plevels[$plevel])) {
										if ($plevel>0) print ", ";
										print trim($plevels[$plevel]);
									}
								}
							}
							$pct = preg_match("/2 TEMP (.*)/", $factrec, $match);
							if ($pct>0) {
								print " -- ".$pgv_lang["temple"]." ";
								if (isset($TEMPLE_CODES[trim($match[1])])) print $TEMPLE_CODES[trim($match[1])];
								else print trim($match[1]);
							}
						}
					}
				}
			}
		}
		print "</div>\n";
	}
	$bpos1 = strpos($indirec, "1 DEAT");
	if ($bpos1) {
		if (showFact("DEAT", $pid)) print_simple_fact($indirec, "DEAT", $pid);
	}
	print "</div>";
	print "\n\t\t\t</td></tr></table></div>";
}

// -- print out the html header information
function print_header($title, $head="") {
	global $pgv_lang, $bwidth;
    global $HOME_SITE_URL, $HOME_SITE_TEXT;
	global $view, $cart;
	global $CHARACTER_SET, $VERSION, $PGV_IMAGE_DIR, $PGV_DATABASE;
	global $PHP_SELF, $QUERY_STRING, $action, $query, $changelanguage;
    global $FAVICON, $stylesheet, $headerfile, $toplinks, $THEME_DIR, $print_headerfile;
    global $PGV_PLUS_IMG, $PGV_MINUS_IMG, $PGV_LARROW2_IMG, $PGV_RARROW2_IMG, $PGV_UARROW2_IMG, $PGV_MEDIA_IMG, $PGV_HLINE_IMG, $PGV_PEDIGREE_IMG, $PGV_DESCENDANT_IMG, $PGV_TIMELINE_IMG, $PGV_RELATIONSHIP_IMG, $PGV_INDIS_IMG, $PGV_CFAMILY_IMG, $PGV_SOURCE_IMG, $PGV_PLACE_IMG, $PGV_CALENDAR_IMG, $PGV_SEARCH_IMG, $PGV_TIMELINE_IMG, $PGV_CLIPPINGS_IMG, $TEXT_DIRECTION;
	header("Content-Type: text/html; charset=$CHARACTER_SET");
	print "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\n";
	print "<html xmlns=\"http://www.w3.org/1999/xhtml\">\n\t<head>\n\t\t";
	print "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=$CHARACTER_SET\" />\n\t\t";
    if( $FAVICON ) {
        print "<link rel=\"shortcut icon\" href=\"$FAVICON\" type=\"image/x-icon\"></link>\n\t\t";
    }
	print "<title>$title - PhpGedView</title>\n\t<link rel=\"stylesheet\" href=\"$stylesheet\" type=\"text/css\"></link>\n\t";
	if (strstr($_SERVER["HTTP_USER_AGENT"], "IE")) print "<style type=\"text/css\">\nFORM { margin-top: 0px; margin-bottom: 0px; }\n</style>\n";
	if($TEXT_DIRECTION == "rtl") print "\n<style type=\"text/css\">body{ direction: rtl;   text-align: right; } </style>";
	print "<!-- PhpGedView v$VERSION $PGV_DATABASE -->\n";
	@include($THEME_DIR."/metatags.php");
	if ($view!="preview") {
		if (isset($changelanguage)) {
			$terms = preg_split("/&/", $QUERY_STRING);
			$vars = "";
			for ($i=0; $i<count($terms); $i++) {
				if ((!empty($terms[$i]))&&(strstr($terms[$i], "changelanguage")===false)&&(strpos($terms[$i], "NEWLANGUAGE")===false)) {
					$vars .= $terms[$i]."&";
				}
			}
			$query_string = $vars;
		}
		else $query_string = $QUERY_STRING;
?>
	<script language="JavaScript" type="text/javascript">
	<!--
	<?php print "query = \"$query_string\";\n"; ?>

	plusminus = new Array();
	plusminus[0] = new Image();
	plusminus[0].src = "<?php print "$PGV_IMAGE_DIR/$PGV_PLUS_IMG"; ?>";
	plusminus[1] = new Image();
	plusminus[1].src = "<?php print "$PGV_IMAGE_DIR/$PGV_MINUS_IMG"; ?>";

	arrows = new Array();
	arrows[0] = new Image();
	arrows[0].src = "<?php print "$PGV_IMAGE_DIR/$PGV_LARROW2_IMG"; ?>";
	arrows[1] = new Image();
	arrows[1].src = "<?php print "$PGV_IMAGE_DIR/$PGV_RARROW2_IMG"; ?>";
	arrows[2] = new Image();
	arrows[2].src = "<?php print "$PGV_IMAGE_DIR/$PGV_UARROW2_IMG"; ?>";

function delete_record(pid, linenum) {
	if (confirm('<?php print $pgv_lang["check_delete"]; ?>')) {
		window.open('gdbi_interface.php?action=delete&pid='+pid+'&linenum='+linenum, '', 'top=50,left=50,width=600,height=500,resizable=1,scrollbars=1');
	}
	return false;
}
function deleteperson(pid) {
	if (confirm('<?php print $pgv_lang["confirm_delete_person"]; ?>')) {
		window.open('gdbi_interface.php?action=deleteperson&pid='+pid, '', 'top=50,left=50,width=600,height=500,resizable=1,scrollbars=1');
	}
	return false;
}

function deletesource(pid) {
	if (confirm('<?php print $pgv_lang["confirm_delete_source"]; ?>')) {
		window.open('gdbi_interface.php?action=deletesource&pid='+pid, '', 'top=50,left=50,width=600,height=500,resizable=1,scrollbars=1');
	}
	return false;
}

function message(username, method, url) {
	if ((!url)||(url=="")) url='<?php print urlencode($PHP_SELF."?".$QUERY_STRING); ?>';
	window.open('message.php?to='+username+'&method='+method+'&url='+url, '', 'top=50,left=50,width=600,height=500,resizable=1,scrollbars=1');
	return false;
}

//-->
</script>
<script src="phpgedview.js" language="JavaScript" type="text/javascript"></script>
<?php
}
else {
?>
<script language="JavaScript" type="text/javascript">
<!--
function hidePrint() {
	var printlink = document.getElementById('printlink');
	if (printlink) {
		printlink.style.display='none';
	}
}

function showBack() {
	var backlink = document.getElementById('backlink');
	if (backlink) {
		backlink.style.display='block';
	}
}
//-->
</script>
<?php
}
	print $head;
	print "</head>\n\t<body";
	if ($view=="preview") print " onbeforeprint=\"hidePrint();\" onafterprint=\"showBack();\"";
	//print " dir=\"$TEXT_DIRECTION\">\n\t";
	print ">\n\t";
	if ($view!="preview") {
		include($headerfile);
		include($toplinks);
	}
	else {
		include($print_headerfile);
	}
}

// -- print out a simplified html header information
function print_simple_header($title) {
	global $pgv_lang;
    global $HOME_SITE_URL;
    global $HOME_SITE_TEXT;
	global $view;
	global $CHARACTER_SET, $VERSION, $PGV_IMAGE_DIR;
	global $PHP_SELF, $QUERY_STRING, $action, $query, $changelanguage;
    global $FAVICON, $stylesheet, $headerfile, $toplinks, $THEME_DIR, $print_headerfile;
    global $PGV_PLUS_IMG, $PGV_MINUS_IMG;

	header("Content-Type: text/html; charset=$CHARACTER_SET");
	print "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\n";
	print "<html xmlns=\"http://www.w3.org/1999/xhtml\">\n\t<head>\n\t\t";
	print "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=$CHARACTER_SET\" />\n\t\t";
    if( $FAVICON ) {
        print "<link rel=\"shortcut icon\" href=\"$FAVICON\" type=\"image/x-icon\"></link>\n\t\t";
    }
	print "<title>$title - PHPGedView $VERSION</title>\n\t<link rel=\"stylesheet\" href=\"$stylesheet\" type=\"text/css\"></link>\n\t";
	@include($THEME_DIR."/metatags.php");
	?>
	<script language="JavaScript" type="text/javascript">
	<!--
	plusminus = new Array();
	plusminus[0] = new Image();
	plusminus[0].src = "<?php print "$PGV_IMAGE_DIR/$PGV_PLUS_IMG"; ?>";
	plusminus[1] = new Image();
	plusminus[1].src = "<?php print "$PGV_IMAGE_DIR/$PGV_MINUS_IMG"; ?>";

	function expand_layer(sid) {
		var sbox = document.getElementById(sid);
		var sbox_img = document.getElementById(sid+"_img");
		var sbox_style = sbox.style;
		if (sbox_style.display=='none') {
			sbox_style.display='block';
			sbox_img.src = plusminus[1].src;
		}
		else {
			sbox_style.display='none';
			sbox_img.src = plusminus[0].src;
		}
		return false;
	}
	//-->
	</script>
	<?php
	print "</head>\n\t<body>\n\t";
}

// -- print the html to close the page
function print_footer() {
	global $without_close, $pgv_lang, $view, $buildindex, $pgv_changes, $PGV_DATABASE, $VERSION_RELEASE;
	global $VERSION, $SHOW_STATS, $PHP_SELF, $QUERY_STRING, $footerfile, $print_footerfile, $GEDCOMS, $ALLOW_CHANGE_GEDCOM, $printlink;
	global $PGV_IMAGE_DIR, $PGV_GEDVIEW_IMG;

	print "<div class=\"footer\">\n";
	$QUERY_STRING = preg_replace("/&/", "&", $QUERY_STRING);
	if ($view!="preview") {
		include($footerfile);
		print "\n\t<br /><div align=\"center\" style=\"width:100%;\">";
		print "\n\t<a href=\"http://www.phpgedview.net\" target=\"_blank\"><img src=\"$PGV_IMAGE_DIR/$PGV_GEDVIEW_IMG\" border=\"0\" alt=\"PhpGedView Version $VERSION $VERSION_RELEASE - $PGV_DATABASE\" title=\"PhpGedView Version $VERSION $VERSION_RELEASE - $PGV_DATABASE\" /></a><br />";
		print "\n\t<br /><a href=\"$PHP_SELF?view=preview&amp;$QUERY_STRING\">".$pgv_lang["print_preview"]."</a><br />";
		if ($SHOW_STATS) print_execution_stats();
		if ($buildindex) print " ".$pgv_lang["build_error"]."  <a href=\"editgedcoms.php\">".$pgv_lang["rebuild_indexes"]."</a>\n";
		if ($ALLOW_CHANGE_GEDCOM && (count($GEDCOMS)>1)) print "\n\t<a href=\"$PHP_SELF?change_gedcom=yes&amp;$QUERY_STRING\">".$pgv_lang["choose_gedcom"]."</a><br />";
		if ((count($pgv_changes) > 0) and (userIsAdmin(getUserName())))
		{
		  print "<br />".$pgv_lang["changes_exist"]." <a href=\"gdbi_changes.php\">".$pgv_lang["accept_changes"]."</a>\n";
		}
		print "</div>";
	}
	else {
		include($print_footerfile);
		print "\n\t<div align=\"center\" width=\"100%\"><br />";
		if (!$printlink) print "\n\t<br /><a id=\"printlink\" href=\"#\" onClick=\"print(); return false;\">".$pgv_lang["print"]."</a><br />";
		$printlink = true;
		print "\n\t<a id=\"backlink\" style=\"display: none;\" href=\"#\" onClick=\"history.back(); return false;\">".$pgv_lang["back"]."</a><br />";
	}
	print "</div>";
	if (!isset($without_close)) print "\n\t</body>\n</html>";
}

// -- print the html to close the page
function print_simple_footer() {
	global $pgv_lang;
	global $start_time, $buildindex;
	global $VERSION, $SHOW_STATS;
	global $PHP_SELF, $QUERY_STRING;
	global $PGV_IMAGE_DIR, $PGV_GEDVIEW_IMG;

	if (empty($PHP_SELF)) {
		$PHP_SELF = $_SERVER["PHP_SELF"];
		$QUERY_STRING = $_SERVER["QUERY_STRING"];
	}
	print "\n\t<br /><div align=\"center\" style=\"width: 100%;\">";
	print "\n\t<a href=\"http://www.phpgedview.net\" target=\"_blank\"><img src=\"$PGV_IMAGE_DIR/$PGV_GEDVIEW_IMG\" border=\"0\" alt=\"PhpGedView Version $VERSION\" title=\"PhpGedView Version $VERSION\" /></a><br />";
	if ($SHOW_STATS) print_execution_stats();
	print "</div>";
	print "\n\t</body>\n</html>";
}


//-- print a form to change the language
function print_lang_form($option=0) {
	global $ENABLE_MULTI_LANGUAGE, $pgv_lang, $pgv_language, $flagsfile, $LANGUAGE, $language_settings;
	global $LANG_FORM_COUNT;
	global $PHP_SELF, $QUERY_STRING;
	if ($ENABLE_MULTI_LANGUAGE) {
		if (empty($LANG_FORM_COUNT)) $LANG_FORM_COUNT=1;
		else $LANG_FORM_COUNT++;
		print "\n\t<div class=\"lang_form\">\n";
		switch($option) {
			case 1:
			//-- flags option
			print "<img src=\"" . $flagsfile[$LANGUAGE] . "\" class=\"flag\" border=\"0\" alt=\"" . $pgv_lang[$LANGUAGE] . "\" />";
			foreach ($pgv_language as $key=>$value)
			{
			  if (($key != $LANGUAGE) and ($language_settings[$key]["pgv_lang_use"]))
			  {
			    print "\n\t\t\t<a href=\"$PHP_SELF?$QUERY_STRING&amp;changelanguage=yes&amp;NEWLANGUAGE=$key\">";
			    print "<img src=\"" . $flagsfile[$key] . "\" class=\"flag\" border=\"0\" alt=\"" . $pgv_lang[$key] . "\" /></a>";
			  }
			}
			break;
			default:
				print "<form name=\"langform$LANG_FORM_COUNT\" action=\"$PHP_SELF";
				if (!empty($QUERY_STRING)) print "?$QUERY_STRING";
				print "\" method=\"post\" onsubmit=\"langchange(this); return false;\">";
				print "\n\t\t<input type=\"hidden\" name=\"changelanguage\" value=\"yes\" />\n\t\t<select name=\"NEWLANGUAGE\" class=\"header_select\" onchange=\"document.langform$LANG_FORM_COUNT.submit();\">";
				print "\n\t\t\t<option value=\"\">".$pgv_lang["change_lang"]."</option>";
				foreach ($pgv_language as $key=>$value) {
					if ($language_settings[$key]["pgv_lang_use"]) print "\n\t\t\t<option value=\"$key\">".$pgv_lang[$key]."</option>";
				}
				print "</select>\n\t</form>\n";
			break;
		}
		print "</div>";
	}
}

//-- print user info and links
function print_user_links() {
	global $pgv_lang, $PHP_SELF, $QUERY_STRING, $GEDCOM, $SHOW_RESEARCH_LOG, $PRIV_USER, $PRIV_PUBLIC, $USE_REGISTRATION_MODULE;
	$user = getUser(getUserName());
	print "<div class=\"user_links\">";
	if ($user) {
		print '<a href="edituser.php" class="link">'.$pgv_lang["logged_in_as"].' ('.getUserName().')</a><br />';
		print "<a href=\"mygedview.php\" class=\"link\">".$pgv_lang["mygedview"]."</a> | ";
		print "<a href=\"index.php?logout=1\" class=\"link\">".$pgv_lang["logout"]."</a>";
		if (file_exists("rs_folders.php")) {
			if ($SHOW_RESEARCH_LOG>=$PRIV_USER || userisAdmin($user["username"])) print "<br /><a href=\"rs_folders.php\" class=\"link\">".$pgv_lang["research_log"]."</a>";
		}
		if (userIsAdmin($user["username"])) print " | <a href=\"admin.php\" class=\"link\">".$pgv_lang["admin"]."</a>";
	}
	else {
		$QUERY_STRING = preg_replace("/logout=1/", "", $QUERY_STRING);
		print "<a href=\"login.php?url=$PHP_SELF?".urlencode($QUERY_STRING."&GEDCOM=$GEDCOM")."\" class=\"link\">".$pgv_lang["login"]."</a>";
		 if (file_exists("rs_folders.php")) {
                        if ($SHOW_RESEARCH_LOG==$PRIV_PUBLIC) print "<br /><a href=\"rs_folders.php\" class=\"link\">".$pgv_lang["research_log"]."</a>";
                }
	}
	print "</div>";
}

//-- print support and genealogy contact links
function print_contact_links() {
	global $WEBMASTER_EMAIL, $SUPPORT_METHOD, $CONTACT_EMAIL, $CONTACT_METHOD, $pgv_lang;

	print "<div class=\"contact_links\">\n";
	if ($SUPPORT_METHOD=="none" && $CONTACT_METHOD=="none") return;
	if ($SUPPORT_METHOD=="none") $WEBMASTER_EMAIL = $CONTACT_EMAIL;
	if ($CONTACT_METHOD=="none") $CONTACT_EMAIL = $WEBMASTER_EMAIL;
	//--only display one message if the contact users are the same
	if ($CONTACT_EMAIL==$WEBMASTER_EMAIL) {
		$user = getUser($WEBMASTER_EMAIL);
		if (($user)&&($SUPPORT_METHOD!="mailto")) print $pgv_lang["for_all_contact"]." <a href=\"#\" onclick=\"message('$WEBMASTER_EMAIL', '$SUPPORT_METHOD'); return false;\">".$user["fullname"]."</a><br />\n";
		else {
			print $pgv_lang["for_support"]." <a href=\"mailto:";
			if ($user) print $user["email"]."\">".$user["fullname"]."</a><br />\n";
			else print $WEBMASTER_EMAIL."\">".$WEBMASTER_EMAIL."</a><br />\n";
		}
	}
	//-- display two messages if the contact users are different
	else {
		$user = getUser($CONTACT_EMAIL);
		if (($user)&&($CONTACT_METHOD!="mailto")) print $pgv_lang["for_contact"]." <a href=\"#\" onclick=\"message('$CONTACT_EMAIL', '$CONTACT_METHOD'); return false;\">".$user["fullname"]."</a><br /><br />\n";
		else {
			print $pgv_lang["for_contact"]." <a href=\"mailto:";
			if ($user) print $user["email"]."\">".$user["fullname"]."</a><br />\n";
			else print $CONTACT_EMAIL."\">".$CONTACT_EMAIL."</a><br />\n";
		}

		$user = getUser($WEBMASTER_EMAIL);
		if (($user)&&($SUPPORT_METHOD!="mailto")) print $pgv_lang["for_support"]." <a href=\"#\" onclick=\"message('$WEBMASTER_EMAIL', '$SUPPORT_METHOD'); return false;\">".$user["fullname"]."</a><br />\n";
		else {
			print $pgv_lang["for_support"]." <a href=\"mailto:";
			if ($user) print $user["email"]."\">".$user["fullname"]."</a><br />\n";
			else print $WEBMASTER_EMAIL."\">".$WEBMASTER_EMAIL."</a><br />\n";
		}
	}
	print "</div>\n";
}

//-- print user favorites
function print_favorite_selector($option=0) {
	global $pgv_lang, $GEDCOM, $PHP_SELF, $SHOW_ID_NUMBERS;

	$username = getUserName();
	if (empty($username)) return false;
	$userfavs = getUserFavorites($username);
	if (!is_array($userfavs)) return;
	print "<div class=\"favorites_form\">\n";
	switch($option) {
		case 1:
			print "<a class=\"link\" href=\"#\" onclick=\"return togglefavoritesbox();\">".$pgv_lang["my_favorites"]."</a><br />\n";
			print "<div id=\"favs_popup\" class=\"person_box\" style=\"position: absolute; visibility: hidden;\">\n";
			$mygedcom = $GEDCOM;
			foreach($userfavs as $key=>$favorite) {
				if ($favorite["type"]=="INDI") {
					$GEDCOM = $favorite["file"];
					print "\n\t\t\t<a href=\"individual.php?pid=".$favorite["gid"]."&amp;GEDCOM=$GEDCOM\"><span class=\"name1\">".get_person_name($favorite["gid"]);
					if ($SHOW_ID_NUMBERS) print " (".$favorite["gid"].")";
					print "</span></a><br />\n";
				}
			}
			$GEDCOM = $mygedcom;
			print "</div>\n";
			break;
		default:
			print "<form name=\"favoriteform\" action=\"$PHP_SELF";
			print "\" method=\"post\" onsubmit=\"return false;\">";
			print "\n\t\t<select name=\"fav_id\" class=\"header_select\" onchange=\"if (document.favoriteform.fav_id.selectedIndex>0) window.location='individual.php?'+document.favoriteform.fav_id.options[document.favoriteform.fav_id.selectedIndex].value;\">";
			print "\n\t\t\t<option value=\"\">".$pgv_lang["my_favorites"]."</option>";
			$mygedcom = $GEDCOM;
			foreach($userfavs as $key=>$favorite) {
				if ($favorite["type"]=="INDI") {
					$GEDCOM = $favorite["file"];
					print "\n\t\t\t<option value=\"pid=".$favorite["gid"]."&amp;GEDCOM=$GEDCOM\">".get_person_name($favorite["gid"]);
					if ($SHOW_ID_NUMBERS) print " (".$favorite["gid"].")";
					print "</option>";
				}
			}
			$GEDCOM = $mygedcom;
			print "</select>\n\t</form>\n";
			break;
	}
	print "</div>\n";
}


//-- function to print the details of a fact in a simple format
function print_simple_fact($indirec, $birttag, $pid) {
	global $pgv_lang, $SHOW_PEDIGREE_PLACES, $factarray;

	print "<span class=\"details_label\">";
	if (isset($pgv_lang[$birttag])) print $pgv_lang[$birttag];
	else if (isset($factarray[$birttag])) print $factarray[$birttag];
	print "</span> ";
	if (showFactDetails($birttag, $pid)) {
		$birthrec = get_sub_record(1, "1 $birttag", $indirec);
		if ($birthrec!==false) {
			$dct = preg_match("/2 DATE (.*)/", $birthrec, $match);
			if ($dct>0) print "<font class=\"date\">".get_changed_date($match[1])."</font>";
			if ($SHOW_PEDIGREE_PLACES>0) {
				$pct = preg_match("/2 PLAC (.*)/", $birthrec, $match);
				if ($pct>0) {
					print " -- ";
					$plevels = preg_split("/,/", $match[1]);
					for($plevel=0; $plevel<$SHOW_PEDIGREE_PLACES; $plevel++) {
						if (!empty($plevels[$plevel])) {
							if ($plevel>0) print ", ";
							print trim($plevels[$plevel]);
						}
					}
				}
			}
			$pct = preg_match("/2 TEMP (.*)/", $birthrec, $match);
			if ($pct>0) {
				print " -- ".$pgv_lang["temple"]." ";
				if (isset($TEMPLE_CODES[trim($match[1])])) print $TEMPLE_CODES[trim($match[1])];
				else print trim($match[1]);
			}
			$pct = preg_match("/2 STAT (.*)/", $birthrec, $match);
			if ($pct>0) {
				print " ".$pgv_lang["status"]." ";
				print trim($match[1]);
			}
		}
	}
	print "<br />\n";
}

// -- function to print details about a fact
function print_fact($factrec, $pid, $linenum) {
	global $factarray;
	global $sexarray;
	global $nonfacts, $birthyear, $birthmonth;
	global $TEMPLE_CODES;
	global $BOXFILLCOLOR;
	global $pgv_lang;
	global $WORD_WRAPPED_NOTES;
	global $HIDE_GEDCOM_ERRORS;
    global $CONTACT_EMAIL, $view, $FACT_COUNT, $monthtonum;

    $FACT_COUNT++;
    $estimates = array("abt","aft","bef","est","cir");

	$ft = preg_match("/1 (_?[A-Z]{3,5})(.*)/", $factrec, $match);
	if ($ft>0) {
		$fact = trim($match[1]);
		$event = trim($match[2]);
	}
	else {
		$fact="";
		$event="";
	}
	$styleadd="";
	$ct = preg_match("/PGV_NEW/", $factrec, $match);
	if ($ct>0) $styleadd="blue";
	$ct = preg_match("/PGV_OLD/", $factrec, $match);
	if ($ct>0) $styleadd="red";
	// -- avoid known non facts
	if (in_array($fact, $nonfacts)) return;
	if (array_key_exists($fact, $factarray)) {
		// -- handle generic facts
		if ($fact!="EVEN") {
			$factref = $fact;
			if (!showFact($factref, $pid)) return false;
			print "\n\t\t<tr>";
			print "\n\t\t\t<td class=\"facts_label$styleadd\">";
			print $factarray[$fact];
			if (userCanEdit(getUserName())&&($styleadd!="red")&&($view!="preview")) print "<br /><a href=\"#\" onclick=\"return edit_record('$pid', $linenum);\">".$pgv_lang["edit"]."</a> | <a href=\"#\" onclick=\"return delete_record('$pid', $linenum);\">".$pgv_lang["delete"]."</a>";
			print "</td>";
		}
		else {
			print "\n\t\t<tr>";
			// -- find generic type for each fact
			$ct = preg_match("/2 TYPE (.*)/", $factrec, $match);
			if ($ct>0) {
				$factref = trim($match[1]);
				if (!showFact($factref, $pid)) return false;
				if (isset($factarray["$factref"])) print "<td class=\"facts_label\">" .$factarray["$factref"];
				else print "<td class=\"facts_label$styleadd\">" . $factref;
				if (userCanEdit(getUserName())&&($styleadd!="red")&&($view!="preview")) print "<br /><a href=\"#\" onclick=\"return edit_record('$pid', $linenum);\">".$pgv_lang["edit"]."</a> | <a href=\"#\" onclick=\"return delete_record('$pid', $linenum);\">".$pgv_lang["delete"]."</a>";
				print "</td>";
			}
		}
		print "<td class=\"facts_value$styleadd\">";
		if (showFactDetails($factref, $pid)) {
			// -- find date for each fact
			$ct = preg_match("/2 DATE (.*)/", $factrec, $match);
			if (($ct>0)&&(strtoupper(trim($match[1]))!="UNKNOWN")) {
				print "<span class=\"date\">".get_changed_date($match[1]);
				if ((isset($birthyear))&&($fact!="BIRT")&&($fact!="CHAN")) {
					$bt = preg_match("/(\d\d\d\d).*(\d\d\d\d)/", $match[1], $bmatch);
					if ($bt>0) {
						$age1 = $bmatch[1]-$birthyear;
						$age2 = $bmatch[2]-$birthyear;
						print " <span class=\"age\">(".$pgv_lang["age"]." ".$pgv_lang["apx"]." ".convert_number($age1)."-".convert_number($age2).")</span>";
					}
					else {
						$bt = preg_match("/(\d\d\d\d)/", $match[1], $bmatch);
						if ($bt>0) {
							$age = $bmatch[1]-$birthyear;
							if (isset($birthmonth)) {
								$bt = preg_match("/(...) \d\d\d\d/", $match[1], $bmatch);
								if ($bt>0) {
									if (isset($monthtonum[strtolower(trim($bmatch[1]))])) {
										$emonth = $monthtonum[strtolower(trim($bmatch[1]))];
										if ($emonth<$birthmonth) $age--;
									}
								}
							}
							print " <span class=\"age\">(".$pgv_lang["age"];
							$at= preg_match("/([a-zA-Z]{3})\.?/", $match[1], $amatch);
							if ($at>0) {
								if (in_array(strtolower($amatch[1]), $estimates)) {
									print " ".$pgv_lang["apx"];
								}
							}
							print " ".convert_number($age).")</span>";
						}
					}
				}
				print "</span> ";
			}
			//-- get any cause tags
			$ct = preg_match("/2 CAUS (.*)/", $factrec, $match);
			if ($ct>0) {
				$causerec = get_sub_record(2, $match[0], $factrec);
				print $match[1];
				print get_cont(3, $causerec);
			}
			//-- print spouse name for marriage events
			if (($fact=="MARR")||($fact=="SLGS")) {
				$ct = preg_match("/PGV_SPOUSE: (.*)/", $factrec, $match);
				if ($ct>0) {
					$spouse=$match[1];
					print "<a href=\"individual.php?pid=$spouse\">";
					if (displayDetailsById($spouse)||showLivingNameById($spouse)) print get_person_name($spouse);
					else print $pgv_lang["living"];
					print "</a>";
					if ($view!="preview") print " - <a href=\"family.php?famid=$pid\">[".$pgv_lang["view_family"]."]</a><br />\n";
				}
			}
			//-- print other characterizing fact information
			if ($event!="") {
				$ct = preg_match("/@(.*)@/", $event, $match);
				if ($ct>0) {
					$gedrec = find_gedcom_record($match[1]);
					if (strstr($gedrec, "INDI")) print "<a href=\"individual.php?pid=$match[1]\">".get_person_name($match[1])."</a><br />";
					else print_submitter_info($match[1]);
				}
				else if ($fact=="ALIA") {
					//-- strip // from ALIA tag for FTM generated gedcoms
					print preg_replace("'/'", "", $event)."<br />";
				}
				else print "$event<br />";
				print get_cont(2, $factrec);
			}
			//-- find description for some facts
			$ct = preg_match("/2 DESC (.*)/", $factrec, $match);
			if ($ct>0) print $match[1];
			// -- find place for each fact
			$ct = preg_match("/2 PLAC (.*)/", $factrec, $match);
			if ($ct>0) {
				$place = trim($match[1]);
				print "<a href=\"placelist.php?action=show&amp;";
				$levels = preg_split ("/,/", $place);		// -- split the place into comma seperated values
				$levels = array_reverse($levels);				// -- reverse the array so that we get the top level first
				foreach($levels as $pindex=>$ppart) {
					//-- comment line to keep periods in places
					//$ppart = preg_replace("/\./", "", $ppart);
					print "parent[$pindex]=".urlencode(trim($ppart))."&amp;";
				}
				print "level=".count($levels);
				print "\">$place</a>";
			}
			// -- find temple code for lds facts
			$ct = preg_match("/2 TEMP (.*)/", $factrec, $match);
			if ($ct>0) {
				$tcode = $match[1];
				$tcode = trim($tcode);
				if (array_key_exists($tcode, $TEMPLE_CODES)) print $pgv_lang["temple"].": ".$TEMPLE_CODES[$tcode];
				else print $pgv_lang["temple_code"].$tcode;
			}
			// -- find status field
			$ct = preg_match("/2 STAT (.*)/", $factrec, $match);
			if ($ct>0) print "<br />".$pgv_lang["status"].": ".$match[1];

			print "<div class=\"indent\">";
			//-- print address structure
			print_address_structure($factrec, 2);
			// -- find source for each fact
			print_fact_sources($factrec, 2);

			// -- find notes for each fact
			print_fact_notes($factrec, 2);

			//-- find multimedia objects
			print_media_links($factrec, 2);
			print "</div>";
		}
		print "</td>";
		print "\n\t\t</tr>";
	}
	else {
		// -- catch all unknown codes here
		if (!$HIDE_GEDCOM_ERRORS) print "\n\t\t<tr><td class=\"facts_label$styleadd\"><span class=error>".$pgv_lang["unrecognized_code"].": $fact</span></td><td class=\"facts_value$styleadd\">$event<br />This is an error, and we would like to fix it. Please report this error to "
            . "<a href=\"mailto:$CONTACT_EMAIL?subject=error&amp;body=Unrecognized GEDCOM code '$fact'.\">" . $CONTACT_EMAIL . "</a>.</td></tr>";
	}
}
//------------------- end print fact function

function print_fact_sources($factrec, $level) {
	global $pgv_lang;
	global $factarray;
	global $WORD_WRAPPED_NOTES, $FACT_COUNT, $PGV_IMAGE_DIR, $FACT_COUNT;
	global $PGV_PLUS_IMG;

	$nlevel = $level+1;

	// -- find source for each fact
	$ct = preg_match_all("/$level SOUR @(.*)@/", $factrec, $match, PREG_SET_ORDER);
	$spos2 = 0;
	for($j=0; $j<$ct; $j++) {
		$spos1 = strpos($factrec, "$level SOUR @".$match[$j][1]."@", $spos2);
		$spos2 = strpos($factrec, "\n$level", $spos1);
		if (!$spos2) $spos2 = strlen($factrec);
		$srec = substr($factrec, $spos1, $spos2-$spos1);
		print "\n\t\t<span class=\"label\">";
		$sid = $match[$j][1];
		print "<a href=\"#\" onclick=\"expand_layer('$sid$j-$FACT_COUNT'); return false;\"><img id=\"{$sid}{$j}-{$FACT_COUNT}_img\" src=\"$PGV_IMAGE_DIR/$PGV_PLUS_IMG\" border=\"0\" width=\"11\" height=\"11\" alt=\"\" /></a> ";
		print $pgv_lang["source"];
		print "</span> <span class=\"field\"><a href=\"source.php?sid=".$match[$j][1]."\">";
		print get_source_descriptor($match[$j][1]);
		print "</a></span>";
		print "<div id=\"$sid$j-$FACT_COUNT\" class=\"source_citations\">";
		$source = find_source_record($match[$j][1]);
		if ($source) {
			$cs = preg_match("/$nlevel PAGE (.*)/", $srec, $cmatch);
			if ($cs>0) {
				print "\n\t\t\t<br /><font class=\"label\">".$pgv_lang["citation"]."</font><font class=\"field\">$cmatch[1]";
				$pagerec = get_sub_record($nlevel, $cmatch[0], $srec);
				print get_cont($nlevel+1, $pagerec);
				print "</font>";
			}
			$cs = preg_match("/$nlevel EVEN (.*)/", $srec, $cmatch);
			if ($cs>0) {
				print "<br /><font class=\"label\">".$factarray["EVEN"]." </font><font class=\"field\">".$cmatch[1]."</font>";
				$cs = preg_match("/".($nlevel+1)." ROLE (.*)/", $srec, $cmatch);
				if ($cs>0) print "\n\t\t\t<br /><font class=\"label\">".$factarray["ROLE"]." </font><font class=\"field\">$cmatch[1]</font>";
			}
			$cs = preg_match("/$nlevel DATA/", $srec, $cmatch);
			if ($cs>0) {
				//print "<br /><font class=\"label\">".$factarray["DATA"]." </font>";
				$cs = preg_match("/".($nlevel+1)." DATE (.*)/", $srec, $cmatch);
				if ($cs>0) print "\n\t\t\t<br /><font class=\"label\">".$pgv_lang["date"]." </font><font class=\"field\">".get_changed_date($cmatch[1])."</font>";
				$tt = preg_match_all("/".($nlevel+1)." TEXT (.*)/", $srec, $tmatch, PREG_SET_ORDER);
				for($k=0; $k<$tt; $k++) {
					print "<br /><font class=\"label\">".$pgv_lang["text"]." </font><font class=\"field\">".$tmatch[$k][1];
					print get_cont($nlevel+2, $srec);
					print "</font>";
				}
			}
			$cs = preg_match("/".$nlevel." DATE (.*)/", $srec, $cmatch);
			if ($cs>0) print "\n\t\t\t<br /><font class=\"label\">".$pgv_lang["date"]." </font><font class=\"field\">".get_changed_date($cmatch[1])."</font>";
			$cs = preg_match("/$nlevel QUAY (.*)/", $srec, $cmatch);
			if ($cs>0) print "<br /><font class=\"label\">".$factarray["QUAY"]." </font><font class=\"field\">".$cmatch[1]."</font>";

			$cs = preg_match_all("/$nlevel TEXT (.*)/", $srec, $tmatch, PREG_SET_ORDER);
			for($k=0; $k<$cs; $k++) {
				print "<br /><font class=\"label\">".$pgv_lang["text"]." </font><font class=\"field\">".$tmatch[$k][1];
				print get_cont($nlevel+1, $srec);
				print "</font>";
			}
			print "<div class=\"indent\">";
			print_media_links($srec, $nlevel);
			print_fact_notes($srec, $nlevel);
			print "</div>";
		}
		print "</div><br />";
	}
}

function print_main_sources($factrec, $level, $pid, $linenum) {
	global $pgv_lang;
	global $factarray, $view;
	global $WORD_WRAPPED_NOTES, $PGV_IMAGE_DIR;
	global $PGV_PLUS_IMG, $PGV_SOURCE_IMG;

	$nlevel = $level+1;

	$styleadd="";
	$ct = preg_match("/PGV_NEW/", $factrec, $match);
	if ($ct>0) $styleadd="blue";
	$ct = preg_match("/PGV_OLD/", $factrec, $match);
	if ($ct>0) $styleadd="red";

	// -- find source for each fact
	$ct = preg_match_all("/$level SOUR @(.*)@/", $factrec, $match, PREG_SET_ORDER);
	$spos2 = 0;
	for($j=0; $j<$ct; $j++) {
		$spos1 = strpos($factrec, "$level SOUR @".$match[$j][1]."@", $spos2);
		$spos2 = strpos($factrec, "\n$level", $spos1);
		if (!$spos2) $spos2 = strlen($factrec);
		$srec = substr($factrec, $spos1, $spos2-$spos1);
		if (!showFact("SOUR", $pid)) return false;
		print "\n\t\t\t<tr><td class=\"facts_label$styleadd\">";
		print "<img src=\"$PGV_IMAGE_DIR/$PGV_SOURCE_IMG\" width=\"50\" height=\"50\" alt=\"\" /><br />";
		print $pgv_lang["source"];
		if (userCanEdit(getUserName())&&($styleadd!="red")&&($view!="preview")) print "<br /><a href=\"#\" onclick=\"return edit_record('$pid', $linenum);\">".$pgv_lang["edit"]."</a> | <a href=\"#\" onclick=\"return delete_record('$pid', $linenum);\">".$pgv_lang["delete"]."</a>";
		print "</td>";
		print "\n\t\t\t<td class=\"facts_value$styleadd\">";
		if (showFactDetails("SOUR", $pid)) {
			print "<a href=\"source.php?sid=".$match[$j][1]."\">";
			print get_source_descriptor($match[$j][1]);
			print "</a>";
			$source = find_source_record($match[$j][1]);
			if ($source) {
				$cs = preg_match("/$nlevel PAGE (.*)/", $srec, $cmatch);
				if ($cs>0) {
					print "\n\t\t\t<br />".$pgv_lang["citation"]." $cmatch[1]";
					print get_cont($nlevel+1, $srec);
				}
				$cs = preg_match("/$nlevel EVEN (.*)/", $srec, $cmatch);
				if ($cs>0) {
					print "<br /><font class=\"label\">".$factarray["EVEN"]." </font><font class=\"field\">".$cmatch[1]."</font>";
					$cs = preg_match("/".($nlevel+1)." ROLE (.*)/", $srec, $cmatch);
					if ($cs>0) print "\n\t\t\t<br />&nbsp;&nbsp;&nbsp;&nbsp;<font class=\"label\">".$factarray["ROLE"]." </font><font class=\"field\">$cmatch[1]</font>";
				}
				$cs = preg_match("/$nlevel DATA/", $srec, $cmatch);
				if ($cs>0) {
					print "<br /><font class=\"label\">".$factarray["DATA"]." </font>";
					$cs = preg_match("/".($nlevel+1)." DATE (.*)/", $srec, $cmatch);
					if ($cs>0) print "\n\t\t\t<br />&nbsp;&nbsp;<font class=\"label\">".$pgv_lang["date"]." </font><font class=\"field\">$cmatch[1]</font>";
					$tt = preg_match_all("/".($nlevel+1)." TEXT (.*)/", $srec, $tmatch, PREG_SET_ORDER);
					for($k=0; $k<$tt; $k++) {
						print "<br />&nbsp;&nbsp;&nbsp;&nbsp;<font class=\"label\">".$pgv_lang["text"]." </font><font class=\"field\">".$tmatch[$k][1]."</font>";

						print get_cont($nlevel+2, $srec);
					}
				}
				$cs = preg_match("/$nlevel QUAY (.*)/", $srec, $cmatch);
				if ($cs>0) print "<br /><font class=\"label\">".$factarray["QUAY"]." </font><font class=\"field\">".$cmatch[1]."</font>";

				$cs = preg_match_all("/$nlevel TEXT (.*)/", $srec, $tmatch, PREG_SET_ORDER);
				for($k=0; $k<$cs; $k++) {
					print "<br /><font class=\"label\">".$pgv_lang["text"]." </font><font class=\"field\">".$tmatch[$k][1];
					$trec = get_sub_record($nlevel, $tmatch[$k][0], $srec);
					print get_cont($nlevel+1, $trec);
					print "</font>";
				}
				print_media_links($srec, $nlevel);
				print_fact_notes($srec, $nlevel);
			}
		}
		print "</td></tr>";
	}
}

//-- Print all of the notes in this fact record
function print_fact_notes($factrec, $level) {
	global $pgv_lang;
	global $factarray;
	global $WORD_WRAPPED_NOTES;

	$nlevel = $level+1;
	$ct = preg_match_all("/$level NOTE(.*)/", $factrec, $match, PREG_SET_ORDER);
	for($j=0; $j<$ct; $j++) {
		$spos1 = strpos($factrec, $match[$j][0]);
		$spos2 = strpos($factrec, "\n$level", $spos1+1);
		if (!$spos2) $spos2 = strlen($factrec);
		$nrec = substr($factrec, $spos1, $spos2-$spos1);
		print "\n\t\t<font class=\"label\">".$pgv_lang["note"]." </font><font class=\"field\">";
		$nt = preg_match("/@(.*)@/", $match[$j][1], $nmatch);
		if ($nt==0) {
			//-- print embedded note records
			$text = preg_replace("/~~/", "<br />", trim($match[$j][1]));
			$text .= get_cont($nlevel, $nrec);
			$text = preg_replace("'(http://[\w\./\-&=?]*)'", "<a href=\"$1\" target=\"blank\">$1</a>", $text);
			print $text;
		}
		else {
			//-- print linked note records
			$noterec = find_gedcom_record($nmatch[1]);
			$nt = preg_match("/0 @$nmatch[1]@ NOTE (.*)/", $noterec, $n1match);
			$text ="";
			if ($nt>0) $text = preg_replace("/~~/", "<br />", trim($n1match[1]));
			$text .= get_cont(1, $noterec);
			$text = preg_replace("'(https?://[\w\./\-&=?]*)'", "<a href=\"$1\" target=\"blank\">$1</a>", $text);
			print $text;
			print_fact_sources($noterec, 1);
		}
		print "</font><div class=\"indent\">";
		print_fact_sources($nrec, $nlevel);
		print "</div>";
	}
}

function print_main_notes($factrec, $level, $pid, $linenum) {
	global $pgv_lang;
	global $factarray, $view;
	global $WORD_WRAPPED_NOTES, $PGV_IMAGE_DIR;
	global $PGV_NOTES_IMG, $PGV_MEDIA_IMG;

	$styleadd="";
	$ct = preg_match("/PGV_NEW/", $factrec, $match);
	if ($ct>0) $styleadd="blue";
	$ct = preg_match("/PGV_OLD/", $factrec, $match);
	if ($ct>0) $styleadd="red";

	$nlevel = $level+1;
	$ct = preg_match_all("/$level NOTE(.*)/", $factrec, $match, PREG_SET_ORDER);
	for($j=0; $j<$ct; $j++) {
		$spos1 = strpos($factrec, "$level NOTE ".$match[$j][1]);
		$spos2 = strpos($factrec, "\n$level", $spos1);
		if (!$spos2) $spos2 = strlen($factrec);
		$nrec = substr($factrec, $spos1, $spos2-$spos1);
		if (!showFact("NOTE", $pid)) return false;
		print "\n\t\t<tr><td valign=\"top\" class=\"facts_label$styleadd\"><img src=\"$PGV_IMAGE_DIR/$PGV_NOTES_IMG\" width=\"50\" height=\"50\" alt=\"\" /><br /><font class=\"label\">".$pgv_lang["note"];
		if (userCanEdit(getUserName())&&($styleadd!="red")&&($view!="preview")) print "<br /><a href=\"#\" onclick=\"return edit_record('$pid', $linenum);\">".$pgv_lang["edit"]."</a> | <a href=\"#\" onclick=\"return delete_record('$pid', $linenum);\">".$pgv_lang["delete"]."</a>";
		print " </font></td><td class=\"facts_value$styleadd\">";
		if (showFactDetails("NOTE", $pid)) {
			$nt = preg_match("/@(.*)@/", $match[$j][1], $nmatch);
			if ($nt==0) {
				//-- print embedded note records
				$text = preg_replace("/~~/", "<br />", trim($match[$j][1]));
				$text .= get_cont($nlevel, $nrec);
				$text = preg_replace("'(http://[\w\./\-&=?]*)'", "<a href=\"$1\" target=\"blank\">$1</a>", $text);
				print $text;
			}
			else {
				//-- print linked note records
				$noterec = find_gedcom_record($nmatch[1]);
				$nt = preg_match("/0 @$nmatch[1]@ NOTE (.*)/", $noterec, $n1match);
				$text ="";
				if ($nt>0) $text = preg_replace("/~~/", "<br />", trim($n1match[1]));
				$text .= get_cont(1, $noterec);
				$text = preg_replace("'(https?://[\w\./\-&=?]*)'", "<a href=\"$1\" target=\"blank\">$1</a>", $text);
				print $text;
				print_fact_sources($noterec, 1);
			}
			print_fact_sources($nrec, $nlevel);
		}
		print "</td></tr>";
	}
}

//-- Print the links to multi-media objects
function print_main_media($factrec, $level, $pid, $linenum) {
  global $MULTI_MEDIA;
	global $pgv_lang;
	global $factarray, $view;
	global $WORD_WRAPPED_NOTES, $MEDIA_DIRECTORY, $PGV_IMAGE_DIR, $PGV_MEDIA_IMG;;

    if( !$MULTI_MEDIA ) return;

    $styleadd="";
	$ct = preg_match("/PGV_NEW/", $factrec, $match);
	if ($ct>0) $styleadd="blue";
	$ct = preg_match("/PGV_OLD/", $factrec, $match);
	if ($ct>0) $styleadd="red";

	$nlevel = $level+1;

	$ct = preg_match_all("/$level OBJE(.*)/", $factrec, $omatch, PREG_SET_ORDER);
	for($i=0; $i<$ct; $i++) {
		$thumbnail="";
		$filename="";
		if (!showFact("OBJE", $pid)) return false;
		$spos1 = strpos($factrec, "$level OBJE".$omatch[$i][1]);
		$spos2 = strpos($factrec, "\n$level", $spos1);
		if (!$spos2) $spos2 = strlen($factrec);
		$orec = substr($factrec, $spos1, $spos2-$spos1);
		$nt = preg_match("/@(.*)@/", $omatch[$i][1], $nmatch);
		if ($nt==0) {
			$tt = preg_match("/$nlevel TITL (.*)/", $orec, $match);
			preg_match("/$nlevel _*FILE (.*)/", $orec, $amatch);
			$fullpath = extract_fullpath($orec);
			$filename = "";
			if ((strstr( $fullpath, "://"))||(strstr( $fullpath, "mailto:"))) $filename=$fullpath;
			else {
				$filename = extract_filename($fullpath);
				$thumbnail = $MEDIA_DIRECTORY."thumbs/".$filename;
				$thumbnail = trim($thumbnail);
				$filename = $MEDIA_DIRECTORY.$filename;
				$filename = trim($filename);
			}
			if ($tt>0) $title = trim($match[1]);
			if (empty($title)) $title = $filename;
		}
		//-- look for a matching record
		else {
			$objrec = find_gedcom_record($nmatch[1]);
			if ($objrec) {
				$tt = preg_match("/1 TITL (.*)/", $objrec, $match);
				$ft = preg_match("/1 _*FILE (.*)/", $objrec, $amatch);
				if ($tt>0) $title = trim($match[1]);
				if (empty($title)) $title = $filename;
				if ($ft>0) {
					$fullpath = trim($amatch[1]);
					$filename = "";
					if ((strstr( $fullpath, "://"))||(strstr( $fullpath, "mailto:"))) $filename=$fullpath;
					else {
						$filename = extract_filename($fullpath);
						$thumbnail = $MEDIA_DIRECTORY."thumbs/".$filename;
						$thumbnail = trim($thumbnail);
						$filename = $MEDIA_DIRECTORY.$filename;
						$filename = trim($filename);
					}
				}
			}
			else {
				return false;
			}
		}
		$imgwidth = 0;
		$imgheight = 0;
		if ((preg_match("'://'", $MEDIA_DIRECTORY)>0)||(file_exists(filename_decode($filename)))) {
			$imgsize = @getimagesize(filename_decode($filename));
			if ($imgsize) {
				$imgwidth = $imgsize[0]+50;
				$imgheight = $imgsize[1]+50;
			}
			else {
				$imgwidth = 300;
				$imgheight = 300;
			}
		}
		else if (preg_match("'://'", $filename)>0) {
			$imgwidth = 500;
			$imgheight = 700;
		}
		if ($imgwidth<300) $imgwidth = 300;
		if ($imgheight<300) $imgheight = 300;

		if (empty($thumbnail)) $thumbnail = "$PGV_IMAGE_DIR/$PGV_MEDIA_IMG";
		print "\n\t\t<tr><td class=\"facts_label$styleadd\"><img src=\"$PGV_IMAGE_DIR/$PGV_MEDIA_IMG\" width=\"50\" height=\"50\" alt=\"\" /><br /><font class=label>".$factarray["OBJE"];
		if (userCanEdit(getUserName())&&($styleadd!="red")&&($view!="preview")) print "<br /><a href=\"#\" onclick=\"return edit_record('$pid', $linenum);\">".$pgv_lang["edit"]."</a> | <a href=\"#\" onclick=\"return delete_record('$pid', $linenum);\">".$pgv_lang["delete"]."</a>";
		print "</font>";
		print "</td><td class=\"facts_value$styleadd\"><font class=\"field\">";
		if (showFactDetails("OBJE", $pid)) {
			if ((preg_match("'://'", $MEDIA_DIRECTORY)>0)||(file_exists(filename_decode($thumbnail)))) print "<a href=\"#\" onclick=\"return openImage('".$filename."',$imgwidth, $imgheight);\"><img src=\"$thumbnail\" border=\"0\" align=\"left\" class=\"thumbnail\" alt=\"\" /></a>";
			print "<a href=\"#\" onclick=\"return openImage('".$filename."',$imgwidth, $imgheight);\">";
			print "<i>$title</i></a>";
			$tt = preg_match("/$nlevel FORM (.*)/", $orec, $match);
			if ($tt>0) print "\n\t\t\t<br /><font class=\"label\">".$factarray["FORM"]."</font> <font class=\"field\">$match[1]</font>";
			print "</font>";
			print "<br />\n";
			print_fact_notes($orec, $nlevel);
		}
		print "</td></tr>";
	} //-- end for loop
}
//-- Print the links to multi-media objects
function print_media_links($factrec, $level) {
    global $MULTI_MEDIA;
	global $pgv_lang;
	global $factarray;
	global $WORD_WRAPPED_NOTES, $MEDIA_DIRECTORY;
	global $PGV_IMAGE_DIR, $PGV_MEDIA_IMG;

    if( !$MULTI_MEDIA )
        return;

	$nlevel = $level+1;

	if ($level==1) $size=50;
	else $size=25;

	$ct = preg_match_all("/$level OBJE(.*)/", $factrec, $omatch, PREG_SET_ORDER);
	$spos2 = 0;
	for($i=0; $i<$ct; $i++) {
		$thumbnail="";
		$filename="";
		$spos1 = strpos($factrec, $omatch[$i][0], $spos2);
		$spos2 = strpos($factrec, "\n$level", $spos1+1);
		if (!$spos2) $spos2 = strlen($factrec);
		$orec = substr($factrec, $spos1, $spos2-$spos1);
		$nt = preg_match("/@(.*)@/", $omatch[$i][1], $nmatch);
		if ($nt==0) {
			$tt = preg_match("/$nlevel TITL (.*)/", $orec, $match);
			preg_match("/$nlevel _*FILE (.*)/", $orec, $amatch);
			$fullpath = extract_fullpath($orec);
			$filename = "";
			if ((strstr( $fullpath, "://"))||(strstr( $fullpath, "mailto:"))) $filename=$fullpath;
			else {
				$filename = extract_filename($fullpath);
				$thumbnail = $MEDIA_DIRECTORY."thumbs/".$filename;
				$thumbnail = trim($thumbnail);
				$filename = $MEDIA_DIRECTORY.$filename;
				$filename = trim($filename);
			}
			if ($tt>0) $title = trim($match[1]);
			if (empty($title)) $title = $filename;
		}
		//-- look for a matching record
		else {
			$objrec = find_gedcom_record($nmatch[1]);
			if ($objrec) {
				$tt = preg_match("/1 TITL (.*)/", $objrec, $match);
				$ft = preg_match("/1 _*FILE (.*)/", $objrec, $amatch);
				if ($ft>0) {
					$fullpath = extract_fullpath($objrec);
					$filename = "";
					if ((strstr( $fullpath, "://"))||(strstr( $fullpath, "mailto:"))) $filename=$fullpath;
					else {
						$filename = extract_filename($fullpath);
						$thumbnail = $MEDIA_DIRECTORY."thumbs/".$filename;
						$thumbnail = trim($thumbnail);
						$filename = $MEDIA_DIRECTORY.$filename;
						$filename = trim($filename);
					}
					if ($tt>0) $title = trim($match[1]);
					if (empty($title)) $title = $filename;
				}
			}
		}
		if ((preg_match("'://'", $MEDIA_DIRECTORY)>0)||(file_exists(filename_decode($filename)))) {
			$imgsize = getimagesize(filename_decode($filename));
			$imgwidth = $imgsize[0]+50;
			$imgheight = $imgsize[1]+50;
		}
		else if (preg_match("'://'", $filename)>0) {
			$imgwidth = 500;
			$imgheight = 700;
		}
		else {
			$imgwidth = 300;
			$imgheight = 300;
		}
		if (empty($thumbnail)) $thumbnail = "$PGV_IMAGE_DIR/$PGV_MEDIA_IMG";
		if ((preg_match("'://'", $MEDIA_DIRECTORY)>0)||(file_exists(filename_decode($thumbnail)))) print "\n\t\t<table width=\"100%\"><tr><td valign=\"top\"><a href=\"#\" onclick=\"return openImage('".$filename."',$imgwidth, $imgheight);\"><img src=\"$thumbnail\" border=\"0\" align=\"left\" class=\"thumbnail\" alt=\"\" /></a></td><td>";
		else print "<br />";
		print "<font class=label>".$factarray["OBJE"].": </font><font class=field>";
		print "<a href=\"#\" onclick=\"return openImage('".$filename."',$imgwidth, $imgheight);\">";
		print "<i>$title</i></a>";
		$tt = preg_match("/$nlevel FORM (.*)/", $orec, $match);
		if ($tt>0) print "\n\t\t\t<font class=\"label\"><br />".$factarray["FORM"]."</font> <font class=\"field\">$match[1]</font>";
		print "</font>";
		print "<br />\n";
		print_fact_notes($orec, $nlevel);
		if ((preg_match("'://'", $MEDIA_DIRECTORY)>0)||(file_exists(filename_decode($thumbnail)))) print "</td></tr></table>";
	} //-- end for loop
}

//-- print the address structure in the given record
function print_address_structure($factrec, $level) {
	global $pgv_lang;
	global $factarray;
	global $WORD_WRAPPED_NOTES;

	$nlevel = $level+1;

	$ct = preg_match_all("/$level ADDR(.*)/", $factrec, $omatch, PREG_SET_ORDER);
	for($i=0; $i<$ct; $i++) {
		print "\n\t\t<br /><font class=label>".$factarray["ADDR"].": </font><br /><div class=\"indent\">";
		print $omatch[$i][1];
		print get_cont($nlevel, $factrec);
		$cs = preg_match("/$nlevel ADR1 (.*)/", $factrec, $cmatch);
		if ($cs>0) print "<br />".$cmatch[1]."";
		$cs = preg_match("/$nlevel ADR2 (.*)/", $factrec, $cmatch);
		if ($cs>0) print "<br />".$cmatch[1]."";
		$cs = preg_match("/$nlevel CITY (.*)/", $factrec, $cmatch);
		if ($cs>0) print "<br />".$cmatch[1]."";
		$cs = preg_match("/$nlevel STAE (.*)/", $factrec, $cmatch);
		if ($cs>0) print ", ".$cmatch[1]."";
		$cs = preg_match("/$nlevel POST (.*)/", $factrec, $cmatch);
		if ($cs>0) print "  ".$cmatch[1]."";
		$cs = preg_match("/$nlevel POST (.*)/", $factrec, $cmatch);
		if ($cs>0) print "<br />".$cmatch[1]."";
		print "</div>";
	}
	$ct = preg_match_all("/$level PHON (.*)/", $factrec, $omatch, PREG_SET_ORDER);
	if ($ct>0) {
		print "\n\t\t<br />";
		for($i=0; $i<$ct; $i++) {
			print "<font class=label>".$factarray["PHON"].": </font><font class=field>";
			print $omatch[$i][1];
			print "</font>";
		}
	}
}

//-- function to print a privacy error with contact method
function print_privacy_error($username) {
	global $pgv_lang, $CONTACT_METHOD, $SUPPORT_METHOD, $WEBMASTER_EMAIL;
	$method = $CONTACT_METHOD;
	if ($username==$WEBMASTER_EMAIL) $method = $SUPPORT_METHOD;

	$user = getUser($username);
	if (!$user) $method = "mailto";

	print "<br /><font class=\"error\">".$pgv_lang["privacy_error"];
	if ($method=="none") {
		print "</font><br />\n";
		return;
	}
	print $pgv_lang["more_information"];
	if ($method=="mailto") {
		if (!$user) {
			$email = $username;
			$fullname = $username;
		}
		else {
			$email = $user["email"];
			$fullname = $user["fullname"];
		}
		print " <a href=\"mailto:$email\">".$fullname."</a></font><br />";
	}
	else {
		print " <a href=\"#\" onclick=\"message('$username','$method'); return false;\">".$user["fullname"]."</a></font><br />";
	}
}

// Function to print popup help boxes
function print_help_link($help, $helpText) {
	global $SHOW_CONTEXT_HELP, $pgv_lang,$view;
	if (($SHOW_CONTEXT_HELP)&&($view!="preview")){
		print "<a class=\"help\" tabindex=\"-1\" href=\"#\" onclick=\"return helpPopup('$help');\">".$pgv_lang[$helpText]."</a>";
	}
}
function print_help_text($help){
	global $pgv_lang;
	$sentence = $pgv_lang[$help];
	$mod_sentence = "";
	$replace = "";
	$replace_text = "";
	$sub = "";
	$pos1 = 0;
	$pos2 = 0;
	while (stristr($sentence, "#") == TRUE){
		$pos1 = strpos($sentence, "#");
		$mod_sentence = substr_replace($sentence, " ", $pos1, 1);
		$pos2 = strpos($mod_sentence, "#");
		$replace = substr($sentence, ($pos1+1), ($pos2-$pos1-1));
		$sub = preg_replace(array("[pgv_lang\\[]","(])"), array("",""), $replace);
		$replace_text = $pgv_lang[$sub];
		$sentence = str_replace("#".$replace."#", $replace_text, $sentence);
	}
	print $sentence;
}
?>
