<?php
/*=================================================
	Project: phpGedView
	File: gdbi_changes.php
	Author: John Finlay
	Comments:
		Interface to review/accept/reject changes made
		through the GDBI interface functions.

	phpGedView: Genealogy Viewer
    Copyright (C) 2002 to 2003  John Finlay and Others

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
    
===================================================*/
# $Id: gdbi_changes.php,v 1.13 2003/12/12 15:54:06 yalnifj Exp $

require "config.php";
require "gdbi_functions.php";
require $INDEX_DIRECTORY."pgv_changes.php";
require($PGV_BASE_DIRECTORY.$factsfile["english"]);
require($PGV_BASE_DIRECTORY.$factsfile[$LANGUAGE]);

if (!userIsAdmin(getUserName())) {
	header("Location: login.php?url=gdbi_changes.php");
	exit;
}

if (empty($action)) $action="";

print_header("Review Gedcom Changes");
print "<script langauge=\"JavaScript\" type=\"text/javascript\">\n";
print "		function show_gedcom_record(xref) {\n";
print "			var recwin = window.open(\"gedrecord.php?fromfile=1&pid=\"+xref, \"\", \"top=50,left=50,width=300,height=400,scrollbars=1,scrollable=1,resizable=1\");\n";
print "		}\n";
print "</script>\n";
print "<center>\n";
print "<font class=\"subheaders\">".$pgv_lang["review_changes"]."</font><br /><br />\n";

if ($action=="undo") {
	if (undo_change($cid, $index)) print "<b>".$pgv_lang["undo_successful"]."</b><br /><br />";
}
print $pgv_lang["accept_gedcom"];
print "<table class=\"list_table\"><tr><td class=\"list_value\">";
$changedgedcoms = array();
foreach($pgv_changes as $cid=>$changes) {
	for($i=0; $i<count($changes); $i++) {
		$change = $changes[$i];
		if ($i==0) {
			$changedgedcoms[$change["gedcom"]] = true;
			if ($GEDCOM != $change["gedcom"]) {
				$GEDCOM = $change["gedcom"];
			}
			$gedrec = find_record_in_file($change["gid"]);
			if (empty($gedrec)) $gedrec = $change["undo"];
			$ct = preg_match("/0 @(.*)@(.*)/", $gedrec, $match);
			$type = trim($match[2]);
			if($type=="INDI") print "<b>".get_sortable_name($change["gid"])."</b><br />\n";
			else if ($type=="FAM") print "<b>".get_family_descriptor($change["gid"])."</b><br />\n";
			else if ($type=="SOUR") print "<b>".get_source_descriptor($change["gid"])."</b><br />\n";
			else print "<b>".$factarray[$type]."</b><br />\n";
			print "<div class=\"indent\">\n";
			print $pgv_lang["changes_occurred"]."<br />\n";
		}
		print $pgv_lang["type"].": ".$change["type"]."<br />\n";
		print $pgv_lang["username"]." ".$change["user"]."<br />\n";
		print $pgv_lang["date"].": ".date("h:i:s j-m-Y", $change["time"])."<br />\n";
		print "Gedcom: ".$change["gedcom"]."<br />\n";
		if ($i==count($changes)-1) {
			print "<a href=\"gdbi_changes.php?action=undo&cid=$cid&index=$i\">".$pgv_lang["undo"]."</a> | ";
			print "<a href=\"javascript:show_gedcom_record('".$change["gid"]."');\">".$pgv_lang["view_gedcom"]."</a><br />";
			if ($type=="INDI") print "<br /><a href=\"individual.php?pid=".$change["gid"]."&GEDCOM=".$change["gedcom"]."&show_changes=yes\">".$pgv_lang["view_change_diff"]."</a><br />\n";
			print "</div><br />";
		}
	}
}
print "</td></tr></table>";
print "<br /><br /><table class=\"list_table\"><tr><td class=\"list_label\">".$pgv_lang["ged_import"]."</td></tr><tr><td class=\"list_value\">";
foreach($changedgedcoms as $ged=>$value) {
	print "<a href=\"importgedcom.php?ged=$ged\">$ged - ".$pgv_lang["ged_import"]."</a><br />\n";
}
print "</td></tr></table>";
print "<br /><br /><br />\n</center>\n";
print_footer();
?>