<?php
/*=================================================
	Project: phpGedView
	File: gdbi_functions.php
	Author:
		John Finlay		(yalnifj)
	Comments:
		Various functions used by the GDBI interface

	Change Log:
		4/29/03 - File Created

    phpGedView: Genealogy Viewer
    Copyright (C) 2002 to 2003  John Finlay and Others

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

===================================================*/
# $Id: gdbi_functions.php,v 1.31.2.1 2004/01/26 22:33:33 yalnifj Exp $
if (strstr($_SERVER["PHP_SELF"],"functions")) {
	print "Now, why would you want to do that.  You're not hacking are you?";
	exit;
}

//-- read the file onto the stack
read_gedcom_file();

//-------------------------------------------- newConnection
//-- this function creates a new unique connection
//-- and adds it to the connections file
//-- it returns the connection identifier
function newConnection() {
	return session_name()."\t".session_id()."\n";
}

//-------------------------------------------- get_next_record
//-- gets the next person in the gedcom, if we reach the end then
//-- returns false
function get_next_xref($gid, $type='INDI') {
	global $GEDCOM, $myindilist, $pgv_changes;

	if (!isset($myindilist[$gid])) {
		print "ERROR 4: Could not find gedcom record with xref:$gid\n";
		return false;
	}
	$found = false;
	foreach($myindilist as $key=>$value) {
		if ($found) {
			return $key;
		}
		if ($key==$gid) $found=true;
	}
	//print "ERROR 14: Reached the end of the list\n";
	return "";
}

//-------------------------------------------- get_prev_record
//-- gets the previous person in the gedcom, if we reach the start then
//-- returns the last record
function get_prev_xref($gid, $type='INDI') {
	global $GEDCOM, $myindilist, $pgv_changes;

	if (!isset($myindilist[$gid])) {
		print "ERROR 4: Could not find gedcom record with xref:$gid\n";
		return false;
	}
	$found = false;
	foreach($myindilist as $key=>$value) {
		if ($key==$gid) $found=true;
		if ($found) {
			if (isset($prev)) {
				return $prevkey;
			}
			else {
				//print "ERROR 15: Reached the beginning of the list\n";
				return "";
			}
		}
		$prev = $value;
		$prevkey = $key;
	}
	//print "ERROR 14: Reached the end of the list\n";
	return "";
}

//-------------------------------------------- replace_gedrec
//-- This function will replace a gedcom record with
//-- a the id $gid with the $gedrec
function replace_gedrec($gid, $gedrec) {
	global $fcontents, $GEDCOM, $pgv_changes;
	$pos1 = strpos($fcontents, "0 @$gid@");
	if ($pos1===false) {
		print "ERROR 4: Could not find gedcom record with xref:$gid\n";
		return false;
	}
	if (check_gedcom($gedrec)) {
		$pos2 = strpos($fcontents, "0 @", $pos1+1);
		if ($pos2===false) $pos2=strlen($fcontents);
		$undo = substr($fcontents, $pos1, $pos2-$pos1);
		$fcontents = substr($fcontents, 0,$pos1).trim($gedrec)."\r\n".substr($fcontents, $pos2);
		$change = array();
		$change["gid"] = $gid;
		$change["gedcom"] = $GEDCOM;
		$change["type"] = "replace";
		$change["status"] = "submitted";
		$change["user"] = getUserName();
		$change["time"] = time();
		$change["undo"] = $undo;
		if (!isset($pgv_changes[$gid."_".$GEDCOM])) $pgv_changes[$gid."_".$GEDCOM] = array();
		$pgv_changes[$gid."_".$GEDCOM][] = $change;
		AddToLog("Replacing gedcom record $gid ->" . getUserName() ."<-");
		return write_file();
	}
	return false;
}

//-------------------------------------------- append_gedrec
//-- this function will append a new gedcom record at
//-- the end of the gedcom file.
function append_gedrec($gedrec) {
	global $fcontents, $GEDCOM, $pgv_changes;

	if (check_gedcom($gedrec)) {
		$ct = preg_match("/0 @(.*)@ (.*)/", $gedrec, $match);
		$gid = $match[1];
		$type = trim($match[2]);
		$xref = get_new_xref($type);
		$gedrec = preg_replace("/0 @$gid@/", "0 @$xref@", $gedrec);
		$pos1 = strrpos($fcontents, "0");
		$fcontents = substr($fcontents, 0, $pos1).trim($gedrec)."\r\n".substr($fcontents, $pos1);
		$change = array();
		$change["gid"] = $xref;
		$change["gedcom"] = $GEDCOM;
		$change["type"] = "append";
		$change["status"] = "submitted";
		$change["user"] = getUserName();
		$change["time"] = time();
		$change["undo"] = "";
		if (!isset($pgv_changes[$xref."_".$GEDCOM])) $pgv_changes[$xref."_".$GEDCOM] = array();
		$pgv_changes[$xref."_".$GEDCOM][] = $change;
		AddToLog("Appending new $type record $gid ->" . getUserName() ."<-");
		if (write_file()) return $xref;
		else return false;
	}
	return false;
}

//-------------------------------------------- get_new_xref
//-- get the next available xref
function get_new_xref($type='INDI') {
	global $fcontents;

	$ct = preg_match_all("/0 @(.*)@ $type/", $fcontents, $match, PREG_SET_ORDER);
	$num = 0;
	for($i=0; $i<$ct; $i++) {
		$ckey = $match[$i][1];
		$bt = preg_match("/(\d+)/", $ckey, $bmatch);
		if ($bt>0) {
			$bnum = trim($bmatch[1]);
			if ($num < $bnum) $num = $bnum;
		}
	}
	$num++;
	$key = $type{0}."$num";
	return $key;
}

//-------------------------------------------- delete_gedrec
//-- this function will delete the gedcom record with
//-- the given $gid
function delete_gedrec($gid) {
	global $fcontents, $GEDCOM, $pgv_changes;
	$pos1 = strpos($fcontents, "0 @$gid@");
	if ($pos1===false) {
		print "ERROR 4: Could not find gedcom record with xref:$gid\n";
		return false;
	}
	$pos2 = strpos($fcontents, "0 @", $pos1+1);
	if ($pos2===false) $pos2=strpos($fcontents, "0 TRLR", $pos1+1);
	$undo = substr($fcontents, $pos1, $pos2-$pos1);
	$fcontents = substr($fcontents, 0,$pos1).substr($fcontents, $pos2);
	$change = array();
	$change["gid"] = $gid;
	$change["gedcom"] = $GEDCOM;
	$change["type"] = "delete";
	$change["status"] = "submitted";
	$change["user"] = getUserName();
	$change["time"] = time();
	$change["undo"] = $undo;
	if (!isset($pgv_changes[$gid."_".$GEDCOM])) $pgv_changes[$gid."_".$GEDCOM] = array();
	$pgv_changes[$gid."_".$GEDCOM][] = $change;
	AddToLog("Deleting gedcom record $gid ->" . getUserName() ."<-");
	return write_file();
}

//-------------------------------------------- check_gedcom
//-- this function will check a GEDCOM record for valid gedcom format
function check_gedcom($gedrec) {
	$ct = preg_match("/0 @(.*)@ (.*)/", $gedrec, $match);
	if ($ct==0) {
		print "ERROR 20: Invalid GEDCOM 5.5 format.\n";
		return false;
	}
	return true;
}

//-------------------------------------------- undo_change
//-- this function will undo a change in the gedcom file
function undo_change($cid, $index) {
	global $fcontents, $pgv_changes, $GEDCOMS, $GEDCOM;

	if (isset($pgv_changes[$cid])) {
		$changes = $pgv_changes[$cid];
		$change = $changes[$index];
		$change["undo"] = stripslashes($change["undo"]);
		if ($GEDCOM != $change["gedcom"]) {
			$GEDCOM = $change["gedcom"];
			read_gedcom_file();
		}
		if ($change["type"]=="delete") {
			$pos1 = strrpos($fcontents, "0");
			$fcontents = substr($fcontents, 0, $pos1).trim($change["undo"])."\r\n".substr($fcontents, $pos1);
		}
		else if ($change["type"]=="append") {
			$pos1 = strpos($fcontents, "0 @".$change["gid"]."@");
			if ($pos1===false) {
				print "ERROR 4: Could not find gedcom record with gid:".$change["gid"]."\n";
				return false;
			}
			$pos2 = strpos($fcontents, "0 @", $pos1+1);
			if ($pos2===false) $pos2=strpos($fcontents, "0 TRLR", $pos1+1);
			$fcontents = substr($fcontents, 0,$pos1).substr($fcontents, $pos2);
		}
		else if ($change["type"]=="replace") {
			$pos1 = strpos($fcontents, "0 @".$change["gid"]."@");
			if ($pos1===false) {
				print "ERROR 4: Could not find gedcom record with gid:".$change["gid"]."\n";
				return false;
			}
			$pos2 = strpos($fcontents, "0 @", $pos1+1);
			if ($pos2===false) $pos2=strlen($fcontents);
			$fcontents = substr($fcontents, 0,$pos1).trim($change["undo"])."\r\n".substr($fcontents, $pos2);
		}
		unset($changes[$index]);
		if (count($pgv_changes[$cid])==0) unset($pgv_changes[$cid]);
		else $pgv_changes[$cid] = $changes;
		AddToLog("Undoing change $cid - $index ".$change["type"]." ->" . getUserName() ."<-");
		return write_file();
	}
	return false;
}

//-------------------------------------------- write_file
//-- this function writes the $fcontents back to the
//-- gedcom file
function write_file() {
	global $fcontents, $GEDCOMS, $GEDCOM, $pgv_changes, $INDEX_DIRECTORY;

	if (preg_match("/win/i", PHP_OS)==0) {
		$fcontents = preg_replace('/\r/', "\n", $fcontents);
		$fcontents = preg_replace('/\n+/', "\n", $fcontents);
	}
	else {
		$fcontents = preg_replace('/([^\r])\n/', "$1\r\n", $fcontents);
	}
	$fcontents = preg_replace('/\\+/', "\\", $fcontents);
	if (preg_match("/0 TRLR/", $fcontents)==0) $fcontents.="0 TRLR";
	//-- write the gedcom file
	if (!is_writable($GEDCOMS[$GEDCOM]["path"])) {
		print "ERROR 5: GEDCOM file is not writable.  Unable to complete request.\n";
		return false;
	}
	$fp = fopen($GEDCOMS[$GEDCOM]["path"], "wb");
	if ($fp===false) {
		print "ERROR 6: Unable to open GEDCOM file resource.  Unable to complete request.\n";
		return false;
	}
	$fw = fwrite($fp, $fcontents);
	if ($fw===false) {
		print "ERROR 7: Unable to write to GEDCOM file.\n";
		fclose($fp);
		return false;
	}
	fclose($fp);

	return write_changes();
}

function print_indi_form($nextaction, $famid, $namerec="", $tag="CHIL") {
	global $pgv_lang, $factarray, $pid;
	?>
	<script language="JavaScript">
	function updatewholename() {
		frm = document.addchildform;
		frm.NAME.value = frm.NPFX.value + " " + frm.GIVN.value + " /" + frm.SURN.value + "/ " + frm.NSFX.value;
	}
	function checkform() {
		frm = document.addchildform;
		if (frm.GIVN.value=="") {
			alert('<?php print $pgv_lang["must_provide"].$pgv_lang["given_name"]; ?>');
			frm.GIVN.focus();
			return false;
		}
		if (frm.SURN.value=="") {
			alert('<?php print $pgv_lang["must_provide"].$pgv_lang["surname"]; ?>');
			frm.SURN.focus();
			return false;
		}
		if (frm.NAME.value=="") {
			alert('<?php print $pgv_lang["must_provide"].$factarray["NAME"]; ?>');
			frm.NAME.focus();
			return false;
		}
		return true;
	}
	</script>
	<?php
	print "<form method=\"post\" name=\"addchildform\" onsubmit=\"return checkform();\">\n";
	print "<input type=\"hidden\" name=\"action\" value=\"$nextaction\">\n";
	print "<input type=\"hidden\" name=\"famid\" value=\"$famid\">\n";
	print "<input type=\"hidden\" name=\"pid\" value=\"$pid\">\n";
	print "<input type=\"hidden\" name=\"tag\" value=\"$tag\">\n";
	print "<table class=\"facts_table\">";
	//-- prefix
	$name = "";
	$nt = preg_match("/\d NPFX (.*)/", $namerec, $nmatch);
	if ($nt>0) $name = trim($nmatch[1]);
	print "<tr><td class=\"facts_label\">".$factarray["NAME"]." ".$factarray["NPFX"].":</td>\n";
	print "<td class=\"facts_value\"><input type=\"text\" name=\"NPFX\" value=\"$name\" onchange=\"updatewholename();\"></td></tr>\n";
	//-- given name
	$name = "";
	$nt = preg_match("/\d GIVN (.*)/", $namerec, $nmatch);
	if ($nt>0) $name = trim($nmatch[1]);
	print "<tr><td class=\"facts_label\">".$pgv_lang["given_name"]."</td>";
	print "<td class=\"facts_value\"><input type=\"text\" name=\"GIVN\" value=\"$name\" onchange=\"updatewholename();\"></td></tr>\n";
	//-- nickname
	$name = "";
	$nt = preg_match("/\d NICK (.*)/", $namerec, $nmatch);
	if ($nt>0) $name = trim($nmatch[1]);
	print "<tr><td class=\"facts_label\">".$factarray["NICK"].":</td>";
	print "<td class=\"facts_value\"><input type=\"text\" name=\"NICK\" value=\"$name\" onchange=\"updatewholename();\"></td></tr>\n";
	//-- surname
	$name = "";
	$nt = preg_match("/\d SURN (.*)/", $namerec, $nmatch);
	if ($nt>0) $name = trim($nmatch[1]);
	print "<tr><td class=\"facts_label\">".$pgv_lang["surname"]."</td>";
	print "<td class=\"facts_value\"><input type=\"text\" name=\"SURN\" value=\"".stripslashes($name)."\" onchange=\"updatewholename();\"></td></tr>\n";
	//-- suffix
	$name = "";
	$nt = preg_match("/\d NSFX (.*)/", $namerec, $nmatch);
	if ($nt>0) $name = trim($nmatch[1]);
	print "<tr><td class=\"facts_label\">".$pgv_lang["suffix"]."</td>";
	print "<td class=\"facts_value\"><input type=\"text\" name=\"NSFX\" value=\"$name\" onchange=\"updatewholename();\"></td></tr>\n";
	//-- whole name
	$name = "";
	$nt = preg_match("/\d NAME (.*)/", $namerec, $nmatch);
	if ($nt>0) $name = trim($nmatch[1]);
	print "<tr><td class=\"facts_label\">".$pgv_lang["name"]."</td>";
	print "<td class=\"facts_value\"><input type=\"text\" name=\"NAME\" value=\"".stripslashes($name)."\" size=\"35\"></td></tr>\n";
	if (empty($namerec)) {
		//-- sex
		print "<tr><td class=\"facts_label\">".$pgv_lang["sex"]."</td>";
		print "<td class=\"facts_value\"><select name=\"SEX\"><option value=\"M\"";
		if ($tag=="HUSB") print " selected";
		print ">".$pgv_lang["male"]."</option><option value=\"F\"";
		if ($tag=="WIFE") print " selected";
		print ">".$pgv_lang["female"]."</option><option value=\"U\">".$pgv_lang["unknown"]."</option></select></td></tr>\n";
		//-- birth
		print "<tr><td class=\"facts_label\">".$pgv_lang["birth"]."</td>";
		print "<td class=\"facts_value\"></td></tr>";
		print "<tr><td class=\"facts_label\">".$pgv_lang["date"]."</td>";
		print "<td class=\"facts_value\"><input type=\"text\" name=\"birthdate\"></td></tr>\n";
		print "<tr><td class=\"facts_label\">".$factarray["PLAC"]."</td>";
		print "<td class=\"facts_value\"><input type=\"text\" name=\"birthplace\" id=\"birthplace\">";
		print " <a href=\"#\" onclick=\"return findPlace(document.getElementById('birthplace'));\">".$pgv_lang["find_place"]."</a>\n";
		print "</td></tr>";
		//-- death
		print "<tr><td class=\"facts_label\">".$pgv_lang["death"]."</td>";
		print "<td class=\"facts_value\"></td></tr>";
		print "<tr><td class=\"facts_label\">".$pgv_lang["date"]."</td>";
		print "<td class=\"facts_value\"><input type=\"text\" name=\"deathdate\"></td></tr>\n";
		print "<tr><td class=\"facts_label\">".$factarray["PLAC"]."</td>";
		print "<td class=\"facts_value\"><input type=\"text\" name=\"deathplace\" id=\"deathplace\">";
		print " <a href=\"#\" onclick=\"return findPlace(document.getElementById('deathplace'));\">".$pgv_lang["find_place"]."</a>\n";
		print "</td></tr>";
		print "</table>\n";
		print "<input type=\"submit\" value=\"".$pgv_lang["save"]."\"><br />\n";
	}
	else {
		print "</td></tr>\n";
		print "</table>\n";
		print "<input type=\"submit\" value=\"".$pgv_lang["save"]."\"><br />\n";
	}
	print "</form>\n";
}

?>