<?php
/*=================================================
	Project: phpGedView
	File: indilist.php
	Author: John Finlay
	Comments:
		Parses gedcom file and displays a list of the individuals in the file.

	Change Log:
		8/21/03 - File Created

	phpGedView: Genealogy Viewer
    Copyright (C) 2002 to 2003  John Finlay and Others

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

===================================================*/
# $Id: indilist.php,v 1.56.2.3 2004/02/03 22:13:22 yalnifj Exp $

require("config.php");
print_header($pgv_lang["individual_list"]);
print_help_link("individuals_help", "page_help");
//print "<div align=\"center\">\n";
print "<div class =\"center\">";
print "\n\t<h2>".$pgv_lang["individual_list"]."</h2>";
if (empty($surname_sublist)) $surname_sublist = "yes";
if (empty($show_all)) $show_all = "no";

$tindilist = array();

$indialpha = get_indi_alpha();
foreach($indialpha as $letter=>$list) {
	if (empty($alpha)) $alpha = $letter;
	print "<a href=\"indilist.php?alpha=".$letter."&amp;surname_sublist=$surname_sublist\">$letter</a> | \n";
}
print "<a href=\"indilist.php?show_all=yes&amp;surname_sublist=$surname_sublist\">".$pgv_lang["all"]."</a>\n";
$tindilist = get_alpha_indis($alpha);
uasort($tindilist, "itemsort");
print_help_link("alpha_help", "qm");
print "<br /><br /><table class=\"list_table, $TEXT_DIRECTION\"><tr>";
if (($surname_sublist=="yes")&&($show_all=="yes")) {
	$tindilist = get_indi_list();
	uasort($tindilist, "itemsort");
	if (!isset($alpha)) $alpha="";
	print "<td class=\"list_label\" colspan=\"2\">".$pgv_lang["surnames"]."</td></tr><tr>\n";
	print "<td class=\"list_value\">\n";
	$surnames = array();
	foreach($tindilist as $gid=>$indi) {
		if (showLivingNameByID($gid)||displayDetailsByID($gid)) {
			$name = preg_replace(array("/ [jJsS]r\.?,/", "/ I+,/", "/^[a-z. ]*/"), array(",","",""), $indi["name"]);
			$name = trim($name);
			$names = preg_split("/,/", $name);
			// Match names with chosen first letter
			$surname = $names[0];
			$surname = strtoupper($surname);
			if (!isset($surnames[$surname])) {
				// Put first letter in array to make link work
				$letter = substr($names[0], 0, 1);
				if ($CHARACTER_SET=="UTF-8") {
					$ord = ord($letter);
					if ($ord==195 || $ord ==196 || $ord==215){
						$letter = substr($names[0], 0, 2);
					}
				}
				$surnames[$surname] = array();
				$surnames[$surname]["alpha"] = $letter;
				$name = preg_replace(array("/ [jJsS]r\.?,/", "/ I+,/"), array(",",""), $indi["name"]);
				$names = preg_split("/,/", $name);
				$surnames[$surname]["name"] = $names[0];
				$surnames[$surname]["match"] = 1;
			}
			else {
				$surnames[$surname]["match"]++;
			}
		}
	}
	$i = 0;
	ksort($surnames);
	$count = count($surnames);
	foreach($surnames as $surname=>$namecount) {
		if (ord(substr($namecount["name"], 0, 2)) == 215){
			print "<div class =\"rtl\"><a href=\"indilist.php?alpha=".$namecount["alpha"]."&amp;surname_sublist=$surname_sublist&amp;surname=".stripslashes($namecount["name"])."\">".stripslashes($namecount["name"]) . " - [".($namecount["match"])."]&rlm;";
		}
		else print "<div class =\"ltr\"><a href=\"indilist.php?alpha=".$namecount["alpha"]."&amp;surname_sublist=$surname_sublist&amp;surname=".stripslashes($namecount["name"])."\">".stripslashes($namecount["name"]) . " - [".($namecount["match"])."]&lrm;";
		print "</a></div>\n";
		$i++;
		if ($i==floor($count/2)) print "</td><td class=\"list_value\">\n";
	}
	print "</td>\n";
}
else if (($surname_sublist=="yes")&&(empty($surname))&&($show_all=="no")) {
	if (!isset($alpha)) $alpha="";
	print "<td class=\"list_label\" colspan=\"2\">".$pgv_lang["surnames"]."</td></tr><tr>\n";
	print "<td class=\"list_value\">\n";
	$surnames = array();
	foreach($tindilist as $gid=>$indi) {
		if (showLivingNameByID($gid)||displayDetailsByID($gid)) {
			$name = preg_replace(array("/ [jJsS]r\.?,/", "/ I+,/", "/^[a-z. ]*/"), array(",","",""), $indi["name"]);
			$name = trim($name);
			$names = preg_split("/,/", $name);
			// Match names with chosen first letter
			if (substr($names[0],0,2) == $alpha || substr($names[0],0,1) == $alpha) {
				$surname = $names[0];
				$surname = strtoupper($surname);
				if (!isset($surnames[$surname])) {
					$name = preg_replace(array("/ [jJsS]r\.?,/", "/ I+,/"), array(",",""), $indi["name"]);
					$names = preg_split("/,/", $name);
					$surnames[$surname] = array();
					$surnames[$surname]["name"] = $names[0];
					$surnames[$surname]["match"] = 1;
				}
				else {
					$surnames[$surname]["match"]++;
				}
			}
		}
	}
	$i = 0;
	ksort($surnames);
	$count = count($surnames);
	foreach($surnames as $surname=>$namecount) {
		if (ord(substr($namecount["name"], 0, 2)) == 215){
			print "<div class =\"rtl\"><a href=\"indilist.php?alpha=".$alpha."&amp;surname_sublist=$surname_sublist&amp;surname=".stripslashes($namecount["name"])."\">".stripslashes($namecount["name"]) . " - [".($namecount["match"])."]&rlm;";
		}
		else print "<div class =\"ltr\"><a href=\"indilist.php?alpha=".$alpha."&amp;surname_sublist=$surname_sublist&amp;surname=".stripslashes($namecount["name"])."\">".stripslashes($namecount["name"]) . " - [".($namecount["match"])."]&lrm;";
		print "</a></div>\n";
		$i++;
		if ($i==floor($count/2)) print "</td><td class=\"list_value\">\n";
	}
	print "</td>\n";
}
else {
	//-- if the surname is set then only get the names in that surname list
	if ((!empty($surname))&&($surname_sublist=="yes")) {
		$newindilist = array();
		foreach($tindilist as $gid=>$indi) {
			$name = preg_replace("/ [jJsS]r\.?,/", ",", $indi["name"]);
			$names = preg_split("/,/", $name);
			$sname = $names[0];
			if (trim(strtoupper($sname))==trim(strtoupper($surname))) $newindilist[$gid] = $indi;
		}
		$tindilist = $newindilist;
	}

	if (($surname_sublist=="no")&&($show_all=="yes")) {
		$tindilist = get_indi_list();
		uasort($tindilist, "itemsort");
	}
	$ct = count($tindilist);
	$i=0;
	print "<td class=\"list_value\"><ul>\n";
	foreach($tindilist as $gid=>$indi) {
		$disp = displayDetailsByID($gid);
    	if ($disp || showLivingNameByID($gid)) {
			$name = preg_replace(array("/ [jJsS]r\.?,/", "/ I+,/", "/^[a-z. ]*/"), array(",","",""), $indi["name"]);
			$name = trim($name);
			$names = preg_split("/,/", $name);
			if ($show_all=="no") {
				if (substr($names[0],0,2) == $alpha || substr($names[0],0,1) == $alpha) {
			$surname = $names[0];
			if (!empty($names[1])) $firstname = $names[1];
			else $firstname = "";
			$name = preg_replace(array("/ [jJsS]r\.?,/", "/ I+,/"), array("",""), $indi["name"]);
			$names = preg_split("/,/", $name);
			if (empty($surname)) $surname = $gid;
			$surnames[$surname.$firstname.$gid]["name"] = $names[0];
			$surnames[$surname.$firstname.$gid]["indiname"] = $indi["name"];
			$surnames[$surname.$firstname.$gid]["gid"] = $gid;
			$surnames[$surname.$firstname.$gid]["file"] = $indi["file"];
		}
	}
			else {
				$surname = $names[0];
				if (!empty($names[1])) $firstname = $names[1];
				else $firstname = "";
				$name = preg_replace(array("/ [jJsS]r\.?,/", "/ I+,/"), array("",""), $indi["name"]);
				$names = preg_split("/,/", $name);
				if (empty($surname)) $surname = $gid;
				$surnames[$surname.$firstname.$gid]["name"] = $names[0];
				$surnames[$surname.$firstname.$gid]["indiname"] = $indi["name"];
				$surnames[$surname.$firstname.$gid]["gid"] = $gid;
				$surnames[$surname.$firstname.$gid]["file"] = $indi["file"];
			}

		}
	}
	if (!empty($surnames)) {
		ksort($surnames);
		$count = count($surnames);
		foreach($surnames as $k => $surname) {
			print "<li>";
			print_list_person($surname["gid"], array($surname["indiname"], $surname["file"]));
			print "</li>\n";
			$i++;
			if ($i==floor($count/2)) print "</ul></td><td class=\"list_value\"><ul>\n";
		}
		print "</ul></td>\n";
	}
}
print "</tr></table>";
print_help_link("name_list_help", "qm");
if ($show_all=="yes"){
	if ($surname_sublist=="yes") print "<br /><a href=\"indilist.php?show_all=yes&amp;surname_sublist=no\">".$pgv_lang["skip_surnames"]."</a>";
 	else print "<br /><a href=\"indilist.php?show_all=yes&amp;surname_sublist=yes\">".$pgv_lang["show_surnames"]."</a>";
}
else if ((!isset($alpha)) || ($alpha=="")) {
	if ($surname_sublist=="yes") print "<br /><a href=\"indilist.php?show_all=yes&amp;surname_sublist=no\">".$pgv_lang["skip_surnames"]."</a>";
	else print "<br /><a href=\"indilist.php?show_all=yes&amp;surname_sublist=yes\">".$pgv_lang["show_surnames"]."</a><br />\n";
}
else {
	if ($surname_sublist=="yes") print "<br /><a href=\"indilist.php?alpha=$alpha&amp;surname_sublist=no\">".$pgv_lang["skip_surnames"]."</a>";
	else print "<br /><a href=\"indilist.php?alpha=$alpha&amp;surname_sublist=yes\">".$pgv_lang["show_surnames"]."</a>";
}
print_help_link("skip_sublist_help", "qm");
print "<br /><br />\n";
if (userCanEdit(getUserName())) {
	?>
	<script language="JavaScript" type="text/javascript">
		function showchanges() {
			return false;
		}
	</script>
	<?php
	print "<br /><a href=\"#\" onclick=\"addnewchild(''); return false;\">".$pgv_lang["add_unlinked_person"]."</a>";
	print_help_link("add_unlinked_person_help", "qm");
	print "<br /><br />\n";
}
print "</div>\n";
print_footer();

?>
