<?php
/*=================================================
   charset=utf-8
   Project:	phpGedView
   File:	configure_help.no.php
   Author:	John Finlay
   Translation: Geir Håkon Eikland
	Comments:
		Norwegian Language Configure Help file for PHPGedView

	Change Log:
		7/1/03 - File Created

===================================================*/
# $Id: configure_help.no.php,v 1.3.2.2 2004/01/29 18:29:26 yalnifj Exp $
if (preg_match("/configure_help\...\.php$/", $_SERVER["PHP_SELF"])>0) {
	print "You cannot access a language file directly.";
	exit;
}

//-- CONFIGURE FILE MESSAGES
$pgv_lang["configure"]			= "Konfigurer PHPGedView";
$pgv_lang["default_user"]		= "Opprett hovedadministratoren.";
$pgv_lang["about_user"]			= "Du skal først opprette din hovedadministrator.  Denne bruker har rettigheter til å oppdatere konfigurasjonsfiler, se private data, og opprette andre brukere.";
$pgv_lang["fullname"]			= "Fullt navn:";
$pgv_lang["confirm"]			= "Bekreft Passord:";
$pgv_lang["can_admin"]			= "Brukeren kan administrere:";
$pgv_lang["can_edit"]			= "Brukeren kan redigere:";
$pgv_lang["add_user"]			= "Legg til ny bruker";
$pgv_lang["current_users"]		= "Nåværende brukerliste";
$pgv_lang["leave_blank"]		= "La passord-feltet være tomt, hvis du vil bevare det eksisterende passordet.";
$pgv_lang["other_theme"]		= "Annet, vennligst tast inn";
$pgv_lang["performing_update"]	= "Oppdaterer.";
$pgv_lang["config_file_read"]	= "Config-fil lest inn.";
$pgv_lang["does_not_exist"]		= "eksisterer ikke";
$pgv_lang["config_write_error"]	= "Feil ved skriving til konfigurasjonsfil.  Sjekk rettigheter og prøv igjen.";
$pgv_lang["db_setup_bad"]		= "Det er feil i din nåværende database-konfigurasjon.  Sjekk databasens forbindelsesparametre og gjør nødvendige endringere.";
$pgv_lang["click_here_to_continue"]	= "Klikk her for å fortsette.";
$pgv_lang["PGV_DATABASE_help"] = "Dette forteller phpGedView om hvilken databasetype du vil bruke til de gedcomfiler du importerer. Velg 'Indeksfiler' for å bruke indeksfiler, som er lagret i index mappen, eller Velg 'MySQL'  for å bruke en MySQL database. Dette endrer \$PGV_DATABASE variablen i config.php filen.";
$pgv_lang["PGV_DATABASE_help"] = "Forteller phpGedView hvilken databasetype du vil bruke til de GEDCOM filer du importerer inn i systemet. Velg 'Indexfiler' hvis du vil bruke indexfiler som er lagret i index mappen, eller Velg 'MySQL' for å bruke en MySQL database. Dette endrer \$PGV_DATABASE variablen i config.php filen.";
$pgv_lang["PGV_DATABASE"] = "PhpGedView database";
$pgv_lang["hebrew_and_gregorian"]	= "Hebraisk og Gregoriansk";
$pgv_lang["mouseover"]				= "Når musen føres over";
$pgv_lang["mousedown"]				= "Når musen senkes";
$pgv_lang["click"]					= "Ved å klikke på musen";
$pgv_lang["disabled"]				= "Ikke valgt";
$pgv_lang["mailto"]					= "E-post-link";
$pgv_lang["messaging"]				= "PhpGedView interne beskjeder";
$pgv_lang["messaging2"]				= "Interne beskjeder med e-Post";
$pgv_lang["no_messaging"]			= "Ingen kontaktmetode";
$pgv_lang["no_logs"]				= "Ingen logging";
$pgv_lang["daily"]					= "Daglig";
$pgv_lang["weekly"]					= "Ukentlig";
$pgv_lang["monthly"]				= "Månedlig";
$pgv_lang["yearly"]					= "Årlig";

$pgv_lang["jewish_and_gregorian"]	= "Jødisk og Gregoriansk";
$pgv_lang["jewish"]				= "Jødisk";
$pgv_lang["julian"]				= "Juliansk";
$pgv_lang["config_french"]		= "Fransk";
$pgv_lang["config_hebrew"]		= "Hebraisk";
$pgv_lang["gregorian"]			= "Gregoriansk";
$pgv_lang["confirm_gedcom_delete"]	= "Er du sikker på du vil slette denne gedcomfil?";
$pgv_lang["show_phpinfo"]		= "Vis PHPInfo siden";
$pgv_lang["ged_config"]			= "Konfigurasjonsfil";
$pgv_lang["ged_title"]			= "Gedcom tittel";
$pgv_lang["ged_gedcom"]			= "Gedcomfil";
$pgv_lang["current_gedcoms"]	= "Nåværende Gedcomfiler";
$pgv_lang["ged_download"]		= "Download";
$pgv_lang["admin_gedcoms"]		= "Klikk her, for å redigere gedcomfiler";
$pgv_lang["index"]				= "Indeksfiler";
$pgv_lang["mysql"]				= "MySQL";
$pgv_lang["config_help"]		= "Konfigurasjonshjelp";

$pgv_lang["DBHOST"] = "MySQL Database Vert:";
$pgv_lang["DBHOST_help"] = "DNS eller IP-adresse til datamaskinen hvor din MySQL databaseserver er installert.  Dette lagres i \$DBHOST variablen i config.php filen.";
$pgv_lang["DBUSER"] = "MySQL Database brukernavn:";
$pgv_lang["DBUSER_help"] = "Det MySQL database-brukernavn, som er nødvendig for login på din database.  Dette lagres i \$DBUSER variablen i config.php filen.";
$pgv_lang["DBPASS"] = "MySQL Database-passord:";
$pgv_lang["USE_RIN"] = "Bruk RIN# istedenfor GEDCOM ID:";
$pgv_lang["USE_RIN_help"] = "Velg JA for å bruke RIN nummeret istedenfor GEDCOM ID når det spørres etter personers ID i konfigurasjonsfiler, brukerinnstilliger, og trær. Dette er nyttig for genealogiprogrammer som ikke eksporterer GEDCOM med person ID, men bruker alltid den samme RIN.<br /><br />Dette lagres i \$USE_RIN variablen i config.php filen";
$pgv_lang["MAX_DESCENDANCY_GENERATIONS"] = "Maks etterkommergenerasjoner";
$pgv_lang["MAX_DESCENDANCY_GENERATIONS_help"] = "Lagrer det maksimale antall generasjoner som skal vises i etterkommertrær.<br /><br />Dette lagres i \$MAX_DESCENDANCY_GENERATIONS variablen i config.php filen.";
$pgv_lang["MAX_PEDIGREE_GENERATIONS"] = "Maks slektstregenerasjoner";
$pgv_lang["MAX_PEDIGREE_GENERATIONS_help"] = "Lagrer maksimalt antall generasjoner som skal vises i slektstrær.<br /><br />Dette lagres i \$MAX_PEDIGREE_GENERATIONS variablen i config.php filen.";
$pgv_lang["DBPASS_help"] = "MySQL database-passord for den brukeren du tastet inn i feltet for brukernavn.  Dette lagres i \$DBPASS variablen i config.php filen.";
$pgv_lang["SHOW_EMPTY_BOXES"] = "Vis tomme bokser i etterkommertrær:";
$pgv_lang["SHOW_EMPTY_BOXES_help"] = "Bestemmer om det skal vises tomme bokser i slektstrær eller ikke.<br /><br />Dette lagres i \$SHOW_EMPTY_BOXES variablen i config.php filen.";
$pgv_lang["ZOOM_BOXES"] = "Endre boks-størrelse på trær:";
$pgv_lang["ZOOM_BOXES_help"] = "Gjør det mulig for en bruker å endre boks-størrelsen i trær og få ytterligere informasjon. Velg \"Ikke valgt\" for å sperre dette valget. Velg \"Når musen føres over\" for å få zoomet boksene når brukeren beveger musen over ikonet i boksen. Velg \"Ved å klikke på musen\" for å få zoomet boksene når en bruker klikker på ikonet i boksen.<br /><br />Dette lagres i \$ZOOM_BOXES variablen i config.php fil.";
$pgv_lang["LINK_ICONS_help"] = "Gjør det muligt for brukere å velge link til andre trær og nære slektninger til den gjeldende person. Velg \"Ikke valgt\" for å sperre dette valget. Velg \"Når musen føres over\" for å få link til å lage popup når brukeren beveger musen over ikonet i boksen. Velg \"Ved å klikke på musen\" for å få popup når en bruker klikker på ikonet i boksen.<br /><br />Dette lagres i \$LINK_ICONS variablen i config.php filen.";
$pgv_lang["LINK_ICONS"] = "PopUp-link på trær:";
$pgv_lang["DBNAME"] = "Database-navn:";
$pgv_lang["DBNAME_help"] = "Den databasen i MySQL-serveren, som du vil ha phpGedView til å bruke.  Det brukernavnet du tastet inn i brukerfeltet må ha rett til å lage, overskrive, oppdatere, slette og velge i denne databasen.  Dette lagres i \$DBNAME variablen i config.php filen.";
$pgv_lang["TBLPREFIX"] = "Database Table Prefiks:";
$pgv_lang["TBLPREFIX_help"] = "En prefiks som legges til de MySQL-tabeller som phpGedView har opprettet.  Ved å endre denne verdi kan du sette flere phpGedView-sider opp til å bruke den samme databasen men med forskellige tabeller.  Dette lagres i \$TBLPREFIX variablen i config.php filen.";
$pgv_lang["DEFAULT_GEDCOM"] = "Standard GEDCOM:";
$pgv_lang["DEFAULT_GEDCOM_help"] = "PhpGedViews MySQL-versjon gjør det mulig å arbeide med flere datasett samtidig.  Bruk denne variablen til å angi hvilket GEDCOM datasett nye brukere får tildelt som utgangspunkt, når de første gang kommer til din side.  Hvis boksen er tom, velges automatisk den Gedcom som først ble importert.  Hvis du tillater en bruker å skifte GEDCOM, vil det være en link på alle sider, som gjør at de kan bytte mellom de GEDCOM datasett de har tilgang til.  Dette lagres i \$DEFAULT_GEDCOM variablen i config.php filen.";
$pgv_lang["ALLOW_CHANGE_GEDCOM"] = "Tillat besøkende å skifte Gedcom:";
$pgv_lang["ALLOW_CHANGE_GEDCOM_help"] = "Upload først din Gedcom-fil til et sted som kan nås av din servers php-installasjon.  Deretter tastes inn stien til filen her.  Dette lagres i \$ALLOW_CHANGE_GEDCOM variablen i config.php filen.";
$pgv_lang["GEDCOM"] = "Gedcom-sti:";
$pgv_lang["gedcom_path_help"] = "Upload først din Gedcom-fil til et sted som kan nås av din servers php-installasjon.  Deretter tastes inn stien til filen her.  Dette lagres i \$GEDCOM variablen i config.php filen.<br /><br />Les <a href=\"readme.txt\">Readme.txt</a> filen for ytterligere hjelp.";
$pgv_lang["CHARACTER_SET"] = "Tegnsett:";
$pgv_lang["ALLOW_EDIT_GEDCOM"] = "Aktiver online-redigering";
$pgv_lang["ALLOW_EDIT_GEDCOM_help"] = "Aktiverer online-redigering for denne gedcom så brukere med redigerings-rettigheter kan oppdatere denne gedcom online.<br /><br />Dette lagres i \$ALLOW_EDIT_GEDCOM variablen i config.php filen.";
$pgv_lang["CHARACTER_SET_help"] = "Dette er din gedcom fils tegnsett.  UTF-8 anbefales, og burde fungere for de fleste sider.  Hvis du eksporterer din gedcom i IBM Windows tegnsett (codepage), skal du skrive WINDOWS her.<br />Dette lagres i \$CHARACTER_SET variablen i config.php filen.<br /><br />NB: PHP støtter IKKE UNICODE (UTF-16) så det nytter ikke å klage over dette til PHP folk :-)";
$pgv_lang["LANGUAGE"] = "Språk:";
$pgv_lang["LANGUAGE_help"] = "Velg det språk din side bruker som utgangspunkt.  Brukerne har mulighet til å ignorere denne innstillingen og istede velge språk selv, enten ved å la brukerens nettleser-språkinnstilling velge, eller ved å velge språk selv på siden, hvis ENABLE_MULTI_LANGUAGE = true.<br />Dette lagres i \$LANGUAGE variablen i config.php filen.";
$pgv_lang["SHOW_PEDIGREE_PLACES"] = "Stednavnsnivåer som vises i personboksene:";
$pgv_lang["SHOW_PEDIGREE_PLACES_help"] = "Viser hvor mye stedsnavninformasjon som vises i trærnes personbokser. Velges 9 vil alle stednavnsnivåer bli vist. Velges 0, skjules stednavn totalt. Velges 1, vises første nivå, 2 viser 2 nivåer osv.<br /><br />Dette lagres i \$SHOW_PEDIGREE_PLACES variablen i config.php filen";
$pgv_lang["SHOW_ID_NUMBERS_help"] = "Vis ID nummer i parenteser etter personnavn.<br /><br />Dette lagres i  \$SHOW_ID_NUMBERS variablen i config.php filen.";
$pgv_lang["SHOW_ID_NUMBERS"] = "Vis ID-nummer ved navn:";
$pgv_lang["NAME_FROM_GEDCOM"] = "Hent navn fra GEDCOM:";
$pgv_lang["NAME_FROM_GEDCOM_help"] = "Som standard bruker phpGedView det navnet som er lagret i indeksen til å finne en persons navn. Men i visse Gedcom-format og -språk, indekseres ikke sorterbare navn tilfredsstillende, og den beste måten å få vist navnet korrekt, er å hente det fra Gedcomfilen. Spanske navn er et godt eksempel. Et spansk navn kan bestå av Fornavn Fars etternavn Mors etternavn. Når indeksen brukes til sortering og fremvisning, vil navnet bli vist som Fornavn Mors etternavn Fars etternavn, men dette er ikke korrekt. Hentes derimot navnet fra Gedcomfilen, vil det bli vist korrekt. Men når navnet skal hentes fra Gedcomfilen, gjør det samtidig phpGedView tregere,.<br /><br />Dette lagres i \$NAME_FROM_GEDCOM variablen i config.php filen";
$pgv_lang["CALENDAR_FORMAT"] = "Kalenderformat";
$pgv_lang["CALENDAR_FORMAT_help"] = "Gir deg adgang til å spesifisere hvilken type kalender du vil bruke sammen med denne Gedcomfilen. Hebraisk er det samme som den jødiske kalender med hebraiske tegn. NB: Verdiene for jødisk / hebraiske datoer er beregnet fra de Gregorianske / Julianske datoer. Ettersom den jødiske kalenderdag starter ved skumringen vil alle begivenheter som finner sted mellom skumringen og midnatt bli vist en dag tidligere enn den korrekte jødiske datoen. Gamle nettlesere kan ha problemer med å vise hebraisk. Visse gamle nettlesere viser hebraisk baklengs eller ikke det hele tatt.<br /><br />Dette lagres i \$CALENDAR_FORMAT variablen i config.php filen";
$pgv_lang["JEWISH_ASHKENAZ_PRONUNCIATION"] = "Jødisk Ashkenazi uttale:";
$pgv_lang["DISPLAY_JEWISH_THOUSANDS"] = "Vis hebraiske tusinder:";
$pgv_lang["DISPLAY_JEWISH_THOUSANDS_help"] = "Vis Alafim i Hebraiske kalendere. Settes den til ja, vises året 1969 som <span lang=\"he-IL\" dir='rtl'>&#1492;'&#160;&#1514;&#1513;&#1499;&quot;&#1496;</span>&lrm; men settes den til nei, vises året som <span lang=\"he-IL\" dir='rtl'>&#1514;&#1513;&#1499;&quot;&#1496;</span>&lrm;. Dette har ingen innvirkning på det jødiske års innstillinger. Året blir vist som 5729 uansett denne innstillingen.<br />Dette lagres i  \$DISPLAY_JEWISH_THOUSANDS variablen i config.php filen.";
$pgv_lang["DISPLAY_JEWISH_GERESHAYIM"] = "Vis hebræisk Geyrshayim";
$pgv_lang["DISPLAY_JEWISH_GERESHAYIM_help"] = "Viser enkelt og dobbelt anførselstegn ved visning av hebraiske datoer. Ved ja-innstilling vises 8 februar 1969 som <span lang='he-IL' dir='rtl'>&#1499;'&#160;&#1513;&#1489;&#1496;&#160;&#1514;&#1513;&#1499;&quot;&#1496;</span>&lrm; kontra nei-innstillingen som viser datoen som <span lang='he-IL' dir='rtl'>&#1499;&#160;&#1513;&#1489;&#1496;&#160;&#1514;&#1513;&#1499;&#1496;</span>&lrm;. Dette påvirker ikke jødisk år innstillingen fordi det ikke brukes anførselstegn i jødiske datoer, som vises med Latin tegnsett.<br />Dette lagres i \$DISPLAY_JEWISH_GERESHAYIM variablen i config.php filen.";
$pgv_lang["JEWISH_ASHKENAZ_PRONUNCIATION_help"] = "Bruk jødisk Ashkenazi uttale.<br />Hvis satt til ja vil månedene Cheshvan og Teves bli stavet med Ashkenazi uttale. Hvis satt til nei vil månedene bli stavet Hesvan og Tevet. <br />Dette berører kun den jødiske innstilling. Med hebraisk innstilling brukes det hebraiske alfabet.<br />Dette lagres i \$JEWISH_ASHKENAZ_PRONUNCIATION variablen i config.php filen.";
$pgv_lang["ENABLE_MULTI_LANGUAGE"] = "Tillat brukere å skifte språk:";
$pgv_lang["ENABLE_MULTI_LANGUAGE_help"] = "Settes til 'ja' hvis brukerne skal få lov til å velge et annet språk fra en 'slipp ned'-liste på siden, eller bli styrt av språkinnstillingen i brukernes nettlesere.<br />Dette lagres i \$ENABLE_MULTI_LANGUAGE variablen i config.php filen.";
$pgv_lang["DEFAULT_PEDIGREE_GENERATIONS"] = "Antall generasjoner i slektstre:";
$pgv_lang["DEFAULT_PEDIGREE_GENERATIONS_help"] = "Angi antall generasjoner som standard skal vises i slektstrær<br />Dette lagres i \$DEFAULT_PEDIGREE_GENERATIONS variablen i config.php filen.";
$pgv_lang["PEDIGREE_ROOT_ID"] = "Standard hovedID i slektstre og etterkommervisning:";
$pgv_lang["PEDIGREE_ROOT_ID_help"] = "Lagrer ID til den person, som standard er valgt som hovedperson ved visning av slektstre og etterkommervisning<br />Dette lagres i \$PEDIGREE_ROOT_ID variablen i config.php filen.";
$pgv_lang["GEDCOM_ID_PREFIX"] = "Gedcom ID prefiks:";
$pgv_lang["GEDCOM_ID_PREFIX_help"] = "Med mindre brukerne selv legger til et prefiks når de taster inn en ID, vil dette prefiks bli brukt i forbindelse med slektstrær, etterkommertrær, slektsskapstrær, og andre trær.<br /><br />Dette lagres i \$GEDCOM_ID_PREFIX variablen i config.php filen.";
$pgv_lang["PEDIGREE_FULL_DETAILS"] = "Viser født og død detaljer på slektstrær og etterkommervisninger:";
$pgv_lang["PEDIGREE_FULL_DETAILS_help"] = "Forteller, hvorvidt en persons fødsels- og dødsdetaljer skal vises som standard<br />Dette lagres i \$PEDIGREE_FULL_DETAILS variablen i config.php filen.";
$pgv_lang["PEDIGREE_LAYOUT"] = "Standard slektstre-layout:";
$pgv_lang["PEDIGREE_LAYOUT_help"] = "Dette bestemmer om slektstreet skal skrives ut i landskaps- eller portrett- orientering.<br /><br />Dette lagres i \$PEDIGREE_LAYOUT variablen i config.php filen. ";
$pgv_lang["AUTHENTICATION_MODULE"] = "Godkjennelses Module Fil:";
$pgv_lang["AUTHENTICATION_MODULE_help"] = "Dette er en fil det hentes godkjennelses-funksjoner fra.  Ved å implementere funksjonene i denne filen, kan brukere tilpasse phpGedView til å bruke andre metoder til å godkjenne brukere og lagre brukere i andre brukerdatabaser.  Man kan håpe på at andre brukere er innstillt på å dele sine egne bruker-godkjennings-moduler med andre phpGedView brukere.<br /><br />Dette lagres i \$AUTHENTICATION_MODULE variablen i config.php filen.";
$pgv_lang["PRIVACY_MODULE"] = "Personvern-fil:";
$pgv_lang["PRIVACY_MODULE_help"] = "En fil inneholder personvern-funksjoner. Se <a href=\"http://gendorbendor.sourceforge.net\">http://gendorbendor.sourceforge.net</a> for mere informasjon og for å downloade alternative personvern (privacy) add-ons.<br />Dette lagres i \$PRIVACY_MODULE variablen i config.php filen.";
$pgv_lang["HIDE_LIVE_PEOPLE"] = "Skjul nålevende personer:";
$pgv_lang["HIDE_LIVE_PEOPLE_help"] = "Denne funksjon gir PhpGedView beskjed om å skjule personlige detaljer til nålevende personer.  Nålevende personer defineres som de, som ikke har en begivenhet registreret lengere tilbake enn for $MAX_ALIVE_AGE år siden, og som ikke har noen barn, som ble født for mer enn $MAX_ALIVE_AGE år siden.<br />Dette lagres i \$HIDE_LIVE_PEOPLE variablen i config.php filen.";
$pgv_lang["REQUIRE_AUTHENTICATION_help"] = "Ved å angi denne valget, tvinges alle besøkende til å logges inn før de kan se data på siden.<br /><br />Dette lagres i \$REQUIRE_AUTHENTICATION variablen i config.php file.";
$pgv_lang["REQUIRE_AUTHENTICATION"] = "Krev innlogging av besøkende:";
$pgv_lang["CHECK_CHILD_DATES"] = "Sjekk barns data:";
$pgv_lang["CHECK_CHILD_DATES_help"] = "Undersøker barnas data, når det skal bestemmes om en person oppfattes som nålevende eller død.  På eldre PC'er og store gedcom filer kan slike søk øke responstiden på siden din.<br />Dette lagres i \$CHECK_CHILD_DATES variablen i config.php filen.";
$pgv_lang["MAX_ALIVE_AGE"] = "Den alder som en person må anses for å være død:";
$pgv_lang["MAX_ALIVE_AGE_help"] = "Dette er den maksimale alder, hvor det kan eksistere en begivenhet på personen, eller den maksimale alder på personens barn, som brukes til å bestemme om en person skal anses for å være død eller ikke.<br />Dette lagres i \$MAX_ALIVE_AGE variablen i config.php filen.";
$pgv_lang["SHOW_GEDCOM_RECORD"] = "Tillat brukere å se GEDCOM poster:";
$pgv_lang["SHOW_GEDCOM_RECORD_help"] = "Settes dette til ja, blir det lagt en link på personer, kilder, og familier, som gjør det mulig for brukere å åpne et eget vindu med GEDCOM koden hentet direkte fra Gedcom-filen.<br />Dette lagres i \$SHOW_GEDCOM_RECORD variablen i config.php filen.";
$pgv_lang["INDEX_DIRECTORY"] = "Indekseringsfilenes mappe:";
$pgv_lang["INDEX_DIRECTORY_help"] = "Dette er stien til en - lese- og skrivbar - mappe, hvor PhpGedView skal lagre indekseringsfiler (husk å legge til avsluttende skråstrek \"/\")<br />Dette lagres i \$INDEX_DIRECTORY variablen i config.php filen.";
$pgv_lang["ALPHA_INDEX_LISTS"] = "Del opp lange lister etter etternavnenes første bokstav:";
$pgv_lang["ALPHA_INDEX_LISTS_help"] = "Ved for mange lange person- og familielister, sett dette valget til 'true' for å dele listen i sider delt etter den første bokstaven i etternavnet. <br />Dette lagres i \$ALPHA_INDEX_LISTS variablen i config.php filen.";
$pgv_lang["MULTI_MEDIA"] = "Aktiver multimedia-valg:";
$pgv_lang["MULTI_MEDIA_help"] = "GEDCOM 5.5 gir deg tillatelse å linke bilder, videoer, og andre multimedia-objekter i din GEDCOM.  Hvis du ikke har inkluderet multimedia objekter i din gedcom, kan du deaktivere multimedia-valget ved å sette denne verdien til 'Nei'. <br />Se multimedia-avsnittet i <a href=\"readme.txt\">readme.txt</a> filen for flere opplysning om å inkludere media på din side.<br />Dette lagres i \$MULTI_MEDIA variablen i config.php filen.";
$pgv_lang["MEDIA_DIRECTORY"] = "MultiMedia-mappe:";
$pgv_lang["MEDIA_DIRECTORY_help"] = "Stien til en leselig mappe, hvor PhpGedView skal lete etter lokale multimedia filer (husk å legge til avsluttende skråstrek \"/\")<br />Dette lagres i \$MEDIA_DIRECTORY variablen i config.php filen.";
$pgv_lang["MEDIA_DIRECTORY_LEVELS"] = "Antall multimedia-mappenivåer:";
$pgv_lang["MEDIA_DIRECTORY_LEVELS_help"] = "Verdien 0 ignoreres i alle mapper i media objektets fil-sti.  Verdien 1 vil også bruke den første mappe som inneholder dette bilde.  Ved å øke verdien økes antall mappenivår som skal inkluderes i stien.  <br />Eksempel: hvis du linker et bilde i din gedcom med en sti som C:\\Documents and Settings\\User\\Mine Dokumenter\\Mine bilder\\Slekt\\Etternavn\\bestefar.jpg vil verdien 0 svare til stien ./media/bestefar.jpg.  Verdien 1 vil svare til  ./media/Etternavn/bestefar.jpg, osv.  De fleste vil kunne klare seg med verdien 0.  Men, forskellige media-objekt som heter det samme, vil da overskrive hverandre.  Denne innstillingen gir deg mulighet til å organisere dine media så navnesammenfall ikke gir problemer.<br />Dette lagres i \$MEDIA_DIRECTORY_LEVELS variablen i config.php filen.";
$pgv_lang["SHOW_HIGHLIGHT_IMAGES"] = "Vis utvalgte bilder i personenes bokser:";
$pgv_lang["SHOW_HIGHLIGHT_IMAGES_help"] = "Hvis du har aktiveret multimedia på din side, kan PhpGedView vise små bilder (thumbnail) ved siden av personenes navn i tableller, trær og bokser.  For tiden bruker PhpGedView det første multimedia objekt som er listet i en gedcom post som det utvalgte bilde.  For personer med flere bilder, må du arrangere multimedia objektene slik at det bilde du ønsker brukt er plasseret før de andre.<br />Se multimedia avsnittet i <a href=\"readme.txt\">readme.txt</a> filen for flere opplysning om å inkludere media på din side.<br />Dette lagres i \$SHOW_HIGHLIGHT_IMAGES variablen i config.php filen.";
$pgv_lang["ENABLE_CLIPPINGS_CART"] = "Aktivere utklippsmappe:";
$pgv_lang["ENABLE_CLIPPINGS_CART_help"] = "Utklippsmappen gir de besøkende på din side å ta utklipp fra dine data og legge disse til en utklippsfil, som de senere kan downloade som en gedcom fil og importere inn i deres eget slektsprogram.<br />Dette lagres i \$ENABLE_CLIPPINGS_CART variablen i config.php filen.";
$pgv_lang["HIDE_GEDCOM_ERRORS"] = "Skjul GEDCOM feilmeldinger:";
$pgv_lang["HIDE_GEDCOM_ERRORS_help"] = "Ved å velge 'Ja' her, skjules de feilmeldinger som PhpGedView lager, når den finner et ukjent gedcom-merke i din gedcom fil.  PhpGedView bestreber seg på å følge GEDCOM 5.5 standarden, men noen slektsprogram legger til deres egne spesielle merker (tags).  Se <a href=\"readme.txt\">readme.txt</a> filen for mer informasjon.<br />Dette lagres i \$HIDE_GEDCOM_ERRORS variablen i config.php filen.";
$pgv_lang["WORD_WRAPPED_NOTES"] = "Legg til mellomrom hvor linjer er delt:";
$pgv_lang["WORD_WRAPPED_NOTES_help"] = "Noen slektsprogram deler linjer etter hele ord, mens andre deler linjer hvor som helst.  Dette kan føre til at PhpGedView kan komme til å slå sammen ord som ikke skal det.  Hvis du velger 'Ja' her, vil det bli lagt til et mellomrom hvor ord er delt i gedcom.<br />Dette lagres i \$WORD_WRAPPED_NOTES variablen i config.php filen.";
$pgv_lang["SHOW_CONTEXT_HELP"]		= "Vis ? hjelp-linker på sidene:";
$pgv_lang["SHOW_CONTEXT_HELP_help"]	= "Dette valget vil vise hjelpe-spørsmålstegn-linker på sider etter valgene på de sidene hvor besøkende kan få en hjelpetekst om valgene på sidene.<br /><br />Dette lagres i \$SHOW_CONTEXT_HELP variablen i config.php filen.";
$pgv_lang["HOME_SITE_URL"] = "URL til hjemmesiden:";
$pgv_lang["HOME_SITE_URL_help"] = "Denne URL er inkluderet i det vedlagte temas topptekst, og brukes til å lage en link til din hjemmeside.<br />Dette lagres i \$HOME_SITE_URL variablen i config.php filen.";
$pgv_lang["HOME_SITE_TEXT"] = "Hjemmeside beskrivelse:";
$pgv_lang["HOME_SITE_TEXT_help"] = "Teksten på linken, som viser til din hjemmeside.<br />Dette lagres i \$HOME_SITE_TEXT variablen i config.php filen.";
$pgv_lang["CONTACT_EMAIL"] = "Slektstreets kontakt-e-post:";
$pgv_lang["CONTACT_EMAIL_help"] = "Den e-post-adressen kan besøkende bruke til kontakt vedrørende din sides slektsmateriale.<br />Dette lagres i \$CONTACT_EMAIL variablen i config.php filen.";
$pgv_lang["CONTACT_METHOD"] = "Kontaktmåte:";
$pgv_lang["CONTACT_METHOD_help"] = "Måten besøkende bruker til å kontakte \"Contact User\" om slektsforskningsspørsmål. 'Mailto'-valget legger til en mailto-link som besøkende kan klikke på for å sende en e-post med deres e-postprogram. 'Beskjed'-valget bruker PhpGedViews beskjedsystem, og det sendes ingen e-post. 'Beskjed med e-post'-valget er standard og bruker PhpGedViews beskjedsystem, men sender også kopi av beskjedene med e-post.  Velges 'Ingen beskjed', kan besøkende ikke kontakte deg.<br /><br />Dette lagres i \$CONTACT_METHOD variablen i config.php filen.";
$pgv_lang["WEBMASTER_EMAIL"] = "Support kontakt:";
$pgv_lang["WEBMASTER_EMAIL_help"] = "Den e-post-adressen kan besøkende bruke til kontakt vedrørende tekniske spørsmål eller feil de er støtt på under besøket på din side.<br />Dette lagres i \$WEBMASTER_EMAIL variablen i config.php filen.";
$pgv_lang["SUPPORT_METHOD"] = "Supportmåte:";
$pgv_lang["SUPPORT_METHOD_help"] = "Måten besøkende bruker for å kontakte \"Support\" om slektsforskning. 'Mailto'-valget legger til en mailto-link som besøkende kan klikke på for å sende en e-mail med deres e-postprogram. 'Beskjed'-valget bruker PhpGedViews beskjedsystem, og det sendes ingen e-post. 'Beskjed med e-post'-valget er standard og bruker PhpGedViews beskjedsystem, men sender også kopi av beskjedene med e-post.  Velges 'Ingen besked', kan besøkende ikke kontakte deg.<br /><br />Dette lagres i \$SUPPORT_METHOD variablen i config.php filen.";
$pgv_lang["FAVICON"] = "Favoritt ikon:";
$pgv_lang["FAVICON_help"] = "Angi en sti til det ikonet du vil vise i dine besøkenes \"Mine linker\" meny, når de legger inn din side inn i deres \"Mine linker\" meny.<br />Dette lagres i \$FAVICON variablen i config.php filen.";
$pgv_lang["THEME_DIR"] = "Tema katalog:";
$pgv_lang["THEME_DIR_help"] = "Katalogen hvor dine PhpGedView tema filer er lagret.  Du kan endre og/eller tilpasse  hvilket som helst av de standard temaer som er levert med PhpGedView for å gi siden din et eget design.  Se tema endring-avsnittet i <a href=\"readme.txt\">readme.txt</a> filen for mer informasjon.<br />Dette lagres i \$THEME_DIR variablen i config.php filen.";
$pgv_lang["TIME_LIMIT"] = "PHP tidsbegrensning:";
$pgv_lang["TIME_LIMIT_help"] = "Den maksimale tid i sekunder, som PhpGedView får lov til å arbeide.  Som standard er den satt til 1 minutt.  Avhengig av størrelsen på din gedcom fil, kan du evt. øke denne tidsbegrensning når du har bruk for å indeksere.  Hvis denne verdi settes til 0, tillater du PHP å kjøre uendelig.<br />ADVARSEL: Hvis verdien settes til 0 eller settes for høyt, kan få siden din til å \"henge\" på visse operativsystemer inntil scriptet avsluttes.  Å sette verdien til 0 betyr at scriptet ikke avsluttes før en nettverksadministrator stopper prosessen eller gjenstarter serveren.  Det kan ta lang tid å lage et stort slektstre, så ved å sette denne verdi så lavt som muligt, kan det hindre at en eller annen får din webserver til å bryte sammen, ved å forsøke, å lage et 1000 generasjoners tre.";
$pgv_lang["PGV_SESSION_SAVE_PATH"] = "Logg-lagrings-sti";
$pgv_lang["PGV_SESSION_SAVE_PATH_help"] = "Sti til katalogen hvor phpGedViews logg-filer lagres. Det er ikke alle webhotell som har konfigureret deres PHP korrekt, og derfor kan logg-data gå tapt ved bytte av side. Denne innstillingen gjør det mulig for administratorer å kompensere for denne webhotel-feilen, ved istede å lagre loggfiler i en lokal mappe på deres egen side. Til det formålt er ./index/ katalogen et opplagt valg, dersom det er nødvendig å endre på denne stien. Som standard skal boksen være tom, for da vil innstillingene fra php.ini filen brukes. Boksen skal kun fylles ut, hvis logg-data går tapt.<br /><br />Dette lagres i \$PGV_SESSION_SAVE_PATH variablen i config.php filen.";
$pgv_lang["SERVER_URL"] = "Server URL:";
$pgv_lang["SERVER_URL_help"] = "Hvis du bruker https eller en annen port enn standard porten, må du legge inn URLen her for å få tilgang til serveren. <br /><br />Dette lagres i \$SERVER_URL variablen i config.php filen.";
$pgv_lang["PGV_SESSION_TIME"] = "Logg-inn timeout";
$pgv_lang["PGV_SESSION_TIME_help"] = "Tid i sekunder før PhpGedView krever at en pålogget bruker må logge seg på på nytt. Standard er 30 minutter.<br /><br />Dette Lagrer \$PGV_SESSION_TIME variablen i config.php filen";
$pgv_lang["SHOW_STATS"] = "Vis utførings-statistikk:";
$pgv_lang["SHOW_STATS_help"] = "Vis runtime-statistikk og antall database-forespørsler på bunnen av hver side.<br /><br />Dette lagres i \$SHOW_STATS variablen i config.php filen.";
$pgv_lang["USE_REGISTRATION_MODULE"] = "Tillat brukere å be om en brukerkonto:";
$pgv_lang["USE_REGISTRATION_MODULE_help"] = "Gir brukere mulighet til å registere seg for å få en konto på siden. Registreringen skal godkjendes av en administrator før kontoen blir aktiveret.<br /><br />Dette lagres i \$USE_REGISTRATION_MODULE variablen i config.php filen.";
$pgv_lang["ALLOW_USER_THEMES"] = "Tillat brukere å velge deres eget tema:";
$pgv_lang["ALLOW_USER_THEMES_help"] = "Gir brukere mulighet for selv å velge deres eget tema.<br /><br />Dette lagres i \$ALLOW_USER_THEMES variablen i config.php filen.";
$pgv_lang["CREATE_GENDEX"] = "Lag Gendex fil";
$pgv_lang["CREATE_GENDEX_help"] = "Vis PhpGedView generert Gendex filer når en Gedcom importeres. Gendex filer lagres i index-katalogen.<br /><br />Dette lagres i \$CREATE_GENDEX variablen i config.php filen.";
$pgv_lang["gedcom_title_help"] = "Tast inn en tittel, som beskriver innholdet i denne GEDCOM filen.";
$pgv_lang["LOGFILE_CREATE"] = "Arkiver logfiler:";
$pgv_lang["LOGFILE_CREATE_help"] = "Hvor ofte skal programmet arkivere loggfiler.<br /><br />Dette lagres i \$LOGFILE_CREATE variablen i config.php filen.";

$pgv_lang["welcome"] = "Velkommen til din nye PhpGedView vevside.  Ettersom du kan se denne tekst, har du lykkes med å installere PhpGedView på din webserver, og kan nå konfigurere PhpGedView etter dine ønsker.<br />";
$pgv_lang["welcome_help"]	= "Dette hjelpevinduet kan hjelpe deg gjennem konfigurasjons-prosessen. Ved inntasting/valg av de forskjellige felt, vil dette vindu inneholde opplysninger om det gjeldende felt. Det er OK å lukke vinduet. For å åpne det igjen, kan du klikke på en av \"?\" spørsmålstegnene ut for det gjeldende felt.";
$pgv_lang["review_readme"] = "Vennligst les <a href=\"readme.txt\" target=\"_blank\">readme.txt</a> filen før du fortsetter med å konfigurere PhpGedView.<br /><br />Du kan alltid vende tilbake til denne konfigurasjonssiden ved å peke på configure.php filen i din nettlesers adresselinje.<br /><br />Du kan få hjelp til hvert punkt ved å klikke på &quot;?&quot; på hver enkel feltmarkør.";
$pgv_lang["save_config"] = "Lagre konfigurasjon";
$pgv_lang["reset"] = "Nullstill";
$pgv_lang["download_here"]	= "Klikk her for å downloade fil.";
$pgv_lang["download_gedconf"]	= "Download GEDCOM konfigurasjon.";
$pgv_lang["not_writable"]	= "Det har vist seg, at PHP ikke kan skrive til konfigurasjonsfilen. Du kan derfor bruke download knappen til lagre dine innstillinger i en fil, som du etterpå uploade manuelt.";
$pgv_lang["download_file"]	= "Download fil";
$pgv_lang["upload_to_index"]	= "Upload filen til din index-katalog:";

//-- edit privacy messages
$pgv_lang["edit_privacy"]			= "Konfigurasjon av personvernfilen";
$pgv_lang["PRIV_PUBLIC"]			= "Vis til alle";
$pgv_lang["PRIV_USER"]				= "Vis kun til godkjente brukere";
$pgv_lang["PRIV_NONE"]				= "Vis kun til administratorer";
$pgv_lang["PRIV_HIDE"]				= "Skjul selv for administrative brukere";
$pgv_lang["save_changed_settings"]		= "lagre endringer";
$pgv_lang["add_new_pp_setting"]		= "Legg til ny [\$person_privacy] - innstilling";
$pgv_lang["add_new_up_setting"]		= "Legg til ny [\$user_privacy] - innstilling";
$pgv_lang["add_new_gf_setting"]		= "Legg til ny [\$global_facts] - innstilling";
$pgv_lang["add_new_pf_setting"]		= "Legg til ny [\$person_facts] - innstilling";
$pgv_lang["choice"]				= "Valg";
$pgv_lang["unable_to_find_privacy_indi"]	= "Kan ikke finne individ med id";
$pgv_lang["SHOW_LIVING_NAMES"]			= "Vis nålevendes navn";
$pgv_lang["SHOW_RESEARCH_LOG"]			= "Vis logg";
$pgv_lang["fact_details"]			= "Vis detaljerte fakta";
$pgv_lang["privacy_header"]			= "Rediger personvern-innstillinger innenfra";
$pgv_lang["fact_show"]				= "Vis fakta";
$pgv_lang["save_and_import"]		= "Etter at du har lagret denne GEDCOM konfigurasjon er det nødvendigt å importere GEDCOM ved å klikke på <b>Importer Gedcom</b>-knappen eller fra <b>Administrasjon->Administrer Gedcomfiler->Importer Gedcom</b>";
$pgv_lang["USE_RELATIONSHIP_PRIVACY"]		= "Bruk personvern på slaktskap";
$pgv_lang["help_info"]				= "Du kan få hjelp i hver enhet ved å klikke på det røde &quot;?&quot; ved ledeteksten ut for hvet felt.";
$pgv_lang["SHOW_LIVING_NAMES_help"]		= "Vis nålevendes navn<br /><br />Skal nålevende personers navn vises til alle?.<br /><br />Dette lagres i \$SHOW_LIVING_NAMES variablen i den valgte personvern fil.";
$pgv_lang["CHECK_MARRIAGE_RELATIONS_help"]	= "Sjekk ekteskaps relasjoner<br /><br />Sjekk slektninger gjennem ekteskapsrelasjoner.<br /><br />Dette lagres i \$CHECK_MARRIAGE_RELATIONS variabler i den valgte personvernsfil.";
$pgv_lang["SHOW_DEAD_PEOPLE_help"]		= "Vis avdøde personer<br /><br />lagres i personvernsnivå for alle avdøde personer.";
$pgv_lang["person_privacy_help"]			= "\"person_privacy\" innstillingen gir administratorer mulighet for å endre personverns-innstillingen for en bestemt person i gedcomfilen. La oss si du f.eks. har et barn, som døde som spedbarn. Normalt vil alle kunne se alle detaljer som vises til alle, fordi barnet er dødt. Men, for deg og familien er disse detaljer fremdeles private. Du vil ikke fjerne dødsoppførslen, men du vil skjule detaljene og bevare dem som private. Hvis dette barn har ID I100 skal du sette inn følgende personverninnstillinger: <br /><br />ID: I100<br />Vis til:\"Vis kun til godkjente brukere\"<br /><br />Dette virker også den andre veien. Hvis du vil vise alle detaljer om en person (ID 101) som du vet er død, men som ikke er registreret som død, kan du legge til følgende:<br /><br />ID: I101<br />Vis til: \"Vis til alle\"<br /><br />Dette lagres i \$person_privacy variablen i den valgte personvernfil.";
$pgv_lang["user_privacy_help"]			= "\"user_privacy\" innstillingen gir administratorer mulighet til å omgå den normale personverninnstillingen for et individ i gedcomfilen baseret på en brukers brukernavn.<br /><br />Så hvis du ikke vil at brukernavnet \"John\" kan se dine private opplysninger, og du har ID I100 i gedcomfilen, kan du konfigurere slik:<br /><br />Brukernavn: John<br />ID: I100<br />Vis?: \"Skjul\"<br /><br />etterpå vil dataene dine kun være skjult for brukernavnet \"John\".<br /><br />For å vise I101's data (som normalt vil være skjult fordi I101 er nålevende) til brukernavnet \"John\" skal du velge:<br /><br />Brukernavn: John<br />ID: I101<br />Vis?: \"Vis\"<br /><br />Dette lagres i \$user_privacy variablen i den valgte personvernfil.";
$pgv_lang["global_facts_help"]			= "\"global_facts\" innstillingen definerer fakta, som på globalt nivå skal skjules hos alle individer i gedcomfilen.<br /><br />[\"Navn på fakta\"] elementet bestemmer hvilke fakta som skal skjules. [\"Valg\"] elementet velger selv fakta eller relaterete detaljer. [\"Vis til\"] elementet bestemmer på hvilket adgangsnivå fakta vises.<br /><br /> \$global_facts array er beregnet til - på basis av GEDCOM merker (tags) - å skjule visse fakta for alle individer, enten disse er nålevende eller døde. SSN tag er som standard skjult for vanlige besøkende. Dette forhindrer folk i å stjele personnummer og dermed stjele dine avdødes identitet, hvilket egentlig er mest relevant for USA's vedkommende. <br />Hvis du vil skjule alle ekteskapsdata i din gedcomfil for vanlige besøkende, kan du velge:<br /><br />Navn på fakta: (MARR) - Ekteskap (Marriage)<br />Valg: \"Vis fakta\"<br />Vis til?: \"Vis kun til godkjente brukere\"<br /><br />Dinne innstillingen skjuler ekteskap (og relateret detaljer) for alle, som ikke er administratorer.<br /><br />Dette lagres i \$global_facts variablen i den valgte personvernfil.";
$pgv_lang["person_facts_help"]			= "\"person_facts\" innstillinger definer fakta som skjules for en spesifik person i gedcom samt på hvilket nivå disse fakta skjules.<br /><br />Det første element er personens ID, det neste element er data.<br />Elementet [\"Valg\"] velger data eller relaterede detaljer. Elementet [\"Vis til\"] bestemmer på hvilket adgangsnivå disse data vises.<br /><br /> \$person_facts array fungerer på samme måte som \$global_facts array med den forskjell, at du også kan spesifisere GEDCOM ID til den person hvor data skal skjules. Du kan altså skjule ekteskapsfeltet for en bestemt person.<br /><br />Dette lagres i \$person_facts variablen i den valgte personvernfil.";

$pgv_lang["USE_RELATIONSHIP_PRIVACY_help"]	= "Bruk relationsbetinget personvernfil<br /><br /> 'Nei' betyr at godkjente brukere kan se alle nålevende personers data.<br />'Ja' betyr, at brukere kun kan se privat informasjon om nålevende personer de er i slekt med.<br /><br />Dette lagres i \$USE_RELATIONSHIP_PRIVACY variablen i den valgte personvernfil.";
$pgv_lang["MAX_RELATION_PATH_LENGTH_help"]	= "Maks relasjon sti-lenge<br /><br />Tremenninger.<br /><br />Dette lagres i \$MAX_RELATION_PATH_LENGTH variablen i den valgte personvernfil.";
$pgv_lang["SHOW_RESEARCH_LOG_help"]		= "Vis søke-logg<br /><br />Hvilken brukertype kan se søke-loggen, hvis det er installert.<br /><br />Dette lagres i \$SHOW_RESEARCH_LOG variablen i den valgte personvernfil.";
$pgv_lang["MAX_RELATION_PATH_LENGTH"]		= "Maks relasjons-stilengde";
$pgv_lang["CHECK_MARRIAGE_RELATIONS"]		= "Sjekk ekteskaps relasjoner";
$pgv_lang["SHOW_DEAD_PEOPLE"]			= "Vis avdøde personer";
$pgv_lang["name_of_fact"]			= "Navn på fakta";
$pgv_lang["user_name"]				= "Brukernavn";
$pgv_lang["accessible_by"]			= "Vis til?";
$pgv_lang["show_question"]			= "Vis?";
$pgv_lang["hide"]				= "Skjul";
$pgv_lang["person_privacy_settings"]		= "[\$person_privacy] - innstilling";
$pgv_lang["edit_exist_person_privacy_settings"]	= "Rediger eksisterende [\$person_privacy] - innstillinger";
$pgv_lang["person_facts_settings"]		= "[\$person_facts] - indstilliger";
$pgv_lang["edit_exist_person_facts_settings"]	= "Rediger eksisterende [\$person_facts] - innstillinger";
$pgv_lang["edit_exist_user_privacy_settings"]	= "Rediger eksisterende [\$user_privacy] - innstillinger";
$pgv_lang["global_facts_settings"]		= "[\$global_facts] - innstillinger";
$pgv_lang["edit_exist_global_facts_settings"]	= "Rediger eksisterende [\$global_facts] - innstillinger";
$pgv_lang["user_privacy_settings"]		= "[\$user_privacy] - innstillinger";
$pgv_lang["general_settings"]			= "Standard personvern - innstilling";
$pgv_lang["file_read_error"]			= "F E I L !!! Personvernfilen kunne ikke leses!";

//-- language edit utility
$pgv_lang["edit_langdiff"]		= "Endre og konfigurere språk-filer";
$pgv_lang["edit_lang_utility"]		= "Endre språk-fil";
$pgv_lang["edit_lang_utility_help"]	= "Du kan bruke dette verktøyet til å endre innholdet av en språk-fil med hjelp av den engelske teksten.<br />Den vil liste opp innholdet av den originale engelske språk-filen sammen med ditt valgte språk<br />Etter å ha klikket på teksten/beskjeden i din valgte fil, vil et nytt vindu åpnes hvor du kan endre og lagre innholdettil språkfilen din.";
$pgv_lang["language_to_edit"]		= "Språk som skal endre";
$pgv_lang["file_to_edit"]		= "Språkfil-type som skal endres";
$pgv_lang["lang_save"]			= "Lagre";
$pgv_lang["contents"]			= "Innhold";
$pgv_lang["listing"]			= "Listing";
$pgv_lang["no_content"]			= "Ikke noe innhold";
$pgv_lang["editlang_help"]		= "Endre tekst/beskjed fra språk-fil";
$pgv_lang["cancel"]			= "Avbryt";
$pgv_lang["savelang_help"]		= "Lagre endret tekst";
$pgv_lang["original_message"]		= "Original tekst";
$pgv_lang["message_to_edit"]		= "Tekst som skal endres";
$pgv_lang["changed_message"]		= "Endre innhold";
$pgv_lang["message_empty_warning"]	= "-> Advarsel!!! Dette beskjedfeltet er tomt [#LANGUAGE_FILE#] <-";
$pgv_lang["language_to_export"]		= "Eksportere språk";
$pgv_lang["export_lang_utility"]	= "Eksportering av språk-fil";
$pgv_lang["export"]			= "Eksport";
$pgv_lang["export_lang_utility_help"]	= "I denne delen kan du velge et språk og klikke på eksport-knappen for å eksportere hjelpe-tekster fra den valgte konfigurasjon_hjelp språk-filen for å lage en dokumentasjon.";
$pgv_lang["export_ok"]			= "Hjelpetekstene er eksportert";
$pgv_lang["compare_lang_utility"]	= "Sammenligning av språk-filer";
$pgv_lang["compare_lang_utility_help"]	= "Denne valget sammenligner to språk-filer og lager en liste med tillegg og fradrag mellom dem.<br /><br />Se filen [languages/LANG_CHANGELOG.txt] for andre endringer av språk-filer.";
$pgv_lang["new_language"]		= "Nytt språk";
$pgv_lang["old_language"]		= "Gammelt språk";
$pgv_lang["compare"]			= "Sammenlign";
$pgv_lang["comparing"]			= "Språk-filene som er sammenlignet";
$pgv_lang["additions"]			= "Tillegg";
$pgv_lang["no_additions"]		= "Ikke noen tillegg";
$pgv_lang["subtractions"]		= "Fjernet (ikke i bruk lengre)";
$pgv_lang["no_subtractions"]		= "Ingen fjernet";
$pgv_lang["config_lang_utility"]	= "Konfigurasjon av støttede språk";
$pgv_lang["config_lang_utility_help"]	= "Dette valget gir deg mulighet til å aktivere/deaktivere støttede språk i PhpGedView.<br /><br />";
$pgv_lang["active"]			= "Aktiv";
$pgv_lang["active_help"]		= "Gir deg mulighet til å velg om brukere skal kunne endre innholde av språkfilene.";
$pgv_lang["edit_settings"]		= "Endre innstillinger";
$pgv_lang["lang_edit"]			= "Endre";
$pgv_lang["lang_language"]		= "Språk";
$pgv_lang["export_filename"]		= "Navn på filen som inneholder eksport data:";
$pgv_lang["lang_back"]			= "Gå tilbake til hovedmenyen for å endre og konfigurere språk-filer";
$pgv_lang["lang_back_admin"]		= "Tilbake til Admin-meny";
$pgv_lang["lang_name_danish"]		= "Dansk";
$pgv_lang["lang_name_norwegian"]	= "Norsk";
$pgv_lang["lang_name_german"]		= "Tysk";
$pgv_lang["lang_name_english"]		= "Engelsk";
$pgv_lang["lang_name_spanish"]		= "Spansk";
$pgv_lang["lang_name_spanish-ar"]	= "Latin-amerikansk spansk";
$pgv_lang["lang_name_french"]		= "Fransk";
$pgv_lang["lang_name_italian"]		= "Italiensk";
$pgv_lang["lang_name_dutch"]		= "Nederlandsk";
$pgv_lang["lang_name_polish"]		= "Polsk";
$pgv_lang["lang_name_portuguese"]	= "Portugisisk";
$pgv_lang["lang_name_swedish"]		= "Svensk";
$pgv_lang["lang_name_turkish"]		= "Tyrkisk";
$pgv_lang["lang_name_chinese"]		= "Kinesisk";
$pgv_lang["lang_name_hebrew"]		= "Hebraisk";
$pgv_lang["lang_name_russian"]		= "Russisk";
$pgv_lang["original_lang_name"]		= "Original-navn på språk i #D_LANGNAME#";
$pgv_lang["original_lang_name_help"]	= "Ikke noe hjelp enda :-(";
$pgv_lang["lang_shortcut"]		= "Kort-navn for språk filer";
$pgv_lang["lang_shortcut_help"]		= "Ikke noe hjelp enda :-(";
$pgv_lang["lang_filename"]		= "Språk-fil";
$pgv_lang["lang_filename_help"]		= "Navn og sti til standard språk-oversettings-fil.";
$pgv_lang["config_filename"]		= "Filnavn til konfigurasjons-hjelp";
$pgv_lang["config_filename_help"]	= "Navn og sti til konfigurasjon språk-oversettings-fil.";
$pgv_lang["facts_filename"]		= "Fakta-fil";
$pgv_lang["facts_filename_help"]	= "Navn og sti til filen med oversettelser av GEDCOM-Feltnavn.";
$pgv_lang["help_filename"]		= "Hjelpefil";
$pgv_lang["help_filename_help"]	= "Navn og sti til filen med oversettelser av Hjelpetekstene.";
$pgv_lang["flagsfile"]			= "Filnavn til Flagg-bildet";
$pgv_lang["flagsfile_help"]		= "Navn og sti til nasjonsflagg-bildefilen for det valgte språk.";
$pgv_lang["text_direction"]		= "Tekst-retning";
$pgv_lang["text_direction_help"]	= "Ikke noe hjelp enda :-(";
$pgv_lang["date_format"]		= "Dato-format";
$pgv_lang["date_format_help"]		= "Ikke noe hjelp enda :-(";
$pgv_lang["week_start"]			= "Uke-start";
$pgv_lang["week_start_help"]		= "Ikke noe hjelp enda :-(";
$pgv_lang["name_reverse"]		= "Etternavn først";
$pgv_lang["name_reverse_help"]		= "Ikke noe hjelp enda :-(";
$pgv_lang["ltr"]			= "Venstre til høyre";
$pgv_lang["rtl"]			= "Høyre til venstre";
$pgv_lang["file_does_not_exist"]	= "FEIL! Finner ikke filen...";
$pgv_lang["alphabet_upper"]		= "STORE bokstaver alfabetisk";
$pgv_lang["alphabet_upper_help"]	= "Språkets store bokstaver i alfabetisk rekkefølge. Dette brukes for at sortering av navnelister i PhpGedView for det valgte språk.";
$pgv_lang["alphabet_lower"]		= "små bokstaver alfabetisk";
$pgv_lang["alphabet_lower_help"]	= "Språkets små bokstaver i alfabetisk rekkefølge. Dette brukes for at sortering av navnelister i PhpGedView for det valgte språk.";
$pgv_lang["lang_config_write_error"]	= "Feil ved skriving av språkets innstillinger til filen [language_settings.php]. Sjekk rettigheter og prøv igjen.";
$pgv_lang["lang_save_success"]		= "Endringene er lagret for #PGV_LANG#";

// Help message upgrade utility
$pgv_lang["how_upgrade_help"]		= "Oppgraderings-valget<br />Dette valget for oppgradering vil gi deg beskjed om det har kommet en nyere versjon av phpGedView enn du har.<br /><br />Hente en ny versjon?<br />En ny versjon kan enten hentes direkt fra http://sourceforge.net/projects/phpgedview/ eller så kan du la Oppgraderings-valget sjekke om det finnes en nyere versjon. Dersom det det finnes en nyere versjon, vil du bli gitt valget om å hente denne. Dette kan enten være en zip- eller gz-fil eller begge deler.<br /><br />Oppgradere hva da?<br />* PhpGedView<br />Dette vil oppgradere alle de sentrale filene til PhpGedView utenom config.php, privacy.php og authenticate.php. Den oppgraderer også bilde-katalogen.<br />* Index-filer<br />Denne oppgraderer katalogen /index. Bruk denne med varsomhet, fordi filer med samme navn vil bli overskrevet.<br />* Språk<br />Denne oppgraderer /languages katalogen.<br />* Tema<br />Denne oppgraderer /themes katalogen. Bruk denne med varsomhet, fordi endringer som er gjort av standard-temaer vil bli overskrevet.* Konfigurasjons- fil<br />Denne sjekker din nåværende konfigurasjons-fil med den nye konfigurasjons-filen og oppdaterer di nåværende fil med de nye endringer funnet i den nye konfigurasjonsfilen. Dette sikrer deg at du har en oppdatert fil med dine egne innstillinger.<br />* Personvern-file<br />Denne sjekker din(e) nåværende personvern fil(er) med den nye personvern-filen og oppgraderer din nåværende fil med de nye endringen funnet i den nye personvern-filen. Dette sikrer deg at du har den siste filen med dine egne personvern-innstillinger.<br />* Dokumentasjon<br />Denne oppgraderer /doc katalogen.<br />* Forskningslogg<br />Denne oppgraderer Researchlog plugin.<br />* Lage sikkerhetskopi<br />Denne vil lage en sikkerhetskopi av den gamle filen i /backup katalogen.<br />Hvordan oppgradere?<br />1. Velg delene du vil oppgradere<br />2. Klikk på Lagre<br /><br />Utførings-progresjonen vil bli vist nederst.";

?>