<?php
/*=================================================
   charset=utf-8
   Project:	phpGedView
   File:	facts.fr.php
   Author:	John Finlay
   Comments:	Defines an array of GEDCOM codes and the french name facts that they represent.
   Change Log:	8/5/02 - File Created
===================================================*/
# $Id: facts.fr.php,v 1.7.2.1 2004/01/26 22:33:37 yalnifj Exp $
if (preg_match("/facts\...\.php$/", $_SERVER["PHP_SELF"])>0) {
	print "You cannot access a language file directly.";
	exit;
}
// -- Define a fact array to map Gedcom tags with their french values
// -- Traduction pr&eacute;sent&eacute;e sur le site  http://perso.club-internet.fr/rweinl/gedc_fr.htm.
$factarray["ABBR"] = "abr&eacute;viation"; // titre abr&eacute;g&eacute;, description abr&eacute;g&eacute;e ou nom abr&eacute;g&eacute;.
$factarray["ADDR"] = "adresse"; // adresse postale d'un individu, de l'auteur d'un fichier, d'une entreprise, d'une &eacute;cole, etc
$factarray["ADR1"] = "adresse 1"; // premi&egrave;re ligne d'une adresse
$factarray["ADR2"] = "adresse 2"; // deuxi&egrave;me ligne d'une adresse
$factarray["ADOP"] = "adoption"; // cr&eacute;ation du lien enfant-parent quand il n'existe pas de lien biologique.
$factarray["AFN"] = "n° AFN"; // num&eacute;ro unique et permanent du fichier Ancestral File qui contient les informations relatives &agrave;  l'individu
$factarray["AGE"] = "ᦥ"; // ᦥ de l'individu au moment de l'&eacute;v&eacute;nement ou ᦥ qui figure dans le document.
$factarray["AGNC"] = "institution"; // institution ou individu responsable ou d&eacute;cisionnaire
$factarray["ALIA"] = "alias"; // indicateur qui associe des informations diff&eacute;rentes sur une personne.
$factarray["ANCE"] = "anc&ecirc;tres"; // anc&ecirc;tres d'un individu
$factarray["ANCI"] = "int&eacute;r&ecirc;t pour les anc&ecirc;tres"; // indique un int&eacute;r&ecirc;t &agrave; rechercher des informations compl&eacute;mentaires sur les anc&ecirc;tres d'un individu (voir DESI)
$factarray["ANUL"] = "annulation"; // d&eacute;claration de nullit&eacute; d'un mariage (comme s'il n'avait pas eu lieu)
$factarray["ASSO"] = "liens"; // indicateur qui relie des amis, des voisins, des parents ou d'autres personnes &agrave;  un individu
$factarray["AUTH"] = "auteur"; // nom de la personne qui a relev&eacute; les informations ou qui a constitu&eacute; le fichier
$factarray["BAPL"] = "bapt&ecirc;me de l'Eglise des Mormons"; // bapt&ecirc;me de l'Eglise des Mormons (voir aussi BAPM)
$factarray["BAPM"] = "bapt&ecirc;me"; // bapt&ecirc;me (non Mormon, voir aussi BAPL et CHR)
$factarray["BARM"] = "bar_mitzvah"; // c&eacute;r&eacute;monie juive qui a lieu pour les gar&agrave;ons &agrave;  l'ᦥ de 13 ans
$factarray["BASM"] = "bas_mitzvah"; // c&eacute;r&eacute;monie juive qui a lieu pour les filles &agrave;  l'ᦥ de 13 ans, aussi appel&eacute;e "Bat Mitzvah."
$factarray["BIRT"] = "naissance"; // naissance
$factarray["BLES"] = "b&eacute;n&eacute;diction religieuse"; // b&eacute;n&eacute;diction religieuse
$factarray["BLOB"] = "objet binaire"; // ensemble de donn&eacute;es utilis&eacute; par un syst&egrave;me multim&eacute;dia qui g&eacute;re des donn&eacute;es binaires qui repr&eacute;sentent des images, du son et de la vid&eacute;o.
$factarray["BURI"] = "s&eacute;pulture"; // s&eacute;pulture
$factarray["CALN"] = "n° r&eacute;f&eacute;rence"; // num&eacute;ro dans un r&eacute;pertoire qui sert &agrave;  identifier une pi&egrave;ce dans une collection.
$factarray["CAST"] = "caste"; // rang ou statut d'un individu dans une soci&eacute;t&eacute;, selon des crit&egrave;res raciaux ou religieux, des crit&egrave;res de richesse ou autres
$factarray["CAUS"] = "cause"; // description de la cause de l'&eacute;v&eacute;nement ou du fait associ&eacute;, cause du d&eacute;c&egrave;s par exemple.
$factarray["CENS"] = "recensement"; // recensement de population
$factarray["CHAN"] = "modification"; // correction ou modification; en relation avec une DATE qui indique quand le changement est survenu.
$factarray["CHAR"] = "caract&egrave;res"; // indique le jeu de caract&egrave;res utilis&eacute; pour l'&eacute;criture des informations dans le fichier.
$factarray["CHIL"] = "enfant"; // enfant naturel ou adopt&eacute;
$factarray["CHR"] = "bapt&ecirc;me religieux enfant"; // bapt&ecirc;me religieux (non Mormon) d'un enfant.
$factarray["CHRA"] = "bapt&ecirc;me religieux adulte"; // bapt&ecirc;me religieux (non Mormon) d'une personne adulte.
$factarray["CITY"] = "localit&eacute;"; // ville ou village
$factarray["CONC"] = "suite"; // indicateur de continuation des informations qui pr&eacute;c&eacute;dent. Ces informations doivent &ecirc;tre mises &agrave;  la suite de celles qui pr&eacute;c&eacute;dent sans espace ni retour au d&eacute;but de ligne. La coupure avec les informations pr&eacute;c&eacute;dentes doit &ecirc;tre faite au milieu d'un champ et non pas sur un espace (l'espace est un d&eacute;limiteur GEDCOM).
$factarray["CONF"] = "confirmation (sauf Mormons)"; // c&eacute;r&eacute;monie religieuse (non Mormon) par laquelle un individu acquiert la qualit&eacute; de membre &agrave;  part enti&egrave;re de son Eglise.
$factarray["CONL"] = "confirmation (Eglise des Mormons)"; // c&eacute;r&eacute;monie religieuse par laquelle un individu devient membre de l'Eglise des Mormons
$factarray["CONT"] = "suite"; // indicateur de continuation des informations qui pr&eacute;c&eacute;dent, apr&egrave;s un retour &agrave;  la ligne.
$factarray["COPR"] = "copyright"; // protection des informations contre la reproduction et la diffusion.
$factarray["CORP"] = "institution"; // nom d'une entreprise, d'une institution ou autre.
$factarray["CREM"] = "incin&eacute;ration"; // incin&eacute;ration du corps d'un individu d&eacute;c&eacute;d&eacute;.
$factarray["CTRY"] = "pays"; // nom ou code du pays
$factarray["DATA"] = "donn&eacute;es"; // informations stock&eacute;es automatiquement.
$factarray["DATE"] = "date"; // date d'un &eacute;v&eacute;nement au format pr&eacute;vu pour les dates
$factarray["DEAT"] = "d&eacute;c&egrave;s"; // d&eacute;c&egrave;s
$factarray["DESC"] = "descendants"; // descendance d'un individu
$factarray["DESI"] = "int&eacute;r&ecirc;t pour les descendants"; // indique un int&eacute;r&ecirc;t &agrave;  rechercher des descendants de l'individu (voir aussi ANCI)
$factarray["DEST"] = "destination"; // syst&egrave;me ou programme destinataire des donn&eacute;es.
$factarray["DIV"] = "divorce"; // dissolution du mariage
$factarray["DIVF"] = "dossier de divorce"; // dossier de divorce d'un &eacute;poux
$factarray["DSCR"] = "description physique"; // caract&egrave;res physiques de description d'une personne, d'un lieu ou d'une chose
$factarray["EDUC"] = "instruction"; // niveau d'instruction
$factarray["EMIG"] = "&eacute;migration"; // d&eacute;part de son pays avec l'intention de r&eacute;sider ailleurs.
$factarray["ENDL"] = "dotation (Eglise des Mormons)"; // c&eacute;r&eacute;monie religieuse de l'Eglise des Mormons.
$factarray["ENGA"] = "fiancailles"; // fiancailles
$factarray["EVEN"] = "&eacute;v&eacute;nement"; // &eacute;v&eacute;nement int&eacute;ressant &agrave;  propos d'un individu, d'un groupe ou d'une organisation
$factarray["FAM"] = "famille"; // association d'un homme, d'une femme et de leurs enfants selon la loi ou les coutumes, ou famille cr&eacute;&eacute;e par la naissance d'un enfant d'un p&egrave;re et d'une m&egrave;re biologiques.
$factarray["FAMC"] = "famille de l'enfant"; // indique la famille &agrave;  laquelle un enfant appartient
$factarray["FAMF"] = "fichier de la famille"; // nom d'un fichier de familles de l'Eglise des Mormons
$factarray["FAMS"] = "famille des conjoints"; // indique la famille dans laquelle l'individu est l'un des conjoints
$factarray["FCOM"] = "premi&egrave;re communion"; // c&eacute;r&eacute;monie religieuse de premi&egrave;re communion
$factarray["FILE"] = "fichier"; // unit&eacute; de conservation d'informations class&eacute;es pouvant &ecirc;tre r&eacute;f&eacute;renc&eacute;es.
$factarray["FORM"] = "format"; // nom donn&eacute; &agrave;  un format dans lequel des informations peuvent &ecirc;tre transcrites
$factarray["GEDC"] = "gedcom"; // information sur l'utilisation de la norme GEDCOM dans un fichier.
$factarray["GIVN"] = "pr&eacute;nom"; // pr&eacute;nom
$factarray["GRAD"] = "dipl&ocirc;me"; // dipl&ocirc;me ou certificat
$factarray["HEAD"] = "ent&ecirc;te"; // identification des informations du fichier GEDCOM
$factarray["HUSB"] = "p&egrave;re"; // individu mari&eacute; ou p&egrave;re
$factarray["IDNO"] = "n° ident"; // num&eacute;ro d'identification d'une personne dans un fichier, une source ou un syst&egrave;me externe
$factarray["IMMI"] = "immigration"; // arriv&eacute;e dans un nouveau lieu avec intention d'y r&eacute;sider
$factarray["INDI"] = "individu"; // une personne
$factarray["LANG"] = "langue"; // langage utilis&eacute; dans le fichier
$factarray["LEGA"] = "l&eacute;gataire"; // l&eacute;gataire
$factarray["MARB"] = "bans de mariage"; // publication des bans de mariage
$factarray["MARC"] = "contrat de mariage"; // contrat de mariage
$factarray["MARL"] = "autorisation l&eacute;gale de mariage"; // autorisation l&eacute;gale de mariage
$factarray["MARR"] = "mariage"; // cr&eacute;ation d'une famille
$factarray["MARS"] = "contrat avant mariage"; // convention, contrat avant mariage
$factarray["MEDI"] = "m&eacute;dia"; // information sur le support des donn&eacute;es stock&eacute;es
$factarray["NAME"] = "nom"; // mot ou ensemble de mots utilis&eacute;s pour l'identification d'un individu, d'un titre, etc. Il faut utiliser plusieurs lignes NAME pour les personnes qui ont des noms multiples.
$factarray["NATI"] = "nationalit&eacute;"; // nationalit&eacute; d'une personne
$factarray["NATU"] = "naturalisation"; // obtention de la nationalit&eacute;
$factarray["NCHI"] = "nombre d'enfants"; // nombre d'enfants du parent (tous mariages confondus) s'il s'agit d'un individu ou de la famille s'il s'agit d'une famille.
$factarray["NICK"] = "surnom"; // surnom
$factarray["NMR"] = "nombre de mariages"; // nombre de mariages de la personne
$factarray["NOTE"] = "note"; // informations compl&eacute;mentaires ajout&eacute;es pour la compr&eacute;hension des donn&eacute;es
$factarray["NPFX"] = "pr&eacute;fixe du nom"; // texte ou titre qui apparait avant le nom d'une personne (Docteur, G&eacute;n&eacute;ral, Monseigneur...)
$factarray["NSFX"] = "suffixe du nom"; // texte qui apparait apr&egrave;s le nom (Junior ou fils, par exemple)
$factarray["OBJE"] = "objet"; // r&eacute;f&eacute;rence aux donn&eacute;es utilis&eacute;es comme description (g&eacute;n&eacute;ralement un enregistrement audio, une photo ou une vid&eacute;o)
$factarray["OCCU"] = "profession"; // profession
$factarray["ORDI"] = "c&eacute;r&eacute;monie de l'Eglise des Mormons"; // c&eacute;r&eacute;monie de l'Eglise des Mormons
$factarray["ORDN"] = "ordination"; // ordination religieuse
$factarray["PAGE"] = "page"; // num&eacute;ro ou description de l'endroit o&agrave;¹ l'information se trouve dans un ouvrage r&eacute;f&eacute;renc&eacute;
$factarray["PEDI"] = "ascendance"; // Information relative &agrave;  l'individu dans un tableau d'ascendance.
$factarray["PHON"] = "t&eacute;l&eacute;phone"; // num&eacute;ro de t&eacute;l&eacute;phone
$factarray["PLAC"] = "lieu"; // lieu de l'&eacute;v&eacute;nement
$factarray["POST"] = "code postal"; // code postal
$factarray["PROB"] = "testament"; // validation d'un testament
$factarray["PROP"] = "biens"; // biens et possessions
$factarray["PUBL"] = "publication"; // date et lieu de publication d'un ouvrage
$factarray["QUAY"] = "niveau de fiabilit&eacute;"; // degr&eacute; de confiance &agrave;  accorder &agrave;  une information
$factarray["REFN"] = "r&eacute;f&eacute;rence"; // description ou num&eacute;ro d'identification d'un fichier ou de tout autre objet pouvant &ecirc;tre r&eacute;f&eacute;renc&eacute;
$factarray["RELA"] = "valeur du lien"; // valeur du lien dans le contexte
$factarray["RELI"] = "religion"; // religion
$factarray["REPO"] = "d&eacute;positaire"; // &eacute;tablissement ou personne d&eacute;positaire de l'information
$factarray["RESI"] = "domicile"; // domicile
$factarray["RESN"] = "acc&egrave;s restreint"; // indicateur d'acc&egrave;s restreint ou interdit &agrave;  une information
$factarray["RETI"] = "retraite"; // retraite
$factarray["RFN"] = "n° enregistrement"; // num&eacute;ro permanent affect&eacute; &agrave;  un enregistrement pour l'identifier de mani&egrave;re unique dans un fichier
$factarray["RIN"] = "n° enregistrement"; // num&eacute;ro affect&eacute; &agrave;  un enregistrement automatiquement par un syst&egrave;me &eacute;metteur qui est utilis&eacute; pour identifier cet enregistrement dans les r&eacute;sultats produits par un syst&egrave;me r&eacute;cepteur
$factarray["ROLE"] = "r&ocirc;le"; // r&ocirc;le jou&eacute; par un individu dans un &eacute;v&eacute;nement
$factarray["SEX"] = "sexe"; // sexe
$factarray["SLGC"] = "scellement enfant (Eglise des Mormons)"; // c&eacute;r&eacute;monie de l'Eglise des Mormons
$factarray["SLGS"] = "scellement conjoint (Eglise des Mormons)"; // c&eacute;r&eacute;monie de l'Eglise des Mormons
$factarray["SOUR"] = "source"; // document d'origine ou source initiale de l'information
$factarray["SPFX"] = "pr&eacute;fixe du nom de famille"; // partie d'un nom de famille qui n'est pas index&eacute;e
$factarray["SSN"] = "num&eacute;ro de s&eacute;curit&eacute; sociale"; // num&eacute;ro de s&eacute;curit&eacute; sociale
$factarray["STAE"] = "&eacute;tat"; // &eacute;tat (division g&eacute;ographique ou juridictionnelle)
$factarray["STAT"] = "&eacute;tat"; // &eacute;tat (condition)
$factarray["SUBM"] = "fournisseur"; // individu ou organisation qui fournit les donn&eacute;es g&eacute;n&eacute;alogiques
$factarray["SUBN"] = "donn&eacute;es &agrave;  traiter"; // ensemble de donn&eacute;es &agrave;  traiter
$factarray["SURN"] = "nom de famille"; // nom de famille
$factarray["TEMP"] = "temple (Eglise des Mormons)"; // nom ou code d'identification d'un temple de l'Eglise des Mormons
$factarray["TEXT"] = "texte"; // texte exact provenant d'un document original
$factarray["TIME"] = "heure"; // heures (entre 0 et 24), minutes et secondes s&eacute;par&eacute;es par les deux points (:). Secondes et centi&egrave;mes de secondes sont optionnels.
$factarray["TITL"] = "titre"; // description d'un ouvrage, comme le titre d'un livre; titre de noblesse ou titre honorifique pour un individu
$factarray["TRLR"] = "fin de fichier"; // marque de fin d'un fichier GEDCOM
$factarray["TYPE"] = "type"; // d&eacute;finition compl&eacute;mentaire de l'identificateur pr&eacute;c&eacute;dent.
$factarray["VERS"] = "version"; // indique la version d'un produit, d'un composant ou d'un ouvrage utilis&eacute; ou r&eacute;f&eacute;renc&eacute;
$factarray["WIFE"] = "&eacute;pouse"; // &eacute;pouse
$factarray["WILL"] = "testament"; // testament (voir aussi PROB)
$factarray["_EMAIL"] = "courriel";
$factarray["EMAIL"] = "courriel";
$factarray["_TODO"] = "note";
$factarray["_UID"] = "UID";

// Faits sp袩fiques aux gedcom export豠par Family Tree Maker
$factarray["_MDCL"] = "m&eacute;dical";
$factarray["_DEG"] = "dipl&ocirc;me";
$factarray["_MILT"] = "service militaire";
$factarray["_SEPR"] = "s&eacute;par&eacute;";
$factarray["_DETS"] = "mort de la premi&egrave;re &eacute;pouse";
$factarray["CITN"] = "citoyennet&eacute;";

// Other common customized facts
$factarray["_ADPF"] = "Adoption par le p&egrave;re";
$factarray["_ADPM"] = "Adoption par la m&egrave;re";
$factarray["_AKAN"] = "Aussi sous le nom de";
$factarray["_BRTM"] = "Brit mila";
$factarray["_COML"] = "Mariage l&eacute;gal";
$factarray["_EYEC"] = "Couleur des yeux";
$factarray["_FNRL"] = "Fun&eacute;railles";
$factarray["_HAIR"] = "Couleur des cheveux";
$factarray["_HEIG"] = "Taille";
$factarray["_INTE"] = "Inhumation";
$factarray["_MARI"] = "Promesse de mariage";
$factarray["_MBON"] = "Lien par mariage";
$factarray["_MEDC"] = "Condition m&eacute;dicale";
$factarray["_MILI"] = "Militaire";
$factarray["_NMR "] = "Non mari&eacute;(e)";
$factarray["_NLIV"] = "Non vivant(e)";
$factarray["_NMAR"] = "Jamais mari&eacute;(e)";
$factarray["_PRMN"] = "Num&eacute;ro permanent";
$factarray["_SEPR"] = "S&eacute;paration";
$factarray["_WEIG"] = "Poids";
$factarray["_YART"] = "Yartzeit";

$factarray["Living"] = "domicile";
$factarray["Milit-Beg"] = "serv. militaire";

if (file_exists($PGV_BASE_DIRECTORY . "languages/facts.fr.extra.php")) require $PGV_BASE_DIRECTORY . "languages/facts.fr.extra.php";

?>