<?php
/*=================================================
   charset=utf-8
   Project:	phpGedView
   File:	lang.da.php
   Author:	John Finlay
   Translation:	Arne Eckmann
   Comments:	Danish Language file for PHPGedView
   Change Log:	See LANG_CHANGELOG.txt
===================================================*/
# $Id: lang.da.php,v 1.31.2.3 2004/02/03 21:36:07 botak Exp $
if (preg_match("/lang\...\.php$/", $_SERVER["PHP_SELF"])>0) {
	print "You cannot access a language file directly.";
	exit;
}

//-- GENERAL HELP MESSAGES
$pgv_lang["qm"]				= "?";
$pgv_lang["page_help"]			= "Hjælp";

//-- CONFIG FILE MESSAGES
$pgv_lang["error_title"]		= "FEJL: kan ikke åbne GEDCOM filen";
$pgv_lang["error_header"] 		= "GEDCOM filen, $GEDCOM, findes ikke på det specificerede sted.";
$pgv_lang["for_support"]		= "For hjælp og information kontakt";
$pgv_lang["for_contact"]		= "For hjælp med slægtsspørgsmål kontakt";
$pgv_lang["for_all_contact"]	= "For hjælp og slægtsspørgsmål, kontakt";
$pgv_lang["build_title"]		= "Opbygger indeksfiler";
$pgv_lang["build_error"]		= "En ny GEDCOM fil blev fundet.";
$pgv_lang["please_wait"]		= "Vent venligst mens Indeksfilerne genopbygges.";
$pgv_lang["choose_gedcom"]		= "Vælg et GEDCOM datasæt";
$pgv_lang["username"]			= "Brugernavn:";
$pgv_lang["password"]			= "Password:";
$pgv_lang["login"]				= "Log på";
$pgv_lang["login_aut"]			= "Rediger bruger";
$pgv_lang["logout"]				= "Log af";
$pgv_lang["admin"]				= "Administration";
$pgv_lang["logged_in_as"]		= "Logget på som";
$pgv_lang["my_pedigree"]		= "Mit Anetræ";
$pgv_lang["my_indi"]			= "Mit Indi";
$pgv_lang["yes"]				= "Ja";
$pgv_lang["no"]					= "Nej";
$pgv_lang["add_gedcom"]			= "Tilføj en gedcomfil";
$pgv_lang["no_support"]			= "Opgrader venligst din browser til en nyere version.";

//-- INDEX (PEDIGREE_TREE) FILE MESSAGES
$pgv_lang["index_header"]		= "Anetræ";
$pgv_lang["gen_ped_chart"]	= "#PEDIGREE_GENERATIONS# Generationers anetræ";
$pgv_lang["generations"]		= "Generationer";
$pgv_lang["view"]				= "Vis";
$pgv_lang["fam_spouse"]			= "Familie med partner:";
$pgv_lang["root_person"]		= "Proband ID:";
$pgv_lang["hide_details"]		= "Skjul detaljer";
$pgv_lang["show_details"]		= "Vis detaljer";
$pgv_lang["person_links"]	= "Link til ane/efterkommer -træer, familie(r), og nære slægtninge til denne person.";
$pgv_lang["zoom_box"]		= "Zoom denne boks ind/ud";
$pgv_lang["portrait"]		= "Portræt";
$pgv_lang["landscape"]		= "Landskab";
$pgv_lang["start_at_parents"]	= "Start med forældre";

//-- FUNCTIONS FILE MESSAGES
$pgv_lang["unable_to_find_family"]	= "Kan ikke finde familien med id";
$pgv_lang["unable_to_find_indi"]	= "Kan ikke finde personen med id";
$pgv_lang["unable_to_find_record"]	= "Kan ikke finde record med id";
$pgv_lang["unable_to_find_source"]	= "Kan ikke finde kilden med id";
$pgv_lang["unable_to_find_repo"]	= "Kan ikke finde Repository med id";
$pgv_lang["repo_name"]			= "Repository navn:";
$pgv_lang["address"]			= "Adresse:";
$pgv_lang["phone"]			= "Tlf:";
$pgv_lang["source_name"]		= "Kildenavn:";
$pgv_lang["title"]			= "Titel:";
$pgv_lang["author"]			= "Forfatter:";
$pgv_lang["publication"]		= "Publikation:";
$pgv_lang["call_number"]		= "Arkivnummer:";
$pgv_lang["living"]			= "Lever";
$pgv_lang["private"]			= "Privat";
$pgv_lang["birth"]			= "Fødsel:";
$pgv_lang["death"]			= "Død:";
$pgv_lang["descend_chart"]		= "Efterkommeroversigt";
$pgv_lang["individual_list"]		= "Personliste";
$pgv_lang["family_list"]		= "Familieliste";
$pgv_lang["source_list"]		= "Kildeliste";
$pgv_lang["place_list"]			= "Stednavne";
$pgv_lang["media_list"]			= "MultiMedia liste";
$pgv_lang["search"]			= "Søg";
$pgv_lang["clippings_cart"]		= "Familietræ udklipsmappe";
$pgv_lang["not_an_array"]		= "Ikke et array";
$pgv_lang["print_preview"]		= "Print preview";
$pgv_lang["change_lang"]		= "Skift sprog";
$pgv_lang["print"]			= "Print";
$pgv_lang["total_queries"]		= "Antal Database opslag:";
$pgv_lang["back"]				= "Tilbage";

//-- INDIVDUAL FILE MESSAGES
$pgv_lang["male"]			= "Mand";
$pgv_lang["female"]			= "Kvinde";
$pgv_lang["temple"]			= "LDS Temple";
$pgv_lang["temple_code"]		= "LDS Temple Code:";
$pgv_lang["status"]			= "Status";
$pgv_lang["source"]			= "Kilde:";
$pgv_lang["citation"]			= "Citat:";
$pgv_lang["text"]			= "Tekst:";
$pgv_lang["note"]			= "Note:";
$pgv_lang["unrecognized_code"]		= "Ukendt GEDCOM kode";
$pgv_lang["indi_info"]			= "Individual Information";
$pgv_lang["pedigree_chart"]		= "Anetræ";
$pgv_lang["desc_chart2"]		= "Efterkommertræ";
$pgv_lang["family"]			= "Familie";
$pgv_lang["as_spouse"]			= "Familie med partner";
$pgv_lang["as_child"]			= "Familie med forældre";
$pgv_lang["view_gedcom"]		= "Vis GEDCOM Record";
$pgv_lang["add_to_cart"]		= "Tilføj til udklipsmappen";
$pgv_lang["still_living_error"]	= "Personen lever stadig eller vil ikke have personlige datoer registreret. Alle detaljer om levende personer er skjult for offentligheden.<br />For yderligere information kontakt";
$pgv_lang["privacy_error"]		= "Detaljer om denne person er private.<br />";
$pgv_lang["more_information"]	= "For yderligere information kontakt";
$pgv_lang["name"]			= "Navn:";
$pgv_lang["given_name"]			= "Fornavn(e):";
$pgv_lang["surname"]			= "Efternavn:";
$pgv_lang["suffix"]			= "Suffiks:";
$pgv_lang["object_note"]		= "Objekt Notat:";
$pgv_lang["sex"]			= "Køn:";
$pgv_lang["personal_facts"]		= "Personlige facts og detaljer";
$pgv_lang["type"]			= "Type";
$pgv_lang["date"]			= "Dato";
$pgv_lang["place_description"]		= "Sted / Beskrivelse";
$pgv_lang["parents"] 			= "Forældre:";
$pgv_lang["siblings"] 			= "Søskende";
$pgv_lang["father"] 			= "Far";
$pgv_lang["mother"] 			= "Mor";
$pgv_lang["relatives"]			= "Nære slægtninge";
$pgv_lang["child"]			= "Barn";
$pgv_lang["spouse"]			= "Partner";
$pgv_lang["surnames"]			= "Efternavne";
$pgv_lang["adopted"]			= "Adopteret";
$pgv_lang["foster"]				= "Foster";
$pgv_lang["sealing"]			= "Forsegling";
$pgv_lang["link_as"]			= "Forbind denne person til en eksisterende familie som ";

//-- FAMILY FILE MESSAGES
$pgv_lang["family_info"]		= "Familieinformation";
$pgv_lang["family_group_info"]	= "Familielgruppe information";
$pgv_lang["husband"]			= "Ægtemand:";
$pgv_lang["wife"]				= "Hustru:";
$pgv_lang["marriage"]			= "Bryllup:";
$pgv_lang["lds_sealing"]		= "LDS Sealing:";
$pgv_lang["marriage_license"]	= "Marriage License:";
$pgv_lang["media_object"]		= "Multimedieobjekt:";
$pgv_lang["children"]			= "Børn";
$pgv_lang["no_children"]		= "Ingen børn";
$pgv_lang["parents_timeline"]	= "Vis forældre på<br />en tidslinje";


//-- CLIPPINGS FILE MESSAGES
$pgv_lang["clip_cart"]			= "Udklipsmappe";
$pgv_lang["clip_explaination"]		= "Familietræets udklipsmappe gør det muligt for dig at tage &quot;udklip&quot; fra dette familietræ og samle disse i en enkelt GEDCOM fil, som kan downloades.<br /><br />";
$pgv_lang["item_with_id"]		= "Item med id";
$pgv_lang["error_already"]		= "findes i forvejen i din udklipsmappe.";
$pgv_lang["which_links"]		= "Hvilke link fra denne familie vil du tilføje?";
$pgv_lang["just_family"]		= "Tilføj kun denne familie record.";
$pgv_lang["parents_and_family"]		= "Tilføj forældrene til denne familie record.";
$pgv_lang["parents_and_child"]		= "Tilføj forældre og børn til denne familie record.";
$pgv_lang["parents_desc"]		= "Tilføj forældre og alle efterkommere til denne familie record.";
$pgv_lang["continue"]			= "Fortsæt med at tilføje";
$pgv_lang["which_p_links"]		= "Hvilke link fra denne person vil du tilføje?";
$pgv_lang["just_person"]		= "Tilføj kun denne person.";
$pgv_lang["person_parents_sibs"]	= "Tilføj denne person, samt forældre og søskende.";
$pgv_lang["person_ancestors"]		= "Tilføj denne person, samt dennes aner i direkte linje.";
$pgv_lang["person_ancestor_fams"]	= "Tilføj denne person, og dennes aner i direkte linje samt deres familier.";
$pgv_lang["person_spouse"]		= "Tilføj denne person, samt partner og børn.";
$pgv_lang["person_desc"]		= "Tilføj denne person, partner, og alle efterkommere.";
$pgv_lang["unable_to_open"]		= "Der kan ikke skrives til udklipsmappe";
$pgv_lang["person_living"]		= "Denne person lever stadig.  Personlige data er derfor ikke inkluderet.";
$pgv_lang["person_private"]		= "Denne persons data er private.  Personlige data er derfor ikke inkluderet.";
$pgv_lang["family_private"]		= "Detaljerede oplysninger om denne familie er privat. Detaljerede familieoplysninger bliver ikke inkluderet.";
$pgv_lang["download"]			= "Højreklik (control-click på Mac) på link herunder og vælg &quot;Gem som&quot; for at downloade filerne.";
$pgv_lang["latest"]						= "Du bruger den nyeste version af phpGedView.";
$pgv_lang["location"]					= "Placering af opgraderingsfiler:";
$pgv_lang["include"]					= "Inkluder:";
$pgv_lang["options"]			= "Valgmuligheder:";
$pgv_lang["inc_phpgedview"]		= "PhpGedView";
$pgv_lang["inc_languages"]		= "Sprog";
$pgv_lang["inc_config"]				= "Konfigurationsfil";
$pgv_lang["inc_researchlog"]	= "Forskningslog";
$pgv_lang["inc_index"]				= "Indeksfiler";
$pgv_lang["inc_themes"]				= "Temaer";
$pgv_lang["inc_docs"]					= "Manualer";
$pgv_lang["upgrade_help"]		= "Hjælp mig";
$pgv_lang["inc_backup"]			= "Lav backup";
$pgv_lang["inc_privacy"]			= "Privatlivsfil(er)";
$pgv_lang["cannot_read"]			= "Kan ikke læse fil:";
$pgv_lang["not_configured"]		= "Du har ikke konfigureret PhpGedView endnu. ";
$pgv_lang["location_upgrade"]	= "Oplys om placering af dine opgraderingsfiler.";
$pgv_lang["new_variable"]			= "Ny variable er fundet:";
$pgv_lang["config_open_error"] = "Der opstod fejl under åbning af konfigurationsfilen.";
$pgv_lang["config_write_error"] = "Fejl! Der kan ikke skrives til konfigurationsfilen.";
$pgv_lang["config_update_ok"]	= "Opdatering af konfigurationsfil lykkedes.";
$pgv_lang["privacy_write_error"]	= "FEJL! Der kan ikke skrives til filen [#PRIVACY_MODULE#].<br />Sørg for at sætte skriverettigheder på filen.<br />Når privatlivsfilen er skrevet kan skriverettighederne fjernes igen.";
$pgv_lang["config_uptodate"]	=	"Din konfigurationsfil er up-to-date.";
$pgv_lang["processing"]				=	"Bearbejder...";
$pgv_lang["privacy_open_error"] = "Der opstod fej under åbning af [#PRIVACY_MODULE#] filen.";
$pgv_lang["privacy_update_ok"]	= "Opdatering af privatlivfil: [#PRIVACY_MODULE#] lykkedes.";
$pgv_lang["privacy_uptodate"]	=	"Din [#PRIVACY_MODULE#] fil er up-to-date.";
$pgv_lang["heading_privacy"]	= "Privatlivsfil(er):";
$pgv_lang["heading_phpgedview"]	= "PhpGedView filer:";
$pgv_lang["heading_image"]			=	"Billedfiler:";
$pgv_lang["heading_index"] 			= "Indeksfiler:";
$pgv_lang["heading_language"]		= "Sprogfiler:";
$pgv_lang["heading_theme"]			= "Tema filer";
$pgv_lang["heading_docs"]				= "Manualer:";
$pgv_lang["heading_researchlog"]= "Forskningslogfiler:";
$pgv_lang["heading_researchloglang"]	=	"Forskningslog sprogfiler:";
$pgv_lang["copied_success"]			= "Kopiering lykkedes.";
$pgv_lang["backup_copied_success"]		= "Det lykkedes at oprette backup filen.";
$pgv_lang["process_error"]		= "Der er problemer med at tilgå siden. Det kan derfor ikke afgøres, om der findes en nyere version. ";
$pgv_lang["folder_created"]			= "Oprettede mappe";
$pgv_lang["media_files"]		= "Media filer der er reference til i denne GEDCOM";
$pgv_lang["cart_is_empty"]		= "Din udklipsmappe er tom.";
$pgv_lang["id"]				= "ID";
$pgv_lang["name_description"]		= "Navn / Beskrivelse";
$pgv_lang["remove"]			= "Fjern";
$pgv_lang["empty_cart"]			= "Tøm mappen";
$pgv_lang["download_now"]		= "Download nu";
$pgv_lang["source_downloaded_from"]	= "Denne kilde blev downloaded fra:";
$pgv_lang["family_downloaded_from"]	= "Denne familie blev downloaded fra:";
$pgv_lang["indi_downloaded_from"]	= "Denne person blev downloaded fra:";

//-- PLACELIST FILE MESSAGES
$pgv_lang["connections"]		= "Stednavnsforbindelser fundet<br />bese resultat nu";
$pgv_lang["top_level"]			= "Top niveau";
$pgv_lang["form"]				= "Stednavne vises som:";
$pgv_lang["default_form"]		= "By/sted, Amt, Stat/Provins, Land";
$pgv_lang["default_form_info"]			= "(Default)";
$pgv_lang["gedcom_form_info"]			= "(Gedcom)";
$pgv_lang["individuals"]			= "Individer";
$pgv_lang["unknown"]			= "Ukendt";

//-- MEDIALIST FILE MESSAGES
$pgv_lang["multi_title"]		= "MultiMedia objektliste";
$pgv_lang["media_found"]		= "Media objekter fundet";
$pgv_lang["view_person"]		= "Vis person";
$pgv_lang["view_family"]		= "Vis familie";
$pgv_lang["view_source"]		= "Vis kilde";
$pgv_lang["prev"]				= "< Forrige";
$pgv_lang["next"]				= "Næste >";
$pgv_lang["file_not_found"]		= "Fil ikke fundet.";

//-- SEARCH FILE MESSAGES
$pgv_lang["search_gedcom"]		= "Søg GEDCOM fil";
$pgv_lang["enter_terms"]		= "Indtast søgeord:";
$pgv_lang["soundex_search"]		= "Soundex navnesøgning:";
$pgv_lang["search_results"]		= "Søgeresultat(er):";
$pgv_lang["sources"]			= "KILDER";
$pgv_lang["firstname_search"]		= "Fornavn:";
$pgv_lang["lastname_search"]		= "Efternavn:";
$pgv_lang["search_place"]		= "Sted:";
$pgv_lang["search_year"]		= "År:";
$pgv_lang["lastname_empty"]		= "Indtast venligst efternavn.";
$pgv_lang["no_results"]				= "Intet fundet.";
$pgv_lang["soundex_results"]		= "Måske kan det følgende soundex resultat bruges.";

//-- SOURCELIST FILE MESSAGES
$pgv_lang["source_list"]		= "Kildeliste";
$pgv_lang["sources_found"]		= "Kilder fundet";

//-- SOURCE FILE MESSAGES
$pgv_lang["source_info"]		= "Kildeinformation";
$pgv_lang["other_records"]		= "Andre Records der refererer til denne kilde:";
$pgv_lang["people"]				= "PERSONER";
$pgv_lang["families"]			= "FAMILIER";

//-- BUILDINDEX FILE MESSAGES
$pgv_lang["building_indi"]		= "Opbygger person og familie indeks";
$pgv_lang["building_index"]		= "Opbygger indekslister";
$pgv_lang["importing_records"]		= "Importerer records til database";
$pgv_lang["detected_change"]		= "phpGedView har opdaget en ændring i GEDCOM fil #GEDCOM#. Indeks filer skal genopbygges før der kan fortsættes.";
$pgv_lang["please_be_patient"]		= "VENT VENLIGST";
$pgv_lang["reading_file"]		= "Indlæser Gedcom fil";
$pgv_lang["flushing"]			= "Fjerner indhold";
$pgv_lang["found_record"]		= "Fandt record";
$pgv_lang["exec_time"]			= "Total processtid:";
$pgv_lang["unable_to_create_index"]	= "Indeksfil kan ikke oprettes. Sørg for, de fornødne skrivetilladelser på phpGedView mappen.  Skrivebeskyttelse kan evt. genetableres når indeksfiler er oprettet.";
$pgv_lang["indi_complete"]		= "Opdatering af personindeksfil er komplet.";
$pgv_lang["family_complete"]		= "Opdatering af familieindeksfil er komplet.";
$pgv_lang["source_complete"]		= "Opdatering af kildeindeksfil er komplet.";
$pgv_lang["tables_exist"]		= "PHPGedView tabeller findes allerede i databasen";
$pgv_lang["you_may"]			= "Du kan:";
$pgv_lang["drop_tables"]		= "Drop nuværende tabeller";
$pgv_lang["import_multiple"]	= "Importer og arbejd med forskellige gedcom filer";
$pgv_lang["explain_options"]	= "Hvis du vælger at droppe tabellerne vil alle data blive udskiftet med denne gedcom.<br />Hvis du vælger at importere og arbejde med flere samtidige gedcom filer, vil phpGedView slette alle data, der blev importeret fra gedcom fil(er) med samme navn. Denne feature gør det muligt at gemme flere samtidige GEDCOM datasæt i de samme tabeller og nemt skifte frem og tilbage mellem disse.";
$pgv_lang["path_to_gedcom"]		= "Indtast stien til din GEDCOM fil:";
$pgv_lang["gedcom_title"]		= "Indtast en titel, der beskriver data i denne GEDCOM fil:";
$pgv_lang["dataset_exists"]		= "Der er allerede importeret en GEDCOM fil til databasen med dette navn.";
$pgv_lang["empty_dataset"]		= "Vil du tømme datasættet?";
$pgv_lang["index_complete"]		= "Indeks komplet.";
$pgv_lang["click_here_to_go_to_pedigree_tree"] = "Klik her for at komme til anetræet.";
$pgv_lang["updating_is_dead"]		= "opdaterer \"er død\" status for INDI";
$pgv_lang["import_complete"]		= "Import komplet";
$pgv_lang["updating_family_names"]	= "Opdaterer familienavne for FAM";
$pgv_lang["processed_for"]			= "Behandlede fil for";
$pgv_lang["run_tools"]				= "Vil du bruge et af de flg. værktøjer på din GEDCOM førend den importeres: ";
$pgv_lang["addmedia"]				= "Tilføj mediaværktøj";
$pgv_lang["dateconvert"]			= "Datokonverteringsværktøj ";
$pgv_lang["xreftorin"]				= "Konverter XREF ID-nummer til RIN nummer  ";
$pgv_lang["tools_readme"]			= "For yderligere information, læs under tools i #README.TXT#.";

//-- INDIVIDUAL AND FAMILYLIST FILE MESSAGES
$pgv_lang["total_fams"]			= "Total antal familier";
$pgv_lang["total_indis"]		= "Total antal personer";
$pgv_lang["starts_with"]		= "Starter med:";
$pgv_lang["person_list"]		= "Personliste:";
$pgv_lang["paste_person"]		= "Indsæt person";
$pgv_lang["notes_sources_media"]	= "Noter, kilder, og media";
$pgv_lang["name_contains"]		= "Navn indeholder:";
$pgv_lang["filter"]			= "Filter";
$pgv_lang["find_individual"]		= "Find individuel ID";
$pgv_lang["skip_surnames"]		= "Drop efternavnsliste";
$pgv_lang["show_surnames"]		= "Vis efternavnsliste";
$pgv_lang["all"]			= "ALLE";

//-- TIMELINE FILE MESSAGES
$pgv_lang["age"]			= "Alder";
$pgv_lang["timeline_title"]		= "phpGedView Tidslinje";
$pgv_lang["timeline_chart"]		= "Tidslinje";
$pgv_lang["remove_person"]		= "Fjern person";
$pgv_lang["show_age"]			= "Vis aldersmarkør";
$pgv_lang["add_another"]		= "Tilføj en person til skemaet:<br />Person ID:";
$pgv_lang["find_id"]			= "Find ID";
$pgv_lang["show"]			= "Vis";
$pgv_lang["year"]			= "År:";
$pgv_lang["timeline_instructions"]	= "De nyeste browsere tillader, man kan klikke og flytte rundt med boksene.";
$pgv_lang["zoom_out"]				= "Zoom ud";
$pgv_lang["zoom_in"]				= "Zoom ind";

//-- MONTH NAMES
$pgv_lang["jan"]			= "januar";
$pgv_lang["feb"]			= "februar";
$pgv_lang["mar"]			= "marts";
$pgv_lang["apr"]			= "april";
$pgv_lang["may"]			= "maj";
$pgv_lang["jun"]			= "juni";
$pgv_lang["jul"]			= "juli";
$pgv_lang["aug"]			= "august";
$pgv_lang["sep"]			= "september";
$pgv_lang["oct"]			= "oktober";
$pgv_lang["nov"]			= "november";
$pgv_lang["dec"]			= "december";
$pgv_lang["abt"]			= "ca.";
$pgv_lang["aft"]			= "efter";
$pgv_lang["and"]			= "og";
$pgv_lang["bef"]			= "før";
$pgv_lang["bet"]			= "mellem";
$pgv_lang["cal"]			= "beregnet";
$pgv_lang["est"]			= "anslået";
$pgv_lang["from"]			= "fra";
$pgv_lang["int"]			= "tolket";
$pgv_lang["to"]				= "til";
$pgv_lang["cir"]			= "cirka";
$pgv_lang["apx"]			= "omtrent";

$pgv_lang["check_delete"]		= "Er du sikker på at du vil slette disse gedcom data?";
$pgv_lang["access_denied"]		= "<b>Adgang nægtet</b><br />Du har ikke adgangsret til denne ressource.";
$pgv_lang["changes_exist"]		= "Der er lavet ændringer i denne GEDCOM.";
$pgv_lang["accept_changes"]		= "Accept/Afvis ændringer";
$pgv_lang["gedrec_deleted"]		= "GEDCOM record blev slettet.";
$pgv_lang["gedcom_deleted"]		= "GEDCOM [#GED#] blev slettet.";
$pgv_lang["show_changes"]		= "Denne record er opdateret. Klik her for at se ændringer.";
$pgv_lang["review_changes"]		= "Bese GEDCOM ændringer";
$pgv_lang["undo_successful"]	= "Fortryd lykkedes";
$pgv_lang["undo"]				= "Fortryd";
$pgv_lang["changes_occurred"]	= "Følgende ændringer indtraf for denne person:";
$pgv_lang["find_place"]			= "Find stednavn";
$pgv_lang["close_window"]		= "Luk vindue";
$pgv_lang["close_window_without_refresh"]	= "Luk vindue uden skærmopdatering";
$pgv_lang["view_change_diff"]	= "Bese ændring, forskel";
$pgv_lang["place_contains"]		= "Stednavn indholder:";
$pgv_lang["accept_gedcom"]		= "Fortryd en ændring ved at klikke på fortryd link ud for ændring. Accepter alle ændringer i gedcom, ved at genimportere gedcomfilen.";
$pgv_lang["ged_import"]			= "Importer Gedcom";
$pgv_lang["now_import"]			= "Nu skal du importere gedcomfilens indhold ind i phpGedView ved at klikke på import linket herunder.";
$pgv_lang["add_note"]			= "Tilføj note til fakta";
$pgv_lang["delete_source"]		= "Slet denne kilde";
$pgv_lang["confirm_delete_source"]	= "Er du sikker på, at du vil slette denne kilde fra GEDCOM filen?";
$pgv_lang["add_husb"]			= "Tilføj ægtemand";
$pgv_lang["add_husb_to_family"]	= "Tilføj en far til denne familie";
$pgv_lang["add_wife"]			= "Tilføj kone";
$pgv_lang["add_wife_to_family"]	= "Tilføj en mor til denne familie";
$pgv_lang["find_family"]			= "Find familie";
$pgv_lang["add_new_wife"]		= "Tilføj en ny kone";
$pgv_lang["add_new_husb"]		= "Tilføj en ny ægtemand";
$pgv_lang["edit_name"]			= "Rediger navn";
$pgv_lang["delete_name"]		= "Slet navn";
$pgv_lang["add_unlinked_person"]	= "Tilføj en ny uforbunden person";
$pgv_lang["no_temple"]			= "No Temple - Living Ordinance";
$pgv_lang["add_source"]			= "Tilføj kilden til fakta";
$pgv_lang["set_link"]			= "Lav link";
$pgv_lang["find_media"]			= "Find media";
$pgv_lang["confirm_delete_person"]	= "Er du sikker på, at du vil slette denne person fra gedcomfilen?";
$pgv_lang["must_provide"]		= "Du må oplyse en";
$pgv_lang["delete_person"]		= "Slet denne person";
$pgv_lang["update_successful"]	= "Opdatering lykkedes";
$pgv_lang["add_child_to_family"]	= "Tilføj et barn til denne familie";
$pgv_lang["add_child"]			= "Tilføj barn";
$pgv_lang["add_fact"]			= "Tillføj data";
$pgv_lang["add"]				= "Tilføj";
$pgv_lang["custom_event"]		= "Custom event";
$pgv_lang["upload_successful"]	= "Upload lykkedes";
$pgv_lang["requestpassword"]	= "Bestil nyt password";
$pgv_lang["requestaccount"]		= "Bestil ny brugerkonto";
$pgv_lang["register_info_01"]		= "Den offentligt tilgængelige mængde kan være begrænset iht. gældende regler om beskyttelse af privatlivets fred. Nogle mennesker ønsker ikke deres personlige data fremvist offentligt på internettet, idet disse data evt. kan misbruges i forbindelse med spam eller opbygning af en falsk identitet.<br /><br />For at få adgang til private data, er du nødt til at have en konto på dette website. For at få en konto må du registrere dig selv og give de ønskede oplysninger om dig selv. Når administratoren har tjekket din registrering og godkendt dig, vil du kunne login på sitet og se de private data.<br /><br />Dersom der eksisterer krav beslægtning, vil du kun kunne få adgang til dine egne nære slægtninges private data efter login. Administratoren har mulighed for at give dig adgang til at redigere i databasen, således du kan ændre eller tilføje oplysninger.<br /><br />BEMÆRK: Du vil kun få adgang til private data hvis du kan sandsynliggøre du er en nær slætning til en person i databasen.<br /><br />Hvis du ikke er en nær slægtning vil du formentlig ikke få oprettet en konto, hvorfor du lige så godt kan spare dig selv for ulejligheden med at bede om det.<br />Ønskes yderligere hjælp, kan du - såfremt den mulighed er aktiveret - bruge linket herunder til at kontakte webmaster.<br /><br />";
$pgv_lang["pls_note01"]			= "Bemærk: Systemet skelner mellem store og små bogstaver!";
$pgv_lang["min6chars"]			= "Password skal indeholde mindst 6 tegn";
$pgv_lang["pls_note02"]			= "Bemærk: Password må kun indeholde bogstaver og tal. Andre tegn i password kan resultere i at man ikke kan få adgang på visse systemer.";
$pgv_lang["pls_note03"]			= "Denne e-mail adresse undersøges før en konto aktiveres. E-mail adressen fremvises ikke på dette site. Du vil få tilsendt en e-mail til denne adresse, med dine registreringsdata.";
$pgv_lang["emailadress"]		= "E-mail adresse:";
$pgv_lang["pls_note04"]			= "Felter derer markeret med * skal udfyldes.";
$pgv_lang["pls_note05"]			= "Vedr. fuldendelse af formen på denne side og verificering af dine svar vil du få tilsendt en bekræftelses e-mail til den e-mail adresse du har oplyst her. Ved hjælp af denne e-mail kan du aktivere din konto. Såfremt du ikke aktiverer kontoen indenfor syv dage, vil kontoen blive slettet (på dette tidspunkt kan du så oprette kontoen igen). For at kunne bruge dette site, har du brug for dit brugernavn og dit password. Du skal oplyse en eksisterende og gyldig e-mailadresse her, således du er istand til at modtage kontoens bekræftelses e-mail.<br /><br />Hvis du støder ind i et problem i forbindelse med at oprette en konto på dette website, så kontakt venligst webmaster desangående.";
$pgv_lang["mail01_line01"]		= "Hallo #user_fullname# ...";
$pgv_lang["mail01_line02"]		= "( #SERVER_NAME# ) blev anmodet om login med din e-mailadresse ( #user_email# ).";
$pgv_lang["mail01_line03"]		= "Flg. data blev brugt.";
$pgv_lang["mail01_line04"]		= "Klik venligst på linket herunder og udfyld med de røde data for at bekræfte din konto og e-mailadresse.";
$pgv_lang["mail01_line05"]		= "hvis du ikke har udbedt dig disse data, bedes du blot slette denne mail.";
$pgv_lang["mail01_line06"]		= "Du vil ikke få tilsendt yderligere e-mails herfra, idet kontoen i mangel på din verifikation vil blive slettet indenfor syv dage.";
$pgv_lang["mail01_subject"]		= "Din registrering hos #SERVER_NAME#";
$pgv_lang["mail02_line01"]		= "Hej administrator ...";
$pgv_lang["mail02_line02"]		= "En ny bruger har registreret sig hos ( #SERVER_NAME# ).";
$pgv_lang["mail02_line03"]		= "Brugeren har fået tilsendt en e-mail med de nødvendige data for at verificere den pgl. konto.";
$pgv_lang["mail02_subject"]		= "Ny registrering hos #SERVER_NAME#";
$pgv_lang["mail02_line04"]		= "Så snart brugeren har foretaget denne verifikation, får du besked pr. mail om at give denne bruger tilladelse til login på dit site.";
$pgv_lang["hashcode"]			= "Kontrolkode";
$pgv_lang["thankyou"]			= "Hej #user_fullname# ...<br />Tak for din registrering";
$pgv_lang["pls_note06"]			= "Du vil nu få tilsendt en bekræftelses e-mail til adressen ( #user_email# ). Ved hjælp af denne e-mail kan du aktivere din konto. Hvis du ikke aktiverer din konto indefor syv dage, vil den blive slettet (hvorefter du kan registrere kontoen igen, om du ønsker det). Login til dette site, kræver at du oplyser dit brugernavn og password.<br /><br /><br /><br />";
$pgv_lang["registernew"]		= "Bekræftelse af ny konto.";
$pgv_lang["user_verify"]		= "Bruger verifikation";
$pgv_lang["pls_note08"]			= "Data for brugeren #user_name# blev undersøgt.";
$pgv_lang["send"]			= "Afsend";
$pgv_lang["pls_note07"]			= "Indtast venligst dit brugernavn, dit password og den kontrolkode du fik tilsendt pr. e-mail, som kontrol af at ønsket om oprettelse af konto kom fra dig.";
$pgv_lang["mail03_line01"]		= "Hej administrator ...";
$pgv_lang["mail03_line02"]		= "#newuser[username]# ( #newuser[fullname]# ) har verificeret registrationsdata.";
$pgv_lang["mail03_line03"]		= "Klik venligst på link herunder for login på dit site, rediger nu brugeren og giv vedkommende tilladelse til login på dit site.";
$pgv_lang["mail03_subject"]		= "Ny verificering hos #SERVER_NAME#";
$pgv_lang["pls_note09"]			= "Du er genkendt som en registreret bruger.";
$pgv_lang["pls_note10"]			= "Administrator har fået besked.<br />Såsnart vedkommende har givet sin tilladelse, kan du logge ind med dit brugernavn og password.";
$pgv_lang["pls_note11"]			= "At glemme eller smide sit password væk er et alvorligt sikkerhedsproblem. Ved at undlade at beskytte dit passwords integritet, har du risikeret at sætte din konto og dette sites sikkerhed over styr.<br /><br />For at få dit password nulstillet, skal du oplyse dit phpGedView brugerkontonavn (brugernavn) og den e-mailadresse du oplyste da du oprettede denne brugerkonto, eller som du senere har ændret den til i opsætningen. Klik på #pgv_lang[lost_pw_reset]#-knappen når denne information er indtastet.<br /><br />Dersom du har indtastet korrekt brugernavn og tilhørende e-mailadresse, sender vi dig et specielt link med e-mail, der indeholder en kontrolkode til din konto. Ved at benytte dette link, får du mulighed for at ændre dit password og login til dette site. Af sikkerhedsmæssige årsager skal du ikke oplyse denne kontrolkode til nogen, og heller ikke dette sites administratorer (Vi vil ikke bede om det).<br /><br />Hvis du er usikker p&aring hvilken e-mailadresse du har brugt i forbindelse med denne konto, kan du prøve alle dine e-mailadresser. Kontrolkoden bliver kun sendt til den e-mailkonto der er registreret i din konto, og kun hvis du oplyser korrekt brugernavn og e-mailadresse for kontoen.";
$pgv_lang["data_incorrect"]		= "Data var forkert!<br />Prøv venligst igen!";
$pgv_lang["user_not_found"]		= "Der blev ikke fundet en sådan bruger!";
$pgv_lang["lost_pw_reset"]		= "Tabt password forespørgsel";
$pgv_lang["enter_email"]		= "Du skal indtaste en e-mail adresse.";
$pgv_lang["mail04_line01"]		= "Hallo #user_fullname# ...";
$pgv_lang["mail04_line02"]		= "Der blev bestilt et nyt password til dit brugernavn!";
$pgv_lang["mail04_line03"]		= "Anbefaling:";
$pgv_lang["mail04_subject"]		= "Data anmodning fra #SERVER_NAME#";
$pgv_lang["pwreqinfo"]			= "Hallo...<br /><br />En e-mail med det nye password blev sendt til e-mailadressen (#user[email]#).<br /><br />Vær venlig at tjekke din e-mailkonto, fordi denne e-mail gerne skulle være fremme i løbet af de næste få minutter.<br /><br />Anbefaling:<br /><br />Efter du har modtaget denne e-mail, bør du login på denne site med dit nye password og ændre det, for således at bevare integriteten på din datasikkerhed.";
$pgv_lang["mail04_line04"]		= "Klik venligst på linket herunder, login med det nye Password og ændre det så, for at bevare dine datas integritet.";
$pgv_lang["verified_by_admin"]		= "Bruger godkendt af administrator:";
$pgv_lang["user_theme"]			= "Mit tema";
$pgv_lang["mygedview"]			= "MitGedView";
$pgv_lang["passwordlength"]		= "Password skal være på mindst 6 tegn.";
$pgv_lang["admin_approved"]		= "Din konto hos #SERVER_NAME# er blevet godkendt";
$pgv_lang["you_may_login"]		= " af siteadministrator. Du kan nu login på phpGedView sitet ved at følge linket herunder:";
$pgv_lang["editowndata"]		= "MinKonto";
$pgv_lang["savedata"]			= "Gem ændrede data";
$pgv_lang["datachanged"]		= "Brugerdata blev ændret!";
$pgv_lang["datachanged_name"]		= "Det vil evt. være nødvendigt at logge ind med dit nye brugernavn.";
$pgv_lang["myuserdata"]			= "Min konto";
$pgv_lang["verified"]			= "Brugeren verificerede sig selv:";
$pgv_lang["welcome"]			= "Velkommen";
$pgv_lang["upcoming_events"]	= "Kommende begivenheder";
$pgv_lang["users_logged_in"]	= "Brugere logged ind";
$pgv_lang["chat"]				= "Chat";
$pgv_lang["message"]			= "Send besked";
$pgv_lang["my_messages"]		= "Mine beskeder";
$pgv_lang["message_body"]		= "Selve beskeden:";
$pgv_lang["provide_email"]		= "Oplys venligst din e-mailadresse, således vi kan besvare denne henvendelse. Hvis du ikke oplyser din e-mailadresse, er vi ikke i stand til at besvare denne forespørgsel. Din e-mailadresse vil ikke blive brugt til andet end at besvare denne forespørgsel.";
$pgv_lang["message_subject"]	= "Emne:";
$pgv_lang["message_to"]			= "Besked til:";
$pgv_lang["date_created"]		= "Dato afsendt:";
$pgv_lang["message_from"]		= "Besked fra:";
$pgv_lang["message_from_name"]		= "Dit navn:";
$pgv_lang["date_created"]		= "Dato afsendt";
$pgv_lang["no_to_user"]			= "Der blev ikke oplyst en anden bruger som modtager. Der kan ikke fortsættes.";
$pgv_lang["reply"]				= "Svar";
$pgv_lang["message_deleted"]	= "Besked slettet";
$pgv_lang["message_sent"]		= "Besked afsendt";
$pgv_lang["reset"]				= "Reset";
$pgv_lang["site_default"]		= "Site default";
$pgv_lang["mygedview_desc"]		= "MitGedView gør det muligt for dig at markere dine personlige favoritter, blive påmindet om kommende begivenheder, og samarbejde med andre phpGedView brugere.";
$pgv_lang["no_messages"]		= "Der er ingen besked til dig.";
$pgv_lang["clicking_ok"]		= "Ved klik på OK, åbnes der et nyt vindue, hvor du kan kontakte #user[fullname]#";
$pgv_lang["my_favorites"]		= "Mine favoritter";
$pgv_lang["no_favorites"]		= "Du har ikke valgt nogen favoritter. For at tilføje en person til dine favoritter, kan du enten finde vedkommende persons detailler og derefter klikke på \"Føj til mine favoritter\" link eller bruge ID boksen herunder for at tilføje en person ved hjælp af vedkommendes ID nummer.";
$pgv_lang["add_to_my_favorites"] = "Føj til MineFavoritter";
$pgv_lang["confirm_fav_remove"]	= "Er du sikker på at du vil fjerne dette fra dine favoritter?";
$pgv_lang["portal"]				= "Portal";
$pgv_lang["invalid_email"]		= "Indtast venligst en gyldig e-mail adresse.";
$pgv_lang["enter_subject"]		= "Indtast venligst en tekst i emnelinjen.";
$pgv_lang["enter_body"]			= "Indtast venligst noget tekst inden der sendes.";
$pgv_lang["confirm_message_delete"]	= "Er du sikker på du vil slette denne besked? Når først den er slettet kan den ikke gendannes igen.";
$pgv_lang["edit_privacy"]		= "Konfigurering af privacy.php";
$pgv_lang["PRIV_PUBLIC"]		= "adgang for enhver";
$pgv_lang["PRIV_USER"]			= "Kun adgang for autoriserede brugere";
$pgv_lang["PRIV_NONE"]			= "kun tilgængelig for administrative brugere";
$pgv_lang["save_changed_settings"]	= "Gem ændrede indstillinger";
$pgv_lang["add_new_pp_setting"]		= "Tilføj ny [\$person_privacy] - indstilling";
$pgv_lang["add_new_up_setting"]		= "Tilføj ny [\$user_privacy] - indstilling";
$pgv_lang["add_new_gf_setting"]		= "Tilføj ny [\$global_facts] - indstilling";
$pgv_lang["add_new_pf_setting"]		= "Tilføj ny [\$person_facts] - indstilling";
$pgv_lang["thumbnail"]			= "Minibillede";
$pgv_lang["upload_media"]		= "Upload mediafiler";
$pgv_lang["media_file"]			= "Mediafil";
$pgv_lang["on_this_day"]		= "På denne dag i din familiehistorie";
$pgv_lang["in_this_month"]		= "I denne måned i din familiehistorie";
$pgv_lang["viewday"]			= "Se dag";
$pgv_lang["viewmonth"]			= "Se måned";
$pgv_lang["all_people"]			= "Alle personer";
$pgv_lang["living_only"]		= "Nulevende personer";
$pgv_lang["recent_events"]		= "Tidligere begivenheder (< 100 år)";
$pgv_lang["viewday"]			= "Se måned";
$pgv_lang["saturday"]			= "lørdag";
$pgv_lang["friday"]				= "fredag";
$pgv_lang["thursday"]			= "torsdag";
$pgv_lang["wednesday"]			= "onsdag";
$pgv_lang["tuesday"]			= "tirsdag";
$pgv_lang["monday"]			= "mandag";
$pgv_lang["sunday"]			= "søndag";
$pgv_lang["year_anniversary"]	= "#year_var# Årsdag";
$pgv_lang["day"]				= "Dag:";
$pgv_lang["month"]				= "Måned";
$pgv_lang["anniversary_calendar"] = "Mærkedage";

//-- Admin File Messages
$pgv_lang["select_an_option"]		= "Vælg en af flg. valgmuligheder:";
$pgv_lang["readme_documentation"]	= "README dokumentation";
$pgv_lang["configuration"]		= "Konfiguration";
$pgv_lang["rebuild_indexes"]		= "Genopbyg indeks";
$pgv_lang["user_admin"]			= "Bruger administration";
$pgv_lang["user_created"]		= "Bruger oprettet.";
$pgv_lang["user_create_error"]		= "Bruger kan ikke oprettes. Vær venlig at gå tilbage og prøv igen.";
$pgv_lang["password_mismatch"]		= "De to password er forskellige.";
$pgv_lang["enter_username"]		= "Du skal indtaste et brugernavn.";
$pgv_lang["enter_fullname"]		= "Du skal indtaste det fulde navn.";
$pgv_lang["enter_password"]		= "Du skal indtaste et password.";
$pgv_lang["confirm_password"]		= "Du skal bekræfte password.";
$pgv_lang["update_user"]		= "Opdaterer bruger";
$pgv_lang["save"]			= "Gem";
$pgv_lang["delete"]			= "Slet";
$pgv_lang["edit"]			= "Rediger";
$pgv_lang["full_name"]			= "Fuldt navn";
$pgv_lang["can_admin"]			= "Har Admin rettigheder";
$pgv_lang["can_edit"]			= "Har Edit rettigheder";
$pgv_lang["confirm_user_delete"]	= "Er du sikker på, at du vil slette brugeren";
$pgv_lang["create_user"]		= "Opret bruger";
$pgv_lang["no_login"]			= "Bruger kan ikke godkendes.";
$pgv_lang["login"]			= "Login";
$pgv_lang["import_gedcom"]		= "Importer GEDCOM filen";
$pgv_lang["duplicate_username"]		= "Duplikat. Der eksisterer allerede et sådan brugernavn. Gå venligst tilbage og vælg et andet brugernavn.";
$pgv_lang["gedcomid"]				= "Gedcom INDI record ID";
$pgv_lang["enter_gedcomid"]			= "Du skal indtaste en Gedcom ID.";
$pgv_lang["user_info"]				= "Min brugerinformation";
$pgv_lang["research_log"]			= "Forskningslog";
$pgv_lang["administration"]			= "Administration";
$pgv_lang["ansi_to_utf8"]			= "Konverter denne ANSI (ISO-8859-1) kodet GEDCOM til UTF-8?";
$pgv_lang["utf8_to_ansi"]			= "Vil du konvertere denne GEDCOM fra UTF-8 til ANSI (ISO-8859-1)?";
$pgv_lang["user_manual"]			= "PhpGedView brugermanual ";
$pgv_lang["step5"]				= "Trin 5 af 5";
$pgv_lang["step4"]				= "Trin 4 af 4";
$pgv_lang["step3"]				= "Trin 3 af 4";
$pgv_lang["step2"]				= "Trin 2 af 4";
$pgv_lang["step1"]				= "Trin 1 af 4";
$pgv_lang["upgrade"]			= "Opgrader phpGedView";
$pgv_lang["view_logs"]			= "Se logfiler";
$pgv_lang["show_phpinfo"]			= "Vis PHPInfo";
$pgv_lang["manage_gedcoms"]			= "Administrer gedcomfiler";
$pgv_lang["rootid"]				= "Anetræ proband";
$pgv_lang["download_gedcom"]		= "Download Gedcom";
$pgv_lang["upload_gedcom"]			= "Upload Gedcom";
$pgv_lang["add_new_gedcom"]		= "Opret ny gedcomfil";
$pgv_lang["file_exists"]		= "Der findes i forvejen en gedcomfil med det navn. Vælg venligst et andet navn, eller slet den gamle fil.";
$pgv_lang["new_gedcom_title"]		= "Slægtsoplysninger fra [#GEDCOMFILE#]";
$pgv_lang["enter_filename"]		= "Du skal indtaste et GEDCOM filnavn.";
$pgv_lang["gedcom_file"]			= "Gedcom fil:";
$pgv_lang["add_gedcom_instructions"]	= "Indtast et filnavn for denne nye gedcomfil. Den nye gedcomfil bliver oprettet i index mappen:";
$pgv_lang["upload_error"]			= "Der opstod en fejl under upload af din gedcom fil.";
$pgv_lang["upload_help"]			= "Vælg den fil fra din lokale computer, du vil uploade til din server.  Denne gedcom fil vil erstatte den nuværende gedcom fil og automatisk ekspedere dig videre til indekseringsafsnittet.";
$pgv_lang["file_success"]			= "Fil uploaded lykkedes";
$pgv_lang["file_too_big"]			= "Uploaded fil overskrider tilladt størrelse";
$pgv_lang["file_partial"]			= "Filen blev kun delvist uploaded, forsø venligst igen";
$pgv_lang["file_missing"]			= "Der blev ikke modtaget nogen fil. Upload igen.";

//-- Relationship chart messages
$pgv_lang["relationship_chart"]		= "Slægtsrelation";
$pgv_lang["person1"]			= "Person 1";
$pgv_lang["person2"]			= "Person 2";
$pgv_lang["no_link_found"]		= "Der kan ikke findes nogen forbindelse mellem de to personer.";
$pgv_lang["sibling"]			= "Søskende";
$pgv_lang["follow_spouse"]		= "Find forbindelse via giftemål.";
$pgv_lang["timeout_error"]			= "Script fik time out før der blev fundet en forbindelse.";
$pgv_lang["son"]					= "Søn";
$pgv_lang["daughter"]				= "Datter";
$pgv_lang["show_path"]			= "Vis sti";
$pgv_lang["next_path"]			= "Find næste sti";
$pgv_lang["brother"]				= "Bror";
$pgv_lang["sister"]					= "Søster";
$pgv_lang["relationship_to_me"]		= "Slætsforhold til mig";
$pgv_lang["message_email1"]		= "Flg. besked blev sendt til din PhpGedView Brugerkonto:";
$pgv_lang["message_email2"]		= "Du sendte flg. besked til en PhpGedView Brugerkonto:";
$pgv_lang["message_email3"]		= "Du sendte flg. besked til en PhpGedView administrator:";
$pgv_lang["viewing_url"]		= "Denne besked blev afsendt fra url:";
$pgv_lang["messaging2_help"]	= "Når du sender denne besked, får du tilsendt en kopi via den e-mailadresse du har oplyst.";
$pgv_lang["random_picture"]		= "Tilfældigt billede";
$pgv_lang["message_instructions"]	= "<b>Bemærk:</b> Private data på nulevende personer kan ikke fås af andre end slægtninge og nære venner. Du vil blive afkrævet bevis for dit slægtskab før du får udleveret private data. Sommetider kan en afdøds data også være skjult; dette kan skyldes, der ikke er nok oplysninger tilstede til at kunne afgøre om vedkommende er nulevende eller ej, eller at der ikke finderes yderligere oplysninger om vedkommende.<br /><br />Før du beder om oplysninger, bedes du sikre, der er tale om den rette person, ved tjek af datoer, stednavne og nærmeste slægtninge. Hvis du bidrager med oplysninger, så angiv venligst de kilder du har oplysningerne fra.<br /><br />    ";
$pgv_lang["upgrade_util"]			=	"Opgraderingsværktøj";
$pgv_lang["no_upgrade"]				= "Der er ingen filer at opgradere.";
$pgv_lang["use_version"]			= "Du bruger version: ";
$pgv_lang["upgrade_zip"]		= "ZIP";
$pgv_lang["upgrade_tar"]		= "TAR";
$pgv_lang["upgrade_download"]		= "Download:";
$pgv_lang["current_version"]	=	"Nuværende stabile version:";

if (file_exists($PGV_BASE_DIRECTORY . "languages/lang.da.extra.php")) require $PGV_BASE_DIRECTORY . "languages/lang.da.extra.php";

?>