<?php
/*=================================================
   charset=utf-8
   Projekt:	phpGedView
   Datei:	lang.ge.php
   Autor:	John Finlay
   Übersetzung:	Bach Jürgen
   		Norgaz Kurt
   		Pluntke Peter
   Bemerkungen:	Deutsches Sprachen Modul für PhpGedView
   Aufzeichnung der Änderungen:
   15.11.2002	Datei erstellt durch Jürgen Bach
   08.04.2003	Inhalt angepasst an Inhalt der Datei lang.en.php v1.23
   		Anhand der Originalsprachdatei lang.en.php gänzlich neu ins Deutsche übersetzt
   18.05.2003	charset=utf-8 in den Header aufgenommen, um das Erkennen als UTF-8-Datei zu gewährleisten
   18.07.2003	fehlende Begriffe ergänzt,
   		doppeldeutige Begriffe optimiert,
   		Vereinheitlichung der Verbformen (Infinitiv statt Imperativ)
   		Vereinheitlichung der Anrede (Sie statt Du)
   		Ergänzung der fehlenden Abschnittsnamen
   		Sortierung an lang.en.php angepasst
===================================================*/
# $Id: lang.ge.php,v 1.62.2.6 2004/02/02 15:18:13 yalnifj Exp $
if (preg_match("/lang\...\.php$/", $_SERVER["PHP_SELF"])>0) {
	print "You cannot access a language file directly.";
	exit;
}
//-- GENERAL HELP MESSAGES
$pgv_lang["qm"]					= "?";
$pgv_lang["page_help"]			= "Hilfe";

//-- CONFIG FILE MESSAGES
$pgv_lang["error_title"]		= "FEHLER: Gedcom Datei kann nicht geöffnet werden";
$pgv_lang["error_header"]		= "Die GEDCOM Datei, [#GEDCOM#], befindet sich nicht am angegebenen Ort.";
$pgv_lang["for_support"]		= "Für Support wenden Sie sich an folgende Kontaktadresse:";
$pgv_lang["for_contact"]		= "Bei genealogischen Fragen wenden Sie sich an folgende Kontaktadresse:";
$pgv_lang["for_all_contact"]		= "Für Support sowie bei genealogischen Fragen wenden Sie sich an folgende Kontaktadresse:";
$pgv_lang["build_title"]		= "Index-Dateien werden erstellt";
$pgv_lang["build_error"]		= "Eine neue GEDCOM-Datei wurde gefunden.";
$pgv_lang["please_wait"]		= "Einen Moment bitte: Index Dateien werden neu erstellt.";
$pgv_lang["choose_gedcom"]		= "Einen GEDCOM Datensatz aussuchen";
$pgv_lang["username"]			= "Benutzername:";
$pgv_lang["password"]			= "Passwort:";
$pgv_lang["login"]			= "Login";
$pgv_lang["login_aut"]			= "Benutzereinstellungen bearbeiten";
$pgv_lang["logout"]			= "Logout";
$pgv_lang["admin"]			= "Verwalten";
$pgv_lang["logged_in_as"]		= "Angemeldet als";
$pgv_lang["my_pedigree"]		= "Mein Stammbaum";
$pgv_lang["my_indi"]			= "Mein Datenblatt";
$pgv_lang["yes"]			= "Ja";
$pgv_lang["no"]				= "Nein";
$pgv_lang["add_gedcom"]			= "Gedcom Datei hinzufügen";
$pgv_lang["no_support"]			= "Ihr Browser unterstützt nicht alle Standards, die von dieser PhpGedView Website benutzt werden. Die meisten neueren Browser-Versionen unterstützen diese Funktionen. Bitte besorgen Sie sich eine neuere Version Ihres Browsers.";

//-- INDEX (PEDIGREE_TREE) FILE MESSAGES
$pgv_lang["index_header"]		= "Stammbaum";
$pgv_lang["gen_ped_chart"]		= "Stammbaum für #PEDIGREE_GENERATIONS# Generationen";
$pgv_lang["generations"]		= "Generationen";
$pgv_lang["view"]			= "Zeige";
$pgv_lang["fam_spouse"]			= "Familie mit Ehepartner";
$pgv_lang["root_person"]		= "ID der Startperson:";
$pgv_lang["hide_details"]		= "Details verbergen";
$pgv_lang["show_details"]		= "Details zeigen";
$pgv_lang["person_links"]		= "Links zu Charts, Familien und nahen Verwandten dieser Person.";
$pgv_lang["zoom_box"]			= "Zoom hinein/heraus";
$pgv_lang["portrait"]			= "Hochformat";
$pgv_lang["landscape"]			= "Querformat";
$pgv_lang["start_at_parents"]	= "Bei den Eltern beginnen";

//-- FUNCTIONS FILE MESSAGES
$pgv_lang["unable_to_find_family"]	= "zu folgender ID kann keine Familie gefunden werden:";
$pgv_lang["unable_to_find_indi"]	= "zu folgender ID kann keine Person gefunden werden:";
$pgv_lang["unable_to_find_record"]	= "zu folgender ID kann kein Datensatz gefunden werden:";
$pgv_lang["unable_to_find_source"]	= "zu folgender ID kann keine Quelle gefunden werden:";
$pgv_lang["unable_to_find_repo"]	= "Kann die Datenbanktabelle zu folgender ID nicht finden:";
$pgv_lang["repo_name"]			= "Datenbanktabellen-Name:";
$pgv_lang["address"]			= "Adresse:";
$pgv_lang["phone"]			= "Telefon:";
$pgv_lang["source_name"]		= "Quellen-Name:";
$pgv_lang["title"]			= "Titel:";
$pgv_lang["author"]			= "Autor:";
$pgv_lang["publication"]		= "Publikation:";
$pgv_lang["call_number"]		= "Telefon Nummer:";
$pgv_lang["living"]			= "Lebt";
$pgv_lang["private"]			= "Privat";
$pgv_lang["birth"]			= "Geburt:";
$pgv_lang["death"]			= "Tod:";
$pgv_lang["descend_chart"]		= "Nachfahrenbaum";
$pgv_lang["individual_list"]		= "Personen Liste";
$pgv_lang["family_list"]		= "Familien Liste";
$pgv_lang["source_list"]		= "Quellen Liste";
$pgv_lang["place_list"]			= "Liste der Orte";
$pgv_lang["media_list"]			= "Multimedia Liste";
$pgv_lang["search"]			= "Suche";
$pgv_lang["clippings_cart"]		= "Ausschnitts-Sammelbehälter";
$pgv_lang["not_an_array"]		= "keine Reihe (Array)";
$pgv_lang["print_preview"]		= "Druck-Vorschau";
$pgv_lang["change_lang"]		= "Sprache auswählen";
$pgv_lang["print"]			= "Drucken";
$pgv_lang["total_queries"]		= "Gesamtanzahl der Datenanfragen an die Datenbank:";
$pgv_lang["back"]			= "zurück";

//-- INDIVUDUAL FILE MESSAGES
$pgv_lang["male"]			= "männlich";
$pgv_lang["female"]			= "weiblich";
$pgv_lang["temple"]			= "LDS Tempel";
$pgv_lang["temple_code"]		= "LDS Tempel Code:";
$pgv_lang["status"]			= "Status";
$pgv_lang["source"]			= "Quelle:";
$pgv_lang["citation"]			= "Abschnitt:";
$pgv_lang["text"]			= "Quellen-Text:";
$pgv_lang["note"]			= "Notiz:";
$pgv_lang["unrecognized_code"]		= "Unbekannter GEDCOM Code";
$pgv_lang["indi_info"]			= "Persönliche Informationen";
$pgv_lang["pedigree_chart"]		= "Stammbaum dieser Person";
$pgv_lang["desc_chart2"]		= "Nachfahrenbaum";
$pgv_lang["family"]			= "Familie";
$pgv_lang["as_spouse"]			= "Familiendaten als Ehepartner";
$pgv_lang["as_child"]			= "Familiendaten als Kind";
$pgv_lang["view_gedcom"]		= "GEDCOM Datensatz anzeigen";
$pgv_lang["add_to_cart"]		= "Datensatz dem Sammelbehälter hinzufügen";
$pgv_lang["still_living_error"]		= "Diese Person lebt noch oder hat keine Geburts- oder Sterbedaten.<br />Alle Details lebender Personen werden hier nicht angzeigt.<br />Für weitere Informationen schreiben Sie an";
$pgv_lang["privacy_error"]		= "Details dieser Person sind vertraulich.<br />";
$pgv_lang["more_information"]		= "Für weitere Informationen wenden Sie sich an folgende E-Mail Adresse:";
$pgv_lang["name"]			= "Name:";
$pgv_lang["given_name"]			= "Vorname:";
$pgv_lang["surname"]			= "Nachname:";
$pgv_lang["suffix"]			= "Namenszusatz:";
$pgv_lang["object_note"]		= "Objekt-Notiz:";
$pgv_lang["sex"]			= "Geschlecht:";
$pgv_lang["personal_facts"]		= "Persönliche Fakten und Details";
$pgv_lang["type"]			= "Typ";
$pgv_lang["date"]			= "Datum";
$pgv_lang["place_description"]		= "Ort / Beschreibung";
$pgv_lang["parents"]			= "Eltern:";
$pgv_lang["siblings"]			= "Geschwister:";
$pgv_lang["father"]			= "Vater";
$pgv_lang["mother"]			= "Mutter";
$pgv_lang["relatives"]			= "Direkte Verwandschaft";
$pgv_lang["child"]			= "Kind";
$pgv_lang["spouse"]			= "Ehepartner";
$pgv_lang["surnames"]			= "Nachname";
$pgv_lang["adopted"]			= "adoptiert";
$pgv_lang["foster"]			= "Vormund";
$pgv_lang["sealing"]			= "Siegelung";
$pgv_lang["link_as"]			= "Diese Person mit bestehender Familie verknüpfen als ";

//-- FAMILY FILE MESSAGES
$pgv_lang["family_info"]		= "Familien Informationen";
$pgv_lang["family_group_info"]		= "Informationen zur Familiengruppe";
$pgv_lang["husband"]			= "Ehemann";
$pgv_lang["wife"]			= "Ehefrau";
$pgv_lang["marriage"]			= "Heirat:";
$pgv_lang["lds_sealing"]		= "LDS Sealing:";
$pgv_lang["marriage_license"]		= "Ehe Erlaubnis:";
$pgv_lang["media_object"]		= "Multimedia Objekt:";
$pgv_lang["children"]			= "Kinder";
$pgv_lang["no_children"]		= "keine Kinder";
$pgv_lang["parents_timeline"]		= "Eltern in<br />Lebensspannen-Ansicht zeigen";

//-- CLIPPINGS FILE MESSAGES
$pgv_lang["clip_cart"]			= "Ausschnitts-Sammelbehälter";
$pgv_lang["clip_explaination"]		= "Der Stammbaum-Ausschnitts-Sammelbehälter ermöglicht es, &quot;Ausschnitte&quot aus diesem Stammbaum zu markieren.<br />Diese können dann später in einer seperaten GEDCOM-Datei zum sofortigen Download gebündelt werden.<br /><br />";
$pgv_lang["item_with_id"]		= "Ausschnitt von ID";
$pgv_lang["error_already"]		= "ist schon in Ihrem Ausschnitts-Sammelbehälter.";
$pgv_lang["which_links"]		= "Welche Verbindungen dieser Familie möchten Sie hinzuzufügen?";
$pgv_lang["just_family"]		= "Nur den Familiendatensatz dieser Familie hinzufügen.";
$pgv_lang["parents_and_family"]		= "Den Familiendatensatz und die Datensätze der Eltern dieser Familie hinzufügen.";
$pgv_lang["parents_and_child"]		= "Den Familiendatensatz, den der Eltern und die der Kinder dieser Familie hinzufügen.";
$pgv_lang["parents_desc"]		= "Den Familiendatensatz, die Datensätze der Eltern und die ihrer gesamten Nachkommen hinzufügen.";
$pgv_lang["continue"]			= "weiter";
$pgv_lang["which_p_links"]		= "Welche Verbindungen dieser Person möchten Sie hinzuzufügen?";
$pgv_lang["just_person"]		= "Nur den Datensatz dieser Person hinzufügen.";
$pgv_lang["person_parents_sibs"]	= "Den Datensatz dieser Person, die seiner Eltern und seiner Geschwister hinzufügen.";
$pgv_lang["person_ancestors"]		= "Den Datensatz dieser Person und die seiner direkten Vorfahren hinzufügen.";
$pgv_lang["person_ancestor_fams"]	= "Den Datensatz dieser Person, die seiner direkten Vorfahren und die Datensätze derer Familien hinzufügen.";
$pgv_lang["person_spouse"]		= "Den Datensatz dieser Person, den seines Ehepartners und die seiner Kinder hinzufügen.";
$pgv_lang["person_desc"]		= "Den Datensatz dieser Person, den seines Ehepartners und die aller seiner Nachfahren hinzufügen.";
$pgv_lang["unable_to_open"]		= "Es ist nicht möglich das Verzeichnis für den Ausschnitts-Sammelbehälter zum Schreiben zu öffnen.";
$pgv_lang["person_living"]		= "Diese Person ist am Leben. Persönliche Details werden nicht eingefügt.";
$pgv_lang["person_private"]		= "Details dieser Person sind vertraulich. Persönliche Details werden nicht eingefügt.";
$pgv_lang["family_private"]		= "Details dieser Familie sind vertraulich. Persönliche Details werden nicht eingefügt.";
$pgv_lang["download"]			= "Klicken Sie mit der rechten Maustaste (beim Mac Control-Klick) auf den untenstehenden Link und wählen &quot;Ziel speichern unter&quot;, um die generierte GEDCOM-Datei auf Ihren eigenen Computer zu übertragen (Download).";
$pgv_lang["media_files"]		= "Multimedia-Dateien, welche zu den Datensätzen dieser GEDCOM-Datei gehören:";
$pgv_lang["cart_is_empty"]		= "Ihr Ausschnitts-Sammelbehälter ist leer.";
$pgv_lang["id"]				= "Identifikationsnummer (ID)";
$pgv_lang["name_description"]		= "Name / Beschreibung";
$pgv_lang["remove"]			= "Entfernen";
$pgv_lang["empty_cart"]			= "Ausschnitts-Sammelbehälter leeren";
$pgv_lang["download_now"]		= "Jetzt downloaden";
$pgv_lang["indi_downloaded_from"]	= "Daten der Person wurden geladen von:";
$pgv_lang["family_downloaded_from"]	= "Daten der Familie wurden geladen von:";
$pgv_lang["source_downloaded_from"]	= "Daten der Quelle wurden geladen von:";

//-- PLACELIST FILE MESSAGES
$pgv_lang["connections"]		= "Orts-Verbindungen gefunden<br />Ergebnisse jetzt ansehen";
$pgv_lang["top_level"]			= "zurück";
$pgv_lang["form"]			= "Ortsangaben werden im folgenden Format ausgewertet:";
$pgv_lang["default_form"]		= "Stadt, Kreis, (Bundes)Land, Staat";
$pgv_lang["default_form_info"]			= "(Standardeinstellung)";
$pgv_lang["gedcom_form_info"]			= "(Gedcom)";
$pgv_lang["unknown"]			= "Unbekannt";
$pgv_lang["individuals"]			= "Personen";

//-- MEDIALIST FILE MESSAGES
$pgv_lang["multi_title"]		= "Liste der Multimedia Objekte";
$pgv_lang["media_found"]		= "Multimedia Objekt(e) gefunden";
$pgv_lang["view_person"]		= "Person zeigen";
$pgv_lang["view_family"]		= "Familie zeigen";
$pgv_lang["view_source"]		= "Quelle zeigen";
$pgv_lang["prev"]			= "&lt; Vorhergehende Seite";
$pgv_lang["next"]			= "Nächste Seite &gt;";
$pgv_lang["file_not_found"]		= "Datei nicht gefunden.";

//-- SEARCH FILE MESSAGES
$pgv_lang["search_gedcom"]		= "GEDCOM-Datei durchsuchen";
$pgv_lang["enter_terms"]		= "Suchbegriffe eingeben:";
$pgv_lang["soundex_search"]		= "Namen nach Soundex-Methode durchsuchen:";
$pgv_lang["search_results"]		= "Suchergebnisse";
$pgv_lang["sources"]			= "QUELLEN";
$pgv_lang["firstname_search"]		= "Vorname:";
$pgv_lang["lastname_search"]		= "Nachname:";
$pgv_lang["search_place"]		= "Ort:";
$pgv_lang["search_year"]		= "Jahr:";
$pgv_lang["lastname_empty"]		= "Bitte einen Nachnamen eingeben.";
$pgv_lang["no_results"]			= "Keine Ergebnisse gefunden";
$pgv_lang["soundex_results"]		= "Eventuell nützliche Ergebnisse der Soundex-Methode:";

//-- SOURCELIST FILE MESSAGES
$pgv_lang["sources_found"]		= "Quelle(n) gefunden";

//-- SOURCE FILE MESSAGES
$pgv_lang["source_info"]		= "Information(en) zur Quelle";
$pgv_lang["other_records"]		= "Andere Datensätze, die ebenfalls diese Quelle haben:";
$pgv_lang["people"]			= "PERSONEN";
$pgv_lang["families"]			= "FAMILIEN";

//-- BUILDINDEX FILE MESSAGES
$pgv_lang["building_indi"]			= "Erstelle Index-Datei(en) der Personen und Familien";
$pgv_lang["building_index"]			= "Erstelle Liste der Index-Datei(en)";
$pgv_lang["importing_records"]			= "Importiere Datensätze in Datenbank";
$pgv_lang["detected_change"]			= "phpGedView erkannte einen Wechsel der GEDCOM-Datei #GEDCOM#. Bevor es weitergeht, müssen erst die Index-Dateien neu erstellt werden.";
$pgv_lang["please_be_patient"]			= "BITTE UM ETWAS GEDULD";
$pgv_lang["reading_file"]			= "GEDCOM-Datei wird gelesen";
$pgv_lang["flushing"]				= "Speicherinhalt wird gelöscht";
$pgv_lang["found_record"]			= "Datensatz gefunden";
$pgv_lang["exec_time"]				= "Gesamt-Ausführungszeit:";
$pgv_lang["unable_to_create_index"]		= "Index-Datei kann nicht erstellt werden.<br />Stellen Sie sicher, dass die Rechte zum Schreiben im phpGedView-Verzeichnis gesetzt sind.<br />Die Rechte können zurückgesetzt werden, sobald die Index-Dateien erstellt wurden.";
$pgv_lang["indi_complete"]			= "Update der Personen-Index-Datei ist komplett.";
$pgv_lang["family_complete"]			= "Update der Familien-Index-Datei ist komplett.";
$pgv_lang["source_complete"]			= "Update der Quellen-Index-Datei ist komplett.";
$pgv_lang["tables_exist"]			= "PHPGedView Tables sind schon in der Datenbank vorhanden";
$pgv_lang["you_may"]				= "Sie können:";
$pgv_lang["drop_tables"]			= "Löschen der aktuellen sql-Tables";
$pgv_lang["import_multiple"]			= "Importieren und Weiterarbeiten mit mehreren GEDCOM-Dateien";
$pgv_lang["explain_options"]			= "Wenn Sie beschliessen, die Tabellen zu löschen, werden alle Inhalte durch die dieser GEDCOM-Datei ersetzt.<br />Wenn Sie sich für einen Import und die Weiterarbeit mit mehreren GEDCOM-Dateien entscheiden, wird phpGedView alle Daten löschen, welche aus einer GEDCOM-Datei mit gleichem Namen importiert wurden.<br />Diese Option erlaubt es Ihnen, mehrere GEDCOM-Dateien in den gleichen Tabellen zu speichern und sehr leicht zwischen diesen zu wechseln.";
$pgv_lang["path_to_gedcom"]			= "Geben Sie den Pfad zu Ihrer GEDCOM-Datei ein:";
$pgv_lang["gedcom_title"]			= "Geben Sie einen Bezeichnung ein, welche die Daten in dieser GEDCOM-Datei beschreibt:";
$pgv_lang["dataset_exists"]			= "Eine GEDCOM-Datei mit diesem Dateinamen wurde bereits in die Datenbank importiert.";
$pgv_lang["empty_dataset"]			= "Möchten Sie den Datensatz leeren?";
$pgv_lang["index_complete"]			= "Index komplett";
$pgv_lang["click_here_to_go_to_pedigree_tree"]	= "Hier klicken, um zum Stammbaum zu gelangen";
$pgv_lang["updating_is_dead"]			= "Ergänze Status von verstorbenen Personen";
$pgv_lang["import_complete"]			= "Import komplett";
$pgv_lang["updating_family_names"]		= "Erneuere Familien Namen für \"FAM\"";
$pgv_lang["processed_for"]			= "Datei bearbeitet";
$pgv_lang["run_tools"]				= "Möchten Sie eines der folgenden Tools anwenden, bevor die GEDCOM-Datei importiert wird:";
$pgv_lang["addmedia"]				= "Add Media Tool (fügt OBJE Medien hinzu)";
$pgv_lang["dateconvert"]			= "Date Conversion Tool (wandelt das Datum um";
$pgv_lang["xreftorin"]				= "Convert XREF IDs to RIN number (wandelt XREF Nummern in RIN Nummern um)";
$pgv_lang["tools_readme"]			= "Lesen Sie in der Datei #README.TXT# das Kapitel \"tools\" für weitere Informationen.";

//-- INDIVIDUAL AND FAMILYLIST FILE MESSAGES
$pgv_lang["total_fams"]			= "Familien insgesamt";
$pgv_lang["total_indis"]		= "Personen insgesamt";
$pgv_lang["starts_with"]		= "Starte mit:";
$pgv_lang["person_list"]		= "Liste der Personen:";
$pgv_lang["paste_person"]		= "Person einfügen";
$pgv_lang["notes_sources_media"]	= "Notizen, Quellen, Media-Dateien";
$pgv_lang["name_contains"]		= "Name enthält:";
$pgv_lang["filter"]			= "Filter";
$pgv_lang["find_individual"]		= "Finde individuelle ID";
$pgv_lang["find_sourceid"]		= "Quelle auswählen";
$pgv_lang["skip_surnames"]		= "Nachnamen Sprung-Liste";
$pgv_lang["show_surnames"]		= "Nachnamen anzeigen";
$pgv_lang["all"]			= "ALLE";

//-- TIMELINE FILE MESSAGES
$pgv_lang["age"]			= "Alter&nbsp;";
$pgv_lang["timeline_title"]		= "phpGedView - Anzeige der Lebensspanne";
$pgv_lang["timeline_chart"]		= "Lebenspannenanzeige";
$pgv_lang["remove_person"]		= "Person entfernen";
$pgv_lang["show_age"]			= "Altersanker anzeigen";
$pgv_lang["add_another"]		= "Andere Person zur Ansicht hinzufügen:<br />Personen ID:";
$pgv_lang["find_id"]			= " Person aussuchen";
$pgv_lang["show"]			= "Zeigen";
$pgv_lang["year"]			= "Jahr:";
$pgv_lang["timeline_instructions"]	= "In den meisten neueren Browsern, kann man die Rechtecke durch Klicken und gleichzeitiges Ziehen innerhalb der Ansicht bewegen.";
$pgv_lang["zoom_in"]			= "Zoom +";
$pgv_lang["zoom_out"]			= "Zoom -";

//-- MONTH NAMES
$pgv_lang["jan"]                        = "Januar";
$pgv_lang["feb"]                        = "Februar";
$pgv_lang["mar"]                        = "März";
$pgv_lang["apr"]                        = "April";
$pgv_lang["may"]                        = "Mai";
$pgv_lang["jun"]                        = "Juni";
$pgv_lang["jul"]                        = "Juli";
$pgv_lang["aug"]                        = "August";
$pgv_lang["sep"]                        = "September";
$pgv_lang["oct"]                        = "Oktober";
$pgv_lang["nov"]                        = "November";
$pgv_lang["dec"]                        = "Dezember";
$pgv_lang["abt"]                        = "um";
$pgv_lang["aft"]                        = "nach";
$pgv_lang["and"]                        = "und";
$pgv_lang["bef"]                        = "vor";
$pgv_lang["bet"]                        = "zwischen";
$pgv_lang["cal"]                        = "berechnet";
$pgv_lang["est"]                        = "angenommen";
$pgv_lang["from"]			= "vom";
$pgv_lang["int"]                        = "interpretiert";
$pgv_lang["to"]				= "bis";
$pgv_lang["cir"]			= "ca.";
$pgv_lang["apx"]			= "angenähert";

//-- Admin File Messages
$pgv_lang["select_an_option"]		= "Wählen Sie bitte eine der unten aufgeführten Optionen:";
$pgv_lang["readme_documentation"]	= "README-Datei / Dokumentation";
$pgv_lang["configuration"]		= "Konfiguration";
$pgv_lang["rebuild_indexes"]		= "Index-Dateien neu erstellen";
$pgv_lang["user_admin"]			= "Benutzer-Verwaltung";
$pgv_lang["user_created"]		= "Benutzer wurde erfolgreich angelegt.";
$pgv_lang["user_create_error"]		= "Der Benutzer konnte nicht angelegt werden. Bitte zurückgehen und neu versuchen.";
$pgv_lang["password_mismatch"]		= "Passwörter stimmen nicht überein.";
$pgv_lang["enter_username"]		= "Sie müssen einen Benutzernamen eingeben.";
$pgv_lang["enter_fullname"]		= "Sie müssen einen kompletten Namen eingeben.";
$pgv_lang["enter_password"]		= "Sie müssen ein Passwort eingeben.";
$pgv_lang["confirm_password"]		= "Sie müssen das Passwort bestätigen.";
$pgv_lang["update_user"]		= "Benutzer updaten";
$pgv_lang["save"]			= "Speichern";
$pgv_lang["delete"]			= "Löschen";
$pgv_lang["edit"]			= "Bearbeiten";
$pgv_lang["full_name"]			= "Vollständiger Name";
$pgv_lang["can_admin"]			= "Darf verwalten";
$pgv_lang["can_edit"]			= "Darf bearbeiten";
$pgv_lang["confirm_user_delete"]        = "Sind Sie sich sicher, dass Sie den Benutzer löschen möchten";
$pgv_lang["create_user"]                = "Benutzer erstellen";
$pgv_lang["no_login"]			= "Kann Benutzer nicht verifizieren.";
$pgv_lang["import_gedcom"]		= "Diese GEDCOM-Datei importieren";
$pgv_lang["duplicate_username"]         = "Doppelter Benutzername. Ein User mit dem gewählten Benutzernamen existiert bereits. Bitte gehen Sie zurück und wählen Sie einen neuen Benutzernamen.";
$pgv_lang["gedcomid"]                   = "Nummer des GEDCOM-Datensatzfeldes INDI dieser Person";
$pgv_lang["enter_gedcomid"]             = "Sie müssen eine GEDCOM-ID angeben.";
$pgv_lang["user_info"]                  = "Meine Benutzerdaten";
$pgv_lang["rootid"]                     = "Startperson für die Stammbaumdarstellung";
$pgv_lang["download_gedcom"]            = "GEDCOM von Ihrem Server herunterladen (download)";
$pgv_lang["upload_gedcom"]              = "GEDCOM upload.";
$pgv_lang["add_new_gedcom"]		= "Eine neue Gedcom-Datei eintragen";
$pgv_lang["gedcom_file"]                = "GEDCOM-Datei:";
$pgv_lang["enter_filename"]		= "Sie müssen einen GEDCOM Dateinamen eingeben.";
$pgv_lang["file_exists"]		= "Es gibt schon eine GEDCOM-Datei mit diesem Dateinamen. Bitte wählen Sie einen anderen Dateinamen oder löschen Sie die alte Datei.";
$pgv_lang["new_gedcom_title"]		= "Genealogische Daten aus [#GEDCOMFILE#]";
$pgv_lang["upload_error"]               = "Beim übertragen (upload) Ihrer GEDCOM-Datei auf Ihren Server trat ein Fehler auf.";
$pgv_lang["upload_help"]                = "Wählen Sie eine Datei auf Ihrem lokalen Computer, um diese auf Ihren Server zu übertragen (upload). Dieser Vorgang wird Ihre aktuelle GEDCOM-Datei ersetzen und automatisch die Index-Dateien neu erstellen.";
$pgv_lang["add_gedcom_instructions"]	= "Geben Sie einen Dateinamen für diese neue GEDCOM-Datei ein. Die neue GEDCOM-Datei wird im Index-Verzeichnis eingetragen: ";
$pgv_lang["file_success"]               = "Datei wurde erfolgreich auf Ihren Server übertragen (upgeloaded)";
$pgv_lang["file_too_big"]               = "Die zu übertragende Datei ist größer als erlaubt";
$pgv_lang["file_partial"]               = "Die Datei wurde nur teilweise hochgeladen. Bitte versuchen Sie es erneut.";
$pgv_lang["file_missing"]               = "Es kam keine Datei auf Ihrem Server an. Bitte erneut übertragen.";
$pgv_lang["manage_gedcoms"]             = "Gedcom Datei Management";
$pgv_lang["research_log"]               = "Research Log";
$pgv_lang["administration"]             = "Administration";
$pgv_lang["ansi_to_utf8"]		= "Soll diese ANSI (ISO-8859-1)-codierte GEDCOM Datei ins UTF-8-Format konvertiert werden?";
$pgv_lang["utf8_to_ansi"]		= "Möchten Sie diese GEDCOM Datei vom UTF-8 ins ANSI (ISO-8859-1)-Format konvertieren?";
$pgv_lang["user_manual"]		= "PhpGedView Benutzer Handbuch";
$pgv_lang["upgrade"]			= "PhpGedView-Upgrade";
$pgv_lang["view_logs"]			= "Log-Dateien einsehen";
$pgv_lang["step1"]				= "Schritt 1 von 5:";
$pgv_lang["step2"]				= "Schritt 2 von 5:";
$pgv_lang["step3"]				= "Schritt 3 von 5:";
$pgv_lang["step4"]				= "Schritt 4 von 5:";
$pgv_lang["step5"]				= "Schritt 5 von 5:";

//-- Relationship chart messages
$pgv_lang["relationship_chart"]         = "Verwandtschaftsberechnung";
$pgv_lang["person1"]                    = "Person 1:";
$pgv_lang["person2"]                    = "Person 2:";
$pgv_lang["no_link_found"]              = "Keine Verbindung zwischen den beiden Personen gefunden.";
$pgv_lang["sibling"]                    = "Geschwister";
$pgv_lang["follow_spouse"]              = "Überprüfe Verwandtschaft anhand der Ehen.";
$pgv_lang["timeout_error"]              = "Die maximal zulässige Ausführungszeit des Scriptes wurde überschritten, bevor ein Verwandtschaftsverhältnis gefunden werden konnte.";
$pgv_lang["son"]                        = "Sohn";
$pgv_lang["daughter"]                   = "Tochter";
$pgv_lang["brother"]                    = "Bruder";
$pgv_lang["sister"]                     = "Schwester";
$pgv_lang["relationship_to_me"]		= "Verwandtschaft mit mir";
$pgv_lang["next_path"]			= "Nächsten Pfad suchen";
$pgv_lang["show_path"]			= "Pfad anzeigen";

//-- gedcom edit utility
$pgv_lang["check_delete"]		= "Möchten Sie dieses Ereignis wirklich löschen?";
$pgv_lang["access_denied"]		= "<strong>Zugriff verweigert</strong><br />Sie besitzen hierfür keine Erlaubnis.";
$pgv_lang["gedrec_deleted"]		= "Gedcom Eintrag erfolgreich gelöscht.";
$pgv_lang["gedcom_deleted"]		= "GEDCOM [#GED#] erfolgreich gelöscht.";
$pgv_lang["changes_exist"]		= "Änderungen wurden zur Gedcom Datei hinzugefügt.";
$pgv_lang["accept_changes"]		= "Änderungen in Datenbank akzeptieren / verwerfen";
$pgv_lang["show_changes"]		= "Dieser Eintrag wurde geändert. Hier klicken, um die Änderungen zu sehen.";
$pgv_lang["review_changes"]		= "Gedcom Änderung überprüfen";
$pgv_lang["undo_successful"]		= "löschen erfolgreich";
$pgv_lang["undo"]			= "löschen";
$pgv_lang["view_change_diff"]		= "Änderungen ansehen";
$pgv_lang["changes_occurred"]		= "Die folgenden Änderungen sind bei dieser Person aufgetreten:";
$pgv_lang["find_place"]			= "finde Ort";
$pgv_lang["close_window"]		= "Fenster schließen";
$pgv_lang["close_window_without_refresh"]	= "Fenster schließen ohne Neuladen";
$pgv_lang["place_contains"]             = "Ort enthält:";
$pgv_lang["accept_gedcom"]              = "Zum Verwerfen der Änderung, Lösch Button klicken. Zum Akzeptieren aller Änderungen an der Gedcom Datei, Reimport durchführen.";
$pgv_lang["ged_import"]                 = "Gedcom Import";
$pgv_lang["now_import"]                 = "Nun sollten Sie den Import der Gedcom Daten in phpGedView durch Klicken des Import Buttons starten.";
$pgv_lang["add_fact"]                   = "neues Ereignis hinzufügen";
$pgv_lang["add"]                        = "hinzufügen";
$pgv_lang["custom_event"]               = "Ereignis";
$pgv_lang["update_successful"]		= "Update erfolgreich";
$pgv_lang["add_child"]                  = "Kind hinzufügen";
$pgv_lang["add_child_to_family"]        = "Kind zu dieser Familie hinzufügen";
$pgv_lang["must_provide"]               = "Bitte eingeben:";
$pgv_lang["delete_person"]              = "Diese Person löschen";
$pgv_lang["confirm_delete_person"]      = "Möchten Sie diese Person wirklich aus der Gedcom Datei löschen ?";
$pgv_lang["find_media"]                 = "Media-Datei suchen";
$pgv_lang["set_link"]                   = "Link setzen";
$pgv_lang["add_source"]                 = "Quelle hinzufügen";
$pgv_lang["add_note"]                   = "Notiz hinzufügen";
$pgv_lang["delete_source"]              = "Diese Quelle löschen";
$pgv_lang["confirm_delete_source"]      = "Möchten Sie diese Quelle wirklich aus der Gedcom Datei löschen ?";
$pgv_lang["add_husb"]                   = "Ehemann hinzufügen";
$pgv_lang["add_husb_to_family"]		= "Einen Ehemann zu dieser Familie hinzufügen";
$pgv_lang["add_wife"]                   = "Ehefrau hinzufügen";
$pgv_lang["add_wife_to_family"]		= "Eine Ehefrau zu dieser Familie hinzufügen";
$pgv_lang["find_family"]                = "Familie suchen";
$pgv_lang["add_new_wife"]               = "Eine weitere Ehefrau hinzufügen";
$pgv_lang["add_new_husb"]               = "Einen weiteren Ehemann hinzufügen";
$pgv_lang["edit_name"]			= "Namen editieren";
$pgv_lang["delete_name"]		= "Namen löschen";
$pgv_lang["no_temple"]			= "Kein Tempel - Ordinanz zu Lebzeiten";
$pgv_lang["add_unlinked_person"]	= "Eine neue Person ohne Verwandtschaftsverknüpfung hinzufügen";

//-- calendar.php messages
$pgv_lang["on_this_day"]		= "An diesem Tag in Ihrer Chronik...";
$pgv_lang["in_this_month"]		= "In diesem Monat in Ihrer Chronik...";
$pgv_lang["year_anniversary"]		= "#year_var#. Jahrestag";
$pgv_lang["day"]			= "Tag:";
$pgv_lang["month"]			= "Monat:";
$pgv_lang["anniversary_calendar"]	= "Jahrestag Kalender";
$pgv_lang["sunday"]			= "Sonntag";
$pgv_lang["monday"]			= "Montag";
$pgv_lang["tuesday"]			= "Dienstag";
$pgv_lang["wednesday"]			= "Mittwoch";
$pgv_lang["thursday"]			= "Donnerstag";
$pgv_lang["friday"]			= "Freitag";
$pgv_lang["saturday"]			= "Samstag";
$pgv_lang["viewday"]			= "Tag anzeigen";
$pgv_lang["viewmonth"]			= "Monat anzeigen";
$pgv_lang["all_people"]			= "Alle Personen";
$pgv_lang["living_only"]                = "Lebende Personen";
$pgv_lang["recent_events"]		= "Jüngere Ereignisse (&lt; 100 Jahre)";

//-- upload media messages
$pgv_lang["upload_media"]		= "Media Dateien auf Server übertragen (upload)";
$pgv_lang["media_file"]                 = "Media Datei";
$pgv_lang["thumbnail"]                  = "Thumbnail";
$pgv_lang["upload_successful"]		= "Upload erfolgreich";

//-- user self registration module
$pgv_lang["requestpassword"]            = "Passwort verloren! Neues beantragen";
$pgv_lang["requestaccount"]             = "Als neuer Benutzer anmelden";
$pgv_lang["register_info_01"]		= "Der Zugang zu privaten Daten auf dieser Webseite kann eingeschränkt sein wegen geltender Datenschutzbestimmungen.<br />Die meisten Personen möchten nicht, dass ihre persönlichen Daten im Internet öffentlich zugänglich sind, da diese dann durch Identitäts-Diebstahl oder für Spam-Versandt missbraucht werden könnten.<br /><br />Um die privaten Daten zu sehen, müssen Sie einen Zugang zu dieser Webseite haben. Um einen Zugang zu bekommen, können Sie sich selbst registrieren, wobei Sie einige Fragen zu Ihrer Person beantworten müssen. Sobald der Administrator Ihre Angaben geprüft und die Registrierung aktiviert hat, können Sie sich auf der Weibseite einloggen und private Daten ansehen.<br /><br />Falls die Verwandschaftsüberprüfung eingeschaltet wurde, können Sie auch danach nur auf die privaten Daten ihrer eigenen näheren Verwandtschaft zugreifen. Der Administrator kann Ihnen auch Rechte zur Veränderung der vorhandenen Daten geben oder zum Eingeben neuer Daten.<br /><br />Bitte beachten Sie, dass Sie nur dann Zugriff auf die Daten erhalten, wenn Sie nachweisen können, dass Sie mit einer der Personen in der Datenbank verwandt sind.<br /><br />Falls dies nicht der Fall sein sollte, wäre es unnötig,  einen Antrag zu stellen, weil diesem wahrscheinlich nicht nachgegangen wird.<br />Falls Sie weitere Unterstützung brauchen, klicken Sie bitte auf den unten stehenden Link und fragen Sie den Betreiber dieser Website per E-Mail um Rat.<br /><br />";
$pgv_lang["register_info_02"]		= "";
$pgv_lang["pls_note01"]                 = "Bitte beachten: Es wird zwischen Groß- und Kleinbuchstaben unterschieden!";
$pgv_lang["min6chars"]                  = "min. 6 Zeichen lang";
$pgv_lang["pls_note02"]                 = "Bitte beachten: Passwörter sollten nur Buchstaben und Zahlen beinhalten. Falls Sie andere Zeichen verwenden, könnte es auf manchen Systemen Probleme bei der Identifizierung Ihres Passwortes geben.";
$pgv_lang["pls_note03"]                 = "Diese E-Mail Adresse wird vor Aktivierung Ihres Zuganges überprüft. Sie wird nicht auf der Webseite veröffentlicht. Sie werden eine Nachricht mit Ihren Registrierungsdaten an diese E-Mail Adresse erhalten.";
$pgv_lang["emailadress"]                = "Email Adresse:";
$pgv_lang["pls_note04"]                 = "Mit * markierte Felder sind Pflichtfelder.";
$pgv_lang["pls_note05"]                 = "Nach vollständiger Eingabe Ihrer Daten und Überprüfung Ihrer Angaben werden Sie eine Bestätigungs-Mail an die hier angegebene Adresse erhalten. Mit der Bestätigungs-Mail können Sie Ihren Zugang aktivieren. Falls Sie den Zugang nicht binnen 7 Tagen aktivieren, wird er gelöscht (Sie müssen sich dann erst erneut registrieren). Um sich an dieser Seite einzuloggen bnenötigen Sie Ihren User-Namen und das Passwort. Achten Sie darauf eine gültige E-Mail-Adresse anzugeben, sonst können Sie die Bestätigungs-Mail mit Ihren Zugangsdaten nicht erhalten.<br /><br />Falls bei der Registrierung Probleme auftreten, fragen Sie bitte den Webmaster um Hilfe.";

$pgv_lang["mail01_line01"]              = "Hallo #user_fullname# ...";
$pgv_lang["mail01_line02"]              = "Auf der Website ( #SERVER_NAME# ) wurde ein Benutzerantrag mit Ihrer Emailadresse ( #user_email# ) gestellt.";
$pgv_lang["mail01_line03"]              = "Dabei wurden die unten stehenden Benutzerdaten eingegeben.";
$pgv_lang["mail01_line04"]              = "Bitte klicken Sie nun auf den unten stehenden Link und geben die dort geforderten Daten ein, um Ihre Anmeldung und die Funktion Ihres Email-Kontos zu bestätigen.";
$pgv_lang["mail01_line05"]              = "Sollten Sie diese Daten nicht beantragt haben, so können Sie diese Mail einfach löschen.";
$pgv_lang["mail01_line06"]              = "Sie werden keine weitere Mail mehr erhalten, da ohne Verifizierung die angegebenen Daten nach einer Woche automatisch gelöscht werden.";

$pgv_lang["mail01_subject"]             = "Ihre Anmeldung bei #SERVER_NAME#";

$pgv_lang["mail02_line01"]              = "Hallo Administrator ...";
$pgv_lang["mail02_line02"]              = "Es hat sich eine neue Person auf der Website ( #SERVER_NAME# ) angemeldet.";
$pgv_lang["mail02_line03"]              = "Diese hat eine Email mit der Aufforderung, sich mit einem Verifizierungscode zu verifizieren, erhalten.";
$pgv_lang["mail02_line04"]              = "Sobald diese Verifikation erfolgt ist, werden Sie erneut benachrichtigt und aufgefordert, diese Person freizuschalten.";

$pgv_lang["mail02_subject"]             = "Neue Anmeldung bei #SERVER_NAME#";

$pgv_lang["hashcode"]                   = "Verifizierungscode:";
$pgv_lang["thankyou"]                   = "Hallo #user_fullname# ...<br />Danke für Ihre Anmeldung";
$pgv_lang["pls_note06"]                 = "Es wurde eine Bestätigungsmail an die Adresse ( #user_email# ) versandt. Durch die mitgesandten Daten können Sie ihren Account aktivieren. Falls Sie innerhalb von 7 Tagen nicht reagieren, wird dieser wieder gelöscht (danach können Sie mit diesem Benutzernamen wieder einen Account anlegen). Um sich auf dieser Website anzumelden, werden Sie dann in Zukunft nur noch Ihren Benutzernamen und Ihr Passwort benötigen.";

$pgv_lang["registernew"]                = "Verifizierung der neuen Benutzerdaten";
$pgv_lang["user_verify"]                = "Benutzer Verifizierung";
$pgv_lang["send"]                       = "Absenden";

$pgv_lang["pls_note07"]                 = "Bitte geben Sie nun Ihren Usernamen, ihr Passwort und den Verifizierungscode ein, welchen Sie per Email erhalten haben, um Ihre Anmeldung zu bestätigen.";
$pgv_lang["pls_note08"]                 = "Die Angaben für den Benutzer #user_name# wurden überprüft.";

$pgv_lang["mail03_line01"]              = "Hallo Administrator ...";
$pgv_lang["mail03_line02"]              = "#newuser[username]# ( #newuser[fullname]# ) hat die Registrierungsdaten verifiziert.";
$pgv_lang["mail03_line03"]              = "Bitte klicken Sie jetzt auf den unten stehenden Link, loggen sich ein und geben den Besucher frei, damit der Benutzer sich in Zukunft einloggen kann.";

$pgv_lang["mail03_subject"]             = "Neue Verifizierung bei #SERVER_NAME#";

$pgv_lang["pls_note09"]                 = "Sie wurden als eingetragener Benutzer identifiziert.";
$pgv_lang["pls_note10"]                 = "Der Administrator wurde benachrichtigt.<br />Sobald dieser Ihren Account freigegeben hat, können Sie sich mit Ihrem Usernamen und Ihrem Passwort einloggen.";
$pgv_lang["data_incorrect"]             = "Die Daten waren falsch!<br />Bitte versuchen Sie es erneut!";
$pgv_lang["user_not_found"]		= "Die Eingegebenen Informationen waren falsch. Bitte versuchen Sie es erneut.";

$pgv_lang["lost_pw_reset"]              = "Passwort neu anfordern";

$pgv_lang["pls_note11"]                 = "Um ein neues Passwort zu beantragen, geben Sie bitte Ihren Benutzernamen und die E-Mail-Adresse Ihres Zugangs ein.Wir werden Ihnen eine spezielle URL zumailen, die einen Bestätigungs-Code für Ihren Zugang enthält. Auf der Web-Seite dieser URL können Sie Ihr Passwort ändern. Aus Sicherheitsgründen dürfen Sie diesen Bestätigungs-Code ('hash') niemandem mitteilen, auch nicht dem Administrator dieser Seit (wir werden Sie nie danach fragen!).<br /><br />Falls Sie Hilfe benötigen, schreiben Sie bitte eine Anfrage an den Administrator.";
$pgv_lang["enter_email"]                = "Sie müssen eine Emailadresse angeben.";

$pgv_lang["mail04_line01"]              = "Hallo #user_fullname#...";
$pgv_lang["mail04_line02"]              = "Für ihren Benutzernamen wurde ein neues Passwort angefordert!";
$pgv_lang["mail04_line03"]              = "Empfehlung:";
$pgv_lang["mail04_line04"]              = "Bitte klicken Sie jetzt auf den unten stehenden Link, loggen sich mit dem neuen Passwort ein erneuern dieses, um ihre Datensicherheit zu behalten.";

$pgv_lang["mail04_subject"]		= "Datenanforderung bei #SERVER_NAME#";

$pgv_lang["pwreqinfo"]			= "Hallo...<br /><br />An die von Ihnen angegebene Emailadresse (#user[email]#) wurde das neue Passwort versandt.<br /><br />Prüfen Sie Ihr Mailkonto, da die Mail innerhalb der nächsten Minuten ankommen müsste.<br /><br />Empfehlung:<br /><br />Nach Empfang der Mail loggen Sie sich hier bitte mit dem neuen Passwort ein und ändern dieses sogleich, um ihre Datensicherheit zu behalten.";

$pgv_lang["editowndata"]                = "Eigene Userdaten bearbeiten";
$pgv_lang["savedata"]                   = "Geänderte Daten speichern";
$pgv_lang["datachanged"]                = "Benutzerdaten wurden geändert!";
$pgv_lang["datachanged_name"]           = "Möglicherweise müssen Sie sich mit Ihrem neuen Benutzernamen neu anmelden.";
$pgv_lang["myuserdata"]                 = "Meine Benutzerdaten";
$pgv_lang["verified"]                   = "Benutzer hat sich selber verifiziert:";
$pgv_lang["verified_by_admin"]          = "Benutzer wurde durch den Administrator freigegeben:";
$pgv_lang["user_theme"]                 = "Mein Thema";
$pgv_lang["mygedview"]                  = "Mein GedView";
$pgv_lang["passwordlength"]             = "Das Passwort muss mind. 6 Zeichen lang sein.";
$pgv_lang["admin_approved"]		= "Ihr Zugang für #SERVER_NAME# wurde freigegeben";
$pgv_lang["you_may_login"]		= " vom Administrator dieser Seite. Mit dem folgenden Link können Sie sich jetzt auf der PhpGedView Seite einloggen:";

//-- mygedview page
$pgv_lang["welcome"]                    = "Wilkommen";
$pgv_lang["upcoming_events"]		= "Bevorstehende Ereignisse";
$pgv_lang["chat"]                       = "Chat";
$pgv_lang["users_logged_in"]		= "Angemeldete Benutzer";
$pgv_lang["message"]			= "Nachricht senden";
$pgv_lang["my_messages"]		= "Meine Nachrichten";
$pgv_lang["date_created"]		= "gesendet:";
$pgv_lang["message_from"]		= "E-Mail Adresse:";
$pgv_lang["message_from_name"]		= "Ihr Name:";
$pgv_lang["message_to"]			= "An:";
$pgv_lang["message_subject"]		= "Betreff:";
$pgv_lang["message_body"]		= "Text:";
$pgv_lang["no_to_user"]                 = "Bitte Empfänger angeben.";
$pgv_lang["provide_email"]              = "Bitte geben Sie die E-Mail-Adresse an, damit wir Ihre Nachricht beantworten können, andernfalls ist eine Antwort nicht möglich. Ihre E-Mail-Adresse wird ausschließlich zur Beantwortung Ihrer Anfrage genutzt.";
$pgv_lang["reply"]                      = "Antwort";
$pgv_lang["message_deleted"]		= "Nachricht gelöscht";
$pgv_lang["message_sent"]               = "Nachricht gesendet";
$pgv_lang["reset"]                      = "Reset";
$pgv_lang["site_default"]               = "Grundeinstellung";
$pgv_lang["mygedview_desc"]             = "Dieses Portal ermöglicht Ihnen das Anlegen von Lesezeichen zu bevorzugten Personen, Überwachen bevorstehender Ereignisse und die Zusammenarbeit mit anderen PhpGedView Benutzern.";
$pgv_lang["no_messages"]                = "Keine Nachrichten.";
$pgv_lang["clicking_ok"]                = "Durch Klick auf OK, können Sie im sich öffnenden Fenster #user[fullname]# kontaktieren.";
$pgv_lang["my_favorites"]               = "Meine Lesezeichen";
$pgv_lang["no_favorites"]               = "Sie haben noch keine Lesezeichen gesetzt. Dies können Sie tun, indem Sie in der Detailansicht einer Person auf den 'Lesezeichen setzen'-Button klicken, oder Sie benutzen die folgende ID-Box.";
$pgv_lang["add_to_my_favorites"]	= "Lesezeichen hinzufügen";
$pgv_lang["confirm_fav_remove"]		= "Möchten Sie dieses Lesezeichen wirklich löschen?";
$pgv_lang["portal"]                     = "Portal";
$pgv_lang["invalid_email"]              = "Bitte geben Sie eine gültige E-Mail-Adresse ein.";
$pgv_lang["enter_subject"]              = "Bitte geben Sie einen Betreff ein.";
$pgv_lang["enter_body"]                 = "Bitte geben Sie vor dem Senden einen Text ein.";
$pgv_lang["confirm_message_delete"]	= "Möchten Sie diese Nachricht wirklich löschen? Sie kann anschließend nicht wiederhergestellt werden.";
$pgv_lang["message_email1"]		= "Die folgende Nachricht wurde an Ihr PhpGedView Benutzer-Postfach gesendet von ";
$pgv_lang["message_email2"]		= "Sie haben die folgende Nachricht an einen PhpGedView Benutzer gesendet:";
$pgv_lang["message_email3"]		= "You sent the following message to a PhpGedView administrator:";
$pgv_lang["viewing_url"]		= "Diese Nachricht wurde gesendet, als die folgende Seite aufgerufen wurde: ";
$pgv_lang["messaging2_help"]		= "Wenn Sie diese Nachricht senden, wird eine Kopie an die von Ihnen angegebene E-Mail Adresse geschickt.";
$pgv_lang["random_picture"]		= "Zufällig ausgewähltes Bild";
$pgv_lang["message_instructions"]	= "<b>Bitte beachten:</b> Private Informationen von lebenden Personen werden nur Familienangehörigen und nahen Freunden zugänglich gemacht. Bevor Sie irgendwelche persönlichen Daten ansehen können, müssen Sie Ihren Verwandtschaftsgrad belegen. Es kann auch vorkommen, dass bestimmte Daten von bereits verstorbenen Personen privat sind. Dies kann der Fall sein, wenn nicht genügend Informationen vorhanden sind, um sicher zu belegen, ob die Person noch lebt oder verstorben ist.<br /><br />Bevor Sie Fragen stellen, überprüfen Sie bitte, dass Sie über die von Ihnen gesuchte Person fragen, indem Sie Orte, Zeitangaben und Verwandte prüfen. Falls Sie Änderungen der genealogischen Daten übermitteln, geben Sie bitte auch die Quelle an, von der Sie Ihre Informationen bezogen haben.<br /><br />";

//-- upgrade.php messages
$pgv_lang["upgrade_util"]		= "Upgrade Modul";
$pgv_lang["no_upgrade"]			= "Es gibt keine Dateien für ein Upgrade.";
$pgv_lang["use_version"]		= "Sie benutzen die Version:";
$pgv_lang["current_version"]		= "Aktuelle stabile Version:";
$pgv_lang["upgrade_download"]		= "Herunterladen:";
$pgv_lang["upgrade_tar"]		= "TAR";
$pgv_lang["upgrade_zip"]		= "ZIP";
$pgv_lang["latest"]			= "Sie benutzen die jüngste Version von PhpGedView.";
$pgv_lang["location"]			= "Speicherort der Upgrade-Dateien: ";
$pgv_lang["include"]			= "Einschließen:";
$pgv_lang["options"]			= "Optionen:";
$pgv_lang["inc_phpgedview"]		= " PhpGedView";
$pgv_lang["inc_languages"]		= " Sprachen";
$pgv_lang["inc_config"]			= " Konfigurations-Datei";
$pgv_lang["inc_researchlog"]		= " Researchlog";
$pgv_lang["inc_index"]			= " Index Dateien";
$pgv_lang["inc_themes"]			= " Themes";
$pgv_lang["inc_docs"]			= " Handbücher";
$pgv_lang["inc_privacy"]		= " Privacy Datei(en)";
$pgv_lang["inc_backup"]			= "Sicherung erstellen";
$pgv_lang["upgrade_help"]		= " Hilfe anzeigen";
$pgv_lang["cannot_read"]		= "Folgende Datei kann nicht gelesen werden:";
$pgv_lang["not_configured"]		= "PhpGedView wurde noch nicht konfiguriert.";
$pgv_lang["location_upgrade"]		= "Bitte geben Sie den Speicherort Ihrer Upgrade-Dateien an.";
$pgv_lang["new_variable"]		= "Neue Variable gefunden: ";
$pgv_lang["config_open_error"]		= "Es gab einen Fehler beim Öffnen der Konfigurations-Datei.";
$pgv_lang["config_write_error"]		= "Fehler!!! Die Konfigurations-Datei kann nicht geschrieben werden.";
$pgv_lang["config_update_ok"]		= "Konfigurations-Datei erfolgreich aktualisiert.";
$pgv_lang["config_uptodate"]		= "Ihre Konfigurations-Datei ist aktuell.";
$pgv_lang["processing"]			= "Arbeite...";
$pgv_lang["privacy_open_error"]		= "Fehler beim Öffnen der Datei [#PRIVACY_MODULE#].";
$pgv_lang["privacy_write_error"]	= "FEHLER!!! Die Datei [#PRIVACY_MODULE#] kann nicht geschrieben werden.<br />Stellen Sie sicher, dass die Schreibrechte für diese Datei gesetzt sind.<br />Diese Rechte können zurückgesetzt werden, sobald die Datenschutzdatei geschrieben wurde.";
$pgv_lang["privacy_update_ok"]		= "Privacy Datei: [#PRIVACY_MODULE#] erfolgreich aktualisiert.";
$pgv_lang["privacy_uptodate"]		= "Ihre Datei [#PRIVACY_MODULE#] ist aktuell.";
$pgv_lang["heading_privacy"]		= "Privacy Datei(en):";
$pgv_lang["heading_phpgedview"]		= "PhpGedView Dateien:";
$pgv_lang["heading_image"]		= "Image-Dateien:";
$pgv_lang["heading_index"] 		= "Index-Dateien:";
$pgv_lang["heading_language"]		= "Sprach-Dateien:";
$pgv_lang["heading_theme"]		= "Theme-Dateien:";
$pgv_lang["heading_docs"]		= "Handbücher:";
$pgv_lang["heading_researchlog"]	= "Research Log Dateien:";
$pgv_lang["heading_researchloglang"]	= "Research Log Sprach-Dateien:";
$pgv_lang["copied_success"]		= "erfolgreich kopiert.";
$pgv_lang["backup_copied_success"]		= "Sicherungsdatei wurde erfolgreich erstellt.";
$pgv_lang["folder_created"]		= "Ordner angelegt";
$pgv_lang["process_error"]		= "Es gibt ein Problem beim Laden der Seite. Es kann nicht ermittelt werden, ob eine neue Version vorliegt.";

if (file_exists($PGV_BASE_DIRECTORY . "languages/lang.ge.extra.php")) require $PGV_BASE_DIRECTORY . "languages/lang.ge.extra.php";

?>