<?php
/*=================================================
   charset=utf-8
	Project: phpGedView
	File: lang.nl.php
	Author: Eduard Wustenveld
   Comments:	Dutch Language file for PHPGedView
   Change Log:	10/24/02 - File Created
		20030517 - Modified by Erik Bent (hjbent@users.sourceforge.net)
		2003-10-21 - Updated to version 2.52b3 by Boudewijn Sjouke
		2003-12-xx - Updated to version 2.61 by Boudewijn				
		2003-12-09 - File cleaned up / File is in-sync with lang.en again /minor typos
		2003-12-24 - Updated to version 2.65 by Boudewijn Sjouke
		2004-01-03 - Updated to version 2.65 Final by Jans B. Luder
		2004-01-19 - Updated to version 2.65.1 by Boudewijn Sjouke
===================================================*/
# $Id: lang.nl.php,v 1.23.2.3 2004/02/01 18:46:21 sjouke Exp $
if (preg_match("/lang\...\.php$/", $_SERVER["PHP_SELF"])>0) {
	print "You cannot access a language file directly.";
	exit;
}
//-- GENERAL HELP MESSAGES
$pgv_lang["qm"]				= "?";
$pgv_lang["page_help"]			= "Help";

//-- CONFIG FILE MESSAGES
$pgv_lang["error_title"]		= "FOUT: kan GEDCOM bestand niet openen";
$pgv_lang["error_header"]	 	= "Het GEDCOM bestand, [#GEDCOM#], kan niet worden gevonden op de aangegeven plaats.";
$pgv_lang["for_support"]		= "Voor ondersteuning en informatie neem contact op met";
$pgv_lang["for_contact"]		= "Neem voor genealogische vragen contact op met";
$pgv_lang["for_all_contact"]		= "Neem voor genealogische vragen en vragen over de site contact op met";
$pgv_lang["build_title"]		= "Indexbestanden worden opgebouwd";
$pgv_lang["build_error"]		= "Er is een nieuw GEDCOM bestand ontdekt.";
$pgv_lang["please_wait"]		= "Even geduld a.u.b. De indexbestanden moeten opnieuw worden opgebouwd.";
$pgv_lang["choose_gedcom"]		= "Kies een GEDCOM bestand";
$pgv_lang["username"]			= "Gebruikersnaam:";
$pgv_lang["password"]			= "Wachtwoord:";
$pgv_lang["login"]			= "Aanmelden";
$pgv_lang["login_aut"]			= "Mijn gegevens";
$pgv_lang["logout"]			= "Afmelden";
$pgv_lang["admin"]			= "Beheren";
$pgv_lang["logged_in_as"]		= "Aangemeld als";
$pgv_lang["my_pedigree"]		= "Mijn kwartierstaat";
$pgv_lang["my_indi"]			= "Mijn persoon";
$pgv_lang["yes"]			= "Ja";
$pgv_lang["no"]				= "Nee";
$pgv_lang["add_gedcom"]			= "GEDCOM toevoegen.";
$pgv_lang["no_support"]			= "Er is geconstateerd dat uw Internet Verkenner niet voldoet aan de eisen van PHPGedView. De meeste nieuwe versies voldoen hier wel aan. We raden u aan een nieuwere versie van uw Internet Verkenner te installeren.";

//-- INDEX (PEDIGREE_TREE) FILE MESSAGES
$pgv_lang["index_header"]		= "Kwartierstaat";
$pgv_lang["gen_ped_chart"]		= "Kwartierstaat (#PEDIGREE_GENERATIONS# Generaties)";
$pgv_lang["generations"]		= "Generaties: ";
$pgv_lang["view"]			= "Ververs pagina";
$pgv_lang["fam_spouse"]			= "Gezin met echtgenoot:";
$pgv_lang["root_person"]		= "Start-persoon ID: ";
$pgv_lang["hide_details"]		= "Verberg details";
$pgv_lang["show_details"]		= "Laat details zien";
$pgv_lang["person_links"]		= "Verwijzingen naar overzichten, families en verwanten van deze persoon.";
$pgv_lang["zoom_box"]			= "In/uitzoomen op dit vak.";
$pgv_lang["portrait"]			= "Staand";
$pgv_lang["landscape"]			= "Liggend";
$pgv_lang["start_at_parents"]	= "Ga naar ouders";

//-- FUNCTIONS FILE MESSAGES
$pgv_lang["unable_to_find_family"]	= "Niet gevonden: gezin met id";
$pgv_lang["unable_to_find_indi"]	= "Niet gevonden: persoon met id";
$pgv_lang["unable_to_find_record"]	= "Niet gevonden: record met id";
$pgv_lang["unable_to_find_source"]	= "Niet gevonden: bron met id";
$pgv_lang["unable_to_find_repo"]	= "Niet gevonden: bewaarplaats met id";
$pgv_lang["repo_name"]			= "Naam bewaarplaats:";
$pgv_lang["address"]			= "Adres:";
$pgv_lang["phone"]			= "Telefoon:";
$pgv_lang["source_name"]		= "Naam bron:";
$pgv_lang["title"]			= "Titel:";
$pgv_lang["author"]			= "Auteur:";
$pgv_lang["publication"]		= "Publicatie:";
$pgv_lang["call_number"]		= "Call number:";
$pgv_lang["living"]			= "Levend";
$pgv_lang["private"]			= "Priv&eacute;";
$pgv_lang["birth"]			= "Geboren:";
$pgv_lang["death"]			= "Overleden:";
$pgv_lang["descend_chart"]		= "Nakomelingen";
$pgv_lang["individual_list"]		= "Personen";
$pgv_lang["family_list"]		= "Gezinnen";
$pgv_lang["source_list"]		= "Bronnen";
$pgv_lang["place_list"]			= "Personen per locatie";
$pgv_lang["media_list"]			= "Multimedia";
$pgv_lang["search"]			= "Zoeken";
$pgv_lang["clippings_cart"]		= "Stamboom knipsels";
$pgv_lang["not_an_array"]		= "Geen tabel";
$pgv_lang["print_preview"]		= "Afdrukvoorbeeld";
$pgv_lang["change_lang"]		= "Wijzig taal";
$pgv_lang["print"]			= "Afdrukken";
$pgv_lang["total_queries"]		= "Totaal aantal databasevragen:";
$pgv_lang["back"]			= "Terug";

//-- INDIVUDUAL FILE MESSAGES
$pgv_lang["male"]			= "Man";
$pgv_lang["female"]			= "Vrouw";
$pgv_lang["temple"]			= "LDS tempel";
$pgv_lang["temple_code"]		= "LDS Tempelcode:";
$pgv_lang["status"]			= "Status";
$pgv_lang["source"]			= "Bron:";
$pgv_lang["citation"]			= "Aanhaling:";
$pgv_lang["text"]			= "Tekst:";
$pgv_lang["note"]			= "Notitie:";
$pgv_lang["unrecognized_code"]		= "Onbekende GEDCOM code";
$pgv_lang["indi_info"]			= "Persoonsinformatie";
$pgv_lang["pedigree_chart"]		= "Kwartierstaat";
$pgv_lang["desc_chart2"]		= "Nakomelingen";
$pgv_lang["family"]			= "Gezin";
$pgv_lang["as_spouse"]			= "Gezin met echtgenoot";
$pgv_lang["as_child"]			= "Gezin met ouders";
$pgv_lang["view_gedcom"]		= "Bekijk GEDCOM record";
$pgv_lang["add_to_cart"]		= "Toevoegen aan knipselbak";
$pgv_lang["still_living_error"]		= "Deze persoon leeft nog of heeft geen geregistreerde geboorte- of sterfdatum. Alle details van levende personen worden verborgen voor openbaar gebruik.<br />Neem voor meer informatie contact op met";
$pgv_lang["privacy_error"]	    	= "Details van deze persoon zijn priv&eacute;.<br />";
$pgv_lang["more_information"]		= "Neem voor meer informatie contact op met ";
$pgv_lang["name"]			= "Naam:";
$pgv_lang["given_name"]			= "Voornaam:";
$pgv_lang["surname"]			= "Achternaam:";
$pgv_lang["suffix"]			= "Toevoeging:";
$pgv_lang["object_note"]		= "Object notitie:";
$pgv_lang["sex"]			= "Geslacht:";
$pgv_lang["personal_facts"]		= "Persoonlijke feiten en details";
$pgv_lang["type"]			= "Type";
$pgv_lang["date"]			= "Datum";
$pgv_lang["place_description"]		= "Plaats / Omschrijving";
$pgv_lang["parents"] 			= "Ouders:";
$pgv_lang["siblings"] 			= "Broers/zussen";
$pgv_lang["father"] 			= "Vader";
$pgv_lang["mother"] 			= "Moeder";
$pgv_lang["relatives"]			= "Verwanten";
$pgv_lang["child"]			= "Kind";
$pgv_lang["spouse"]			= "Echtgenoot";
$pgv_lang["surnames"]			= "Achternamen";
$pgv_lang["adopted"]			= "Geadopteerd";
$pgv_lang["foster"]			= "Pleeg";
$pgv_lang["sealing"]			= "Zegeling";
$pgv_lang["link_as"]			= "Koppel deze persoon aan een bestaand gezin als: ";

//-- FAMILY FILE MESSAGES
$pgv_lang["family_info"]		= "Gezinsinformatie";
$pgv_lang["family_group_info"]		= "Gezinsinformatie";
$pgv_lang["husband"]			= "Echtgenoot";
$pgv_lang["wife"]			= "Echtgenote";
$pgv_lang["marriage"]			= "Huwelijk:";
$pgv_lang["lds_sealing"]		= "LDS sealing:";
$pgv_lang["marriage_license"]		= "Huwelijksovereenkomst:";
$pgv_lang["media_object"]		= "Multimedia object:";
$pgv_lang["children"]			= "Kinderen";
$pgv_lang["no_children"]		= "Geen kinderen";
$pgv_lang["parents_timeline"]		= "Laat ouders zien<br />op de tijdlijn";

//-- CLIPPINGS FILE MESSAGES
$pgv_lang["clip_cart"]			= "Knipselbak";
$pgv_lang["clip_explaination"]		= "De Stamboom knipsel-bak geeft u de mogelijkheid om &quot;knipsels&quot; van deze stamboom te nemen en deze samen te bundelen in één GEDCOM bestand om te kunnen downloaden.<br /><br />";
$pgv_lang["item_with_id"]		= "Item met ID";
$pgv_lang["error_already"]		= "zit al in uw knipsel bak.";
$pgv_lang["which_links"]		= "Welke koppelingen uit dit gezin wilt u nog meer toevoegen?";
$pgv_lang["just_family"]		= "Voeg alleen dit gezin toe.";
$pgv_lang["parents_and_family"]		= "Voeg de ouders en dit gezin toe.";
$pgv_lang["parents_and_child"]		= "Voeg de ouders, dit gezin en de kinderen toe.";
$pgv_lang["parents_desc"]		= "Voeg de ouders, dit gezin en alle nakomelingen toe.";
$pgv_lang["continue"]			= "Doorgaan met toevoegen";
$pgv_lang["which_p_links"]		= "Welke koppelingen van deze persoon wilt u nog meer toevoegen?";
$pgv_lang["just_person"]		= "Voeg alleen deze persoon toe.";
$pgv_lang["person_parents_sibs"]	= "Voeg deze persoon, zijn/haar ouders en broers en zussen toe.";
$pgv_lang["person_ancestors"]		= "Voeg deze persoon en de directe voorouders toe.";
$pgv_lang["person_ancestor_fams"]	= "Voeg deze persoon, de directe voorouders en hun gezinnen toe.";
$pgv_lang["person_spouse"]		= "Voeg deze persoon, zijn/haar ega en kinderen toe.";
$pgv_lang["person_desc"]		= "Voeg deze persoon, zijn/haar ega en alle nakomelingen toe.";
$pgv_lang["unable_to_open"]		= "Het is niet mogelijk om naar de knipsel-bak te schrijven";
$pgv_lang["person_living"]		= "Deze persoon leeft nog. Persoonlijke details worden niet toegevoegd.";
$pgv_lang["person_private"]		= "Details van deze persoon zijn priv&eacute;. Persoonlijke details worden niet toegevoegd.";
$pgv_lang["family_private"]		= "Details van deze familie zijn priv&eacute;. Details van deze familie worden niet toegevoegd.";
$pgv_lang["download"]			= "Klik met uw rechtermuisknop op de onderstaande links en selecteer &quot;Bewaar doel als&quot; om de bestanden te downloaden.";
$pgv_lang["media_files"]		= "Referenties aan media bestanden in deze GEDCOM";
$pgv_lang["cart_is_empty"]		= "Uw knipsel-bak is leeg.";
$pgv_lang["id"]				= "ID";
$pgv_lang["name_description"]		= "Naam / Omschrijving";
$pgv_lang["remove"]			= "Verwijderen";
$pgv_lang["empty_cart"]			= "Maak bak leeg";
$pgv_lang["download_now"]		= "Nu downloaden";
$pgv_lang["indi_downloaded_from"]	= "Deze persoon is gedownload van:";
$pgv_lang["family_downloaded_from"]	= "Deze familie is gedownload van:";
$pgv_lang["source_downloaded_from"]	= "Deze bron is gedownload van:";

//-- PLACELIST FILE MESSAGES
$pgv_lang["connections"]		= "Locatieverbindingen gevonden<br />Bekijk nu de resultaten";
$pgv_lang["top_level"]			= "Hoogste niveau";
$pgv_lang["form"]			= "Locaties staan geordend in deze volgorde: ";
$pgv_lang["gedcom_form_info"]			= "(vlgs. GEDCOM)";
$pgv_lang["default_form_info"]			= "(Standaard)";
$pgv_lang["default_form"]		= "Plaats, Gemeente, Provincie/Staat, Land";
$pgv_lang["unknown"]			= "Onbekend";
$pgv_lang["individuals"]		= "PERSONEN";

//-- MEDIALIST FILE MESSAGES
$pgv_lang["multi_title"]		= "Multimedialijst";
$pgv_lang["media_found"]		= "Media objecten gevonden";
$pgv_lang["view_person"]		= "Bekijk persoon";
$pgv_lang["view_family"]		= "Bekijk gezin";
$pgv_lang["view_source"]		= "Bekijk bron";
$pgv_lang["prev"]			= "< vorige";
$pgv_lang["next"]			= "volgende >";
$pgv_lang["file_not_found"]		= "Bestand niet gevonden.";

//-- SEARCH FILE MESSAGES
$pgv_lang["search_gedcom"]		= "Doorzoek GEDCOM bestand";
$pgv_lang["enter_terms"]		= "Geef zoekcriteria op:";
$pgv_lang["soundex_search"]		= "Achternaam zoeken met Soundex:";
$pgv_lang["search_results"]		= "Zoek resultaten";
$pgv_lang["sources"]			= "BRONNEN";
$pgv_lang["firstname_search"]		= "Voornaam:";
$pgv_lang["lastname_search"]		= "Achternaam:";
$pgv_lang["search_place"]		= "Plaats:";
$pgv_lang["search_year"]		= "Jaar:";
$pgv_lang["lastname_empty"]		= "Geef een achternaam op.";
$pgv_lang["no_results"]			= "Geen resultaat gevonden.";
$pgv_lang["soundex_results"]		= "Wellicht zijn de volgende soundex-resultaten van belang.";

//-- SOURCELIST FILE MESSAGES
$pgv_lang["sources_found"]		= "Bronnen gevonden";

//-- SOURCE FILE MESSAGES
$pgv_lang["source_info"]		= "Bron informatie";
$pgv_lang["other_records"]		= "Andere records die verwijzen naar deze bron:";
$pgv_lang["people"]			= "MENSEN";
$pgv_lang["families"]			= "GEZINNEN";

//-- BUILDINDEX FILE MESSAGES
$pgv_lang["building_indi"]		= "Persoons- en gezinsindexering wordt opgebouwd";
$pgv_lang["building_index"]		= "Index lijsten worden gebouwd";
$pgv_lang["importing_records"]		= "Toevoegen records aan de database";
$pgv_lang["detected_change"]		= "phpGedView heeft een verandering gevonden in het GEDCOM bestand  #GEDCOM#. Index bestanden moeten eerst opnieuw worden gemaakt voordat u kunt doorgaan.";
$pgv_lang["please_be_patient"]		= "EVEN GEDULD A.U.B.";
$pgv_lang["reading_file"]		= "GEDCOM bestand inlezen";
$pgv_lang["flushing"]			= "Inhoud verwijderen";
$pgv_lang["found_record"]		= "Record gevonden";
$pgv_lang["exec_time"]			= "Totale uitvoerings tijd:";
$pgv_lang["unable_to_create_index"]	= "Index bestand schrijven mislukt. Dit komt waarschijnlijk doordat de rechten op de webserver onjuist ingesteld zijn.";
$pgv_lang["indi_complete"]		= "Persoonsindex voltooid";
$pgv_lang["family_complete"]		= "Gezinsindex voltooid";
$pgv_lang["source_complete"]		= "Algemene index voltooid.";
$pgv_lang["tables_exist"]		= "PHPGedView tabellen bestaan reeds in de database";
$pgv_lang["you_may"]			= "U kunt:";
$pgv_lang["drop_tables"]		= "De huidige tabellen verwijderen";
$pgv_lang["import_multiple"]		= "werken met meedere GEDCOMS";
$pgv_lang["explain_options"]		= "Als u ervoor kiest om de tabellen te droppen dan wordt alle informatie vervangen door dit gedcom bestand.<br />Als u ervoor kiest om met meerdere gedcoms te werken dan zal phpGedView alle gegevens verwijderen die dezelfde gedcom bestandsnaam hebben. Deze optie maakt het mogelijk om meerdere GEDCOM bestanden in dezelfde tabellen op te slaan en eenvoudig te wisselen.";
$pgv_lang["path_to_gedcom"]		= "Geef het pad naar uw GEDCOM bestand:";
$pgv_lang["gedcom_title"]		= "Geef een omschrijving van de data in dit GEDCOM bestand:";
$pgv_lang["dataset_exists"]		= "Een GEDCOM bestand met deze naam staat reeds in de database.";
$pgv_lang["empty_dataset"]		= "Wilt u de dataset leeg maken?";
$pgv_lang["index_complete"]		= "Indexeren gereed.";
$pgv_lang["click_here_to_go_to_pedigree_tree"] = "Klik hier om naar de kwartierstaat te gaan.";
$pgv_lang["updating_is_dead"]		= "Aanpassen van overlijden voor INDI";
$pgv_lang["tools_readme"]			= "Zie ook de \"tools-section\" van het #README.TXT# bestand voor meer informatie.";
$pgv_lang["xreftorin"]				= "Omzetten XREF ID\'s naar RIN-nummer";
$pgv_lang["dateconvert"]			= "Programma datumconversie";
$pgv_lang["addmedia"]				= "Media-gereedschap toevoegen";
$pgv_lang["run_tools"]				= "Wilt u een van de volgende programma's uitvoeren voordat de GEDCOM wordt geimporteerd:";
$pgv_lang["run_tools"]				= "Wilt u een van de volgende programma's uitvoeren voordat de GEDCOM wordt geinporteerd:";
$pgv_lang["import_complete"]		= "Import gereed";
$pgv_lang["updating_family_names"]	= "Bijwerken familienamen voor FAM";
$pgv_lang["processed_for"]		= "Bestand verwerkt voor";

//-- INDIVIDUAL AND FAMILYLIST FILE MESSAGES
$pgv_lang["total_fams"]			= "Gezinnen gevonden";
$pgv_lang["total_indis"]		= "Personen gevonden";
$pgv_lang["starts_with"]		= "Beginnend met:";
$pgv_lang["person_list"]		= "Persoonslijst:";
$pgv_lang["paste_person"]		= "Persoon plakken";
$pgv_lang["notes_sources_media"]	= "Notities, bronnen en multimedia";
$pgv_lang["name_contains"]		= "Naam bevat:";
$pgv_lang["filter"]			= "Filter";
$pgv_lang["find_individual"]		= "Zoek persoon ID";
$pgv_lang["find_sourceid"]			= "Zoek bron-ID";
$pgv_lang["skip_surnames"]		= "Sla achternamenlijst over";
$pgv_lang["show_surnames"]		= "Toon achternamenlijst";
$pgv_lang["all"]			= "ALLE";

//-- TIMELINE FILE MESSAGES
$pgv_lang["age"]			= "Leeftijd";
$pgv_lang["timeline_title"]		= "Tijdlijn";
$pgv_lang["timeline_chart"]		= "Tijdlijn";
$pgv_lang["remove_person"]		= "Persoon verwijderen";
$pgv_lang["show_age"]			= "Toon leeftijds-indicator";
$pgv_lang["add_another"]		= "Nog een persoon aan de tijdlijn toevoegen:<br />Persoons ID:";
$pgv_lang["find_id"]			= "Zoek ID";
$pgv_lang["show"]			= "Toon";
$pgv_lang["year"]			= "Jaar:";
$pgv_lang["timeline_instructions"]	= "In de nieuwste browsers is het mogelijk om de weergegeven blokken te verschuiven zoals u dat wilt.";
$pgv_lang["zoom_in"]			= "Inzoomen";
$pgv_lang["zoom_out"]			= "Uitzoomen";

// -- MONTH NAMES
$pgv_lang["jan"]			= "januari";
$pgv_lang["feb"]			= "februari";
$pgv_lang["mar"]			= "maart";
$pgv_lang["apr"]			= "april";
$pgv_lang["may"]			= "mei";
$pgv_lang["jun"]			= "juni";
$pgv_lang["jul"]			= "juli";
$pgv_lang["aug"]			= "augustus";
$pgv_lang["sep"]			= "september";
$pgv_lang["oct"]			= "oktober";
$pgv_lang["nov"]			= "november";
$pgv_lang["dec"]			= "december";
$pgv_lang["abt"]			= "ongeveer";
$pgv_lang["aft"]			= "na";
$pgv_lang["and"]			= "en";
$pgv_lang["bef"]			= "voor";
$pgv_lang["bet"]			= "tussen";
$pgv_lang["cal"]			= "berekend";
$pgv_lang["est"]			= "geschat";
$pgv_lang["from"]			= "van";
$pgv_lang["int"]			= "afgeleid";
$pgv_lang["to"]				= "tot";
$pgv_lang["cir"]			= "circa";
$pgv_lang["apx"]			= "ongeveer";

//-- Admin File Messages
$pgv_lang["select_an_option"]		= "Selecteer een optie:";
$pgv_lang["readme_documentation"]	= "README documentatie";
$pgv_lang["configuration"]		= "Instellingen";
$pgv_lang["rebuild_indexes"]		= "Indexen (opnieuw) aanmaken";
$pgv_lang["user_admin"]			= "Beheer gebruikers";
$pgv_lang["user_created"]		= "Gebruiker gemaakt.";
$pgv_lang["user_create_error"]		= "Het is niet mogelijk om de gebruiker toe te voegen. Probeer het opnieuw.";
$pgv_lang["password_mismatch"]		= "Wachtwoorden zijn verschillend.";
$pgv_lang["enter_username"]		= "U moet de gebruikersnaam invullen.";
$pgv_lang["enter_fullname"]		= "U moet de volledige naam invullen.";
$pgv_lang["enter_password"]		= "U moet het wachtwoord invullen.";
$pgv_lang["confirm_password"]		= "U moet het wachtwoord twee keer invullen.";
$pgv_lang["update_user"]		= "Aanpassen gebruiker";
$pgv_lang["save"]			= "Opslaan";
$pgv_lang["delete"]			= "Verwijder";
$pgv_lang["edit"]			= "Wijzig";
$pgv_lang["full_name"]			= "Volledige naam";
$pgv_lang["can_admin"]			= "Heeft beheerrechten";
$pgv_lang["can_edit"]			= "Heeft wijzigingsrechten";
$pgv_lang["confirm_user_delete"]	= "Weet u zeker dat u deze gebruiker wilt verwijderen?";
$pgv_lang["create_user"]		= "Gebruiker maken";
$pgv_lang["no_login"]			= "De gebruiker is niet geautoriseerd.";
$pgv_lang["import_gedcom"]		= "Importeer dit GEDCOM bestand";
$pgv_lang["duplicate_username"]		= "Een gebruiker met die naam is reeds aanwezig. Ga terug en kies een andere naam.";
$pgv_lang["gedcomid"]			= "Gedcom INDI record ID";
$pgv_lang["enter_gedcomid"]		= "U moet een Gedcom ID invoeren.";
$pgv_lang["user_info"]			= "Mijn gebruikers informatie";
$pgv_lang["rootid"]			= "Start persoon van de kwartierstaat";
$pgv_lang["download_gedcom"]		= "Download Gedcom bestand";
$pgv_lang["upload_gedcom"]		= "Upload Gedcom bestand";
$pgv_lang["add_new_gedcom"]		= "Nieuwe Gedcom maken";
$pgv_lang["gedcom_file"]		= "Gedcom bestand:";
$pgv_lang["enter_filename"]		= "Voer een Gedcom-bestandsnaam in.";
$pgv_lang["file_exists"]		= "Er bestaat al een Gedcom-bestand met die naam. Kies een andere naam, of verwijder het oude bestand.";
$pgv_lang["new_gedcom_title"]		= "Genealogie van [#GEDCOMFILE#]";
$pgv_lang["upload_error"]		= "Er is een fout opgetreden bij het versturen van het Gedcom bestand.";
$pgv_lang["upload_help"]		= "Kies een bestand op de lokale schijf om naar de server te sturen. Dit bestand zal het huidige Gedcom bestand overschrijven. Daarna gaat u automatisch naar het scherm voor het opnieuw opbouwen van de indexen in: ";
$pgv_lang["add_gedcom_instructions"]	= "Geef een naam voor het nieuwe Gedcom-bestand. Deze zal worden geplaatst in de Index-map.";
$pgv_lang["file_success"]		= "Het bestand is goed verstuurd";
$pgv_lang["file_too_big"]		= "Het bestand is te groot.";
$pgv_lang["file_partial"]		= "Het bestand is slechts gedeeltelijk overgestuurd. Probeer het opnieuw.";
$pgv_lang["file_missing"]		= "Geen bestand ontvangen. Verstuur het bestand opnieuw.";
$pgv_lang["manage_gedcoms"]		= "Beheer Gedcoms";
$pgv_lang["research_log"]		= "Onderzoekslogboek";
$pgv_lang["administration"]		= "Beheer";
$pgv_lang["ansi_to_utf8"]		= "Converteer deze ANSI (ISO-8859-1) gecodeerde GEDCOM naar UTF-8?";
$pgv_lang["utf8_to_ansi"]		= "Converteer deze GEDCOM van UTF-8 naar ANSI (ISO-8859-1)?";
$pgv_lang["user_manual"]		= "PHPGedView gebruikershandboek";
$pgv_lang["upgrade"]			= "Upgrade PHPGedView";
$pgv_lang["view_logs"]			= "Bekijk Log-bestanden";
$pgv_lang["step5"]				= "Stap 5 van 5:";
$pgv_lang["step4"]				= "Stap 4 van 5:";
$pgv_lang["step3"]				= "Stap 3 van 5:";
$pgv_lang["step2"]				= "Stap 2 van 5:";
$pgv_lang["step2"]				= "Stap 2 van 4:";
$pgv_lang["step1"]				= "Stap 1 van 5:";

//-- Relationship chart messages
$pgv_lang["relationship_chart"]		= "Verwantschap";
$pgv_lang["person1"]			= "Persoon 1";
$pgv_lang["person2"]			= "Persoon 2";
$pgv_lang["no_link_found"]		= "Geen verbinding tussen de twee personen gevonden.";
$pgv_lang["sibling"]			= "Broer/zus";
$pgv_lang["follow_spouse"]		= "Controleer verwantschap door huwelijk.";
$pgv_lang["timeout_error"]		= "Maximale zoektijd overschreden voordat een relatie werd gevonden.";
$pgv_lang["son"]			= "Zoon";
$pgv_lang["daughter"]			= "Dochter";
$pgv_lang["brother"]			= "Broer";
$pgv_lang["sister"]			= "Zus";
$pgv_lang["relationship_to_me"]		= "Relatie met mij";
$pgv_lang["next_path"]			= "Zoek volgend pad";
$pgv_lang["show_path"]			= "Toon pad";

//-- gedcom edit utility
$pgv_lang["check_delete"]		= "Weet u zeker dat u dit Gedcom-feit wilt verwijderen?";
$pgv_lang["access_denied"]		= "<b>Toegang geweigerd</b><br />U heeft geen toegang tot deze bron.";
$pgv_lang["gedrec_deleted"]		= "GEDCOM record verwijderd.";
$pgv_lang["gedcom_deleted"]		= "GEDCOM [#GED#] verwijderd.";
$pgv_lang["changes_exist"]		= "Deze Gedcom is gewijzigd.";
$pgv_lang["accept_changes"]		= "Wijzigingen accepteren/ongedaan maken";
$pgv_lang["show_changes"]		= "Dit record is gewijzigd. Klik hier om de wijzigingen te tonen.";
$pgv_lang["review_changes"]		= "Bekijk GEDCOM wijzigingen";
$pgv_lang["undo_successful"]		= "Ongedaan maken geslaagd";
$pgv_lang["undo"]			= "Maak ongedaan";
$pgv_lang["view_change_diff"]		= "Toon wijzigingen";
$pgv_lang["changes_occurred"]		= "De volgende wijzigingen zijn voorgekomen voor deze persoon:";
$pgv_lang["find_place"]			= "Zoek plaats";
$pgv_lang["close_window"]		= "Sluit venster";
$pgv_lang["close_window_without_refresh"]	= "Sluit venster zonder herladen";
$pgv_lang["place_contains"]		= "Plaats bevat:";
$pgv_lang["accept_gedcom"]		= "Om een wijziging ongedaan te maken, klik op de link ernaast.<br /> Om alle wijzigingen in een Gedcom aan te brengen, importeer de Gedcom file opnieuw.";
$pgv_lang["ged_import"]			= "Importeren Gedcom bestand";
$pgv_lang["now_import"]			= "Klik op de onderstaande link om de Gedcom records te importeren in phpGedView";
$pgv_lang["add_fact"]			= "Nieuw feit toevoegen";
$pgv_lang["add"]			= "Toevoegen";
$pgv_lang["custom_event"]		= "Vrij te kiezen gebeurtenis";
$pgv_lang["update_successful"]		= "Bijwerken geslaagd.";
$pgv_lang["add_child"]			= "Kind toevoegen";
$pgv_lang["add_child_to_family"]	= "Kind toevoegen aan dit gezin";
$pgv_lang["must_provide"]		= "Invoeren:";
$pgv_lang["delete_person"]		= "Verwijder deze persoon";
$pgv_lang["confirm_delete_person"]	= "Weet u zeker dat u deze persoon uit de GEDCOM wilt verwijderen?";
$pgv_lang["find_media"]			= "Zoek multimedia";
$pgv_lang["set_link"]			= "Maak koppeling";
$pgv_lang["add_source"]			= "Voeg bron toe aan feit";
$pgv_lang["add_note"]			= "Voeg notitie toe aan feit";
$pgv_lang["delete_source"]		= "Verwijder deze bron";
$pgv_lang["confirm_delete_source"]	= "Weet u zeker dat u deze bron uit de GEDCOM wilt verwijderen?";
$pgv_lang["add_husb"]			= "Echtgenoot toevoegen";
$pgv_lang["add_husb_to_family"]		= "Voeg echtgenoot toe aan dit gezin";
$pgv_lang["add_wife"]			= "Echtgenote toevoegen";
$pgv_lang["add_wife_to_family"]		= "Voeg echtgenote toe aan dit gezin";
$pgv_lang["find_family"]		= "Zoek gezin";
$pgv_lang["add_new_wife"]		= "Nieuwe echtgenote toevoegen";
$pgv_lang["add_new_husb"]		= "Nieuwe echtgenoot toevoegen";
$pgv_lang["edit_name"]			= "Wijzig naam";
$pgv_lang["delete_name"]		= "Verwijder naam";
$pgv_lang["no_temple"]			= "Geen Temple - Living Ordinance";
$pgv_lang["add_unlinked_person"]	= "Nieuw ongekoppeld persoon toevoegen";

//-- calendar.php messages
$pgv_lang["on_this_day"]		= "Op deze dag, in het verleden...";
$pgv_lang["in_this_month"]		= "In deze maand, in het verleden...";
$pgv_lang["year_anniversary"]		= "#year_var# jaar geleden";
$pgv_lang["day"]			= "Dag:";
$pgv_lang["month"]			= "Maand:";
$pgv_lang["anniversary_calendar"] 	= "Gebeurteniskalender";
$pgv_lang["sunday"]			= "Zondag";
$pgv_lang["monday"]			= "Maandag";
$pgv_lang["tuesday"]			= "Dinsdag";
$pgv_lang["wednesday"]			= "Woensdag";
$pgv_lang["thursday"]			= "Donderdag";
$pgv_lang["friday"]			= "Vrijdag";
$pgv_lang["saturday"]			= "Zaterdag";
$pgv_lang["viewday"]			= "Toon dag";
$pgv_lang["viewmonth"]			= "Toon maand";
$pgv_lang["all_people"]			= "Alle personen";
$pgv_lang["living_only"]		= "Levende personen";
$pgv_lang["recent_events"]		= "Recente gebeurtenissen (< 100 jaar)";

//-- upload media messages
$pgv_lang["upload_media"]		= "Uploaden mediabestanden";
$pgv_lang["media_file"]			= "Mediabestand";
$pgv_lang["thumbnail"]			= "Miniatuurweergave";
$pgv_lang["upload_successful"]		= "Upload geslaagd";

//-- user self registration module
$pgv_lang["requestpassword"]		= "Wachtwoord kwijt? Vraag nieuw wachtwoord aan";
$pgv_lang["requestaccount"]		= "Nog geen gebruiker? Vraag gebruikersnaam aan";
$pgv_lang["register_info_01"]		= "De gegevens op deze website zullen niet volledig publiek toegankelijk zijn voor alle bezoekers.<br /><br />Dit is een gevolg van de wet op gegevensbescherming en privacy.<br />U zult zich voor kunnen stellen dat de meeste mensen het er niet mee eens zijn dat hun gegevens door iedereen ingezien kunnen worden, of kunnen worden misbruikt voor spam of commerciele doeleinden.<br /><br />Maar u heeft de mogelijkheid om u te registreren, om toegang tot de verborgen gegevens te krijgen, nadat de beheerder uw persoonlijke details heeft gecontroleerd. Indien de relatie-privacy is geactiveerd, heeft u toegang tot de informatie van uw directe relaties, na registratie. De beheerder kan u toegang verlenen om de gegevens van het bestand aan te passen, zodat u persoonlijke informatie kunt aanpassen, of toevoegen.<br /><br />OPMERKING: U zult alleen dan toegang tot de verborgen informatie krijgen, indien u aan kunt tonen dat u in het bestand voorkomt, of u een nauwe verwantschap heeft met een persoon in het bestand.<br /><br />In alle andere gevallen kunt u zich de moeite en tijd besparen om een account aan te vragen. Als u meer ondersteuning nodig heeft, gebruik dan a.u.b. de link onderaan, om contact op te nemen met de beheerder.<br /><br />";
$pgv_lang["register_info_02"]		= "";
$pgv_lang["pls_note01"]			= "Let op: het systeem is hoofdlettergevoelig!";
$pgv_lang["min6chars"]			= "Wachtwoord moet minimaal 6 karakters lang zijn";
$pgv_lang["pls_note02"]			= "Let op: Wachtwoorden mogen alleen letters en cijfers bevatten. Gebruik van leestekens e.d. kan leiden tot weigering van toegang.";
$pgv_lang["pls_note03"]			= "Dit e-mailadres wordt gecontroleerd voordat de gebruiker wordt geactiveerd. Het zal niet op de site worden getoond. U ontvangt een bericht op dit e-mailadres met de benodigde registratiegegevens voor het activeren.";
$pgv_lang["emailadress"]		= "E-mail adres:";
$pgv_lang["pls_note04"]			= "Velden met een * moeten verplicht worden ingevuld.";
$pgv_lang["pls_note05"]			= "U krijgt, op het e-mailadres dat u heeft opgegeven, een bevestiging toegezonden. Met de gegevens in deze e-mail kunt u uw gebruikersnaam activeren. Als dit niet binnen zeven dagen gebeurt, wordt uw verzoek verwijderd. Uw verzoek kunt u altijd opnieuw indienen. Om deze site ten volle te gebruiken, moet u beschikken over een gebruikersnaam en wachtwoord. U moet een geldig en bestaand e-mailadres opgeven op deze pagina, om de gebruikersgegevens te ontvangen. <br /><br />Als u problemen ondervindt bij het aanvragen van een gebruikersnaam op deze website, neemt u dan contact op met de beheerder.";

$pgv_lang["mail01_line01"]		= "Hallo #user_fullname# ...";
$pgv_lang["mail01_line02"]		= "Op ( #SERVER_NAME# ) is een verzoek gedaan om aan te melden met uw e-mailadres ( #user_email# ).";
$pgv_lang["mail01_line03"]		= "De volgende gegevens zijn gebruikt.";
$pgv_lang["mail01_line04"]		= "Klik op onderstaande link en vul de gegevens in om uw gebruikersnaam en e-mailadres te verifieren.";
$pgv_lang["mail01_line05"]		= "Als u deze gegevens niet heeft aangevraagd, kunt u dit bericht verwijderen.";
$pgv_lang["mail01_line06"]		= "U krijgt geen e-mailberichten meer van dit systeem, omdat uw gebruikersnaam, zonder verificatie, binnen zeven dagen wordt verwijderd.";

$pgv_lang["mail01_subject"]		= "Uw registratie op #SERVER_NAME#";

$pgv_lang["mail02_line01"]		= "Hallo Beheerder ...";
$pgv_lang["mail02_line02"]		= "Een nieuwe gebruiker vroeg een gebruikersnaam aan op ( #SERVER_NAME# ).";
$pgv_lang["mail02_line03"]		= "Deze gebruiker ontving een e-mail met de voor verificatie noodzakelijke informatie.";
$pgv_lang["mail02_line04"]		= "U krijgt bericht zodra de gebruiker de verificatie heeft uitgevoerd. Daarna kunt u de gebruiker toestemming geven om aan te melden op de site.";

$pgv_lang["mail02_subject"]		= "Er is een verzoek gedaan op ( #SERVER_NAME# ) om aan te melden met uw e-mailadres ( #user_email# ).";

$pgv_lang["hashcode"]			= "Verificatiecode:";
$pgv_lang["thankyou"]			= "Hallo #user_fullname# ...<br />Dank voor uw registratie";
$pgv_lang["pls_note06"]			= "U ontvangt een bevestigingsbericht naar het emailadres ( #user_email# ). Met de gegevens in dit bericht kunt u uw gebruikersnaam activeren. Als dit niet binnen zeven dagen gebeurt, wordt uw aanvraag verwijderd. U kunt dan opnieuw een gebruikersnaam aanvragen. Om aan te melden op deze site heeft u altijd een gebruikersnaam en wachtwoord nodig.";

$pgv_lang["registernew"]		= "Bevestiging nieuwe gebruiker";
$pgv_lang["user_verify"]		= "Verificatie gebruiker";
$pgv_lang["send"]			= "Verzenden";

$pgv_lang["pls_note07"]			= "Type uw gebruikersnaam, wachtwoord en verificatiecode in. Deze heeft u per e-mail ontvangen.";
$pgv_lang["pls_note08"]			= "De gegevens van gebruiker #user_name# zijn gecontroleerd.";

$pgv_lang["mail03_line01"]		= "Hallo Beheerder ...";
$pgv_lang["mail03_line02"]		= "#newuser[username]# ( #newuser[fullname]# ) heeft de registratiegegevens geverifieerd.";
$pgv_lang["mail03_line03"]		= "Klik op de onderstaande link, meld u aan bij uw site en geef de gebruiker toestemming om zich aan te melden.";

$pgv_lang["mail03_subject"]		= "Nieuwe verificatie op #SERVER_NAME#";

$pgv_lang["pls_note09"]			= "U bent herkend als geregistreerde gebruiker.";
$pgv_lang["pls_note10"]			= "De beheerder is geinformeerd.<br /> Zodra hij toestemming heft verleend kunt u met uw gebruikersnaam en wachtwoord aanmelden.";
$pgv_lang["data_incorrect"]		= "Gegevens niet correct!<br />Probeer opnieuw!";
$pgv_lang["user_not_found"]		= "Gebruiker niet gevonden!";

$pgv_lang["lost_pw_reset"]		= "Verzoek om een nieuw wachtwoord";

$pgv_lang["pls_note11"]			= "Uw wachtwoord kwijtraken is voor u lastig. Daarnaast betekent het ook een beveiligingsprobleem. Als het in handen komt van anderen, kunnen deze ongeoorloofde toegang krijgen tot gegevens.<br /><br />Type uw gebruikersnaam en e-mail adres in om uw wachtwoord opnieuw aan te vragen. Gebruik de gebruikersnaam en het e-mailadres dat u eerder op deze site heeft opgegeven. Klik daarna op de #pgv_lang[lost_pw_reset]#-knop.<br /><br />Als de gebruikersnaam en het e-mailadres correct zijn, ontvangt u een e-mailbericht, waarin een link en een code zijn opgenomen. Via de link en het intypen van de code kunt u uw wachtwoord opnieuw instellen. Zorg ervoor, dat het e-mailbericht niet in handen van anderen komt, inclusief de beheerder van deze site (deze zal er niet om vragen).<br /><br />Als u niet meer weet welk e-mailadres u eerder op de site heeft opgegeven, kunt u meerdere e-mailadressen proberen. Onze e-mail met de link en code worden alleen verzonden, wanneer de juiste combinatie van gebruikersnaam en e-mailadres is opgegeven. In geval van problemen kunt u altijd contact opnemen met de beheerder van deze site.";
$pgv_lang["enter_email"]		= "U moet een e-mailadres opgeven.";

$pgv_lang["mail04_line01"]		= "Hallo #user_fullname# ...";
$pgv_lang["mail04_line02"]		= "Voor uw gebruikersnaam is een nieuw wachtwoord aangevraagd!";
$pgv_lang["mail04_line03"]		= "Aanbeveling:";
$pgv_lang["mail04_line04"]		= "Klik op de onderstaande link, meldt u aan met het nieuwe wachtwoord en wijzig het vervolgens.";

$pgv_lang["mail04_subject"]		= "Verzoek om gegevens op #SERVER_NAME#";

$pgv_lang["pwreqinfo"]			= "Hallo....<br /><br />Een nieuw wachtwoord is per e-mail verzonden aan (#user[email]#).<br /><br />Binnen enkele minuten zal deze in uw mailbox worden bezorgd.<br /><br />Aanbeveling:<br /><br />Meldt u na ontvangst van de e-mail met uw gebruikersnaam en nieuwe wachtwoord aan en wijzig daarna uw wachtwoord.";

$pgv_lang["editowndata"]		= "Mijn gegevens";
$pgv_lang["savedata"]			= "Gewijzigde gegevens opslaan";
$pgv_lang["datachanged"]		= "Gebruikersgegevens zijn gewijzigd!";
$pgv_lang["datachanged_name"]		= "Opnieuw aanmelden met nieuwe gebruikersnaam a.u.b.";
$pgv_lang["myuserdata"]			= "Mijn gegevens";
$pgv_lang["verified"]			= "Bevestigd door gebruiker:";
$pgv_lang["verified_by_admin"]		= "Goedgekeurd door Beheerder:";
$pgv_lang["user_theme"]			= "Mijn site-opmaak";
$pgv_lang["mygedview"]			= "MyGedView";
$pgv_lang["passwordlength"]		= "Het wachtwoord moet uit minimaal 6 karakters bestaan.";
$pgv_lang["admin_approved"]		= "Uw aanmelding op #SERVER_NAME# is goedgekeurd";
$pgv_lang["you_may_login"]		= " door de Beheerder. U kunt nu aanloggen op de website door op de onderstaande link te klikken.";


//-- mygedview page
$pgv_lang["welcome"]			= "Welkom";
$pgv_lang["upcoming_events"]		= "Binnenkort.....";
$pgv_lang["chat"]			= "Chatten";
$pgv_lang["users_logged_in"]		= "Aangemelde gebruikers";
$pgv_lang["message"]			= "Stuur bericht";
$pgv_lang["my_messages"]		= "Mijn berichten";
$pgv_lang["date_created"]		= "Datum verzonden:";
$pgv_lang["message_from"]		= "E-mail adres:";
$pgv_lang["message_from_name"]		= "Uw Naam:";
$pgv_lang["message_to"]			= "Bericht aan:";
$pgv_lang["message_subject"]		= "Onderwerp:";
$pgv_lang["message_body"]		= "Inhoud:";
$pgv_lang["no_to_user"]			= "Geen geadresseerde ingevoerd.";
$pgv_lang["provide_email"]		= "Geef het e-mailadres waar wij het antwoord op uw bericht heen kunnen sturen. Als u dit achterwege laat kunnen wij uw vraag niet beantwoorden. Uw e-mailadres wordt uitsluitend gebruikt om uw vraag te beantwoorden.";
$pgv_lang["reply"]			= "Antwoord";
$pgv_lang["message_deleted"]		= "Bericht verwijderd";
$pgv_lang["message_sent"]		= "Bericht verzonden";
$pgv_lang["reset"]			= "Herstel";
$pgv_lang["site_default"]		= "Standaard site";
$pgv_lang["mygedview_desc"]		= "Op uw persoonlijke MyGedView pagina kunt u uw favoriete personen aangeven, kijken naar gebeurtenissen die binnenkort plaatsvinden en samenwerken met andere PHPGedView gebruikers van deze site.";
$pgv_lang["no_messages"]		= "U heeft geen ongelezen boodschappen";
$pgv_lang["clicking_ok"]		= "Als u op OK klikt, wordt een venster geopend om contact op te nemen met";
$pgv_lang["my_favorites"]		= "Mijn favorieten";
$pgv_lang["no_favorites"]		= "U heeft geen favorieten geselecteerd. U kunt een persoon aan uw favorieten toevoegen door de details van de persoon op te zoeken en te klikken op \"Toevoegen aan favorieten\". U kunt ook het ID van de persoon, als u dit kent, in het vak hieronder intypen.";
$pgv_lang["add_to_my_favorites"] 	= "Toevoegen aan mijn favorieten";
$pgv_lang["confirm_fav_remove"]		= "Weet u zeker dat u deze persoon uit uw favorieten wilt verwijderen?";
$pgv_lang["portal"]			= "Portaal";
$pgv_lang["invalid_email"]		= "Voer een geldig e-mailadres in";
$pgv_lang["message_instructions"]	= "<b>Let op:</b>Vertrouwelijke informatie over levende personen wordt alleen verstrekt aan verwanten en andere geautoriseerde personen. Voordat u vertrouwelijke informatie ontvangt, wordt eerst uw relatie met de desbetreffende persoon geverifieerd.<br />Soms is informatie over reeds overleden personen ook vertrouwelijk. Dit kan voorkomen, als er niet voldoende informatie voorhanden is, om vast te stellen of de persoon daadwerkelijk is overleden. Waarschijnlijk is ook niet meer informatie voorhanden over deze persoon.<br /><br />Controleer, voordat u een vraag stelt, aan de hand van data, plaatsen en familieleden, dat het de juiste persoon betreft. Als u genealogische informatie versterkt, vermeldt dan de bronnen waar de informatie vandaan komt.";
$pgv_lang["enter_subject"]		= "Voer onderwerp van het bericht in";
$pgv_lang["enter_body"]			= "Voer tekst in voor het verzenden a.u.b.";
$pgv_lang["confirm_message_delete"]	= "Wilt u dit bericht echt verwijderen? Herstellen is niet mogelijk.";
$pgv_lang["message_email1"]		= "Het volgende bericht is verzonden naar uw PHPGedView-gebruiker:";
$pgv_lang["message_email2"]		= "U zond het volgende bericht naar een PHPGedView-gebruiker:";
$pgv_lang["message_email3"]		= "U zond het volgende bericht naar de PHPGedView beheerder:";
$pgv_lang["viewing_url"]		= "Het bericht is verzonden vanaf de volgende URL:";
$pgv_lang["messaging2_help"]		= "Als u dit bericht verzendt, ontvangt u een kopie op het e-mailadres dat u heeft opgegeven.";
$pgv_lang["random_picture"]		= "Willekeurige afbeelding";

//-- upgrade.php messages
$pgv_lang["upgrade_util"]		= "Upgrade-programma";
$pgv_lang["no_upgrade"]			= "Er zijn geen bestanden om bij te werken.";
$pgv_lang["use_version"]		= "U gebruikt versie:";
$pgv_lang["current_version"]		= "Huidige stabiele versie:";
$pgv_lang["upgrade_download"]		= "Download:";
$pgv_lang["upgrade_tar"]		= "TAR";
$pgv_lang["upgrade_zip"]		= "ZIP";
$pgv_lang["latest"]			= "U heeft de laatste versie van PHPGedView.";
$pgv_lang["location"]			= "Plaats van de upgrade-bestanden:";
$pgv_lang["include"]			= "Toevoegen:";
$pgv_lang["options"]			= "Opties:";
$pgv_lang["inc_phpgedview"]		= "PHPGedView";
$pgv_lang["inc_languages"]		= "Talen";
$pgv_lang["inc_config"]			= "Configuratiebestand";
$pgv_lang["inc_researchlog"]		= "Onderzoekslogboek";
$pgv_lang["inc_index"]			= "Indexbestanden";
$pgv_lang["inc_themes"]			= "Thema's";
$pgv_lang["inc_docs"]			= "Handleidingen";
$pgv_lang["inc_privacy"]		= "Privacybestand(en)";
$pgv_lang["inc_backup"]			= "Maak backup";
$pgv_lang["upgrade_help"]		= "Help mij";
$pgv_lang["cannot_read"]		= "Kan bestand niet lezen:";
$pgv_lang["not_configured"]		= "U heeft PHPGedView nog niet geconfigureerd.";
$pgv_lang["location_upgrade"]		= "Geef de locatie van de upgrade-bestanden.";
$pgv_lang["new_variable"]		= "Nieuwe variabele gevonden:";
$pgv_lang["config_open_error"] 		= "Fout bij het openen van het configuratiebestand.";
$pgv_lang["config_write_error"] 	= "Fout!!! Kan niet schrijven naar het configuratiebestand.";
$pgv_lang["config_update_ok"]		= "Configuratiebestand is bijgewerkt.";
$pgv_lang["config_uptodate"]		= "Uw configuratiebestand is bijgewerkt.";
$pgv_lang["processing"]			= "Bezig.......";
$pgv_lang["privacy_open_error"] 	= "Fout bij het openen van het [#PRIVACY_MODULE#] bestand.";
$pgv_lang["privacy_write_error"] 	= "FOUT!!! Kan niet schrijven naar het [#PRIVACY_MODULE#] bestand.<br />Overtuig u ervan dat de schrijf-bevoegdheden voor dit bestand zijn ingesteld.<br />De bevoegdheden kunnen eventueel weer worden hersteld nadat het privacy bestand is geschreven.";
$pgv_lang["privacy_update_ok"]		= "Privacybestand: [#PRIVACY_MODULE#] is bijgewerkt.";
$pgv_lang["privacy_uptodate"]		= "Uw [#PRIVACY_MODULE#] bestand is bijgewerkt.";
$pgv_lang["heading_privacy"]		= "Privacybestand(en):";
$pgv_lang["heading_phpgedview"]		= "PHPGedView-bestanden";
$pgv_lang["heading_image"]		= "Multimediabestanden:";
$pgv_lang["heading_index"]		= "Indexbestanden:";
$pgv_lang["heading_language"]		= "Taalbestanden:";
$pgv_lang["heading_theme"]		= "Themabestanden:";
$pgv_lang["heading_docs"]		= "Handleidingen:";
$pgv_lang["heading_researchlog"]	= "Bestanden onderzoekslogboek:";
$pgv_lang["heading_researchloglang"]	= "Taalbestanden onderzoekslogboek:";
$pgv_lang["copied_success"]		= "kopieren geslaagd";
$pgv_lang["backup_copied_success"]	= "backup maken geslaagd.";
$pgv_lang["folder_created"]		= "Map gemaakt";
$pgv_lang["process_error"]		= "Er is een probleem met de pagina. Een nieuwere versie kan niet worden gevonden.";

if (file_exists($PGV_BASE_DIRECTORY . "languages/lang.nl.extra.php")) require $PGV_BASE_DIRECTORY . "languages/lang.nl.extra.php";

?>