<?php
/*=================================================
	Project: phpGedView
	File: medialist.php
	Author: John Finlay
	Comments:
		Parses gedcom file and displays a list of the multimedia objects found
		in the file

	Change Log:
		7/9/02 - File Created
		1/8/03 - Fixed bug where PAF exported empty TITL tags
		4/14/03 - Add support for thumbnails

	phpGedView: Genealogy Viewer
    Copyright (C) 2002 to 2003  John Finlay and Others

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
===================================================*/
# $Id: medialist.php,v 1.42.2.2 2004/01/29 15:32:18 yalnifj Exp $

require("config.php");

function mediasort($a, $b) {
	return strnatcasecmp($a["title"], $b["title"]);
}

if (!isset($level)) $level=0;

// -- array of names
$medialist = array();
$foundlist = array();
print_header($pgv_lang["multi_title"]);
print_help_link("multimedia_help", "page_help");
print "\n\t<div align=\"center\"><h2>".$pgv_lang["multi_title"]."</h2></div>\n\t";

get_media_list();

//-- sort the media by title
usort($medialist, "mediasort");

//-- remove all private media objects
$newmedialist = array();
foreach($medialist as $media) {
	print " ";
	$disp = true;
	$links = $media["link"];
	foreach($links as $id=>$type) {
		if ($type=="INDI") {
			$disp = $disp && displayDetailsByID($id);
		}
		else if ($type=="FAM") {
			$parents = find_parents($id);
			$disp = $disp && displayDetailsByID($parents["HUSB"]);
			$disp = $disp && displayDetailsByID($parents["WIFE"]);
		}
		else if ($type=="SOUR") {
			$disp = $disp && showFact("OBJE", $id);
			}
	}
	if ($disp) $newmedialist[] = $media;
}
$medialist = $newmedialist;
$ct = count($medialist);

if (!isset($start)) $start = 0;
if (!isset($max)) $max = 40;
$count = $max;
if ($start+$count > $ct) $count = $ct-$start;
print "\n\t<div align=\"center\">$ct ".$pgv_lang["media_found"]." <br />\n\t<table class=\"list_table\">\n\t\t<tr>\n\t\t";
// -- print the array
for($i=0; $i<$count; $i++) {
	$value = $medialist[$start+$i];
	$imgwidth = 0;
	$imgheight = 0;
    if (file_exists(filename_decode($value["file"]))) {
		$imgsize = getimagesize(filename_decode($value["file"]));
		$imgwidth = $imgsize[0]+50;
		$imgheight = $imgsize[1]+50;
	}
	if ($imgwidth<300) $imgwidth=300;
	if ($imgheight<200) $imgheight=200;
	
	print "\n\t\t\t<td class=\"list_value\" width=\"50%\">";
    print "<table><tr><td valign=\"top\">";
    print "<a href=\"#\" onclick=\"return openImage('".$value["file"]."',$imgwidth, $imgheight);\">";
    if (file_exists(filename_decode($value["thumb"]))) print "<img src=\"".$value["thumb"]."\" border=0 align=left class=\"thumbnail\"></a>";
    print "</td><td class=\"list_value\" style=\"border: none;\">";
    print "<a href=\"#\" onclick=\"return openImage('".$value["file"]."',$imgwidth, $imgheight);\">";
    print "<b>".$value["title"]."</b></a>";
    $links = $value["link"];
    foreach($links as $id=>$type) {
    	if (($type=="INDI")&&(displayDetailsByID($id))) print " <a href=\"individual.php?pid=".$id."\"> <br />".$pgv_lang["view_person"]." -".get_person_name($id)."</a>";
    	if ($type=="FAM") print " <a href=\"family.php?famid=".$id."\"> <br />".$pgv_lang["view_family"]." - ".get_family_descriptor($id)."</a>";
    	if ($type=="SOUR") print " <a href=\"source.php?sid=".$id."\"> <br />".$pgv_lang["view_source"]." - ".get_source_descriptor($id)."</a>";
    }
    $value["file"] = filename_decode($value["file"]);
    if ((!strstr($value["file"], "://"))&&(!strstr($value["file"], "mailto:"))&&(!file_exists($value["file"]))) {
	    print "<br /><font class=\"error\">".$pgv_lang["file_not_found"]." ".$value["file"]."</font>";
    }
    print "<br /><div class=\"indent\">";
    print_fact_notes($value["gedcom"], $value["level"]);
    print "</div>";
    print "</td></tr></table>\n";
    print "</td>";
	if ($i%2 == 1) print "\n\t\t</tr>\n\t\t<tr>";
}
print "\n\t\t</tr>";
if ($ct>$max) {
	print "\n<tr>\n";
	print "<td>";
	if ($start>0) {
		$newstart = $start-$max;
		if ($start<0) $start = 0;
		print "<a href=\"medialist.php?start=$newstart&max=$max\">".$pgv_lang["prev"]."</a>\n";
	}
	print "</td><td align=\"right\">";
	if ($start+$max < $ct) {
		$newstart = $start+$count;
		if ($start<0) $start = 0;
		print "<a href=\"medialist.php?start=$newstart&max=$max\">".$pgv_lang["next"]."</a>\n";
	}
	print "</td></tr>\n";
}
print "</table>";
print "\n</div>\n";
print_footer();

?>