<?php
/***********************************************************
	File: message.php
	Project: phpGedView
	Author: John Finlay
	Posts to: none
	Comments:
		Send a message to a user in the system

	Change Log:
		11/06/32 - File Created (yalnifj)

	phpGedView: Genealogy Viewer
    Copyright (C) 2002 to 2003  John Finlay and Others

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

***********************************************************/
# $Id: message.php,v 1.20 2004/01/12 21:08:35 yalnifj Exp $
require("config.php");
if (!isset($action)) $action="compose";

print_simple_header("Message");

if (!isset($subject)) $subject = "";
if (!isset($url)) $url = "";
if (!isset($method)) $method="messaging2";

if ($action=="compose") {
	print '<font class="subheaders">'.$pgv_lang["message"].'</font>';
	if (empty($to)) {
		print "<font class=\"error\">".$pgv_lang["no_to_user"]."</font><br />";
		print_simple_footer();
		exit;
	}
	$_SESSION["good_to_send"] = true;
	?>
	<script language="JavaScript">
		function validateEmail(email) {
			if (email.value.search("(.*)@(.*)")==-1) {
				alert('<?php print $pgv_lang["invalid_email"]; ?>');
				email.focus();
				return false;
			}
			return checkForm(document.messageform);
		}
		function checkForm(frm) {
			if (frm.subject.value=="") {
				alert('<?php print $pgv_lang["enter_subject"]; ?>');
				document.messageform.subject.focus();
				return false;
			}
			if (frm.body.value=="") {
				alert('<?php print $pgv_lang["enter_body"]; ?>');
				document.messageform.body.focus();
				return false;
			}
			return true;
		}
	</script>
	<?php
	$username = getUserName();
	if (empty($username)) {
		print "<br /><br />".$pgv_lang["message_instructions"];
	}
	print "<br /><form name=\"messageform\" method=\"post\" onsubmit=\"t = new Date(); document.messageform.time.value=t.toUTCString(); ";
	if (empty($username)) print "return validateEmail(document.messageform.from_email);";
	else print "return checkForm(this);";
	print "\">\n";
	print "<input type=\"hidden\" name=\"action\" value=\"send\">\n";
	print "<input type=\"hidden\" name=\"to\" value=\"$to\">\n";
	print "<input type=\"hidden\" name=\"time\" value=\"\">\n";
	print "<input type=\"hidden\" name=\"method\" value=\"$method\">\n";
	print "<input type=\"hidden\" name=\"url\" value=\"$url\">\n";
	if (!empty($username)) print "<input type=\"hidden\" name=\"from\" value=\"$username\">\n";
	else print $pgv_lang["message_from_name"]."<input type=\"text\" name=\"from_name\" size=\"40\"><br />".$pgv_lang["message_from"]."<input type=\"text\" name=\"from_email\" size=\"40\"><br />".$pgv_lang["provide_email"]."<br /><br />\n";
	print $pgv_lang["message_subject"]."<input type=\"text\" name=\"subject\" size=\"50\" value=\"$subject\"><br />\n";
	print $pgv_lang["message_body"]."<br /><textarea name=\"body\" cols=\"50\" rows=\"7\"></textarea><br />\n";
	print "<input type=\"submit\" value=\"".$pgv_lang["send"]."\">\n";
	print "</form>\n";
	if ($method=="messaging2") print $pgv_lang["messaging2_help"];
}
else if (($action=="send")&&(isset($_SESSION["good_to_send"]))&&($_SESSION["good_to_send"]===true)) {
	$_SESSION["good_to_send"] = false;
	if (!empty($from_email)) $from = $from_email;
	$tuser = getUser($from);
	if (!$tuser) {
		$mt = preg_match("/(.+)@(.+)/", $from, $match);
	    if ($mt>0) {
	            $host = trim($match[2]);
	            $ip = gethostbyname($host);
	            if ($ip == $host) {
		            $host = "www.".$host;
		            $ip = gethostbyname($host);
		            if ($ip == $host) {
			            print "<center><br /><font class=\"error\">".$pgv_lang["invalid_email"]."</font>\n";
			            print "<br /><br /><a href=\"#\" onclick=\"history.back();\">".$pgv_lang["back"]."</a><br /></center>";
						print_simple_footer();
						exit;
					}
	            }
	    }
	}
	$message = array();
	$message["to"]=$to;
	$message["from"]=$from;
	if (!empty($from_name)) {
		$message["from_name"] = $from_name;
		$body = $pgv_lang["message_from_name"]." $from_name\r\n".$pgv_lang["message_from"]." $from_email\r\n\r\n".$body;

	}
	$message["subject"] = $subject;
	$url = preg_replace("/".session_name()."=.*/", "", $url);
	if (!empty($url)) $body .= "\r\n\r\n--------------------------------------\r\n\r\n".$pgv_lang["viewing_url"]."\r\n".$SERVER_URL.$url."\r\n";
	$message["body"] = $body;
	$message["created"] = $time;
	$message["method"] = $method;
	if (addMessage($message)) print $pgv_lang["message_sent"];
}
else if ($action=="delete") {
	if (deleteMessage($id)) print $pgv_lang["message_deleted"];
}
print "<center><br /><br /><a href=\"#\" onclick=\"if (window.opener.refreshpage) window.opener.refreshpage(); window.close();\">".$pgv_lang["close_window"]."</a><br /></center>";

print_simple_footer();
?>
