<?php
/*=================================================
	Project: phpGedView
	File: mygedview.php
	Author: John Finlay
	Comments:
		MyGedView page allows a logged in user the abilty
		to keep bookmarks, see a list of upcoming events, etc.

	Change Log:
		11/6/03 - File Created

	phpGedView: Genealogy Viewer
    Copyright (C) 2002 to 2003  John Finlay and Others

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

===================================================*/
# $Id: mygedview.php,v 1.15 2003/12/12 15:54:06 yalnifj Exp $

require("config.php");
require("functions_blocks.php");
require($PGV_BASE_DIRECTORY.$factsfile["english"]);
require($PGV_BASE_DIRECTORY.$factsfile[$LANGUAGE]);

if (isset($_SESSION["usertime"])) $time = $_SESSION["usertime"]+$_SESSION["timediff"];
else $time = time();
if (empty($day)) $day = date("j", $time);
if (empty($month)) $month = date("M", $time);
if (empty($year)) $year = date("Y", $time);

//-- make sure that they have admin status before they can use this page
//-- otherwise have them login again
$uname = getUserName();
if (empty($uname)) {
	header("Location: login.php?url=edituser.php");
	exit;
}
$user = getUser($uname);

//-- add favorites action
if (!isset($action)) $action="";
if (($action=="addfav")&&(!empty($gid))) {
	$indirec = find_person_record($gid);
	if ($indirec) {
		$favorite = array();
		$favorite["username"] = $uname;
		$favorite["gid"] = $gid;
		$favorite["type"] = "INDI";
		$favorite["file"] = $GEDCOM;
		addFavorite($favorite);
	}
}
if (($action=="deletefav")&&(isset($fv_id))) {
	deleteFavorite($fv_id);
}
else if ($action=="deletemessage") {
	deleteMessage($message_id);
}

$blocks = array();
$blocks["main"] = array();
$blocks["right"] = array();
$blocks["main"][] = "print_todays_events";
$blocks["main"][] = "print_user_messages";
$blocks["main"][] = "print_user_favorites";
$blocks["right"][] = "print_welcome_block";
if ($MULTI_MEDIA) $blocks["right"][] = "print_random_media";
$blocks["right"][] = "print_upcoming_events";
$blocks["right"][] = "print_logged_in_users";

print_header($pgv_lang["mygedview"]);
?>
<script language="JavaScript">
	function refreshpage() {
		window.location = 'mygedview.php';
	}
	function printTimeNow() {
		t = new Date();
		document.write(t.toLocaleTimeString());
	}
	function printTime(utc) {
		t = new Date(utc);
		document.write(t.toLocaleTimeString());
	}
</script>
<?php
print "<table border=\"0\" cellspacing=\"5\">\n";
print "<tr><td width=\"75%\" align=\"left\" valign=\"top\">\n";
print "<h1>".$pgv_lang["mygedview"]." ".$pgv_lang["portal"]."</h1>".$pgv_lang["mygedview_desc"]."</td>\n";
print "<td width=\"25%\" align=\"center\" class=\"list_value\">";
	eval($blocks["right"][0]."();");
print "</td></tr>\n";
print "<tr><td width=\"75%\" align=\"left\" valign=\"top\">\n";

//-- start of main content section
print "\t<table width=\"100%\" class=\"list_table\" cellspacing=\"5\">\n";
foreach($blocks["main"] as $block) {
	print "\t\t<tr><td class=\"list_value\">\n";
	eval($block."(false);");
	print "\t\t</td></tr>\n";
}
print "</table>\n";
//-- end of main content section

print "</td><td width=\"25%\" align=\"center\" valign=\"top\">\n";

//-- start of blocks section
print "\t<table class=\"list_table\">\n";
for($i=1; $i<count($blocks["right"]); $i++) {
	$block = $blocks["right"][$i];
	print "\t\t<tr><td class=\"list_value\">\n";
	eval($block."();");
	print "\t\t</td></tr>\n";
}
print "\t</table>\n";
//-- end of blocks section

print "</td></tr>\n";
print "</table>\n";

print_footer();
?>