<?php
/*=================================================
	Project: phpGedView
	File: relationship.php
	Author: John Finlay
	Comments:
		Caclulates the relationship between two individuals in the gedcom

	Change Log:
		6/24/03 - File Created

	phpGedView: Genealogy Viewer
    Copyright (C) 2002 to 2003  John Finlay and Others

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
===================================================*/
# $Id: relationship.php,v 1.28.2.6 2004/02/03 22:13:22 yalnifj Exp $
// -- include config file
require("config.php");
require($PGV_BASE_DIRECTORY.$factsfile["english"]);
require($PGV_BASE_DIRECTORY.$factsfile[$LANGUAGE]);

if (!isset($show_full)) $show_full=$PEDIGREE_FULL_DETAILS;
if (!isset($path_to_find)) {
	$path_to_find = 0;
	unset($_SESSION["relationships"]);
}

if ($show_full==false) {
	$Dbheight=25;
	$Dbwidth-=40;
}

$bwidth = $Dbwidth;
$bheight = $Dbheight;

$title_string = "";
if (!isset($pid1)) $pid1 = "";
if (!isset($pid2)) $pid2 = "";
if (!isset($followspouse)) $followspouse = 0;
if (empty($pid1)) $followspouse = 1;

if (!empty($pid1)) {
	if (preg_match("/[A-Za-z]+/", $pid1)==0) $pid1 = $GEDCOM_ID_PREFIX.$pid1;
	if ((!displayDetailsByID($pid1))&&(!showLivingNameByID($pid1))) $title_string .= $pgv_lang["living"]." ";
	else $title_string .= get_person_name($pid1)." ";
	if (!empty($_SESSION["pid1"]) && ($_SESSION["pid1"]!=$pid1)) {
		unset($_SESSION["relationships"]);
		$path_to_find=0;
	}
}
if (!empty($pid2)) {
	if (preg_match("/[A-Za-z]+/", $pid2)==0) $pid2 = $GEDCOM_ID_PREFIX.$pid2;
	if ((!displayDetailsByID($pid2))&&(!showLivingNameByID($pid2))) $title_string .= $pgv_lang["living"]." ";
	else $title_string .= "- ".get_person_name($pid2)." ";
	if (!empty($_SESSION["pid2"]) && ($_SESSION["pid2"]!=$pid2)) {
		unset($_SESSION["relationships"]);
		$path_to_find=0;
	}
}
$title_string .= $pgv_lang["relationship_chart"];
// -- print html header information
print_header($title_string);
	print_help_link("relationship_help", "page_help");
?>
<script type="text/javascript">
var pasteto;
function open_find(textbox) {
	pasteto = textbox;
	findwin = window.open('findid.php', '', 'left=50,top=50,width=450,height=450,resizable=1,scrollbars=1');
}
function paste_id(value) {
	pasteto.value=value;
}
</script>
<?php
print "\n\t<h2>$title_string</h2>";
// -- print the form to change the number of displayed generations
if ($view!="preview") {
	$Dbaseyoffset += 70;
	print "\n\t<form name=\"people\" method=\"get\" action=\"relationship.php\">\n";
	print "<input type=\"hidden\" name=\"path_to_find\" value=\"$path_to_find\">\n";
	print "\t\t<table><tr><td>\n";
	print "\t\t".$pgv_lang["person1"]."<input type=\"text\" name=\"pid1\" size=\"3\" value=\"$pid1\" /><font size=\"1\"><a href=\"javascript:open_find(document.people.pid1);\">".$pgv_lang["find_id"]."</a></font>";
	print "\n\t\t";
	print_help_link("relationship_id_help", "qm");
	print"  \n\t\t</td><td>\n";
	print "\t\t".$pgv_lang["person2"]."<input type=\"text\" name=\"pid2\" size=\"3\" value=\"$pid2\" /><font size=\"1\"><a href=\"javascript:open_find(document.people.pid2);\">".$pgv_lang["find_id"]."</a></font>";
	print "\n\t\t</td>";
	print "<td rowspan=\"3\" valign=\"top\">\n";
	print "<table><tr><td>\n";
	if (isset($_SESSION["relationships"])) {
		$i=0;
		foreach($_SESSION["relationships"] as $node) {
			print "<a href=\"relationship.php?pid1=$pid1&amp;pid2=$pid2&amp;path_to_find=$i&amp;followspouse=$followspouse&amp;show_full=$show_full\">".$pgv_lang["show_path"]." ".($i+1)."</a><br />\n";
			$i++;
			if ($i%5==0) print "</td><td>";
		}
	}
	print "</td></tr></table>\n";
	print "</td>\n";
	print "</tr>\n";
	print "\t\t<tr><td colspan=\"2\">";
	print "<input type=\"checkbox\" name=\"followspouse\" value=\"1\"";
	if ($followspouse) print " checked=\"checked\"";
	print " />".$pgv_lang["follow_spouse"];
	print_help_link("follow_spouse_help", "qm");
	print "<br />\n";
	print "\n\t\t<input type=\"submit\" value=\"".$pgv_lang["view"]."\" />";
	print "<input type=\"hidden\" name=\"show_full\" value=\"$show_full\" />";
	print "<input type=\"submit\" value=\"";
	if ($show_full) print $pgv_lang["hide_details"];
	else print $pgv_lang["show_details"];
	print "\" onclick=\"document.people.show_full.value='".(!$show_full)."';\" />\n";
	print_help_link("show_full_help", "qm");
	if ((!empty($pid1))&&(!empty($pid2))) print "<input type=\"submit\" value=\"".$pgv_lang["next_path"]."\" onclick=\"document.people.path_to_find.value='".($path_to_find+1)."';\" />\n";
	print "</td></tr></table>";
	print "\n\t\t</form>";
} else {
	$Dbaseyoffset=55;
	$Dbasexoffset=10;
}
$maxyoffset = $Dbaseyoffset;
if ((!empty($pid1))&&(!empty($pid2))) {
	$disp = true;
	if ((!displayDetailsByID($pid1))&&(!showLivingNameByID($pid1))) {
		print_privacy_error($CONTACT_EMAIL);
		$disp = false;
	}
	if ((!displayDetailsByID($pid2))&&(!showLivingNameByID($pid2))) {
		print_privacy_error($CONTACT_EMAIL);
		$disp = false;
	}
	if ($disp) {
		if (isset($_SESSION["relationships"][$path_to_find])) $node = $_SESSION["relationships"][$path_to_find];
		else $node = get_relationship($pid1, $pid2, $followspouse, 0, true, $path_to_find);
		if ($node!==false) {
			$_SESSION["pid1"] = $pid1;
			$_SESSION["pid2"] = $pid2;
			if (!isset($_SESSION["relationships"])) $_SESSION["relationships"] = array();
			$_SESSION["relationships"][$path_to_find] = $node;
			//print_r($node);
			$yoffset = $Dbaseyoffset;
			$xoffset = $Dbasexoffset;
			$maxyoffset = $yoffset;
			foreach($node["path"] as $index=>$pid) {
				$linex = $xoffset;
				$liney = $yoffset;
				$mfstyle = "";
				$indirec = find_person_record($pid);
				$ct = preg_match("/1 SEX F/", $indirec, $smatch);
				if ($ct>0) $mfstyle="F";
				if (($node["relations"][$index]=="father")||($node["relations"][$index]=="mother")) {
					$yoffset += $Dbheight+$Dbyspacing+50;
					$line = $PGV_VLINE_IMG;
					$liney += $Dbheight;
					$linex += $Dbwidth/2;
					$lh = 54;
					$lw = 3;
				}
				if ($node["relations"][$index]=="sibling") {
					if ($mfstyle=="F") $node["relations"][$index]="sister";
					else $node["relations"][$index]="brother";
					$xoffset += $Dbwidth+$Dbxspacing+70;
					$line = $PGV_HLINE_IMG;
					$linex += $Dbwidth;
					$liney += $Dbheight/2;
					$lh = 3;
					$lw = 70;
				}
				if ($node["relations"][$index]=="spouse") {
					if ($mfstyle=="F") $node["relations"][$index]="wife";
					else $node["relations"][$index]="husband";
					$xoffset += $Dbwidth+$Dbxspacing+70;
					$line = $PGV_HLINE_IMG;
					$linex += $Dbwidth;
					$liney += $Dbheight/2;
					$lh = 3;
					$lw = 70;
				}
				if ($node["relations"][$index]=="child") {
					if ($mfstyle=="F") $node["relations"][$index]="daughter";
					else $node["relations"][$index]="son";
					$yoffset += $Dbheight+$Dbyspacing+50;
					$line = $PGV_VLINE_IMG;
					$liney += $Dbheight;
					$linex += $Dbwidth/2;
					$lh = 54;
					$lw = 3;
				}
				if ($yoffset > $maxyoffset) $maxyoffset = $yoffset;
				if ($index>0) {
					print "<div id=\"line$index\" style=\"position:absolute; left:".($linex)."px; top:".$liney."px; z-index:".(100-$index)."; \" align=\"center\"><img src=\"$PGV_IMAGE_DIR/$line\" align=\"left\" width=\"$lw\" height=\"$lh\" alt=\"\" />\n";
					print "<br />";
					print $pgv_lang[$node["relations"][$index]]."\n";
					print "</div>\n";
				}
				print "<div id=\"box$pid\" style=\"position:absolute; left:".$xoffset."px; top:".$yoffset."px; width:".$Dbwidth."px; height:".$Dbheight."px; z-index:".(100-$index)."; \"><table><tr><td colspan=\"2\" width=\"$Dbwidth\" height=\"$Dbheight\">";
				print_pedigree_person($pid);
				print "</td></tr></table></div>\n";
			}
		}
		else print "<font class=\"error\">".$pgv_lang["no_link_found"]."</font><br /><br />";

	}
}

$maxyoffset += 200;
print "\n\t\t<div id=\"footerbox\" style=\"position:absolute; left:0px; top:".$maxyoffset."px; width:100%;  \">";
$without_close=true;
print_footer();
print "\n\t</div>\n</body>\n</html>";


?>
