<?php
/*=================================================
   Project: phpGedView
   File: session.php
   Author: John Finlay
   Comments:
      Startup and session logic

   phpGedView: Genealogy Viewer
    Copyright (C) 2002 to 2004  John Finlay and Others

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
===================================================*/

# $Id: session.php,v 1.147.2.10 2004/02/03 22:13:22 yalnifj Exp $
if (strstr($_SERVER["PHP_SELF"],"session")) {
	print "Now, why would you want to do that.  You're not hacking are you?";
	exit;
}

ini_set('arg_separator.output', '&amp;');
ini_set ('error_reporting', E_ALL);
ini_set('display_errors', '1');

//-- version of phpgedview
$VERSION = "2.65.3";
$VERSION_RELEASE = "final";

$memory_limit = ini_get('memory_limit');
if ($memory_limit < 16) {
	ini_set('memory_limit', '16M');
}

set_magic_quotes_runtime(0);

if (phpversion()<4.1) {
	//-- detect old versions of PHP and display error message
	//-- cannot add this to the language files because the language has not been established yet.
	print "<html>\n<body><b style=\"color: red;\">PhpGedView requires PHP version 4.1.0 or later.</b><br /><br />\nYou are running PHP version ".phpversion().".  Please ask your server host to upgrade your PHP installtion.</body></html>";
	exit;
}

if ((empty($PHP_SELF))&&(!empty($_SERVER["PHP_SELF"]))) $PHP_SELF=$_SERVER["PHP_SELF"];
if (!empty($_SERVER["QUERY_STRING"])) $QUERY_STRING = $_SERVER["QUERY_STRING"];
else $QUERY_STRING="";
$QUERY_STRING = preg_replace(array("/&/","/</"), array("&amp;","&gt;"), $QUERY_STRING);

//-- if not configured then redirect to the configuration script
if (!$CONFIGURED) {
   if ((strstr($PHP_SELF, "admin.php")===false)
   &&(strstr($PHP_SELF, "login.php")===false)
   &&(strstr($PHP_SELF, "editconfig.php")===false)
   &&(strstr($PHP_SELF, "config_download.php")===false)
   &&(strstr($PHP_SELF, "editconfig_help.php")===false)) {
      header("Location: editconfig.php");
      exit;
   }
}
//-- allow user to cancel
ignore_user_abort(false);

//-- check if they are trying to hack
$CONFIG_VARS = array();
$CONFIG_VARS[] = "PGV_BASE_DIRECTORY";
$CONFIG_VARS[] = "PGV_DATABASE";
$CONFIG_VARS[] = "DBHOST";
$CONFIG_VARS[] = "DBUSER";
$CONFIG_VARS[] = "DBPASS";
$CONFIG_VARS[] = "DBNAME";
$CONFIG_VARS[] = "TBLPREFIX";
$CONFIG_VARS[] = "INDEX_DIRECTORY";
$CONFIG_VARS[] = "AUTHENTICATION_MODULE";
$CONFIG_VARS[] = "USE_REGISTRATION_MODULE";
$CONFIG_VARS[] = "ALLOW_USER_THEMES";
$CONFIG_VARS[] = "DEFAULT_GEDCOM";
$CONFIG_VARS[] = "ALLOW_CHANGE_GEDCOM";
$CONFIG_VARS[] = "LOGFILE_CREATE";
$CONFIG_VARS[] = "PGV_SESSION_SAVE_PATH";
$CONFIG_VARS[] = "PGV_SESSION_TIME";
$CONFIG_VARS[] = "GEDCOMS";
$CONFIG_VARS[] = "SERVER_URL";
$CONFIG_VARS[] = "CONFIGURED";

foreach($CONFIG_VARS as $VAR) {
	$incoming = array_keys($_REQUEST);
	if (in_array($VAR, $incoming)) {
		print "Config variable override detected. Possible hacking attempt. Script terminated.\n";
		if ((!ini_get('register_globals'))||(ini_get('register_globals')=="Off")) {
			//--load common functions
			require("functions.php");
			//-- load db specific functions
			require("functions_$PGV_DATABASE.php");
			require($AUTHENTICATION_MODULE);      // -- load the authentication system
			AddToLog("Config variable override detected. Possible hacking attempt. Script terminated.");
		}
		exit;
	}
}

if (empty($SERVER_URL)) $SERVER_URL = "http://".$_SERVER["SERVER_NAME"].dirname($PHP_SELF)."/";

//--load common functions
require($PGV_BASE_DIRECTORY."functions.php");
//-- load db specific functions
require($PGV_BASE_DIRECTORY."functions_$PGV_DATABASE.php");

//-- setup execution timer
$start_time = getmicrotime();

//-- start the php session
// "Sat Jan  4 11:55:15 MST 2003"
$time = time()+$PGV_SESSION_TIME;
$date = date("D M j H:i:s T Y", $time);
session_set_cookie_params($date);
if (($PGV_SESSION_TIME>0)&&(function_exists('session_cache_expire'))) session_cache_expire($PGV_SESSION_TIME/60);
if (!empty($PGV_SESSION_SAVE_PATH)) session_save_path($PGV_SESSION_SAVE_PATH);
session_start();

if (isset($_REQUEST["GEDCOM"])){
   $_REQUEST["GEDCOM"] = trim($_REQUEST["GEDCOM"]);
}
if (empty($_REQUEST["GEDCOM"])) {
   if (isset($_SESSION["GEDCOM"])) $GEDCOM = $_SESSION["GEDCOM"];
   else {
      if ((empty($GEDCOM))||(empty($GEDCOMS[$GEDCOM]))) $GEDCOM=$DEFAULT_GEDCOM;
      if ((empty($GEDCOM))&&(count($GEDCOMS)>0)) {
         $gedkeys = array_keys($GEDCOMS);
         $GEDCOM = $gedkeys[0];
      }
   }
}
else {
	$GEDCOM = $_REQUEST["GEDCOM"];
}
$_SESSION["GEDCOM"] = $GEDCOM;

//-- import the post, get, and cookie variable into the scope on new versions of php
if (phpversion() >= '4.1') @import_request_variables("cgp");

require($PGV_BASE_DIRECTORY."config_gedcom.php");
require(get_config_file());

foreach($_REQUEST as $key=>$value) {
	if (!is_array($value)) {
		if ($PGV_DATABASE!="index") {
			if (preg_match("/((SELECT)|(DELETE)|(INSERT)|(UPDATE)|(ALTER)|(CREATE)|(TABLE)|(DROP)).+((FROM)|(INTO)|(TABLE))/i", $value)>0) {
				print "Possible SQL injection detected: $key=>$value.  Script terminated.";
				require($AUTHENTICATION_MODULE);      // -- load the authentication system
				AddToLog("Possible SQL injection detected: $key=>$value.  Script terminated.");
				exit;
			}
		}
		//-- don't let any html in
		if (!empty($value)) ${$key} = htmlspecialchars($value, ENT_NOQUOTES, "UTF-8");
	}
	else {
		foreach($value as $key1=>$val) {
			if ($PGV_DATABASE!="index") {
				if (preg_match("/((SELECT)|(DELETE)|(INSERT)|(UPDATE)|(ALTER)|(CREATE)|(TABLE)|(DROP)).+((FROM)|(INTO)|(TABLE))/i", $val)>0) {
					print "Possible SQL injection detected: $key.  Script terminated.";
					require($AUTHENTICATION_MODULE);      // -- load the authentication system
					AddToLog("Possible SQL injection detected: $key.  Script terminated.");
					exit;
				}
			}
			//-- don't let any html in
			if (!empty($val)) ${$key}[$key1] = htmlspecialchars($val, ENT_NOQUOTES, "UTF-8");
		}
	}
}

if (empty($PEDIGREE_GENERATIONS)) $PEDIGREE_GENERATIONS = $DEFAULT_PEDIGREE_GENERATIONS;
//-- load file for language settings
if (file_exists($INDEX_DIRECTORY . "lang_settings.php")) require($INDEX_DIRECTORY . "lang_settings.php");
else require($PGV_BASE_DIRECTORY . "lang_settings_std.php");

if (($ENABLE_MULTI_LANGUAGE)&&(empty($_SESSION["CLANGUAGE"]))) {
   # require($PGV_BASE_DIRECTORY.'languages/langcodes.php');
   if (isset($HTTP_ACCEPT_LANGUAGE)) $accept_langs = $HTTP_ACCEPT_LANGUAGE;
   else if (!empty($_SERVER['HTTP_ACCEPT_LANGUAGE'])) $accept_langs = $_SERVER['HTTP_ACCEPT_LANGUAGE'];
   if (isset($accept_langs)) {
      if (strstr($accept_langs, ",")) {
         $langs_array = preg_split("/(,\s*)|(;\s*)/", $accept_langs);
         for ($i=0; $i<count($langs_array); $i++) {
            if (!empty($langcode[$langs_array[$i]])) {
               $LANGUAGE = $langcode[$langs_array[$i]];
               break;
            }
         }
      }
      else {
         if (!empty($langcode[$accept_langs])) $LANGUAGE = $langcode[$accept_langs];
      }
   }
}
$deflang = $LANGUAGE;

require($AUTHENTICATION_MODULE);      // -- load the authentication system
$pgv_username = getUserName();
if (isset($_SESSION['CLANGUAGE'])) $CLANGUAGE = $_SESSION['CLANGUAGE'];
else if (isset($HTTP_SESSION_VARS['CLANGUAGE'])) $CLANGUAGE = $HTTP_SESSION_VARS['CLANGUAGE'];
if (isset($CLANGUAGE)) {
   $LANGUAGE = $CLANGUAGE;
}

if ($ENABLE_MULTI_LANGUAGE) {
   if ((isset($changelanguage))&&($changelanguage=="yes")) {
      if (!empty($NEWLANGUAGE)) $LANGUAGE=$NEWLANGUAGE;
   }
}

# if (file_exists($INDEX_DIRECTORY . "lang_settings.php")) require($INDEX_DIRECTORY . "lang_settings.php");		//-- load file for language settings
# else require($PGV_BASE_DIRECTORY . "lang_settings_std.php");
require($PGV_BASE_DIRECTORY . $pgv_language["english"]);	//-- load english as the default language
if (isset($pgv_language[$LANGUAGE]) && (file_exists($PGV_BASE_DIRECTORY . $pgv_language[$LANGUAGE]))) require($PGV_BASE_DIRECTORY . $pgv_language[$LANGUAGE]);	//-- load language file
require($PGV_BASE_DIRECTORY . "templecodes.php");		//-- load in the LDS temple code translations

require(get_privacy_file());

if (!isset($PHP_SELF)) $PHP_SELF=$_SERVER["PHP_SELF"];

if (empty($TEXT_DIRECTION)) $TEXT_DIRECTION="ltr";
$TEXT_DIRECTION = $TEXT_DIRECTION_array[$LANGUAGE];
$DATE_FORMAT	= $DATE_FORMAT_array[$LANGUAGE];
$WEEK_START	= $WEEK_START_array[$LANGUAGE];
$NAME_REVERSE	= $NAME_REVERSE_array[$LANGUAGE];

$monthtonum = array();
$monthtonum["jan"] = 1;
$monthtonum["feb"] = 2;
$monthtonum["mar"] = 3;
$monthtonum["apr"] = 4;
$monthtonum["may"] = 5;
$monthtonum["jun"] = 6;
$monthtonum["jul"] = 7;
$monthtonum["aug"] = 8;
$monthtonum["sep"] = 9;
$monthtonum["oct"] = 10;
$monthtonum["nov"] = 11;
$monthtonum["dec"] = 12;

if ((strstr($PHP_SELF, "editconfig.php")===false)
   &&(strstr($PHP_SELF, "editconfig_help.php")===false)) {
   if ((!check_db())||(!adminUserExists())) {
      header("Location: editconfig.php");
      exit;
   }

   if ((strstr($PHP_SELF, "editconfig_gedcom.php")===false)
   &&(strstr($PHP_SELF, "editconfig_help.php")===false)
   &&(strstr($PHP_SELF, "editgedcoms.php")===false)
   &&(strstr($PHP_SELF, "uploadgedcom.php")===false)
   &&(strstr($PHP_SELF, "login.php")===false)
   &&(strstr($PHP_SELF, "admin.php")===false)
   &&(strstr($PHP_SELF, "config_download.php")===false)
   &&(strstr($PHP_SELF, "addnewgedcom.php")===false)
   &&(strstr($PHP_SELF, "useradmin.php")===false)) {
   	if ((count($GEDCOMS)==0)||(!check_for_import($GEDCOM))) {
		header("Location: editgedcoms.php");
		exit;
   	}
   }

//-----------------------------------
//-- if user wishes to logout this is where we will do it
if ((!empty($logout))&&($logout==1)) {
	userLogout();
	if ($REQUIRE_AUTHENTICATION) {
		header("Location: ".$HOME_SITE_URL);
		exit;
	}
}

	if ($REQUIRE_AUTHENTICATION) {
		if (empty($pgv_username)) {
			if ((strstr($PHP_SELF, "login.php")===false)
				&&(strstr($PHP_SELF, "mygedview.php")===false)
				&&(strstr($PHP_SELF, "login_register.php")===false)
				&&(strstr($PHP_SELF, "gdbi.php")===false)
				&&(strstr($PHP_SELF, "help_text.php")===false)
				&&(strstr($PHP_SELF, "message.php")===false)) {
				header("Location: mygedview.php");
				exit;
			}
		}
	}

   //-- load the user specific theme
	if (!empty($pgv_username)) {
		$tempuser = getUser($pgv_username);
		$usertheme = $tempuser["theme"];
		if (isset($_POST["user_theme"])) $usertheme = $_POST["user_theme"];
		if (file_exists($usertheme."theme.php")) {
			$THEME_DIR = $usertheme;
			require($usertheme."theme.php");
		}
	}

   if (!isset($change_gedcom)) $change_gedcom="No";
   if ($change_gedcom=='yes') {
      print_header($pgv_lang["choose_gedcom"]);
      print "\n\t<div align=\"center\"><h2>".$pgv_lang["choose_gedcom"]."</h2></div>\n\t<br /><br />";
      print "\n<ul>";
      foreach($GEDCOMS as $ged=>$gedarray) {
         print "\n\t<li><a href=\"index.php?GEDCOM=".$ged."\">".stripslashes($gedarray["title"])."</a></li>";
      }
      print "\n</ul>\n";
      print_footer();
      exit;
   }

   // -- setup session information for tree clippings cart features
   if ($ENABLE_CLIPPINGS_CART) {
      if (isset($_SESSION)) {
         if (!isset($_SESSION['cart'])) {
            $_SESSION['cart'] = array();
         }
         $cart = $_SESSION['cart'];
      }
      else {
         if (!isset($HTTP_SESSION_VARS['cart'])) {
            $HTTP_SESSION_VARS['cart'] = array();
         }
         $cart = $HTTP_SESSION_VARS['cart'];
      }
   }

   if (isset($_SESSION)) {
      $_SESSION['CLANGUAGE'] = $LANGUAGE;
   }
   else {
      $HTTP_SESSION_VARS['CLANGUAGE'] = $LANGUAGE;
   }

   //-- load any editing changes
   if (userCanEdit(getUserName())) {
      if (file_exists($INDEX_DIRECTORY."pgv_changes.php")) require($INDEX_DIRECTORY."pgv_changes.php");
      else $pgv_changes = array();
   }
   else $pgv_changes = array();
}
?>
