<?php
/*=================================================
	Project: phpGedView
	File: xreftorin.php
	Author: John Finlay
	Comments:
		Converts gedcom ids to refns or rins

	phpGedView: Genealogy Viewer
    Copyright (C) 2002 to 2003  John Finlay and Others

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
===================================================*/
# $Id: xreftorin.php,v 1.5 2004/01/11 18:17:12 yalnifj Exp $

require("config.php");

if (empty($ged)) $ged = $GEDCOM;
$GEDCOM = $ged;
require("gdbi_functions.php");

if (empty($tag)) $tag = "RIN";

print_header("Convert XREFs to RIN");
print "\n\t<center><h2>".$pgv_lang["multi_title"]."</h2></center>\n\t";
print "Replacing all xrefs with the value of the $tag field in gedcom $ged.<br /><br />";

//-- find all of the XREFS in the file
$ct = preg_match_all("/0 @(.*)@ INDI/", $fcontents, $match, PREG_SET_ORDER);
for($i=0; $i<$ct; $i++) {
	$xref = trim($match[$i][1]);
	$indirec = find_record_in_file($xref);
	if ($indirec!==false) {
		print "Found record $i - $xref: ";
		$rt = preg_match("/1 $tag (.*)/", $indirec, $rmatch);
		if ($rt>0) {
			$rin = trim($rmatch[1]);
			$fcontents = preg_replace("/@$xref@/", "@$rin@", $fcontents);
			print "successfully set to $rin<br />\n";
		}
		else print "<font class=\"error\">No $tag found in record<br /></font>\n";
	}
}

write_file();
print "<p>Conversion complete.</p>\n";

print_footer();
?>