<?php
/*=================================================
	Project: phpGedView
	File: admin.php
	Author: John Finlay
	Comments:
		Administrative User Interface.

	phpGedView: Genealogy Viewer
    Copyright (C) 2002 to 2003  John Finlay and Others

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

===================================================*/
# $Id: admin.php,v 1.31.2.6 2004/02/04 20:17:32 yalnifj Exp $

require "config.php";
if (!userIsAdmin(getUserName())) {
	header("Location: login.php?url=admin.php");
	exit;
}

require $PGV_BASE_DIRECTORY . $confighelpfile["english"];
if (file_exists($PGV_BASE_DIRECTORY . $confighelpfile[$LANGUAGE])) require $PGV_BASE_DIRECTORY . $confighelpfile[$LANGUAGE];

if (!isset($action)) $action="";
if ($action=="phpinfo") {
	phpinfo();
	exit;
}

print_header($pgv_lang["administration"]);

$d_pgv_changes = "";
if (count($pgv_changes) > 0) $d_pgv_changes = "<a href=\"gdbi_changes.php\">" . $pgv_lang["accept_changes"] . "</a>\n";
$d_php_info = "<a href=\"admin.php?action=phpinfo\">" . $pgv_lang["show_phpinfo"] . "</a>";

if (!isset($logfilename)) $logfilename = "";
$file_nr = 0;
$dir_var = opendir ($INDEX_DIRECTORY);
while ($file = readdir ($dir_var))
{
  if (strpos($file, ".log") > 0){$dir_array[$file_nr] = $file; $file_nr++;}
}
closedir($dir_var);

$d_logfile_str  = "<form action=\"admin.php\" method=\"post\">";
$d_logfile_str .= $pgv_lang["view_logs"] . ": ";
$d_logfile_str .= "\n<select name=\"logfilename\">\n";
$ct = count($dir_array);
for($x = 0; $x < $file_nr; $x++)

{
  $ct--;
  $d_logfile_str .= "<option value=\"";
  $d_logfile_str .= $dir_array[$ct];
  if ($dir_array[$x] == $logfilename) $d_logfile_str .= "\" selected=\"selected";
  $d_logfile_str .= "\">";
  $d_logfile_str .= $dir_array[$ct];
  $d_logfile_str .= "</option>\n";
}
$d_logfile_str .= "</select>\n";
$d_logfile_str .= "<input type=\"submit\" name=\"logfile\" value=\" > \">";
$d_logfile_str .= "</form>";

$usermanual_filename = "docs/english/PGV-manual-en.html";
$d_LangName = "lang_name_" . "english";
$doc_lang = $pgv_lang[$d_LangName];
$new_usermanual_filename = "docs/" . $languages[$LANGUAGE] . "/PGV-manual-" . $language_settings[$LANGUAGE]["lang_short_cut"] . ".html";
if (file_exists($new_usermanual_filename)){$usermanual_filename = $new_usermanual_filename; $d_LangName = "lang_name_" . $languages[$LANGUAGE]; $doc_lang = $pgv_lang[$d_LangName];}

?>
<div class="center"><!--center-->
  <table class="facts_table, <?php print $TEXT_DIRECTION ?>">
    <tr>
      <td colspan="2" class="facts_label03"><?php print "<h2>PhpGedView v" . $VERSION . " " . $VERSION_RELEASE . "<br />" . $pgv_lang["administration"]. "</h2>".$pgv_lang["system_time"]." ".get_changed_date(date("j M Y")).date(" g:i:sa"); ?></td>
    </tr>
    <tr>
      <td colspan="2" class="facts_value" style="text-align:center; "><?php print $pgv_lang["select_an_option"]; ?></td>
    </tr>
    <tr>
      <td colspan="2">&nbsp;</td>
    </tr>
    <tr>
      <td class="facts_value"><li style="line-height: 20pt;"><a href="readme.txt"><?php print $pgv_lang["readme_documentation"];?></a></li></td>
      <td class="facts_value"><li style="line-height: 20pt;"><a href="editlang.php"><?php print $pgv_lang["edit_langdiff"];?></a></li></td>
    </tr>
    <tr>
      <td class="facts_value"><li style="line-height: 20pt;"><a href="<?php print $usermanual_filename;?>" target="manual"><?php print $pgv_lang["user_manual"] . " (" . $doc_lang . ")";?></a></li></td>
	  <td class="facts_value"><li style="line-height: 20pt;"><a href="upgrade.php"><?php print $pgv_lang["upgrade"];?></a></li></td>
    </tr>
    <tr>
      <td class="facts_value"><li style="line-height: 20pt;"><a href="editconfig.php"><?php print $pgv_lang["configuration"];?></a></li></td>
      <td class="facts_value"><li style="line-height: 20pt;"><?php
      if ($d_pgv_changes != "")print $d_pgv_changes; else print $d_php_info;
      ?></li></td>
    </tr>
    <tr>
      <td class="facts_value"><li style="line-height: 20pt;"><a href="editgedcoms.php"><?php print $pgv_lang["manage_gedcoms"];?></a></li></td>
      <td class="facts_value"><li style="line-height: 20pt;"><?php
      if ($d_pgv_changes != "")print $d_php_info; else print $d_logfile_str;
      ?></li></td>
    </tr>
    <tr>
      <td class="facts_value"><li style="line-height: 20pt;"><a href="uploadmedia.php"><?php print $pgv_lang["upload_media"];?></a></li></td>
      <td class="facts_value">&nbsp;</td>
    </tr>
    <tr>
      <td class="facts_value"><li style="line-height: 20pt;"><a href="useradmin.php"><?php print $pgv_lang["user_admin"];?></a></li></td>
      <td class="facts_value">&nbsp;</td>
   </tr>
  </table>
<!--/center--></div>

<?php
  if (isset($logfilename) and ($logfilename != ""))
  {
    print "<hr><table align=\"center\" width=\"70%\"><tr><td style=\"line-height: 20pt; COLOR: #555555; font-family: Arial, sans-serif;\">";
    print "<strong>Content of log-file [" . $INDEX_DIRECTORY . $logfilename . "]</strong><br /><br />";
    $lines=file($INDEX_DIRECTORY . $logfilename);
    $num = sizeof($lines); for ($i = 0; $i < $num ; $i++)
    {
      print $lines[$i] . "<br>";
    }
    print "</td></tr></table><hr>";
  }
?>
<br /><br />
<?php
print_footer();
?>

