<?php
/*=================================================
	Project: phpGedView
	File: dateconvert.php
	Author: John Finlay
	Comments:
		Converts gedcom ids to refns or rins

	phpGedView: Genealogy Viewer
    Copyright (C) 2002 to 2003  John Finlay and Others

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
===================================================*/
# $Id: dateconvert.php,v 1.3 2004/01/11 18:17:12 yalnifj Exp $

require("config.php");

if (empty($ged)) $ged = $GEDCOM;
$GEDCOM = $ged;
require("gdbi_functions.php");

print_header("Convert Dates");
print "\n\t<center><h2>Convert Dates</h2></center>\n\t";
print "Replacing all dates of the format YYYY-MM-DD with the correct date format DD MMM YYYY in gedcom $ged.<br /><br />";

$ct = preg_match_all("/(\d\d\d\d)-(\d\d)-(\d\d)/", $fcontents, $match, PREG_SET_ORDER);
print $ct." dates found";
$fcontents = preg_replace("/(\d\d\d\d)-(01)-(\d\d)/", "$3 JAN $1", $fcontents);
$fcontents = preg_replace("/(\d\d\d\d)-(02)-(\d\d)/", "$3 FEB $1", $fcontents);
$fcontents = preg_replace("/(\d\d\d\d)-(03)-(\d\d)/", "$3 MAR $1", $fcontents);
$fcontents = preg_replace("/(\d\d\d\d)-(04)-(\d\d)/", "$3 APR $1", $fcontents);
$fcontents = preg_replace("/(\d\d\d\d)-(05)-(\d\d)/", "$3 MAY $1", $fcontents);
$fcontents = preg_replace("/(\d\d\d\d)-(06)-(\d\d)/", "$3 JUN $1", $fcontents);
$fcontents = preg_replace("/(\d\d\d\d)-(07)-(\d\d)/", "$3 JUL $1", $fcontents);
$fcontents = preg_replace("/(\d\d\d\d)-(08)-(\d\d)/", "$3 AUG $1", $fcontents);
$fcontents = preg_replace("/(\d\d\d\d)-(09)-(\d\d)/", "$3 SEP $1", $fcontents);
$fcontents = preg_replace("/(\d\d\d\d)-(10)-(\d\d)/", "$3 OCT $1", $fcontents);
$fcontents = preg_replace("/(\d\d\d\d)-(11)-(\d\d)/", "$3 NOV $1", $fcontents);
$fcontents = preg_replace("/(\d\d\d\d)-(12)-(\d\d)/", "$3 DEC $1", $fcontents);
//print $fcontents;
write_file();
print "<p>Conversion complete.</p>\n";

print_footer();
?>