<?php
/*=================================================
	Project: phpGedView
	File: downloadgedcom.php
	Author: John Finlay
	Comments:
		Allow an admin user to download the entire gedcom
		file.

	phpGedView: Genealogy Viewer
    Copyright (C) 2002 to 2003  John Finlay and Others

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
    
===================================================*/
# $Id: downloadgedcom.php,v 1.14 2004/01/05 19:41:38 yalnifj Exp $

require "config.php";

if ((!userIsAdmin(getUserName()))||(empty($ged))) {
	header("Location: admin.php");
	exit;
}
if (!isset($action)) $action="";
if ($action=="download") {
	$encoding = $CHARACTER_SET;
	if (($encoding=="UTF-8")&&($convert=="yes")) $encoding="ISO-8859-1";
	
	header("Content-Type: text/plain; charset=$CHARACTER_SET");
	header("Content-Disposition: attachment; filename=$ged; size=".filesize($GEDCOMS[$GEDCOM]["path"]));
	$GEDCOM = $ged;
	$indilist = get_indi_list();
	$famlist = get_fam_list();
	$sourcelist = get_source_list();
	$otherlist = get_other_list();
	
	$head = "0 HEAD\r\n1 SOUR PhpGedView\r\n2 NAME PhpGedView Online Genealogy Viewer\r\n2 VERS $VERSION $VERSION_RELEASE\r\n1 DEST DISKETTE\r\n1 DATE ".date("j M Y")."\r\n";
	$head .= "1 GEDC\r\n2 VERS 5.5\r\n2 FORM LINEAGE-LINKED\r\n1 CHAR $encoding\r\n";
	if ($convert=="yes") {
		$head = preg_replace("/UTF-8/", "ANSI", $head);
		$head = utf8_decode($head);
	}
	print $head;
	foreach($indilist as $indi) {
		$rec = trim($indi["gedcom"])."\r\n";
		if ($convert=="yes") $rec = utf8_decode($rec);
		print $rec;
	}
	foreach($famlist as $fam) {
		$rec = trim($fam["gedcom"])."\r\n";
		if ($convert=="yes") $rec = utf8_decode($rec);
		print $rec;
	}
	foreach($sourcelist as $source) {
		$rec = trim($source["gedcom"])."\r\n";
		if ($convert=="yes") $rec = utf8_decode($rec);
		print $rec;
	}
	foreach($otherlist as $key=>$other) {
		if (($key!="HEAD")&&($key!="TRLR")) {
			$rec = trim($other["gedcom"])."\r\n";
			if ($convert=="yes") $rec = utf8_decode($rec);
			print $rec;
		}
	}
	print "0 TRLR\r\n";
}
else {
	print_header("Download Gedcom");
	?>
	<center>
	<h2><?php print $pgv_lang["download_gedcom"]; ?></h2>
	<br />
	<form name="convertform" method="post">
		<input type="hidden" name="action" value="download">
		<input type="hidden" name="convert" value="no">
		<?php print $pgv_lang["utf8_to_ansi"]; ?><br />
		<input type="submit" value="<?php print $pgv_lang["yes"]; ?>" onclick="document.convertform.convert.value='yes';"?> <input type="submit" value="<?php print $pgv_lang["no"]; ?>">
	</form>
	<?php
	print_footer();
}
?>