<?php
/*=================================================
   Project:	phpGedView
   File:	editlang_edit_settings.php
   Author:	Kurt Norgaz, John Finlay
   Comments:	File to edit the language settings of PHPGedView
   Change Log:	2004/01/03 - File Created

   phpGedView:	Genealogy Viewer
   		Copyright (C) 2002 to 2004  John Finlay and Others

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

===================================================*/
# $Id: editlang_edit_settings.php,v 1.10.2.4 2004/02/03 22:13:22 yalnifj Exp $

require "config.php";
require $PGV_BASE_DIRECTORY . $confighelpfile["english"];
if (file_exists($PGV_BASE_DIRECTORY . $confighelpfile[$LANGUAGE])) require $PGV_BASE_DIRECTORY . $confighelpfile[$LANGUAGE];

//-- make sure that they have admin status before they can use this page
//-- otherwise have them login again
$uname = getUserName();
if (empty($uname)) {
	print "Please close this window and do a Login in the former window first...";
	exit;
}

if (!isset($ln)) $ln = "";
if (!isset($action)) $action = "";

$d_LangName = "lang_name_" . $ln;

print_simple_header($pgv_lang["config_lang_utility"]);

print "<script language=\"javascript\">";
  print "self.focus();";
print "</script>\n";

# print "<div align=\"center\"><center>";
print "<div class=\"center\"><center>";
if ($action != "save")
{
  print "<table class=\"facts_table\">";
    print "<tr>";
      print "<td class=\"facts_label03\">" . $pgv_lang["config_lang_utility"] . "</td>";
    print "</tr>";
    print "<tr>";
      print "<td class=\"facts_value\" style=\"text-align:center; \">" . $pgv_lang[$d_LangName] . "</td>";
    print "</tr>";
  print "</table>";

  print "<script language=\"JavaScript\">\n";
  print "var helpWin;\n";
  print "function helpPopup(which) {\n";
  print "if ((!helpWin)||(helpWin.closed)) helpWin = window.open('editconfig_help.php?help='+which,'','left=50,top=50,width=400,height=320,resizable=1,scrollbars=1');\n";
  print "else helpWin.location = 'editconfig_help.php?help='+which;\n";
  print "return false;\n";
  print "}\n";
  print "</script>\n";

  print "<script language=\"javascript\">\n";
  print "<!--\n";
  print "function CheckFileSelect() {\n";
  print "if (document.Form1.v_u_lang_filename.value != \"\"){\n";
  print "document.Form1.v_lang_filename.value = document.Form1.v_u_lang_filename.value;\n";
  print "}\n";
  print "}\n";
  print "// -->\n";
  print "</script>\n";

  print "<form name=\"Form1\" method=\"post\" action=\"" .$PHP_SELF. "\">";
    print "<input type=\"hidden\" name=\"action\" value=\"save\">";
    print "<input type=\"hidden\" name=\"ln\" value=\"" . $ln . "\">";

    print "<table class=\"facts_table\">";

      print "<tr>";
        print "<td class=\"facts_label\" >";
          print $pgv_lang["active"];
          print " <a href=\"#\" onclick=\"return helpPopup('active_help'); \"><b style=\"color: red; \">?</b></a>";
        print "</td>";
        print "<td class=\"facts_value\" style=\"text-align:left; \" >";
          print "<select size=\"1\" name=\"v_lang_use\">";
            print "<option";
              if (!$pgv_lang_use[$ln]) print " selected=\"selected\"";
              print " value=\"";
              print "0";
              print "\">";
              print $pgv_lang["no"];
            print "</option>";
            print "<option";
            if ($pgv_lang_use[$ln]) print " selected=\"selected\"";
            print " value=\"";
            print "1";
            print "\">";
            print $pgv_lang["yes"];
          print "</option>";
          print "</select>";
        print "</td>";
      print "</tr>";

      print "<tr>";
        print "<td class=\"facts_label\" >";
          print str_replace("#D_LANGNAME#", $pgv_lang[$d_LangName], $pgv_lang["original_lang_name"]);
          # str_replace("#D_LANGNAME#", $pgv_lang[$d_LangName], $pgv_lang["original_lang_name"])
          print " <a href=\"#\" onclick=\"return helpPopup('original_lang_name_help'); \"><b style=\"color: red; \">?</b></a>";
        print "</td>";
        print "<td class=\"facts_value\" style=\"text-align:left; \">";
          print "<input type=\"text\" name=\"v_original_lang_name\" size=\"30\" value=\"" . $pgv_lang[$ln] . "\">";
        print "</td>";
      print "</tr>";

      print "<tr>";
        print "<td class=\"facts_label\" >";
          print $pgv_lang["lang_shortcut"];
          print " <a href=\"#\" onclick=\"return helpPopup('lang_shortcut_help'); \"><b style=\"color: red; \">?</b></a>";
        print "</td>";
        print "<td class=\"facts_value\" style=\"text-align:left; \" >";
          print "<input type=\"text\" name=\"v_lang_shortcut\" size=\"2\" value=\"" . $lang_short_cut[$ln] . "\">";
        print "</td>";
      print "</tr>";

      print "<tr>";
        print "<td class=\"facts_label\" >";
          print $pgv_lang["lang_shortcut"];
          print " <a href=\"#\" onclick=\"return helpPopup('lang_shortcut_help'); \"><b style=\"color: red; \">?</b></a>";
        print "</td>";
        print "<td class=\"facts_value\" style=\"text-align:left; \" >";
          print "<input type=\"text\" name=\"v_lang_langcode\" size=\"70\" value=\"" . $lang_langcode[$ln] . "\">";
        print "</td>";
      print "</tr>";

      print "<tr>";
        print "<td class=\"facts_label\" >";
          print $pgv_lang["date_format"];
          print " <a href=\"#\" onclick=\"return helpPopup('date_format_help'); \"><b style=\"color: red; \">?</b></a>";
        print "</td>";
        print "<td class=\"facts_value\" style=\"text-align:left; \" >";
          print "<input type=\"text\" name=\"v_date_format\" size=\"30\" value=\"" . $DATE_FORMAT_array[$ln] . "\">";
        print "</td>";
      print "</tr>";

      print "<tr>";
        print "<td class=\"facts_label\" >";
          print $pgv_lang["week_start"];
          print " <a href=\"#\" onclick=\"return helpPopup('week_start_help'); \"><b style=\"color: red; \">?</b></a>";
        print "</td>";
        print "<td class=\"facts_value\" style=\"text-align:left; \" >";

          print "<select size=\"1\" name=\"v_week_start\">";
            $dayArray = array($pgv_lang["sunday"],$pgv_lang["monday"],$pgv_lang["tuesday"],$pgv_lang["wednesday"],$pgv_lang["thursday"],$pgv_lang["friday"],$pgv_lang["saturday"]);

            for ($x = 0; $x <= 6; $x++)
            {
            print "<option";
              if ($WEEK_START_array[$ln] == $x) print " selected=\"selected\"";
              print " value=\"";
              print $x;
              print "\">";
              print $dayArray[$x];
            print "</option>";
            }
          print "</select>";

        print "</td>";
      print "</tr>";

      print "<tr>";
        print "<td class=\"facts_label\" >";
          print $pgv_lang["text_direction"];
          print " <a href=\"#\" onclick=\"return helpPopup('text_direction_help'); \"><b style=\"color: red; \">?</b></a>";
        print "</td>";
        print "<td class=\"facts_value\" style=\"text-align:left; \" >";
          print "<select size=\"1\" name=\"v_text_direction\">";
            print "<option";
              if ($TEXT_DIRECTION_array[$ln] == "ltr") print " selected=\"selected\"";
              print " value=\"";
              print "0";
              print "\">";
              print $pgv_lang["ltr"];
            print "</option>";
            print "<option";
              if ($TEXT_DIRECTION_array[$ln] == "rtl") print " selected=\"selected\"";
            print " value=\"";
            print "1";
            print "\">";
            print $pgv_lang["rtl"];
          print "</option>";
          print "</select>";
        print "</td>";
      print "</tr>";

      print "<tr>";
        print "<td class=\"facts_label\" >";
          print $pgv_lang["name_reverse"];
          print " <a href=\"#\" onclick=\"return helpPopup('name_reverse_help'); \"><b style=\"color: red; \">?</b></a>";
        print "</td>";
        print "<td class=\"facts_value\" style=\"text-align:left; \" >";
          print "<select size=\"1\" name=\"v_name_reverse\">";
            print "<option";
              if (!$NAME_REVERSE_array[$ln]) print " selected=\"selected\"";
              print " value=\"";
              print "0";
              print "\">";
              print $pgv_lang["no"];
            print "</option>";
            print "<option";
            if ($NAME_REVERSE_array[$ln]) print " selected=\"selected\"";
            print " value=\"";
            print "1";
            print "\">";
            print $pgv_lang["yes"];
          print "</option>";
          print "</select>";
        print "</td>";
      print "</tr>";

      print "<tr>";
        print "<td class=\"facts_label\" >";
          print $pgv_lang["alphabet_upper"];
          print " <a href=\"#\" onclick=\"return helpPopup('alphabet_upper_help'); \"><b style=\"color: red; \">?</b></a>";
        print "</td>";
        print "<td class=\"facts_value\" style=\"text-align:left; \" >";
          print "<input type=\"text\" name=\"v_alphabet_upper\" size=\"50\" value=\"" . $ALPHABET_upper[$ln] . "\">";
        print "</td>";
      print "</tr>";

      print "<tr>";
        print "<td class=\"facts_label\" >";
          print $pgv_lang["alphabet_lower"];
          print " <a href=\"#\" onclick=\"return helpPopup('alphabet_lower_help'); \"><b style=\"color: red; \">?</b></a>";
        print "</td>";
        print "<td class=\"facts_value\" style=\"text-align:left; \" >";
          print "<input type=\"text\" name=\"v_alphabet_lower\" size=\"50\" value=\"" . $ALPHABET_lower[$ln] . "\">";
        print "</td>";
      print "</tr>";

      print "<tr>";
        print "<td class=\"facts_label\" >";
          print $pgv_lang["lang_filename"];
          print " <a href=\"#\" onclick=\"return helpPopup('lang_filename_help'); \"><b style=\"color: red; \">?</b></a>";
        print "</td>";
        print "<td class=\"facts_value\" style=\"text-align:left; \" >";
          if ($action != "addnew")
          {
            print $pgv_language[$ln];
            if (!file_exists($pgv_language[$ln])) print " <b class=\"error\">" . $pgv_lang["file_does_not_exist"] . "</b>";
          }
          else
          {
            print "<input type=\"text\" name=\"v_lang_filename\" size=\"30\" value=\"" . $pgv_language[$ln] . "\">";
            if (!file_exists($pgv_language[$ln])) print "<b class=\"error\">" . $pgv_lang["file_does_not_exist"] . "</b>";
            print "<br /><input onChange=\"CheckFileSelect(); return true;\" type=\"file\" name=\"v_u_lang_filename\" size=\"30\" >";
          }
        print "</td>";
      print "</tr>";

      print "<tr>";
        print "<td class=\"facts_label\" >";
          print $pgv_lang["config_filename"];
          print " <a href=\"#\" onclick=\"return helpPopup('config_filename_help'); \"><b style=\"color: red; \">?</b></a>";
        print "</td>";
        print "<td class=\"facts_value\" style=\"text-align:left; \" >";
          if ($action != "addnew")
          {
            print $confighelpfile[$ln];
            if (!file_exists($confighelpfile[$ln])) print " <b class=\"error\">" . $pgv_lang["file_does_not_exist"] . "</b>";
          }
          else
          {
            print "<input type=\"text\" name=\"v_config_filename\" size=\"30\" value=\"" . $confighelpfile[$ln] . "\"> ";
            if (!file_exists($confighelpfile[$ln])) print "<b class=\"error\">" . $pgv_lang["file_does_not_exist"] . "</b>";
            print "<br /><input type=\"file\" name=\"v_u_config_filename\" size=\"30\" >";
          }
        print "</td>";
      print "</tr>";

      print "<tr>";
        print "<td class=\"facts_label\" >";
          print $pgv_lang["facts_filename"];
          print " <a href=\"#\" onclick=\"return helpPopup('facts_filename_help'); \"><b style=\"color: red; \">?</b></a>";
        print "</td>";
        print "<td class=\"facts_value\" style=\"text-align:left; \" >";
          if ($action != "addnew")
          {
            print $factsfile[$ln];
            if (!file_exists($factsfile[$ln])) print " <b class=\"error\">" . $pgv_lang["file_does_not_exist"] . "</b>";
          }
          else
          {
            print "<input type=\"text\" name=\"v_factsfile\" size=\"30\" value=\"" . $factsfile[$ln] . "\"> ";
            if (!file_exists($factsfile[$ln])) print "<b class=\"error\">" . $pgv_lang["file_does_not_exist"] . "</b>";
            print "<br /><input type=\"file\" name=\"v_u_factsfile\" size=\"30\" >";
          }
        print "</td>";
      print "</tr>";
      
      //-- added by John for context help popup files
      print "<tr>";
        print "<td class=\"facts_label\" >";
          print $pgv_lang["help_filename"];
          print " <a href=\"#\" onclick=\"return helpPopup('help_filename_help'); \"><b style=\"color: red; \">?</b></a>";
        print "</td>";
        print "<td class=\"facts_value\" style=\"text-align:left; \" >";
          if ($action != "addnew")
          {
            print $helptextfile[$ln];
            if (!file_exists($helptextfile[$ln])) print " <b class=\"error\">" . $pgv_lang["file_does_not_exist"] . "</b>";
          }
          else
          {
            print "<input type=\"text\" name=\"v_helpfile\" size=\"30\" value=\"" . $helptextfile[$ln] . "\"> ";
            if (!file_exists($helptextfile[$ln])) print "<b class=\"error\">" . $pgv_lang["file_does_not_exist"] . "</b>";
            print "<br /><input type=\"file\" name=\"v_u_helpfile\" size=\"30\" >";
          }
        print "</td>";
      print "</tr>";
      //-- end added by John

      print "<tr>";
        print "<td class=\"facts_label\" >";
          print $pgv_lang["flagsfile"];
          print " <a href=\"#\" onclick=\"return helpPopup('flagsfile_help'); \"><b style=\"color: red; \">?</b></a>";
        print "</td>";
        print "<td class=\"facts_value\" style=\"text-align:left; \" >";
          if ($action != "addnew")
          {
            print $flagsfile[$ln];
            if (file_exists($flagsfile[$ln])) print " <img src=\"".$flagsfile[$ln]."\" alt=\"\" class=\"flag\" />";
            else if ($flagsfile[$ln] != "") print " <b class=\"error\">" . $pgv_lang["file_does_not_exist"] . "</b>";
          }
          else
          {
            print "<input type=\"text\" name=\"v_flagsfile\" size=\"30\" value=\"" . $flagsfile[$ln] . "\"> ";
            if (file_exists($flagsfile[$ln])) print "<img src=\"".$flagsfile[$ln]."\" alt=\"\" class=\"flag\" />";
            else if ($flagsfile[$ln] != "") print "<b class=\"error\">" . $pgv_lang["file_does_not_exist"] . "</b>";
            print "<br /><input type=\"file\" name=\"v_u_flagsfile\" size=\"30\" >";
          }
        print "</td>";
      print "</tr>";

    print "</table>";

    print "<br />";

    print "<table class=\"facts_table\">";
      print "<tr>";
        print "<td class=\"facts_value\" style=\"text-align:center; \" >";
          print "<input type=\"submit\" value=\"" . $pgv_lang["lang_save"] . "\">";
          print "&nbsp;&nbsp;";
          print "<input type=\"submit\" value=\"" . $pgv_lang["cancel"] . "\"" . " onClick=\"self.close()\">";
        print "</td>";
      print "</tr>";
    print "</table>";
  print "</form>";
}

if ($action == "save")
{
  if (!isset($_POST)) $_POST = $HTTP_POST_VARS;
/*
foreach ($_POST as $key => $value){print "-".$key."-";print "".$value."-<br>";}

-$_POST["v_u_lang_filename"] # --
-$_POST["v_u_config_filename"] # --
-$_POST["v_u_factsfile"] # --
-$_POST["v_u_flagsfile"] # --
*/
  $pgv_lang_use[$ln]	= $_POST["v_lang_use"];
  $pgv_lang[$ln]	= $_POST["v_original_lang_name"];
  $lang_short_cut[$ln]	= $_POST["v_lang_shortcut"];
  $lang_langcode[$ln]	= $_POST["v_lang_langcode"];
  # $pgv_language[$ln]	= $_POST["v_lang_filename"];
  # $confighelpfile[$ln]	= $_POST["v_config_filename"];
  # $flagsfile[$ln]	= $_POST["v_flagsfile"];
  # $factsfile[$ln]	= $_POST["v_factsfile"];
  $ALPHABET_upper[$ln]	= $_POST["v_alphabet_upper"];
  $ALPHABET_lower[$ln]	= $_POST["v_alphabet_lower"];
  $DATE_FORMAT_array[$ln]	= $_POST["v_date_format"];
  $WEEK_START_array[$ln]	= $_POST["v_week_start"];
  $TEXT_DIRECTION_array[$ln]	= $_POST["v_text_direction"];
  $NAME_REVERSE_array[$ln]	= $_POST["v_name_reverse"];

  $Filename = $INDEX_DIRECTORY . "lang_settings.php";
  # print $Filename; exit;
  if (!file_exists($Filename)) @copy("lang_settings_std.php", $Filename);

  if ($file_array = file($Filename))
  {
    @copy($Filename, $Filename . ".old");

    # if ($fp = @fopen($Filename . ".txt", "w"))
    if ($fp = @fopen($Filename, "w"))
    {
      for ($x = 0; $x < count($file_array); $x++)
      {
      	fwrite($fp, $file_array[$x]);
      	$dDummy00 = trim($file_array[$x]);
      	if ($dDummy00 == "//-- NEVER manually delete or edit this entry and every line below this entry! --START--//") break;
      }

      fwrite($fp, "\r\n");
      fwrite($fp, "// Array definition of language_settings\r\n");
      fwrite($fp, "\$language_settings = array();\r\n");

      foreach ($language_settings as $key => $value)
      {
      	fwrite($fp, "\r\n");
      	fwrite($fp, "//-- settings for " . $languages[$key] . "\r\n");
      	fwrite($fp, "\$lang = array();\r\n");
      	fwrite($fp, "\$lang[\"pgv_langname\"]		= \"" . $languages[$key] . "\";\r\n");
      	fwrite($fp, "\$lang[\"pgv_lang_use\"]		= ");
      	if ($pgv_lang_use[$key]) fwrite($fp, "true"); else fwrite($fp, "false");
      	fwrite($fp, ";\r\n");
      	fwrite($fp, "\$lang[\"pgv_lang\"]		= \"" . $pgv_lang[$key] . "\";\r\n");
      	fwrite($fp, "\$lang[\"lang_short_cut\"]		= \"" . $lang_short_cut[$key] . "\";\r\n");
      	fwrite($fp, "\$lang[\"langcode\"]		= \"" . $lang_langcode[$key] . "\";\r\n");
      	fwrite($fp, "\$lang[\"pgv_language\"]		= \"" . $pgv_language[$key] . "\";\r\n");
      	fwrite($fp, "\$lang[\"confighelpfile\"]		= \"" . $confighelpfile[$key] . "\";\r\n");
      	fwrite($fp, "\$lang[\"helptextfile\"]		= \"" . $helptextfile[$key] . "\";\r\n");
      	fwrite($fp, "\$lang[\"flagsfile\"]		= \"" . $flagsfile[$key] . "\";\r\n");
      	fwrite($fp, "\$lang[\"factsfile\"]		= \"" . $factsfile[$key] . "\";\r\n");
      	fwrite($fp, "\$lang[\"DATE_FORMAT\"]		= \"" . $DATE_FORMAT_array[$key] . "\";\r\n");
      	fwrite($fp, "\$lang[\"WEEK_START\"]		= \"" . $WEEK_START_array[$key] . "\";\r\n");
      	fwrite($fp, "\$lang[\"TEXT_DIRECTION\"]		= \"" . $TEXT_DIRECTION_array[$key] . "\";\r\n");
      	fwrite($fp, "\$lang[\"NAME_REVERSE\"]		= ");
      	if ($NAME_REVERSE_array[$key]) fwrite($fp, "true"); else fwrite($fp, "false");
      	fwrite($fp, ";\r\n");
      	fwrite($fp, "\$lang[\"ALPHABET_upper\"]		= \"" . $ALPHABET_upper[$key] . "\";\r\n");
      	fwrite($fp, "\$lang[\"ALPHABET_lower\"]		= \"" . $ALPHABET_lower[$key] . "\";\r\n");
      	fwrite($fp, "\$language_settings[\"" . $languages[$key] . "\"]	= \$lang;\r\n");
      }

      $end_found = false;
      for ($x = 0; $x < count($file_array); $x++)
      {
      	$dDummy00 = trim($file_array[$x]);
      	if ($dDummy00 == "//-- NEVER manually delete or edit this entry and every line above this entry! --END--//"){fwrite($fp, "\r\n"); $end_found = true;}
      	if ($end_found) fwrite($fp, $file_array[$x]);
      }

      fclose($fp);

      print "<table class=\"facts_table\">";
        print "<tr>";
          print "<td class=\"facts_value\" style=\"text-align:center; \" >";
            print str_replace("#PGV_LANG#", $pgv_lang[$d_LangName], $pgv_lang["lang_save_success"]);
          print "</td>";
        print "</tr>";
      print "</table>";
    }
    else print "<center class=\"error\">" . $pgv_lang["lang_config_write_error"] . "</center><br /><br />";
  }
  else print "<font class=\"error\">" . $pgv_lang["lang_set_file_read_error"] . "</font><br /><br />";

  print "<form name=\"Form2\" method=\"post\" action=\"" .$PHP_SELF. "\">";
    print "<table class=\"facts_table\">";
      print "<tr>";
          print "<td class=\"facts_value\" style=\"text-align:center; \" >";
          print "<input type=\"submit\" value=\"" . $pgv_lang["close_window"] . "\"" . " onClick=\"window.opener.showchanges(); self.close();\">";
        print "</td>";
      print "</tr>";
    print "</table>";
  print "</form>";
}

print "</center></div>";

print_simple_footer();

?>
